(ns fogus.thneed.config
  "A dead simple config reader for Clojure supporting multiple formats and locations."
  (:require [clojure.java.io :as io]))

(defmulti -read-impl (fn [frmt & _] frmt))

(defmethod -read-impl :default
  [_ rdr]
  (read (java.io.PushbackReader. rdr)))

(defn read-config
  "Usage:

      (config-reader \"/path/to/cfg.json\" :as :json)
  "
  [file _ format & args]
  (with-open [rdr (apply io/reader file args)]
    (-read-impl format rdr)))

