
(ns fogus.thneed.parallel)

(defmacro as-futures [[a args] & body]
  (let [parts	        (partition-by #{'=>} body)
        [acts & as]     (partition-by #{:as} (first parts))
        res             (check-as-clause as)  
        [_ _ task]	parts]
    `(let [~res (for [~a ~args] (future ~@acts))]
       ~@task)))

(defmacro with-promises [[n tasks _ as] & body]
  (when as
    `(let [tasks# ~tasks
           n# (count tasks#)
           promises# (take n# (repeatedly promise))]
       (doseq [i# (range n#)]
         (dothreads
          (fn []
            (deliver (nth promises# i#)
                     ((nth tasks# i#))))))
       (let [~n tasks#
             ~as promises#]
         ~@body))))

