(ns fogus.thneed.functional)

(defn foldr
  [f acc [h & t :as coll]]
  (if (seq coll)
    (f h (foldr f acc t))
    acc))

(defn iota [t nxt stop y]
  (take-while stop (iterate #(t (nxt %)) y)))

(iota identity inc #(< % 10) 1)

(def upto (fn [end start]
            (iota identity inc #(< % end) start)))

(def downto (fn [end start]
              (iota identity dec #(> % end) start)))

(upto 10 1)
(downto 10 20)

(defn to [start end]
  (if (<= start end)
    (upto end start)
    (downto end start)))

(to 10 20)
(to 20 10)
(to 5 -5)


(defn ffold [fns v]
  (reduce #(%2 %) v fns))

(ffold [#(* 2 %) - /] 3)

