(ns thneed.combinators)

(defn kwargify
  "Takes a function that expects a map and returns a function that
   accepts keyword arguments on its behalf."
  [f]
  (fn [& kwargs]
    (f (apply hash-map kwargs))))

(comment
  (defrecord R [a b])

  (map->R {:a 42})

  (def *->R (kwargify map->R))

  (*->R :a 108 :b 9 :c 99)

  (*->R :a 108)
  (*->R)
)
