(ns fogus.thneed.lein)

(defn parse-project-form
  "Parses a project.clj file and returns a map in the following form

       {:name
        :version
        :dependencies
        :dev-dependencies
        etc...}
  by merging into the name and version information the rest of the defproject
  forms (`:dependencies`, etc)"
  [[_ project-name version-number & attributes]]
  (merge {:name (str project-name)
          :version version-number}
         (apply hash-map attributes)))

(defn parse-project-file
  "Parses a project file -- './project.clj' by default -- and returns a map
   assembled according to the logic in parse-project-form."
  ([] (parse-project-file "./project.clj"))
  ([path]
     (try
       (let [rdr (clojure.lang.LineNumberingPushbackReader.
                  (java.io.FileReader.
                   (java.io.File. path)))]
         (parse-project-form (read rdr)))
       (catch Exception e
         (throw (Exception.
                 (str
                  "There was a problem reading the project definition from "
                  path)))))))