(ns leiningen.new.fmn
  "A Leiningen template for a web apps project, that uses:
   http-kit
   ring
   monger
   juggler
   compojure
   liberator."
  (:use [leiningen.new.templates :only [renderer
                                        name-to-path
                                        ->files
                                        sanitize-ns]]))

(def ^{:const true}
  project-ver "0.1.0")

(def render (renderer "fmn"))

(defn fmn
  "A Leiningen template for a web apps project, that uses:
   http-kit
   ring
   monger
   juggler
   compojure
   liberator."
  [name]
  (let [fq-name (str "fmn/" name)
        data {:name name
              :fq-name fq-name
              :project-version project-ver
              :clojure-version "1.5.1"
              :clojure-data-json-version "0.2.4"
              :http-kit-version "2.1.16"
              :compojure-version "1.1.6"
              :juggler-version "0.2.3"
              :ring-version "1.2.1"
              :ring-json-version "0.3.0"
              :monger-version "1.7.0"
              :clojurescript-version "0.0-2202"
              :lein-cljsbuild-version "1.0.3"
              :liberator-version "0.11.0"
              :midje-version "1.5.1"
              :midi-version "0.1.0"
              :clj-source-path "src/clj"
              :cljs-source-path "src/cljs"
              :cljs-output "resources/js/core.js"
              :cljs-dev-output "resources/js/core-dev.js"
              :file-path (name-to-path fq-name)
              :sanitized-ns (sanitize-ns fq-name)}]
    (->files data
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render ".gitignore" data)]
             ["README.md" (render "README.md" data)]
             ["src/clj/{{fq-name}}/core.clj" (render "core.clj" data)]
             ["resources/index.html" (render "index.html" data)]
             ["src/clj/{{fq-name}}/routes.clj" (render "routes.clj" data)]
             ["src/cljs/{{fq-name}}/core.cljs"])))
