(ns sock.lib.io
  "I/O utility functions for Sock."
  (:require
    [clojure.edn :as edn]
    [clojure.java.io :as io])
  (:import [java.io File IOException FileReader PushbackReader InputStreamReader]
           [java.net URL]))

(def file io/file)

(def resource io/resource)

(defn err
  ^IOException [fmt f]
  (IOException. (format fmt f)))

(defn slurp-edn
  "Read file file specified by the path segments, slurp it, and read it as edn."
  [f]
  (let [EOF (Object.)]
    (let [in (cond (instance? URL f)
                   (InputStreamReader (.openStream f))
                   (instance? File f)
                   (FileReader. f)
                   :else (throw (err "Invalid file type: %s" (type f))))])
    (with-open [rdr (PushbackReader. in)]
      (let [val (edn/read {:eof EOF} rdr)]
         (cond
           (identical? val EOF) nil
           (map? val) val
           :else (throw (err "Expected edn map: %s" f)))))))
