(ns sock.task.plumbing.deps
  "Sock plumbing for dependencies"
  {:boot/export-tasks true}
  (:require
    [boot.core :as boot :refer [deftask]]
    [boot.pod :as pod]
    [boot.util :as util]
    [boot.task.built-in :as built-in]))
    ;[boot.lein :as boot-lein]


(def ^:dynamic
  *pod-env*
  "The deps pod env. It can be changed dynamically before the first task call
   if necessary."
  {:name "deps-pod"
   :dependencies '[[org.clojure/clojure "1.9.0"]
                   [org.clojure/tools.deps.alpha "0.2.190"] ;; TODO upgrade to <= 0.5.342
                   [boot/core "2.7.2"]
                   [flybot/sock "0.2.0-SNAPSHOT"]
                   [com.maitria/packthread "0.1.7"]]})

(defn make-pod
  []
  (let [pod-env (merge (boot/get-env) *pod-env*)]
    (util/dbug* "deps pod env %s\n" (util/pp-str pod-env))
    (future (pod/make-pod *pod-env*))))

(deftask deps
  "Use tools.deps to read and resolve the specified deps.edn files.

  The dependencies read in are added to your Boot :dependencies vector.

  With the exception of -A, and -v, the arguments are intended to match
  the clj script usage (as passed to clojure.tools.deps.alpha.makecp/-main).
  Note, in particular, that -c / --config-paths is assumed to be the COMPLETE
  list of EDN files to read (and therefore overrides the default set of
  system deps and local deps)."
  [c config-paths    PATH [str] "the list of deps.edn files to read"
   A aliases           KW [kw]  "the list of aliases (for both -C and -R)"
   C classpath-aliases KW [kw]  "the list of classpath aliases to use"
   R resolve-aliases   KW [kw]  "the list of resolve aliases to use"
   v verbose              bool  "Be verbose (and ask tools.deps to be verbose too)"]
  (let [deps-pod (make-pod)
        opts {:config-paths config-paths
              :classpath-aliases (into (vec aliases) classpath-aliases)
              :resolve-aliases (into (vec aliases) resolve-aliases)
              :verbose verbose}]
     (boot/with-pass-thru fs
       (let [env-map (pod/with-call-in @deps-pod (sock.pod.deps/resolve ~opts))]
         (boot/merge-env! env-map)))))

(deftask conflicts
  "Print graph of dependency conflicts."
  []
  (built-in/show :pedantic true))
