(ns sock.pod.deps
  (:require
    [sock.lib.io :as io]
    [clojure.tools.deps.alpha :as deps]
    [clojure.tools.deps.alpha.makecp :as util]
    [clojure.tools.deps.alpha.reader :as reader]
    [packthread.core :refer :all]
    [clojure.string :as str]))

(defn- libs->boot-deps
  "Turn tools.deps resolved dependencies (libs) into Boot-style dependencies,
   one step at a time."
  [boot-deps artifact info]
  (if-let [version (:mvn/version info)]
    (conj boot-deps
          (transduce cat conj [artifact version]
                     (select-keys info [:scope :exclusions])))
    boot-deps))

(defn- read-default-deps
  "Read our sock-default-deps.edn file."
  []
  (io/slurp-edn (io/resource "sock-default-deps.edn")))

(defn resolve
  "TODO"
  [{:keys [config-paths classpath-aliases resolve-aliases verbose]}]
  (let [deps-paths   (if (seq config-paths) config-paths ["deps.edn"])
        deps-files   (into [] (comp (map io/file) (filter #(.exists %))) deps-paths)
        deps-map     (reader/read-deps deps-files)
        has-paths?   (:paths deps-map)
        deps-map'    (merge-with merge
                                 (cond-> (if (seq config-paths)
                                           {}
                                           (read-default-deps))
                                         has-paths? (dissoc :paths))
                                 (cond-> deps-map
                                         (not has-paths?) (dissoc :paths)))
        resolve-args (cond-> (#'util/resolve-deps-aliases deps-map'
                               (str/join (map str resolve-aliases)))
                             verbose (assoc :verbose true))
        cp-args      (#'util/resolve-cp-aliases deps-map'
                       (str/join (map str classpath-aliases)))
        libs         (deps/resolve-deps deps-map' resolve-args)
        boot-deps    (reduce-kv libs->boot-deps [] libs)]
    (+> {:dependencies boot-deps}
        (when-let [paths (not-empty (:paths deps-map'))]
          (assoc :resource-paths (set paths)))
        (when-let [paths (or (not-empty (:extra-paths cp-args))
                             (not-empty (:extra-paths deps-map')))]
          (assoc :source-paths (set paths))))))