(ns sock.task.porcelain.clj
  "Sock porcelain boot tasks for Clojure"
  {:boot/export-tasks true}
  (:require
    [boot.core :refer [deftask]]
    [boot.task.built-in :as boot-built-in]
    [sock.task.plumbing.core :refer [testing]]
    [sock.task.plumbing.deps :refer [deps]]
    [sock.task.plumbing.clj :refer [clj]]))

(deftask build
  "Resolve dependencies, create project pom.xml file and build a jar file."
  []
  (comp (deps)
        (boot-built-in/pom)
        (boot-built-in/jar)))

(deftask local
  "Build then install project jar file to local Maven repository."
  []
  (comp (build)
        (boot-built-in/install)))

(deftask snapshot
  "Build then deploy project jar file to company snapshots repository."
  []
  (comp (build)
        (boot-built-in/push :repo "company-snapshots")))

(deftask release
  "Build then deploy project jar file to company releases repository."
  []
  (comp (build)
        (boot-built-in/push :repo "company-releases")))
