(ns sock.lib.project-edn
  (:require
    [boot.core :as core]
    [boot.util :as util]
    [boot.task.built-in :as built-in]
    [sock.lib.io :as io]))

(defn obtain
  []
  (io/slurp-edn (io/file "project.edn")))

(defn pom-options!
  "Set pom task options from project.edn"
  [project-edn]
  (util/dbug* "Setting these pom options: %s\n" (util/pp-str project-edn))
  (core/task-options! built-in/pom project-edn))
