(ns sock.init
  "The sock core API."
  {:boot/export-tasks true}
  (:require
    [sock.lib.deps-edn :as deps-edn]
    [sock.lib.project-edn :as project-edn]))

;; Initialize on ns load
(let [aliases [:ci :dev :test :integration]
      deps-edn (deps-edn/obtain)
      project-edn (project-edn/obtain)]
  (deps-edn/repositories! deps-edn)
  (deps-edn/paths! deps-edn aliases)
  (deps-edn/dependencies! deps-edn aliases)
  (project-edn/pom-options! project-edn))