(ns sock.init
  "The sock core API."
  {:boot/export-tasks true}
  (:require
    [sock.lib.deps-edn :as deps-edn]
    [sock.lib.project-edn :as project-edn]))

;; Initialize on ns load
(let [aliases [:ci :dev :test :integration]]
  (-> (deps-edn/obtain)
      (deps-edn/repositories!)
      (deps-edn/paths! aliases)
      (deps-edn/dependencies! aliases))
  (-> (project-edn/obtain)
      (project-edn/pom-options!)))