(ns sock.init
  "The sock core API."
  {:boot/export-tasks true}
  (:require
    [boot.core :as core]
    [boot.util :as util]
    [boot.task.built-in :as built-in]
    [sock.lib.io :as io]
    [sock.lib.deps-edn :as deps-edn]))

(defn- repositories!
  "Read repositories from deps.edn and merge into the boot environment."
  [deps-edn]
  (let [wagons '[[s3-wagon-private "1.2.0"]]
        repositories (deps-edn/->repositories deps-edn)]
    (util/dbug* "Adding these wagons: %s\n" (util/pp-str wagons))
    (util/dbug* "Adding these repositories: %s\n" (util/pp-str repositories))
    (core/merge-env! :wagons wagons)
    (core/merge-env! :repositories repositories)))

(defn- pom-options!
  "Set pom task options from project.edn"
  []
  (let [project (io/slurp-edn (io/file "project.edn"))]
    (util/dbug* "Setting these pom options: %s\n" (util/pp-str project))
    (core/task-options! built-in/pom project)))

(defn- dependencies!
  "Set boot dependencies"
  [deps-edn aliases]
  (let [deps(deps-edn/->deps deps-edn aliases)
        dependencies (deps-edn/->dependencies deps)
        paths (deps-edn/->paths deps-edn aliases)]
    (core/merge-env! :resource-paths paths)
    (core/merge-env! :source-paths paths)
    (core/set-env! :dependencies dependencies)))

; Initialize on ns load
(let [deps-edn (deps-edn/obtain)]
  (pom-options!)
  (repositories! deps-edn)
  (dependencies! deps-edn [:ci :dev :test :integration]))
