(ns sock.task.porcelain.java
  "Sock porcelain boot tasks for Java"
  {:boot/export-tasks true}
  (:require
    [boot.core :refer [deftask]]
    [boot.task.built-in :as boot-built-in]
    [sock.task.plumbing.core :refer [testing]]
    [sock.task.plumbing.deps :refer [deps]]
    [sock.task.plumbing.java :refer [junit]]))

(deftask build
  ""
  []
  (comp (deps)
        (boot-built-in/javac)
        (boot-built-in/pom)
        (boot-built-in/jar)))

;;; This prevents a name collision WARNING between the test task and
;;; clojure.core/test, a function that nobody really uses or cares
;;; about.
(ns-unmap 'boot.user 'test)
(ns-unmap 'sock.task.porcelain.java 'test)

(deftask test
  ""
  []
  (comp (testing)
        (boot-built-in/javac)
        (junit)))

(deftask local
  ""
  []
  (comp (build)
        (boot-built-in/install)))

(deftask snapshot
  ""
  []
  (comp (build)
        (boot-built-in/push :repo "company-snapshots")))

(deftask release
  ""
  []
  (comp (build)
        (boot-built-in/push :repo "company-releases")))


