(ns sock.task.porcelain.java
  "Sock porcelain boot tasks for Java"
  {:boot/export-tasks true}
  (:require
    [boot.core :refer [deftask]]
    [boot.task.built-in :as boot-built-in]
    [sock.task.plumbing.core :refer [testing]]
    [sock.task.plumbing.deps :refer [deps]]
    [sock.task.plumbing.java :refer [junit]]))

(deftask build
  ""
  []
  (comp (deps)
        (boot-built-in/javac)
        (boot-built-in/pom)
        (boot-built-in/jar)))

(deftask install
  ""
  []
  (comp (build)
        (boot-built-in/install)))

;;; This prevents a name collision WARNING between the test task and
;;; clojure.core/test, a function that nobody really uses or cares
;;; about.
(ns-unmap 'sock.task.porcelain.java 'test)

(deftask test
  ""
  []
  (comp (testing)
        (boot-built-in/javac)
        (junit)))

(deftask snapshot
  ""
  []
  (comp (build)
        (push :repo "company-snapshots")))

(deftask release
  ""
  []
  (comp (build)
        (push :repo "company-releases")))


