;; Copyright (c) 2018 Flybot Pte Ltd, Singapore.
;;
;; This file is distributed under the Eclipse Public License, the same as
;; Clojure.
;;
;; This file incorporates alandipert.kahn from
;; https://gist.github.com/alandipert/1263783 covered by the following copyright
;; and permission notice:
;;
;;     Copyright (c) Alan Dipert. All rights reserved.
;;
;;     The use and distribution terms for this software are covered by the
;;     Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;;     By using this software in any fashion, you are agreeing to be bound by
;;     the terms of this license.
;;     You must not remove this notice, or any other, from this software.
(ns flybot.kahn
  (:require
    [clojure.set :refer [union intersection]]
    [flybot.kahn.core :refer [without take-1 no-incoming normalize]])
  (:refer-clojure :exclude [sort]))

(defn sort
  "Proposes a topological sort for directed graph g using Kahn's
   algorithm, where g is a map of nodes to sets of nodes. If g is
   cyclic, returns nil."
  ([g]
   (sort (normalize g) [] (no-incoming g)))
  ([g l s]
   (if (empty? s)
     (when (every? empty? (vals g)) l)
     (let [[n s'] (take-1 s)
           m  (g n)
           g' (reduce #(update-in % [n] without %2) g m)]
       (recur g' (conj l n) (union s' (intersection (no-incoming g') m)))))))