// Compiled by ClojureScript 1.10.520 {:static-fns false, :optimize-constants false}
goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__27778){
var map__27779 = p__27778;
var map__27779__$1 = (((((!((map__27779 == null))))?(((((map__27779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27779.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27779):map__27779);
var m = map__27779__$1;
var n = cljs.core.get.call(null,map__27779__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__27779__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return [(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__27781_27813 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__27782_27814 = null;
var count__27783_27815 = (0);
var i__27784_27816 = (0);
while(true){
if((i__27784_27816 < count__27783_27815)){
var f_27817 = cljs.core._nth.call(null,chunk__27782_27814,i__27784_27816);
cljs.core.println.call(null,"  ",f_27817);


var G__27818 = seq__27781_27813;
var G__27819 = chunk__27782_27814;
var G__27820 = count__27783_27815;
var G__27821 = (i__27784_27816 + (1));
seq__27781_27813 = G__27818;
chunk__27782_27814 = G__27819;
count__27783_27815 = G__27820;
i__27784_27816 = G__27821;
continue;
} else {
var temp__5735__auto___27822 = cljs.core.seq.call(null,seq__27781_27813);
if(temp__5735__auto___27822){
var seq__27781_27823__$1 = temp__5735__auto___27822;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27781_27823__$1)){
var c__4550__auto___27824 = cljs.core.chunk_first.call(null,seq__27781_27823__$1);
var G__27825 = cljs.core.chunk_rest.call(null,seq__27781_27823__$1);
var G__27826 = c__4550__auto___27824;
var G__27827 = cljs.core.count.call(null,c__4550__auto___27824);
var G__27828 = (0);
seq__27781_27813 = G__27825;
chunk__27782_27814 = G__27826;
count__27783_27815 = G__27827;
i__27784_27816 = G__27828;
continue;
} else {
var f_27829 = cljs.core.first.call(null,seq__27781_27823__$1);
cljs.core.println.call(null,"  ",f_27829);


var G__27830 = cljs.core.next.call(null,seq__27781_27823__$1);
var G__27831 = null;
var G__27832 = (0);
var G__27833 = (0);
seq__27781_27813 = G__27830;
chunk__27782_27814 = G__27831;
count__27783_27815 = G__27832;
i__27784_27816 = G__27833;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_27834 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_27834);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_27834)))?cljs.core.second.call(null,arglists_27834):arglists_27834));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__27785_27835 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__27786_27836 = null;
var count__27787_27837 = (0);
var i__27788_27838 = (0);
while(true){
if((i__27788_27838 < count__27787_27837)){
var vec__27799_27839 = cljs.core._nth.call(null,chunk__27786_27836,i__27788_27838);
var name_27840 = cljs.core.nth.call(null,vec__27799_27839,(0),null);
var map__27802_27841 = cljs.core.nth.call(null,vec__27799_27839,(1),null);
var map__27802_27842__$1 = (((((!((map__27802_27841 == null))))?(((((map__27802_27841.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27802_27841.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27802_27841):map__27802_27841);
var doc_27843 = cljs.core.get.call(null,map__27802_27842__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_27844 = cljs.core.get.call(null,map__27802_27842__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_27840);

cljs.core.println.call(null," ",arglists_27844);

if(cljs.core.truth_(doc_27843)){
cljs.core.println.call(null," ",doc_27843);
} else {
}


var G__27845 = seq__27785_27835;
var G__27846 = chunk__27786_27836;
var G__27847 = count__27787_27837;
var G__27848 = (i__27788_27838 + (1));
seq__27785_27835 = G__27845;
chunk__27786_27836 = G__27846;
count__27787_27837 = G__27847;
i__27788_27838 = G__27848;
continue;
} else {
var temp__5735__auto___27849 = cljs.core.seq.call(null,seq__27785_27835);
if(temp__5735__auto___27849){
var seq__27785_27850__$1 = temp__5735__auto___27849;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27785_27850__$1)){
var c__4550__auto___27851 = cljs.core.chunk_first.call(null,seq__27785_27850__$1);
var G__27852 = cljs.core.chunk_rest.call(null,seq__27785_27850__$1);
var G__27853 = c__4550__auto___27851;
var G__27854 = cljs.core.count.call(null,c__4550__auto___27851);
var G__27855 = (0);
seq__27785_27835 = G__27852;
chunk__27786_27836 = G__27853;
count__27787_27837 = G__27854;
i__27788_27838 = G__27855;
continue;
} else {
var vec__27804_27856 = cljs.core.first.call(null,seq__27785_27850__$1);
var name_27857 = cljs.core.nth.call(null,vec__27804_27856,(0),null);
var map__27807_27858 = cljs.core.nth.call(null,vec__27804_27856,(1),null);
var map__27807_27859__$1 = (((((!((map__27807_27858 == null))))?(((((map__27807_27858.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27807_27858.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27807_27858):map__27807_27858);
var doc_27860 = cljs.core.get.call(null,map__27807_27859__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_27861 = cljs.core.get.call(null,map__27807_27859__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_27857);

cljs.core.println.call(null," ",arglists_27861);

if(cljs.core.truth_(doc_27860)){
cljs.core.println.call(null," ",doc_27860);
} else {
}


var G__27862 = cljs.core.next.call(null,seq__27785_27850__$1);
var G__27863 = null;
var G__27864 = (0);
var G__27865 = (0);
seq__27785_27835 = G__27862;
chunk__27786_27836 = G__27863;
count__27787_27837 = G__27864;
i__27788_27838 = G__27865;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5735__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5735__auto__)){
var fnspec = temp__5735__auto__;
cljs.core.print.call(null,"Spec");

var seq__27809 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__27810 = null;
var count__27811 = (0);
var i__27812 = (0);
while(true){
if((i__27812 < count__27811)){
var role = cljs.core._nth.call(null,chunk__27810,i__27812);
var temp__5735__auto___27866__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5735__auto___27866__$1)){
var spec_27867 = temp__5735__auto___27866__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_27867));
} else {
}


var G__27868 = seq__27809;
var G__27869 = chunk__27810;
var G__27870 = count__27811;
var G__27871 = (i__27812 + (1));
seq__27809 = G__27868;
chunk__27810 = G__27869;
count__27811 = G__27870;
i__27812 = G__27871;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__27809);
if(temp__5735__auto____$1){
var seq__27809__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27809__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__27809__$1);
var G__27872 = cljs.core.chunk_rest.call(null,seq__27809__$1);
var G__27873 = c__4550__auto__;
var G__27874 = cljs.core.count.call(null,c__4550__auto__);
var G__27875 = (0);
seq__27809 = G__27872;
chunk__27810 = G__27873;
count__27811 = G__27874;
i__27812 = G__27875;
continue;
} else {
var role = cljs.core.first.call(null,seq__27809__$1);
var temp__5735__auto___27876__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5735__auto___27876__$2)){
var spec_27877 = temp__5735__auto___27876__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_27877));
} else {
}


var G__27878 = cljs.core.next.call(null,seq__27809__$1);
var G__27879 = null;
var G__27880 = (0);
var G__27881 = (0);
seq__27809 = G__27878;
chunk__27810 = G__27879;
count__27811 = G__27880;
i__27812 = G__27881;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof EvalError))?new cljs.core.Symbol("js","EvalError","js/EvalError",1793498501,null):(((t instanceof RangeError))?new cljs.core.Symbol("js","RangeError","js/RangeError",1703848089,null):(((t instanceof ReferenceError))?new cljs.core.Symbol("js","ReferenceError","js/ReferenceError",-198403224,null):(((t instanceof SyntaxError))?new cljs.core.Symbol("js","SyntaxError","js/SyntaxError",-1527651665,null):(((t instanceof URIError))?new cljs.core.Symbol("js","URIError","js/URIError",505061350,null):(((t instanceof Error))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):null
)))))))], null),(function (){var temp__5735__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5735__auto__)){
var msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5735__auto__)){
var ed = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__27882 = cljs.core.conj.call(null,via,t);
var G__27883 = cljs.core.ex_cause.call(null,t);
via = G__27882;
t = G__27883;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5735__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5735__auto__)){
var root_msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5735__auto__)){
var data = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5735__auto__)){
var phase = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__27886 = datafied_throwable;
var map__27886__$1 = (((((!((map__27886 == null))))?(((((map__27886.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27886.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27886):map__27886);
var via = cljs.core.get.call(null,map__27886__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__27886__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__27886__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__27887 = cljs.core.last.call(null,via);
var map__27887__$1 = (((((!((map__27887 == null))))?(((((map__27887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27887.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27887):map__27887);
var type = cljs.core.get.call(null,map__27887__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__27887__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__27887__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__27888 = data;
var map__27888__$1 = (((((!((map__27888 == null))))?(((((map__27888.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27888.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27888):map__27888);
var problems = cljs.core.get.call(null,map__27888__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__27888__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__27888__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__27889 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__27889__$1 = (((((!((map__27889 == null))))?(((((map__27889.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27889.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27889):map__27889);
var top_data = map__27889__$1;
var source = cljs.core.get.call(null,map__27889__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__27894 = phase;
var G__27894__$1 = (((G__27894 instanceof cljs.core.Keyword))?G__27894.fqn:null);
switch (G__27894__$1) {
case "read-source":
var map__27895 = data;
var map__27895__$1 = (((((!((map__27895 == null))))?(((((map__27895.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27895.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27895):map__27895);
var line = cljs.core.get.call(null,map__27895__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__27895__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__27897 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__27897__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__27897,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__27897);
var G__27897__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__27897__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__27897__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__27897__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__27897__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__27898 = top_data;
var G__27898__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__27898,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__27898);
var G__27898__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__27898__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__27898__$1);
var G__27898__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__27898__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__27898__$2);
var G__27898__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__27898__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__27898__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__27898__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__27898__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__27899 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__27899,(0),null);
var method = cljs.core.nth.call(null,vec__27899,(1),null);
var file = cljs.core.nth.call(null,vec__27899,(2),null);
var line = cljs.core.nth.call(null,vec__27899,(3),null);
var G__27902 = top_data;
var G__27902__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__27902,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__27902);
var G__27902__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__27902__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__27902__$1);
var G__27902__$3 = (cljs.core.truth_((function (){var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.call(null,G__27902__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__27902__$2);
var G__27902__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__27902__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__27902__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__27902__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__27902__$4;
}

break;
case "execution":
var vec__27903 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__27903,(0),null);
var method = cljs.core.nth.call(null,vec__27903,(1),null);
var file = cljs.core.nth.call(null,vec__27903,(2),null);
var line = cljs.core.nth.call(null,vec__27903,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,((function (vec__27903,source__$1,method,file,line,G__27894,G__27894__$1,map__27886,map__27886__$1,via,trace,phase,map__27887,map__27887__$1,type,message,data,map__27888,map__27888__$1,problems,fn,caller,map__27889,map__27889__$1,top_data,source){
return (function (p1__27885_SHARP_){
var or__4131__auto__ = (p1__27885_SHARP_ == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__27885_SHARP_);
}
});})(vec__27903,source__$1,method,file,line,G__27894,G__27894__$1,map__27886,map__27886__$1,via,trace,phase,map__27887,map__27887__$1,type,message,data,map__27888,map__27888__$1,problems,fn,caller,map__27889,map__27889__$1,top_data,source))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return line;
}
})();
var G__27906 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__27906__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__27906,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__27906);
var G__27906__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__27906__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__27906__$1);
var G__27906__$3 = (cljs.core.truth_((function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
}
})())?cljs.core.assoc.call(null,G__27906__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__27906__$2);
var G__27906__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__27906__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__27906__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__27906__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__27906__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27894__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__27910){
var map__27911 = p__27910;
var map__27911__$1 = (((((!((map__27911 == null))))?(((((map__27911.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27911.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27911):map__27911);
var triage_data = map__27911__$1;
var phase = cljs.core.get.call(null,map__27911__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__27911__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__27911__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__27911__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__27911__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__27911__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__27911__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__27911__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4131__auto__ = class$;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__27913 = phase;
var G__27913__$1 = (((G__27913 instanceof cljs.core.Keyword))?G__27913.fqn:null);
switch (G__27913__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__27914_27923 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__27915_27924 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__27916_27925 = true;
var _STAR_print_fn_STAR__temp_val__27917_27926 = ((function (_STAR_print_newline_STAR__orig_val__27914_27923,_STAR_print_fn_STAR__orig_val__27915_27924,_STAR_print_newline_STAR__temp_val__27916_27925,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__27914_27923,_STAR_print_fn_STAR__orig_val__27915_27924,_STAR_print_newline_STAR__temp_val__27916_27925,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__27916_27925;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__27917_27926;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__27914_27923,_STAR_print_fn_STAR__orig_val__27915_27924,_STAR_print_newline_STAR__temp_val__27916_27925,_STAR_print_fn_STAR__temp_val__27917_27926,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__27914_27923,_STAR_print_fn_STAR__orig_val__27915_27924,_STAR_print_newline_STAR__temp_val__27916_27925,_STAR_print_fn_STAR__temp_val__27917_27926,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__27908_SHARP_){
return cljs.core.dissoc.call(null,p1__27908_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__27914_27923,_STAR_print_fn_STAR__orig_val__27915_27924,_STAR_print_newline_STAR__temp_val__27916_27925,_STAR_print_fn_STAR__temp_val__27917_27926,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__27914_27923,_STAR_print_fn_STAR__orig_val__27915_27924,_STAR_print_newline_STAR__temp_val__27916_27925,_STAR_print_fn_STAR__temp_val__27917_27926,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__27915_27924;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__27914_27923;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__27918_27927 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__27919_27928 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__27920_27929 = true;
var _STAR_print_fn_STAR__temp_val__27921_27930 = ((function (_STAR_print_newline_STAR__orig_val__27918_27927,_STAR_print_fn_STAR__orig_val__27919_27928,_STAR_print_newline_STAR__temp_val__27920_27929,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__27918_27927,_STAR_print_fn_STAR__orig_val__27919_27928,_STAR_print_newline_STAR__temp_val__27920_27929,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__27920_27929;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__27921_27930;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__27918_27927,_STAR_print_fn_STAR__orig_val__27919_27928,_STAR_print_newline_STAR__temp_val__27920_27929,_STAR_print_fn_STAR__temp_val__27921_27930,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__27918_27927,_STAR_print_fn_STAR__orig_val__27919_27928,_STAR_print_newline_STAR__temp_val__27920_27929,_STAR_print_fn_STAR__temp_val__27921_27930,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__27909_SHARP_){
return cljs.core.dissoc.call(null,p1__27909_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__27918_27927,_STAR_print_fn_STAR__orig_val__27919_27928,_STAR_print_newline_STAR__temp_val__27920_27929,_STAR_print_fn_STAR__temp_val__27921_27930,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__27918_27927,_STAR_print_fn_STAR__orig_val__27919_27928,_STAR_print_newline_STAR__temp_val__27920_27929,_STAR_print_fn_STAR__temp_val__27921_27930,sb__4661__auto__,G__27913,G__27913__$1,loc,class_name,simple_class,cause_type,format,map__27911,map__27911__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__27919_27928;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__27918_27927;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27913__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=repl.js.map?rel=1571424880219
