// Compiled by ClojureScript 1.10.520 {:static-fns false, :optimize-constants false}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__24183 = arguments.length;
switch (G__24183) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24184 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24184 = (function (f,blockable,meta24185){
this.f = f;
this.blockable = blockable;
this.meta24185 = meta24185;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24184.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24186,meta24185__$1){
var self__ = this;
var _24186__$1 = this;
return (new cljs.core.async.t_cljs$core$async24184(self__.f,self__.blockable,meta24185__$1));
});

cljs.core.async.t_cljs$core$async24184.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24186){
var self__ = this;
var _24186__$1 = this;
return self__.meta24185;
});

cljs.core.async.t_cljs$core$async24184.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24184.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async24184.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async24184.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async24184.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta24185","meta24185",-1042458964,null)], null);
});

cljs.core.async.t_cljs$core$async24184.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24184.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24184";

cljs.core.async.t_cljs$core$async24184.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async24184");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24184.
 */
cljs.core.async.__GT_t_cljs$core$async24184 = (function cljs$core$async$__GT_t_cljs$core$async24184(f__$1,blockable__$1,meta24185){
return (new cljs.core.async.t_cljs$core$async24184(f__$1,blockable__$1,meta24185));
});

}

return (new cljs.core.async.t_cljs$core$async24184(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__24190 = arguments.length;
switch (G__24190) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__24193 = arguments.length;
switch (G__24193) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__24196 = arguments.length;
switch (G__24196) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_24198 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_24198);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_24198,ret){
return (function (){
return fn1.call(null,val_24198);
});})(val_24198,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__24200 = arguments.length;
switch (G__24200) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5733__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5733__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___24202 = n;
var x_24203 = (0);
while(true){
if((x_24203 < n__4607__auto___24202)){
(a[x_24203] = (0));

var G__24204 = (x_24203 + (1));
x_24203 = G__24204;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__24205 = (i + (1));
i = G__24205;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24206 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24206 = (function (flag,meta24207){
this.flag = flag;
this.meta24207 = meta24207;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24206.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_24208,meta24207__$1){
var self__ = this;
var _24208__$1 = this;
return (new cljs.core.async.t_cljs$core$async24206(self__.flag,meta24207__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async24206.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_24208){
var self__ = this;
var _24208__$1 = this;
return self__.meta24207;
});})(flag))
;

cljs.core.async.t_cljs$core$async24206.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24206.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async24206.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async24206.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async24206.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta24207","meta24207",1113688603,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async24206.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24206.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24206";

cljs.core.async.t_cljs$core$async24206.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async24206");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24206.
 */
cljs.core.async.__GT_t_cljs$core$async24206 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async24206(flag__$1,meta24207){
return (new cljs.core.async.t_cljs$core$async24206(flag__$1,meta24207));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async24206(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24209 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24209 = (function (flag,cb,meta24210){
this.flag = flag;
this.cb = cb;
this.meta24210 = meta24210;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24209.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24211,meta24210__$1){
var self__ = this;
var _24211__$1 = this;
return (new cljs.core.async.t_cljs$core$async24209(self__.flag,self__.cb,meta24210__$1));
});

cljs.core.async.t_cljs$core$async24209.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24211){
var self__ = this;
var _24211__$1 = this;
return self__.meta24210;
});

cljs.core.async.t_cljs$core$async24209.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24209.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async24209.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async24209.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async24209.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta24210","meta24210",-617084847,null)], null);
});

cljs.core.async.t_cljs$core$async24209.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24209.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24209";

cljs.core.async.t_cljs$core$async24209.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async24209");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24209.
 */
cljs.core.async.__GT_t_cljs$core$async24209 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async24209(flag__$1,cb__$1,meta24210){
return (new cljs.core.async.t_cljs$core$async24209(flag__$1,cb__$1,meta24210));
});

}

return (new cljs.core.async.t_cljs$core$async24209(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__24212_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24212_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__24213_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24213_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__24214 = (i + (1));
i = G__24214;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___24220 = arguments.length;
var i__4731__auto___24221 = (0);
while(true){
if((i__4731__auto___24221 < len__4730__auto___24220)){
args__4736__auto__.push((arguments[i__4731__auto___24221]));

var G__24222 = (i__4731__auto___24221 + (1));
i__4731__auto___24221 = G__24222;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__24217){
var map__24218 = p__24217;
var map__24218__$1 = (((((!((map__24218 == null))))?(((((map__24218.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24218.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24218):map__24218);
var opts = map__24218__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq24215){
var G__24216 = cljs.core.first.call(null,seq24215);
var seq24215__$1 = cljs.core.next.call(null,seq24215);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__24216,seq24215__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__24224 = arguments.length;
switch (G__24224) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__24123__auto___24270 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___24270){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___24270){
return (function (state_24248){
var state_val_24249 = (state_24248[(1)]);
if((state_val_24249 === (7))){
var inst_24244 = (state_24248[(2)]);
var state_24248__$1 = state_24248;
var statearr_24250_24271 = state_24248__$1;
(statearr_24250_24271[(2)] = inst_24244);

(statearr_24250_24271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (1))){
var state_24248__$1 = state_24248;
var statearr_24251_24272 = state_24248__$1;
(statearr_24251_24272[(2)] = null);

(statearr_24251_24272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (4))){
var inst_24227 = (state_24248[(7)]);
var inst_24227__$1 = (state_24248[(2)]);
var inst_24228 = (inst_24227__$1 == null);
var state_24248__$1 = (function (){var statearr_24252 = state_24248;
(statearr_24252[(7)] = inst_24227__$1);

return statearr_24252;
})();
if(cljs.core.truth_(inst_24228)){
var statearr_24253_24273 = state_24248__$1;
(statearr_24253_24273[(1)] = (5));

} else {
var statearr_24254_24274 = state_24248__$1;
(statearr_24254_24274[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (13))){
var state_24248__$1 = state_24248;
var statearr_24255_24275 = state_24248__$1;
(statearr_24255_24275[(2)] = null);

(statearr_24255_24275[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (6))){
var inst_24227 = (state_24248[(7)]);
var state_24248__$1 = state_24248;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24248__$1,(11),to,inst_24227);
} else {
if((state_val_24249 === (3))){
var inst_24246 = (state_24248[(2)]);
var state_24248__$1 = state_24248;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24248__$1,inst_24246);
} else {
if((state_val_24249 === (12))){
var state_24248__$1 = state_24248;
var statearr_24256_24276 = state_24248__$1;
(statearr_24256_24276[(2)] = null);

(statearr_24256_24276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (2))){
var state_24248__$1 = state_24248;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24248__$1,(4),from);
} else {
if((state_val_24249 === (11))){
var inst_24237 = (state_24248[(2)]);
var state_24248__$1 = state_24248;
if(cljs.core.truth_(inst_24237)){
var statearr_24257_24277 = state_24248__$1;
(statearr_24257_24277[(1)] = (12));

} else {
var statearr_24258_24278 = state_24248__$1;
(statearr_24258_24278[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (9))){
var state_24248__$1 = state_24248;
var statearr_24259_24279 = state_24248__$1;
(statearr_24259_24279[(2)] = null);

(statearr_24259_24279[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (5))){
var state_24248__$1 = state_24248;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24260_24280 = state_24248__$1;
(statearr_24260_24280[(1)] = (8));

} else {
var statearr_24261_24281 = state_24248__$1;
(statearr_24261_24281[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (14))){
var inst_24242 = (state_24248[(2)]);
var state_24248__$1 = state_24248;
var statearr_24262_24282 = state_24248__$1;
(statearr_24262_24282[(2)] = inst_24242);

(statearr_24262_24282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (10))){
var inst_24234 = (state_24248[(2)]);
var state_24248__$1 = state_24248;
var statearr_24263_24283 = state_24248__$1;
(statearr_24263_24283[(2)] = inst_24234);

(statearr_24263_24283[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24249 === (8))){
var inst_24231 = cljs.core.async.close_BANG_.call(null,to);
var state_24248__$1 = state_24248;
var statearr_24264_24284 = state_24248__$1;
(statearr_24264_24284[(2)] = inst_24231);

(statearr_24264_24284[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___24270))
;
return ((function (switch__24028__auto__,c__24123__auto___24270){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_24265 = [null,null,null,null,null,null,null,null];
(statearr_24265[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_24265[(1)] = (1));

return statearr_24265;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_24248){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24248);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24266){if((e24266 instanceof Object)){
var ex__24032__auto__ = e24266;
var statearr_24267_24285 = state_24248;
(statearr_24267_24285[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24248);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24266;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24286 = state_24248;
state_24248 = G__24286;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_24248){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_24248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___24270))
})();
var state__24125__auto__ = (function (){var statearr_24268 = f__24124__auto__.call(null);
(statearr_24268[(6)] = c__24123__auto___24270);

return statearr_24268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___24270))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__24287){
var vec__24288 = p__24287;
var v = cljs.core.nth.call(null,vec__24288,(0),null);
var p = cljs.core.nth.call(null,vec__24288,(1),null);
var job = vec__24288;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__24123__auto___24459 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___24459,res,vec__24288,v,p,job,jobs,results){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___24459,res,vec__24288,v,p,job,jobs,results){
return (function (state_24295){
var state_val_24296 = (state_24295[(1)]);
if((state_val_24296 === (1))){
var state_24295__$1 = state_24295;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24295__$1,(2),res,v);
} else {
if((state_val_24296 === (2))){
var inst_24292 = (state_24295[(2)]);
var inst_24293 = cljs.core.async.close_BANG_.call(null,res);
var state_24295__$1 = (function (){var statearr_24297 = state_24295;
(statearr_24297[(7)] = inst_24292);

return statearr_24297;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24295__$1,inst_24293);
} else {
return null;
}
}
});})(c__24123__auto___24459,res,vec__24288,v,p,job,jobs,results))
;
return ((function (switch__24028__auto__,c__24123__auto___24459,res,vec__24288,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0 = (function (){
var statearr_24298 = [null,null,null,null,null,null,null,null];
(statearr_24298[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__);

(statearr_24298[(1)] = (1));

return statearr_24298;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1 = (function (state_24295){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24295);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24299){if((e24299 instanceof Object)){
var ex__24032__auto__ = e24299;
var statearr_24300_24460 = state_24295;
(statearr_24300_24460[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24295);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24299;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24461 = state_24295;
state_24295 = G__24461;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = function(state_24295){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1.call(this,state_24295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___24459,res,vec__24288,v,p,job,jobs,results))
})();
var state__24125__auto__ = (function (){var statearr_24301 = f__24124__auto__.call(null);
(statearr_24301[(6)] = c__24123__auto___24459);

return statearr_24301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___24459,res,vec__24288,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__24302){
var vec__24303 = p__24302;
var v = cljs.core.nth.call(null,vec__24303,(0),null);
var p = cljs.core.nth.call(null,vec__24303,(1),null);
var job = vec__24303;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___24462 = n;
var __24463 = (0);
while(true){
if((__24463 < n__4607__auto___24462)){
var G__24306_24464 = type;
var G__24306_24465__$1 = (((G__24306_24464 instanceof cljs.core.Keyword))?G__24306_24464.fqn:null);
switch (G__24306_24465__$1) {
case "compute":
var c__24123__auto___24467 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__24463,c__24123__auto___24467,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (__24463,c__24123__auto___24467,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async){
return (function (state_24319){
var state_val_24320 = (state_24319[(1)]);
if((state_val_24320 === (1))){
var state_24319__$1 = state_24319;
var statearr_24321_24468 = state_24319__$1;
(statearr_24321_24468[(2)] = null);

(statearr_24321_24468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24320 === (2))){
var state_24319__$1 = state_24319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24319__$1,(4),jobs);
} else {
if((state_val_24320 === (3))){
var inst_24317 = (state_24319[(2)]);
var state_24319__$1 = state_24319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24319__$1,inst_24317);
} else {
if((state_val_24320 === (4))){
var inst_24309 = (state_24319[(2)]);
var inst_24310 = process.call(null,inst_24309);
var state_24319__$1 = state_24319;
if(cljs.core.truth_(inst_24310)){
var statearr_24322_24469 = state_24319__$1;
(statearr_24322_24469[(1)] = (5));

} else {
var statearr_24323_24470 = state_24319__$1;
(statearr_24323_24470[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24320 === (5))){
var state_24319__$1 = state_24319;
var statearr_24324_24471 = state_24319__$1;
(statearr_24324_24471[(2)] = null);

(statearr_24324_24471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24320 === (6))){
var state_24319__$1 = state_24319;
var statearr_24325_24472 = state_24319__$1;
(statearr_24325_24472[(2)] = null);

(statearr_24325_24472[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24320 === (7))){
var inst_24315 = (state_24319[(2)]);
var state_24319__$1 = state_24319;
var statearr_24326_24473 = state_24319__$1;
(statearr_24326_24473[(2)] = inst_24315);

(statearr_24326_24473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__24463,c__24123__auto___24467,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async))
;
return ((function (__24463,switch__24028__auto__,c__24123__auto___24467,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0 = (function (){
var statearr_24327 = [null,null,null,null,null,null,null];
(statearr_24327[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__);

(statearr_24327[(1)] = (1));

return statearr_24327;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1 = (function (state_24319){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24328){if((e24328 instanceof Object)){
var ex__24032__auto__ = e24328;
var statearr_24329_24474 = state_24319;
(statearr_24329_24474[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24328;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24475 = state_24319;
state_24319 = G__24475;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = function(state_24319){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1.call(this,state_24319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__;
})()
;})(__24463,switch__24028__auto__,c__24123__auto___24467,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async))
})();
var state__24125__auto__ = (function (){var statearr_24330 = f__24124__auto__.call(null);
(statearr_24330[(6)] = c__24123__auto___24467);

return statearr_24330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(__24463,c__24123__auto___24467,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async))
);


break;
case "async":
var c__24123__auto___24476 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__24463,c__24123__auto___24476,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (__24463,c__24123__auto___24476,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async){
return (function (state_24343){
var state_val_24344 = (state_24343[(1)]);
if((state_val_24344 === (1))){
var state_24343__$1 = state_24343;
var statearr_24345_24477 = state_24343__$1;
(statearr_24345_24477[(2)] = null);

(statearr_24345_24477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24344 === (2))){
var state_24343__$1 = state_24343;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24343__$1,(4),jobs);
} else {
if((state_val_24344 === (3))){
var inst_24341 = (state_24343[(2)]);
var state_24343__$1 = state_24343;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24343__$1,inst_24341);
} else {
if((state_val_24344 === (4))){
var inst_24333 = (state_24343[(2)]);
var inst_24334 = async.call(null,inst_24333);
var state_24343__$1 = state_24343;
if(cljs.core.truth_(inst_24334)){
var statearr_24346_24478 = state_24343__$1;
(statearr_24346_24478[(1)] = (5));

} else {
var statearr_24347_24479 = state_24343__$1;
(statearr_24347_24479[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24344 === (5))){
var state_24343__$1 = state_24343;
var statearr_24348_24480 = state_24343__$1;
(statearr_24348_24480[(2)] = null);

(statearr_24348_24480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24344 === (6))){
var state_24343__$1 = state_24343;
var statearr_24349_24481 = state_24343__$1;
(statearr_24349_24481[(2)] = null);

(statearr_24349_24481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24344 === (7))){
var inst_24339 = (state_24343[(2)]);
var state_24343__$1 = state_24343;
var statearr_24350_24482 = state_24343__$1;
(statearr_24350_24482[(2)] = inst_24339);

(statearr_24350_24482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__24463,c__24123__auto___24476,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async))
;
return ((function (__24463,switch__24028__auto__,c__24123__auto___24476,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0 = (function (){
var statearr_24351 = [null,null,null,null,null,null,null];
(statearr_24351[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__);

(statearr_24351[(1)] = (1));

return statearr_24351;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1 = (function (state_24343){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24343);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24352){if((e24352 instanceof Object)){
var ex__24032__auto__ = e24352;
var statearr_24353_24483 = state_24343;
(statearr_24353_24483[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24343);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24352;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24484 = state_24343;
state_24343 = G__24484;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = function(state_24343){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1.call(this,state_24343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__;
})()
;})(__24463,switch__24028__auto__,c__24123__auto___24476,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async))
})();
var state__24125__auto__ = (function (){var statearr_24354 = f__24124__auto__.call(null);
(statearr_24354[(6)] = c__24123__auto___24476);

return statearr_24354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(__24463,c__24123__auto___24476,G__24306_24464,G__24306_24465__$1,n__4607__auto___24462,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24306_24465__$1)].join('')));

}

var G__24485 = (__24463 + (1));
__24463 = G__24485;
continue;
} else {
}
break;
}

var c__24123__auto___24486 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___24486,jobs,results,process,async){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___24486,jobs,results,process,async){
return (function (state_24376){
var state_val_24377 = (state_24376[(1)]);
if((state_val_24377 === (7))){
var inst_24372 = (state_24376[(2)]);
var state_24376__$1 = state_24376;
var statearr_24378_24487 = state_24376__$1;
(statearr_24378_24487[(2)] = inst_24372);

(statearr_24378_24487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (1))){
var state_24376__$1 = state_24376;
var statearr_24379_24488 = state_24376__$1;
(statearr_24379_24488[(2)] = null);

(statearr_24379_24488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (4))){
var inst_24357 = (state_24376[(7)]);
var inst_24357__$1 = (state_24376[(2)]);
var inst_24358 = (inst_24357__$1 == null);
var state_24376__$1 = (function (){var statearr_24380 = state_24376;
(statearr_24380[(7)] = inst_24357__$1);

return statearr_24380;
})();
if(cljs.core.truth_(inst_24358)){
var statearr_24381_24489 = state_24376__$1;
(statearr_24381_24489[(1)] = (5));

} else {
var statearr_24382_24490 = state_24376__$1;
(statearr_24382_24490[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (6))){
var inst_24357 = (state_24376[(7)]);
var inst_24362 = (state_24376[(8)]);
var inst_24362__$1 = cljs.core.async.chan.call(null,(1));
var inst_24363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24364 = [inst_24357,inst_24362__$1];
var inst_24365 = (new cljs.core.PersistentVector(null,2,(5),inst_24363,inst_24364,null));
var state_24376__$1 = (function (){var statearr_24383 = state_24376;
(statearr_24383[(8)] = inst_24362__$1);

return statearr_24383;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24376__$1,(8),jobs,inst_24365);
} else {
if((state_val_24377 === (3))){
var inst_24374 = (state_24376[(2)]);
var state_24376__$1 = state_24376;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24376__$1,inst_24374);
} else {
if((state_val_24377 === (2))){
var state_24376__$1 = state_24376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24376__$1,(4),from);
} else {
if((state_val_24377 === (9))){
var inst_24369 = (state_24376[(2)]);
var state_24376__$1 = (function (){var statearr_24384 = state_24376;
(statearr_24384[(9)] = inst_24369);

return statearr_24384;
})();
var statearr_24385_24491 = state_24376__$1;
(statearr_24385_24491[(2)] = null);

(statearr_24385_24491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (5))){
var inst_24360 = cljs.core.async.close_BANG_.call(null,jobs);
var state_24376__$1 = state_24376;
var statearr_24386_24492 = state_24376__$1;
(statearr_24386_24492[(2)] = inst_24360);

(statearr_24386_24492[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (8))){
var inst_24362 = (state_24376[(8)]);
var inst_24367 = (state_24376[(2)]);
var state_24376__$1 = (function (){var statearr_24387 = state_24376;
(statearr_24387[(10)] = inst_24367);

return statearr_24387;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24376__$1,(9),results,inst_24362);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___24486,jobs,results,process,async))
;
return ((function (switch__24028__auto__,c__24123__auto___24486,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0 = (function (){
var statearr_24388 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24388[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__);

(statearr_24388[(1)] = (1));

return statearr_24388;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1 = (function (state_24376){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24376);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24389){if((e24389 instanceof Object)){
var ex__24032__auto__ = e24389;
var statearr_24390_24493 = state_24376;
(statearr_24390_24493[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24376);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24389;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24494 = state_24376;
state_24376 = G__24494;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = function(state_24376){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1.call(this,state_24376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___24486,jobs,results,process,async))
})();
var state__24125__auto__ = (function (){var statearr_24391 = f__24124__auto__.call(null);
(statearr_24391[(6)] = c__24123__auto___24486);

return statearr_24391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___24486,jobs,results,process,async))
);


var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__,jobs,results,process,async){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__,jobs,results,process,async){
return (function (state_24429){
var state_val_24430 = (state_24429[(1)]);
if((state_val_24430 === (7))){
var inst_24425 = (state_24429[(2)]);
var state_24429__$1 = state_24429;
var statearr_24431_24495 = state_24429__$1;
(statearr_24431_24495[(2)] = inst_24425);

(statearr_24431_24495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (20))){
var state_24429__$1 = state_24429;
var statearr_24432_24496 = state_24429__$1;
(statearr_24432_24496[(2)] = null);

(statearr_24432_24496[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (1))){
var state_24429__$1 = state_24429;
var statearr_24433_24497 = state_24429__$1;
(statearr_24433_24497[(2)] = null);

(statearr_24433_24497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (4))){
var inst_24394 = (state_24429[(7)]);
var inst_24394__$1 = (state_24429[(2)]);
var inst_24395 = (inst_24394__$1 == null);
var state_24429__$1 = (function (){var statearr_24434 = state_24429;
(statearr_24434[(7)] = inst_24394__$1);

return statearr_24434;
})();
if(cljs.core.truth_(inst_24395)){
var statearr_24435_24498 = state_24429__$1;
(statearr_24435_24498[(1)] = (5));

} else {
var statearr_24436_24499 = state_24429__$1;
(statearr_24436_24499[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (15))){
var inst_24407 = (state_24429[(8)]);
var state_24429__$1 = state_24429;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24429__$1,(18),to,inst_24407);
} else {
if((state_val_24430 === (21))){
var inst_24420 = (state_24429[(2)]);
var state_24429__$1 = state_24429;
var statearr_24437_24500 = state_24429__$1;
(statearr_24437_24500[(2)] = inst_24420);

(statearr_24437_24500[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (13))){
var inst_24422 = (state_24429[(2)]);
var state_24429__$1 = (function (){var statearr_24438 = state_24429;
(statearr_24438[(9)] = inst_24422);

return statearr_24438;
})();
var statearr_24439_24501 = state_24429__$1;
(statearr_24439_24501[(2)] = null);

(statearr_24439_24501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (6))){
var inst_24394 = (state_24429[(7)]);
var state_24429__$1 = state_24429;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24429__$1,(11),inst_24394);
} else {
if((state_val_24430 === (17))){
var inst_24415 = (state_24429[(2)]);
var state_24429__$1 = state_24429;
if(cljs.core.truth_(inst_24415)){
var statearr_24440_24502 = state_24429__$1;
(statearr_24440_24502[(1)] = (19));

} else {
var statearr_24441_24503 = state_24429__$1;
(statearr_24441_24503[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (3))){
var inst_24427 = (state_24429[(2)]);
var state_24429__$1 = state_24429;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24429__$1,inst_24427);
} else {
if((state_val_24430 === (12))){
var inst_24404 = (state_24429[(10)]);
var state_24429__$1 = state_24429;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24429__$1,(14),inst_24404);
} else {
if((state_val_24430 === (2))){
var state_24429__$1 = state_24429;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24429__$1,(4),results);
} else {
if((state_val_24430 === (19))){
var state_24429__$1 = state_24429;
var statearr_24442_24504 = state_24429__$1;
(statearr_24442_24504[(2)] = null);

(statearr_24442_24504[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (11))){
var inst_24404 = (state_24429[(2)]);
var state_24429__$1 = (function (){var statearr_24443 = state_24429;
(statearr_24443[(10)] = inst_24404);

return statearr_24443;
})();
var statearr_24444_24505 = state_24429__$1;
(statearr_24444_24505[(2)] = null);

(statearr_24444_24505[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (9))){
var state_24429__$1 = state_24429;
var statearr_24445_24506 = state_24429__$1;
(statearr_24445_24506[(2)] = null);

(statearr_24445_24506[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (5))){
var state_24429__$1 = state_24429;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24446_24507 = state_24429__$1;
(statearr_24446_24507[(1)] = (8));

} else {
var statearr_24447_24508 = state_24429__$1;
(statearr_24447_24508[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (14))){
var inst_24409 = (state_24429[(11)]);
var inst_24407 = (state_24429[(8)]);
var inst_24407__$1 = (state_24429[(2)]);
var inst_24408 = (inst_24407__$1 == null);
var inst_24409__$1 = cljs.core.not.call(null,inst_24408);
var state_24429__$1 = (function (){var statearr_24448 = state_24429;
(statearr_24448[(11)] = inst_24409__$1);

(statearr_24448[(8)] = inst_24407__$1);

return statearr_24448;
})();
if(inst_24409__$1){
var statearr_24449_24509 = state_24429__$1;
(statearr_24449_24509[(1)] = (15));

} else {
var statearr_24450_24510 = state_24429__$1;
(statearr_24450_24510[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (16))){
var inst_24409 = (state_24429[(11)]);
var state_24429__$1 = state_24429;
var statearr_24451_24511 = state_24429__$1;
(statearr_24451_24511[(2)] = inst_24409);

(statearr_24451_24511[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (10))){
var inst_24401 = (state_24429[(2)]);
var state_24429__$1 = state_24429;
var statearr_24452_24512 = state_24429__$1;
(statearr_24452_24512[(2)] = inst_24401);

(statearr_24452_24512[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (18))){
var inst_24412 = (state_24429[(2)]);
var state_24429__$1 = state_24429;
var statearr_24453_24513 = state_24429__$1;
(statearr_24453_24513[(2)] = inst_24412);

(statearr_24453_24513[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24430 === (8))){
var inst_24398 = cljs.core.async.close_BANG_.call(null,to);
var state_24429__$1 = state_24429;
var statearr_24454_24514 = state_24429__$1;
(statearr_24454_24514[(2)] = inst_24398);

(statearr_24454_24514[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto__,jobs,results,process,async))
;
return ((function (switch__24028__auto__,c__24123__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0 = (function (){
var statearr_24455 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24455[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__);

(statearr_24455[(1)] = (1));

return statearr_24455;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1 = (function (state_24429){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24429);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24456){if((e24456 instanceof Object)){
var ex__24032__auto__ = e24456;
var statearr_24457_24515 = state_24429;
(statearr_24457_24515[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24429);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24456;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24516 = state_24429;
state_24429 = G__24516;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__ = function(state_24429){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1.call(this,state_24429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24029__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__,jobs,results,process,async))
})();
var state__24125__auto__ = (function (){var statearr_24458 = f__24124__auto__.call(null);
(statearr_24458[(6)] = c__24123__auto__);

return statearr_24458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__,jobs,results,process,async))
);

return c__24123__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__24518 = arguments.length;
switch (G__24518) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__24521 = arguments.length;
switch (G__24521) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__24524 = arguments.length;
switch (G__24524) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__24123__auto___24573 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___24573,tc,fc){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___24573,tc,fc){
return (function (state_24550){
var state_val_24551 = (state_24550[(1)]);
if((state_val_24551 === (7))){
var inst_24546 = (state_24550[(2)]);
var state_24550__$1 = state_24550;
var statearr_24552_24574 = state_24550__$1;
(statearr_24552_24574[(2)] = inst_24546);

(statearr_24552_24574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (1))){
var state_24550__$1 = state_24550;
var statearr_24553_24575 = state_24550__$1;
(statearr_24553_24575[(2)] = null);

(statearr_24553_24575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (4))){
var inst_24527 = (state_24550[(7)]);
var inst_24527__$1 = (state_24550[(2)]);
var inst_24528 = (inst_24527__$1 == null);
var state_24550__$1 = (function (){var statearr_24554 = state_24550;
(statearr_24554[(7)] = inst_24527__$1);

return statearr_24554;
})();
if(cljs.core.truth_(inst_24528)){
var statearr_24555_24576 = state_24550__$1;
(statearr_24555_24576[(1)] = (5));

} else {
var statearr_24556_24577 = state_24550__$1;
(statearr_24556_24577[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (13))){
var state_24550__$1 = state_24550;
var statearr_24557_24578 = state_24550__$1;
(statearr_24557_24578[(2)] = null);

(statearr_24557_24578[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (6))){
var inst_24527 = (state_24550[(7)]);
var inst_24533 = p.call(null,inst_24527);
var state_24550__$1 = state_24550;
if(cljs.core.truth_(inst_24533)){
var statearr_24558_24579 = state_24550__$1;
(statearr_24558_24579[(1)] = (9));

} else {
var statearr_24559_24580 = state_24550__$1;
(statearr_24559_24580[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (3))){
var inst_24548 = (state_24550[(2)]);
var state_24550__$1 = state_24550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24550__$1,inst_24548);
} else {
if((state_val_24551 === (12))){
var state_24550__$1 = state_24550;
var statearr_24560_24581 = state_24550__$1;
(statearr_24560_24581[(2)] = null);

(statearr_24560_24581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (2))){
var state_24550__$1 = state_24550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24550__$1,(4),ch);
} else {
if((state_val_24551 === (11))){
var inst_24527 = (state_24550[(7)]);
var inst_24537 = (state_24550[(2)]);
var state_24550__$1 = state_24550;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24550__$1,(8),inst_24537,inst_24527);
} else {
if((state_val_24551 === (9))){
var state_24550__$1 = state_24550;
var statearr_24561_24582 = state_24550__$1;
(statearr_24561_24582[(2)] = tc);

(statearr_24561_24582[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (5))){
var inst_24530 = cljs.core.async.close_BANG_.call(null,tc);
var inst_24531 = cljs.core.async.close_BANG_.call(null,fc);
var state_24550__$1 = (function (){var statearr_24562 = state_24550;
(statearr_24562[(8)] = inst_24530);

return statearr_24562;
})();
var statearr_24563_24583 = state_24550__$1;
(statearr_24563_24583[(2)] = inst_24531);

(statearr_24563_24583[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (14))){
var inst_24544 = (state_24550[(2)]);
var state_24550__$1 = state_24550;
var statearr_24564_24584 = state_24550__$1;
(statearr_24564_24584[(2)] = inst_24544);

(statearr_24564_24584[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (10))){
var state_24550__$1 = state_24550;
var statearr_24565_24585 = state_24550__$1;
(statearr_24565_24585[(2)] = fc);

(statearr_24565_24585[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24551 === (8))){
var inst_24539 = (state_24550[(2)]);
var state_24550__$1 = state_24550;
if(cljs.core.truth_(inst_24539)){
var statearr_24566_24586 = state_24550__$1;
(statearr_24566_24586[(1)] = (12));

} else {
var statearr_24567_24587 = state_24550__$1;
(statearr_24567_24587[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___24573,tc,fc))
;
return ((function (switch__24028__auto__,c__24123__auto___24573,tc,fc){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_24568 = [null,null,null,null,null,null,null,null,null];
(statearr_24568[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_24568[(1)] = (1));

return statearr_24568;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_24550){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24569){if((e24569 instanceof Object)){
var ex__24032__auto__ = e24569;
var statearr_24570_24588 = state_24550;
(statearr_24570_24588[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24569;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24589 = state_24550;
state_24550 = G__24589;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_24550){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_24550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___24573,tc,fc))
})();
var state__24125__auto__ = (function (){var statearr_24571 = f__24124__auto__.call(null);
(statearr_24571[(6)] = c__24123__auto___24573);

return statearr_24571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___24573,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__){
return (function (state_24610){
var state_val_24611 = (state_24610[(1)]);
if((state_val_24611 === (7))){
var inst_24606 = (state_24610[(2)]);
var state_24610__$1 = state_24610;
var statearr_24612_24630 = state_24610__$1;
(statearr_24612_24630[(2)] = inst_24606);

(statearr_24612_24630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24611 === (1))){
var inst_24590 = init;
var state_24610__$1 = (function (){var statearr_24613 = state_24610;
(statearr_24613[(7)] = inst_24590);

return statearr_24613;
})();
var statearr_24614_24631 = state_24610__$1;
(statearr_24614_24631[(2)] = null);

(statearr_24614_24631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24611 === (4))){
var inst_24593 = (state_24610[(8)]);
var inst_24593__$1 = (state_24610[(2)]);
var inst_24594 = (inst_24593__$1 == null);
var state_24610__$1 = (function (){var statearr_24615 = state_24610;
(statearr_24615[(8)] = inst_24593__$1);

return statearr_24615;
})();
if(cljs.core.truth_(inst_24594)){
var statearr_24616_24632 = state_24610__$1;
(statearr_24616_24632[(1)] = (5));

} else {
var statearr_24617_24633 = state_24610__$1;
(statearr_24617_24633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24611 === (6))){
var inst_24590 = (state_24610[(7)]);
var inst_24593 = (state_24610[(8)]);
var inst_24597 = (state_24610[(9)]);
var inst_24597__$1 = f.call(null,inst_24590,inst_24593);
var inst_24598 = cljs.core.reduced_QMARK_.call(null,inst_24597__$1);
var state_24610__$1 = (function (){var statearr_24618 = state_24610;
(statearr_24618[(9)] = inst_24597__$1);

return statearr_24618;
})();
if(inst_24598){
var statearr_24619_24634 = state_24610__$1;
(statearr_24619_24634[(1)] = (8));

} else {
var statearr_24620_24635 = state_24610__$1;
(statearr_24620_24635[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24611 === (3))){
var inst_24608 = (state_24610[(2)]);
var state_24610__$1 = state_24610;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24610__$1,inst_24608);
} else {
if((state_val_24611 === (2))){
var state_24610__$1 = state_24610;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24610__$1,(4),ch);
} else {
if((state_val_24611 === (9))){
var inst_24597 = (state_24610[(9)]);
var inst_24590 = inst_24597;
var state_24610__$1 = (function (){var statearr_24621 = state_24610;
(statearr_24621[(7)] = inst_24590);

return statearr_24621;
})();
var statearr_24622_24636 = state_24610__$1;
(statearr_24622_24636[(2)] = null);

(statearr_24622_24636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24611 === (5))){
var inst_24590 = (state_24610[(7)]);
var state_24610__$1 = state_24610;
var statearr_24623_24637 = state_24610__$1;
(statearr_24623_24637[(2)] = inst_24590);

(statearr_24623_24637[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24611 === (10))){
var inst_24604 = (state_24610[(2)]);
var state_24610__$1 = state_24610;
var statearr_24624_24638 = state_24610__$1;
(statearr_24624_24638[(2)] = inst_24604);

(statearr_24624_24638[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24611 === (8))){
var inst_24597 = (state_24610[(9)]);
var inst_24600 = cljs.core.deref.call(null,inst_24597);
var state_24610__$1 = state_24610;
var statearr_24625_24639 = state_24610__$1;
(statearr_24625_24639[(2)] = inst_24600);

(statearr_24625_24639[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto__))
;
return ((function (switch__24028__auto__,c__24123__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__24029__auto__ = null;
var cljs$core$async$reduce_$_state_machine__24029__auto____0 = (function (){
var statearr_24626 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24626[(0)] = cljs$core$async$reduce_$_state_machine__24029__auto__);

(statearr_24626[(1)] = (1));

return statearr_24626;
});
var cljs$core$async$reduce_$_state_machine__24029__auto____1 = (function (state_24610){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24610);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24627){if((e24627 instanceof Object)){
var ex__24032__auto__ = e24627;
var statearr_24628_24640 = state_24610;
(statearr_24628_24640[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24610);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24641 = state_24610;
state_24610 = G__24641;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__24029__auto__ = function(state_24610){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__24029__auto____1.call(this,state_24610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__24029__auto____0;
cljs$core$async$reduce_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__24029__auto____1;
return cljs$core$async$reduce_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__))
})();
var state__24125__auto__ = (function (){var statearr_24629 = f__24124__auto__.call(null);
(statearr_24629[(6)] = c__24123__auto__);

return statearr_24629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__))
);

return c__24123__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__,f__$1){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__,f__$1){
return (function (state_24647){
var state_val_24648 = (state_24647[(1)]);
if((state_val_24648 === (1))){
var inst_24642 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_24647__$1 = state_24647;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24647__$1,(2),inst_24642);
} else {
if((state_val_24648 === (2))){
var inst_24644 = (state_24647[(2)]);
var inst_24645 = f__$1.call(null,inst_24644);
var state_24647__$1 = state_24647;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24647__$1,inst_24645);
} else {
return null;
}
}
});})(c__24123__auto__,f__$1))
;
return ((function (switch__24028__auto__,c__24123__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__24029__auto__ = null;
var cljs$core$async$transduce_$_state_machine__24029__auto____0 = (function (){
var statearr_24649 = [null,null,null,null,null,null,null];
(statearr_24649[(0)] = cljs$core$async$transduce_$_state_machine__24029__auto__);

(statearr_24649[(1)] = (1));

return statearr_24649;
});
var cljs$core$async$transduce_$_state_machine__24029__auto____1 = (function (state_24647){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24647);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24650){if((e24650 instanceof Object)){
var ex__24032__auto__ = e24650;
var statearr_24651_24653 = state_24647;
(statearr_24651_24653[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24647);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24650;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24654 = state_24647;
state_24647 = G__24654;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__24029__auto__ = function(state_24647){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__24029__auto____1.call(this,state_24647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__24029__auto____0;
cljs$core$async$transduce_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__24029__auto____1;
return cljs$core$async$transduce_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__,f__$1))
})();
var state__24125__auto__ = (function (){var statearr_24652 = f__24124__auto__.call(null);
(statearr_24652[(6)] = c__24123__auto__);

return statearr_24652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__,f__$1))
);

return c__24123__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__24656 = arguments.length;
switch (G__24656) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__){
return (function (state_24681){
var state_val_24682 = (state_24681[(1)]);
if((state_val_24682 === (7))){
var inst_24663 = (state_24681[(2)]);
var state_24681__$1 = state_24681;
var statearr_24683_24704 = state_24681__$1;
(statearr_24683_24704[(2)] = inst_24663);

(statearr_24683_24704[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (1))){
var inst_24657 = cljs.core.seq.call(null,coll);
var inst_24658 = inst_24657;
var state_24681__$1 = (function (){var statearr_24684 = state_24681;
(statearr_24684[(7)] = inst_24658);

return statearr_24684;
})();
var statearr_24685_24705 = state_24681__$1;
(statearr_24685_24705[(2)] = null);

(statearr_24685_24705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (4))){
var inst_24658 = (state_24681[(7)]);
var inst_24661 = cljs.core.first.call(null,inst_24658);
var state_24681__$1 = state_24681;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24681__$1,(7),ch,inst_24661);
} else {
if((state_val_24682 === (13))){
var inst_24675 = (state_24681[(2)]);
var state_24681__$1 = state_24681;
var statearr_24686_24706 = state_24681__$1;
(statearr_24686_24706[(2)] = inst_24675);

(statearr_24686_24706[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (6))){
var inst_24666 = (state_24681[(2)]);
var state_24681__$1 = state_24681;
if(cljs.core.truth_(inst_24666)){
var statearr_24687_24707 = state_24681__$1;
(statearr_24687_24707[(1)] = (8));

} else {
var statearr_24688_24708 = state_24681__$1;
(statearr_24688_24708[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (3))){
var inst_24679 = (state_24681[(2)]);
var state_24681__$1 = state_24681;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24681__$1,inst_24679);
} else {
if((state_val_24682 === (12))){
var state_24681__$1 = state_24681;
var statearr_24689_24709 = state_24681__$1;
(statearr_24689_24709[(2)] = null);

(statearr_24689_24709[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (2))){
var inst_24658 = (state_24681[(7)]);
var state_24681__$1 = state_24681;
if(cljs.core.truth_(inst_24658)){
var statearr_24690_24710 = state_24681__$1;
(statearr_24690_24710[(1)] = (4));

} else {
var statearr_24691_24711 = state_24681__$1;
(statearr_24691_24711[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (11))){
var inst_24672 = cljs.core.async.close_BANG_.call(null,ch);
var state_24681__$1 = state_24681;
var statearr_24692_24712 = state_24681__$1;
(statearr_24692_24712[(2)] = inst_24672);

(statearr_24692_24712[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (9))){
var state_24681__$1 = state_24681;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24693_24713 = state_24681__$1;
(statearr_24693_24713[(1)] = (11));

} else {
var statearr_24694_24714 = state_24681__$1;
(statearr_24694_24714[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (5))){
var inst_24658 = (state_24681[(7)]);
var state_24681__$1 = state_24681;
var statearr_24695_24715 = state_24681__$1;
(statearr_24695_24715[(2)] = inst_24658);

(statearr_24695_24715[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (10))){
var inst_24677 = (state_24681[(2)]);
var state_24681__$1 = state_24681;
var statearr_24696_24716 = state_24681__$1;
(statearr_24696_24716[(2)] = inst_24677);

(statearr_24696_24716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24682 === (8))){
var inst_24658 = (state_24681[(7)]);
var inst_24668 = cljs.core.next.call(null,inst_24658);
var inst_24658__$1 = inst_24668;
var state_24681__$1 = (function (){var statearr_24697 = state_24681;
(statearr_24697[(7)] = inst_24658__$1);

return statearr_24697;
})();
var statearr_24698_24717 = state_24681__$1;
(statearr_24698_24717[(2)] = null);

(statearr_24698_24717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto__))
;
return ((function (switch__24028__auto__,c__24123__auto__){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_24699 = [null,null,null,null,null,null,null,null];
(statearr_24699[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_24699[(1)] = (1));

return statearr_24699;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_24681){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24700){if((e24700 instanceof Object)){
var ex__24032__auto__ = e24700;
var statearr_24701_24718 = state_24681;
(statearr_24701_24718[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24681);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24700;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24719 = state_24681;
state_24681 = G__24719;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_24681){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_24681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__))
})();
var state__24125__auto__ = (function (){var statearr_24702 = f__24124__auto__.call(null);
(statearr_24702[(6)] = c__24123__auto__);

return statearr_24702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__))
);

return c__24123__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24720 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24720 = (function (ch,cs,meta24721){
this.ch = ch;
this.cs = cs;
this.meta24721 = meta24721;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24720.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_24722,meta24721__$1){
var self__ = this;
var _24722__$1 = this;
return (new cljs.core.async.t_cljs$core$async24720(self__.ch,self__.cs,meta24721__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async24720.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_24722){
var self__ = this;
var _24722__$1 = this;
return self__.meta24721;
});})(cs))
;

cljs.core.async.t_cljs$core$async24720.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24720.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async24720.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24720.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24720.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24720.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24720.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta24721","meta24721",490231645,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async24720.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24720.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24720";

cljs.core.async.t_cljs$core$async24720.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async24720");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24720.
 */
cljs.core.async.__GT_t_cljs$core$async24720 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async24720(ch__$1,cs__$1,meta24721){
return (new cljs.core.async.t_cljs$core$async24720(ch__$1,cs__$1,meta24721));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async24720(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__24123__auto___24942 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___24942,cs,m,dchan,dctr,done){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___24942,cs,m,dchan,dctr,done){
return (function (state_24857){
var state_val_24858 = (state_24857[(1)]);
if((state_val_24858 === (7))){
var inst_24853 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
var statearr_24859_24943 = state_24857__$1;
(statearr_24859_24943[(2)] = inst_24853);

(statearr_24859_24943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (20))){
var inst_24756 = (state_24857[(7)]);
var inst_24768 = cljs.core.first.call(null,inst_24756);
var inst_24769 = cljs.core.nth.call(null,inst_24768,(0),null);
var inst_24770 = cljs.core.nth.call(null,inst_24768,(1),null);
var state_24857__$1 = (function (){var statearr_24860 = state_24857;
(statearr_24860[(8)] = inst_24769);

return statearr_24860;
})();
if(cljs.core.truth_(inst_24770)){
var statearr_24861_24944 = state_24857__$1;
(statearr_24861_24944[(1)] = (22));

} else {
var statearr_24862_24945 = state_24857__$1;
(statearr_24862_24945[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (27))){
var inst_24805 = (state_24857[(9)]);
var inst_24800 = (state_24857[(10)]);
var inst_24725 = (state_24857[(11)]);
var inst_24798 = (state_24857[(12)]);
var inst_24805__$1 = cljs.core._nth.call(null,inst_24798,inst_24800);
var inst_24806 = cljs.core.async.put_BANG_.call(null,inst_24805__$1,inst_24725,done);
var state_24857__$1 = (function (){var statearr_24863 = state_24857;
(statearr_24863[(9)] = inst_24805__$1);

return statearr_24863;
})();
if(cljs.core.truth_(inst_24806)){
var statearr_24864_24946 = state_24857__$1;
(statearr_24864_24946[(1)] = (30));

} else {
var statearr_24865_24947 = state_24857__$1;
(statearr_24865_24947[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (1))){
var state_24857__$1 = state_24857;
var statearr_24866_24948 = state_24857__$1;
(statearr_24866_24948[(2)] = null);

(statearr_24866_24948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (24))){
var inst_24756 = (state_24857[(7)]);
var inst_24775 = (state_24857[(2)]);
var inst_24776 = cljs.core.next.call(null,inst_24756);
var inst_24734 = inst_24776;
var inst_24735 = null;
var inst_24736 = (0);
var inst_24737 = (0);
var state_24857__$1 = (function (){var statearr_24867 = state_24857;
(statearr_24867[(13)] = inst_24735);

(statearr_24867[(14)] = inst_24775);

(statearr_24867[(15)] = inst_24734);

(statearr_24867[(16)] = inst_24737);

(statearr_24867[(17)] = inst_24736);

return statearr_24867;
})();
var statearr_24868_24949 = state_24857__$1;
(statearr_24868_24949[(2)] = null);

(statearr_24868_24949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (39))){
var state_24857__$1 = state_24857;
var statearr_24872_24950 = state_24857__$1;
(statearr_24872_24950[(2)] = null);

(statearr_24872_24950[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (4))){
var inst_24725 = (state_24857[(11)]);
var inst_24725__$1 = (state_24857[(2)]);
var inst_24726 = (inst_24725__$1 == null);
var state_24857__$1 = (function (){var statearr_24873 = state_24857;
(statearr_24873[(11)] = inst_24725__$1);

return statearr_24873;
})();
if(cljs.core.truth_(inst_24726)){
var statearr_24874_24951 = state_24857__$1;
(statearr_24874_24951[(1)] = (5));

} else {
var statearr_24875_24952 = state_24857__$1;
(statearr_24875_24952[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (15))){
var inst_24735 = (state_24857[(13)]);
var inst_24734 = (state_24857[(15)]);
var inst_24737 = (state_24857[(16)]);
var inst_24736 = (state_24857[(17)]);
var inst_24752 = (state_24857[(2)]);
var inst_24753 = (inst_24737 + (1));
var tmp24869 = inst_24735;
var tmp24870 = inst_24734;
var tmp24871 = inst_24736;
var inst_24734__$1 = tmp24870;
var inst_24735__$1 = tmp24869;
var inst_24736__$1 = tmp24871;
var inst_24737__$1 = inst_24753;
var state_24857__$1 = (function (){var statearr_24876 = state_24857;
(statearr_24876[(13)] = inst_24735__$1);

(statearr_24876[(18)] = inst_24752);

(statearr_24876[(15)] = inst_24734__$1);

(statearr_24876[(16)] = inst_24737__$1);

(statearr_24876[(17)] = inst_24736__$1);

return statearr_24876;
})();
var statearr_24877_24953 = state_24857__$1;
(statearr_24877_24953[(2)] = null);

(statearr_24877_24953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (21))){
var inst_24779 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
var statearr_24881_24954 = state_24857__$1;
(statearr_24881_24954[(2)] = inst_24779);

(statearr_24881_24954[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (31))){
var inst_24805 = (state_24857[(9)]);
var inst_24809 = done.call(null,null);
var inst_24810 = cljs.core.async.untap_STAR_.call(null,m,inst_24805);
var state_24857__$1 = (function (){var statearr_24882 = state_24857;
(statearr_24882[(19)] = inst_24809);

return statearr_24882;
})();
var statearr_24883_24955 = state_24857__$1;
(statearr_24883_24955[(2)] = inst_24810);

(statearr_24883_24955[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (32))){
var inst_24797 = (state_24857[(20)]);
var inst_24800 = (state_24857[(10)]);
var inst_24799 = (state_24857[(21)]);
var inst_24798 = (state_24857[(12)]);
var inst_24812 = (state_24857[(2)]);
var inst_24813 = (inst_24800 + (1));
var tmp24878 = inst_24797;
var tmp24879 = inst_24799;
var tmp24880 = inst_24798;
var inst_24797__$1 = tmp24878;
var inst_24798__$1 = tmp24880;
var inst_24799__$1 = tmp24879;
var inst_24800__$1 = inst_24813;
var state_24857__$1 = (function (){var statearr_24884 = state_24857;
(statearr_24884[(22)] = inst_24812);

(statearr_24884[(20)] = inst_24797__$1);

(statearr_24884[(10)] = inst_24800__$1);

(statearr_24884[(21)] = inst_24799__$1);

(statearr_24884[(12)] = inst_24798__$1);

return statearr_24884;
})();
var statearr_24885_24956 = state_24857__$1;
(statearr_24885_24956[(2)] = null);

(statearr_24885_24956[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (40))){
var inst_24825 = (state_24857[(23)]);
var inst_24829 = done.call(null,null);
var inst_24830 = cljs.core.async.untap_STAR_.call(null,m,inst_24825);
var state_24857__$1 = (function (){var statearr_24886 = state_24857;
(statearr_24886[(24)] = inst_24829);

return statearr_24886;
})();
var statearr_24887_24957 = state_24857__$1;
(statearr_24887_24957[(2)] = inst_24830);

(statearr_24887_24957[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (33))){
var inst_24816 = (state_24857[(25)]);
var inst_24818 = cljs.core.chunked_seq_QMARK_.call(null,inst_24816);
var state_24857__$1 = state_24857;
if(inst_24818){
var statearr_24888_24958 = state_24857__$1;
(statearr_24888_24958[(1)] = (36));

} else {
var statearr_24889_24959 = state_24857__$1;
(statearr_24889_24959[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (13))){
var inst_24746 = (state_24857[(26)]);
var inst_24749 = cljs.core.async.close_BANG_.call(null,inst_24746);
var state_24857__$1 = state_24857;
var statearr_24890_24960 = state_24857__$1;
(statearr_24890_24960[(2)] = inst_24749);

(statearr_24890_24960[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (22))){
var inst_24769 = (state_24857[(8)]);
var inst_24772 = cljs.core.async.close_BANG_.call(null,inst_24769);
var state_24857__$1 = state_24857;
var statearr_24891_24961 = state_24857__$1;
(statearr_24891_24961[(2)] = inst_24772);

(statearr_24891_24961[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (36))){
var inst_24816 = (state_24857[(25)]);
var inst_24820 = cljs.core.chunk_first.call(null,inst_24816);
var inst_24821 = cljs.core.chunk_rest.call(null,inst_24816);
var inst_24822 = cljs.core.count.call(null,inst_24820);
var inst_24797 = inst_24821;
var inst_24798 = inst_24820;
var inst_24799 = inst_24822;
var inst_24800 = (0);
var state_24857__$1 = (function (){var statearr_24892 = state_24857;
(statearr_24892[(20)] = inst_24797);

(statearr_24892[(10)] = inst_24800);

(statearr_24892[(21)] = inst_24799);

(statearr_24892[(12)] = inst_24798);

return statearr_24892;
})();
var statearr_24893_24962 = state_24857__$1;
(statearr_24893_24962[(2)] = null);

(statearr_24893_24962[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (41))){
var inst_24816 = (state_24857[(25)]);
var inst_24832 = (state_24857[(2)]);
var inst_24833 = cljs.core.next.call(null,inst_24816);
var inst_24797 = inst_24833;
var inst_24798 = null;
var inst_24799 = (0);
var inst_24800 = (0);
var state_24857__$1 = (function (){var statearr_24894 = state_24857;
(statearr_24894[(20)] = inst_24797);

(statearr_24894[(10)] = inst_24800);

(statearr_24894[(21)] = inst_24799);

(statearr_24894[(27)] = inst_24832);

(statearr_24894[(12)] = inst_24798);

return statearr_24894;
})();
var statearr_24895_24963 = state_24857__$1;
(statearr_24895_24963[(2)] = null);

(statearr_24895_24963[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (43))){
var state_24857__$1 = state_24857;
var statearr_24896_24964 = state_24857__$1;
(statearr_24896_24964[(2)] = null);

(statearr_24896_24964[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (29))){
var inst_24841 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
var statearr_24897_24965 = state_24857__$1;
(statearr_24897_24965[(2)] = inst_24841);

(statearr_24897_24965[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (44))){
var inst_24850 = (state_24857[(2)]);
var state_24857__$1 = (function (){var statearr_24898 = state_24857;
(statearr_24898[(28)] = inst_24850);

return statearr_24898;
})();
var statearr_24899_24966 = state_24857__$1;
(statearr_24899_24966[(2)] = null);

(statearr_24899_24966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (6))){
var inst_24789 = (state_24857[(29)]);
var inst_24788 = cljs.core.deref.call(null,cs);
var inst_24789__$1 = cljs.core.keys.call(null,inst_24788);
var inst_24790 = cljs.core.count.call(null,inst_24789__$1);
var inst_24791 = cljs.core.reset_BANG_.call(null,dctr,inst_24790);
var inst_24796 = cljs.core.seq.call(null,inst_24789__$1);
var inst_24797 = inst_24796;
var inst_24798 = null;
var inst_24799 = (0);
var inst_24800 = (0);
var state_24857__$1 = (function (){var statearr_24900 = state_24857;
(statearr_24900[(29)] = inst_24789__$1);

(statearr_24900[(20)] = inst_24797);

(statearr_24900[(30)] = inst_24791);

(statearr_24900[(10)] = inst_24800);

(statearr_24900[(21)] = inst_24799);

(statearr_24900[(12)] = inst_24798);

return statearr_24900;
})();
var statearr_24901_24967 = state_24857__$1;
(statearr_24901_24967[(2)] = null);

(statearr_24901_24967[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (28))){
var inst_24816 = (state_24857[(25)]);
var inst_24797 = (state_24857[(20)]);
var inst_24816__$1 = cljs.core.seq.call(null,inst_24797);
var state_24857__$1 = (function (){var statearr_24902 = state_24857;
(statearr_24902[(25)] = inst_24816__$1);

return statearr_24902;
})();
if(inst_24816__$1){
var statearr_24903_24968 = state_24857__$1;
(statearr_24903_24968[(1)] = (33));

} else {
var statearr_24904_24969 = state_24857__$1;
(statearr_24904_24969[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (25))){
var inst_24800 = (state_24857[(10)]);
var inst_24799 = (state_24857[(21)]);
var inst_24802 = (inst_24800 < inst_24799);
var inst_24803 = inst_24802;
var state_24857__$1 = state_24857;
if(cljs.core.truth_(inst_24803)){
var statearr_24905_24970 = state_24857__$1;
(statearr_24905_24970[(1)] = (27));

} else {
var statearr_24906_24971 = state_24857__$1;
(statearr_24906_24971[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (34))){
var state_24857__$1 = state_24857;
var statearr_24907_24972 = state_24857__$1;
(statearr_24907_24972[(2)] = null);

(statearr_24907_24972[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (17))){
var state_24857__$1 = state_24857;
var statearr_24908_24973 = state_24857__$1;
(statearr_24908_24973[(2)] = null);

(statearr_24908_24973[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (3))){
var inst_24855 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24857__$1,inst_24855);
} else {
if((state_val_24858 === (12))){
var inst_24784 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
var statearr_24909_24974 = state_24857__$1;
(statearr_24909_24974[(2)] = inst_24784);

(statearr_24909_24974[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (2))){
var state_24857__$1 = state_24857;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24857__$1,(4),ch);
} else {
if((state_val_24858 === (23))){
var state_24857__$1 = state_24857;
var statearr_24910_24975 = state_24857__$1;
(statearr_24910_24975[(2)] = null);

(statearr_24910_24975[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (35))){
var inst_24839 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
var statearr_24911_24976 = state_24857__$1;
(statearr_24911_24976[(2)] = inst_24839);

(statearr_24911_24976[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (19))){
var inst_24756 = (state_24857[(7)]);
var inst_24760 = cljs.core.chunk_first.call(null,inst_24756);
var inst_24761 = cljs.core.chunk_rest.call(null,inst_24756);
var inst_24762 = cljs.core.count.call(null,inst_24760);
var inst_24734 = inst_24761;
var inst_24735 = inst_24760;
var inst_24736 = inst_24762;
var inst_24737 = (0);
var state_24857__$1 = (function (){var statearr_24912 = state_24857;
(statearr_24912[(13)] = inst_24735);

(statearr_24912[(15)] = inst_24734);

(statearr_24912[(16)] = inst_24737);

(statearr_24912[(17)] = inst_24736);

return statearr_24912;
})();
var statearr_24913_24977 = state_24857__$1;
(statearr_24913_24977[(2)] = null);

(statearr_24913_24977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (11))){
var inst_24756 = (state_24857[(7)]);
var inst_24734 = (state_24857[(15)]);
var inst_24756__$1 = cljs.core.seq.call(null,inst_24734);
var state_24857__$1 = (function (){var statearr_24914 = state_24857;
(statearr_24914[(7)] = inst_24756__$1);

return statearr_24914;
})();
if(inst_24756__$1){
var statearr_24915_24978 = state_24857__$1;
(statearr_24915_24978[(1)] = (16));

} else {
var statearr_24916_24979 = state_24857__$1;
(statearr_24916_24979[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (9))){
var inst_24786 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
var statearr_24917_24980 = state_24857__$1;
(statearr_24917_24980[(2)] = inst_24786);

(statearr_24917_24980[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (5))){
var inst_24732 = cljs.core.deref.call(null,cs);
var inst_24733 = cljs.core.seq.call(null,inst_24732);
var inst_24734 = inst_24733;
var inst_24735 = null;
var inst_24736 = (0);
var inst_24737 = (0);
var state_24857__$1 = (function (){var statearr_24918 = state_24857;
(statearr_24918[(13)] = inst_24735);

(statearr_24918[(15)] = inst_24734);

(statearr_24918[(16)] = inst_24737);

(statearr_24918[(17)] = inst_24736);

return statearr_24918;
})();
var statearr_24919_24981 = state_24857__$1;
(statearr_24919_24981[(2)] = null);

(statearr_24919_24981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (14))){
var state_24857__$1 = state_24857;
var statearr_24920_24982 = state_24857__$1;
(statearr_24920_24982[(2)] = null);

(statearr_24920_24982[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (45))){
var inst_24847 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
var statearr_24921_24983 = state_24857__$1;
(statearr_24921_24983[(2)] = inst_24847);

(statearr_24921_24983[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (26))){
var inst_24789 = (state_24857[(29)]);
var inst_24843 = (state_24857[(2)]);
var inst_24844 = cljs.core.seq.call(null,inst_24789);
var state_24857__$1 = (function (){var statearr_24922 = state_24857;
(statearr_24922[(31)] = inst_24843);

return statearr_24922;
})();
if(inst_24844){
var statearr_24923_24984 = state_24857__$1;
(statearr_24923_24984[(1)] = (42));

} else {
var statearr_24924_24985 = state_24857__$1;
(statearr_24924_24985[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (16))){
var inst_24756 = (state_24857[(7)]);
var inst_24758 = cljs.core.chunked_seq_QMARK_.call(null,inst_24756);
var state_24857__$1 = state_24857;
if(inst_24758){
var statearr_24925_24986 = state_24857__$1;
(statearr_24925_24986[(1)] = (19));

} else {
var statearr_24926_24987 = state_24857__$1;
(statearr_24926_24987[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (38))){
var inst_24836 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
var statearr_24927_24988 = state_24857__$1;
(statearr_24927_24988[(2)] = inst_24836);

(statearr_24927_24988[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (30))){
var state_24857__$1 = state_24857;
var statearr_24928_24989 = state_24857__$1;
(statearr_24928_24989[(2)] = null);

(statearr_24928_24989[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (10))){
var inst_24735 = (state_24857[(13)]);
var inst_24737 = (state_24857[(16)]);
var inst_24745 = cljs.core._nth.call(null,inst_24735,inst_24737);
var inst_24746 = cljs.core.nth.call(null,inst_24745,(0),null);
var inst_24747 = cljs.core.nth.call(null,inst_24745,(1),null);
var state_24857__$1 = (function (){var statearr_24929 = state_24857;
(statearr_24929[(26)] = inst_24746);

return statearr_24929;
})();
if(cljs.core.truth_(inst_24747)){
var statearr_24930_24990 = state_24857__$1;
(statearr_24930_24990[(1)] = (13));

} else {
var statearr_24931_24991 = state_24857__$1;
(statearr_24931_24991[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (18))){
var inst_24782 = (state_24857[(2)]);
var state_24857__$1 = state_24857;
var statearr_24932_24992 = state_24857__$1;
(statearr_24932_24992[(2)] = inst_24782);

(statearr_24932_24992[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (42))){
var state_24857__$1 = state_24857;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24857__$1,(45),dchan);
} else {
if((state_val_24858 === (37))){
var inst_24816 = (state_24857[(25)]);
var inst_24825 = (state_24857[(23)]);
var inst_24725 = (state_24857[(11)]);
var inst_24825__$1 = cljs.core.first.call(null,inst_24816);
var inst_24826 = cljs.core.async.put_BANG_.call(null,inst_24825__$1,inst_24725,done);
var state_24857__$1 = (function (){var statearr_24933 = state_24857;
(statearr_24933[(23)] = inst_24825__$1);

return statearr_24933;
})();
if(cljs.core.truth_(inst_24826)){
var statearr_24934_24993 = state_24857__$1;
(statearr_24934_24993[(1)] = (39));

} else {
var statearr_24935_24994 = state_24857__$1;
(statearr_24935_24994[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24858 === (8))){
var inst_24737 = (state_24857[(16)]);
var inst_24736 = (state_24857[(17)]);
var inst_24739 = (inst_24737 < inst_24736);
var inst_24740 = inst_24739;
var state_24857__$1 = state_24857;
if(cljs.core.truth_(inst_24740)){
var statearr_24936_24995 = state_24857__$1;
(statearr_24936_24995[(1)] = (10));

} else {
var statearr_24937_24996 = state_24857__$1;
(statearr_24937_24996[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___24942,cs,m,dchan,dctr,done))
;
return ((function (switch__24028__auto__,c__24123__auto___24942,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__24029__auto__ = null;
var cljs$core$async$mult_$_state_machine__24029__auto____0 = (function (){
var statearr_24938 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24938[(0)] = cljs$core$async$mult_$_state_machine__24029__auto__);

(statearr_24938[(1)] = (1));

return statearr_24938;
});
var cljs$core$async$mult_$_state_machine__24029__auto____1 = (function (state_24857){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_24857);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e24939){if((e24939 instanceof Object)){
var ex__24032__auto__ = e24939;
var statearr_24940_24997 = state_24857;
(statearr_24940_24997[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24857);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24939;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24998 = state_24857;
state_24857 = G__24998;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__24029__auto__ = function(state_24857){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__24029__auto____1.call(this,state_24857);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__24029__auto____0;
cljs$core$async$mult_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__24029__auto____1;
return cljs$core$async$mult_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___24942,cs,m,dchan,dctr,done))
})();
var state__24125__auto__ = (function (){var statearr_24941 = f__24124__auto__.call(null);
(statearr_24941[(6)] = c__24123__auto___24942);

return statearr_24941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___24942,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__25000 = arguments.length;
switch (G__25000) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___25012 = arguments.length;
var i__4731__auto___25013 = (0);
while(true){
if((i__4731__auto___25013 < len__4730__auto___25012)){
args__4736__auto__.push((arguments[i__4731__auto___25013]));

var G__25014 = (i__4731__auto___25013 + (1));
i__4731__auto___25013 = G__25014;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__25006){
var map__25007 = p__25006;
var map__25007__$1 = (((((!((map__25007 == null))))?(((((map__25007.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25007.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25007):map__25007);
var opts = map__25007__$1;
var statearr_25009_25015 = state;
(statearr_25009_25015[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,((function (map__25007,map__25007__$1,opts){
return (function (val){
var statearr_25010_25016 = state;
(statearr_25010_25016[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__25007,map__25007__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_25011_25017 = state;
(statearr_25011_25017[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq25002){
var G__25003 = cljs.core.first.call(null,seq25002);
var seq25002__$1 = cljs.core.next.call(null,seq25002);
var G__25004 = cljs.core.first.call(null,seq25002__$1);
var seq25002__$2 = cljs.core.next.call(null,seq25002__$1);
var G__25005 = cljs.core.first.call(null,seq25002__$2);
var seq25002__$3 = cljs.core.next.call(null,seq25002__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__25003,G__25004,G__25005,seq25002__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25018 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25018 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta25019){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta25019 = meta25019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_25020,meta25019__$1){
var self__ = this;
var _25020__$1 = this;
return (new cljs.core.async.t_cljs$core$async25018(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta25019__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_25020){
var self__ = this;
var _25020__$1 = this;
return self__.meta25019;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async25018.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async25018.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta25019","meta25019",299905360,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async25018.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25018.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25018";

cljs.core.async.t_cljs$core$async25018.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async25018");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25018.
 */
cljs.core.async.__GT_t_cljs$core$async25018 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async25018(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta25019){
return (new cljs.core.async.t_cljs$core$async25018(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta25019));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async25018(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24123__auto___25182 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___25182,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___25182,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_25122){
var state_val_25123 = (state_25122[(1)]);
if((state_val_25123 === (7))){
var inst_25037 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
var statearr_25124_25183 = state_25122__$1;
(statearr_25124_25183[(2)] = inst_25037);

(statearr_25124_25183[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (20))){
var inst_25049 = (state_25122[(7)]);
var state_25122__$1 = state_25122;
var statearr_25125_25184 = state_25122__$1;
(statearr_25125_25184[(2)] = inst_25049);

(statearr_25125_25184[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (27))){
var state_25122__$1 = state_25122;
var statearr_25126_25185 = state_25122__$1;
(statearr_25126_25185[(2)] = null);

(statearr_25126_25185[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (1))){
var inst_25024 = (state_25122[(8)]);
var inst_25024__$1 = calc_state.call(null);
var inst_25026 = (inst_25024__$1 == null);
var inst_25027 = cljs.core.not.call(null,inst_25026);
var state_25122__$1 = (function (){var statearr_25127 = state_25122;
(statearr_25127[(8)] = inst_25024__$1);

return statearr_25127;
})();
if(inst_25027){
var statearr_25128_25186 = state_25122__$1;
(statearr_25128_25186[(1)] = (2));

} else {
var statearr_25129_25187 = state_25122__$1;
(statearr_25129_25187[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (24))){
var inst_25082 = (state_25122[(9)]);
var inst_25073 = (state_25122[(10)]);
var inst_25096 = (state_25122[(11)]);
var inst_25096__$1 = inst_25073.call(null,inst_25082);
var state_25122__$1 = (function (){var statearr_25130 = state_25122;
(statearr_25130[(11)] = inst_25096__$1);

return statearr_25130;
})();
if(cljs.core.truth_(inst_25096__$1)){
var statearr_25131_25188 = state_25122__$1;
(statearr_25131_25188[(1)] = (29));

} else {
var statearr_25132_25189 = state_25122__$1;
(statearr_25132_25189[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (4))){
var inst_25040 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
if(cljs.core.truth_(inst_25040)){
var statearr_25133_25190 = state_25122__$1;
(statearr_25133_25190[(1)] = (8));

} else {
var statearr_25134_25191 = state_25122__$1;
(statearr_25134_25191[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (15))){
var inst_25067 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
if(cljs.core.truth_(inst_25067)){
var statearr_25135_25192 = state_25122__$1;
(statearr_25135_25192[(1)] = (19));

} else {
var statearr_25136_25193 = state_25122__$1;
(statearr_25136_25193[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (21))){
var inst_25072 = (state_25122[(12)]);
var inst_25072__$1 = (state_25122[(2)]);
var inst_25073 = cljs.core.get.call(null,inst_25072__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_25074 = cljs.core.get.call(null,inst_25072__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_25075 = cljs.core.get.call(null,inst_25072__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_25122__$1 = (function (){var statearr_25137 = state_25122;
(statearr_25137[(13)] = inst_25074);

(statearr_25137[(12)] = inst_25072__$1);

(statearr_25137[(10)] = inst_25073);

return statearr_25137;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_25122__$1,(22),inst_25075);
} else {
if((state_val_25123 === (31))){
var inst_25104 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
if(cljs.core.truth_(inst_25104)){
var statearr_25138_25194 = state_25122__$1;
(statearr_25138_25194[(1)] = (32));

} else {
var statearr_25139_25195 = state_25122__$1;
(statearr_25139_25195[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (32))){
var inst_25081 = (state_25122[(14)]);
var state_25122__$1 = state_25122;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25122__$1,(35),out,inst_25081);
} else {
if((state_val_25123 === (33))){
var inst_25072 = (state_25122[(12)]);
var inst_25049 = inst_25072;
var state_25122__$1 = (function (){var statearr_25140 = state_25122;
(statearr_25140[(7)] = inst_25049);

return statearr_25140;
})();
var statearr_25141_25196 = state_25122__$1;
(statearr_25141_25196[(2)] = null);

(statearr_25141_25196[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (13))){
var inst_25049 = (state_25122[(7)]);
var inst_25056 = inst_25049.cljs$lang$protocol_mask$partition0$;
var inst_25057 = (inst_25056 & (64));
var inst_25058 = inst_25049.cljs$core$ISeq$;
var inst_25059 = (cljs.core.PROTOCOL_SENTINEL === inst_25058);
var inst_25060 = ((inst_25057) || (inst_25059));
var state_25122__$1 = state_25122;
if(cljs.core.truth_(inst_25060)){
var statearr_25142_25197 = state_25122__$1;
(statearr_25142_25197[(1)] = (16));

} else {
var statearr_25143_25198 = state_25122__$1;
(statearr_25143_25198[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (22))){
var inst_25081 = (state_25122[(14)]);
var inst_25082 = (state_25122[(9)]);
var inst_25080 = (state_25122[(2)]);
var inst_25081__$1 = cljs.core.nth.call(null,inst_25080,(0),null);
var inst_25082__$1 = cljs.core.nth.call(null,inst_25080,(1),null);
var inst_25083 = (inst_25081__$1 == null);
var inst_25084 = cljs.core._EQ_.call(null,inst_25082__$1,change);
var inst_25085 = ((inst_25083) || (inst_25084));
var state_25122__$1 = (function (){var statearr_25144 = state_25122;
(statearr_25144[(14)] = inst_25081__$1);

(statearr_25144[(9)] = inst_25082__$1);

return statearr_25144;
})();
if(cljs.core.truth_(inst_25085)){
var statearr_25145_25199 = state_25122__$1;
(statearr_25145_25199[(1)] = (23));

} else {
var statearr_25146_25200 = state_25122__$1;
(statearr_25146_25200[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (36))){
var inst_25072 = (state_25122[(12)]);
var inst_25049 = inst_25072;
var state_25122__$1 = (function (){var statearr_25147 = state_25122;
(statearr_25147[(7)] = inst_25049);

return statearr_25147;
})();
var statearr_25148_25201 = state_25122__$1;
(statearr_25148_25201[(2)] = null);

(statearr_25148_25201[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (29))){
var inst_25096 = (state_25122[(11)]);
var state_25122__$1 = state_25122;
var statearr_25149_25202 = state_25122__$1;
(statearr_25149_25202[(2)] = inst_25096);

(statearr_25149_25202[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (6))){
var state_25122__$1 = state_25122;
var statearr_25150_25203 = state_25122__$1;
(statearr_25150_25203[(2)] = false);

(statearr_25150_25203[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (28))){
var inst_25092 = (state_25122[(2)]);
var inst_25093 = calc_state.call(null);
var inst_25049 = inst_25093;
var state_25122__$1 = (function (){var statearr_25151 = state_25122;
(statearr_25151[(15)] = inst_25092);

(statearr_25151[(7)] = inst_25049);

return statearr_25151;
})();
var statearr_25152_25204 = state_25122__$1;
(statearr_25152_25204[(2)] = null);

(statearr_25152_25204[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (25))){
var inst_25118 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
var statearr_25153_25205 = state_25122__$1;
(statearr_25153_25205[(2)] = inst_25118);

(statearr_25153_25205[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (34))){
var inst_25116 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
var statearr_25154_25206 = state_25122__$1;
(statearr_25154_25206[(2)] = inst_25116);

(statearr_25154_25206[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (17))){
var state_25122__$1 = state_25122;
var statearr_25155_25207 = state_25122__$1;
(statearr_25155_25207[(2)] = false);

(statearr_25155_25207[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (3))){
var state_25122__$1 = state_25122;
var statearr_25156_25208 = state_25122__$1;
(statearr_25156_25208[(2)] = false);

(statearr_25156_25208[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (12))){
var inst_25120 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25122__$1,inst_25120);
} else {
if((state_val_25123 === (2))){
var inst_25024 = (state_25122[(8)]);
var inst_25029 = inst_25024.cljs$lang$protocol_mask$partition0$;
var inst_25030 = (inst_25029 & (64));
var inst_25031 = inst_25024.cljs$core$ISeq$;
var inst_25032 = (cljs.core.PROTOCOL_SENTINEL === inst_25031);
var inst_25033 = ((inst_25030) || (inst_25032));
var state_25122__$1 = state_25122;
if(cljs.core.truth_(inst_25033)){
var statearr_25157_25209 = state_25122__$1;
(statearr_25157_25209[(1)] = (5));

} else {
var statearr_25158_25210 = state_25122__$1;
(statearr_25158_25210[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (23))){
var inst_25081 = (state_25122[(14)]);
var inst_25087 = (inst_25081 == null);
var state_25122__$1 = state_25122;
if(cljs.core.truth_(inst_25087)){
var statearr_25159_25211 = state_25122__$1;
(statearr_25159_25211[(1)] = (26));

} else {
var statearr_25160_25212 = state_25122__$1;
(statearr_25160_25212[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (35))){
var inst_25107 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
if(cljs.core.truth_(inst_25107)){
var statearr_25161_25213 = state_25122__$1;
(statearr_25161_25213[(1)] = (36));

} else {
var statearr_25162_25214 = state_25122__$1;
(statearr_25162_25214[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (19))){
var inst_25049 = (state_25122[(7)]);
var inst_25069 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25049);
var state_25122__$1 = state_25122;
var statearr_25163_25215 = state_25122__$1;
(statearr_25163_25215[(2)] = inst_25069);

(statearr_25163_25215[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (11))){
var inst_25049 = (state_25122[(7)]);
var inst_25053 = (inst_25049 == null);
var inst_25054 = cljs.core.not.call(null,inst_25053);
var state_25122__$1 = state_25122;
if(inst_25054){
var statearr_25164_25216 = state_25122__$1;
(statearr_25164_25216[(1)] = (13));

} else {
var statearr_25165_25217 = state_25122__$1;
(statearr_25165_25217[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (9))){
var inst_25024 = (state_25122[(8)]);
var state_25122__$1 = state_25122;
var statearr_25166_25218 = state_25122__$1;
(statearr_25166_25218[(2)] = inst_25024);

(statearr_25166_25218[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (5))){
var state_25122__$1 = state_25122;
var statearr_25167_25219 = state_25122__$1;
(statearr_25167_25219[(2)] = true);

(statearr_25167_25219[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (14))){
var state_25122__$1 = state_25122;
var statearr_25168_25220 = state_25122__$1;
(statearr_25168_25220[(2)] = false);

(statearr_25168_25220[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (26))){
var inst_25082 = (state_25122[(9)]);
var inst_25089 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_25082);
var state_25122__$1 = state_25122;
var statearr_25169_25221 = state_25122__$1;
(statearr_25169_25221[(2)] = inst_25089);

(statearr_25169_25221[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (16))){
var state_25122__$1 = state_25122;
var statearr_25170_25222 = state_25122__$1;
(statearr_25170_25222[(2)] = true);

(statearr_25170_25222[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (38))){
var inst_25112 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
var statearr_25171_25223 = state_25122__$1;
(statearr_25171_25223[(2)] = inst_25112);

(statearr_25171_25223[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (30))){
var inst_25074 = (state_25122[(13)]);
var inst_25082 = (state_25122[(9)]);
var inst_25073 = (state_25122[(10)]);
var inst_25099 = cljs.core.empty_QMARK_.call(null,inst_25073);
var inst_25100 = inst_25074.call(null,inst_25082);
var inst_25101 = cljs.core.not.call(null,inst_25100);
var inst_25102 = ((inst_25099) && (inst_25101));
var state_25122__$1 = state_25122;
var statearr_25172_25224 = state_25122__$1;
(statearr_25172_25224[(2)] = inst_25102);

(statearr_25172_25224[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (10))){
var inst_25024 = (state_25122[(8)]);
var inst_25045 = (state_25122[(2)]);
var inst_25046 = cljs.core.get.call(null,inst_25045,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_25047 = cljs.core.get.call(null,inst_25045,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_25048 = cljs.core.get.call(null,inst_25045,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_25049 = inst_25024;
var state_25122__$1 = (function (){var statearr_25173 = state_25122;
(statearr_25173[(16)] = inst_25048);

(statearr_25173[(7)] = inst_25049);

(statearr_25173[(17)] = inst_25047);

(statearr_25173[(18)] = inst_25046);

return statearr_25173;
})();
var statearr_25174_25225 = state_25122__$1;
(statearr_25174_25225[(2)] = null);

(statearr_25174_25225[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (18))){
var inst_25064 = (state_25122[(2)]);
var state_25122__$1 = state_25122;
var statearr_25175_25226 = state_25122__$1;
(statearr_25175_25226[(2)] = inst_25064);

(statearr_25175_25226[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (37))){
var state_25122__$1 = state_25122;
var statearr_25176_25227 = state_25122__$1;
(statearr_25176_25227[(2)] = null);

(statearr_25176_25227[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25123 === (8))){
var inst_25024 = (state_25122[(8)]);
var inst_25042 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25024);
var state_25122__$1 = state_25122;
var statearr_25177_25228 = state_25122__$1;
(statearr_25177_25228[(2)] = inst_25042);

(statearr_25177_25228[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___25182,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__24028__auto__,c__24123__auto___25182,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__24029__auto__ = null;
var cljs$core$async$mix_$_state_machine__24029__auto____0 = (function (){
var statearr_25178 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25178[(0)] = cljs$core$async$mix_$_state_machine__24029__auto__);

(statearr_25178[(1)] = (1));

return statearr_25178;
});
var cljs$core$async$mix_$_state_machine__24029__auto____1 = (function (state_25122){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e25179){if((e25179 instanceof Object)){
var ex__24032__auto__ = e25179;
var statearr_25180_25229 = state_25122;
(statearr_25180_25229[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25122);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25179;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25230 = state_25122;
state_25122 = G__25230;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__24029__auto__ = function(state_25122){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__24029__auto____1.call(this,state_25122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__24029__auto____0;
cljs$core$async$mix_$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__24029__auto____1;
return cljs$core$async$mix_$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___25182,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__24125__auto__ = (function (){var statearr_25181 = f__24124__auto__.call(null);
(statearr_25181[(6)] = c__24123__auto___25182);

return statearr_25181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___25182,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__25232 = arguments.length;
switch (G__25232) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__25236 = arguments.length;
switch (G__25236) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__25234_SHARP_){
if(cljs.core.truth_(p1__25234_SHARP_.call(null,topic))){
return p1__25234_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__25234_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25237 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25237 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta25238){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta25238 = meta25238;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25237.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_25239,meta25238__$1){
var self__ = this;
var _25239__$1 = this;
return (new cljs.core.async.t_cljs$core$async25237(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta25238__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25237.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_25239){
var self__ = this;
var _25239__$1 = this;
return self__.meta25238;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25237.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25237.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25237.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25237.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25237.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25237.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25237.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25237.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta25238","meta25238",680613111,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25237.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25237.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25237";

cljs.core.async.t_cljs$core$async25237.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async25237");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25237.
 */
cljs.core.async.__GT_t_cljs$core$async25237 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async25237(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25238){
return (new cljs.core.async.t_cljs$core$async25237(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25238));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async25237(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24123__auto___25357 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___25357,mults,ensure_mult,p){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___25357,mults,ensure_mult,p){
return (function (state_25311){
var state_val_25312 = (state_25311[(1)]);
if((state_val_25312 === (7))){
var inst_25307 = (state_25311[(2)]);
var state_25311__$1 = state_25311;
var statearr_25313_25358 = state_25311__$1;
(statearr_25313_25358[(2)] = inst_25307);

(statearr_25313_25358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (20))){
var state_25311__$1 = state_25311;
var statearr_25314_25359 = state_25311__$1;
(statearr_25314_25359[(2)] = null);

(statearr_25314_25359[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (1))){
var state_25311__$1 = state_25311;
var statearr_25315_25360 = state_25311__$1;
(statearr_25315_25360[(2)] = null);

(statearr_25315_25360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (24))){
var inst_25290 = (state_25311[(7)]);
var inst_25299 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_25290);
var state_25311__$1 = state_25311;
var statearr_25316_25361 = state_25311__$1;
(statearr_25316_25361[(2)] = inst_25299);

(statearr_25316_25361[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (4))){
var inst_25242 = (state_25311[(8)]);
var inst_25242__$1 = (state_25311[(2)]);
var inst_25243 = (inst_25242__$1 == null);
var state_25311__$1 = (function (){var statearr_25317 = state_25311;
(statearr_25317[(8)] = inst_25242__$1);

return statearr_25317;
})();
if(cljs.core.truth_(inst_25243)){
var statearr_25318_25362 = state_25311__$1;
(statearr_25318_25362[(1)] = (5));

} else {
var statearr_25319_25363 = state_25311__$1;
(statearr_25319_25363[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (15))){
var inst_25284 = (state_25311[(2)]);
var state_25311__$1 = state_25311;
var statearr_25320_25364 = state_25311__$1;
(statearr_25320_25364[(2)] = inst_25284);

(statearr_25320_25364[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (21))){
var inst_25304 = (state_25311[(2)]);
var state_25311__$1 = (function (){var statearr_25321 = state_25311;
(statearr_25321[(9)] = inst_25304);

return statearr_25321;
})();
var statearr_25322_25365 = state_25311__$1;
(statearr_25322_25365[(2)] = null);

(statearr_25322_25365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (13))){
var inst_25266 = (state_25311[(10)]);
var inst_25268 = cljs.core.chunked_seq_QMARK_.call(null,inst_25266);
var state_25311__$1 = state_25311;
if(inst_25268){
var statearr_25323_25366 = state_25311__$1;
(statearr_25323_25366[(1)] = (16));

} else {
var statearr_25324_25367 = state_25311__$1;
(statearr_25324_25367[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (22))){
var inst_25296 = (state_25311[(2)]);
var state_25311__$1 = state_25311;
if(cljs.core.truth_(inst_25296)){
var statearr_25325_25368 = state_25311__$1;
(statearr_25325_25368[(1)] = (23));

} else {
var statearr_25326_25369 = state_25311__$1;
(statearr_25326_25369[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (6))){
var inst_25242 = (state_25311[(8)]);
var inst_25292 = (state_25311[(11)]);
var inst_25290 = (state_25311[(7)]);
var inst_25290__$1 = topic_fn.call(null,inst_25242);
var inst_25291 = cljs.core.deref.call(null,mults);
var inst_25292__$1 = cljs.core.get.call(null,inst_25291,inst_25290__$1);
var state_25311__$1 = (function (){var statearr_25327 = state_25311;
(statearr_25327[(11)] = inst_25292__$1);

(statearr_25327[(7)] = inst_25290__$1);

return statearr_25327;
})();
if(cljs.core.truth_(inst_25292__$1)){
var statearr_25328_25370 = state_25311__$1;
(statearr_25328_25370[(1)] = (19));

} else {
var statearr_25329_25371 = state_25311__$1;
(statearr_25329_25371[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (25))){
var inst_25301 = (state_25311[(2)]);
var state_25311__$1 = state_25311;
var statearr_25330_25372 = state_25311__$1;
(statearr_25330_25372[(2)] = inst_25301);

(statearr_25330_25372[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (17))){
var inst_25266 = (state_25311[(10)]);
var inst_25275 = cljs.core.first.call(null,inst_25266);
var inst_25276 = cljs.core.async.muxch_STAR_.call(null,inst_25275);
var inst_25277 = cljs.core.async.close_BANG_.call(null,inst_25276);
var inst_25278 = cljs.core.next.call(null,inst_25266);
var inst_25252 = inst_25278;
var inst_25253 = null;
var inst_25254 = (0);
var inst_25255 = (0);
var state_25311__$1 = (function (){var statearr_25331 = state_25311;
(statearr_25331[(12)] = inst_25255);

(statearr_25331[(13)] = inst_25254);

(statearr_25331[(14)] = inst_25252);

(statearr_25331[(15)] = inst_25277);

(statearr_25331[(16)] = inst_25253);

return statearr_25331;
})();
var statearr_25332_25373 = state_25311__$1;
(statearr_25332_25373[(2)] = null);

(statearr_25332_25373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (3))){
var inst_25309 = (state_25311[(2)]);
var state_25311__$1 = state_25311;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25311__$1,inst_25309);
} else {
if((state_val_25312 === (12))){
var inst_25286 = (state_25311[(2)]);
var state_25311__$1 = state_25311;
var statearr_25333_25374 = state_25311__$1;
(statearr_25333_25374[(2)] = inst_25286);

(statearr_25333_25374[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (2))){
var state_25311__$1 = state_25311;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25311__$1,(4),ch);
} else {
if((state_val_25312 === (23))){
var state_25311__$1 = state_25311;
var statearr_25334_25375 = state_25311__$1;
(statearr_25334_25375[(2)] = null);

(statearr_25334_25375[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (19))){
var inst_25242 = (state_25311[(8)]);
var inst_25292 = (state_25311[(11)]);
var inst_25294 = cljs.core.async.muxch_STAR_.call(null,inst_25292);
var state_25311__$1 = state_25311;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25311__$1,(22),inst_25294,inst_25242);
} else {
if((state_val_25312 === (11))){
var inst_25252 = (state_25311[(14)]);
var inst_25266 = (state_25311[(10)]);
var inst_25266__$1 = cljs.core.seq.call(null,inst_25252);
var state_25311__$1 = (function (){var statearr_25335 = state_25311;
(statearr_25335[(10)] = inst_25266__$1);

return statearr_25335;
})();
if(inst_25266__$1){
var statearr_25336_25376 = state_25311__$1;
(statearr_25336_25376[(1)] = (13));

} else {
var statearr_25337_25377 = state_25311__$1;
(statearr_25337_25377[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (9))){
var inst_25288 = (state_25311[(2)]);
var state_25311__$1 = state_25311;
var statearr_25338_25378 = state_25311__$1;
(statearr_25338_25378[(2)] = inst_25288);

(statearr_25338_25378[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (5))){
var inst_25249 = cljs.core.deref.call(null,mults);
var inst_25250 = cljs.core.vals.call(null,inst_25249);
var inst_25251 = cljs.core.seq.call(null,inst_25250);
var inst_25252 = inst_25251;
var inst_25253 = null;
var inst_25254 = (0);
var inst_25255 = (0);
var state_25311__$1 = (function (){var statearr_25339 = state_25311;
(statearr_25339[(12)] = inst_25255);

(statearr_25339[(13)] = inst_25254);

(statearr_25339[(14)] = inst_25252);

(statearr_25339[(16)] = inst_25253);

return statearr_25339;
})();
var statearr_25340_25379 = state_25311__$1;
(statearr_25340_25379[(2)] = null);

(statearr_25340_25379[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (14))){
var state_25311__$1 = state_25311;
var statearr_25344_25380 = state_25311__$1;
(statearr_25344_25380[(2)] = null);

(statearr_25344_25380[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (16))){
var inst_25266 = (state_25311[(10)]);
var inst_25270 = cljs.core.chunk_first.call(null,inst_25266);
var inst_25271 = cljs.core.chunk_rest.call(null,inst_25266);
var inst_25272 = cljs.core.count.call(null,inst_25270);
var inst_25252 = inst_25271;
var inst_25253 = inst_25270;
var inst_25254 = inst_25272;
var inst_25255 = (0);
var state_25311__$1 = (function (){var statearr_25345 = state_25311;
(statearr_25345[(12)] = inst_25255);

(statearr_25345[(13)] = inst_25254);

(statearr_25345[(14)] = inst_25252);

(statearr_25345[(16)] = inst_25253);

return statearr_25345;
})();
var statearr_25346_25381 = state_25311__$1;
(statearr_25346_25381[(2)] = null);

(statearr_25346_25381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (10))){
var inst_25255 = (state_25311[(12)]);
var inst_25254 = (state_25311[(13)]);
var inst_25252 = (state_25311[(14)]);
var inst_25253 = (state_25311[(16)]);
var inst_25260 = cljs.core._nth.call(null,inst_25253,inst_25255);
var inst_25261 = cljs.core.async.muxch_STAR_.call(null,inst_25260);
var inst_25262 = cljs.core.async.close_BANG_.call(null,inst_25261);
var inst_25263 = (inst_25255 + (1));
var tmp25341 = inst_25254;
var tmp25342 = inst_25252;
var tmp25343 = inst_25253;
var inst_25252__$1 = tmp25342;
var inst_25253__$1 = tmp25343;
var inst_25254__$1 = tmp25341;
var inst_25255__$1 = inst_25263;
var state_25311__$1 = (function (){var statearr_25347 = state_25311;
(statearr_25347[(12)] = inst_25255__$1);

(statearr_25347[(17)] = inst_25262);

(statearr_25347[(13)] = inst_25254__$1);

(statearr_25347[(14)] = inst_25252__$1);

(statearr_25347[(16)] = inst_25253__$1);

return statearr_25347;
})();
var statearr_25348_25382 = state_25311__$1;
(statearr_25348_25382[(2)] = null);

(statearr_25348_25382[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (18))){
var inst_25281 = (state_25311[(2)]);
var state_25311__$1 = state_25311;
var statearr_25349_25383 = state_25311__$1;
(statearr_25349_25383[(2)] = inst_25281);

(statearr_25349_25383[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25312 === (8))){
var inst_25255 = (state_25311[(12)]);
var inst_25254 = (state_25311[(13)]);
var inst_25257 = (inst_25255 < inst_25254);
var inst_25258 = inst_25257;
var state_25311__$1 = state_25311;
if(cljs.core.truth_(inst_25258)){
var statearr_25350_25384 = state_25311__$1;
(statearr_25350_25384[(1)] = (10));

} else {
var statearr_25351_25385 = state_25311__$1;
(statearr_25351_25385[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___25357,mults,ensure_mult,p))
;
return ((function (switch__24028__auto__,c__24123__auto___25357,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_25352 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25352[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_25352[(1)] = (1));

return statearr_25352;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_25311){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25311);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e25353){if((e25353 instanceof Object)){
var ex__24032__auto__ = e25353;
var statearr_25354_25386 = state_25311;
(statearr_25354_25386[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25311);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25353;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25387 = state_25311;
state_25311 = G__25387;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_25311){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_25311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___25357,mults,ensure_mult,p))
})();
var state__24125__auto__ = (function (){var statearr_25355 = f__24124__auto__.call(null);
(statearr_25355[(6)] = c__24123__auto___25357);

return statearr_25355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___25357,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__25389 = arguments.length;
switch (G__25389) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__25392 = arguments.length;
switch (G__25392) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__25395 = arguments.length;
switch (G__25395) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__24123__auto___25462 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___25462,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___25462,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_25434){
var state_val_25435 = (state_25434[(1)]);
if((state_val_25435 === (7))){
var state_25434__$1 = state_25434;
var statearr_25436_25463 = state_25434__$1;
(statearr_25436_25463[(2)] = null);

(statearr_25436_25463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (1))){
var state_25434__$1 = state_25434;
var statearr_25437_25464 = state_25434__$1;
(statearr_25437_25464[(2)] = null);

(statearr_25437_25464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (4))){
var inst_25398 = (state_25434[(7)]);
var inst_25400 = (inst_25398 < cnt);
var state_25434__$1 = state_25434;
if(cljs.core.truth_(inst_25400)){
var statearr_25438_25465 = state_25434__$1;
(statearr_25438_25465[(1)] = (6));

} else {
var statearr_25439_25466 = state_25434__$1;
(statearr_25439_25466[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (15))){
var inst_25430 = (state_25434[(2)]);
var state_25434__$1 = state_25434;
var statearr_25440_25467 = state_25434__$1;
(statearr_25440_25467[(2)] = inst_25430);

(statearr_25440_25467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (13))){
var inst_25423 = cljs.core.async.close_BANG_.call(null,out);
var state_25434__$1 = state_25434;
var statearr_25441_25468 = state_25434__$1;
(statearr_25441_25468[(2)] = inst_25423);

(statearr_25441_25468[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (6))){
var state_25434__$1 = state_25434;
var statearr_25442_25469 = state_25434__$1;
(statearr_25442_25469[(2)] = null);

(statearr_25442_25469[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (3))){
var inst_25432 = (state_25434[(2)]);
var state_25434__$1 = state_25434;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25434__$1,inst_25432);
} else {
if((state_val_25435 === (12))){
var inst_25420 = (state_25434[(8)]);
var inst_25420__$1 = (state_25434[(2)]);
var inst_25421 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_25420__$1);
var state_25434__$1 = (function (){var statearr_25443 = state_25434;
(statearr_25443[(8)] = inst_25420__$1);

return statearr_25443;
})();
if(cljs.core.truth_(inst_25421)){
var statearr_25444_25470 = state_25434__$1;
(statearr_25444_25470[(1)] = (13));

} else {
var statearr_25445_25471 = state_25434__$1;
(statearr_25445_25471[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (2))){
var inst_25397 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_25398 = (0);
var state_25434__$1 = (function (){var statearr_25446 = state_25434;
(statearr_25446[(9)] = inst_25397);

(statearr_25446[(7)] = inst_25398);

return statearr_25446;
})();
var statearr_25447_25472 = state_25434__$1;
(statearr_25447_25472[(2)] = null);

(statearr_25447_25472[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (11))){
var inst_25398 = (state_25434[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_25434,(10),Object,null,(9));
var inst_25407 = chs__$1.call(null,inst_25398);
var inst_25408 = done.call(null,inst_25398);
var inst_25409 = cljs.core.async.take_BANG_.call(null,inst_25407,inst_25408);
var state_25434__$1 = state_25434;
var statearr_25448_25473 = state_25434__$1;
(statearr_25448_25473[(2)] = inst_25409);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25434__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (9))){
var inst_25398 = (state_25434[(7)]);
var inst_25411 = (state_25434[(2)]);
var inst_25412 = (inst_25398 + (1));
var inst_25398__$1 = inst_25412;
var state_25434__$1 = (function (){var statearr_25449 = state_25434;
(statearr_25449[(10)] = inst_25411);

(statearr_25449[(7)] = inst_25398__$1);

return statearr_25449;
})();
var statearr_25450_25474 = state_25434__$1;
(statearr_25450_25474[(2)] = null);

(statearr_25450_25474[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (5))){
var inst_25418 = (state_25434[(2)]);
var state_25434__$1 = (function (){var statearr_25451 = state_25434;
(statearr_25451[(11)] = inst_25418);

return statearr_25451;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25434__$1,(12),dchan);
} else {
if((state_val_25435 === (14))){
var inst_25420 = (state_25434[(8)]);
var inst_25425 = cljs.core.apply.call(null,f,inst_25420);
var state_25434__$1 = state_25434;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25434__$1,(16),out,inst_25425);
} else {
if((state_val_25435 === (16))){
var inst_25427 = (state_25434[(2)]);
var state_25434__$1 = (function (){var statearr_25452 = state_25434;
(statearr_25452[(12)] = inst_25427);

return statearr_25452;
})();
var statearr_25453_25475 = state_25434__$1;
(statearr_25453_25475[(2)] = null);

(statearr_25453_25475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (10))){
var inst_25402 = (state_25434[(2)]);
var inst_25403 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_25434__$1 = (function (){var statearr_25454 = state_25434;
(statearr_25454[(13)] = inst_25402);

return statearr_25454;
})();
var statearr_25455_25476 = state_25434__$1;
(statearr_25455_25476[(2)] = inst_25403);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25434__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25435 === (8))){
var inst_25416 = (state_25434[(2)]);
var state_25434__$1 = state_25434;
var statearr_25456_25477 = state_25434__$1;
(statearr_25456_25477[(2)] = inst_25416);

(statearr_25456_25477[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___25462,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__24028__auto__,c__24123__auto___25462,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_25457 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25457[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_25457[(1)] = (1));

return statearr_25457;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_25434){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25434);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e25458){if((e25458 instanceof Object)){
var ex__24032__auto__ = e25458;
var statearr_25459_25478 = state_25434;
(statearr_25459_25478[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25434);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25458;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25479 = state_25434;
state_25434 = G__25479;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_25434){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_25434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___25462,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__24125__auto__ = (function (){var statearr_25460 = f__24124__auto__.call(null);
(statearr_25460[(6)] = c__24123__auto___25462);

return statearr_25460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___25462,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__25482 = arguments.length;
switch (G__25482) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24123__auto___25536 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___25536,out){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___25536,out){
return (function (state_25514){
var state_val_25515 = (state_25514[(1)]);
if((state_val_25515 === (7))){
var inst_25494 = (state_25514[(7)]);
var inst_25493 = (state_25514[(8)]);
var inst_25493__$1 = (state_25514[(2)]);
var inst_25494__$1 = cljs.core.nth.call(null,inst_25493__$1,(0),null);
var inst_25495 = cljs.core.nth.call(null,inst_25493__$1,(1),null);
var inst_25496 = (inst_25494__$1 == null);
var state_25514__$1 = (function (){var statearr_25516 = state_25514;
(statearr_25516[(7)] = inst_25494__$1);

(statearr_25516[(8)] = inst_25493__$1);

(statearr_25516[(9)] = inst_25495);

return statearr_25516;
})();
if(cljs.core.truth_(inst_25496)){
var statearr_25517_25537 = state_25514__$1;
(statearr_25517_25537[(1)] = (8));

} else {
var statearr_25518_25538 = state_25514__$1;
(statearr_25518_25538[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25515 === (1))){
var inst_25483 = cljs.core.vec.call(null,chs);
var inst_25484 = inst_25483;
var state_25514__$1 = (function (){var statearr_25519 = state_25514;
(statearr_25519[(10)] = inst_25484);

return statearr_25519;
})();
var statearr_25520_25539 = state_25514__$1;
(statearr_25520_25539[(2)] = null);

(statearr_25520_25539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25515 === (4))){
var inst_25484 = (state_25514[(10)]);
var state_25514__$1 = state_25514;
return cljs.core.async.ioc_alts_BANG_.call(null,state_25514__$1,(7),inst_25484);
} else {
if((state_val_25515 === (6))){
var inst_25510 = (state_25514[(2)]);
var state_25514__$1 = state_25514;
var statearr_25521_25540 = state_25514__$1;
(statearr_25521_25540[(2)] = inst_25510);

(statearr_25521_25540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25515 === (3))){
var inst_25512 = (state_25514[(2)]);
var state_25514__$1 = state_25514;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25514__$1,inst_25512);
} else {
if((state_val_25515 === (2))){
var inst_25484 = (state_25514[(10)]);
var inst_25486 = cljs.core.count.call(null,inst_25484);
var inst_25487 = (inst_25486 > (0));
var state_25514__$1 = state_25514;
if(cljs.core.truth_(inst_25487)){
var statearr_25523_25541 = state_25514__$1;
(statearr_25523_25541[(1)] = (4));

} else {
var statearr_25524_25542 = state_25514__$1;
(statearr_25524_25542[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25515 === (11))){
var inst_25484 = (state_25514[(10)]);
var inst_25503 = (state_25514[(2)]);
var tmp25522 = inst_25484;
var inst_25484__$1 = tmp25522;
var state_25514__$1 = (function (){var statearr_25525 = state_25514;
(statearr_25525[(11)] = inst_25503);

(statearr_25525[(10)] = inst_25484__$1);

return statearr_25525;
})();
var statearr_25526_25543 = state_25514__$1;
(statearr_25526_25543[(2)] = null);

(statearr_25526_25543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25515 === (9))){
var inst_25494 = (state_25514[(7)]);
var state_25514__$1 = state_25514;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25514__$1,(11),out,inst_25494);
} else {
if((state_val_25515 === (5))){
var inst_25508 = cljs.core.async.close_BANG_.call(null,out);
var state_25514__$1 = state_25514;
var statearr_25527_25544 = state_25514__$1;
(statearr_25527_25544[(2)] = inst_25508);

(statearr_25527_25544[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25515 === (10))){
var inst_25506 = (state_25514[(2)]);
var state_25514__$1 = state_25514;
var statearr_25528_25545 = state_25514__$1;
(statearr_25528_25545[(2)] = inst_25506);

(statearr_25528_25545[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25515 === (8))){
var inst_25494 = (state_25514[(7)]);
var inst_25493 = (state_25514[(8)]);
var inst_25495 = (state_25514[(9)]);
var inst_25484 = (state_25514[(10)]);
var inst_25498 = (function (){var cs = inst_25484;
var vec__25489 = inst_25493;
var v = inst_25494;
var c = inst_25495;
return ((function (cs,vec__25489,v,c,inst_25494,inst_25493,inst_25495,inst_25484,state_val_25515,c__24123__auto___25536,out){
return (function (p1__25480_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__25480_SHARP_);
});
;})(cs,vec__25489,v,c,inst_25494,inst_25493,inst_25495,inst_25484,state_val_25515,c__24123__auto___25536,out))
})();
var inst_25499 = cljs.core.filterv.call(null,inst_25498,inst_25484);
var inst_25484__$1 = inst_25499;
var state_25514__$1 = (function (){var statearr_25529 = state_25514;
(statearr_25529[(10)] = inst_25484__$1);

return statearr_25529;
})();
var statearr_25530_25546 = state_25514__$1;
(statearr_25530_25546[(2)] = null);

(statearr_25530_25546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___25536,out))
;
return ((function (switch__24028__auto__,c__24123__auto___25536,out){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_25531 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25531[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_25531[(1)] = (1));

return statearr_25531;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_25514){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25514);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e25532){if((e25532 instanceof Object)){
var ex__24032__auto__ = e25532;
var statearr_25533_25547 = state_25514;
(statearr_25533_25547[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25514);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25532;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25548 = state_25514;
state_25514 = G__25548;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_25514){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_25514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___25536,out))
})();
var state__24125__auto__ = (function (){var statearr_25534 = f__24124__auto__.call(null);
(statearr_25534[(6)] = c__24123__auto___25536);

return statearr_25534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___25536,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__25550 = arguments.length;
switch (G__25550) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24123__auto___25595 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___25595,out){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___25595,out){
return (function (state_25574){
var state_val_25575 = (state_25574[(1)]);
if((state_val_25575 === (7))){
var inst_25556 = (state_25574[(7)]);
var inst_25556__$1 = (state_25574[(2)]);
var inst_25557 = (inst_25556__$1 == null);
var inst_25558 = cljs.core.not.call(null,inst_25557);
var state_25574__$1 = (function (){var statearr_25576 = state_25574;
(statearr_25576[(7)] = inst_25556__$1);

return statearr_25576;
})();
if(inst_25558){
var statearr_25577_25596 = state_25574__$1;
(statearr_25577_25596[(1)] = (8));

} else {
var statearr_25578_25597 = state_25574__$1;
(statearr_25578_25597[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25575 === (1))){
var inst_25551 = (0);
var state_25574__$1 = (function (){var statearr_25579 = state_25574;
(statearr_25579[(8)] = inst_25551);

return statearr_25579;
})();
var statearr_25580_25598 = state_25574__$1;
(statearr_25580_25598[(2)] = null);

(statearr_25580_25598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25575 === (4))){
var state_25574__$1 = state_25574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25574__$1,(7),ch);
} else {
if((state_val_25575 === (6))){
var inst_25569 = (state_25574[(2)]);
var state_25574__$1 = state_25574;
var statearr_25581_25599 = state_25574__$1;
(statearr_25581_25599[(2)] = inst_25569);

(statearr_25581_25599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25575 === (3))){
var inst_25571 = (state_25574[(2)]);
var inst_25572 = cljs.core.async.close_BANG_.call(null,out);
var state_25574__$1 = (function (){var statearr_25582 = state_25574;
(statearr_25582[(9)] = inst_25571);

return statearr_25582;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25574__$1,inst_25572);
} else {
if((state_val_25575 === (2))){
var inst_25551 = (state_25574[(8)]);
var inst_25553 = (inst_25551 < n);
var state_25574__$1 = state_25574;
if(cljs.core.truth_(inst_25553)){
var statearr_25583_25600 = state_25574__$1;
(statearr_25583_25600[(1)] = (4));

} else {
var statearr_25584_25601 = state_25574__$1;
(statearr_25584_25601[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25575 === (11))){
var inst_25551 = (state_25574[(8)]);
var inst_25561 = (state_25574[(2)]);
var inst_25562 = (inst_25551 + (1));
var inst_25551__$1 = inst_25562;
var state_25574__$1 = (function (){var statearr_25585 = state_25574;
(statearr_25585[(8)] = inst_25551__$1);

(statearr_25585[(10)] = inst_25561);

return statearr_25585;
})();
var statearr_25586_25602 = state_25574__$1;
(statearr_25586_25602[(2)] = null);

(statearr_25586_25602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25575 === (9))){
var state_25574__$1 = state_25574;
var statearr_25587_25603 = state_25574__$1;
(statearr_25587_25603[(2)] = null);

(statearr_25587_25603[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25575 === (5))){
var state_25574__$1 = state_25574;
var statearr_25588_25604 = state_25574__$1;
(statearr_25588_25604[(2)] = null);

(statearr_25588_25604[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25575 === (10))){
var inst_25566 = (state_25574[(2)]);
var state_25574__$1 = state_25574;
var statearr_25589_25605 = state_25574__$1;
(statearr_25589_25605[(2)] = inst_25566);

(statearr_25589_25605[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25575 === (8))){
var inst_25556 = (state_25574[(7)]);
var state_25574__$1 = state_25574;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25574__$1,(11),out,inst_25556);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___25595,out))
;
return ((function (switch__24028__auto__,c__24123__auto___25595,out){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_25590 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25590[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_25590[(1)] = (1));

return statearr_25590;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_25574){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25574);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e25591){if((e25591 instanceof Object)){
var ex__24032__auto__ = e25591;
var statearr_25592_25606 = state_25574;
(statearr_25592_25606[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25574);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25591;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25607 = state_25574;
state_25574 = G__25607;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_25574){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_25574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___25595,out))
})();
var state__24125__auto__ = (function (){var statearr_25593 = f__24124__auto__.call(null);
(statearr_25593[(6)] = c__24123__auto___25595);

return statearr_25593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___25595,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25609 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25609 = (function (f,ch,meta25610){
this.f = f;
this.ch = ch;
this.meta25610 = meta25610;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25609.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25611,meta25610__$1){
var self__ = this;
var _25611__$1 = this;
return (new cljs.core.async.t_cljs$core$async25609(self__.f,self__.ch,meta25610__$1));
});

cljs.core.async.t_cljs$core$async25609.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25611){
var self__ = this;
var _25611__$1 = this;
return self__.meta25610;
});

cljs.core.async.t_cljs$core$async25609.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25609.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25609.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25609.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25609.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25612 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25612 = (function (f,ch,meta25610,_,fn1,meta25613){
this.f = f;
this.ch = ch;
this.meta25610 = meta25610;
this._ = _;
this.fn1 = fn1;
this.meta25613 = meta25613;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25612.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_25614,meta25613__$1){
var self__ = this;
var _25614__$1 = this;
return (new cljs.core.async.t_cljs$core$async25612(self__.f,self__.ch,self__.meta25610,self__._,self__.fn1,meta25613__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async25612.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_25614){
var self__ = this;
var _25614__$1 = this;
return self__.meta25613;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25612.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25612.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25612.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25612.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__25608_SHARP_){
return f1.call(null,(((p1__25608_SHARP_ == null))?null:self__.f.call(null,p1__25608_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async25612.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25610","meta25610",-625552034,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async25609","cljs.core.async/t_cljs$core$async25609",1833762680,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta25613","meta25613",1942514215,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25612.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25612.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25612";

cljs.core.async.t_cljs$core$async25612.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async25612");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25612.
 */
cljs.core.async.__GT_t_cljs$core$async25612 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25612(f__$1,ch__$1,meta25610__$1,___$2,fn1__$1,meta25613){
return (new cljs.core.async.t_cljs$core$async25612(f__$1,ch__$1,meta25610__$1,___$2,fn1__$1,meta25613));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async25612(self__.f,self__.ch,self__.meta25610,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async25609.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25609.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async25609.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25610","meta25610",-625552034,null)], null);
});

cljs.core.async.t_cljs$core$async25609.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25609.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25609";

cljs.core.async.t_cljs$core$async25609.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async25609");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25609.
 */
cljs.core.async.__GT_t_cljs$core$async25609 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25609(f__$1,ch__$1,meta25610){
return (new cljs.core.async.t_cljs$core$async25609(f__$1,ch__$1,meta25610));
});

}

return (new cljs.core.async.t_cljs$core$async25609(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25615 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25615 = (function (f,ch,meta25616){
this.f = f;
this.ch = ch;
this.meta25616 = meta25616;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25615.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25617,meta25616__$1){
var self__ = this;
var _25617__$1 = this;
return (new cljs.core.async.t_cljs$core$async25615(self__.f,self__.ch,meta25616__$1));
});

cljs.core.async.t_cljs$core$async25615.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25617){
var self__ = this;
var _25617__$1 = this;
return self__.meta25616;
});

cljs.core.async.t_cljs$core$async25615.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25615.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25615.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25615.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25615.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25615.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async25615.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25616","meta25616",1449041658,null)], null);
});

cljs.core.async.t_cljs$core$async25615.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25615.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25615";

cljs.core.async.t_cljs$core$async25615.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async25615");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25615.
 */
cljs.core.async.__GT_t_cljs$core$async25615 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async25615(f__$1,ch__$1,meta25616){
return (new cljs.core.async.t_cljs$core$async25615(f__$1,ch__$1,meta25616));
});

}

return (new cljs.core.async.t_cljs$core$async25615(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25618 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25618 = (function (p,ch,meta25619){
this.p = p;
this.ch = ch;
this.meta25619 = meta25619;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25618.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25620,meta25619__$1){
var self__ = this;
var _25620__$1 = this;
return (new cljs.core.async.t_cljs$core$async25618(self__.p,self__.ch,meta25619__$1));
});

cljs.core.async.t_cljs$core$async25618.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25620){
var self__ = this;
var _25620__$1 = this;
return self__.meta25619;
});

cljs.core.async.t_cljs$core$async25618.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25618.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25618.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25618.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25618.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25618.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25618.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async25618.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25619","meta25619",926315141,null)], null);
});

cljs.core.async.t_cljs$core$async25618.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25618.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25618";

cljs.core.async.t_cljs$core$async25618.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async25618");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25618.
 */
cljs.core.async.__GT_t_cljs$core$async25618 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async25618(p__$1,ch__$1,meta25619){
return (new cljs.core.async.t_cljs$core$async25618(p__$1,ch__$1,meta25619));
});

}

return (new cljs.core.async.t_cljs$core$async25618(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__25622 = arguments.length;
switch (G__25622) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24123__auto___25662 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___25662,out){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___25662,out){
return (function (state_25643){
var state_val_25644 = (state_25643[(1)]);
if((state_val_25644 === (7))){
var inst_25639 = (state_25643[(2)]);
var state_25643__$1 = state_25643;
var statearr_25645_25663 = state_25643__$1;
(statearr_25645_25663[(2)] = inst_25639);

(statearr_25645_25663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25644 === (1))){
var state_25643__$1 = state_25643;
var statearr_25646_25664 = state_25643__$1;
(statearr_25646_25664[(2)] = null);

(statearr_25646_25664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25644 === (4))){
var inst_25625 = (state_25643[(7)]);
var inst_25625__$1 = (state_25643[(2)]);
var inst_25626 = (inst_25625__$1 == null);
var state_25643__$1 = (function (){var statearr_25647 = state_25643;
(statearr_25647[(7)] = inst_25625__$1);

return statearr_25647;
})();
if(cljs.core.truth_(inst_25626)){
var statearr_25648_25665 = state_25643__$1;
(statearr_25648_25665[(1)] = (5));

} else {
var statearr_25649_25666 = state_25643__$1;
(statearr_25649_25666[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25644 === (6))){
var inst_25625 = (state_25643[(7)]);
var inst_25630 = p.call(null,inst_25625);
var state_25643__$1 = state_25643;
if(cljs.core.truth_(inst_25630)){
var statearr_25650_25667 = state_25643__$1;
(statearr_25650_25667[(1)] = (8));

} else {
var statearr_25651_25668 = state_25643__$1;
(statearr_25651_25668[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25644 === (3))){
var inst_25641 = (state_25643[(2)]);
var state_25643__$1 = state_25643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25643__$1,inst_25641);
} else {
if((state_val_25644 === (2))){
var state_25643__$1 = state_25643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25643__$1,(4),ch);
} else {
if((state_val_25644 === (11))){
var inst_25633 = (state_25643[(2)]);
var state_25643__$1 = state_25643;
var statearr_25652_25669 = state_25643__$1;
(statearr_25652_25669[(2)] = inst_25633);

(statearr_25652_25669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25644 === (9))){
var state_25643__$1 = state_25643;
var statearr_25653_25670 = state_25643__$1;
(statearr_25653_25670[(2)] = null);

(statearr_25653_25670[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25644 === (5))){
var inst_25628 = cljs.core.async.close_BANG_.call(null,out);
var state_25643__$1 = state_25643;
var statearr_25654_25671 = state_25643__$1;
(statearr_25654_25671[(2)] = inst_25628);

(statearr_25654_25671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25644 === (10))){
var inst_25636 = (state_25643[(2)]);
var state_25643__$1 = (function (){var statearr_25655 = state_25643;
(statearr_25655[(8)] = inst_25636);

return statearr_25655;
})();
var statearr_25656_25672 = state_25643__$1;
(statearr_25656_25672[(2)] = null);

(statearr_25656_25672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25644 === (8))){
var inst_25625 = (state_25643[(7)]);
var state_25643__$1 = state_25643;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25643__$1,(11),out,inst_25625);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___25662,out))
;
return ((function (switch__24028__auto__,c__24123__auto___25662,out){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_25657 = [null,null,null,null,null,null,null,null,null];
(statearr_25657[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_25657[(1)] = (1));

return statearr_25657;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_25643){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e25658){if((e25658 instanceof Object)){
var ex__24032__auto__ = e25658;
var statearr_25659_25673 = state_25643;
(statearr_25659_25673[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25643);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25658;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25674 = state_25643;
state_25643 = G__25674;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_25643){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_25643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___25662,out))
})();
var state__24125__auto__ = (function (){var statearr_25660 = f__24124__auto__.call(null);
(statearr_25660[(6)] = c__24123__auto___25662);

return statearr_25660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___25662,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__25676 = arguments.length;
switch (G__25676) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__24123__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto__){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto__){
return (function (state_25739){
var state_val_25740 = (state_25739[(1)]);
if((state_val_25740 === (7))){
var inst_25735 = (state_25739[(2)]);
var state_25739__$1 = state_25739;
var statearr_25741_25779 = state_25739__$1;
(statearr_25741_25779[(2)] = inst_25735);

(statearr_25741_25779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (20))){
var inst_25705 = (state_25739[(7)]);
var inst_25716 = (state_25739[(2)]);
var inst_25717 = cljs.core.next.call(null,inst_25705);
var inst_25691 = inst_25717;
var inst_25692 = null;
var inst_25693 = (0);
var inst_25694 = (0);
var state_25739__$1 = (function (){var statearr_25742 = state_25739;
(statearr_25742[(8)] = inst_25693);

(statearr_25742[(9)] = inst_25692);

(statearr_25742[(10)] = inst_25691);

(statearr_25742[(11)] = inst_25694);

(statearr_25742[(12)] = inst_25716);

return statearr_25742;
})();
var statearr_25743_25780 = state_25739__$1;
(statearr_25743_25780[(2)] = null);

(statearr_25743_25780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (1))){
var state_25739__$1 = state_25739;
var statearr_25744_25781 = state_25739__$1;
(statearr_25744_25781[(2)] = null);

(statearr_25744_25781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (4))){
var inst_25680 = (state_25739[(13)]);
var inst_25680__$1 = (state_25739[(2)]);
var inst_25681 = (inst_25680__$1 == null);
var state_25739__$1 = (function (){var statearr_25745 = state_25739;
(statearr_25745[(13)] = inst_25680__$1);

return statearr_25745;
})();
if(cljs.core.truth_(inst_25681)){
var statearr_25746_25782 = state_25739__$1;
(statearr_25746_25782[(1)] = (5));

} else {
var statearr_25747_25783 = state_25739__$1;
(statearr_25747_25783[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (15))){
var state_25739__$1 = state_25739;
var statearr_25751_25784 = state_25739__$1;
(statearr_25751_25784[(2)] = null);

(statearr_25751_25784[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (21))){
var state_25739__$1 = state_25739;
var statearr_25752_25785 = state_25739__$1;
(statearr_25752_25785[(2)] = null);

(statearr_25752_25785[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (13))){
var inst_25693 = (state_25739[(8)]);
var inst_25692 = (state_25739[(9)]);
var inst_25691 = (state_25739[(10)]);
var inst_25694 = (state_25739[(11)]);
var inst_25701 = (state_25739[(2)]);
var inst_25702 = (inst_25694 + (1));
var tmp25748 = inst_25693;
var tmp25749 = inst_25692;
var tmp25750 = inst_25691;
var inst_25691__$1 = tmp25750;
var inst_25692__$1 = tmp25749;
var inst_25693__$1 = tmp25748;
var inst_25694__$1 = inst_25702;
var state_25739__$1 = (function (){var statearr_25753 = state_25739;
(statearr_25753[(8)] = inst_25693__$1);

(statearr_25753[(9)] = inst_25692__$1);

(statearr_25753[(14)] = inst_25701);

(statearr_25753[(10)] = inst_25691__$1);

(statearr_25753[(11)] = inst_25694__$1);

return statearr_25753;
})();
var statearr_25754_25786 = state_25739__$1;
(statearr_25754_25786[(2)] = null);

(statearr_25754_25786[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (22))){
var state_25739__$1 = state_25739;
var statearr_25755_25787 = state_25739__$1;
(statearr_25755_25787[(2)] = null);

(statearr_25755_25787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (6))){
var inst_25680 = (state_25739[(13)]);
var inst_25689 = f.call(null,inst_25680);
var inst_25690 = cljs.core.seq.call(null,inst_25689);
var inst_25691 = inst_25690;
var inst_25692 = null;
var inst_25693 = (0);
var inst_25694 = (0);
var state_25739__$1 = (function (){var statearr_25756 = state_25739;
(statearr_25756[(8)] = inst_25693);

(statearr_25756[(9)] = inst_25692);

(statearr_25756[(10)] = inst_25691);

(statearr_25756[(11)] = inst_25694);

return statearr_25756;
})();
var statearr_25757_25788 = state_25739__$1;
(statearr_25757_25788[(2)] = null);

(statearr_25757_25788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (17))){
var inst_25705 = (state_25739[(7)]);
var inst_25709 = cljs.core.chunk_first.call(null,inst_25705);
var inst_25710 = cljs.core.chunk_rest.call(null,inst_25705);
var inst_25711 = cljs.core.count.call(null,inst_25709);
var inst_25691 = inst_25710;
var inst_25692 = inst_25709;
var inst_25693 = inst_25711;
var inst_25694 = (0);
var state_25739__$1 = (function (){var statearr_25758 = state_25739;
(statearr_25758[(8)] = inst_25693);

(statearr_25758[(9)] = inst_25692);

(statearr_25758[(10)] = inst_25691);

(statearr_25758[(11)] = inst_25694);

return statearr_25758;
})();
var statearr_25759_25789 = state_25739__$1;
(statearr_25759_25789[(2)] = null);

(statearr_25759_25789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (3))){
var inst_25737 = (state_25739[(2)]);
var state_25739__$1 = state_25739;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25739__$1,inst_25737);
} else {
if((state_val_25740 === (12))){
var inst_25725 = (state_25739[(2)]);
var state_25739__$1 = state_25739;
var statearr_25760_25790 = state_25739__$1;
(statearr_25760_25790[(2)] = inst_25725);

(statearr_25760_25790[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (2))){
var state_25739__$1 = state_25739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25739__$1,(4),in$);
} else {
if((state_val_25740 === (23))){
var inst_25733 = (state_25739[(2)]);
var state_25739__$1 = state_25739;
var statearr_25761_25791 = state_25739__$1;
(statearr_25761_25791[(2)] = inst_25733);

(statearr_25761_25791[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (19))){
var inst_25720 = (state_25739[(2)]);
var state_25739__$1 = state_25739;
var statearr_25762_25792 = state_25739__$1;
(statearr_25762_25792[(2)] = inst_25720);

(statearr_25762_25792[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (11))){
var inst_25705 = (state_25739[(7)]);
var inst_25691 = (state_25739[(10)]);
var inst_25705__$1 = cljs.core.seq.call(null,inst_25691);
var state_25739__$1 = (function (){var statearr_25763 = state_25739;
(statearr_25763[(7)] = inst_25705__$1);

return statearr_25763;
})();
if(inst_25705__$1){
var statearr_25764_25793 = state_25739__$1;
(statearr_25764_25793[(1)] = (14));

} else {
var statearr_25765_25794 = state_25739__$1;
(statearr_25765_25794[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (9))){
var inst_25727 = (state_25739[(2)]);
var inst_25728 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_25739__$1 = (function (){var statearr_25766 = state_25739;
(statearr_25766[(15)] = inst_25727);

return statearr_25766;
})();
if(cljs.core.truth_(inst_25728)){
var statearr_25767_25795 = state_25739__$1;
(statearr_25767_25795[(1)] = (21));

} else {
var statearr_25768_25796 = state_25739__$1;
(statearr_25768_25796[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (5))){
var inst_25683 = cljs.core.async.close_BANG_.call(null,out);
var state_25739__$1 = state_25739;
var statearr_25769_25797 = state_25739__$1;
(statearr_25769_25797[(2)] = inst_25683);

(statearr_25769_25797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (14))){
var inst_25705 = (state_25739[(7)]);
var inst_25707 = cljs.core.chunked_seq_QMARK_.call(null,inst_25705);
var state_25739__$1 = state_25739;
if(inst_25707){
var statearr_25770_25798 = state_25739__$1;
(statearr_25770_25798[(1)] = (17));

} else {
var statearr_25771_25799 = state_25739__$1;
(statearr_25771_25799[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (16))){
var inst_25723 = (state_25739[(2)]);
var state_25739__$1 = state_25739;
var statearr_25772_25800 = state_25739__$1;
(statearr_25772_25800[(2)] = inst_25723);

(statearr_25772_25800[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25740 === (10))){
var inst_25692 = (state_25739[(9)]);
var inst_25694 = (state_25739[(11)]);
var inst_25699 = cljs.core._nth.call(null,inst_25692,inst_25694);
var state_25739__$1 = state_25739;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25739__$1,(13),out,inst_25699);
} else {
if((state_val_25740 === (18))){
var inst_25705 = (state_25739[(7)]);
var inst_25714 = cljs.core.first.call(null,inst_25705);
var state_25739__$1 = state_25739;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25739__$1,(20),out,inst_25714);
} else {
if((state_val_25740 === (8))){
var inst_25693 = (state_25739[(8)]);
var inst_25694 = (state_25739[(11)]);
var inst_25696 = (inst_25694 < inst_25693);
var inst_25697 = inst_25696;
var state_25739__$1 = state_25739;
if(cljs.core.truth_(inst_25697)){
var statearr_25773_25801 = state_25739__$1;
(statearr_25773_25801[(1)] = (10));

} else {
var statearr_25774_25802 = state_25739__$1;
(statearr_25774_25802[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto__))
;
return ((function (switch__24028__auto__,c__24123__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__24029__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__24029__auto____0 = (function (){
var statearr_25775 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25775[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__24029__auto__);

(statearr_25775[(1)] = (1));

return statearr_25775;
});
var cljs$core$async$mapcat_STAR__$_state_machine__24029__auto____1 = (function (state_25739){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25739);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e25776){if((e25776 instanceof Object)){
var ex__24032__auto__ = e25776;
var statearr_25777_25803 = state_25739;
(statearr_25777_25803[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25739);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25776;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25804 = state_25739;
state_25739 = G__25804;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__24029__auto__ = function(state_25739){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__24029__auto____1.call(this,state_25739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__24029__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__24029__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto__))
})();
var state__24125__auto__ = (function (){var statearr_25778 = f__24124__auto__.call(null);
(statearr_25778[(6)] = c__24123__auto__);

return statearr_25778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto__))
);

return c__24123__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__25806 = arguments.length;
switch (G__25806) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__25809 = arguments.length;
switch (G__25809) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__25812 = arguments.length;
switch (G__25812) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24123__auto___25859 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___25859,out){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___25859,out){
return (function (state_25836){
var state_val_25837 = (state_25836[(1)]);
if((state_val_25837 === (7))){
var inst_25831 = (state_25836[(2)]);
var state_25836__$1 = state_25836;
var statearr_25838_25860 = state_25836__$1;
(statearr_25838_25860[(2)] = inst_25831);

(statearr_25838_25860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25837 === (1))){
var inst_25813 = null;
var state_25836__$1 = (function (){var statearr_25839 = state_25836;
(statearr_25839[(7)] = inst_25813);

return statearr_25839;
})();
var statearr_25840_25861 = state_25836__$1;
(statearr_25840_25861[(2)] = null);

(statearr_25840_25861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25837 === (4))){
var inst_25816 = (state_25836[(8)]);
var inst_25816__$1 = (state_25836[(2)]);
var inst_25817 = (inst_25816__$1 == null);
var inst_25818 = cljs.core.not.call(null,inst_25817);
var state_25836__$1 = (function (){var statearr_25841 = state_25836;
(statearr_25841[(8)] = inst_25816__$1);

return statearr_25841;
})();
if(inst_25818){
var statearr_25842_25862 = state_25836__$1;
(statearr_25842_25862[(1)] = (5));

} else {
var statearr_25843_25863 = state_25836__$1;
(statearr_25843_25863[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25837 === (6))){
var state_25836__$1 = state_25836;
var statearr_25844_25864 = state_25836__$1;
(statearr_25844_25864[(2)] = null);

(statearr_25844_25864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25837 === (3))){
var inst_25833 = (state_25836[(2)]);
var inst_25834 = cljs.core.async.close_BANG_.call(null,out);
var state_25836__$1 = (function (){var statearr_25845 = state_25836;
(statearr_25845[(9)] = inst_25833);

return statearr_25845;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25836__$1,inst_25834);
} else {
if((state_val_25837 === (2))){
var state_25836__$1 = state_25836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25836__$1,(4),ch);
} else {
if((state_val_25837 === (11))){
var inst_25816 = (state_25836[(8)]);
var inst_25825 = (state_25836[(2)]);
var inst_25813 = inst_25816;
var state_25836__$1 = (function (){var statearr_25846 = state_25836;
(statearr_25846[(7)] = inst_25813);

(statearr_25846[(10)] = inst_25825);

return statearr_25846;
})();
var statearr_25847_25865 = state_25836__$1;
(statearr_25847_25865[(2)] = null);

(statearr_25847_25865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25837 === (9))){
var inst_25816 = (state_25836[(8)]);
var state_25836__$1 = state_25836;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25836__$1,(11),out,inst_25816);
} else {
if((state_val_25837 === (5))){
var inst_25813 = (state_25836[(7)]);
var inst_25816 = (state_25836[(8)]);
var inst_25820 = cljs.core._EQ_.call(null,inst_25816,inst_25813);
var state_25836__$1 = state_25836;
if(inst_25820){
var statearr_25849_25866 = state_25836__$1;
(statearr_25849_25866[(1)] = (8));

} else {
var statearr_25850_25867 = state_25836__$1;
(statearr_25850_25867[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25837 === (10))){
var inst_25828 = (state_25836[(2)]);
var state_25836__$1 = state_25836;
var statearr_25851_25868 = state_25836__$1;
(statearr_25851_25868[(2)] = inst_25828);

(statearr_25851_25868[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25837 === (8))){
var inst_25813 = (state_25836[(7)]);
var tmp25848 = inst_25813;
var inst_25813__$1 = tmp25848;
var state_25836__$1 = (function (){var statearr_25852 = state_25836;
(statearr_25852[(7)] = inst_25813__$1);

return statearr_25852;
})();
var statearr_25853_25869 = state_25836__$1;
(statearr_25853_25869[(2)] = null);

(statearr_25853_25869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___25859,out))
;
return ((function (switch__24028__auto__,c__24123__auto___25859,out){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_25854 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25854[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_25854[(1)] = (1));

return statearr_25854;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_25836){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25836);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e25855){if((e25855 instanceof Object)){
var ex__24032__auto__ = e25855;
var statearr_25856_25870 = state_25836;
(statearr_25856_25870[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25836);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25855;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25871 = state_25836;
state_25836 = G__25871;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_25836){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_25836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___25859,out))
})();
var state__24125__auto__ = (function (){var statearr_25857 = f__24124__auto__.call(null);
(statearr_25857[(6)] = c__24123__auto___25859);

return statearr_25857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___25859,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__25873 = arguments.length;
switch (G__25873) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24123__auto___25939 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___25939,out){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___25939,out){
return (function (state_25911){
var state_val_25912 = (state_25911[(1)]);
if((state_val_25912 === (7))){
var inst_25907 = (state_25911[(2)]);
var state_25911__$1 = state_25911;
var statearr_25913_25940 = state_25911__$1;
(statearr_25913_25940[(2)] = inst_25907);

(statearr_25913_25940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (1))){
var inst_25874 = (new Array(n));
var inst_25875 = inst_25874;
var inst_25876 = (0);
var state_25911__$1 = (function (){var statearr_25914 = state_25911;
(statearr_25914[(7)] = inst_25875);

(statearr_25914[(8)] = inst_25876);

return statearr_25914;
})();
var statearr_25915_25941 = state_25911__$1;
(statearr_25915_25941[(2)] = null);

(statearr_25915_25941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (4))){
var inst_25879 = (state_25911[(9)]);
var inst_25879__$1 = (state_25911[(2)]);
var inst_25880 = (inst_25879__$1 == null);
var inst_25881 = cljs.core.not.call(null,inst_25880);
var state_25911__$1 = (function (){var statearr_25916 = state_25911;
(statearr_25916[(9)] = inst_25879__$1);

return statearr_25916;
})();
if(inst_25881){
var statearr_25917_25942 = state_25911__$1;
(statearr_25917_25942[(1)] = (5));

} else {
var statearr_25918_25943 = state_25911__$1;
(statearr_25918_25943[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (15))){
var inst_25901 = (state_25911[(2)]);
var state_25911__$1 = state_25911;
var statearr_25919_25944 = state_25911__$1;
(statearr_25919_25944[(2)] = inst_25901);

(statearr_25919_25944[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (13))){
var state_25911__$1 = state_25911;
var statearr_25920_25945 = state_25911__$1;
(statearr_25920_25945[(2)] = null);

(statearr_25920_25945[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (6))){
var inst_25876 = (state_25911[(8)]);
var inst_25897 = (inst_25876 > (0));
var state_25911__$1 = state_25911;
if(cljs.core.truth_(inst_25897)){
var statearr_25921_25946 = state_25911__$1;
(statearr_25921_25946[(1)] = (12));

} else {
var statearr_25922_25947 = state_25911__$1;
(statearr_25922_25947[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (3))){
var inst_25909 = (state_25911[(2)]);
var state_25911__$1 = state_25911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25911__$1,inst_25909);
} else {
if((state_val_25912 === (12))){
var inst_25875 = (state_25911[(7)]);
var inst_25899 = cljs.core.vec.call(null,inst_25875);
var state_25911__$1 = state_25911;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25911__$1,(15),out,inst_25899);
} else {
if((state_val_25912 === (2))){
var state_25911__$1 = state_25911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25911__$1,(4),ch);
} else {
if((state_val_25912 === (11))){
var inst_25891 = (state_25911[(2)]);
var inst_25892 = (new Array(n));
var inst_25875 = inst_25892;
var inst_25876 = (0);
var state_25911__$1 = (function (){var statearr_25923 = state_25911;
(statearr_25923[(7)] = inst_25875);

(statearr_25923[(8)] = inst_25876);

(statearr_25923[(10)] = inst_25891);

return statearr_25923;
})();
var statearr_25924_25948 = state_25911__$1;
(statearr_25924_25948[(2)] = null);

(statearr_25924_25948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (9))){
var inst_25875 = (state_25911[(7)]);
var inst_25889 = cljs.core.vec.call(null,inst_25875);
var state_25911__$1 = state_25911;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25911__$1,(11),out,inst_25889);
} else {
if((state_val_25912 === (5))){
var inst_25875 = (state_25911[(7)]);
var inst_25884 = (state_25911[(11)]);
var inst_25876 = (state_25911[(8)]);
var inst_25879 = (state_25911[(9)]);
var inst_25883 = (inst_25875[inst_25876] = inst_25879);
var inst_25884__$1 = (inst_25876 + (1));
var inst_25885 = (inst_25884__$1 < n);
var state_25911__$1 = (function (){var statearr_25925 = state_25911;
(statearr_25925[(11)] = inst_25884__$1);

(statearr_25925[(12)] = inst_25883);

return statearr_25925;
})();
if(cljs.core.truth_(inst_25885)){
var statearr_25926_25949 = state_25911__$1;
(statearr_25926_25949[(1)] = (8));

} else {
var statearr_25927_25950 = state_25911__$1;
(statearr_25927_25950[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (14))){
var inst_25904 = (state_25911[(2)]);
var inst_25905 = cljs.core.async.close_BANG_.call(null,out);
var state_25911__$1 = (function (){var statearr_25929 = state_25911;
(statearr_25929[(13)] = inst_25904);

return statearr_25929;
})();
var statearr_25930_25951 = state_25911__$1;
(statearr_25930_25951[(2)] = inst_25905);

(statearr_25930_25951[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (10))){
var inst_25895 = (state_25911[(2)]);
var state_25911__$1 = state_25911;
var statearr_25931_25952 = state_25911__$1;
(statearr_25931_25952[(2)] = inst_25895);

(statearr_25931_25952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (8))){
var inst_25875 = (state_25911[(7)]);
var inst_25884 = (state_25911[(11)]);
var tmp25928 = inst_25875;
var inst_25875__$1 = tmp25928;
var inst_25876 = inst_25884;
var state_25911__$1 = (function (){var statearr_25932 = state_25911;
(statearr_25932[(7)] = inst_25875__$1);

(statearr_25932[(8)] = inst_25876);

return statearr_25932;
})();
var statearr_25933_25953 = state_25911__$1;
(statearr_25933_25953[(2)] = null);

(statearr_25933_25953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___25939,out))
;
return ((function (switch__24028__auto__,c__24123__auto___25939,out){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_25934 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25934[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_25934[(1)] = (1));

return statearr_25934;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_25911){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e25935){if((e25935 instanceof Object)){
var ex__24032__auto__ = e25935;
var statearr_25936_25954 = state_25911;
(statearr_25936_25954[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25911);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25935;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25955 = state_25911;
state_25911 = G__25955;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_25911){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_25911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___25939,out))
})();
var state__24125__auto__ = (function (){var statearr_25937 = f__24124__auto__.call(null);
(statearr_25937[(6)] = c__24123__auto___25939);

return statearr_25937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___25939,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__25957 = arguments.length;
switch (G__25957) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24123__auto___26027 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24123__auto___26027,out){
return (function (){
var f__24124__auto__ = (function (){var switch__24028__auto__ = ((function (c__24123__auto___26027,out){
return (function (state_25999){
var state_val_26000 = (state_25999[(1)]);
if((state_val_26000 === (7))){
var inst_25995 = (state_25999[(2)]);
var state_25999__$1 = state_25999;
var statearr_26001_26028 = state_25999__$1;
(statearr_26001_26028[(2)] = inst_25995);

(statearr_26001_26028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (1))){
var inst_25958 = [];
var inst_25959 = inst_25958;
var inst_25960 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_25999__$1 = (function (){var statearr_26002 = state_25999;
(statearr_26002[(7)] = inst_25959);

(statearr_26002[(8)] = inst_25960);

return statearr_26002;
})();
var statearr_26003_26029 = state_25999__$1;
(statearr_26003_26029[(2)] = null);

(statearr_26003_26029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (4))){
var inst_25963 = (state_25999[(9)]);
var inst_25963__$1 = (state_25999[(2)]);
var inst_25964 = (inst_25963__$1 == null);
var inst_25965 = cljs.core.not.call(null,inst_25964);
var state_25999__$1 = (function (){var statearr_26004 = state_25999;
(statearr_26004[(9)] = inst_25963__$1);

return statearr_26004;
})();
if(inst_25965){
var statearr_26005_26030 = state_25999__$1;
(statearr_26005_26030[(1)] = (5));

} else {
var statearr_26006_26031 = state_25999__$1;
(statearr_26006_26031[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (15))){
var inst_25989 = (state_25999[(2)]);
var state_25999__$1 = state_25999;
var statearr_26007_26032 = state_25999__$1;
(statearr_26007_26032[(2)] = inst_25989);

(statearr_26007_26032[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (13))){
var state_25999__$1 = state_25999;
var statearr_26008_26033 = state_25999__$1;
(statearr_26008_26033[(2)] = null);

(statearr_26008_26033[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (6))){
var inst_25959 = (state_25999[(7)]);
var inst_25984 = inst_25959.length;
var inst_25985 = (inst_25984 > (0));
var state_25999__$1 = state_25999;
if(cljs.core.truth_(inst_25985)){
var statearr_26009_26034 = state_25999__$1;
(statearr_26009_26034[(1)] = (12));

} else {
var statearr_26010_26035 = state_25999__$1;
(statearr_26010_26035[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (3))){
var inst_25997 = (state_25999[(2)]);
var state_25999__$1 = state_25999;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25999__$1,inst_25997);
} else {
if((state_val_26000 === (12))){
var inst_25959 = (state_25999[(7)]);
var inst_25987 = cljs.core.vec.call(null,inst_25959);
var state_25999__$1 = state_25999;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25999__$1,(15),out,inst_25987);
} else {
if((state_val_26000 === (2))){
var state_25999__$1 = state_25999;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25999__$1,(4),ch);
} else {
if((state_val_26000 === (11))){
var inst_25967 = (state_25999[(10)]);
var inst_25963 = (state_25999[(9)]);
var inst_25977 = (state_25999[(2)]);
var inst_25978 = [];
var inst_25979 = inst_25978.push(inst_25963);
var inst_25959 = inst_25978;
var inst_25960 = inst_25967;
var state_25999__$1 = (function (){var statearr_26011 = state_25999;
(statearr_26011[(7)] = inst_25959);

(statearr_26011[(8)] = inst_25960);

(statearr_26011[(11)] = inst_25979);

(statearr_26011[(12)] = inst_25977);

return statearr_26011;
})();
var statearr_26012_26036 = state_25999__$1;
(statearr_26012_26036[(2)] = null);

(statearr_26012_26036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (9))){
var inst_25959 = (state_25999[(7)]);
var inst_25975 = cljs.core.vec.call(null,inst_25959);
var state_25999__$1 = state_25999;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25999__$1,(11),out,inst_25975);
} else {
if((state_val_26000 === (5))){
var inst_25960 = (state_25999[(8)]);
var inst_25967 = (state_25999[(10)]);
var inst_25963 = (state_25999[(9)]);
var inst_25967__$1 = f.call(null,inst_25963);
var inst_25968 = cljs.core._EQ_.call(null,inst_25967__$1,inst_25960);
var inst_25969 = cljs.core.keyword_identical_QMARK_.call(null,inst_25960,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_25970 = ((inst_25968) || (inst_25969));
var state_25999__$1 = (function (){var statearr_26013 = state_25999;
(statearr_26013[(10)] = inst_25967__$1);

return statearr_26013;
})();
if(cljs.core.truth_(inst_25970)){
var statearr_26014_26037 = state_25999__$1;
(statearr_26014_26037[(1)] = (8));

} else {
var statearr_26015_26038 = state_25999__$1;
(statearr_26015_26038[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (14))){
var inst_25992 = (state_25999[(2)]);
var inst_25993 = cljs.core.async.close_BANG_.call(null,out);
var state_25999__$1 = (function (){var statearr_26017 = state_25999;
(statearr_26017[(13)] = inst_25992);

return statearr_26017;
})();
var statearr_26018_26039 = state_25999__$1;
(statearr_26018_26039[(2)] = inst_25993);

(statearr_26018_26039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (10))){
var inst_25982 = (state_25999[(2)]);
var state_25999__$1 = state_25999;
var statearr_26019_26040 = state_25999__$1;
(statearr_26019_26040[(2)] = inst_25982);

(statearr_26019_26040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26000 === (8))){
var inst_25959 = (state_25999[(7)]);
var inst_25967 = (state_25999[(10)]);
var inst_25963 = (state_25999[(9)]);
var inst_25972 = inst_25959.push(inst_25963);
var tmp26016 = inst_25959;
var inst_25959__$1 = tmp26016;
var inst_25960 = inst_25967;
var state_25999__$1 = (function (){var statearr_26020 = state_25999;
(statearr_26020[(7)] = inst_25959__$1);

(statearr_26020[(8)] = inst_25960);

(statearr_26020[(14)] = inst_25972);

return statearr_26020;
})();
var statearr_26021_26041 = state_25999__$1;
(statearr_26021_26041[(2)] = null);

(statearr_26021_26041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24123__auto___26027,out))
;
return ((function (switch__24028__auto__,c__24123__auto___26027,out){
return (function() {
var cljs$core$async$state_machine__24029__auto__ = null;
var cljs$core$async$state_machine__24029__auto____0 = (function (){
var statearr_26022 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26022[(0)] = cljs$core$async$state_machine__24029__auto__);

(statearr_26022[(1)] = (1));

return statearr_26022;
});
var cljs$core$async$state_machine__24029__auto____1 = (function (state_25999){
while(true){
var ret_value__24030__auto__ = (function (){try{while(true){
var result__24031__auto__ = switch__24028__auto__.call(null,state_25999);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24031__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24031__auto__;
}
break;
}
}catch (e26023){if((e26023 instanceof Object)){
var ex__24032__auto__ = e26023;
var statearr_26024_26042 = state_25999;
(statearr_26024_26042[(5)] = ex__24032__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25999);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26023;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26043 = state_25999;
state_25999 = G__26043;
continue;
} else {
return ret_value__24030__auto__;
}
break;
}
});
cljs$core$async$state_machine__24029__auto__ = function(state_25999){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24029__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24029__auto____1.call(this,state_25999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24029__auto____0;
cljs$core$async$state_machine__24029__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24029__auto____1;
return cljs$core$async$state_machine__24029__auto__;
})()
;})(switch__24028__auto__,c__24123__auto___26027,out))
})();
var state__24125__auto__ = (function (){var statearr_26025 = f__24124__auto__.call(null);
(statearr_26025[(6)] = c__24123__auto___26027);

return statearr_26025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24125__auto__);
});})(c__24123__auto___26027,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1571424878573
