var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
void 0;
void 0;
void 0;
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
void 0;
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  if(p[goog.typeOf.call(null, x)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error("No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
void 0;
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__4968__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__4968 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4968__delegate.call(this, array, i, idxs)
    };
    G__4968.cljs$lang$maxFixedArity = 2;
    G__4968.cljs$lang$applyTo = function(arglist__4969) {
      var array = cljs.core.first(arglist__4969);
      var i = cljs.core.first(cljs.core.next(arglist__4969));
      var idxs = cljs.core.rest(cljs.core.next(arglist__4969));
      return G__4968__delegate(array, i, idxs)
    };
    G__4968.cljs$lang$arity$variadic = G__4968__delegate;
    return G__4968
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
void 0;
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
void 0;
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3546__auto____4970 = this$;
      if(and__3546__auto____4970) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3546__auto____4970
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      return function() {
        var or__3548__auto____4971 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4971) {
          return or__3548__auto____4971
        }else {
          var or__3548__auto____4972 = cljs.core._invoke["_"];
          if(or__3548__auto____4972) {
            return or__3548__auto____4972
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3546__auto____4973 = this$;
      if(and__3546__auto____4973) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3546__auto____4973
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      return function() {
        var or__3548__auto____4974 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4974) {
          return or__3548__auto____4974
        }else {
          var or__3548__auto____4975 = cljs.core._invoke["_"];
          if(or__3548__auto____4975) {
            return or__3548__auto____4975
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3546__auto____4976 = this$;
      if(and__3546__auto____4976) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3546__auto____4976
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____4977 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4977) {
          return or__3548__auto____4977
        }else {
          var or__3548__auto____4978 = cljs.core._invoke["_"];
          if(or__3548__auto____4978) {
            return or__3548__auto____4978
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3546__auto____4979 = this$;
      if(and__3546__auto____4979) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3546__auto____4979
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____4980 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4980) {
          return or__3548__auto____4980
        }else {
          var or__3548__auto____4981 = cljs.core._invoke["_"];
          if(or__3548__auto____4981) {
            return or__3548__auto____4981
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3546__auto____4982 = this$;
      if(and__3546__auto____4982) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3546__auto____4982
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____4983 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4983) {
          return or__3548__auto____4983
        }else {
          var or__3548__auto____4984 = cljs.core._invoke["_"];
          if(or__3548__auto____4984) {
            return or__3548__auto____4984
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3546__auto____4985 = this$;
      if(and__3546__auto____4985) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3546__auto____4985
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____4986 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4986) {
          return or__3548__auto____4986
        }else {
          var or__3548__auto____4987 = cljs.core._invoke["_"];
          if(or__3548__auto____4987) {
            return or__3548__auto____4987
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3546__auto____4988 = this$;
      if(and__3546__auto____4988) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3546__auto____4988
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____4989 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4989) {
          return or__3548__auto____4989
        }else {
          var or__3548__auto____4990 = cljs.core._invoke["_"];
          if(or__3548__auto____4990) {
            return or__3548__auto____4990
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3546__auto____4991 = this$;
      if(and__3546__auto____4991) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3546__auto____4991
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____4992 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4992) {
          return or__3548__auto____4992
        }else {
          var or__3548__auto____4993 = cljs.core._invoke["_"];
          if(or__3548__auto____4993) {
            return or__3548__auto____4993
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3546__auto____4994 = this$;
      if(and__3546__auto____4994) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3546__auto____4994
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____4995 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4995) {
          return or__3548__auto____4995
        }else {
          var or__3548__auto____4996 = cljs.core._invoke["_"];
          if(or__3548__auto____4996) {
            return or__3548__auto____4996
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3546__auto____4997 = this$;
      if(and__3546__auto____4997) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3546__auto____4997
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____4998 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4998) {
          return or__3548__auto____4998
        }else {
          var or__3548__auto____4999 = cljs.core._invoke["_"];
          if(or__3548__auto____4999) {
            return or__3548__auto____4999
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3546__auto____5000 = this$;
      if(and__3546__auto____5000) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3546__auto____5000
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____5001 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5001) {
          return or__3548__auto____5001
        }else {
          var or__3548__auto____5002 = cljs.core._invoke["_"];
          if(or__3548__auto____5002) {
            return or__3548__auto____5002
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3546__auto____5003 = this$;
      if(and__3546__auto____5003) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3546__auto____5003
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____5004 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5004) {
          return or__3548__auto____5004
        }else {
          var or__3548__auto____5005 = cljs.core._invoke["_"];
          if(or__3548__auto____5005) {
            return or__3548__auto____5005
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3546__auto____5006 = this$;
      if(and__3546__auto____5006) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3546__auto____5006
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____5007 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5007) {
          return or__3548__auto____5007
        }else {
          var or__3548__auto____5008 = cljs.core._invoke["_"];
          if(or__3548__auto____5008) {
            return or__3548__auto____5008
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3546__auto____5009 = this$;
      if(and__3546__auto____5009) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3546__auto____5009
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____5010 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5010) {
          return or__3548__auto____5010
        }else {
          var or__3548__auto____5011 = cljs.core._invoke["_"];
          if(or__3548__auto____5011) {
            return or__3548__auto____5011
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3546__auto____5012 = this$;
      if(and__3546__auto____5012) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3546__auto____5012
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____5013 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5013) {
          return or__3548__auto____5013
        }else {
          var or__3548__auto____5014 = cljs.core._invoke["_"];
          if(or__3548__auto____5014) {
            return or__3548__auto____5014
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3546__auto____5015 = this$;
      if(and__3546__auto____5015) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3546__auto____5015
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____5016 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5016) {
          return or__3548__auto____5016
        }else {
          var or__3548__auto____5017 = cljs.core._invoke["_"];
          if(or__3548__auto____5017) {
            return or__3548__auto____5017
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3546__auto____5018 = this$;
      if(and__3546__auto____5018) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3546__auto____5018
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____5019 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5019) {
          return or__3548__auto____5019
        }else {
          var or__3548__auto____5020 = cljs.core._invoke["_"];
          if(or__3548__auto____5020) {
            return or__3548__auto____5020
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3546__auto____5021 = this$;
      if(and__3546__auto____5021) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3546__auto____5021
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____5022 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5022) {
          return or__3548__auto____5022
        }else {
          var or__3548__auto____5023 = cljs.core._invoke["_"];
          if(or__3548__auto____5023) {
            return or__3548__auto____5023
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3546__auto____5024 = this$;
      if(and__3546__auto____5024) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3546__auto____5024
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____5025 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5025) {
          return or__3548__auto____5025
        }else {
          var or__3548__auto____5026 = cljs.core._invoke["_"];
          if(or__3548__auto____5026) {
            return or__3548__auto____5026
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3546__auto____5027 = this$;
      if(and__3546__auto____5027) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3546__auto____5027
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____5028 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5028) {
          return or__3548__auto____5028
        }else {
          var or__3548__auto____5029 = cljs.core._invoke["_"];
          if(or__3548__auto____5029) {
            return or__3548__auto____5029
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3546__auto____5030 = this$;
      if(and__3546__auto____5030) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3546__auto____5030
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____5031 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____5031) {
          return or__3548__auto____5031
        }else {
          var or__3548__auto____5032 = cljs.core._invoke["_"];
          if(or__3548__auto____5032) {
            return or__3548__auto____5032
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
void 0;
void 0;
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3546__auto____5033 = coll;
    if(and__3546__auto____5033) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3546__auto____5033
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5034 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5034) {
        return or__3548__auto____5034
      }else {
        var or__3548__auto____5035 = cljs.core._count["_"];
        if(or__3548__auto____5035) {
          return or__3548__auto____5035
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3546__auto____5036 = coll;
    if(and__3546__auto____5036) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3546__auto____5036
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5037 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5037) {
        return or__3548__auto____5037
      }else {
        var or__3548__auto____5038 = cljs.core._empty["_"];
        if(or__3548__auto____5038) {
          return or__3548__auto____5038
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3546__auto____5039 = coll;
    if(and__3546__auto____5039) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3546__auto____5039
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    return function() {
      var or__3548__auto____5040 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5040) {
        return or__3548__auto____5040
      }else {
        var or__3548__auto____5041 = cljs.core._conj["_"];
        if(or__3548__auto____5041) {
          return or__3548__auto____5041
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
void 0;
void 0;
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3546__auto____5042 = coll;
      if(and__3546__auto____5042) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3546__auto____5042
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      return function() {
        var or__3548__auto____5043 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5043) {
          return or__3548__auto____5043
        }else {
          var or__3548__auto____5044 = cljs.core._nth["_"];
          if(or__3548__auto____5044) {
            return or__3548__auto____5044
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3546__auto____5045 = coll;
      if(and__3546__auto____5045) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3546__auto____5045
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____5046 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5046) {
          return or__3548__auto____5046
        }else {
          var or__3548__auto____5047 = cljs.core._nth["_"];
          if(or__3548__auto____5047) {
            return or__3548__auto____5047
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
void 0;
void 0;
cljs.core.ASeq = {};
void 0;
void 0;
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3546__auto____5048 = coll;
    if(and__3546__auto____5048) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3546__auto____5048
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5049 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5049) {
        return or__3548__auto____5049
      }else {
        var or__3548__auto____5050 = cljs.core._first["_"];
        if(or__3548__auto____5050) {
          return or__3548__auto____5050
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3546__auto____5051 = coll;
    if(and__3546__auto____5051) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3546__auto____5051
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5052 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5052) {
        return or__3548__auto____5052
      }else {
        var or__3548__auto____5053 = cljs.core._rest["_"];
        if(or__3548__auto____5053) {
          return or__3548__auto____5053
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3546__auto____5054 = o;
      if(and__3546__auto____5054) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3546__auto____5054
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      return function() {
        var or__3548__auto____5055 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5055) {
          return or__3548__auto____5055
        }else {
          var or__3548__auto____5056 = cljs.core._lookup["_"];
          if(or__3548__auto____5056) {
            return or__3548__auto____5056
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3546__auto____5057 = o;
      if(and__3546__auto____5057) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3546__auto____5057
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____5058 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____5058) {
          return or__3548__auto____5058
        }else {
          var or__3548__auto____5059 = cljs.core._lookup["_"];
          if(or__3548__auto____5059) {
            return or__3548__auto____5059
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
void 0;
void 0;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3546__auto____5060 = coll;
    if(and__3546__auto____5060) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3546__auto____5060
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5061 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5061) {
        return or__3548__auto____5061
      }else {
        var or__3548__auto____5062 = cljs.core._contains_key_QMARK_["_"];
        if(or__3548__auto____5062) {
          return or__3548__auto____5062
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3546__auto____5063 = coll;
    if(and__3546__auto____5063) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3546__auto____5063
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____5064 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5064) {
        return or__3548__auto____5064
      }else {
        var or__3548__auto____5065 = cljs.core._assoc["_"];
        if(or__3548__auto____5065) {
          return or__3548__auto____5065
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
void 0;
void 0;
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3546__auto____5066 = coll;
    if(and__3546__auto____5066) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3546__auto____5066
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____5067 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5067) {
        return or__3548__auto____5067
      }else {
        var or__3548__auto____5068 = cljs.core._dissoc["_"];
        if(or__3548__auto____5068) {
          return or__3548__auto____5068
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
void 0;
void 0;
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3546__auto____5069 = coll;
    if(and__3546__auto____5069) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3546__auto____5069
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5070 = cljs.core._key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5070) {
        return or__3548__auto____5070
      }else {
        var or__3548__auto____5071 = cljs.core._key["_"];
        if(or__3548__auto____5071) {
          return or__3548__auto____5071
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3546__auto____5072 = coll;
    if(and__3546__auto____5072) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3546__auto____5072
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5073 = cljs.core._val[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5073) {
        return or__3548__auto____5073
      }else {
        var or__3548__auto____5074 = cljs.core._val["_"];
        if(or__3548__auto____5074) {
          return or__3548__auto____5074
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3546__auto____5075 = coll;
    if(and__3546__auto____5075) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3546__auto____5075
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    return function() {
      var or__3548__auto____5076 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5076) {
        return or__3548__auto____5076
      }else {
        var or__3548__auto____5077 = cljs.core._disjoin["_"];
        if(or__3548__auto____5077) {
          return or__3548__auto____5077
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
void 0;
void 0;
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3546__auto____5078 = coll;
    if(and__3546__auto____5078) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3546__auto____5078
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5079 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5079) {
        return or__3548__auto____5079
      }else {
        var or__3548__auto____5080 = cljs.core._peek["_"];
        if(or__3548__auto____5080) {
          return or__3548__auto____5080
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3546__auto____5081 = coll;
    if(and__3546__auto____5081) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3546__auto____5081
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5082 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5082) {
        return or__3548__auto____5082
      }else {
        var or__3548__auto____5083 = cljs.core._pop["_"];
        if(or__3548__auto____5083) {
          return or__3548__auto____5083
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3546__auto____5084 = coll;
    if(and__3546__auto____5084) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3546__auto____5084
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____5085 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5085) {
        return or__3548__auto____5085
      }else {
        var or__3548__auto____5086 = cljs.core._assoc_n["_"];
        if(or__3548__auto____5086) {
          return or__3548__auto____5086
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
void 0;
void 0;
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3546__auto____5087 = o;
    if(and__3546__auto____5087) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3546__auto____5087
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5088 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(or__3548__auto____5088) {
        return or__3548__auto____5088
      }else {
        var or__3548__auto____5089 = cljs.core._deref["_"];
        if(or__3548__auto____5089) {
          return or__3548__auto____5089
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3546__auto____5090 = o;
    if(and__3546__auto____5090) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3546__auto____5090
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____5091 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(or__3548__auto____5091) {
        return or__3548__auto____5091
      }else {
        var or__3548__auto____5092 = cljs.core._deref_with_timeout["_"];
        if(or__3548__auto____5092) {
          return or__3548__auto____5092
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
void 0;
void 0;
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3546__auto____5093 = o;
    if(and__3546__auto____5093) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3546__auto____5093
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5094 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5094) {
        return or__3548__auto____5094
      }else {
        var or__3548__auto____5095 = cljs.core._meta["_"];
        if(or__3548__auto____5095) {
          return or__3548__auto____5095
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3546__auto____5096 = o;
    if(and__3546__auto____5096) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3546__auto____5096
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    return function() {
      var or__3548__auto____5097 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____5097) {
        return or__3548__auto____5097
      }else {
        var or__3548__auto____5098 = cljs.core._with_meta["_"];
        if(or__3548__auto____5098) {
          return or__3548__auto____5098
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
void 0;
void 0;
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3546__auto____5099 = coll;
      if(and__3546__auto____5099) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3546__auto____5099
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      return function() {
        var or__3548__auto____5100 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5100) {
          return or__3548__auto____5100
        }else {
          var or__3548__auto____5101 = cljs.core._reduce["_"];
          if(or__3548__auto____5101) {
            return or__3548__auto____5101
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3546__auto____5102 = coll;
      if(and__3546__auto____5102) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3546__auto____5102
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____5103 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____5103) {
          return or__3548__auto____5103
        }else {
          var or__3548__auto____5104 = cljs.core._reduce["_"];
          if(or__3548__auto____5104) {
            return or__3548__auto____5104
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
void 0;
void 0;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3546__auto____5105 = coll;
    if(and__3546__auto____5105) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3546__auto____5105
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    return function() {
      var or__3548__auto____5106 = cljs.core._kv_reduce[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5106) {
        return or__3548__auto____5106
      }else {
        var or__3548__auto____5107 = cljs.core._kv_reduce["_"];
        if(or__3548__auto____5107) {
          return or__3548__auto____5107
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
void 0;
void 0;
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3546__auto____5108 = o;
    if(and__3546__auto____5108) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3546__auto____5108
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    return function() {
      var or__3548__auto____5109 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(or__3548__auto____5109) {
        return or__3548__auto____5109
      }else {
        var or__3548__auto____5110 = cljs.core._equiv["_"];
        if(or__3548__auto____5110) {
          return or__3548__auto____5110
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
void 0;
void 0;
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3546__auto____5111 = o;
    if(and__3546__auto____5111) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3546__auto____5111
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5112 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(or__3548__auto____5112) {
        return or__3548__auto____5112
      }else {
        var or__3548__auto____5113 = cljs.core._hash["_"];
        if(or__3548__auto____5113) {
          return or__3548__auto____5113
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3546__auto____5114 = o;
    if(and__3546__auto____5114) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3546__auto____5114
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____5115 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5115) {
        return or__3548__auto____5115
      }else {
        var or__3548__auto____5116 = cljs.core._seq["_"];
        if(or__3548__auto____5116) {
          return or__3548__auto____5116
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISequential = {};
void 0;
void 0;
cljs.core.IList = {};
void 0;
void 0;
cljs.core.IRecord = {};
void 0;
void 0;
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3546__auto____5117 = coll;
    if(and__3546__auto____5117) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3546__auto____5117
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5118 = cljs.core._rseq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5118) {
        return or__3548__auto____5118
      }else {
        var or__3548__auto____5119 = cljs.core._rseq["_"];
        if(or__3548__auto____5119) {
          return or__3548__auto____5119
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5120 = coll;
    if(and__3546__auto____5120) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3546__auto____5120
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5121 = cljs.core._sorted_seq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5121) {
        return or__3548__auto____5121
      }else {
        var or__3548__auto____5122 = cljs.core._sorted_seq["_"];
        if(or__3548__auto____5122) {
          return or__3548__auto____5122
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____5123 = coll;
    if(and__3546__auto____5123) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3546__auto____5123
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____5124 = cljs.core._sorted_seq_from[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5124) {
        return or__3548__auto____5124
      }else {
        var or__3548__auto____5125 = cljs.core._sorted_seq_from["_"];
        if(or__3548__auto____5125) {
          return or__3548__auto____5125
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3546__auto____5126 = coll;
    if(and__3546__auto____5126) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3546__auto____5126
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    return function() {
      var or__3548__auto____5127 = cljs.core._entry_key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5127) {
        return or__3548__auto____5127
      }else {
        var or__3548__auto____5128 = cljs.core._entry_key["_"];
        if(or__3548__auto____5128) {
          return or__3548__auto____5128
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3546__auto____5129 = coll;
    if(and__3546__auto____5129) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3546__auto____5129
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5130 = cljs.core._comparator[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5130) {
        return or__3548__auto____5130
      }else {
        var or__3548__auto____5131 = cljs.core._comparator["_"];
        if(or__3548__auto____5131) {
          return or__3548__auto____5131
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3546__auto____5132 = o;
    if(and__3546__auto____5132) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3546__auto____5132
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    return function() {
      var or__3548__auto____5133 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____5133) {
        return or__3548__auto____5133
      }else {
        var or__3548__auto____5134 = cljs.core._pr_seq["_"];
        if(or__3548__auto____5134) {
          return or__3548__auto____5134
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
void 0;
void 0;
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3546__auto____5135 = d;
    if(and__3546__auto____5135) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3546__auto____5135
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    return function() {
      var or__3548__auto____5136 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(or__3548__auto____5136) {
        return or__3548__auto____5136
      }else {
        var or__3548__auto____5137 = cljs.core._realized_QMARK_["_"];
        if(or__3548__auto____5137) {
          return or__3548__auto____5137
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
void 0;
void 0;
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3546__auto____5138 = this$;
    if(and__3546__auto____5138) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3546__auto____5138
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____5139 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5139) {
        return or__3548__auto____5139
      }else {
        var or__3548__auto____5140 = cljs.core._notify_watches["_"];
        if(or__3548__auto____5140) {
          return or__3548__auto____5140
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3546__auto____5141 = this$;
    if(and__3546__auto____5141) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3546__auto____5141
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____5142 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5142) {
        return or__3548__auto____5142
      }else {
        var or__3548__auto____5143 = cljs.core._add_watch["_"];
        if(or__3548__auto____5143) {
          return or__3548__auto____5143
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3546__auto____5144 = this$;
    if(and__3546__auto____5144) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3546__auto____5144
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    return function() {
      var or__3548__auto____5145 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____5145) {
        return or__3548__auto____5145
      }else {
        var or__3548__auto____5146 = cljs.core._remove_watch["_"];
        if(or__3548__auto____5146) {
          return or__3548__auto____5146
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
void 0;
void 0;
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3546__auto____5147 = coll;
    if(and__3546__auto____5147) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3546__auto____5147
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____5148 = cljs.core._as_transient[goog.typeOf.call(null, coll)];
      if(or__3548__auto____5148) {
        return or__3548__auto____5148
      }else {
        var or__3548__auto____5149 = cljs.core._as_transient["_"];
        if(or__3548__auto____5149) {
          return or__3548__auto____5149
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3546__auto____5150 = tcoll;
    if(and__3546__auto____5150) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3546__auto____5150
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    return function() {
      var or__3548__auto____5151 = cljs.core._conj_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5151) {
        return or__3548__auto____5151
      }else {
        var or__3548__auto____5152 = cljs.core._conj_BANG_["_"];
        if(or__3548__auto____5152) {
          return or__3548__auto____5152
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5153 = tcoll;
    if(and__3546__auto____5153) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3546__auto____5153
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5154 = cljs.core._persistent_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5154) {
        return or__3548__auto____5154
      }else {
        var or__3548__auto____5155 = cljs.core._persistent_BANG_["_"];
        if(or__3548__auto____5155) {
          return or__3548__auto____5155
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3546__auto____5156 = tcoll;
    if(and__3546__auto____5156) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3546__auto____5156
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    return function() {
      var or__3548__auto____5157 = cljs.core._assoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5157) {
        return or__3548__auto____5157
      }else {
        var or__3548__auto____5158 = cljs.core._assoc_BANG_["_"];
        if(or__3548__auto____5158) {
          return or__3548__auto____5158
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
void 0;
void 0;
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3546__auto____5159 = tcoll;
    if(and__3546__auto____5159) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3546__auto____5159
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    return function() {
      var or__3548__auto____5160 = cljs.core._dissoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5160) {
        return or__3548__auto____5160
      }else {
        var or__3548__auto____5161 = cljs.core._dissoc_BANG_["_"];
        if(or__3548__auto____5161) {
          return or__3548__auto____5161
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
void 0;
void 0;
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3546__auto____5162 = tcoll;
    if(and__3546__auto____5162) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3546__auto____5162
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    return function() {
      var or__3548__auto____5163 = cljs.core._assoc_n_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5163) {
        return or__3548__auto____5163
      }else {
        var or__3548__auto____5164 = cljs.core._assoc_n_BANG_["_"];
        if(or__3548__auto____5164) {
          return or__3548__auto____5164
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____5165 = tcoll;
    if(and__3546__auto____5165) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3546__auto____5165
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____5166 = cljs.core._pop_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5166) {
        return or__3548__auto____5166
      }else {
        var or__3548__auto____5167 = cljs.core._pop_BANG_["_"];
        if(or__3548__auto____5167) {
          return or__3548__auto____5167
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3546__auto____5168 = tcoll;
    if(and__3546__auto____5168) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3546__auto____5168
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    return function() {
      var or__3548__auto____5169 = cljs.core._disjoin_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____5169) {
        return or__3548__auto____5169
      }else {
        var or__3548__auto____5170 = cljs.core._disjoin_BANG_["_"];
        if(or__3548__auto____5170) {
          return or__3548__auto____5170
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
void 0;
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
void 0;
void 0;
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3548__auto____5171 = x === y;
    if(or__3548__auto____5171) {
      return or__3548__auto____5171
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__5172__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5173 = y;
            var G__5174 = cljs.core.first.call(null, more);
            var G__5175 = cljs.core.next.call(null, more);
            x = G__5173;
            y = G__5174;
            more = G__5175;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5172 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5172__delegate.call(this, x, y, more)
    };
    G__5172.cljs$lang$maxFixedArity = 2;
    G__5172.cljs$lang$applyTo = function(arglist__5176) {
      var x = cljs.core.first(arglist__5176);
      var y = cljs.core.first(cljs.core.next(arglist__5176));
      var more = cljs.core.rest(cljs.core.next(arglist__5176));
      return G__5172__delegate(x, y, more)
    };
    G__5172.cljs$lang$arity$variadic = G__5172__delegate;
    return G__5172
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(function() {
    var or__3548__auto____5177 = x == null;
    if(or__3548__auto____5177) {
      return or__3548__auto____5177
    }else {
      return void 0 === x
    }
  }()) {
    return null
  }else {
    return x.constructor
  }
};
void 0;
void 0;
void 0;
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__5178 = null;
  var G__5178__2 = function(o, k) {
    return null
  };
  var G__5178__3 = function(o, k, not_found) {
    return not_found
  };
  G__5178 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5178__2.call(this, o, k);
      case 3:
        return G__5178__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5178
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__5179 = null;
  var G__5179__2 = function(_, f) {
    return f.call(null)
  };
  var G__5179__3 = function(_, f, start) {
    return start
  };
  G__5179 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5179__2.call(this, _, f);
      case 3:
        return G__5179__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5179
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__5180 = null;
  var G__5180__2 = function(_, n) {
    return null
  };
  var G__5180__3 = function(_, n, not_found) {
    return not_found
  };
  G__5180 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5180__2.call(this, _, n);
      case 3:
        return G__5180__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5180
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
void 0;
void 0;
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    if(cljs.core._count.call(null, cicoll) === 0) {
      return f.call(null)
    }else {
      var val__5181 = cljs.core._nth.call(null, cicoll, 0);
      var n__5182 = 1;
      while(true) {
        if(n__5182 < cljs.core._count.call(null, cicoll)) {
          var nval__5183 = f.call(null, val__5181, cljs.core._nth.call(null, cicoll, n__5182));
          if(cljs.core.reduced_QMARK_.call(null, nval__5183)) {
            return cljs.core.deref.call(null, nval__5183)
          }else {
            var G__5190 = nval__5183;
            var G__5191 = n__5182 + 1;
            val__5181 = G__5190;
            n__5182 = G__5191;
            continue
          }
        }else {
          return val__5181
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var val__5184 = val;
    var n__5185 = 0;
    while(true) {
      if(n__5185 < cljs.core._count.call(null, cicoll)) {
        var nval__5186 = f.call(null, val__5184, cljs.core._nth.call(null, cicoll, n__5185));
        if(cljs.core.reduced_QMARK_.call(null, nval__5186)) {
          return cljs.core.deref.call(null, nval__5186)
        }else {
          var G__5192 = nval__5186;
          var G__5193 = n__5185 + 1;
          val__5184 = G__5192;
          n__5185 = G__5193;
          continue
        }
      }else {
        return val__5184
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var val__5187 = val;
    var n__5188 = idx;
    while(true) {
      if(n__5188 < cljs.core._count.call(null, cicoll)) {
        var nval__5189 = f.call(null, val__5187, cljs.core._nth.call(null, cicoll, n__5188));
        if(cljs.core.reduced_QMARK_.call(null, nval__5189)) {
          return cljs.core.deref.call(null, nval__5189)
        }else {
          var G__5194 = nval__5189;
          var G__5195 = n__5188 + 1;
          val__5187 = G__5194;
          n__5188 = G__5195;
          continue
        }
      }else {
        return val__5187
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
void 0;
void 0;
void 0;
void 0;
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15990906
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5196 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5197 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ASeq$ = true;
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__5198 = this;
  var this$__5199 = this;
  return cljs.core.pr_str.call(null, this$__5199)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__5200 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5200.a)) {
    return cljs.core.ci_reduce.call(null, this__5200.a, f, this__5200.a[this__5200.i], this__5200.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__5200.a[this__5200.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__5201 = this;
  if(cljs.core.counted_QMARK_.call(null, this__5201.a)) {
    return cljs.core.ci_reduce.call(null, this__5201.a, f, start, this__5201.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__5202 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__5203 = this;
  return this__5203.a.length - this__5203.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__5204 = this;
  return this__5204.a[this__5204.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__5205 = this;
  if(this__5205.i + 1 < this__5205.a.length) {
    return new cljs.core.IndexedSeq(this__5205.a, this__5205.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5206 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5207 = this;
  var i__5208 = n + this__5207.i;
  if(i__5208 < this__5207.a.length) {
    return this__5207.a[i__5208]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5209 = this;
  var i__5210 = n + this__5209.i;
  if(i__5210 < this__5209.a.length) {
    return this__5209.a[i__5210]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__5211 = null;
  var G__5211__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__5211__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__5211 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5211__2.call(this, array, f);
      case 3:
        return G__5211__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5211
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__5212 = null;
  var G__5212__2 = function(array, k) {
    return array[k]
  };
  var G__5212__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__5212 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5212__2.call(this, array, k);
      case 3:
        return G__5212__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5212
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__5213 = null;
  var G__5213__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__5213__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__5213 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5213__2.call(this, array, n);
      case 3:
        return G__5213__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5213
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(coll != null) {
    if(function() {
      var G__5214__5215 = coll;
      if(G__5214__5215 != null) {
        if(function() {
          var or__3548__auto____5216 = G__5214__5215.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3548__auto____5216) {
            return or__3548__auto____5216
          }else {
            return G__5214__5215.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__5214__5215.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5214__5215)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5214__5215)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  if(coll != null) {
    if(function() {
      var G__5217__5218 = coll;
      if(G__5217__5218 != null) {
        if(function() {
          var or__3548__auto____5219 = G__5217__5218.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5219) {
            return or__3548__auto____5219
          }else {
            return G__5217__5218.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5217__5218.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5217__5218)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5217__5218)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__5220 = cljs.core.seq.call(null, coll);
      if(s__5220 != null) {
        return cljs.core._first.call(null, s__5220)
      }else {
        return null
      }
    }
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  if(coll != null) {
    if(function() {
      var G__5221__5222 = coll;
      if(G__5221__5222 != null) {
        if(function() {
          var or__3548__auto____5223 = G__5221__5222.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5223) {
            return or__3548__auto____5223
          }else {
            return G__5221__5222.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5221__5222.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5221__5222)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5221__5222)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__5224 = cljs.core.seq.call(null, coll);
      if(s__5224 != null) {
        return cljs.core._rest.call(null, s__5224)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll != null) {
    if(function() {
      var G__5225__5226 = coll;
      if(G__5225__5226 != null) {
        if(function() {
          var or__3548__auto____5227 = G__5225__5226.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5227) {
            return or__3548__auto____5227
          }else {
            return G__5225__5226.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5225__5226.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5225__5226)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5225__5226)
      }
    }()) {
      var coll__5228 = cljs.core._rest.call(null, coll);
      if(coll__5228 != null) {
        if(function() {
          var G__5229__5230 = coll__5228;
          if(G__5229__5230 != null) {
            if(function() {
              var or__3548__auto____5231 = G__5229__5230.cljs$lang$protocol_mask$partition0$ & 32;
              if(or__3548__auto____5231) {
                return or__3548__auto____5231
              }else {
                return G__5229__5230.cljs$core$ASeq$
              }
            }()) {
              return true
            }else {
              if(!G__5229__5230.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5229__5230)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5229__5230)
          }
        }()) {
          return coll__5228
        }else {
          return cljs.core._seq.call(null, coll__5228)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__5232 = cljs.core.next.call(null, s);
      s = G__5232;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__5233__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__5234 = conj.call(null, coll, x);
          var G__5235 = cljs.core.first.call(null, xs);
          var G__5236 = cljs.core.next.call(null, xs);
          coll = G__5234;
          x = G__5235;
          xs = G__5236;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__5233 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5233__delegate.call(this, coll, x, xs)
    };
    G__5233.cljs$lang$maxFixedArity = 2;
    G__5233.cljs$lang$applyTo = function(arglist__5237) {
      var coll = cljs.core.first(arglist__5237);
      var x = cljs.core.first(cljs.core.next(arglist__5237));
      var xs = cljs.core.rest(cljs.core.next(arglist__5237));
      return G__5233__delegate(coll, x, xs)
    };
    G__5233.cljs$lang$arity$variadic = G__5233__delegate;
    return G__5233
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
void 0;
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__5238 = cljs.core.seq.call(null, coll);
  var acc__5239 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__5238)) {
      return acc__5239 + cljs.core._count.call(null, s__5238)
    }else {
      var G__5240 = cljs.core.next.call(null, s__5238);
      var G__5241 = acc__5239 + 1;
      s__5238 = G__5240;
      acc__5239 = G__5241;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
void 0;
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll != null) {
      if(function() {
        var G__5242__5243 = coll;
        if(G__5242__5243 != null) {
          if(function() {
            var or__3548__auto____5244 = G__5242__5243.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5244) {
              return or__3548__auto____5244
            }else {
              return G__5242__5243.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5242__5243.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5242__5243)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5242__5243)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }else {
      return null
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(coll != null) {
      if(function() {
        var G__5245__5246 = coll;
        if(G__5245__5246 != null) {
          if(function() {
            var or__3548__auto____5247 = G__5245__5246.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5247) {
              return or__3548__auto____5247
            }else {
              return G__5245__5246.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5245__5246.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5245__5246)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5245__5246)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__5249__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__5248 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__5250 = ret__5248;
          var G__5251 = cljs.core.first.call(null, kvs);
          var G__5252 = cljs.core.second.call(null, kvs);
          var G__5253 = cljs.core.nnext.call(null, kvs);
          coll = G__5250;
          k = G__5251;
          v = G__5252;
          kvs = G__5253;
          continue
        }else {
          return ret__5248
        }
        break
      }
    };
    var G__5249 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5249__delegate.call(this, coll, k, v, kvs)
    };
    G__5249.cljs$lang$maxFixedArity = 3;
    G__5249.cljs$lang$applyTo = function(arglist__5254) {
      var coll = cljs.core.first(arglist__5254);
      var k = cljs.core.first(cljs.core.next(arglist__5254));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5254)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5254)));
      return G__5249__delegate(coll, k, v, kvs)
    };
    G__5249.cljs$lang$arity$variadic = G__5249__delegate;
    return G__5249
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__5256__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5255 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5257 = ret__5255;
          var G__5258 = cljs.core.first.call(null, ks);
          var G__5259 = cljs.core.next.call(null, ks);
          coll = G__5257;
          k = G__5258;
          ks = G__5259;
          continue
        }else {
          return ret__5255
        }
        break
      }
    };
    var G__5256 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5256__delegate.call(this, coll, k, ks)
    };
    G__5256.cljs$lang$maxFixedArity = 2;
    G__5256.cljs$lang$applyTo = function(arglist__5260) {
      var coll = cljs.core.first(arglist__5260);
      var k = cljs.core.first(cljs.core.next(arglist__5260));
      var ks = cljs.core.rest(cljs.core.next(arglist__5260));
      return G__5256__delegate(coll, k, ks)
    };
    G__5256.cljs$lang$arity$variadic = G__5256__delegate;
    return G__5256
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__5261__5262 = o;
    if(G__5261__5262 != null) {
      if(function() {
        var or__3548__auto____5263 = G__5261__5262.cljs$lang$protocol_mask$partition0$ & 65536;
        if(or__3548__auto____5263) {
          return or__3548__auto____5263
        }else {
          return G__5261__5262.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__5261__5262.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5261__5262)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5261__5262)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__5265__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5264 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5266 = ret__5264;
          var G__5267 = cljs.core.first.call(null, ks);
          var G__5268 = cljs.core.next.call(null, ks);
          coll = G__5266;
          k = G__5267;
          ks = G__5268;
          continue
        }else {
          return ret__5264
        }
        break
      }
    };
    var G__5265 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5265__delegate.call(this, coll, k, ks)
    };
    G__5265.cljs$lang$maxFixedArity = 2;
    G__5265.cljs$lang$applyTo = function(arglist__5269) {
      var coll = cljs.core.first(arglist__5269);
      var k = cljs.core.first(cljs.core.next(arglist__5269));
      var ks = cljs.core.rest(cljs.core.next(arglist__5269));
      return G__5265__delegate(coll, k, ks)
    };
    G__5265.cljs$lang$arity$variadic = G__5265__delegate;
    return G__5265
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5270__5271 = x;
    if(G__5270__5271 != null) {
      if(function() {
        var or__3548__auto____5272 = G__5270__5271.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3548__auto____5272) {
          return or__3548__auto____5272
        }else {
          return G__5270__5271.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__5270__5271.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5270__5271)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5270__5271)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5273__5274 = x;
    if(G__5273__5274 != null) {
      if(function() {
        var or__3548__auto____5275 = G__5273__5274.cljs$lang$protocol_mask$partition0$ & 2048;
        if(or__3548__auto____5275) {
          return or__3548__auto____5275
        }else {
          return G__5273__5274.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__5273__5274.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5273__5274)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5273__5274)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__5276__5277 = x;
  if(G__5276__5277 != null) {
    if(function() {
      var or__3548__auto____5278 = G__5276__5277.cljs$lang$protocol_mask$partition0$ & 256;
      if(or__3548__auto____5278) {
        return or__3548__auto____5278
      }else {
        return G__5276__5277.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__5276__5277.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5276__5277)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5276__5277)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__5279__5280 = x;
  if(G__5279__5280 != null) {
    if(function() {
      var or__3548__auto____5281 = G__5279__5280.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3548__auto____5281) {
        return or__3548__auto____5281
      }else {
        return G__5279__5280.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__5279__5280.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5279__5280)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5279__5280)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__5282__5283 = x;
  if(G__5282__5283 != null) {
    if(function() {
      var or__3548__auto____5284 = G__5282__5283.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3548__auto____5284) {
        return or__3548__auto____5284
      }else {
        return G__5282__5283.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__5282__5283.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5282__5283)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5282__5283)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__5285__5286 = x;
  if(G__5285__5286 != null) {
    if(function() {
      var or__3548__auto____5287 = G__5285__5286.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3548__auto____5287) {
        return or__3548__auto____5287
      }else {
        return G__5285__5286.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__5285__5286.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5285__5286)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5285__5286)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__5288__5289 = x;
  if(G__5288__5289 != null) {
    if(function() {
      var or__3548__auto____5290 = G__5288__5289.cljs$lang$protocol_mask$partition0$ & 262144;
      if(or__3548__auto____5290) {
        return or__3548__auto____5290
      }else {
        return G__5288__5289.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__5288__5289.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5288__5289)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5288__5289)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5291__5292 = x;
    if(G__5291__5292 != null) {
      if(function() {
        var or__3548__auto____5293 = G__5291__5292.cljs$lang$protocol_mask$partition0$ & 512;
        if(or__3548__auto____5293) {
          return or__3548__auto____5293
        }else {
          return G__5291__5292.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__5291__5292.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5291__5292)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5291__5292)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__5294__5295 = x;
  if(G__5294__5295 != null) {
    if(function() {
      var or__3548__auto____5296 = G__5294__5295.cljs$lang$protocol_mask$partition0$ & 8192;
      if(or__3548__auto____5296) {
        return or__3548__auto____5296
      }else {
        return G__5294__5295.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__5294__5295.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5294__5295)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5294__5295)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__5297__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__5297 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5297__delegate.call(this, keyvals)
    };
    G__5297.cljs$lang$maxFixedArity = 0;
    G__5297.cljs$lang$applyTo = function(arglist__5298) {
      var keyvals = cljs.core.seq(arglist__5298);
      return G__5297__delegate(keyvals)
    };
    G__5297.cljs$lang$arity$variadic = G__5297__delegate;
    return G__5297
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(falsecljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__5299 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__5299.push(key)
  });
  return keys__5299
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__5300 = i;
  var j__5301 = j;
  var len__5302 = len;
  while(true) {
    if(len__5302 === 0) {
      return to
    }else {
      to[j__5301] = from[i__5300];
      var G__5303 = i__5300 + 1;
      var G__5304 = j__5301 + 1;
      var G__5305 = len__5302 - 1;
      i__5300 = G__5303;
      j__5301 = G__5304;
      len__5302 = G__5305;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__5306 = i + (len - 1);
  var j__5307 = j + (len - 1);
  var len__5308 = len;
  while(true) {
    if(len__5308 === 0) {
      return to
    }else {
      to[j__5307] = from[i__5306];
      var G__5309 = i__5306 - 1;
      var G__5310 = j__5307 - 1;
      var G__5311 = len__5308 - 1;
      i__5306 = G__5309;
      j__5307 = G__5310;
      len__5308 = G__5311;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__5312__5313 = s;
    if(G__5312__5313 != null) {
      if(function() {
        var or__3548__auto____5314 = G__5312__5313.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3548__auto____5314) {
          return or__3548__auto____5314
        }else {
          return G__5312__5313.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__5312__5313.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5312__5313)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5312__5313)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__5315__5316 = s;
  if(G__5315__5316 != null) {
    if(function() {
      var or__3548__auto____5317 = G__5315__5316.cljs$lang$protocol_mask$partition0$ & 4194304;
      if(or__3548__auto____5317) {
        return or__3548__auto____5317
      }else {
        return G__5315__5316.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__5315__5316.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5315__5316)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5315__5316)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____5318 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5318)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____5319 = x.charAt(0) === "\ufdd0";
      if(or__3548__auto____5319) {
        return or__3548__auto____5319
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }())
  }else {
    return and__3546__auto____5318
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____5320 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5320)) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3546__auto____5320
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____5321 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5321)) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3546__auto____5321
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3548__auto____5322 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3548__auto____5322) {
    return or__3548__auto____5322
  }else {
    var G__5323__5324 = f;
    if(G__5323__5324 != null) {
      if(function() {
        var or__3548__auto____5325 = G__5323__5324.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3548__auto____5325) {
          return or__3548__auto____5325
        }else {
          return G__5323__5324.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__5323__5324.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5323__5324)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5323__5324)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____5326 = cljs.core.number_QMARK_.call(null, n);
  if(and__3546__auto____5326) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____5326
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5327 = coll;
    if(cljs.core.truth_(and__3546__auto____5327)) {
      var and__3546__auto____5328 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3546__auto____5328) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____5328
      }
    }else {
      return and__3546__auto____5327
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3 = function() {
    var G__5333__delegate = function(x, y, more) {
      if(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))) {
        var s__5329 = cljs.core.set([y, x]);
        var xs__5330 = more;
        while(true) {
          var x__5331 = cljs.core.first.call(null, xs__5330);
          var etc__5332 = cljs.core.next.call(null, xs__5330);
          if(cljs.core.truth_(xs__5330)) {
            if(cljs.core.contains_QMARK_.call(null, s__5329, x__5331)) {
              return false
            }else {
              var G__5334 = cljs.core.conj.call(null, s__5329, x__5331);
              var G__5335 = etc__5332;
              s__5329 = G__5334;
              xs__5330 = G__5335;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__5333 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5333__delegate.call(this, x, y, more)
    };
    G__5333.cljs$lang$maxFixedArity = 2;
    G__5333.cljs$lang$applyTo = function(arglist__5336) {
      var x = cljs.core.first(arglist__5336);
      var y = cljs.core.first(cljs.core.next(arglist__5336));
      var more = cljs.core.rest(cljs.core.next(arglist__5336));
      return G__5333__delegate(x, y, more)
    };
    G__5333.cljs$lang$arity$variadic = G__5333__delegate;
    return G__5333
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
    return goog.array.defaultCompare.call(null, x, y)
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if("\ufdd0'else") {
          throw new Error("compare on non-nil objects of different types");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__5337 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__5337)) {
        return r__5337
      }else {
        if(cljs.core.truth_(r__5337)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
void 0;
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__5338 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__5338, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__5338)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3695__auto____5339 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____5339)) {
      var s__5340 = temp__3695__auto____5339;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__5340), cljs.core.next.call(null, s__5340))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__5341 = val;
    var coll__5342 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__5342)) {
        var nval__5343 = f.call(null, val__5341, cljs.core.first.call(null, coll__5342));
        if(cljs.core.reduced_QMARK_.call(null, nval__5343)) {
          return cljs.core.deref.call(null, nval__5343)
        }else {
          var G__5344 = nval__5343;
          var G__5345 = cljs.core.next.call(null, coll__5342);
          val__5341 = G__5344;
          coll__5342 = G__5345;
          continue
        }
      }else {
        return val__5341
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__5346__5347 = coll;
      if(G__5346__5347 != null) {
        if(function() {
          var or__3548__auto____5348 = G__5346__5347.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5348) {
            return or__3548__auto____5348
          }else {
            return G__5346__5347.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5346__5347.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5346__5347)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5346__5347)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__5349__5350 = coll;
      if(G__5349__5350 != null) {
        if(function() {
          var or__3548__auto____5351 = G__5349__5350.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5351) {
            return or__3548__auto____5351
          }else {
            return G__5349__5350.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5349__5350.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5349__5350)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5349__5350)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16384
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$ = true;
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__5352 = this;
  return this__5352.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__5353__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__5353 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5353__delegate.call(this, x, y, more)
    };
    G__5353.cljs$lang$maxFixedArity = 2;
    G__5353.cljs$lang$applyTo = function(arglist__5354) {
      var x = cljs.core.first(arglist__5354);
      var y = cljs.core.first(cljs.core.next(arglist__5354));
      var more = cljs.core.rest(cljs.core.next(arglist__5354));
      return G__5353__delegate(x, y, more)
    };
    G__5353.cljs$lang$arity$variadic = G__5353__delegate;
    return G__5353
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__5355__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__5355 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5355__delegate.call(this, x, y, more)
    };
    G__5355.cljs$lang$maxFixedArity = 2;
    G__5355.cljs$lang$applyTo = function(arglist__5356) {
      var x = cljs.core.first(arglist__5356);
      var y = cljs.core.first(cljs.core.next(arglist__5356));
      var more = cljs.core.rest(cljs.core.next(arglist__5356));
      return G__5355__delegate(x, y, more)
    };
    G__5355.cljs$lang$arity$variadic = G__5355__delegate;
    return G__5355
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__5357__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__5357 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5357__delegate.call(this, x, y, more)
    };
    G__5357.cljs$lang$maxFixedArity = 2;
    G__5357.cljs$lang$applyTo = function(arglist__5358) {
      var x = cljs.core.first(arglist__5358);
      var y = cljs.core.first(cljs.core.next(arglist__5358));
      var more = cljs.core.rest(cljs.core.next(arglist__5358));
      return G__5357__delegate(x, y, more)
    };
    G__5357.cljs$lang$arity$variadic = G__5357__delegate;
    return G__5357
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__5359__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__5359 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5359__delegate.call(this, x, y, more)
    };
    G__5359.cljs$lang$maxFixedArity = 2;
    G__5359.cljs$lang$applyTo = function(arglist__5360) {
      var x = cljs.core.first(arglist__5360);
      var y = cljs.core.first(cljs.core.next(arglist__5360));
      var more = cljs.core.rest(cljs.core.next(arglist__5360));
      return G__5359__delegate(x, y, more)
    };
    G__5359.cljs$lang$arity$variadic = G__5359__delegate;
    return G__5359
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__5361__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5362 = y;
            var G__5363 = cljs.core.first.call(null, more);
            var G__5364 = cljs.core.next.call(null, more);
            x = G__5362;
            y = G__5363;
            more = G__5364;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5361 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5361__delegate.call(this, x, y, more)
    };
    G__5361.cljs$lang$maxFixedArity = 2;
    G__5361.cljs$lang$applyTo = function(arglist__5365) {
      var x = cljs.core.first(arglist__5365);
      var y = cljs.core.first(cljs.core.next(arglist__5365));
      var more = cljs.core.rest(cljs.core.next(arglist__5365));
      return G__5361__delegate(x, y, more)
    };
    G__5361.cljs$lang$arity$variadic = G__5361__delegate;
    return G__5361
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__5366__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5367 = y;
            var G__5368 = cljs.core.first.call(null, more);
            var G__5369 = cljs.core.next.call(null, more);
            x = G__5367;
            y = G__5368;
            more = G__5369;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5366 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5366__delegate.call(this, x, y, more)
    };
    G__5366.cljs$lang$maxFixedArity = 2;
    G__5366.cljs$lang$applyTo = function(arglist__5370) {
      var x = cljs.core.first(arglist__5370);
      var y = cljs.core.first(cljs.core.next(arglist__5370));
      var more = cljs.core.rest(cljs.core.next(arglist__5370));
      return G__5366__delegate(x, y, more)
    };
    G__5366.cljs$lang$arity$variadic = G__5366__delegate;
    return G__5366
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__5371__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5372 = y;
            var G__5373 = cljs.core.first.call(null, more);
            var G__5374 = cljs.core.next.call(null, more);
            x = G__5372;
            y = G__5373;
            more = G__5374;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5371 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5371__delegate.call(this, x, y, more)
    };
    G__5371.cljs$lang$maxFixedArity = 2;
    G__5371.cljs$lang$applyTo = function(arglist__5375) {
      var x = cljs.core.first(arglist__5375);
      var y = cljs.core.first(cljs.core.next(arglist__5375));
      var more = cljs.core.rest(cljs.core.next(arglist__5375));
      return G__5371__delegate(x, y, more)
    };
    G__5371.cljs$lang$arity$variadic = G__5371__delegate;
    return G__5371
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__5376__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5377 = y;
            var G__5378 = cljs.core.first.call(null, more);
            var G__5379 = cljs.core.next.call(null, more);
            x = G__5377;
            y = G__5378;
            more = G__5379;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5376 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5376__delegate.call(this, x, y, more)
    };
    G__5376.cljs$lang$maxFixedArity = 2;
    G__5376.cljs$lang$applyTo = function(arglist__5380) {
      var x = cljs.core.first(arglist__5380);
      var y = cljs.core.first(cljs.core.next(arglist__5380));
      var more = cljs.core.rest(cljs.core.next(arglist__5380));
      return G__5376__delegate(x, y, more)
    };
    G__5376.cljs$lang$arity$variadic = G__5376__delegate;
    return G__5376
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__5381__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__5381 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5381__delegate.call(this, x, y, more)
    };
    G__5381.cljs$lang$maxFixedArity = 2;
    G__5381.cljs$lang$applyTo = function(arglist__5382) {
      var x = cljs.core.first(arglist__5382);
      var y = cljs.core.first(cljs.core.next(arglist__5382));
      var more = cljs.core.rest(cljs.core.next(arglist__5382));
      return G__5381__delegate(x, y, more)
    };
    G__5381.cljs$lang$arity$variadic = G__5381__delegate;
    return G__5381
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__5383__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__5383 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5383__delegate.call(this, x, y, more)
    };
    G__5383.cljs$lang$maxFixedArity = 2;
    G__5383.cljs$lang$applyTo = function(arglist__5384) {
      var x = cljs.core.first(arglist__5384);
      var y = cljs.core.first(cljs.core.next(arglist__5384));
      var more = cljs.core.rest(cljs.core.next(arglist__5384));
      return G__5383__delegate(x, y, more)
    };
    G__5383.cljs$lang$arity$variadic = G__5383__delegate;
    return G__5383
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__5385 = n % d;
  return cljs.core.fix.call(null, (n - rem__5385) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__5386 = cljs.core.quot.call(null, n, d);
  return n - d * q__5386
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(n) {
  var c__5387 = 0;
  var n__5388 = n;
  while(true) {
    if(n__5388 === 0) {
      return c__5387
    }else {
      var G__5389 = c__5387 + 1;
      var G__5390 = n__5388 & n__5388 - 1;
      c__5387 = G__5389;
      n__5388 = G__5390;
      continue
    }
    break
  }
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__5391__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5392 = y;
            var G__5393 = cljs.core.first.call(null, more);
            var G__5394 = cljs.core.next.call(null, more);
            x = G__5392;
            y = G__5393;
            more = G__5394;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5391 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5391__delegate.call(this, x, y, more)
    };
    G__5391.cljs$lang$maxFixedArity = 2;
    G__5391.cljs$lang$applyTo = function(arglist__5395) {
      var x = cljs.core.first(arglist__5395);
      var y = cljs.core.first(cljs.core.next(arglist__5395));
      var more = cljs.core.rest(cljs.core.next(arglist__5395));
      return G__5391__delegate(x, y, more)
    };
    G__5391.cljs$lang$arity$variadic = G__5391__delegate;
    return G__5391
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__5396 = n;
  var xs__5397 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5398 = xs__5397;
      if(cljs.core.truth_(and__3546__auto____5398)) {
        return n__5396 > 0
      }else {
        return and__3546__auto____5398
      }
    }())) {
      var G__5399 = n__5396 - 1;
      var G__5400 = cljs.core.next.call(null, xs__5397);
      n__5396 = G__5399;
      xs__5397 = G__5400;
      continue
    }else {
      return xs__5397
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__5401__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5402 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__5403 = cljs.core.next.call(null, more);
            sb = G__5402;
            more = G__5403;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__5401 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5401__delegate.call(this, x, ys)
    };
    G__5401.cljs$lang$maxFixedArity = 1;
    G__5401.cljs$lang$applyTo = function(arglist__5404) {
      var x = cljs.core.first(arglist__5404);
      var ys = cljs.core.rest(arglist__5404);
      return G__5401__delegate(x, ys)
    };
    G__5401.cljs$lang$arity$variadic = G__5401__delegate;
    return G__5401
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__5405__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5406 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__5407 = cljs.core.next.call(null, more);
            sb = G__5406;
            more = G__5407;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__5405 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5405__delegate.call(this, x, ys)
    };
    G__5405.cljs$lang$maxFixedArity = 1;
    G__5405.cljs$lang$applyTo = function(arglist__5408) {
      var x = cljs.core.first(arglist__5408);
      var ys = cljs.core.rest(arglist__5408);
      return G__5405__delegate(x, ys)
    };
    G__5405.cljs$lang$arity$variadic = G__5405__delegate;
    return G__5405
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__5409 = cljs.core.seq.call(null, x);
    var ys__5410 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__5409 == null) {
        return ys__5410 == null
      }else {
        if(ys__5410 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__5409), cljs.core.first.call(null, ys__5410))) {
            var G__5411 = cljs.core.next.call(null, xs__5409);
            var G__5412 = cljs.core.next.call(null, ys__5410);
            xs__5409 = G__5411;
            ys__5410 = G__5412;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__5413_SHARP_, p2__5414_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__5413_SHARP_, cljs.core.hash.call(null, p2__5414_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
void 0;
void 0;
cljs.core.hash_imap = function hash_imap(m) {
  var h__5415 = 0;
  var s__5416 = cljs.core.seq.call(null, m);
  while(true) {
    if(cljs.core.truth_(s__5416)) {
      var e__5417 = cljs.core.first.call(null, s__5416);
      var G__5418 = (h__5415 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__5417)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__5417)))) % 4503599627370496;
      var G__5419 = cljs.core.next.call(null, s__5416);
      h__5415 = G__5418;
      s__5416 = G__5419;
      continue
    }else {
      return h__5415
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__5420 = 0;
  var s__5421 = cljs.core.seq.call(null, s);
  while(true) {
    if(cljs.core.truth_(s__5421)) {
      var e__5422 = cljs.core.first.call(null, s__5421);
      var G__5423 = (h__5420 + cljs.core.hash.call(null, e__5422)) % 4503599627370496;
      var G__5424 = cljs.core.next.call(null, s__5421);
      h__5420 = G__5423;
      s__5421 = G__5424;
      continue
    }else {
      return h__5420
    }
    break
  }
};
void 0;
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__5425__5426 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__5425__5426)) {
    var G__5428__5430 = cljs.core.first.call(null, G__5425__5426);
    var vec__5429__5431 = G__5428__5430;
    var key_name__5432 = cljs.core.nth.call(null, vec__5429__5431, 0, null);
    var f__5433 = cljs.core.nth.call(null, vec__5429__5431, 1, null);
    var G__5425__5434 = G__5425__5426;
    var G__5428__5435 = G__5428__5430;
    var G__5425__5436 = G__5425__5434;
    while(true) {
      var vec__5437__5438 = G__5428__5435;
      var key_name__5439 = cljs.core.nth.call(null, vec__5437__5438, 0, null);
      var f__5440 = cljs.core.nth.call(null, vec__5437__5438, 1, null);
      var G__5425__5441 = G__5425__5436;
      var str_name__5442 = cljs.core.name.call(null, key_name__5439);
      obj[str_name__5442] = f__5440;
      var temp__3698__auto____5443 = cljs.core.next.call(null, G__5425__5441);
      if(cljs.core.truth_(temp__3698__auto____5443)) {
        var G__5425__5444 = temp__3698__auto____5443;
        var G__5445 = cljs.core.first.call(null, G__5425__5444);
        var G__5446 = G__5425__5444;
        G__5428__5435 = G__5445;
        G__5425__5436 = G__5446;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706670
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5447 = this;
  var h__364__auto____5448 = this__5447.__hash;
  if(h__364__auto____5448 != null) {
    return h__364__auto____5448
  }else {
    var h__364__auto____5449 = cljs.core.hash_coll.call(null, coll);
    this__5447.__hash = h__364__auto____5449;
    return h__364__auto____5449
  }
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5450 = this;
  return new cljs.core.List(this__5450.meta, o, coll, this__5450.count + 1, null)
};
cljs.core.List.prototype.cljs$core$ASeq$ = true;
cljs.core.List.prototype.toString = function() {
  var this__5451 = this;
  var this$__5452 = this;
  return cljs.core.pr_str.call(null, this$__5452)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5453 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5454 = this;
  return this__5454.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5455 = this;
  return this__5455.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5456 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5457 = this;
  return this__5457.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5458 = this;
  return this__5458.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5459 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5460 = this;
  return new cljs.core.List(meta, this__5460.first, this__5460.rest, this__5460.count, this__5460.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5461 = this;
  return this__5461.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5462 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List.prototype.cljs$core$IList$ = true;
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706638
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5463 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5464 = this;
  return new cljs.core.List(this__5464.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__5465 = this;
  var this$__5466 = this;
  return cljs.core.pr_str.call(null, this$__5466)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5467 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5468 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5469 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5470 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5471 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5472 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5473 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5474 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5475 = this;
  return this__5475.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5476 = this;
  return coll
};
cljs.core.EmptyList.prototype.cljs$core$IList$ = true;
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__5477__5478 = coll;
  if(G__5477__5478 != null) {
    if(function() {
      var or__3548__auto____5479 = G__5477__5478.cljs$lang$protocol_mask$partition0$ & 67108864;
      if(or__3548__auto____5479) {
        return or__3548__auto____5479
      }else {
        return G__5477__5478.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__5477__5478.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5477__5478)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5477__5478)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__5480) {
    var items = cljs.core.seq(arglist__5480);
    return list__delegate(items)
  };
  list.cljs$lang$arity$variadic = list__delegate;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32702572
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5481 = this;
  var h__364__auto____5482 = this__5481.__hash;
  if(h__364__auto____5482 != null) {
    return h__364__auto____5482
  }else {
    var h__364__auto____5483 = cljs.core.hash_coll.call(null, coll);
    this__5481.__hash = h__364__auto____5483;
    return h__364__auto____5483
  }
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5484 = this;
  return new cljs.core.Cons(null, o, coll, this__5484.__hash)
};
cljs.core.Cons.prototype.cljs$core$ASeq$ = true;
cljs.core.Cons.prototype.toString = function() {
  var this__5485 = this;
  var this$__5486 = this;
  return cljs.core.pr_str.call(null, this$__5486)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5487 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5488 = this;
  return this__5488.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5489 = this;
  if(this__5489.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__5489.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5490 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5491 = this;
  return new cljs.core.Cons(meta, this__5491.first, this__5491.rest, this__5491.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5492 = this;
  return this__5492.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5493 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5493.meta)
};
cljs.core.Cons.prototype.cljs$core$IList$ = true;
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3548__auto____5494 = coll == null;
    if(or__3548__auto____5494) {
      return or__3548__auto____5494
    }else {
      var G__5495__5496 = coll;
      if(G__5495__5496 != null) {
        if(function() {
          var or__3548__auto____5497 = G__5495__5496.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5497) {
            return or__3548__auto____5497
          }else {
            return G__5495__5496.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5495__5496.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5495__5496)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5495__5496)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__5498__5499 = x;
  if(G__5498__5499 != null) {
    if(function() {
      var or__3548__auto____5500 = G__5498__5499.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3548__auto____5500) {
        return or__3548__auto____5500
      }else {
        return G__5498__5499.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__5498__5499.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5498__5499)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5498__5499)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__5501 = null;
  var G__5501__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__5501__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__5501 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5501__2.call(this, string, f);
      case 3:
        return G__5501__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5501
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__5502 = null;
  var G__5502__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__5502__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__5502 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5502__2.call(this, string, k);
      case 3:
        return G__5502__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5502
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__5503 = null;
  var G__5503__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__5503__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__5503 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5503__2.call(this, string, n);
      case 3:
        return G__5503__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5503
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__5512 = null;
  var G__5512__2 = function(tsym5506, coll) {
    var tsym5506__5508 = this;
    var this$__5509 = tsym5506__5508;
    return cljs.core.get.call(null, coll, this$__5509.toString())
  };
  var G__5512__3 = function(tsym5507, coll, not_found) {
    var tsym5507__5510 = this;
    var this$__5511 = tsym5507__5510;
    return cljs.core.get.call(null, coll, this$__5511.toString(), not_found)
  };
  G__5512 = function(tsym5507, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5512__2.call(this, tsym5507, coll);
      case 3:
        return G__5512__3.call(this, tsym5507, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5512
}();
String.prototype.apply = function(tsym5504, args5505) {
  return tsym5504.call.apply(tsym5504, [tsym5504].concat(cljs.core.aclone.call(null, args5505)))
};
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__5513 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__5513
  }else {
    lazy_seq.x = x__5513.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5514 = this;
  var h__364__auto____5515 = this__5514.__hash;
  if(h__364__auto____5515 != null) {
    return h__364__auto____5515
  }else {
    var h__364__auto____5516 = cljs.core.hash_coll.call(null, coll);
    this__5514.__hash = h__364__auto____5516;
    return h__364__auto____5516
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5517 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__5518 = this;
  var this$__5519 = this;
  return cljs.core.pr_str.call(null, this$__5519)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5520 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5521 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5522 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5523 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5524 = this;
  return new cljs.core.LazySeq(meta, this__5524.realized, this__5524.x, this__5524.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5525 = this;
  return this__5525.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5526 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5526.meta)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__5527 = [];
  var s__5528 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__5528))) {
      ary__5527.push(cljs.core.first.call(null, s__5528));
      var G__5529 = cljs.core.next.call(null, s__5528);
      s__5528 = G__5529;
      continue
    }else {
      return ary__5527
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__5530 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__5531 = 0;
  var xs__5532 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(xs__5532)) {
      ret__5530[i__5531] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__5532));
      var G__5533 = i__5531 + 1;
      var G__5534 = cljs.core.next.call(null, xs__5532);
      i__5531 = G__5533;
      xs__5532 = G__5534;
      continue
    }else {
    }
    break
  }
  return ret__5530
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__5535 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5536 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5537 = 0;
      var s__5538 = s__5536;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5539 = s__5538;
          if(cljs.core.truth_(and__3546__auto____5539)) {
            return i__5537 < size
          }else {
            return and__3546__auto____5539
          }
        }())) {
          a__5535[i__5537] = cljs.core.first.call(null, s__5538);
          var G__5542 = i__5537 + 1;
          var G__5543 = cljs.core.next.call(null, s__5538);
          i__5537 = G__5542;
          s__5538 = G__5543;
          continue
        }else {
          return a__5535
        }
        break
      }
    }else {
      var n__685__auto____5540 = size;
      var i__5541 = 0;
      while(true) {
        if(i__5541 < n__685__auto____5540) {
          a__5535[i__5541] = init_val_or_seq;
          var G__5544 = i__5541 + 1;
          i__5541 = G__5544;
          continue
        }else {
        }
        break
      }
      return a__5535
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__5545 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5546 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5547 = 0;
      var s__5548 = s__5546;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5549 = s__5548;
          if(cljs.core.truth_(and__3546__auto____5549)) {
            return i__5547 < size
          }else {
            return and__3546__auto____5549
          }
        }())) {
          a__5545[i__5547] = cljs.core.first.call(null, s__5548);
          var G__5552 = i__5547 + 1;
          var G__5553 = cljs.core.next.call(null, s__5548);
          i__5547 = G__5552;
          s__5548 = G__5553;
          continue
        }else {
          return a__5545
        }
        break
      }
    }else {
      var n__685__auto____5550 = size;
      var i__5551 = 0;
      while(true) {
        if(i__5551 < n__685__auto____5550) {
          a__5545[i__5551] = init_val_or_seq;
          var G__5554 = i__5551 + 1;
          i__5551 = G__5554;
          continue
        }else {
        }
        break
      }
      return a__5545
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__5555 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5556 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5557 = 0;
      var s__5558 = s__5556;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5559 = s__5558;
          if(cljs.core.truth_(and__3546__auto____5559)) {
            return i__5557 < size
          }else {
            return and__3546__auto____5559
          }
        }())) {
          a__5555[i__5557] = cljs.core.first.call(null, s__5558);
          var G__5562 = i__5557 + 1;
          var G__5563 = cljs.core.next.call(null, s__5558);
          i__5557 = G__5562;
          s__5558 = G__5563;
          continue
        }else {
          return a__5555
        }
        break
      }
    }else {
      var n__685__auto____5560 = size;
      var i__5561 = 0;
      while(true) {
        if(i__5561 < n__685__auto____5560) {
          a__5555[i__5561] = init_val_or_seq;
          var G__5564 = i__5561 + 1;
          i__5561 = G__5564;
          continue
        }else {
        }
        break
      }
      return a__5555
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__5565 = s;
    var i__5566 = n;
    var sum__5567 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____5568 = i__5566 > 0;
        if(and__3546__auto____5568) {
          return cljs.core.seq.call(null, s__5565)
        }else {
          return and__3546__auto____5568
        }
      }())) {
        var G__5569 = cljs.core.next.call(null, s__5565);
        var G__5570 = i__5566 - 1;
        var G__5571 = sum__5567 + 1;
        s__5565 = G__5569;
        i__5566 = G__5570;
        sum__5567 = G__5571;
        continue
      }else {
        return sum__5567
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__5572 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__5572)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5572), concat.call(null, cljs.core.rest.call(null, s__5572), y))
      }else {
        return y
      }
    })
  };
  var concat__3 = function() {
    var G__5575__delegate = function(x, y, zs) {
      var cat__5574 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__5573 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__5573)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__5573), cat.call(null, cljs.core.rest.call(null, xys__5573), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__5574.call(null, concat.call(null, x, y), zs)
    };
    var G__5575 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5575__delegate.call(this, x, y, zs)
    };
    G__5575.cljs$lang$maxFixedArity = 2;
    G__5575.cljs$lang$applyTo = function(arglist__5576) {
      var x = cljs.core.first(arglist__5576);
      var y = cljs.core.first(cljs.core.next(arglist__5576));
      var zs = cljs.core.rest(cljs.core.next(arglist__5576));
      return G__5575__delegate(x, y, zs)
    };
    G__5575.cljs$lang$arity$variadic = G__5575__delegate;
    return G__5575
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__5577__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__5577 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5577__delegate.call(this, a, b, c, d, more)
    };
    G__5577.cljs$lang$maxFixedArity = 4;
    G__5577.cljs$lang$applyTo = function(arglist__5578) {
      var a = cljs.core.first(arglist__5578);
      var b = cljs.core.first(cljs.core.next(arglist__5578));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5578)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5578))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5578))));
      return G__5577__delegate(a, b, c, d, more)
    };
    G__5577.cljs$lang$arity$variadic = G__5577__delegate;
    return G__5577
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
void 0;
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__5579 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__5580 = cljs.core._first.call(null, args__5579);
    var args__5581 = cljs.core._rest.call(null, args__5579);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__5580)
      }else {
        return f.call(null, a__5580)
      }
    }else {
      var b__5582 = cljs.core._first.call(null, args__5581);
      var args__5583 = cljs.core._rest.call(null, args__5581);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__5580, b__5582)
        }else {
          return f.call(null, a__5580, b__5582)
        }
      }else {
        var c__5584 = cljs.core._first.call(null, args__5583);
        var args__5585 = cljs.core._rest.call(null, args__5583);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__5580, b__5582, c__5584)
          }else {
            return f.call(null, a__5580, b__5582, c__5584)
          }
        }else {
          var d__5586 = cljs.core._first.call(null, args__5585);
          var args__5587 = cljs.core._rest.call(null, args__5585);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__5580, b__5582, c__5584, d__5586)
            }else {
              return f.call(null, a__5580, b__5582, c__5584, d__5586)
            }
          }else {
            var e__5588 = cljs.core._first.call(null, args__5587);
            var args__5589 = cljs.core._rest.call(null, args__5587);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__5580, b__5582, c__5584, d__5586, e__5588)
              }else {
                return f.call(null, a__5580, b__5582, c__5584, d__5586, e__5588)
              }
            }else {
              var f__5590 = cljs.core._first.call(null, args__5589);
              var args__5591 = cljs.core._rest.call(null, args__5589);
              if(argc === 6) {
                if(f__5590.cljs$lang$arity$6) {
                  return f__5590.cljs$lang$arity$6(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590)
                }else {
                  return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590)
                }
              }else {
                var g__5592 = cljs.core._first.call(null, args__5591);
                var args__5593 = cljs.core._rest.call(null, args__5591);
                if(argc === 7) {
                  if(f__5590.cljs$lang$arity$7) {
                    return f__5590.cljs$lang$arity$7(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592)
                  }else {
                    return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592)
                  }
                }else {
                  var h__5594 = cljs.core._first.call(null, args__5593);
                  var args__5595 = cljs.core._rest.call(null, args__5593);
                  if(argc === 8) {
                    if(f__5590.cljs$lang$arity$8) {
                      return f__5590.cljs$lang$arity$8(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594)
                    }else {
                      return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594)
                    }
                  }else {
                    var i__5596 = cljs.core._first.call(null, args__5595);
                    var args__5597 = cljs.core._rest.call(null, args__5595);
                    if(argc === 9) {
                      if(f__5590.cljs$lang$arity$9) {
                        return f__5590.cljs$lang$arity$9(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596)
                      }else {
                        return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596)
                      }
                    }else {
                      var j__5598 = cljs.core._first.call(null, args__5597);
                      var args__5599 = cljs.core._rest.call(null, args__5597);
                      if(argc === 10) {
                        if(f__5590.cljs$lang$arity$10) {
                          return f__5590.cljs$lang$arity$10(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598)
                        }else {
                          return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598)
                        }
                      }else {
                        var k__5600 = cljs.core._first.call(null, args__5599);
                        var args__5601 = cljs.core._rest.call(null, args__5599);
                        if(argc === 11) {
                          if(f__5590.cljs$lang$arity$11) {
                            return f__5590.cljs$lang$arity$11(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600)
                          }else {
                            return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600)
                          }
                        }else {
                          var l__5602 = cljs.core._first.call(null, args__5601);
                          var args__5603 = cljs.core._rest.call(null, args__5601);
                          if(argc === 12) {
                            if(f__5590.cljs$lang$arity$12) {
                              return f__5590.cljs$lang$arity$12(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602)
                            }else {
                              return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602)
                            }
                          }else {
                            var m__5604 = cljs.core._first.call(null, args__5603);
                            var args__5605 = cljs.core._rest.call(null, args__5603);
                            if(argc === 13) {
                              if(f__5590.cljs$lang$arity$13) {
                                return f__5590.cljs$lang$arity$13(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604)
                              }else {
                                return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604)
                              }
                            }else {
                              var n__5606 = cljs.core._first.call(null, args__5605);
                              var args__5607 = cljs.core._rest.call(null, args__5605);
                              if(argc === 14) {
                                if(f__5590.cljs$lang$arity$14) {
                                  return f__5590.cljs$lang$arity$14(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606)
                                }else {
                                  return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606)
                                }
                              }else {
                                var o__5608 = cljs.core._first.call(null, args__5607);
                                var args__5609 = cljs.core._rest.call(null, args__5607);
                                if(argc === 15) {
                                  if(f__5590.cljs$lang$arity$15) {
                                    return f__5590.cljs$lang$arity$15(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608)
                                  }else {
                                    return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608)
                                  }
                                }else {
                                  var p__5610 = cljs.core._first.call(null, args__5609);
                                  var args__5611 = cljs.core._rest.call(null, args__5609);
                                  if(argc === 16) {
                                    if(f__5590.cljs$lang$arity$16) {
                                      return f__5590.cljs$lang$arity$16(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610)
                                    }else {
                                      return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610)
                                    }
                                  }else {
                                    var q__5612 = cljs.core._first.call(null, args__5611);
                                    var args__5613 = cljs.core._rest.call(null, args__5611);
                                    if(argc === 17) {
                                      if(f__5590.cljs$lang$arity$17) {
                                        return f__5590.cljs$lang$arity$17(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610, q__5612)
                                      }else {
                                        return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610, q__5612)
                                      }
                                    }else {
                                      var r__5614 = cljs.core._first.call(null, args__5613);
                                      var args__5615 = cljs.core._rest.call(null, args__5613);
                                      if(argc === 18) {
                                        if(f__5590.cljs$lang$arity$18) {
                                          return f__5590.cljs$lang$arity$18(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610, q__5612, r__5614)
                                        }else {
                                          return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610, q__5612, r__5614)
                                        }
                                      }else {
                                        var s__5616 = cljs.core._first.call(null, args__5615);
                                        var args__5617 = cljs.core._rest.call(null, args__5615);
                                        if(argc === 19) {
                                          if(f__5590.cljs$lang$arity$19) {
                                            return f__5590.cljs$lang$arity$19(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610, q__5612, r__5614, s__5616)
                                          }else {
                                            return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610, q__5612, r__5614, s__5616)
                                          }
                                        }else {
                                          var t__5618 = cljs.core._first.call(null, args__5617);
                                          var args__5619 = cljs.core._rest.call(null, args__5617);
                                          if(argc === 20) {
                                            if(f__5590.cljs$lang$arity$20) {
                                              return f__5590.cljs$lang$arity$20(a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610, q__5612, r__5614, s__5616, t__5618)
                                            }else {
                                              return f__5590.call(null, a__5580, b__5582, c__5584, d__5586, e__5588, f__5590, g__5592, h__5594, i__5596, j__5598, k__5600, l__5602, m__5604, n__5606, o__5608, p__5610, q__5612, r__5614, s__5616, t__5618)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
void 0;
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__5620 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5621 = cljs.core.bounded_count.call(null, args, fixed_arity__5620 + 1);
      if(bc__5621 <= fixed_arity__5620) {
        return cljs.core.apply_to.call(null, f, bc__5621, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__5622 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__5623 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5624 = cljs.core.bounded_count.call(null, arglist__5622, fixed_arity__5623 + 1);
      if(bc__5624 <= fixed_arity__5623) {
        return cljs.core.apply_to.call(null, f, bc__5624, arglist__5622)
      }else {
        return f.cljs$lang$applyTo(arglist__5622)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5622))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__5625 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__5626 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5627 = cljs.core.bounded_count.call(null, arglist__5625, fixed_arity__5626 + 1);
      if(bc__5627 <= fixed_arity__5626) {
        return cljs.core.apply_to.call(null, f, bc__5627, arglist__5625)
      }else {
        return f.cljs$lang$applyTo(arglist__5625)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5625))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__5628 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__5629 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5630 = cljs.core.bounded_count.call(null, arglist__5628, fixed_arity__5629 + 1);
      if(bc__5630 <= fixed_arity__5629) {
        return cljs.core.apply_to.call(null, f, bc__5630, arglist__5628)
      }else {
        return f.cljs$lang$applyTo(arglist__5628)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5628))
    }
  };
  var apply__6 = function() {
    var G__5634__delegate = function(f, a, b, c, d, args) {
      var arglist__5631 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__5632 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__5633 = cljs.core.bounded_count.call(null, arglist__5631, fixed_arity__5632 + 1);
        if(bc__5633 <= fixed_arity__5632) {
          return cljs.core.apply_to.call(null, f, bc__5633, arglist__5631)
        }else {
          return f.cljs$lang$applyTo(arglist__5631)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__5631))
      }
    };
    var G__5634 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__5634__delegate.call(this, f, a, b, c, d, args)
    };
    G__5634.cljs$lang$maxFixedArity = 5;
    G__5634.cljs$lang$applyTo = function(arglist__5635) {
      var f = cljs.core.first(arglist__5635);
      var a = cljs.core.first(cljs.core.next(arglist__5635));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5635)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5635))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5635)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5635)))));
      return G__5634__delegate(f, a, b, c, d, args)
    };
    G__5634.cljs$lang$arity$variadic = G__5634__delegate;
    return G__5634
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__5636) {
    var obj = cljs.core.first(arglist__5636);
    var f = cljs.core.first(cljs.core.next(arglist__5636));
    var args = cljs.core.rest(cljs.core.next(arglist__5636));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3 = function() {
    var G__5637__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__5637 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5637__delegate.call(this, x, y, more)
    };
    G__5637.cljs$lang$maxFixedArity = 2;
    G__5637.cljs$lang$applyTo = function(arglist__5638) {
      var x = cljs.core.first(arglist__5638);
      var y = cljs.core.first(cljs.core.next(arglist__5638));
      var more = cljs.core.rest(cljs.core.next(arglist__5638));
      return G__5637__delegate(x, y, more)
    };
    G__5637.cljs$lang$arity$variadic = G__5637__delegate;
    return G__5637
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__5639 = pred;
        var G__5640 = cljs.core.next.call(null, coll);
        pred = G__5639;
        coll = G__5640;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____5641 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____5641)) {
        return or__3548__auto____5641
      }else {
        var G__5642 = pred;
        var G__5643 = cljs.core.next.call(null, coll);
        pred = G__5642;
        coll = G__5643;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__5644 = null;
    var G__5644__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__5644__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__5644__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__5644__3 = function() {
      var G__5645__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__5645 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__5645__delegate.call(this, x, y, zs)
      };
      G__5645.cljs$lang$maxFixedArity = 2;
      G__5645.cljs$lang$applyTo = function(arglist__5646) {
        var x = cljs.core.first(arglist__5646);
        var y = cljs.core.first(cljs.core.next(arglist__5646));
        var zs = cljs.core.rest(cljs.core.next(arglist__5646));
        return G__5645__delegate(x, y, zs)
      };
      G__5645.cljs$lang$arity$variadic = G__5645__delegate;
      return G__5645
    }();
    G__5644 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5644__0.call(this);
        case 1:
          return G__5644__1.call(this, x);
        case 2:
          return G__5644__2.call(this, x, y);
        default:
          return G__5644__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__5644.cljs$lang$maxFixedArity = 2;
    G__5644.cljs$lang$applyTo = G__5644__3.cljs$lang$applyTo;
    return G__5644
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__5647__delegate = function(args) {
      return x
    };
    var G__5647 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5647__delegate.call(this, args)
    };
    G__5647.cljs$lang$maxFixedArity = 0;
    G__5647.cljs$lang$applyTo = function(arglist__5648) {
      var args = cljs.core.seq(arglist__5648);
      return G__5647__delegate(args)
    };
    G__5647.cljs$lang$arity$variadic = G__5647__delegate;
    return G__5647
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__5652 = null;
      var G__5652__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__5652__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__5652__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__5652__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__5652__4 = function() {
        var G__5653__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__5653 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5653__delegate.call(this, x, y, z, args)
        };
        G__5653.cljs$lang$maxFixedArity = 3;
        G__5653.cljs$lang$applyTo = function(arglist__5654) {
          var x = cljs.core.first(arglist__5654);
          var y = cljs.core.first(cljs.core.next(arglist__5654));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5654)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5654)));
          return G__5653__delegate(x, y, z, args)
        };
        G__5653.cljs$lang$arity$variadic = G__5653__delegate;
        return G__5653
      }();
      G__5652 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5652__0.call(this);
          case 1:
            return G__5652__1.call(this, x);
          case 2:
            return G__5652__2.call(this, x, y);
          case 3:
            return G__5652__3.call(this, x, y, z);
          default:
            return G__5652__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5652.cljs$lang$maxFixedArity = 3;
      G__5652.cljs$lang$applyTo = G__5652__4.cljs$lang$applyTo;
      return G__5652
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__5655 = null;
      var G__5655__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__5655__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__5655__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__5655__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__5655__4 = function() {
        var G__5656__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__5656 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5656__delegate.call(this, x, y, z, args)
        };
        G__5656.cljs$lang$maxFixedArity = 3;
        G__5656.cljs$lang$applyTo = function(arglist__5657) {
          var x = cljs.core.first(arglist__5657);
          var y = cljs.core.first(cljs.core.next(arglist__5657));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5657)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5657)));
          return G__5656__delegate(x, y, z, args)
        };
        G__5656.cljs$lang$arity$variadic = G__5656__delegate;
        return G__5656
      }();
      G__5655 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5655__0.call(this);
          case 1:
            return G__5655__1.call(this, x);
          case 2:
            return G__5655__2.call(this, x, y);
          case 3:
            return G__5655__3.call(this, x, y, z);
          default:
            return G__5655__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5655.cljs$lang$maxFixedArity = 3;
      G__5655.cljs$lang$applyTo = G__5655__4.cljs$lang$applyTo;
      return G__5655
    }()
  };
  var comp__4 = function() {
    var G__5658__delegate = function(f1, f2, f3, fs) {
      var fs__5649 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__5659__delegate = function(args) {
          var ret__5650 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__5649), args);
          var fs__5651 = cljs.core.next.call(null, fs__5649);
          while(true) {
            if(cljs.core.truth_(fs__5651)) {
              var G__5660 = cljs.core.first.call(null, fs__5651).call(null, ret__5650);
              var G__5661 = cljs.core.next.call(null, fs__5651);
              ret__5650 = G__5660;
              fs__5651 = G__5661;
              continue
            }else {
              return ret__5650
            }
            break
          }
        };
        var G__5659 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5659__delegate.call(this, args)
        };
        G__5659.cljs$lang$maxFixedArity = 0;
        G__5659.cljs$lang$applyTo = function(arglist__5662) {
          var args = cljs.core.seq(arglist__5662);
          return G__5659__delegate(args)
        };
        G__5659.cljs$lang$arity$variadic = G__5659__delegate;
        return G__5659
      }()
    };
    var G__5658 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5658__delegate.call(this, f1, f2, f3, fs)
    };
    G__5658.cljs$lang$maxFixedArity = 3;
    G__5658.cljs$lang$applyTo = function(arglist__5663) {
      var f1 = cljs.core.first(arglist__5663);
      var f2 = cljs.core.first(cljs.core.next(arglist__5663));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5663)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5663)));
      return G__5658__delegate(f1, f2, f3, fs)
    };
    G__5658.cljs$lang$arity$variadic = G__5658__delegate;
    return G__5658
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__5664__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__5664 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5664__delegate.call(this, args)
      };
      G__5664.cljs$lang$maxFixedArity = 0;
      G__5664.cljs$lang$applyTo = function(arglist__5665) {
        var args = cljs.core.seq(arglist__5665);
        return G__5664__delegate(args)
      };
      G__5664.cljs$lang$arity$variadic = G__5664__delegate;
      return G__5664
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__5666__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__5666 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5666__delegate.call(this, args)
      };
      G__5666.cljs$lang$maxFixedArity = 0;
      G__5666.cljs$lang$applyTo = function(arglist__5667) {
        var args = cljs.core.seq(arglist__5667);
        return G__5666__delegate(args)
      };
      G__5666.cljs$lang$arity$variadic = G__5666__delegate;
      return G__5666
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__5668__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__5668 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5668__delegate.call(this, args)
      };
      G__5668.cljs$lang$maxFixedArity = 0;
      G__5668.cljs$lang$applyTo = function(arglist__5669) {
        var args = cljs.core.seq(arglist__5669);
        return G__5668__delegate(args)
      };
      G__5668.cljs$lang$arity$variadic = G__5668__delegate;
      return G__5668
    }()
  };
  var partial__5 = function() {
    var G__5670__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__5671__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__5671 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5671__delegate.call(this, args)
        };
        G__5671.cljs$lang$maxFixedArity = 0;
        G__5671.cljs$lang$applyTo = function(arglist__5672) {
          var args = cljs.core.seq(arglist__5672);
          return G__5671__delegate(args)
        };
        G__5671.cljs$lang$arity$variadic = G__5671__delegate;
        return G__5671
      }()
    };
    var G__5670 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5670__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__5670.cljs$lang$maxFixedArity = 4;
    G__5670.cljs$lang$applyTo = function(arglist__5673) {
      var f = cljs.core.first(arglist__5673);
      var arg1 = cljs.core.first(cljs.core.next(arglist__5673));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5673)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5673))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5673))));
      return G__5670__delegate(f, arg1, arg2, arg3, more)
    };
    G__5670.cljs$lang$arity$variadic = G__5670__delegate;
    return G__5670
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__5674 = null;
      var G__5674__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__5674__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__5674__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__5674__4 = function() {
        var G__5675__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__5675 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5675__delegate.call(this, a, b, c, ds)
        };
        G__5675.cljs$lang$maxFixedArity = 3;
        G__5675.cljs$lang$applyTo = function(arglist__5676) {
          var a = cljs.core.first(arglist__5676);
          var b = cljs.core.first(cljs.core.next(arglist__5676));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5676)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5676)));
          return G__5675__delegate(a, b, c, ds)
        };
        G__5675.cljs$lang$arity$variadic = G__5675__delegate;
        return G__5675
      }();
      G__5674 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__5674__1.call(this, a);
          case 2:
            return G__5674__2.call(this, a, b);
          case 3:
            return G__5674__3.call(this, a, b, c);
          default:
            return G__5674__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5674.cljs$lang$maxFixedArity = 3;
      G__5674.cljs$lang$applyTo = G__5674__4.cljs$lang$applyTo;
      return G__5674
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__5677 = null;
      var G__5677__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5677__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__5677__4 = function() {
        var G__5678__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__5678 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5678__delegate.call(this, a, b, c, ds)
        };
        G__5678.cljs$lang$maxFixedArity = 3;
        G__5678.cljs$lang$applyTo = function(arglist__5679) {
          var a = cljs.core.first(arglist__5679);
          var b = cljs.core.first(cljs.core.next(arglist__5679));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5679)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5679)));
          return G__5678__delegate(a, b, c, ds)
        };
        G__5678.cljs$lang$arity$variadic = G__5678__delegate;
        return G__5678
      }();
      G__5677 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5677__2.call(this, a, b);
          case 3:
            return G__5677__3.call(this, a, b, c);
          default:
            return G__5677__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5677.cljs$lang$maxFixedArity = 3;
      G__5677.cljs$lang$applyTo = G__5677__4.cljs$lang$applyTo;
      return G__5677
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__5680 = null;
      var G__5680__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5680__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__5680__4 = function() {
        var G__5681__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__5681 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5681__delegate.call(this, a, b, c, ds)
        };
        G__5681.cljs$lang$maxFixedArity = 3;
        G__5681.cljs$lang$applyTo = function(arglist__5682) {
          var a = cljs.core.first(arglist__5682);
          var b = cljs.core.first(cljs.core.next(arglist__5682));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5682)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5682)));
          return G__5681__delegate(a, b, c, ds)
        };
        G__5681.cljs$lang$arity$variadic = G__5681__delegate;
        return G__5681
      }();
      G__5680 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5680__2.call(this, a, b);
          case 3:
            return G__5680__3.call(this, a, b, c);
          default:
            return G__5680__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5680.cljs$lang$maxFixedArity = 3;
      G__5680.cljs$lang$applyTo = G__5680__4.cljs$lang$applyTo;
      return G__5680
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__5685 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5683 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5683)) {
        var s__5684 = temp__3698__auto____5683;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__5684)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__5684)))
      }else {
        return null
      }
    })
  };
  return mapi__5685.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5686 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5686)) {
      var s__5687 = temp__3698__auto____5686;
      var x__5688 = f.call(null, cljs.core.first.call(null, s__5687));
      if(x__5688 == null) {
        return keep.call(null, f, cljs.core.rest.call(null, s__5687))
      }else {
        return cljs.core.cons.call(null, x__5688, keep.call(null, f, cljs.core.rest.call(null, s__5687)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__5698 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5695 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5695)) {
        var s__5696 = temp__3698__auto____5695;
        var x__5697 = f.call(null, idx, cljs.core.first.call(null, s__5696));
        if(x__5697 == null) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5696))
        }else {
          return cljs.core.cons.call(null, x__5697, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5696)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__5698.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5705 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5705)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____5705
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5706 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5706)) {
            var and__3546__auto____5707 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5707)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____5707
            }
          }else {
            return and__3546__auto____5706
          }
        }())
      };
      var ep1__4 = function() {
        var G__5743__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5708 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5708)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____5708
            }
          }())
        };
        var G__5743 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5743__delegate.call(this, x, y, z, args)
        };
        G__5743.cljs$lang$maxFixedArity = 3;
        G__5743.cljs$lang$applyTo = function(arglist__5744) {
          var x = cljs.core.first(arglist__5744);
          var y = cljs.core.first(cljs.core.next(arglist__5744));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5744)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5744)));
          return G__5743__delegate(x, y, z, args)
        };
        G__5743.cljs$lang$arity$variadic = G__5743__delegate;
        return G__5743
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5709 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5709)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____5709
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5710 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5710)) {
            var and__3546__auto____5711 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5711)) {
              var and__3546__auto____5712 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5712)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____5712
              }
            }else {
              return and__3546__auto____5711
            }
          }else {
            return and__3546__auto____5710
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5713 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5713)) {
            var and__3546__auto____5714 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5714)) {
              var and__3546__auto____5715 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____5715)) {
                var and__3546__auto____5716 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____5716)) {
                  var and__3546__auto____5717 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5717)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____5717
                  }
                }else {
                  return and__3546__auto____5716
                }
              }else {
                return and__3546__auto____5715
              }
            }else {
              return and__3546__auto____5714
            }
          }else {
            return and__3546__auto____5713
          }
        }())
      };
      var ep2__4 = function() {
        var G__5745__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5718 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5718)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5689_SHARP_) {
                var and__3546__auto____5719 = p1.call(null, p1__5689_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5719)) {
                  return p2.call(null, p1__5689_SHARP_)
                }else {
                  return and__3546__auto____5719
                }
              }, args)
            }else {
              return and__3546__auto____5718
            }
          }())
        };
        var G__5745 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5745__delegate.call(this, x, y, z, args)
        };
        G__5745.cljs$lang$maxFixedArity = 3;
        G__5745.cljs$lang$applyTo = function(arglist__5746) {
          var x = cljs.core.first(arglist__5746);
          var y = cljs.core.first(cljs.core.next(arglist__5746));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5746)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5746)));
          return G__5745__delegate(x, y, z, args)
        };
        G__5745.cljs$lang$arity$variadic = G__5745__delegate;
        return G__5745
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5720 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5720)) {
            var and__3546__auto____5721 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5721)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____5721
            }
          }else {
            return and__3546__auto____5720
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5722 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5722)) {
            var and__3546__auto____5723 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5723)) {
              var and__3546__auto____5724 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5724)) {
                var and__3546__auto____5725 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5725)) {
                  var and__3546__auto____5726 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5726)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____5726
                  }
                }else {
                  return and__3546__auto____5725
                }
              }else {
                return and__3546__auto____5724
              }
            }else {
              return and__3546__auto____5723
            }
          }else {
            return and__3546__auto____5722
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5727 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5727)) {
            var and__3546__auto____5728 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5728)) {
              var and__3546__auto____5729 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5729)) {
                var and__3546__auto____5730 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5730)) {
                  var and__3546__auto____5731 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5731)) {
                    var and__3546__auto____5732 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____5732)) {
                      var and__3546__auto____5733 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____5733)) {
                        var and__3546__auto____5734 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____5734)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____5734
                        }
                      }else {
                        return and__3546__auto____5733
                      }
                    }else {
                      return and__3546__auto____5732
                    }
                  }else {
                    return and__3546__auto____5731
                  }
                }else {
                  return and__3546__auto____5730
                }
              }else {
                return and__3546__auto____5729
              }
            }else {
              return and__3546__auto____5728
            }
          }else {
            return and__3546__auto____5727
          }
        }())
      };
      var ep3__4 = function() {
        var G__5747__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5735 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5735)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5690_SHARP_) {
                var and__3546__auto____5736 = p1.call(null, p1__5690_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5736)) {
                  var and__3546__auto____5737 = p2.call(null, p1__5690_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____5737)) {
                    return p3.call(null, p1__5690_SHARP_)
                  }else {
                    return and__3546__auto____5737
                  }
                }else {
                  return and__3546__auto____5736
                }
              }, args)
            }else {
              return and__3546__auto____5735
            }
          }())
        };
        var G__5747 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5747__delegate.call(this, x, y, z, args)
        };
        G__5747.cljs$lang$maxFixedArity = 3;
        G__5747.cljs$lang$applyTo = function(arglist__5748) {
          var x = cljs.core.first(arglist__5748);
          var y = cljs.core.first(cljs.core.next(arglist__5748));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5748)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5748)));
          return G__5747__delegate(x, y, z, args)
        };
        G__5747.cljs$lang$arity$variadic = G__5747__delegate;
        return G__5747
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__5749__delegate = function(p1, p2, p3, ps) {
      var ps__5738 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__5691_SHARP_) {
            return p1__5691_SHARP_.call(null, x)
          }, ps__5738)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__5692_SHARP_) {
            var and__3546__auto____5739 = p1__5692_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5739)) {
              return p1__5692_SHARP_.call(null, y)
            }else {
              return and__3546__auto____5739
            }
          }, ps__5738)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__5693_SHARP_) {
            var and__3546__auto____5740 = p1__5693_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5740)) {
              var and__3546__auto____5741 = p1__5693_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____5741)) {
                return p1__5693_SHARP_.call(null, z)
              }else {
                return and__3546__auto____5741
              }
            }else {
              return and__3546__auto____5740
            }
          }, ps__5738)
        };
        var epn__4 = function() {
          var G__5750__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____5742 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____5742)) {
                return cljs.core.every_QMARK_.call(null, function(p1__5694_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__5694_SHARP_, args)
                }, ps__5738)
              }else {
                return and__3546__auto____5742
              }
            }())
          };
          var G__5750 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5750__delegate.call(this, x, y, z, args)
          };
          G__5750.cljs$lang$maxFixedArity = 3;
          G__5750.cljs$lang$applyTo = function(arglist__5751) {
            var x = cljs.core.first(arglist__5751);
            var y = cljs.core.first(cljs.core.next(arglist__5751));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5751)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5751)));
            return G__5750__delegate(x, y, z, args)
          };
          G__5750.cljs$lang$arity$variadic = G__5750__delegate;
          return G__5750
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__5749 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5749__delegate.call(this, p1, p2, p3, ps)
    };
    G__5749.cljs$lang$maxFixedArity = 3;
    G__5749.cljs$lang$applyTo = function(arglist__5752) {
      var p1 = cljs.core.first(arglist__5752);
      var p2 = cljs.core.first(cljs.core.next(arglist__5752));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5752)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5752)));
      return G__5749__delegate(p1, p2, p3, ps)
    };
    G__5749.cljs$lang$arity$variadic = G__5749__delegate;
    return G__5749
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3548__auto____5754 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5754)) {
          return or__3548__auto____5754
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3548__auto____5755 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5755)) {
          return or__3548__auto____5755
        }else {
          var or__3548__auto____5756 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5756)) {
            return or__3548__auto____5756
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__5792__delegate = function(x, y, z, args) {
          var or__3548__auto____5757 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5757)) {
            return or__3548__auto____5757
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__5792 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5792__delegate.call(this, x, y, z, args)
        };
        G__5792.cljs$lang$maxFixedArity = 3;
        G__5792.cljs$lang$applyTo = function(arglist__5793) {
          var x = cljs.core.first(arglist__5793);
          var y = cljs.core.first(cljs.core.next(arglist__5793));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5793)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5793)));
          return G__5792__delegate(x, y, z, args)
        };
        G__5792.cljs$lang$arity$variadic = G__5792__delegate;
        return G__5792
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3548__auto____5758 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5758)) {
          return or__3548__auto____5758
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3548__auto____5759 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5759)) {
          return or__3548__auto____5759
        }else {
          var or__3548__auto____5760 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5760)) {
            return or__3548__auto____5760
          }else {
            var or__3548__auto____5761 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5761)) {
              return or__3548__auto____5761
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3548__auto____5762 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5762)) {
          return or__3548__auto____5762
        }else {
          var or__3548__auto____5763 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5763)) {
            return or__3548__auto____5763
          }else {
            var or__3548__auto____5764 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____5764)) {
              return or__3548__auto____5764
            }else {
              var or__3548__auto____5765 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____5765)) {
                return or__3548__auto____5765
              }else {
                var or__3548__auto____5766 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5766)) {
                  return or__3548__auto____5766
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__5794__delegate = function(x, y, z, args) {
          var or__3548__auto____5767 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5767)) {
            return or__3548__auto____5767
          }else {
            return cljs.core.some.call(null, function(p1__5699_SHARP_) {
              var or__3548__auto____5768 = p1.call(null, p1__5699_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5768)) {
                return or__3548__auto____5768
              }else {
                return p2.call(null, p1__5699_SHARP_)
              }
            }, args)
          }
        };
        var G__5794 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5794__delegate.call(this, x, y, z, args)
        };
        G__5794.cljs$lang$maxFixedArity = 3;
        G__5794.cljs$lang$applyTo = function(arglist__5795) {
          var x = cljs.core.first(arglist__5795);
          var y = cljs.core.first(cljs.core.next(arglist__5795));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5795)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5795)));
          return G__5794__delegate(x, y, z, args)
        };
        G__5794.cljs$lang$arity$variadic = G__5794__delegate;
        return G__5794
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3548__auto____5769 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5769)) {
          return or__3548__auto____5769
        }else {
          var or__3548__auto____5770 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5770)) {
            return or__3548__auto____5770
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3548__auto____5771 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5771)) {
          return or__3548__auto____5771
        }else {
          var or__3548__auto____5772 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5772)) {
            return or__3548__auto____5772
          }else {
            var or__3548__auto____5773 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5773)) {
              return or__3548__auto____5773
            }else {
              var or__3548__auto____5774 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5774)) {
                return or__3548__auto____5774
              }else {
                var or__3548__auto____5775 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5775)) {
                  return or__3548__auto____5775
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3548__auto____5776 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5776)) {
          return or__3548__auto____5776
        }else {
          var or__3548__auto____5777 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5777)) {
            return or__3548__auto____5777
          }else {
            var or__3548__auto____5778 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5778)) {
              return or__3548__auto____5778
            }else {
              var or__3548__auto____5779 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5779)) {
                return or__3548__auto____5779
              }else {
                var or__3548__auto____5780 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5780)) {
                  return or__3548__auto____5780
                }else {
                  var or__3548__auto____5781 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____5781)) {
                    return or__3548__auto____5781
                  }else {
                    var or__3548__auto____5782 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____5782)) {
                      return or__3548__auto____5782
                    }else {
                      var or__3548__auto____5783 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____5783)) {
                        return or__3548__auto____5783
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__5796__delegate = function(x, y, z, args) {
          var or__3548__auto____5784 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5784)) {
            return or__3548__auto____5784
          }else {
            return cljs.core.some.call(null, function(p1__5700_SHARP_) {
              var or__3548__auto____5785 = p1.call(null, p1__5700_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5785)) {
                return or__3548__auto____5785
              }else {
                var or__3548__auto____5786 = p2.call(null, p1__5700_SHARP_);
                if(cljs.core.truth_(or__3548__auto____5786)) {
                  return or__3548__auto____5786
                }else {
                  return p3.call(null, p1__5700_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__5796 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5796__delegate.call(this, x, y, z, args)
        };
        G__5796.cljs$lang$maxFixedArity = 3;
        G__5796.cljs$lang$applyTo = function(arglist__5797) {
          var x = cljs.core.first(arglist__5797);
          var y = cljs.core.first(cljs.core.next(arglist__5797));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5797)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5797)));
          return G__5796__delegate(x, y, z, args)
        };
        G__5796.cljs$lang$arity$variadic = G__5796__delegate;
        return G__5796
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__5798__delegate = function(p1, p2, p3, ps) {
      var ps__5787 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__5701_SHARP_) {
            return p1__5701_SHARP_.call(null, x)
          }, ps__5787)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__5702_SHARP_) {
            var or__3548__auto____5788 = p1__5702_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5788)) {
              return or__3548__auto____5788
            }else {
              return p1__5702_SHARP_.call(null, y)
            }
          }, ps__5787)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__5703_SHARP_) {
            var or__3548__auto____5789 = p1__5703_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5789)) {
              return or__3548__auto____5789
            }else {
              var or__3548__auto____5790 = p1__5703_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5790)) {
                return or__3548__auto____5790
              }else {
                return p1__5703_SHARP_.call(null, z)
              }
            }
          }, ps__5787)
        };
        var spn__4 = function() {
          var G__5799__delegate = function(x, y, z, args) {
            var or__3548__auto____5791 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____5791)) {
              return or__3548__auto____5791
            }else {
              return cljs.core.some.call(null, function(p1__5704_SHARP_) {
                return cljs.core.some.call(null, p1__5704_SHARP_, args)
              }, ps__5787)
            }
          };
          var G__5799 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5799__delegate.call(this, x, y, z, args)
          };
          G__5799.cljs$lang$maxFixedArity = 3;
          G__5799.cljs$lang$applyTo = function(arglist__5800) {
            var x = cljs.core.first(arglist__5800);
            var y = cljs.core.first(cljs.core.next(arglist__5800));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5800)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5800)));
            return G__5799__delegate(x, y, z, args)
          };
          G__5799.cljs$lang$arity$variadic = G__5799__delegate;
          return G__5799
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__5798 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5798__delegate.call(this, p1, p2, p3, ps)
    };
    G__5798.cljs$lang$maxFixedArity = 3;
    G__5798.cljs$lang$applyTo = function(arglist__5801) {
      var p1 = cljs.core.first(arglist__5801);
      var p2 = cljs.core.first(cljs.core.next(arglist__5801));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5801)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5801)));
      return G__5798__delegate(p1, p2, p3, ps)
    };
    G__5798.cljs$lang$arity$variadic = G__5798__delegate;
    return G__5798
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5802 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5802)) {
        var s__5803 = temp__3698__auto____5802;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__5803)), map.call(null, f, cljs.core.rest.call(null, s__5803)))
      }else {
        return null
      }
    })
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5804 = cljs.core.seq.call(null, c1);
      var s2__5805 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5806 = s1__5804;
        if(cljs.core.truth_(and__3546__auto____5806)) {
          return s2__5805
        }else {
          return and__3546__auto____5806
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5804), cljs.core.first.call(null, s2__5805)), map.call(null, f, cljs.core.rest.call(null, s1__5804), cljs.core.rest.call(null, s2__5805)))
      }else {
        return null
      }
    })
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5807 = cljs.core.seq.call(null, c1);
      var s2__5808 = cljs.core.seq.call(null, c2);
      var s3__5809 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5810 = s1__5807;
        if(cljs.core.truth_(and__3546__auto____5810)) {
          var and__3546__auto____5811 = s2__5808;
          if(cljs.core.truth_(and__3546__auto____5811)) {
            return s3__5809
          }else {
            return and__3546__auto____5811
          }
        }else {
          return and__3546__auto____5810
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5807), cljs.core.first.call(null, s2__5808), cljs.core.first.call(null, s3__5809)), map.call(null, f, cljs.core.rest.call(null, s1__5807), cljs.core.rest.call(null, s2__5808), cljs.core.rest.call(null, s3__5809)))
      }else {
        return null
      }
    })
  };
  var map__5 = function() {
    var G__5814__delegate = function(f, c1, c2, c3, colls) {
      var step__5813 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__5812 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5812)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__5812), step.call(null, map.call(null, cljs.core.rest, ss__5812)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__5753_SHARP_) {
        return cljs.core.apply.call(null, f, p1__5753_SHARP_)
      }, step__5813.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__5814 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5814__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5814.cljs$lang$maxFixedArity = 4;
    G__5814.cljs$lang$applyTo = function(arglist__5815) {
      var f = cljs.core.first(arglist__5815);
      var c1 = cljs.core.first(cljs.core.next(arglist__5815));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5815)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5815))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5815))));
      return G__5814__delegate(f, c1, c2, c3, colls)
    };
    G__5814.cljs$lang$arity$variadic = G__5814__delegate;
    return G__5814
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3698__auto____5816 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5816)) {
        var s__5817 = temp__3698__auto____5816;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5817), take.call(null, n - 1, cljs.core.rest.call(null, s__5817)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__5820 = function(n, coll) {
    while(true) {
      var s__5818 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5819 = n > 0;
        if(and__3546__auto____5819) {
          return s__5818
        }else {
          return and__3546__auto____5819
        }
      }())) {
        var G__5821 = n - 1;
        var G__5822 = cljs.core.rest.call(null, s__5818);
        n = G__5821;
        coll = G__5822;
        continue
      }else {
        return s__5818
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5820.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__5823 = cljs.core.seq.call(null, coll);
  var lead__5824 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__5824)) {
      var G__5825 = cljs.core.next.call(null, s__5823);
      var G__5826 = cljs.core.next.call(null, lead__5824);
      s__5823 = G__5825;
      lead__5824 = G__5826;
      continue
    }else {
      return s__5823
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__5829 = function(pred, coll) {
    while(true) {
      var s__5827 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5828 = s__5827;
        if(cljs.core.truth_(and__3546__auto____5828)) {
          return pred.call(null, cljs.core.first.call(null, s__5827))
        }else {
          return and__3546__auto____5828
        }
      }())) {
        var G__5830 = pred;
        var G__5831 = cljs.core.rest.call(null, s__5827);
        pred = G__5830;
        coll = G__5831;
        continue
      }else {
        return s__5827
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5829.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5832 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5832)) {
      var s__5833 = temp__3698__auto____5832;
      return cljs.core.concat.call(null, s__5833, cycle.call(null, s__5833))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5834 = cljs.core.seq.call(null, c1);
      var s2__5835 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5836 = s1__5834;
        if(cljs.core.truth_(and__3546__auto____5836)) {
          return s2__5835
        }else {
          return and__3546__auto____5836
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__5834), cljs.core.cons.call(null, cljs.core.first.call(null, s2__5835), interleave.call(null, cljs.core.rest.call(null, s1__5834), cljs.core.rest.call(null, s2__5835))))
      }else {
        return null
      }
    })
  };
  var interleave__3 = function() {
    var G__5838__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__5837 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5837)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__5837), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__5837)))
        }else {
          return null
        }
      })
    };
    var G__5838 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5838__delegate.call(this, c1, c2, colls)
    };
    G__5838.cljs$lang$maxFixedArity = 2;
    G__5838.cljs$lang$applyTo = function(arglist__5839) {
      var c1 = cljs.core.first(arglist__5839);
      var c2 = cljs.core.first(cljs.core.next(arglist__5839));
      var colls = cljs.core.rest(cljs.core.next(arglist__5839));
      return G__5838__delegate(c1, c2, colls)
    };
    G__5838.cljs$lang$arity$variadic = G__5838__delegate;
    return G__5838
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__5842 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____5840 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____5840)) {
        var coll__5841 = temp__3695__auto____5840;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__5841), cat.call(null, cljs.core.rest.call(null, coll__5841), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__5842.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__5843__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__5843 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5843__delegate.call(this, f, coll, colls)
    };
    G__5843.cljs$lang$maxFixedArity = 2;
    G__5843.cljs$lang$applyTo = function(arglist__5844) {
      var f = cljs.core.first(arglist__5844);
      var coll = cljs.core.first(cljs.core.next(arglist__5844));
      var colls = cljs.core.rest(cljs.core.next(arglist__5844));
      return G__5843__delegate(f, coll, colls)
    };
    G__5843.cljs$lang$arity$variadic = G__5843__delegate;
    return G__5843
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5845 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5845)) {
      var s__5846 = temp__3698__auto____5845;
      var f__5847 = cljs.core.first.call(null, s__5846);
      var r__5848 = cljs.core.rest.call(null, s__5846);
      if(cljs.core.truth_(pred.call(null, f__5847))) {
        return cljs.core.cons.call(null, f__5847, filter.call(null, pred, r__5848))
      }else {
        return filter.call(null, pred, r__5848)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__5850 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__5850.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__5849_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__5849_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__5851__5852 = to;
    if(G__5851__5852 != null) {
      if(function() {
        var or__3548__auto____5853 = G__5851__5852.cljs$lang$protocol_mask$partition0$ & 2147483648;
        if(or__3548__auto____5853) {
          return or__3548__auto____5853
        }else {
          return G__5851__5852.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__5851__5852.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5851__5852)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5851__5852)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__5854__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__5854 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5854__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5854.cljs$lang$maxFixedArity = 4;
    G__5854.cljs$lang$applyTo = function(arglist__5855) {
      var f = cljs.core.first(arglist__5855);
      var c1 = cljs.core.first(cljs.core.next(arglist__5855));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5855)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5855))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5855))));
      return G__5854__delegate(f, c1, c2, c3, colls)
    };
    G__5854.cljs$lang$arity$variadic = G__5854__delegate;
    return G__5854
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5856 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5856)) {
        var s__5857 = temp__3698__auto____5856;
        var p__5858 = cljs.core.take.call(null, n, s__5857);
        if(n === cljs.core.count.call(null, p__5858)) {
          return cljs.core.cons.call(null, p__5858, partition.call(null, n, step, cljs.core.drop.call(null, step, s__5857)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5859 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5859)) {
        var s__5860 = temp__3698__auto____5859;
        var p__5861 = cljs.core.take.call(null, n, s__5860);
        if(n === cljs.core.count.call(null, p__5861)) {
          return cljs.core.cons.call(null, p__5861, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__5860)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__5861, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__5862 = cljs.core.lookup_sentinel;
    var m__5863 = m;
    var ks__5864 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__5864)) {
        var m__5865 = cljs.core.get.call(null, m__5863, cljs.core.first.call(null, ks__5864), sentinel__5862);
        if(sentinel__5862 === m__5865) {
          return not_found
        }else {
          var G__5866 = sentinel__5862;
          var G__5867 = m__5865;
          var G__5868 = cljs.core.next.call(null, ks__5864);
          sentinel__5862 = G__5866;
          m__5863 = G__5867;
          ks__5864 = G__5868;
          continue
        }
      }else {
        return m__5863
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__5869, v) {
  var vec__5870__5871 = p__5869;
  var k__5872 = cljs.core.nth.call(null, vec__5870__5871, 0, null);
  var ks__5873 = cljs.core.nthnext.call(null, vec__5870__5871, 1);
  if(cljs.core.truth_(ks__5873)) {
    return cljs.core.assoc.call(null, m, k__5872, assoc_in.call(null, cljs.core.get.call(null, m, k__5872), ks__5873, v))
  }else {
    return cljs.core.assoc.call(null, m, k__5872, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__5874, f, args) {
    var vec__5875__5876 = p__5874;
    var k__5877 = cljs.core.nth.call(null, vec__5875__5876, 0, null);
    var ks__5878 = cljs.core.nthnext.call(null, vec__5875__5876, 1);
    if(cljs.core.truth_(ks__5878)) {
      return cljs.core.assoc.call(null, m, k__5877, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__5877), ks__5878, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__5877, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__5877), args))
    }
  };
  var update_in = function(m, p__5874, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__5874, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__5879) {
    var m = cljs.core.first(arglist__5879);
    var p__5874 = cljs.core.first(cljs.core.next(arglist__5879));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5879)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5879)));
    return update_in__delegate(m, p__5874, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5884 = this;
  var h__364__auto____5885 = this__5884.__hash;
  if(h__364__auto____5885 != null) {
    return h__364__auto____5885
  }else {
    var h__364__auto____5886 = cljs.core.hash_coll.call(null, coll);
    this__5884.__hash = h__364__auto____5886;
    return h__364__auto____5886
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5887 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5888 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5889 = this;
  var new_array__5890 = cljs.core.aclone.call(null, this__5889.array);
  new_array__5890[k] = v;
  return new cljs.core.Vector(this__5889.meta, new_array__5890, null)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__5919 = null;
  var G__5919__2 = function(tsym5882, k) {
    var this__5891 = this;
    var tsym5882__5892 = this;
    var coll__5893 = tsym5882__5892;
    return cljs.core._lookup.call(null, coll__5893, k)
  };
  var G__5919__3 = function(tsym5883, k, not_found) {
    var this__5894 = this;
    var tsym5883__5895 = this;
    var coll__5896 = tsym5883__5895;
    return cljs.core._lookup.call(null, coll__5896, k, not_found)
  };
  G__5919 = function(tsym5883, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5919__2.call(this, tsym5883, k);
      case 3:
        return G__5919__3.call(this, tsym5883, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5919
}();
cljs.core.Vector.prototype.apply = function(tsym5880, args5881) {
  return tsym5880.call.apply(tsym5880, [tsym5880].concat(cljs.core.aclone.call(null, args5881)))
};
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5897 = this;
  var new_array__5898 = cljs.core.aclone.call(null, this__5897.array);
  new_array__5898.push(o);
  return new cljs.core.Vector(this__5897.meta, new_array__5898, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__5899 = this;
  var this$__5900 = this;
  return cljs.core.pr_str.call(null, this$__5900)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5901 = this;
  return cljs.core.ci_reduce.call(null, this__5901.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5902 = this;
  return cljs.core.ci_reduce.call(null, this__5902.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5903 = this;
  if(this__5903.array.length > 0) {
    var vector_seq__5904 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__5903.array.length) {
          return cljs.core.cons.call(null, this__5903.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__5904.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5905 = this;
  return this__5905.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5906 = this;
  var count__5907 = this__5906.array.length;
  if(count__5907 > 0) {
    return this__5906.array[count__5907 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5908 = this;
  if(this__5908.array.length > 0) {
    var new_array__5909 = cljs.core.aclone.call(null, this__5908.array);
    new_array__5909.pop();
    return new cljs.core.Vector(this__5908.meta, new_array__5909, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5910 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5911 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5912 = this;
  return new cljs.core.Vector(meta, this__5912.array, this__5912.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5913 = this;
  return this__5913.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5915 = this;
  if(function() {
    var and__3546__auto____5916 = 0 <= n;
    if(and__3546__auto____5916) {
      return n < this__5915.array.length
    }else {
      return and__3546__auto____5916
    }
  }()) {
    return this__5915.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5917 = this;
  if(function() {
    var and__3546__auto____5918 = 0 <= n;
    if(and__3546__auto____5918) {
      return n < this__5917.array.length
    }else {
      return and__3546__auto____5918
    }
  }()) {
    return this__5917.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5914 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5914.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__455__auto__) {
  return cljs.core.list.call(null, "cljs.core.VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__5920 = pv.cnt;
  if(cnt__5920 < 32) {
    return 0
  }else {
    return cnt__5920 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__5921 = level;
  var ret__5922 = node;
  while(true) {
    if(ll__5921 === 0) {
      return ret__5922
    }else {
      var embed__5923 = ret__5922;
      var r__5924 = cljs.core.pv_fresh_node.call(null, edit);
      var ___5925 = cljs.core.pv_aset.call(null, r__5924, 0, embed__5923);
      var G__5926 = ll__5921 - 5;
      var G__5927 = r__5924;
      ll__5921 = G__5926;
      ret__5922 = G__5927;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__5928 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__5929 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__5928, subidx__5929, tailnode);
    return ret__5928
  }else {
    var temp__3695__auto____5930 = cljs.core.pv_aget.call(null, parent, subidx__5929);
    if(cljs.core.truth_(temp__3695__auto____5930)) {
      var child__5931 = temp__3695__auto____5930;
      var node_to_insert__5932 = push_tail.call(null, pv, level - 5, child__5931, tailnode);
      cljs.core.pv_aset.call(null, ret__5928, subidx__5929, node_to_insert__5932);
      return ret__5928
    }else {
      var node_to_insert__5933 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__5928, subidx__5929, node_to_insert__5933);
      return ret__5928
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3546__auto____5934 = 0 <= i;
    if(and__3546__auto____5934) {
      return i < pv.cnt
    }else {
      return and__3546__auto____5934
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__5935 = pv.root;
      var level__5936 = pv.shift;
      while(true) {
        if(level__5936 > 0) {
          var G__5937 = cljs.core.pv_aget.call(null, node__5935, i >>> level__5936 & 31);
          var G__5938 = level__5936 - 5;
          node__5935 = G__5937;
          level__5936 = G__5938;
          continue
        }else {
          return node__5935.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__5939 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__5939, i & 31, val);
    return ret__5939
  }else {
    var subidx__5940 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__5939, subidx__5940, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5940), i, val));
    return ret__5939
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__5941 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5942 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5941));
    if(function() {
      var and__3546__auto____5943 = new_child__5942 == null;
      if(and__3546__auto____5943) {
        return subidx__5941 === 0
      }else {
        return and__3546__auto____5943
      }
    }()) {
      return null
    }else {
      var ret__5944 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__5944, subidx__5941, new_child__5942);
      return ret__5944
    }
  }else {
    if(subidx__5941 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__5945 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__5945, subidx__5941, null);
        return ret__5945
      }else {
        return null
      }
    }
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.vector_seq = function vector_seq(v, offset) {
  var c__5946 = cljs.core._count.call(null, v);
  if(c__5946 > 0) {
    if(void 0 === cljs.core.t5947) {
      cljs.core.t5947 = function(c, offset, v, vector_seq, __meta__389__auto__) {
        this.c = c;
        this.offset = offset;
        this.v = v;
        this.vector_seq = vector_seq;
        this.__meta__389__auto__ = __meta__389__auto__;
        this.cljs$lang$protocol_mask$partition1$ = 0;
        this.cljs$lang$protocol_mask$partition0$ = 282263648
      };
      cljs.core.t5947.cljs$lang$type = true;
      cljs.core.t5947.cljs$lang$ctorPrSeq = function(this__454__auto__) {
        return cljs.core.list.call(null, "cljs.core.t5947")
      };
      cljs.core.t5947.prototype.cljs$core$ISeqable$ = true;
      cljs.core.t5947.prototype.cljs$core$ISeqable$_seq$arity$1 = function(vseq) {
        var this__5948 = this;
        return vseq
      };
      cljs.core.t5947.prototype.cljs$core$ISeq$ = true;
      cljs.core.t5947.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
        var this__5949 = this;
        return cljs.core._nth.call(null, this__5949.v, this__5949.offset)
      };
      cljs.core.t5947.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
        var this__5950 = this;
        var offset__5951 = this__5950.offset + 1;
        if(offset__5951 < this__5950.c) {
          return this__5950.vector_seq.call(null, this__5950.v, offset__5951)
        }else {
          return cljs.core.List.EMPTY
        }
      };
      cljs.core.t5947.prototype.cljs$core$ASeq$ = true;
      cljs.core.t5947.prototype.cljs$core$IEquiv$ = true;
      cljs.core.t5947.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(vseq, other) {
        var this__5952 = this;
        return cljs.core.equiv_sequential.call(null, vseq, other)
      };
      cljs.core.t5947.prototype.cljs$core$ISequential$ = true;
      cljs.core.t5947.prototype.cljs$core$IPrintable$ = true;
      cljs.core.t5947.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(vseq, opts) {
        var this__5953 = this;
        return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, vseq)
      };
      cljs.core.t5947.prototype.cljs$core$IMeta$ = true;
      cljs.core.t5947.prototype.cljs$core$IMeta$_meta$arity$1 = function(___390__auto__) {
        var this__5954 = this;
        return this__5954.__meta__389__auto__
      };
      cljs.core.t5947.prototype.cljs$core$IWithMeta$ = true;
      cljs.core.t5947.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(___390__auto__, __meta__389__auto__) {
        var this__5955 = this;
        return new cljs.core.t5947(this__5955.c, this__5955.offset, this__5955.v, this__5955.vector_seq, __meta__389__auto__)
      };
      cljs.core.t5947
    }else {
    }
    return new cljs.core.t5947(c__5946, offset, v, vector_seq, null)
  }else {
    return null
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2164209055
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5960 = this;
  return new cljs.core.TransientVector(this__5960.cnt, this__5960.shift, cljs.core.tv_editable_root.call(null, this__5960.root), cljs.core.tv_editable_tail.call(null, this__5960.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5961 = this;
  var h__364__auto____5962 = this__5961.__hash;
  if(h__364__auto____5962 != null) {
    return h__364__auto____5962
  }else {
    var h__364__auto____5963 = cljs.core.hash_coll.call(null, coll);
    this__5961.__hash = h__364__auto____5963;
    return h__364__auto____5963
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5964 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5965 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5966 = this;
  if(function() {
    var and__3546__auto____5967 = 0 <= k;
    if(and__3546__auto____5967) {
      return k < this__5966.cnt
    }else {
      return and__3546__auto____5967
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__5968 = cljs.core.aclone.call(null, this__5966.tail);
      new_tail__5968[k & 31] = v;
      return new cljs.core.PersistentVector(this__5966.meta, this__5966.cnt, this__5966.shift, this__5966.root, new_tail__5968, null)
    }else {
      return new cljs.core.PersistentVector(this__5966.meta, this__5966.cnt, this__5966.shift, cljs.core.do_assoc.call(null, coll, this__5966.shift, this__5966.root, k, v), this__5966.tail, null)
    }
  }else {
    if(k === this__5966.cnt) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__5966.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__6013 = null;
  var G__6013__2 = function(tsym5958, k) {
    var this__5969 = this;
    var tsym5958__5970 = this;
    var coll__5971 = tsym5958__5970;
    return cljs.core._lookup.call(null, coll__5971, k)
  };
  var G__6013__3 = function(tsym5959, k, not_found) {
    var this__5972 = this;
    var tsym5959__5973 = this;
    var coll__5974 = tsym5959__5973;
    return cljs.core._lookup.call(null, coll__5974, k, not_found)
  };
  G__6013 = function(tsym5959, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6013__2.call(this, tsym5959, k);
      case 3:
        return G__6013__3.call(this, tsym5959, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6013
}();
cljs.core.PersistentVector.prototype.apply = function(tsym5956, args5957) {
  return tsym5956.call.apply(tsym5956, [tsym5956].concat(cljs.core.aclone.call(null, args5957)))
};
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__5975 = this;
  var step_init__5976 = [0, init];
  var i__5977 = 0;
  while(true) {
    if(i__5977 < this__5975.cnt) {
      var arr__5978 = cljs.core.array_for.call(null, v, i__5977);
      var len__5979 = arr__5978.length;
      var init__5983 = function() {
        var j__5980 = 0;
        var init__5981 = step_init__5976[1];
        while(true) {
          if(j__5980 < len__5979) {
            var init__5982 = f.call(null, init__5981, j__5980 + i__5977, arr__5978[j__5980]);
            if(cljs.core.reduced_QMARK_.call(null, init__5982)) {
              return init__5982
            }else {
              var G__6014 = j__5980 + 1;
              var G__6015 = init__5982;
              j__5980 = G__6014;
              init__5981 = G__6015;
              continue
            }
          }else {
            step_init__5976[0] = len__5979;
            step_init__5976[1] = init__5981;
            return init__5981
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5983)) {
        return cljs.core.deref.call(null, init__5983)
      }else {
        var G__6016 = i__5977 + step_init__5976[0];
        i__5977 = G__6016;
        continue
      }
    }else {
      return step_init__5976[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5984 = this;
  if(this__5984.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__5985 = cljs.core.aclone.call(null, this__5984.tail);
    new_tail__5985.push(o);
    return new cljs.core.PersistentVector(this__5984.meta, this__5984.cnt + 1, this__5984.shift, this__5984.root, new_tail__5985, null)
  }else {
    var root_overflow_QMARK___5986 = this__5984.cnt >>> 5 > 1 << this__5984.shift;
    var new_shift__5987 = root_overflow_QMARK___5986 ? this__5984.shift + 5 : this__5984.shift;
    var new_root__5989 = root_overflow_QMARK___5986 ? function() {
      var n_r__5988 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__5988, 0, this__5984.root);
      cljs.core.pv_aset.call(null, n_r__5988, 1, cljs.core.new_path.call(null, null, this__5984.shift, new cljs.core.VectorNode(null, this__5984.tail)));
      return n_r__5988
    }() : cljs.core.push_tail.call(null, coll, this__5984.shift, this__5984.root, new cljs.core.VectorNode(null, this__5984.tail));
    return new cljs.core.PersistentVector(this__5984.meta, this__5984.cnt + 1, new_shift__5987, new_root__5989, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__5990 = this;
  return cljs.core._nth.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__5991 = this;
  return cljs.core._nth.call(null, coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__5992 = this;
  var this$__5993 = this;
  return cljs.core.pr_str.call(null, this$__5993)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5994 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5995 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5996 = this;
  return cljs.core.vector_seq.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5997 = this;
  return this__5997.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5998 = this;
  if(this__5998.cnt > 0) {
    return cljs.core._nth.call(null, coll, this__5998.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5999 = this;
  if(this__5999.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__5999.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5999.meta)
    }else {
      if(1 < this__5999.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__5999.meta, this__5999.cnt - 1, this__5999.shift, this__5999.root, this__5999.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__6000 = cljs.core.array_for.call(null, coll, this__5999.cnt - 2);
          var nr__6001 = cljs.core.pop_tail.call(null, coll, this__5999.shift, this__5999.root);
          var new_root__6002 = nr__6001 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__6001;
          var cnt_1__6003 = this__5999.cnt - 1;
          if(function() {
            var and__3546__auto____6004 = 5 < this__5999.shift;
            if(and__3546__auto____6004) {
              return cljs.core.pv_aget.call(null, new_root__6002, 1) == null
            }else {
              return and__3546__auto____6004
            }
          }()) {
            return new cljs.core.PersistentVector(this__5999.meta, cnt_1__6003, this__5999.shift - 5, cljs.core.pv_aget.call(null, new_root__6002, 0), new_tail__6000, null)
          }else {
            return new cljs.core.PersistentVector(this__5999.meta, cnt_1__6003, this__5999.shift, new_root__6002, new_tail__6000, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__6006 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6007 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6008 = this;
  return new cljs.core.PersistentVector(meta, this__6008.cnt, this__6008.shift, this__6008.root, this__6008.tail, this__6008.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6009 = this;
  return this__6009.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6010 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6011 = this;
  if(function() {
    var and__3546__auto____6012 = 0 <= n;
    if(and__3546__auto____6012) {
      return n < this__6011.cnt
    }else {
      return and__3546__auto____6012
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6005 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__6005.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs) {
  var xs__6017 = cljs.core.seq.call(null, xs);
  var out__6018 = cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);
  while(true) {
    if(cljs.core.truth_(xs__6017)) {
      var G__6019 = cljs.core.next.call(null, xs__6017);
      var G__6020 = cljs.core.conj_BANG_.call(null, out__6018, cljs.core.first.call(null, xs__6017));
      xs__6017 = G__6019;
      out__6018 = G__6020;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6018)
    }
    break
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__6021) {
    var args = cljs.core.seq(arglist__6021);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6026 = this;
  var h__364__auto____6027 = this__6026.__hash;
  if(h__364__auto____6027 != null) {
    return h__364__auto____6027
  }else {
    var h__364__auto____6028 = cljs.core.hash_coll.call(null, coll);
    this__6026.__hash = h__364__auto____6028;
    return h__364__auto____6028
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6029 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6030 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__6031 = this;
  var v_pos__6032 = this__6031.start + key;
  return new cljs.core.Subvec(this__6031.meta, cljs.core._assoc.call(null, this__6031.v, v_pos__6032, val), this__6031.start, this__6031.end > v_pos__6032 + 1 ? this__6031.end : v_pos__6032 + 1, null)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__6056 = null;
  var G__6056__2 = function(tsym6024, k) {
    var this__6033 = this;
    var tsym6024__6034 = this;
    var coll__6035 = tsym6024__6034;
    return cljs.core._lookup.call(null, coll__6035, k)
  };
  var G__6056__3 = function(tsym6025, k, not_found) {
    var this__6036 = this;
    var tsym6025__6037 = this;
    var coll__6038 = tsym6025__6037;
    return cljs.core._lookup.call(null, coll__6038, k, not_found)
  };
  G__6056 = function(tsym6025, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6056__2.call(this, tsym6025, k);
      case 3:
        return G__6056__3.call(this, tsym6025, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6056
}();
cljs.core.Subvec.prototype.apply = function(tsym6022, args6023) {
  return tsym6022.call.apply(tsym6022, [tsym6022].concat(cljs.core.aclone.call(null, args6023)))
};
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6039 = this;
  return new cljs.core.Subvec(this__6039.meta, cljs.core._assoc_n.call(null, this__6039.v, this__6039.end, o), this__6039.start, this__6039.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__6040 = this;
  var this$__6041 = this;
  return cljs.core.pr_str.call(null, this$__6041)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__6042 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__6043 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6044 = this;
  var subvec_seq__6045 = function subvec_seq(i) {
    if(i === this__6044.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__6044.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__6045.call(null, this__6044.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6046 = this;
  return this__6046.end - this__6046.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6047 = this;
  return cljs.core._nth.call(null, this__6047.v, this__6047.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6048 = this;
  if(this__6048.start === this__6048.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__6048.meta, this__6048.v, this__6048.start, this__6048.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__6049 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6050 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6051 = this;
  return new cljs.core.Subvec(meta, this__6051.v, this__6051.start, this__6051.end, this__6051.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6052 = this;
  return this__6052.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6054 = this;
  return cljs.core._nth.call(null, this__6054.v, this__6054.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6055 = this;
  return cljs.core._nth.call(null, this__6055.v, this__6055.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6053 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__6053.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone.call(null, node.arr))
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__6057 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__6057, 0, tl.length);
  return ret__6057
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__6058 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__6059 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__6058, subidx__6059, level === 5 ? tail_node : function() {
    var child__6060 = cljs.core.pv_aget.call(null, ret__6058, subidx__6059);
    if(child__6060 != null) {
      return tv_push_tail.call(null, tv, level - 5, child__6060, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__6058
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__6061 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__6062 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__6063 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__6061, subidx__6062));
    if(function() {
      var and__3546__auto____6064 = new_child__6063 == null;
      if(and__3546__auto____6064) {
        return subidx__6062 === 0
      }else {
        return and__3546__auto____6064
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__6061, subidx__6062, new_child__6063);
      return node__6061
    }
  }else {
    if(subidx__6062 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__6061, subidx__6062, null);
        return node__6061
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3546__auto____6065 = 0 <= i;
    if(and__3546__auto____6065) {
      return i < tv.cnt
    }else {
      return and__3546__auto____6065
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__6066 = tv.root;
      var node__6067 = root__6066;
      var level__6068 = tv.shift;
      while(true) {
        if(level__6068 > 0) {
          var G__6069 = cljs.core.tv_ensure_editable.call(null, root__6066.edit, cljs.core.pv_aget.call(null, node__6067, i >>> level__6068 & 31));
          var G__6070 = level__6068 - 5;
          node__6067 = G__6069;
          level__6068 = G__6070;
          continue
        }else {
          return node__6067.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 147;
  this.cljs$lang$protocol_mask$partition1$ = 11
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientVector")
};
cljs.core.TransientVector.prototype.cljs$core$IFn$ = true;
cljs.core.TransientVector.prototype.call = function() {
  var G__6108 = null;
  var G__6108__2 = function(tsym6073, k) {
    var this__6075 = this;
    var tsym6073__6076 = this;
    var coll__6077 = tsym6073__6076;
    return cljs.core._lookup.call(null, coll__6077, k)
  };
  var G__6108__3 = function(tsym6074, k, not_found) {
    var this__6078 = this;
    var tsym6074__6079 = this;
    var coll__6080 = tsym6074__6079;
    return cljs.core._lookup.call(null, coll__6080, k, not_found)
  };
  G__6108 = function(tsym6074, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6108__2.call(this, tsym6074, k);
      case 3:
        return G__6108__3.call(this, tsym6074, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6108
}();
cljs.core.TransientVector.prototype.apply = function(tsym6071, args6072) {
  return tsym6071.call.apply(tsym6071, [tsym6071].concat(cljs.core.aclone.call(null, args6072)))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6081 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6082 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6083 = this;
  if(cljs.core.truth_(this__6083.root.edit)) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6084 = this;
  if(function() {
    var and__3546__auto____6085 = 0 <= n;
    if(and__3546__auto____6085) {
      return n < this__6084.cnt
    }else {
      return and__3546__auto____6085
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6086 = this;
  if(cljs.core.truth_(this__6086.root.edit)) {
    return this__6086.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__6087 = this;
  if(cljs.core.truth_(this__6087.root.edit)) {
    if(function() {
      var and__3546__auto____6088 = 0 <= n;
      if(and__3546__auto____6088) {
        return n < this__6087.cnt
      }else {
        return and__3546__auto____6088
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__6087.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__6091 = function go(level, node) {
          var node__6089 = cljs.core.tv_ensure_editable.call(null, this__6087.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__6089, n & 31, val);
            return node__6089
          }else {
            var subidx__6090 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__6089, subidx__6090, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__6089, subidx__6090)));
            return node__6089
          }
        }.call(null, this__6087.shift, this__6087.root);
        this__6087.root = new_root__6091;
        return tcoll
      }
    }else {
      if(n === this__6087.cnt) {
        return cljs.core._conj_BANG_.call(null, tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__6087.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__6092 = this;
  if(cljs.core.truth_(this__6092.root.edit)) {
    if(this__6092.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__6092.cnt) {
        this__6092.cnt = 0;
        return tcoll
      }else {
        if((this__6092.cnt - 1 & 31) > 0) {
          this__6092.cnt = this__6092.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__6093 = cljs.core.editable_array_for.call(null, tcoll, this__6092.cnt - 2);
            var new_root__6095 = function() {
              var nr__6094 = cljs.core.tv_pop_tail.call(null, tcoll, this__6092.shift, this__6092.root);
              if(nr__6094 != null) {
                return nr__6094
              }else {
                return new cljs.core.VectorNode(this__6092.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3546__auto____6096 = 5 < this__6092.shift;
              if(and__3546__auto____6096) {
                return cljs.core.pv_aget.call(null, new_root__6095, 1) == null
              }else {
                return and__3546__auto____6096
              }
            }()) {
              var new_root__6097 = cljs.core.tv_ensure_editable.call(null, this__6092.root.edit, cljs.core.pv_aget.call(null, new_root__6095, 0));
              this__6092.root = new_root__6097;
              this__6092.shift = this__6092.shift - 5;
              this__6092.cnt = this__6092.cnt - 1;
              this__6092.tail = new_tail__6093;
              return tcoll
            }else {
              this__6092.root = new_root__6095;
              this__6092.cnt = this__6092.cnt - 1;
              this__6092.tail = new_tail__6093;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6098 = this;
  return cljs.core._assoc_n_BANG_.call(null, tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6099 = this;
  if(cljs.core.truth_(this__6099.root.edit)) {
    if(this__6099.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__6099.tail[this__6099.cnt & 31] = o;
      this__6099.cnt = this__6099.cnt + 1;
      return tcoll
    }else {
      var tail_node__6100 = new cljs.core.VectorNode(this__6099.root.edit, this__6099.tail);
      var new_tail__6101 = cljs.core.make_array.call(null, 32);
      new_tail__6101[0] = o;
      this__6099.tail = new_tail__6101;
      if(this__6099.cnt >>> 5 > 1 << this__6099.shift) {
        var new_root_array__6102 = cljs.core.make_array.call(null, 32);
        var new_shift__6103 = this__6099.shift + 5;
        new_root_array__6102[0] = this__6099.root;
        new_root_array__6102[1] = cljs.core.new_path.call(null, this__6099.root.edit, this__6099.shift, tail_node__6100);
        this__6099.root = new cljs.core.VectorNode(this__6099.root.edit, new_root_array__6102);
        this__6099.shift = new_shift__6103;
        this__6099.cnt = this__6099.cnt + 1;
        return tcoll
      }else {
        var new_root__6104 = cljs.core.tv_push_tail.call(null, tcoll, this__6099.shift, this__6099.root, tail_node__6100);
        this__6099.root = new_root__6104;
        this__6099.cnt = this__6099.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6105 = this;
  if(cljs.core.truth_(this__6105.root.edit)) {
    this__6105.root.edit = null;
    var len__6106 = this__6105.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__6107 = cljs.core.make_array.call(null, len__6106);
    cljs.core.array_copy.call(null, this__6105.tail, 0, trimmed_tail__6107, 0, len__6106);
    return new cljs.core.PersistentVector(null, this__6105.cnt, this__6105.shift, this__6105.root, trimmed_tail__6107, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6109 = this;
  var h__364__auto____6110 = this__6109.__hash;
  if(h__364__auto____6110 != null) {
    return h__364__auto____6110
  }else {
    var h__364__auto____6111 = cljs.core.hash_coll.call(null, coll);
    this__6109.__hash = h__364__auto____6111;
    return h__364__auto____6111
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6112 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__6113 = this;
  var this$__6114 = this;
  return cljs.core.pr_str.call(null, this$__6114)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6115 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6116 = this;
  return cljs.core._first.call(null, this__6116.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6117 = this;
  var temp__3695__auto____6118 = cljs.core.next.call(null, this__6117.front);
  if(cljs.core.truth_(temp__3695__auto____6118)) {
    var f1__6119 = temp__3695__auto____6118;
    return new cljs.core.PersistentQueueSeq(this__6117.meta, f1__6119, this__6117.rear, null)
  }else {
    if(this__6117.rear == null) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__6117.meta, this__6117.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6120 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6121 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__6121.front, this__6121.rear, this__6121.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6122 = this;
  return this__6122.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6123 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6123.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15929422
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6124 = this;
  var h__364__auto____6125 = this__6124.__hash;
  if(h__364__auto____6125 != null) {
    return h__364__auto____6125
  }else {
    var h__364__auto____6126 = cljs.core.hash_coll.call(null, coll);
    this__6124.__hash = h__364__auto____6126;
    return h__364__auto____6126
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6127 = this;
  if(cljs.core.truth_(this__6127.front)) {
    return new cljs.core.PersistentQueue(this__6127.meta, this__6127.count + 1, this__6127.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____6128 = this__6127.rear;
      if(cljs.core.truth_(or__3548__auto____6128)) {
        return or__3548__auto____6128
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__6127.meta, this__6127.count + 1, cljs.core.conj.call(null, this__6127.front, o), cljs.core.PersistentVector.fromArray([]), null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__6129 = this;
  var this$__6130 = this;
  return cljs.core.pr_str.call(null, this$__6130)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6131 = this;
  var rear__6132 = cljs.core.seq.call(null, this__6131.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____6133 = this__6131.front;
    if(cljs.core.truth_(or__3548__auto____6133)) {
      return or__3548__auto____6133
    }else {
      return rear__6132
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__6131.front, cljs.core.seq.call(null, rear__6132), null, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6134 = this;
  return this__6134.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__6135 = this;
  return cljs.core._first.call(null, this__6135.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__6136 = this;
  if(cljs.core.truth_(this__6136.front)) {
    var temp__3695__auto____6137 = cljs.core.next.call(null, this__6136.front);
    if(cljs.core.truth_(temp__3695__auto____6137)) {
      var f1__6138 = temp__3695__auto____6137;
      return new cljs.core.PersistentQueue(this__6136.meta, this__6136.count - 1, f1__6138, this__6136.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__6136.meta, this__6136.count - 1, cljs.core.seq.call(null, this__6136.rear), cljs.core.PersistentVector.fromArray([]), null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6139 = this;
  return cljs.core.first.call(null, this__6139.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6140 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6141 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6142 = this;
  return new cljs.core.PersistentQueue(meta, this__6142.count, this__6142.front, this__6142.rear, this__6142.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6143 = this;
  return this__6143.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6144 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]), 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1048576
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__6145 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__6146 = array.length;
  var i__6147 = 0;
  while(true) {
    if(i__6147 < len__6146) {
      if(cljs.core._EQ_.call(null, k, array[i__6147])) {
        return i__6147
      }else {
        var G__6148 = i__6147 + incr;
        i__6147 = G__6148;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___2 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6149 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____6149)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____6149
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___2.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  obj_map_contains_key_QMARK_.cljs$lang$arity$2 = obj_map_contains_key_QMARK___2;
  obj_map_contains_key_QMARK_.cljs$lang$arity$4 = obj_map_contains_key_QMARK___4;
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__6150 = cljs.core.hash.call(null, a);
  var b__6151 = cljs.core.hash.call(null, b);
  if(a__6150 < b__6151) {
    return-1
  }else {
    if(a__6150 > b__6151) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__6153 = m.keys;
  var len__6154 = ks__6153.length;
  var so__6155 = m.strobj;
  var out__6156 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__6157 = 0;
  var out__6158 = cljs.core.transient$.call(null, out__6156);
  while(true) {
    if(i__6157 < len__6154) {
      var k__6159 = ks__6153[i__6157];
      var G__6160 = i__6157 + 1;
      var G__6161 = cljs.core.assoc_BANG_.call(null, out__6158, k__6159, so__6155[k__6159]);
      i__6157 = G__6160;
      out__6158 = G__6161;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__6158, k, v))
    }
    break
  }
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155021199
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6166 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6167 = this;
  var h__364__auto____6168 = this__6167.__hash;
  if(h__364__auto____6168 != null) {
    return h__364__auto____6168
  }else {
    var h__364__auto____6169 = cljs.core.hash_imap.call(null, coll);
    this__6167.__hash = h__364__auto____6169;
    return h__364__auto____6169
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6170 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6171 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6171.strobj, this__6171.strobj[k], not_found)
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6172 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var overwrite_QMARK___6173 = this__6172.strobj.hasOwnProperty(k);
    if(cljs.core.truth_(overwrite_QMARK___6173)) {
      var new_strobj__6174 = goog.object.clone.call(null, this__6172.strobj);
      new_strobj__6174[k] = v;
      return new cljs.core.ObjMap(this__6172.meta, this__6172.keys, new_strobj__6174, this__6172.update_count + 1, null)
    }else {
      if(this__6172.update_count < cljs.core.ObjMap.HASHMAP_THRESHOLD) {
        var new_strobj__6175 = goog.object.clone.call(null, this__6172.strobj);
        var new_keys__6176 = cljs.core.aclone.call(null, this__6172.keys);
        new_strobj__6175[k] = v;
        new_keys__6176.push(k);
        return new cljs.core.ObjMap(this__6172.meta, new_keys__6176, new_strobj__6175, this__6172.update_count + 1, null)
      }else {
        return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6177 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__6177.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__6197 = null;
  var G__6197__2 = function(tsym6164, k) {
    var this__6178 = this;
    var tsym6164__6179 = this;
    var coll__6180 = tsym6164__6179;
    return cljs.core._lookup.call(null, coll__6180, k)
  };
  var G__6197__3 = function(tsym6165, k, not_found) {
    var this__6181 = this;
    var tsym6165__6182 = this;
    var coll__6183 = tsym6165__6182;
    return cljs.core._lookup.call(null, coll__6183, k, not_found)
  };
  G__6197 = function(tsym6165, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6197__2.call(this, tsym6165, k);
      case 3:
        return G__6197__3.call(this, tsym6165, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6197
}();
cljs.core.ObjMap.prototype.apply = function(tsym6162, args6163) {
  return tsym6162.call.apply(tsym6162, [tsym6162].concat(cljs.core.aclone.call(null, args6163)))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6184 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__6185 = this;
  var this$__6186 = this;
  return cljs.core.pr_str.call(null, this$__6186)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6187 = this;
  if(this__6187.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__6152_SHARP_) {
      return cljs.core.vector.call(null, p1__6152_SHARP_, this__6187.strobj[p1__6152_SHARP_])
    }, this__6187.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6188 = this;
  return this__6188.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6189 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6190 = this;
  return new cljs.core.ObjMap(meta, this__6190.keys, this__6190.strobj, this__6190.update_count, this__6190.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6191 = this;
  return this__6191.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6192 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__6192.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6193 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____6194 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____6194)) {
      return this__6193.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____6194
    }
  }())) {
    var new_keys__6195 = cljs.core.aclone.call(null, this__6193.keys);
    var new_strobj__6196 = goog.object.clone.call(null, this__6193.strobj);
    new_keys__6195.splice(cljs.core.scan_array.call(null, 1, k, new_keys__6195), 1);
    cljs.core.js_delete.call(null, new_strobj__6196, k);
    return new cljs.core.ObjMap(this__6193.meta, new_keys__6195, new_strobj__6196, this__6193.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 7537551
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6203 = this;
  var h__364__auto____6204 = this__6203.__hash;
  if(h__364__auto____6204 != null) {
    return h__364__auto____6204
  }else {
    var h__364__auto____6205 = cljs.core.hash_imap.call(null, coll);
    this__6203.__hash = h__364__auto____6205;
    return h__364__auto____6205
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6206 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6207 = this;
  var bucket__6208 = this__6207.hashobj[cljs.core.hash.call(null, k)];
  var i__6209 = cljs.core.truth_(bucket__6208) ? cljs.core.scan_array.call(null, 2, k, bucket__6208) : null;
  if(cljs.core.truth_(i__6209)) {
    return bucket__6208[i__6209 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6210 = this;
  var h__6211 = cljs.core.hash.call(null, k);
  var bucket__6212 = this__6210.hashobj[h__6211];
  if(cljs.core.truth_(bucket__6212)) {
    var new_bucket__6213 = cljs.core.aclone.call(null, bucket__6212);
    var new_hashobj__6214 = goog.object.clone.call(null, this__6210.hashobj);
    new_hashobj__6214[h__6211] = new_bucket__6213;
    var temp__3695__auto____6215 = cljs.core.scan_array.call(null, 2, k, new_bucket__6213);
    if(cljs.core.truth_(temp__3695__auto____6215)) {
      var i__6216 = temp__3695__auto____6215;
      new_bucket__6213[i__6216 + 1] = v;
      return new cljs.core.HashMap(this__6210.meta, this__6210.count, new_hashobj__6214, null)
    }else {
      new_bucket__6213.push(k, v);
      return new cljs.core.HashMap(this__6210.meta, this__6210.count + 1, new_hashobj__6214, null)
    }
  }else {
    var new_hashobj__6217 = goog.object.clone.call(null, this__6210.hashobj);
    new_hashobj__6217[h__6211] = [k, v];
    return new cljs.core.HashMap(this__6210.meta, this__6210.count + 1, new_hashobj__6217, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6218 = this;
  var bucket__6219 = this__6218.hashobj[cljs.core.hash.call(null, k)];
  var i__6220 = cljs.core.truth_(bucket__6219) ? cljs.core.scan_array.call(null, 2, k, bucket__6219) : null;
  if(cljs.core.truth_(i__6220)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__6243 = null;
  var G__6243__2 = function(tsym6201, k) {
    var this__6221 = this;
    var tsym6201__6222 = this;
    var coll__6223 = tsym6201__6222;
    return cljs.core._lookup.call(null, coll__6223, k)
  };
  var G__6243__3 = function(tsym6202, k, not_found) {
    var this__6224 = this;
    var tsym6202__6225 = this;
    var coll__6226 = tsym6202__6225;
    return cljs.core._lookup.call(null, coll__6226, k, not_found)
  };
  G__6243 = function(tsym6202, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6243__2.call(this, tsym6202, k);
      case 3:
        return G__6243__3.call(this, tsym6202, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6243
}();
cljs.core.HashMap.prototype.apply = function(tsym6199, args6200) {
  return tsym6199.call.apply(tsym6199, [tsym6199].concat(cljs.core.aclone.call(null, args6200)))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6227 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__6228 = this;
  var this$__6229 = this;
  return cljs.core.pr_str.call(null, this$__6229)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6230 = this;
  if(this__6230.count > 0) {
    var hashes__6231 = cljs.core.js_keys.call(null, this__6230.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__6198_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__6230.hashobj[p1__6198_SHARP_]))
    }, hashes__6231)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6232 = this;
  return this__6232.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6233 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6234 = this;
  return new cljs.core.HashMap(meta, this__6234.count, this__6234.hashobj, this__6234.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6235 = this;
  return this__6235.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6236 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__6236.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6237 = this;
  var h__6238 = cljs.core.hash.call(null, k);
  var bucket__6239 = this__6237.hashobj[h__6238];
  var i__6240 = cljs.core.truth_(bucket__6239) ? cljs.core.scan_array.call(null, 2, k, bucket__6239) : null;
  if(cljs.core.not.call(null, i__6240)) {
    return coll
  }else {
    var new_hashobj__6241 = goog.object.clone.call(null, this__6237.hashobj);
    if(3 > bucket__6239.length) {
      cljs.core.js_delete.call(null, new_hashobj__6241, h__6238)
    }else {
      var new_bucket__6242 = cljs.core.aclone.call(null, bucket__6239);
      new_bucket__6242.splice(i__6240, 2);
      new_hashobj__6241[h__6238] = new_bucket__6242
    }
    return new cljs.core.HashMap(this__6237.meta, this__6237.count - 1, new_hashobj__6241, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__6244 = ks.length;
  var i__6245 = 0;
  var out__6246 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__6245 < len__6244) {
      var G__6247 = i__6245 + 1;
      var G__6248 = cljs.core.assoc.call(null, out__6246, ks[i__6245], vs[i__6245]);
      i__6245 = G__6247;
      out__6246 = G__6248;
      continue
    }else {
      return out__6246
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__6249 = m.arr;
  var len__6250 = arr__6249.length;
  var i__6251 = 0;
  while(true) {
    if(len__6250 <= i__6251) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__6249[i__6251], k)) {
        return i__6251
      }else {
        if("\ufdd0'else") {
          var G__6252 = i__6251 + 2;
          i__6251 = G__6252;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
void 0;
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6257 = this;
  return new cljs.core.TransientArrayMap({}, this__6257.arr.length, cljs.core.aclone.call(null, this__6257.arr))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6258 = this;
  var h__364__auto____6259 = this__6258.__hash;
  if(h__364__auto____6259 != null) {
    return h__364__auto____6259
  }else {
    var h__364__auto____6260 = cljs.core.hash_imap.call(null, coll);
    this__6258.__hash = h__364__auto____6260;
    return h__364__auto____6260
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6261 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6262 = this;
  var idx__6263 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6263 === -1) {
    return not_found
  }else {
    return this__6262.arr[idx__6263 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6264 = this;
  var idx__6265 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6265 === -1) {
    if(this__6264.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__6264.meta, this__6264.cnt + 1, function() {
        var G__6266__6267 = cljs.core.aclone.call(null, this__6264.arr);
        G__6266__6267.push(k);
        G__6266__6267.push(v);
        return G__6266__6267
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__6264.arr[idx__6265 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__6264.meta, this__6264.cnt, function() {
          var G__6268__6269 = cljs.core.aclone.call(null, this__6264.arr);
          G__6268__6269[idx__6265 + 1] = v;
          return G__6268__6269
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6270 = this;
  return cljs.core.array_map_index_of.call(null, coll, k) != -1
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__6300 = null;
  var G__6300__2 = function(tsym6255, k) {
    var this__6271 = this;
    var tsym6255__6272 = this;
    var coll__6273 = tsym6255__6272;
    return cljs.core._lookup.call(null, coll__6273, k)
  };
  var G__6300__3 = function(tsym6256, k, not_found) {
    var this__6274 = this;
    var tsym6256__6275 = this;
    var coll__6276 = tsym6256__6275;
    return cljs.core._lookup.call(null, coll__6276, k, not_found)
  };
  G__6300 = function(tsym6256, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6300__2.call(this, tsym6256, k);
      case 3:
        return G__6300__3.call(this, tsym6256, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6300
}();
cljs.core.PersistentArrayMap.prototype.apply = function(tsym6253, args6254) {
  return tsym6253.call.apply(tsym6253, [tsym6253].concat(cljs.core.aclone.call(null, args6254)))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6277 = this;
  var len__6278 = this__6277.arr.length;
  var i__6279 = 0;
  var init__6280 = init;
  while(true) {
    if(i__6279 < len__6278) {
      var init__6281 = f.call(null, init__6280, this__6277.arr[i__6279], this__6277.arr[i__6279 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__6281)) {
        return cljs.core.deref.call(null, init__6281)
      }else {
        var G__6301 = i__6279 + 2;
        var G__6302 = init__6281;
        i__6279 = G__6301;
        init__6280 = G__6302;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6282 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__6283 = this;
  var this$__6284 = this;
  return cljs.core.pr_str.call(null, this$__6284)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6285 = this;
  if(this__6285.cnt > 0) {
    var len__6286 = this__6285.arr.length;
    var array_map_seq__6287 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__6286) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__6285.arr[i], this__6285.arr[i + 1]]), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      })
    };
    return array_map_seq__6287.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6288 = this;
  return this__6288.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6289 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6290 = this;
  return new cljs.core.PersistentArrayMap(meta, this__6290.cnt, this__6290.arr, this__6290.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6291 = this;
  return this__6291.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6292 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__6292.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6293 = this;
  var idx__6294 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6294 >= 0) {
    var len__6295 = this__6293.arr.length;
    var new_len__6296 = len__6295 - 2;
    if(new_len__6296 === 0) {
      return cljs.core._empty.call(null, coll)
    }else {
      var new_arr__6297 = cljs.core.make_array.call(null, new_len__6296);
      var s__6298 = 0;
      var d__6299 = 0;
      while(true) {
        if(s__6298 >= len__6295) {
          return new cljs.core.PersistentArrayMap(this__6293.meta, this__6293.cnt - 1, new_arr__6297, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__6293.arr[s__6298])) {
            var G__6303 = s__6298 + 2;
            var G__6304 = d__6299;
            s__6298 = G__6303;
            d__6299 = G__6304;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__6297[d__6299] = this__6293.arr[s__6298];
              new_arr__6297[d__6299 + 1] = this__6293.arr[s__6298 + 1];
              var G__6305 = s__6298 + 2;
              var G__6306 = d__6299 + 2;
              s__6298 = G__6305;
              d__6299 = G__6306;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__6307 = cljs.core.count.call(null, ks);
  var i__6308 = 0;
  var out__6309 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__6308 < len__6307) {
      var G__6310 = i__6308 + 1;
      var G__6311 = cljs.core.assoc_BANG_.call(null, out__6309, ks[i__6308], vs[i__6308]);
      i__6308 = G__6310;
      out__6309 = G__6311;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6309)
    }
    break
  }
};
void 0;
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6312 = this;
  if(cljs.core.truth_(this__6312.editable_QMARK_)) {
    var idx__6313 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6313 >= 0) {
      this__6312.arr[idx__6313] = this__6312.arr[this__6312.len - 2];
      this__6312.arr[idx__6313 + 1] = this__6312.arr[this__6312.len - 1];
      var G__6314__6315 = this__6312.arr;
      G__6314__6315.pop();
      G__6314__6315.pop();
      G__6314__6315;
      this__6312.len = this__6312.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6316 = this;
  if(cljs.core.truth_(this__6316.editable_QMARK_)) {
    var idx__6317 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6317 === -1) {
      if(this__6316.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__6316.len = this__6316.len + 2;
        this__6316.arr.push(key);
        this__6316.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__6316.len, this__6316.arr), key, val)
      }
    }else {
      if(val === this__6316.arr[idx__6317 + 1]) {
        return tcoll
      }else {
        this__6316.arr[idx__6317 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6318 = this;
  if(cljs.core.truth_(this__6318.editable_QMARK_)) {
    if(function() {
      var G__6319__6320 = o;
      if(G__6319__6320 != null) {
        if(function() {
          var or__3548__auto____6321 = G__6319__6320.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6321) {
            return or__3548__auto____6321
          }else {
            return G__6319__6320.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6319__6320.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6319__6320)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6319__6320)
      }
    }()) {
      return cljs.core._assoc_BANG_.call(null, tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6322 = cljs.core.seq.call(null, o);
      var tcoll__6323 = tcoll;
      while(true) {
        var temp__3695__auto____6324 = cljs.core.first.call(null, es__6322);
        if(cljs.core.truth_(temp__3695__auto____6324)) {
          var e__6325 = temp__3695__auto____6324;
          var G__6331 = cljs.core.next.call(null, es__6322);
          var G__6332 = cljs.core._assoc_BANG_.call(null, tcoll__6323, cljs.core.key.call(null, e__6325), cljs.core.val.call(null, e__6325));
          es__6322 = G__6331;
          tcoll__6323 = G__6332;
          continue
        }else {
          return tcoll__6323
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6326 = this;
  if(cljs.core.truth_(this__6326.editable_QMARK_)) {
    this__6326.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__6326.len, 2), this__6326.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6327 = this;
  return cljs.core._lookup.call(null, tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6328 = this;
  if(cljs.core.truth_(this__6328.editable_QMARK_)) {
    var idx__6329 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__6329 === -1) {
      return not_found
    }else {
      return this__6328.arr[idx__6329 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6330 = this;
  if(cljs.core.truth_(this__6330.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__6330.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
void 0;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__6333 = cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {}));
  var i__6334 = 0;
  while(true) {
    if(i__6334 < len) {
      var G__6335 = cljs.core.assoc_BANG_.call(null, out__6333, arr[i__6334], arr[i__6334 + 1]);
      var G__6336 = i__6334 + 2;
      out__6333 = G__6335;
      i__6334 = G__6336;
      continue
    }else {
      return out__6333
    }
    break
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__6337__6338 = cljs.core.aclone.call(null, arr);
    G__6337__6338[i] = a;
    return G__6337__6338
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__6339__6340 = cljs.core.aclone.call(null, arr);
    G__6339__6340[i] = a;
    G__6339__6340[j] = b;
    return G__6339__6340
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__6341 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__6341, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__6341, 2 * i, new_arr__6341.length - 2 * i);
  return new_arr__6341
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__6342 = inode.ensure_editable(edit);
    editable__6342.arr[i] = a;
    return editable__6342
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__6343 = inode.ensure_editable(edit);
    editable__6343.arr[i] = a;
    editable__6343.arr[j] = b;
    return editable__6343
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__6344 = arr.length;
  var i__6345 = 0;
  var init__6346 = init;
  while(true) {
    if(i__6345 < len__6344) {
      var init__6349 = function() {
        var k__6347 = arr[i__6345];
        if(k__6347 != null) {
          return f.call(null, init__6346, k__6347, arr[i__6345 + 1])
        }else {
          var node__6348 = arr[i__6345 + 1];
          if(node__6348 != null) {
            return node__6348.kv_reduce(f, init__6346)
          }else {
            return init__6346
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__6349)) {
        return cljs.core.deref.call(null, init__6349)
      }else {
        var G__6350 = i__6345 + 2;
        var G__6351 = init__6349;
        i__6345 = G__6350;
        init__6346 = G__6351;
        continue
      }
    }else {
      return init__6346
    }
    break
  }
};
void 0;
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__6352 = this;
  var inode__6353 = this;
  if(this__6352.bitmap === bit) {
    return null
  }else {
    var editable__6354 = inode__6353.ensure_editable(e);
    var earr__6355 = editable__6354.arr;
    var len__6356 = earr__6355.length;
    editable__6354.bitmap = bit ^ editable__6354.bitmap;
    cljs.core.array_copy.call(null, earr__6355, 2 * (i + 1), earr__6355, 2 * i, len__6356 - 2 * (i + 1));
    earr__6355[len__6356 - 2] = null;
    earr__6355[len__6356 - 1] = null;
    return editable__6354
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6357 = this;
  var inode__6358 = this;
  var bit__6359 = 1 << (hash >>> shift & 31);
  var idx__6360 = cljs.core.bitmap_indexed_node_index.call(null, this__6357.bitmap, bit__6359);
  if((this__6357.bitmap & bit__6359) === 0) {
    var n__6361 = cljs.core.bit_count.call(null, this__6357.bitmap);
    if(2 * n__6361 < this__6357.arr.length) {
      var editable__6362 = inode__6358.ensure_editable(edit);
      var earr__6363 = editable__6362.arr;
      added_leaf_QMARK_[0] = true;
      cljs.core.array_copy_downward.call(null, earr__6363, 2 * idx__6360, earr__6363, 2 * (idx__6360 + 1), 2 * (n__6361 - idx__6360));
      earr__6363[2 * idx__6360] = key;
      earr__6363[2 * idx__6360 + 1] = val;
      editable__6362.bitmap = editable__6362.bitmap | bit__6359;
      return editable__6362
    }else {
      if(n__6361 >= 16) {
        var nodes__6364 = cljs.core.make_array.call(null, 32);
        var jdx__6365 = hash >>> shift & 31;
        nodes__6364[jdx__6365] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__6366 = 0;
        var j__6367 = 0;
        while(true) {
          if(i__6366 < 32) {
            if((this__6357.bitmap >>> i__6366 & 1) === 0) {
              var G__6420 = i__6366 + 1;
              var G__6421 = j__6367;
              i__6366 = G__6420;
              j__6367 = G__6421;
              continue
            }else {
              nodes__6364[i__6366] = null != this__6357.arr[j__6367] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__6357.arr[j__6367]), this__6357.arr[j__6367], this__6357.arr[j__6367 + 1], added_leaf_QMARK_) : this__6357.arr[j__6367 + 1];
              var G__6422 = i__6366 + 1;
              var G__6423 = j__6367 + 2;
              i__6366 = G__6422;
              j__6367 = G__6423;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__6361 + 1, nodes__6364)
      }else {
        if("\ufdd0'else") {
          var new_arr__6368 = cljs.core.make_array.call(null, 2 * (n__6361 + 4));
          cljs.core.array_copy.call(null, this__6357.arr, 0, new_arr__6368, 0, 2 * idx__6360);
          new_arr__6368[2 * idx__6360] = key;
          added_leaf_QMARK_[0] = true;
          new_arr__6368[2 * idx__6360 + 1] = val;
          cljs.core.array_copy.call(null, this__6357.arr, 2 * idx__6360, new_arr__6368, 2 * (idx__6360 + 1), 2 * (n__6361 - idx__6360));
          var editable__6369 = inode__6358.ensure_editable(edit);
          editable__6369.arr = new_arr__6368;
          editable__6369.bitmap = editable__6369.bitmap | bit__6359;
          return editable__6369
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__6370 = this__6357.arr[2 * idx__6360];
    var val_or_node__6371 = this__6357.arr[2 * idx__6360 + 1];
    if(null == key_or_nil__6370) {
      var n__6372 = val_or_node__6371.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6372 === val_or_node__6371) {
        return inode__6358
      }else {
        return cljs.core.edit_and_set.call(null, inode__6358, edit, 2 * idx__6360 + 1, n__6372)
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6370)) {
        if(val === val_or_node__6371) {
          return inode__6358
        }else {
          return cljs.core.edit_and_set.call(null, inode__6358, edit, 2 * idx__6360 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return cljs.core.edit_and_set.call(null, inode__6358, edit, 2 * idx__6360, null, 2 * idx__6360 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__6370, val_or_node__6371, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__6373 = this;
  var inode__6374 = this;
  return cljs.core.create_inode_seq.call(null, this__6373.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6375 = this;
  var inode__6376 = this;
  var bit__6377 = 1 << (hash >>> shift & 31);
  if((this__6375.bitmap & bit__6377) === 0) {
    return inode__6376
  }else {
    var idx__6378 = cljs.core.bitmap_indexed_node_index.call(null, this__6375.bitmap, bit__6377);
    var key_or_nil__6379 = this__6375.arr[2 * idx__6378];
    var val_or_node__6380 = this__6375.arr[2 * idx__6378 + 1];
    if(null == key_or_nil__6379) {
      var n__6381 = val_or_node__6380.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__6381 === val_or_node__6380) {
        return inode__6376
      }else {
        if(null != n__6381) {
          return cljs.core.edit_and_set.call(null, inode__6376, edit, 2 * idx__6378 + 1, n__6381)
        }else {
          if(this__6375.bitmap === bit__6377) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__6376.edit_and_remove_pair(edit, bit__6377, idx__6378)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6379)) {
        removed_leaf_QMARK_[0] = true;
        return inode__6376.edit_and_remove_pair(edit, bit__6377, idx__6378)
      }else {
        if("\ufdd0'else") {
          return inode__6376
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__6382 = this;
  var inode__6383 = this;
  if(e === this__6382.edit) {
    return inode__6383
  }else {
    var n__6384 = cljs.core.bit_count.call(null, this__6382.bitmap);
    var new_arr__6385 = cljs.core.make_array.call(null, n__6384 < 0 ? 4 : 2 * (n__6384 + 1));
    cljs.core.array_copy.call(null, this__6382.arr, 0, new_arr__6385, 0, 2 * n__6384);
    return new cljs.core.BitmapIndexedNode(e, this__6382.bitmap, new_arr__6385)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__6386 = this;
  var inode__6387 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6386.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function() {
  var G__6424 = null;
  var G__6424__3 = function(shift, hash, key) {
    var this__6388 = this;
    var inode__6389 = this;
    var bit__6390 = 1 << (hash >>> shift & 31);
    if((this__6388.bitmap & bit__6390) === 0) {
      return null
    }else {
      var idx__6391 = cljs.core.bitmap_indexed_node_index.call(null, this__6388.bitmap, bit__6390);
      var key_or_nil__6392 = this__6388.arr[2 * idx__6391];
      var val_or_node__6393 = this__6388.arr[2 * idx__6391 + 1];
      if(null == key_or_nil__6392) {
        return val_or_node__6393.inode_find(shift + 5, hash, key)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6392)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6392, val_or_node__6393])
        }else {
          if("\ufdd0'else") {
            return null
          }else {
            return null
          }
        }
      }
    }
  };
  var G__6424__4 = function(shift, hash, key, not_found) {
    var this__6394 = this;
    var inode__6395 = this;
    var bit__6396 = 1 << (hash >>> shift & 31);
    if((this__6394.bitmap & bit__6396) === 0) {
      return not_found
    }else {
      var idx__6397 = cljs.core.bitmap_indexed_node_index.call(null, this__6394.bitmap, bit__6396);
      var key_or_nil__6398 = this__6394.arr[2 * idx__6397];
      var val_or_node__6399 = this__6394.arr[2 * idx__6397 + 1];
      if(null == key_or_nil__6398) {
        return val_or_node__6399.inode_find(shift + 5, hash, key, not_found)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6398)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6398, val_or_node__6399])
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  G__6424 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6424__3.call(this, shift, hash, key);
      case 4:
        return G__6424__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6424
}();
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__6400 = this;
  var inode__6401 = this;
  var bit__6402 = 1 << (hash >>> shift & 31);
  if((this__6400.bitmap & bit__6402) === 0) {
    return inode__6401
  }else {
    var idx__6403 = cljs.core.bitmap_indexed_node_index.call(null, this__6400.bitmap, bit__6402);
    var key_or_nil__6404 = this__6400.arr[2 * idx__6403];
    var val_or_node__6405 = this__6400.arr[2 * idx__6403 + 1];
    if(null == key_or_nil__6404) {
      var n__6406 = val_or_node__6405.inode_without(shift + 5, hash, key);
      if(n__6406 === val_or_node__6405) {
        return inode__6401
      }else {
        if(null != n__6406) {
          return new cljs.core.BitmapIndexedNode(null, this__6400.bitmap, cljs.core.clone_and_set.call(null, this__6400.arr, 2 * idx__6403 + 1, n__6406))
        }else {
          if(this__6400.bitmap === bit__6402) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__6400.bitmap ^ bit__6402, cljs.core.remove_pair.call(null, this__6400.arr, idx__6403))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6404)) {
        return new cljs.core.BitmapIndexedNode(null, this__6400.bitmap ^ bit__6402, cljs.core.remove_pair.call(null, this__6400.arr, idx__6403))
      }else {
        if("\ufdd0'else") {
          return inode__6401
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6407 = this;
  var inode__6408 = this;
  var bit__6409 = 1 << (hash >>> shift & 31);
  var idx__6410 = cljs.core.bitmap_indexed_node_index.call(null, this__6407.bitmap, bit__6409);
  if((this__6407.bitmap & bit__6409) === 0) {
    var n__6411 = cljs.core.bit_count.call(null, this__6407.bitmap);
    if(n__6411 >= 16) {
      var nodes__6412 = cljs.core.make_array.call(null, 32);
      var jdx__6413 = hash >>> shift & 31;
      nodes__6412[jdx__6413] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__6414 = 0;
      var j__6415 = 0;
      while(true) {
        if(i__6414 < 32) {
          if((this__6407.bitmap >>> i__6414 & 1) === 0) {
            var G__6425 = i__6414 + 1;
            var G__6426 = j__6415;
            i__6414 = G__6425;
            j__6415 = G__6426;
            continue
          }else {
            nodes__6412[i__6414] = null != this__6407.arr[j__6415] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__6407.arr[j__6415]), this__6407.arr[j__6415], this__6407.arr[j__6415 + 1], added_leaf_QMARK_) : this__6407.arr[j__6415 + 1];
            var G__6427 = i__6414 + 1;
            var G__6428 = j__6415 + 2;
            i__6414 = G__6427;
            j__6415 = G__6428;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__6411 + 1, nodes__6412)
    }else {
      var new_arr__6416 = cljs.core.make_array.call(null, 2 * (n__6411 + 1));
      cljs.core.array_copy.call(null, this__6407.arr, 0, new_arr__6416, 0, 2 * idx__6410);
      new_arr__6416[2 * idx__6410] = key;
      added_leaf_QMARK_[0] = true;
      new_arr__6416[2 * idx__6410 + 1] = val;
      cljs.core.array_copy.call(null, this__6407.arr, 2 * idx__6410, new_arr__6416, 2 * (idx__6410 + 1), 2 * (n__6411 - idx__6410));
      return new cljs.core.BitmapIndexedNode(null, this__6407.bitmap | bit__6409, new_arr__6416)
    }
  }else {
    var key_or_nil__6417 = this__6407.arr[2 * idx__6410];
    var val_or_node__6418 = this__6407.arr[2 * idx__6410 + 1];
    if(null == key_or_nil__6417) {
      var n__6419 = val_or_node__6418.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6419 === val_or_node__6418) {
        return inode__6408
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__6407.bitmap, cljs.core.clone_and_set.call(null, this__6407.arr, 2 * idx__6410 + 1, n__6419))
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6417)) {
        if(val === val_or_node__6418) {
          return inode__6408
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__6407.bitmap, cljs.core.clone_and_set.call(null, this__6407.arr, 2 * idx__6410 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return new cljs.core.BitmapIndexedNode(null, this__6407.bitmap, cljs.core.clone_and_set.call(null, this__6407.arr, 2 * idx__6410, null, 2 * idx__6410 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__6417, val_or_node__6418, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__6429 = array_node.arr;
  var len__6430 = 2 * (array_node.cnt - 1);
  var new_arr__6431 = cljs.core.make_array.call(null, len__6430);
  var i__6432 = 0;
  var j__6433 = 1;
  var bitmap__6434 = 0;
  while(true) {
    if(i__6432 < len__6430) {
      if(function() {
        var and__3546__auto____6435 = i__6432 != idx;
        if(and__3546__auto____6435) {
          return null != arr__6429[i__6432]
        }else {
          return and__3546__auto____6435
        }
      }()) {
        new_arr__6431[j__6433] = arr__6429[i__6432];
        var G__6436 = i__6432 + 1;
        var G__6437 = j__6433 + 2;
        var G__6438 = bitmap__6434 | 1 << i__6432;
        i__6432 = G__6436;
        j__6433 = G__6437;
        bitmap__6434 = G__6438;
        continue
      }else {
        var G__6439 = i__6432 + 1;
        var G__6440 = j__6433;
        var G__6441 = bitmap__6434;
        i__6432 = G__6439;
        j__6433 = G__6440;
        bitmap__6434 = G__6441;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__6434, new_arr__6431)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6442 = this;
  var inode__6443 = this;
  var idx__6444 = hash >>> shift & 31;
  var node__6445 = this__6442.arr[idx__6444];
  if(null == node__6445) {
    return new cljs.core.ArrayNode(null, this__6442.cnt + 1, cljs.core.clone_and_set.call(null, this__6442.arr, idx__6444, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__6446 = node__6445.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6446 === node__6445) {
      return inode__6443
    }else {
      return new cljs.core.ArrayNode(null, this__6442.cnt, cljs.core.clone_and_set.call(null, this__6442.arr, idx__6444, n__6446))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__6447 = this;
  var inode__6448 = this;
  var idx__6449 = hash >>> shift & 31;
  var node__6450 = this__6447.arr[idx__6449];
  if(null != node__6450) {
    var n__6451 = node__6450.inode_without(shift + 5, hash, key);
    if(n__6451 === node__6450) {
      return inode__6448
    }else {
      if(n__6451 == null) {
        if(this__6447.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6448, null, idx__6449)
        }else {
          return new cljs.core.ArrayNode(null, this__6447.cnt - 1, cljs.core.clone_and_set.call(null, this__6447.arr, idx__6449, n__6451))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__6447.cnt, cljs.core.clone_and_set.call(null, this__6447.arr, idx__6449, n__6451))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__6448
  }
};
cljs.core.ArrayNode.prototype.inode_find = function() {
  var G__6483 = null;
  var G__6483__3 = function(shift, hash, key) {
    var this__6452 = this;
    var inode__6453 = this;
    var idx__6454 = hash >>> shift & 31;
    var node__6455 = this__6452.arr[idx__6454];
    if(null != node__6455) {
      return node__6455.inode_find(shift + 5, hash, key)
    }else {
      return null
    }
  };
  var G__6483__4 = function(shift, hash, key, not_found) {
    var this__6456 = this;
    var inode__6457 = this;
    var idx__6458 = hash >>> shift & 31;
    var node__6459 = this__6456.arr[idx__6458];
    if(null != node__6459) {
      return node__6459.inode_find(shift + 5, hash, key, not_found)
    }else {
      return not_found
    }
  };
  G__6483 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6483__3.call(this, shift, hash, key);
      case 4:
        return G__6483__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6483
}();
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__6460 = this;
  var inode__6461 = this;
  return cljs.core.create_array_node_seq.call(null, this__6460.arr)
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__6462 = this;
  var inode__6463 = this;
  if(e === this__6462.edit) {
    return inode__6463
  }else {
    return new cljs.core.ArrayNode(e, this__6462.cnt, cljs.core.aclone.call(null, this__6462.arr))
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6464 = this;
  var inode__6465 = this;
  var idx__6466 = hash >>> shift & 31;
  var node__6467 = this__6464.arr[idx__6466];
  if(null == node__6467) {
    var editable__6468 = cljs.core.edit_and_set.call(null, inode__6465, edit, idx__6466, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__6468.cnt = editable__6468.cnt + 1;
    return editable__6468
  }else {
    var n__6469 = node__6467.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6469 === node__6467) {
      return inode__6465
    }else {
      return cljs.core.edit_and_set.call(null, inode__6465, edit, idx__6466, n__6469)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6470 = this;
  var inode__6471 = this;
  var idx__6472 = hash >>> shift & 31;
  var node__6473 = this__6470.arr[idx__6472];
  if(null == node__6473) {
    return inode__6471
  }else {
    var n__6474 = node__6473.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__6474 === node__6473) {
      return inode__6471
    }else {
      if(null == n__6474) {
        if(this__6470.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6471, edit, idx__6472)
        }else {
          var editable__6475 = cljs.core.edit_and_set.call(null, inode__6471, edit, idx__6472, n__6474);
          editable__6475.cnt = editable__6475.cnt - 1;
          return editable__6475
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__6471, edit, idx__6472, n__6474)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__6476 = this;
  var inode__6477 = this;
  var len__6478 = this__6476.arr.length;
  var i__6479 = 0;
  var init__6480 = init;
  while(true) {
    if(i__6479 < len__6478) {
      var node__6481 = this__6476.arr[i__6479];
      if(node__6481 != null) {
        var init__6482 = node__6481.kv_reduce(f, init__6480);
        if(cljs.core.reduced_QMARK_.call(null, init__6482)) {
          return cljs.core.deref.call(null, init__6482)
        }else {
          var G__6484 = i__6479 + 1;
          var G__6485 = init__6482;
          i__6479 = G__6484;
          init__6480 = G__6485;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__6480
    }
    break
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__6486 = 2 * cnt;
  var i__6487 = 0;
  while(true) {
    if(i__6487 < lim__6486) {
      if(cljs.core._EQ_.call(null, key, arr[i__6487])) {
        return i__6487
      }else {
        var G__6488 = i__6487 + 2;
        i__6487 = G__6488;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6489 = this;
  var inode__6490 = this;
  if(hash === this__6489.collision_hash) {
    var idx__6491 = cljs.core.hash_collision_node_find_index.call(null, this__6489.arr, this__6489.cnt, key);
    if(idx__6491 === -1) {
      var len__6492 = this__6489.arr.length;
      var new_arr__6493 = cljs.core.make_array.call(null, len__6492 + 2);
      cljs.core.array_copy.call(null, this__6489.arr, 0, new_arr__6493, 0, len__6492);
      new_arr__6493[len__6492] = key;
      new_arr__6493[len__6492 + 1] = val;
      added_leaf_QMARK_[0] = true;
      return new cljs.core.HashCollisionNode(null, this__6489.collision_hash, this__6489.cnt + 1, new_arr__6493)
    }else {
      if(cljs.core._EQ_.call(null, this__6489.arr[idx__6491], val)) {
        return inode__6490
      }else {
        return new cljs.core.HashCollisionNode(null, this__6489.collision_hash, this__6489.cnt, cljs.core.clone_and_set.call(null, this__6489.arr, idx__6491 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__6489.collision_hash >>> shift & 31), [null, inode__6490])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__6494 = this;
  var inode__6495 = this;
  var idx__6496 = cljs.core.hash_collision_node_find_index.call(null, this__6494.arr, this__6494.cnt, key);
  if(idx__6496 === -1) {
    return inode__6495
  }else {
    if(this__6494.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__6494.collision_hash, this__6494.cnt - 1, cljs.core.remove_pair.call(null, this__6494.arr, cljs.core.quot.call(null, idx__6496, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function() {
  var G__6523 = null;
  var G__6523__3 = function(shift, hash, key) {
    var this__6497 = this;
    var inode__6498 = this;
    var idx__6499 = cljs.core.hash_collision_node_find_index.call(null, this__6497.arr, this__6497.cnt, key);
    if(idx__6499 < 0) {
      return null
    }else {
      if(cljs.core._EQ_.call(null, key, this__6497.arr[idx__6499])) {
        return cljs.core.PersistentVector.fromArray([this__6497.arr[idx__6499], this__6497.arr[idx__6499 + 1]])
      }else {
        if("\ufdd0'else") {
          return null
        }else {
          return null
        }
      }
    }
  };
  var G__6523__4 = function(shift, hash, key, not_found) {
    var this__6500 = this;
    var inode__6501 = this;
    var idx__6502 = cljs.core.hash_collision_node_find_index.call(null, this__6500.arr, this__6500.cnt, key);
    if(idx__6502 < 0) {
      return not_found
    }else {
      if(cljs.core._EQ_.call(null, key, this__6500.arr[idx__6502])) {
        return cljs.core.PersistentVector.fromArray([this__6500.arr[idx__6502], this__6500.arr[idx__6502 + 1]])
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  };
  G__6523 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6523__3.call(this, shift, hash, key);
      case 4:
        return G__6523__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6523
}();
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__6503 = this;
  var inode__6504 = this;
  return cljs.core.create_inode_seq.call(null, this__6503.arr)
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function() {
  var G__6524 = null;
  var G__6524__1 = function(e) {
    var this__6505 = this;
    var inode__6506 = this;
    if(e === this__6505.edit) {
      return inode__6506
    }else {
      var new_arr__6507 = cljs.core.make_array.call(null, 2 * (this__6505.cnt + 1));
      cljs.core.array_copy.call(null, this__6505.arr, 0, new_arr__6507, 0, 2 * this__6505.cnt);
      return new cljs.core.HashCollisionNode(e, this__6505.collision_hash, this__6505.cnt, new_arr__6507)
    }
  };
  var G__6524__3 = function(e, count, array) {
    var this__6508 = this;
    var inode__6509 = this;
    if(e === this__6508.edit) {
      this__6508.arr = array;
      this__6508.cnt = count;
      return inode__6509
    }else {
      return new cljs.core.HashCollisionNode(this__6508.edit, this__6508.collision_hash, count, array)
    }
  };
  G__6524 = function(e, count, array) {
    switch(arguments.length) {
      case 1:
        return G__6524__1.call(this, e);
      case 3:
        return G__6524__3.call(this, e, count, array)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6524
}();
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6510 = this;
  var inode__6511 = this;
  if(hash === this__6510.collision_hash) {
    var idx__6512 = cljs.core.hash_collision_node_find_index.call(null, this__6510.arr, this__6510.cnt, key);
    if(idx__6512 === -1) {
      if(this__6510.arr.length > 2 * this__6510.cnt) {
        var editable__6513 = cljs.core.edit_and_set.call(null, inode__6511, edit, 2 * this__6510.cnt, key, 2 * this__6510.cnt + 1, val);
        added_leaf_QMARK_[0] = true;
        editable__6513.cnt = editable__6513.cnt + 1;
        return editable__6513
      }else {
        var len__6514 = this__6510.arr.length;
        var new_arr__6515 = cljs.core.make_array.call(null, len__6514 + 2);
        cljs.core.array_copy.call(null, this__6510.arr, 0, new_arr__6515, 0, len__6514);
        new_arr__6515[len__6514] = key;
        new_arr__6515[len__6514 + 1] = val;
        added_leaf_QMARK_[0] = true;
        return inode__6511.ensure_editable(edit, this__6510.cnt + 1, new_arr__6515)
      }
    }else {
      if(this__6510.arr[idx__6512 + 1] === val) {
        return inode__6511
      }else {
        return cljs.core.edit_and_set.call(null, inode__6511, edit, idx__6512 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__6510.collision_hash >>> shift & 31), [null, inode__6511, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6516 = this;
  var inode__6517 = this;
  var idx__6518 = cljs.core.hash_collision_node_find_index.call(null, this__6516.arr, this__6516.cnt, key);
  if(idx__6518 === -1) {
    return inode__6517
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__6516.cnt === 1) {
      return null
    }else {
      var editable__6519 = inode__6517.ensure_editable(edit);
      var earr__6520 = editable__6519.arr;
      earr__6520[idx__6518] = earr__6520[2 * this__6516.cnt - 2];
      earr__6520[idx__6518 + 1] = earr__6520[2 * this__6516.cnt - 1];
      earr__6520[2 * this__6516.cnt - 1] = null;
      earr__6520[2 * this__6516.cnt - 2] = null;
      editable__6519.cnt = editable__6519.cnt - 1;
      return editable__6519
    }
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__6521 = this;
  var inode__6522 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6521.arr, f, init)
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6525 = cljs.core.hash.call(null, key1);
    if(key1hash__6525 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6525, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6526 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__6525, key1, val1, added_leaf_QMARK___6526).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___6526)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6527 = cljs.core.hash.call(null, key1);
    if(key1hash__6527 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6527, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6528 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__6527, key1, val1, added_leaf_QMARK___6528).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___6528)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6529 = this;
  var h__364__auto____6530 = this__6529.__hash;
  if(h__364__auto____6530 != null) {
    return h__364__auto____6530
  }else {
    var h__364__auto____6531 = cljs.core.hash_coll.call(null, coll);
    this__6529.__hash = h__364__auto____6531;
    return h__364__auto____6531
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6532 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__6533 = this;
  var this$__6534 = this;
  return cljs.core.pr_str.call(null, this$__6534)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6535 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6536 = this;
  if(this__6536.s == null) {
    return cljs.core.PersistentVector.fromArray([this__6536.nodes[this__6536.i], this__6536.nodes[this__6536.i + 1]])
  }else {
    return cljs.core.first.call(null, this__6536.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6537 = this;
  if(this__6537.s == null) {
    return cljs.core.create_inode_seq.call(null, this__6537.nodes, this__6537.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__6537.nodes, this__6537.i, cljs.core.next.call(null, this__6537.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6538 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6539 = this;
  return new cljs.core.NodeSeq(meta, this__6539.nodes, this__6539.i, this__6539.s, this__6539.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6540 = this;
  return this__6540.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6541 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6541.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__6542 = nodes.length;
      var j__6543 = i;
      while(true) {
        if(j__6543 < len__6542) {
          if(null != nodes[j__6543]) {
            return new cljs.core.NodeSeq(null, nodes, j__6543, null, null)
          }else {
            var temp__3695__auto____6544 = nodes[j__6543 + 1];
            if(cljs.core.truth_(temp__3695__auto____6544)) {
              var node__6545 = temp__3695__auto____6544;
              var temp__3695__auto____6546 = node__6545.inode_seq();
              if(cljs.core.truth_(temp__3695__auto____6546)) {
                var node_seq__6547 = temp__3695__auto____6546;
                return new cljs.core.NodeSeq(null, nodes, j__6543 + 2, node_seq__6547, null)
              }else {
                var G__6548 = j__6543 + 2;
                j__6543 = G__6548;
                continue
              }
            }else {
              var G__6549 = j__6543 + 2;
              j__6543 = G__6549;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6550 = this;
  var h__364__auto____6551 = this__6550.__hash;
  if(h__364__auto____6551 != null) {
    return h__364__auto____6551
  }else {
    var h__364__auto____6552 = cljs.core.hash_coll.call(null, coll);
    this__6550.__hash = h__364__auto____6552;
    return h__364__auto____6552
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6553 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__6554 = this;
  var this$__6555 = this;
  return cljs.core.pr_str.call(null, this$__6555)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6556 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6557 = this;
  return cljs.core.first.call(null, this__6557.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6558 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__6558.nodes, this__6558.i, cljs.core.next.call(null, this__6558.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6559 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6560 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__6560.nodes, this__6560.i, this__6560.s, this__6560.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6561 = this;
  return this__6561.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6562 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6562.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__6563 = nodes.length;
      var j__6564 = i;
      while(true) {
        if(j__6564 < len__6563) {
          var temp__3695__auto____6565 = nodes[j__6564];
          if(cljs.core.truth_(temp__3695__auto____6565)) {
            var nj__6566 = temp__3695__auto____6565;
            var temp__3695__auto____6567 = nj__6566.inode_seq();
            if(cljs.core.truth_(temp__3695__auto____6567)) {
              var ns__6568 = temp__3695__auto____6567;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__6564 + 1, ns__6568, null)
            }else {
              var G__6569 = j__6564 + 1;
              j__6564 = G__6569;
              continue
            }
          }else {
            var G__6570 = j__6564 + 1;
            j__6564 = G__6570;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
void 0;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6575 = this;
  return new cljs.core.TransientHashMap({}, this__6575.root, this__6575.cnt, this__6575.has_nil_QMARK_, this__6575.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6576 = this;
  var h__364__auto____6577 = this__6576.__hash;
  if(h__364__auto____6577 != null) {
    return h__364__auto____6577
  }else {
    var h__364__auto____6578 = cljs.core.hash_imap.call(null, coll);
    this__6576.__hash = h__364__auto____6578;
    return h__364__auto____6578
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6579 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6580 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6580.has_nil_QMARK_)) {
      return this__6580.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6580.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return cljs.core.nth.call(null, this__6580.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6581 = this;
  if(k == null) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6582 = this__6581.has_nil_QMARK_;
      if(cljs.core.truth_(and__3546__auto____6582)) {
        return v === this__6581.nil_val
      }else {
        return and__3546__auto____6582
      }
    }())) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6581.meta, cljs.core.truth_(this__6581.has_nil_QMARK_) ? this__6581.cnt : this__6581.cnt + 1, this__6581.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___6583 = [false];
    var new_root__6584 = (this__6581.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6581.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6583);
    if(new_root__6584 === this__6581.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6581.meta, cljs.core.truth_(added_leaf_QMARK___6583[0]) ? this__6581.cnt + 1 : this__6581.cnt, new_root__6584, this__6581.has_nil_QMARK_, this__6581.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6585 = this;
  if(k == null) {
    return this__6585.has_nil_QMARK_
  }else {
    if(this__6585.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return cljs.core.not.call(null, this__6585.root.inode_find(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__6606 = null;
  var G__6606__2 = function(tsym6573, k) {
    var this__6586 = this;
    var tsym6573__6587 = this;
    var coll__6588 = tsym6573__6587;
    return cljs.core._lookup.call(null, coll__6588, k)
  };
  var G__6606__3 = function(tsym6574, k, not_found) {
    var this__6589 = this;
    var tsym6574__6590 = this;
    var coll__6591 = tsym6574__6590;
    return cljs.core._lookup.call(null, coll__6591, k, not_found)
  };
  G__6606 = function(tsym6574, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6606__2.call(this, tsym6574, k);
      case 3:
        return G__6606__3.call(this, tsym6574, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6606
}();
cljs.core.PersistentHashMap.prototype.apply = function(tsym6571, args6572) {
  return tsym6571.call.apply(tsym6571, [tsym6571].concat(cljs.core.aclone.call(null, args6572)))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6592 = this;
  var init__6593 = cljs.core.truth_(this__6592.has_nil_QMARK_) ? f.call(null, init, null, this__6592.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__6593)) {
    return cljs.core.deref.call(null, init__6593)
  }else {
    if(null != this__6592.root) {
      return this__6592.root.kv_reduce(f, init__6593)
    }else {
      if("\ufdd0'else") {
        return init__6593
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6594 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__6595 = this;
  var this$__6596 = this;
  return cljs.core.pr_str.call(null, this$__6596)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6597 = this;
  if(this__6597.cnt > 0) {
    var s__6598 = null != this__6597.root ? this__6597.root.inode_seq() : null;
    if(cljs.core.truth_(this__6597.has_nil_QMARK_)) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__6597.nil_val]), s__6598)
    }else {
      return s__6598
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6599 = this;
  return this__6599.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6600 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6601 = this;
  return new cljs.core.PersistentHashMap(meta, this__6601.cnt, this__6601.root, this__6601.has_nil_QMARK_, this__6601.nil_val, this__6601.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6602 = this;
  return this__6602.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6603 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__6603.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6604 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6604.has_nil_QMARK_)) {
      return new cljs.core.PersistentHashMap(this__6604.meta, this__6604.cnt - 1, this__6604.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__6604.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__6605 = this__6604.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__6605 === this__6604.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__6604.meta, this__6604.cnt - 1, new_root__6605, this__6604.has_nil_QMARK_, this__6604.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__6607 = ks.length;
  var i__6608 = 0;
  var out__6609 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__6608 < len__6607) {
      var G__6610 = i__6608 + 1;
      var G__6611 = cljs.core.assoc_BANG_.call(null, out__6609, ks[i__6608], vs[i__6608]);
      i__6608 = G__6610;
      out__6609 = G__6611;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6609)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6612 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6613 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__6614 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6615 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6616 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6616.has_nil_QMARK_)) {
      return this__6616.nil_val
    }else {
      return null
    }
  }else {
    if(this__6616.root == null) {
      return null
    }else {
      return cljs.core.nth.call(null, this__6616.root.inode_find(0, cljs.core.hash.call(null, k), k), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6617 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6617.has_nil_QMARK_)) {
      return this__6617.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6617.root == null) {
      return not_found
    }else {
      return cljs.core.nth.call(null, this__6617.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6618 = this;
  if(cljs.core.truth_(this__6618.edit)) {
    return this__6618.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__6619 = this;
  var tcoll__6620 = this;
  if(cljs.core.truth_(this__6619.edit)) {
    if(function() {
      var G__6621__6622 = o;
      if(G__6621__6622 != null) {
        if(function() {
          var or__3548__auto____6623 = G__6621__6622.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6623) {
            return or__3548__auto____6623
          }else {
            return G__6621__6622.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6621__6622.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6621__6622)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6621__6622)
      }
    }()) {
      return tcoll__6620.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6624 = cljs.core.seq.call(null, o);
      var tcoll__6625 = tcoll__6620;
      while(true) {
        var temp__3695__auto____6626 = cljs.core.first.call(null, es__6624);
        if(cljs.core.truth_(temp__3695__auto____6626)) {
          var e__6627 = temp__3695__auto____6626;
          var G__6638 = cljs.core.next.call(null, es__6624);
          var G__6639 = tcoll__6625.assoc_BANG_(cljs.core.key.call(null, e__6627), cljs.core.val.call(null, e__6627));
          es__6624 = G__6638;
          tcoll__6625 = G__6639;
          continue
        }else {
          return tcoll__6625
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__6628 = this;
  var tcoll__6629 = this;
  if(cljs.core.truth_(this__6628.edit)) {
    if(k == null) {
      if(this__6628.nil_val === v) {
      }else {
        this__6628.nil_val = v
      }
      if(cljs.core.truth_(this__6628.has_nil_QMARK_)) {
      }else {
        this__6628.count = this__6628.count + 1;
        this__6628.has_nil_QMARK_ = true
      }
      return tcoll__6629
    }else {
      var added_leaf_QMARK___6630 = [false];
      var node__6631 = (this__6628.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6628.root).inode_assoc_BANG_(this__6628.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6630);
      if(node__6631 === this__6628.root) {
      }else {
        this__6628.root = node__6631
      }
      if(cljs.core.truth_(added_leaf_QMARK___6630[0])) {
        this__6628.count = this__6628.count + 1
      }else {
      }
      return tcoll__6629
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__6632 = this;
  var tcoll__6633 = this;
  if(cljs.core.truth_(this__6632.edit)) {
    if(k == null) {
      if(cljs.core.truth_(this__6632.has_nil_QMARK_)) {
        this__6632.has_nil_QMARK_ = false;
        this__6632.nil_val = null;
        this__6632.count = this__6632.count - 1;
        return tcoll__6633
      }else {
        return tcoll__6633
      }
    }else {
      if(this__6632.root == null) {
        return tcoll__6633
      }else {
        var removed_leaf_QMARK___6634 = [false];
        var node__6635 = this__6632.root.inode_without_BANG_(this__6632.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___6634);
        if(node__6635 === this__6632.root) {
        }else {
          this__6632.root = node__6635
        }
        if(cljs.core.truth_(removed_leaf_QMARK___6634[0])) {
          this__6632.count = this__6632.count - 1
        }else {
        }
        return tcoll__6633
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__6636 = this;
  var tcoll__6637 = this;
  if(cljs.core.truth_(this__6636.edit)) {
    this__6636.edit = null;
    return new cljs.core.PersistentHashMap(null, this__6636.count, this__6636.root, this__6636.has_nil_QMARK_, this__6636.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__6640 = node;
  var stack__6641 = stack;
  while(true) {
    if(t__6640 != null) {
      var G__6642 = cljs.core.truth_(ascending_QMARK_) ? t__6640.left : t__6640.right;
      var G__6643 = cljs.core.conj.call(null, stack__6641, t__6640);
      t__6640 = G__6642;
      stack__6641 = G__6643;
      continue
    }else {
      return stack__6641
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925322
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6644 = this;
  var h__364__auto____6645 = this__6644.__hash;
  if(h__364__auto____6645 != null) {
    return h__364__auto____6645
  }else {
    var h__364__auto____6646 = cljs.core.hash_coll.call(null, coll);
    this__6644.__hash = h__364__auto____6646;
    return h__364__auto____6646
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6647 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__6648 = this;
  var this$__6649 = this;
  return cljs.core.pr_str.call(null, this$__6649)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6650 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6651 = this;
  if(this__6651.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__6651.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__6652 = this;
  return cljs.core.peek.call(null, this__6652.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__6653 = this;
  var t__6654 = cljs.core.peek.call(null, this__6653.stack);
  var next_stack__6655 = cljs.core.tree_map_seq_push.call(null, cljs.core.truth_(this__6653.ascending_QMARK_) ? t__6654.right : t__6654.left, cljs.core.pop.call(null, this__6653.stack), this__6653.ascending_QMARK_);
  if(next_stack__6655 != null) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__6655, this__6653.ascending_QMARK_, this__6653.cnt - 1, null)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6656 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6657 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__6657.stack, this__6657.ascending_QMARK_, this__6657.cnt, this__6657.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6658 = this;
  return this__6658.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
void 0;
void 0;
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3546__auto____6659 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3546__auto____6659) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3546__auto____6659
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3546__auto____6660 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3546__auto____6660) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3546__auto____6660
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__6661 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__6661)) {
    return cljs.core.deref.call(null, init__6661)
  }else {
    var init__6662 = node.left != null ? tree_map_kv_reduce.call(null, node.left, f, init__6661) : init__6661;
    if(cljs.core.reduced_QMARK_.call(null, init__6662)) {
      return cljs.core.deref.call(null, init__6662)
    }else {
      var init__6663 = node.right != null ? tree_map_kv_reduce.call(null, node.right, f, init__6662) : init__6662;
      if(cljs.core.reduced_QMARK_.call(null, init__6663)) {
        return cljs.core.deref.call(null, init__6663)
      }else {
        return init__6663
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$ = true;
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6668 = this;
  var h__364__auto____6669 = this__6668.__hash;
  if(h__364__auto____6669 != null) {
    return h__364__auto____6669
  }else {
    var h__364__auto____6670 = cljs.core.hash_coll.call(null, coll);
    this__6668.__hash = h__364__auto____6670;
    return h__364__auto____6670
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$ = true;
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6671 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6672 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6673 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6673.key, this__6673.val]), k, v)
};
cljs.core.BlackNode.prototype.cljs$core$IFn$ = true;
cljs.core.BlackNode.prototype.call = function() {
  var G__6720 = null;
  var G__6720__2 = function(tsym6666, k) {
    var this__6674 = this;
    var tsym6666__6675 = this;
    var node__6676 = tsym6666__6675;
    return cljs.core._lookup.call(null, node__6676, k)
  };
  var G__6720__3 = function(tsym6667, k, not_found) {
    var this__6677 = this;
    var tsym6667__6678 = this;
    var node__6679 = tsym6667__6678;
    return cljs.core._lookup.call(null, node__6679, k, not_found)
  };
  G__6720 = function(tsym6667, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6720__2.call(this, tsym6667, k);
      case 3:
        return G__6720__3.call(this, tsym6667, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6720
}();
cljs.core.BlackNode.prototype.apply = function(tsym6664, args6665) {
  return tsym6664.call.apply(tsym6664, [tsym6664].concat(cljs.core.aclone.call(null, args6665)))
};
cljs.core.BlackNode.prototype.cljs$core$ISequential$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6680 = this;
  return cljs.core.PersistentVector.fromArray([this__6680.key, this__6680.val, o])
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6681 = this;
  return this__6681.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6682 = this;
  return this__6682.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__6683 = this;
  var node__6684 = this;
  return ins.balance_right(node__6684)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__6685 = this;
  var node__6686 = this;
  return new cljs.core.RedNode(this__6685.key, this__6685.val, this__6685.left, this__6685.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__6687 = this;
  var node__6688 = this;
  return cljs.core.balance_right_del.call(null, this__6687.key, this__6687.val, this__6687.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__6689 = this;
  var node__6690 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__6691 = this;
  var node__6692 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6692, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__6693 = this;
  var node__6694 = this;
  return cljs.core.balance_left_del.call(null, this__6693.key, this__6693.val, del, this__6693.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__6695 = this;
  var node__6696 = this;
  return ins.balance_left(node__6696)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__6697 = this;
  var node__6698 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__6698, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__6721 = null;
  var G__6721__0 = function() {
    var this__6701 = this;
    var this$__6702 = this;
    return cljs.core.pr_str.call(null, this$__6702)
  };
  G__6721 = function() {
    switch(arguments.length) {
      case 0:
        return G__6721__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6721
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__6703 = this;
  var node__6704 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6704, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__6705 = this;
  var node__6706 = this;
  return node__6706
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$ = true;
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6707 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6708 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6709 = this;
  return cljs.core.list.call(null, this__6709.key, this__6709.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6711 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$ = true;
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6712 = this;
  return this__6712.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6713 = this;
  return cljs.core.PersistentVector.fromArray([this__6713.key])
};
cljs.core.BlackNode.prototype.cljs$core$IVector$ = true;
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6714 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6714.key, this__6714.val]), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6715 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6716 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6716.key, this__6716.val]), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6717 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6718 = this;
  if(n === 0) {
    return this__6718.key
  }else {
    if(n === 1) {
      return this__6718.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6719 = this;
  if(n === 0) {
    return this__6719.key
  }else {
    if(n === 1) {
      return this__6719.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6710 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$ = true;
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6726 = this;
  var h__364__auto____6727 = this__6726.__hash;
  if(h__364__auto____6727 != null) {
    return h__364__auto____6727
  }else {
    var h__364__auto____6728 = cljs.core.hash_coll.call(null, coll);
    this__6726.__hash = h__364__auto____6728;
    return h__364__auto____6728
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$ = true;
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6729 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6730 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6731 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6731.key, this__6731.val]), k, v)
};
cljs.core.RedNode.prototype.cljs$core$IFn$ = true;
cljs.core.RedNode.prototype.call = function() {
  var G__6778 = null;
  var G__6778__2 = function(tsym6724, k) {
    var this__6732 = this;
    var tsym6724__6733 = this;
    var node__6734 = tsym6724__6733;
    return cljs.core._lookup.call(null, node__6734, k)
  };
  var G__6778__3 = function(tsym6725, k, not_found) {
    var this__6735 = this;
    var tsym6725__6736 = this;
    var node__6737 = tsym6725__6736;
    return cljs.core._lookup.call(null, node__6737, k, not_found)
  };
  G__6778 = function(tsym6725, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6778__2.call(this, tsym6725, k);
      case 3:
        return G__6778__3.call(this, tsym6725, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6778
}();
cljs.core.RedNode.prototype.apply = function(tsym6722, args6723) {
  return tsym6722.call.apply(tsym6722, [tsym6722].concat(cljs.core.aclone.call(null, args6723)))
};
cljs.core.RedNode.prototype.cljs$core$ISequential$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6738 = this;
  return cljs.core.PersistentVector.fromArray([this__6738.key, this__6738.val, o])
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6739 = this;
  return this__6739.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6740 = this;
  return this__6740.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__6741 = this;
  var node__6742 = this;
  return new cljs.core.RedNode(this__6741.key, this__6741.val, this__6741.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__6743 = this;
  var node__6744 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__6745 = this;
  var node__6746 = this;
  return new cljs.core.RedNode(this__6745.key, this__6745.val, this__6745.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__6747 = this;
  var node__6748 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__6749 = this;
  var node__6750 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6750, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__6751 = this;
  var node__6752 = this;
  return new cljs.core.RedNode(this__6751.key, this__6751.val, del, this__6751.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__6753 = this;
  var node__6754 = this;
  return new cljs.core.RedNode(this__6753.key, this__6753.val, ins, this__6753.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__6755 = this;
  var node__6756 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6755.left)) {
    return new cljs.core.RedNode(this__6755.key, this__6755.val, this__6755.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__6755.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6755.right)) {
      return new cljs.core.RedNode(this__6755.right.key, this__6755.right.val, new cljs.core.BlackNode(this__6755.key, this__6755.val, this__6755.left, this__6755.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__6755.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__6756, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__6779 = null;
  var G__6779__0 = function() {
    var this__6759 = this;
    var this$__6760 = this;
    return cljs.core.pr_str.call(null, this$__6760)
  };
  G__6779 = function() {
    switch(arguments.length) {
      case 0:
        return G__6779__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6779
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__6761 = this;
  var node__6762 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6761.right)) {
    return new cljs.core.RedNode(this__6761.key, this__6761.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6761.left, null), this__6761.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6761.left)) {
      return new cljs.core.RedNode(this__6761.left.key, this__6761.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6761.left.left, null), new cljs.core.BlackNode(this__6761.key, this__6761.val, this__6761.left.right, this__6761.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6762, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__6763 = this;
  var node__6764 = this;
  return new cljs.core.BlackNode(this__6763.key, this__6763.val, this__6763.left, this__6763.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$ = true;
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6765 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6766 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6767 = this;
  return cljs.core.list.call(null, this__6767.key, this__6767.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$ = true;
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6769 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$ = true;
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6770 = this;
  return this__6770.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6771 = this;
  return cljs.core.PersistentVector.fromArray([this__6771.key])
};
cljs.core.RedNode.prototype.cljs$core$IVector$ = true;
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6772 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6772.key, this__6772.val]), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6773 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6774 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6774.key, this__6774.val]), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6775 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6776 = this;
  if(n === 0) {
    return this__6776.key
  }else {
    if(n === 1) {
      return this__6776.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6777 = this;
  if(n === 0) {
    return this__6777.key
  }else {
    if(n === 1) {
      return this__6777.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6768 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__6780 = comp.call(null, k, tree.key);
    if(c__6780 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__6780 < 0) {
        var ins__6781 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(ins__6781 != null) {
          return tree.add_left(ins__6781)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__6782 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(ins__6782 != null) {
            return tree.add_right(ins__6782)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__6783 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6783)) {
            return new cljs.core.RedNode(app__6783.key, app__6783.val, new cljs.core.RedNode(left.key, left.val, left.left, app__6783.left), new cljs.core.RedNode(right.key, right.val, app__6783.right, right.right), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__6783, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__6784 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6784)) {
              return new cljs.core.RedNode(app__6784.key, app__6784.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__6784.left, null), new cljs.core.BlackNode(right.key, right.val, app__6784.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__6784, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(tree != null) {
    var c__6785 = comp.call(null, k, tree.key);
    if(c__6785 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__6785 < 0) {
        var del__6786 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3548__auto____6787 = del__6786 != null;
          if(or__3548__auto____6787) {
            return or__3548__auto____6787
          }else {
            return found[0] != null
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__6786, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__6786, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__6788 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3548__auto____6789 = del__6788 != null;
            if(or__3548__auto____6789) {
              return or__3548__auto____6789
            }else {
              return found[0] != null
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__6788)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__6788, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__6790 = tree.key;
  var c__6791 = comp.call(null, k, tk__6790);
  if(c__6791 === 0) {
    return tree.replace(tk__6790, v, tree.left, tree.right)
  }else {
    if(c__6791 < 0) {
      return tree.replace(tk__6790, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__6790, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 209388431
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6796 = this;
  var h__364__auto____6797 = this__6796.__hash;
  if(h__364__auto____6797 != null) {
    return h__364__auto____6797
  }else {
    var h__364__auto____6798 = cljs.core.hash_imap.call(null, coll);
    this__6796.__hash = h__364__auto____6798;
    return h__364__auto____6798
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6799 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6800 = this;
  var n__6801 = coll.entry_at(k);
  if(n__6801 != null) {
    return n__6801.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6802 = this;
  var found__6803 = [null];
  var t__6804 = cljs.core.tree_map_add.call(null, this__6802.comp, this__6802.tree, k, v, found__6803);
  if(t__6804 == null) {
    var found_node__6805 = cljs.core.nth.call(null, found__6803, 0);
    if(cljs.core._EQ_.call(null, v, found_node__6805.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6802.comp, cljs.core.tree_map_replace.call(null, this__6802.comp, this__6802.tree, k, v), this__6802.cnt, this__6802.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6802.comp, t__6804.blacken(), this__6802.cnt + 1, this__6802.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6806 = this;
  return coll.entry_at(k) != null
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__6838 = null;
  var G__6838__2 = function(tsym6794, k) {
    var this__6807 = this;
    var tsym6794__6808 = this;
    var coll__6809 = tsym6794__6808;
    return cljs.core._lookup.call(null, coll__6809, k)
  };
  var G__6838__3 = function(tsym6795, k, not_found) {
    var this__6810 = this;
    var tsym6795__6811 = this;
    var coll__6812 = tsym6795__6811;
    return cljs.core._lookup.call(null, coll__6812, k, not_found)
  };
  G__6838 = function(tsym6795, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6838__2.call(this, tsym6795, k);
      case 3:
        return G__6838__3.call(this, tsym6795, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6838
}();
cljs.core.PersistentTreeMap.prototype.apply = function(tsym6792, args6793) {
  return tsym6792.call.apply(tsym6792, [tsym6792].concat(cljs.core.aclone.call(null, args6793)))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6813 = this;
  if(this__6813.tree != null) {
    return cljs.core.tree_map_kv_reduce.call(null, this__6813.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6814 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6815 = this;
  if(this__6815.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6815.tree, false, this__6815.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__6816 = this;
  var this$__6817 = this;
  return cljs.core.pr_str.call(null, this$__6817)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__6818 = this;
  var coll__6819 = this;
  var t__6820 = this__6818.tree;
  while(true) {
    if(t__6820 != null) {
      var c__6821 = this__6818.comp.call(null, k, t__6820.key);
      if(c__6821 === 0) {
        return t__6820
      }else {
        if(c__6821 < 0) {
          var G__6839 = t__6820.left;
          t__6820 = G__6839;
          continue
        }else {
          if("\ufdd0'else") {
            var G__6840 = t__6820.right;
            t__6820 = G__6840;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6822 = this;
  if(this__6822.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6822.tree, ascending_QMARK_, this__6822.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6823 = this;
  if(this__6823.cnt > 0) {
    var stack__6824 = null;
    var t__6825 = this__6823.tree;
    while(true) {
      if(t__6825 != null) {
        var c__6826 = this__6823.comp.call(null, k, t__6825.key);
        if(c__6826 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__6824, t__6825), ascending_QMARK_, -1)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__6826 < 0) {
              var G__6841 = cljs.core.conj.call(null, stack__6824, t__6825);
              var G__6842 = t__6825.left;
              stack__6824 = G__6841;
              t__6825 = G__6842;
              continue
            }else {
              var G__6843 = stack__6824;
              var G__6844 = t__6825.right;
              stack__6824 = G__6843;
              t__6825 = G__6844;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__6826 > 0) {
                var G__6845 = cljs.core.conj.call(null, stack__6824, t__6825);
                var G__6846 = t__6825.right;
                stack__6824 = G__6845;
                t__6825 = G__6846;
                continue
              }else {
                var G__6847 = stack__6824;
                var G__6848 = t__6825.left;
                stack__6824 = G__6847;
                t__6825 = G__6848;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__6824 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__6824, ascending_QMARK_, -1)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6827 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6828 = this;
  return this__6828.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6829 = this;
  if(this__6829.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6829.tree, true, this__6829.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6830 = this;
  return this__6830.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6831 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6832 = this;
  return new cljs.core.PersistentTreeMap(this__6832.comp, this__6832.tree, this__6832.cnt, meta, this__6832.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6836 = this;
  return this__6836.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6837 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__6837.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6833 = this;
  var found__6834 = [null];
  var t__6835 = cljs.core.tree_map_remove.call(null, this__6833.comp, this__6833.tree, k, found__6834);
  if(t__6835 == null) {
    if(cljs.core.nth.call(null, found__6834, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6833.comp, null, 0, this__6833.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6833.comp, t__6835.blacken(), this__6833.cnt - 1, this__6833.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__6849 = cljs.core.seq.call(null, keyvals);
    var out__6850 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(cljs.core.truth_(in$__6849)) {
        var G__6851 = cljs.core.nnext.call(null, in$__6849);
        var G__6852 = cljs.core.assoc_BANG_.call(null, out__6850, cljs.core.first.call(null, in$__6849), cljs.core.second.call(null, in$__6849));
        in$__6849 = G__6851;
        out__6850 = G__6852;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__6850)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__6853) {
    var keyvals = cljs.core.seq(arglist__6853);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__6854) {
    var keyvals = cljs.core.seq(arglist__6854);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in$__6855 = cljs.core.seq.call(null, keyvals);
    var out__6856 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__6855)) {
        var G__6857 = cljs.core.nnext.call(null, in$__6855);
        var G__6858 = cljs.core.assoc.call(null, out__6856, cljs.core.first.call(null, in$__6855), cljs.core.second.call(null, in$__6855));
        in$__6855 = G__6857;
        out__6856 = G__6858;
        continue
      }else {
        return out__6856
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__6859) {
    var keyvals = cljs.core.seq(arglist__6859);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in$__6860 = cljs.core.seq.call(null, keyvals);
    var out__6861 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(cljs.core.truth_(in$__6860)) {
        var G__6862 = cljs.core.nnext.call(null, in$__6860);
        var G__6863 = cljs.core.assoc.call(null, out__6861, cljs.core.first.call(null, in$__6860), cljs.core.second.call(null, in$__6860));
        in$__6860 = G__6862;
        out__6861 = G__6863;
        continue
      }else {
        return out__6861
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__6864) {
    var comparator = cljs.core.first(arglist__6864);
    var keyvals = cljs.core.rest(arglist__6864);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__6865_SHARP_, p2__6866_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____6867 = p1__6865_SHARP_;
          if(cljs.core.truth_(or__3548__auto____6867)) {
            return or__3548__auto____6867
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__6866_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__6868) {
    var maps = cljs.core.seq(arglist__6868);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__6871 = function(m, e) {
        var k__6869 = cljs.core.first.call(null, e);
        var v__6870 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__6869)) {
          return cljs.core.assoc.call(null, m, k__6869, f.call(null, cljs.core.get.call(null, m, k__6869), v__6870))
        }else {
          return cljs.core.assoc.call(null, m, k__6869, v__6870)
        }
      };
      var merge2__6873 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__6871, function() {
          var or__3548__auto____6872 = m1;
          if(cljs.core.truth_(or__3548__auto____6872)) {
            return or__3548__auto____6872
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__6873, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__6874) {
    var f = cljs.core.first(arglist__6874);
    var maps = cljs.core.rest(arglist__6874);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__6875 = cljs.core.ObjMap.fromObject([], {});
  var keys__6876 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__6876)) {
      var key__6877 = cljs.core.first.call(null, keys__6876);
      var entry__6878 = cljs.core.get.call(null, map, key__6877, "\ufdd0'user/not-found");
      var G__6879 = cljs.core.not_EQ_.call(null, entry__6878, "\ufdd0'user/not-found") ? cljs.core.assoc.call(null, ret__6875, key__6877, entry__6878) : ret__6875;
      var G__6880 = cljs.core.next.call(null, keys__6876);
      ret__6875 = G__6879;
      keys__6876 = G__6880;
      continue
    }else {
      return ret__6875
    }
    break
  }
};
void 0;
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155022479
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6886 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__6886.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6887 = this;
  var h__364__auto____6888 = this__6887.__hash;
  if(h__364__auto____6888 != null) {
    return h__364__auto____6888
  }else {
    var h__364__auto____6889 = cljs.core.hash_iset.call(null, coll);
    this__6887.__hash = h__364__auto____6889;
    return h__364__auto____6889
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6890 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6891 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6891.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__6910 = null;
  var G__6910__2 = function(tsym6884, k) {
    var this__6892 = this;
    var tsym6884__6893 = this;
    var coll__6894 = tsym6884__6893;
    return cljs.core._lookup.call(null, coll__6894, k)
  };
  var G__6910__3 = function(tsym6885, k, not_found) {
    var this__6895 = this;
    var tsym6885__6896 = this;
    var coll__6897 = tsym6885__6896;
    return cljs.core._lookup.call(null, coll__6897, k, not_found)
  };
  G__6910 = function(tsym6885, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6910__2.call(this, tsym6885, k);
      case 3:
        return G__6910__3.call(this, tsym6885, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6910
}();
cljs.core.PersistentHashSet.prototype.apply = function(tsym6882, args6883) {
  return tsym6882.call.apply(tsym6882, [tsym6882].concat(cljs.core.aclone.call(null, args6883)))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6898 = this;
  return new cljs.core.PersistentHashSet(this__6898.meta, cljs.core.assoc.call(null, this__6898.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__6899 = this;
  var this$__6900 = this;
  return cljs.core.pr_str.call(null, this$__6900)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6901 = this;
  return cljs.core.keys.call(null, this__6901.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6902 = this;
  return new cljs.core.PersistentHashSet(this__6902.meta, cljs.core.dissoc.call(null, this__6902.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6903 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6904 = this;
  var and__3546__auto____6905 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6905) {
    var and__3546__auto____6906 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6906) {
      return cljs.core.every_QMARK_.call(null, function(p1__6881_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6881_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6906
    }
  }else {
    return and__3546__auto____6905
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6907 = this;
  return new cljs.core.PersistentHashSet(meta, this__6907.hash_map, this__6907.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6908 = this;
  return this__6908.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6909 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__6909.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 131;
  this.cljs$lang$protocol_mask$partition1$ = 17
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashSet")
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.TransientHashSet.prototype.call = function() {
  var G__6928 = null;
  var G__6928__2 = function(tsym6914, k) {
    var this__6916 = this;
    var tsym6914__6917 = this;
    var tcoll__6918 = tsym6914__6917;
    if(cljs.core._lookup.call(null, this__6916.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__6928__3 = function(tsym6915, k, not_found) {
    var this__6919 = this;
    var tsym6915__6920 = this;
    var tcoll__6921 = tsym6915__6920;
    if(cljs.core._lookup.call(null, this__6919.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__6928 = function(tsym6915, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6928__2.call(this, tsym6915, k);
      case 3:
        return G__6928__3.call(this, tsym6915, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6928
}();
cljs.core.TransientHashSet.prototype.apply = function(tsym6912, args6913) {
  return tsym6912.call.apply(tsym6912, [tsym6912].concat(cljs.core.aclone.call(null, args6913)))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__6922 = this;
  return cljs.core._lookup.call(null, tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__6923 = this;
  if(cljs.core._lookup.call(null, this__6923.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6924 = this;
  return cljs.core.count.call(null, this__6924.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__6925 = this;
  this__6925.transient_map = cljs.core.dissoc_BANG_.call(null, this__6925.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6926 = this;
  this__6926.transient_map = cljs.core.assoc_BANG_.call(null, this__6926.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6927 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__6927.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 208865423
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6933 = this;
  var h__364__auto____6934 = this__6933.__hash;
  if(h__364__auto____6934 != null) {
    return h__364__auto____6934
  }else {
    var h__364__auto____6935 = cljs.core.hash_iset.call(null, coll);
    this__6933.__hash = h__364__auto____6935;
    return h__364__auto____6935
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6936 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6937 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6937.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__6961 = null;
  var G__6961__2 = function(tsym6931, k) {
    var this__6938 = this;
    var tsym6931__6939 = this;
    var coll__6940 = tsym6931__6939;
    return cljs.core._lookup.call(null, coll__6940, k)
  };
  var G__6961__3 = function(tsym6932, k, not_found) {
    var this__6941 = this;
    var tsym6932__6942 = this;
    var coll__6943 = tsym6932__6942;
    return cljs.core._lookup.call(null, coll__6943, k, not_found)
  };
  G__6961 = function(tsym6932, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6961__2.call(this, tsym6932, k);
      case 3:
        return G__6961__3.call(this, tsym6932, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6961
}();
cljs.core.PersistentTreeSet.prototype.apply = function(tsym6929, args6930) {
  return tsym6929.call.apply(tsym6929, [tsym6929].concat(cljs.core.aclone.call(null, args6930)))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6944 = this;
  return new cljs.core.PersistentTreeSet(this__6944.meta, cljs.core.assoc.call(null, this__6944.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6945 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__6945.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__6946 = this;
  var this$__6947 = this;
  return cljs.core.pr_str.call(null, this$__6947)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6948 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__6948.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6949 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__6949.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6950 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6951 = this;
  return cljs.core._comparator.call(null, this__6951.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6952 = this;
  return cljs.core.keys.call(null, this__6952.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6953 = this;
  return new cljs.core.PersistentTreeSet(this__6953.meta, cljs.core.dissoc.call(null, this__6953.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6954 = this;
  return cljs.core.count.call(null, this__6954.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6955 = this;
  var and__3546__auto____6956 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6956) {
    var and__3546__auto____6957 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6957) {
      return cljs.core.every_QMARK_.call(null, function(p1__6911_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6911_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6957
    }
  }else {
    return and__3546__auto____6956
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6958 = this;
  return new cljs.core.PersistentTreeSet(meta, this__6958.tree_map, this__6958.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6959 = this;
  return this__6959.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6960 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__6960.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.set = function set(coll) {
  var in$__6962 = cljs.core.seq.call(null, coll);
  var out__6963 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, in$__6962))) {
      var G__6964 = cljs.core.next.call(null, in$__6962);
      var G__6965 = cljs.core.conj_BANG_.call(null, out__6963, cljs.core.first.call(null, in$__6962));
      in$__6962 = G__6964;
      out__6963 = G__6965;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6963)
    }
    break
  }
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__6966) {
    var keys = cljs.core.seq(arglist__6966);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__6968) {
    var comparator = cljs.core.first(arglist__6968);
    var keys = cljs.core.rest(arglist__6968);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__6969 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____6970 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____6970)) {
        var e__6971 = temp__3695__auto____6970;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__6971))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__6969, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__6967_SHARP_) {
      var temp__3695__auto____6972 = cljs.core.find.call(null, smap, p1__6967_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____6972)) {
        var e__6973 = temp__3695__auto____6972;
        return cljs.core.second.call(null, e__6973)
      }else {
        return p1__6967_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__6981 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__6974, seen) {
        while(true) {
          var vec__6975__6976 = p__6974;
          var f__6977 = cljs.core.nth.call(null, vec__6975__6976, 0, null);
          var xs__6978 = vec__6975__6976;
          var temp__3698__auto____6979 = cljs.core.seq.call(null, xs__6978);
          if(cljs.core.truth_(temp__3698__auto____6979)) {
            var s__6980 = temp__3698__auto____6979;
            if(cljs.core.contains_QMARK_.call(null, seen, f__6977)) {
              var G__6982 = cljs.core.rest.call(null, s__6980);
              var G__6983 = seen;
              p__6974 = G__6982;
              seen = G__6983;
              continue
            }else {
              return cljs.core.cons.call(null, f__6977, step.call(null, cljs.core.rest.call(null, s__6980), cljs.core.conj.call(null, seen, f__6977)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__6981.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__6984 = cljs.core.PersistentVector.fromArray([]);
  var s__6985 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__6985))) {
      var G__6986 = cljs.core.conj.call(null, ret__6984, cljs.core.first.call(null, s__6985));
      var G__6987 = cljs.core.next.call(null, s__6985);
      ret__6984 = G__6986;
      s__6985 = G__6987;
      continue
    }else {
      return cljs.core.seq.call(null, ret__6984)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3548__auto____6988 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3548__auto____6988) {
        return or__3548__auto____6988
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__6989 = x.lastIndexOf("/");
      if(i__6989 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__6989 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3548__auto____6990 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3548__auto____6990) {
      return or__3548__auto____6990
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__6991 = x.lastIndexOf("/");
    if(i__6991 > -1) {
      return cljs.core.subs.call(null, x, 2, i__6991)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__6994 = cljs.core.ObjMap.fromObject([], {});
  var ks__6995 = cljs.core.seq.call(null, keys);
  var vs__6996 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6997 = ks__6995;
      if(cljs.core.truth_(and__3546__auto____6997)) {
        return vs__6996
      }else {
        return and__3546__auto____6997
      }
    }())) {
      var G__6998 = cljs.core.assoc.call(null, map__6994, cljs.core.first.call(null, ks__6995), cljs.core.first.call(null, vs__6996));
      var G__6999 = cljs.core.next.call(null, ks__6995);
      var G__7000 = cljs.core.next.call(null, vs__6996);
      map__6994 = G__6998;
      ks__6995 = G__6999;
      vs__6996 = G__7000;
      continue
    }else {
      return map__6994
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__7003__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6992_SHARP_, p2__6993_SHARP_) {
        return max_key.call(null, k, p1__6992_SHARP_, p2__6993_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__7003 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7003__delegate.call(this, k, x, y, more)
    };
    G__7003.cljs$lang$maxFixedArity = 3;
    G__7003.cljs$lang$applyTo = function(arglist__7004) {
      var k = cljs.core.first(arglist__7004);
      var x = cljs.core.first(cljs.core.next(arglist__7004));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7004)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7004)));
      return G__7003__delegate(k, x, y, more)
    };
    G__7003.cljs$lang$arity$variadic = G__7003__delegate;
    return G__7003
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__7005__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__7001_SHARP_, p2__7002_SHARP_) {
        return min_key.call(null, k, p1__7001_SHARP_, p2__7002_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__7005 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7005__delegate.call(this, k, x, y, more)
    };
    G__7005.cljs$lang$maxFixedArity = 3;
    G__7005.cljs$lang$applyTo = function(arglist__7006) {
      var k = cljs.core.first(arglist__7006);
      var x = cljs.core.first(cljs.core.next(arglist__7006));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7006)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7006)));
      return G__7005__delegate(k, x, y, more)
    };
    G__7005.cljs$lang$arity$variadic = G__7005__delegate;
    return G__7005
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____7007 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____7007)) {
        var s__7008 = temp__3698__auto____7007;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__7008), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__7008)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7009 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7009)) {
      var s__7010 = temp__3698__auto____7009;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__7010)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__7010), take_while.call(null, pred, cljs.core.rest.call(null, s__7010)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__7011 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__7011.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__7012 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3698__auto____7013 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3698__auto____7013)) {
        var vec__7014__7015 = temp__3698__auto____7013;
        var e__7016 = cljs.core.nth.call(null, vec__7014__7015, 0, null);
        var s__7017 = vec__7014__7015;
        if(cljs.core.truth_(include__7012.call(null, e__7016))) {
          return s__7017
        }else {
          return cljs.core.next.call(null, s__7017)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__7012, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____7018 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3698__auto____7018)) {
      var vec__7019__7020 = temp__3698__auto____7018;
      var e__7021 = cljs.core.nth.call(null, vec__7019__7020, 0, null);
      var s__7022 = vec__7019__7020;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__7021)) ? s__7022 : cljs.core.next.call(null, s__7022))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__7023 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3698__auto____7024 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3698__auto____7024)) {
        var vec__7025__7026 = temp__3698__auto____7024;
        var e__7027 = cljs.core.nth.call(null, vec__7025__7026, 0, null);
        var s__7028 = vec__7025__7026;
        if(cljs.core.truth_(include__7023.call(null, e__7027))) {
          return s__7028
        }else {
          return cljs.core.next.call(null, s__7028)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__7023, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____7029 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3698__auto____7029)) {
      var vec__7030__7031 = temp__3698__auto____7029;
      var e__7032 = cljs.core.nth.call(null, vec__7030__7031, 0, null);
      var s__7033 = vec__7030__7031;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__7032)) ? s__7033 : cljs.core.next.call(null, s__7033))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16187486
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__7034 = this;
  var h__364__auto____7035 = this__7034.__hash;
  if(h__364__auto____7035 != null) {
    return h__364__auto____7035
  }else {
    var h__364__auto____7036 = cljs.core.hash_coll.call(null, rng);
    this__7034.__hash = h__364__auto____7036;
    return h__364__auto____7036
  }
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__7037 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__7038 = this;
  var this$__7039 = this;
  return cljs.core.pr_str.call(null, this$__7039)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__7040 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__7041 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__7042 = this;
  var comp__7043 = this__7042.step > 0 ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__7043.call(null, this__7042.start, this__7042.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__7044 = this;
  if(cljs.core.not.call(null, cljs.core._seq.call(null, rng))) {
    return 0
  }else {
    return Math["ceil"]((this__7044.end - this__7044.start) / this__7044.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__7045 = this;
  return this__7045.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__7046 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__7046.meta, this__7046.start + this__7046.step, this__7046.end, this__7046.step, null)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__7047 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__7048 = this;
  return new cljs.core.Range(meta, this__7048.start, this__7048.end, this__7048.step, this__7048.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__7049 = this;
  return this__7049.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__7050 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7050.start + n * this__7050.step
  }else {
    if(function() {
      var and__3546__auto____7051 = this__7050.start > this__7050.end;
      if(and__3546__auto____7051) {
        return this__7050.step === 0
      }else {
        return and__3546__auto____7051
      }
    }()) {
      return this__7050.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__7052 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__7052.start + n * this__7052.step
  }else {
    if(function() {
      var and__3546__auto____7053 = this__7052.start > this__7052.end;
      if(and__3546__auto____7053) {
        return this__7052.step === 0
      }else {
        return and__3546__auto____7053
      }
    }()) {
      return this__7052.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__7054 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__7054.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7055 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7055)) {
      var s__7056 = temp__3698__auto____7055;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__7056), take_nth.call(null, n, cljs.core.drop.call(null, n, s__7056)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____7058 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____7058)) {
      var s__7059 = temp__3698__auto____7058;
      var fst__7060 = cljs.core.first.call(null, s__7059);
      var fv__7061 = f.call(null, fst__7060);
      var run__7062 = cljs.core.cons.call(null, fst__7060, cljs.core.take_while.call(null, function(p1__7057_SHARP_) {
        return cljs.core._EQ_.call(null, fv__7061, f.call(null, p1__7057_SHARP_))
      }, cljs.core.next.call(null, s__7059)));
      return cljs.core.cons.call(null, run__7062, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__7062), s__7059))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {})), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____7073 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____7073)) {
        var s__7074 = temp__3695__auto____7073;
        return reductions.call(null, f, cljs.core.first.call(null, s__7074), cljs.core.rest.call(null, s__7074))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____7075 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____7075)) {
        var s__7076 = temp__3698__auto____7075;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__7076)), cljs.core.rest.call(null, s__7076))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__7078 = null;
      var G__7078__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__7078__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__7078__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__7078__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__7078__4 = function() {
        var G__7079__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__7079 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7079__delegate.call(this, x, y, z, args)
        };
        G__7079.cljs$lang$maxFixedArity = 3;
        G__7079.cljs$lang$applyTo = function(arglist__7080) {
          var x = cljs.core.first(arglist__7080);
          var y = cljs.core.first(cljs.core.next(arglist__7080));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7080)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7080)));
          return G__7079__delegate(x, y, z, args)
        };
        G__7079.cljs$lang$arity$variadic = G__7079__delegate;
        return G__7079
      }();
      G__7078 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7078__0.call(this);
          case 1:
            return G__7078__1.call(this, x);
          case 2:
            return G__7078__2.call(this, x, y);
          case 3:
            return G__7078__3.call(this, x, y, z);
          default:
            return G__7078__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7078.cljs$lang$maxFixedArity = 3;
      G__7078.cljs$lang$applyTo = G__7078__4.cljs$lang$applyTo;
      return G__7078
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__7081 = null;
      var G__7081__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__7081__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__7081__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__7081__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__7081__4 = function() {
        var G__7082__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__7082 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7082__delegate.call(this, x, y, z, args)
        };
        G__7082.cljs$lang$maxFixedArity = 3;
        G__7082.cljs$lang$applyTo = function(arglist__7083) {
          var x = cljs.core.first(arglist__7083);
          var y = cljs.core.first(cljs.core.next(arglist__7083));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7083)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7083)));
          return G__7082__delegate(x, y, z, args)
        };
        G__7082.cljs$lang$arity$variadic = G__7082__delegate;
        return G__7082
      }();
      G__7081 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7081__0.call(this);
          case 1:
            return G__7081__1.call(this, x);
          case 2:
            return G__7081__2.call(this, x, y);
          case 3:
            return G__7081__3.call(this, x, y, z);
          default:
            return G__7081__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7081.cljs$lang$maxFixedArity = 3;
      G__7081.cljs$lang$applyTo = G__7081__4.cljs$lang$applyTo;
      return G__7081
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__7084 = null;
      var G__7084__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__7084__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__7084__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__7084__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__7084__4 = function() {
        var G__7085__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__7085 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7085__delegate.call(this, x, y, z, args)
        };
        G__7085.cljs$lang$maxFixedArity = 3;
        G__7085.cljs$lang$applyTo = function(arglist__7086) {
          var x = cljs.core.first(arglist__7086);
          var y = cljs.core.first(cljs.core.next(arglist__7086));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7086)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7086)));
          return G__7085__delegate(x, y, z, args)
        };
        G__7085.cljs$lang$arity$variadic = G__7085__delegate;
        return G__7085
      }();
      G__7084 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7084__0.call(this);
          case 1:
            return G__7084__1.call(this, x);
          case 2:
            return G__7084__2.call(this, x, y);
          case 3:
            return G__7084__3.call(this, x, y, z);
          default:
            return G__7084__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7084.cljs$lang$maxFixedArity = 3;
      G__7084.cljs$lang$applyTo = G__7084__4.cljs$lang$applyTo;
      return G__7084
    }()
  };
  var juxt__4 = function() {
    var G__7087__delegate = function(f, g, h, fs) {
      var fs__7077 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__7088 = null;
        var G__7088__0 = function() {
          return cljs.core.reduce.call(null, function(p1__7063_SHARP_, p2__7064_SHARP_) {
            return cljs.core.conj.call(null, p1__7063_SHARP_, p2__7064_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__7077)
        };
        var G__7088__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__7065_SHARP_, p2__7066_SHARP_) {
            return cljs.core.conj.call(null, p1__7065_SHARP_, p2__7066_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__7077)
        };
        var G__7088__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__7067_SHARP_, p2__7068_SHARP_) {
            return cljs.core.conj.call(null, p1__7067_SHARP_, p2__7068_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__7077)
        };
        var G__7088__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__7069_SHARP_, p2__7070_SHARP_) {
            return cljs.core.conj.call(null, p1__7069_SHARP_, p2__7070_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__7077)
        };
        var G__7088__4 = function() {
          var G__7089__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__7071_SHARP_, p2__7072_SHARP_) {
              return cljs.core.conj.call(null, p1__7071_SHARP_, cljs.core.apply.call(null, p2__7072_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__7077)
          };
          var G__7089 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__7089__delegate.call(this, x, y, z, args)
          };
          G__7089.cljs$lang$maxFixedArity = 3;
          G__7089.cljs$lang$applyTo = function(arglist__7090) {
            var x = cljs.core.first(arglist__7090);
            var y = cljs.core.first(cljs.core.next(arglist__7090));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7090)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7090)));
            return G__7089__delegate(x, y, z, args)
          };
          G__7089.cljs$lang$arity$variadic = G__7089__delegate;
          return G__7089
        }();
        G__7088 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__7088__0.call(this);
            case 1:
              return G__7088__1.call(this, x);
            case 2:
              return G__7088__2.call(this, x, y);
            case 3:
              return G__7088__3.call(this, x, y, z);
            default:
              return G__7088__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__7088.cljs$lang$maxFixedArity = 3;
        G__7088.cljs$lang$applyTo = G__7088__4.cljs$lang$applyTo;
        return G__7088
      }()
    };
    var G__7087 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7087__delegate.call(this, f, g, h, fs)
    };
    G__7087.cljs$lang$maxFixedArity = 3;
    G__7087.cljs$lang$applyTo = function(arglist__7091) {
      var f = cljs.core.first(arglist__7091);
      var g = cljs.core.first(cljs.core.next(arglist__7091));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7091)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7091)));
      return G__7087__delegate(f, g, h, fs)
    };
    G__7087.cljs$lang$arity$variadic = G__7087__delegate;
    return G__7087
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__7093 = cljs.core.next.call(null, coll);
        coll = G__7093;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____7092 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____7092)) {
          return n > 0
        }else {
          return and__3546__auto____7092
        }
      }())) {
        var G__7094 = n - 1;
        var G__7095 = cljs.core.next.call(null, coll);
        n = G__7094;
        coll = G__7095;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__7096 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__7096), s)) {
    if(cljs.core.count.call(null, matches__7096) === 1) {
      return cljs.core.first.call(null, matches__7096)
    }else {
      return cljs.core.vec.call(null, matches__7096)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__7097 = re.exec(s);
  if(matches__7097 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__7097) === 1) {
      return cljs.core.first.call(null, matches__7097)
    }else {
      return cljs.core.vec.call(null, matches__7097)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__7098 = cljs.core.re_find.call(null, re, s);
  var match_idx__7099 = s.search(re);
  var match_str__7100 = cljs.core.coll_QMARK_.call(null, match_data__7098) ? cljs.core.first.call(null, match_data__7098) : match_data__7098;
  var post_match__7101 = cljs.core.subs.call(null, s, match_idx__7099 + cljs.core.count.call(null, match_str__7100));
  if(cljs.core.truth_(match_data__7098)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__7098, re_seq.call(null, re, post_match__7101))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__7103__7104 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___7105 = cljs.core.nth.call(null, vec__7103__7104, 0, null);
  var flags__7106 = cljs.core.nth.call(null, vec__7103__7104, 1, null);
  var pattern__7107 = cljs.core.nth.call(null, vec__7103__7104, 2, null);
  return new RegExp(pattern__7107, flags__7106)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__7102_SHARP_) {
    return print_one.call(null, p1__7102_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____7108 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____7108)) {
            var and__3546__auto____7112 = function() {
              var G__7109__7110 = obj;
              if(G__7109__7110 != null) {
                if(function() {
                  var or__3548__auto____7111 = G__7109__7110.cljs$lang$protocol_mask$partition0$ & 65536;
                  if(or__3548__auto____7111) {
                    return or__3548__auto____7111
                  }else {
                    return G__7109__7110.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__7109__7110.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7109__7110)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7109__7110)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____7112)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____7112
            }
          }else {
            return and__3546__auto____7108
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var and__3546__auto____7113 = obj != null;
          if(and__3546__auto____7113) {
            return obj.cljs$lang$type
          }else {
            return and__3546__auto____7113
          }
        }()) ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__7114__7115 = obj;
          if(G__7114__7115 != null) {
            if(function() {
              var or__3548__auto____7116 = G__7114__7115.cljs$lang$protocol_mask$partition0$ & 268435456;
              if(or__3548__auto____7116) {
                return or__3548__auto____7116
              }else {
                return G__7114__7115.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__7114__7115.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7114__7115)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__7114__7115)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__7117 = cljs.core.first.call(null, objs);
  var sb__7118 = new goog.string.StringBuffer;
  var G__7119__7120 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7119__7120)) {
    var obj__7121 = cljs.core.first.call(null, G__7119__7120);
    var G__7119__7122 = G__7119__7120;
    while(true) {
      if(obj__7121 === first_obj__7117) {
      }else {
        sb__7118.append(" ")
      }
      var G__7123__7124 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7121, opts));
      if(cljs.core.truth_(G__7123__7124)) {
        var string__7125 = cljs.core.first.call(null, G__7123__7124);
        var G__7123__7126 = G__7123__7124;
        while(true) {
          sb__7118.append(string__7125);
          var temp__3698__auto____7127 = cljs.core.next.call(null, G__7123__7126);
          if(cljs.core.truth_(temp__3698__auto____7127)) {
            var G__7123__7128 = temp__3698__auto____7127;
            var G__7131 = cljs.core.first.call(null, G__7123__7128);
            var G__7132 = G__7123__7128;
            string__7125 = G__7131;
            G__7123__7126 = G__7132;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7129 = cljs.core.next.call(null, G__7119__7122);
      if(cljs.core.truth_(temp__3698__auto____7129)) {
        var G__7119__7130 = temp__3698__auto____7129;
        var G__7133 = cljs.core.first.call(null, G__7119__7130);
        var G__7134 = G__7119__7130;
        obj__7121 = G__7133;
        G__7119__7122 = G__7134;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__7118
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__7135 = cljs.core.pr_sb.call(null, objs, opts);
  sb__7135.append("\n");
  return[cljs.core.str(sb__7135)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__7136 = cljs.core.first.call(null, objs);
  var G__7137__7138 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__7137__7138)) {
    var obj__7139 = cljs.core.first.call(null, G__7137__7138);
    var G__7137__7140 = G__7137__7138;
    while(true) {
      if(obj__7139 === first_obj__7136) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__7141__7142 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__7139, opts));
      if(cljs.core.truth_(G__7141__7142)) {
        var string__7143 = cljs.core.first.call(null, G__7141__7142);
        var G__7141__7144 = G__7141__7142;
        while(true) {
          cljs.core.string_print.call(null, string__7143);
          var temp__3698__auto____7145 = cljs.core.next.call(null, G__7141__7144);
          if(cljs.core.truth_(temp__3698__auto____7145)) {
            var G__7141__7146 = temp__3698__auto____7145;
            var G__7149 = cljs.core.first.call(null, G__7141__7146);
            var G__7150 = G__7141__7146;
            string__7143 = G__7149;
            G__7141__7144 = G__7150;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____7147 = cljs.core.next.call(null, G__7137__7140);
      if(cljs.core.truth_(temp__3698__auto____7147)) {
        var G__7137__7148 = temp__3698__auto____7147;
        var G__7151 = cljs.core.first.call(null, G__7137__7148);
        var G__7152 = G__7137__7148;
        obj__7139 = G__7151;
        G__7137__7140 = G__7152;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__7153) {
    var objs = cljs.core.seq(arglist__7153);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__7154) {
    var objs = cljs.core.seq(arglist__7154);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__7155) {
    var objs = cljs.core.seq(arglist__7155);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__7156) {
    var objs = cljs.core.seq(arglist__7156);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__7157) {
    var objs = cljs.core.seq(arglist__7157);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__7158) {
    var objs = cljs.core.seq(arglist__7158);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__7159) {
    var objs = cljs.core.seq(arglist__7159);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__7160) {
    var objs = cljs.core.seq(arglist__7160);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7161 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7161, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7162 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7162, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7163 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7163, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3698__auto____7164 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____7164)) {
        var nspc__7165 = temp__3698__auto____7164;
        return[cljs.core.str(nspc__7165), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3698__auto____7166 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____7166)) {
          var nspc__7167 = temp__3698__auto____7166;
          return[cljs.core.str(nspc__7167), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7168 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7168, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__7169 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__7169, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1345404928
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7170 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__7171 = this;
  var G__7172__7173 = cljs.core.seq.call(null, this__7171.watches);
  if(cljs.core.truth_(G__7172__7173)) {
    var G__7175__7177 = cljs.core.first.call(null, G__7172__7173);
    var vec__7176__7178 = G__7175__7177;
    var key__7179 = cljs.core.nth.call(null, vec__7176__7178, 0, null);
    var f__7180 = cljs.core.nth.call(null, vec__7176__7178, 1, null);
    var G__7172__7181 = G__7172__7173;
    var G__7175__7182 = G__7175__7177;
    var G__7172__7183 = G__7172__7181;
    while(true) {
      var vec__7184__7185 = G__7175__7182;
      var key__7186 = cljs.core.nth.call(null, vec__7184__7185, 0, null);
      var f__7187 = cljs.core.nth.call(null, vec__7184__7185, 1, null);
      var G__7172__7188 = G__7172__7183;
      f__7187.call(null, key__7186, this$, oldval, newval);
      var temp__3698__auto____7189 = cljs.core.next.call(null, G__7172__7188);
      if(cljs.core.truth_(temp__3698__auto____7189)) {
        var G__7172__7190 = temp__3698__auto____7189;
        var G__7197 = cljs.core.first.call(null, G__7172__7190);
        var G__7198 = G__7172__7190;
        G__7175__7182 = G__7197;
        G__7172__7183 = G__7198;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__7191 = this;
  return this$.watches = cljs.core.assoc.call(null, this__7191.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__7192 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__7192.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__7193 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__7193.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__7194 = this;
  return this__7194.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7195 = this;
  return this__7195.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__7196 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__7205__delegate = function(x, p__7199) {
      var map__7200__7201 = p__7199;
      var map__7200__7202 = cljs.core.seq_QMARK_.call(null, map__7200__7201) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7200__7201) : map__7200__7201;
      var validator__7203 = cljs.core.get.call(null, map__7200__7202, "\ufdd0'validator");
      var meta__7204 = cljs.core.get.call(null, map__7200__7202, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__7204, validator__7203, null)
    };
    var G__7205 = function(x, var_args) {
      var p__7199 = null;
      if(goog.isDef(var_args)) {
        p__7199 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7205__delegate.call(this, x, p__7199)
    };
    G__7205.cljs$lang$maxFixedArity = 1;
    G__7205.cljs$lang$applyTo = function(arglist__7206) {
      var x = cljs.core.first(arglist__7206);
      var p__7199 = cljs.core.rest(arglist__7206);
      return G__7205__delegate(x, p__7199)
    };
    G__7205.cljs$lang$arity$variadic = G__7205__delegate;
    return G__7205
  }();
  atom = function(x, var_args) {
    var p__7199 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____7207 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____7207)) {
    var validate__7208 = temp__3698__auto____7207;
    if(cljs.core.truth_(validate__7208.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 5917))))].join(""));
    }
  }else {
  }
  var old_value__7209 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__7209, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__7210__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__7210 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__7210__delegate.call(this, a, f, x, y, z, more)
    };
    G__7210.cljs$lang$maxFixedArity = 5;
    G__7210.cljs$lang$applyTo = function(arglist__7211) {
      var a = cljs.core.first(arglist__7211);
      var f = cljs.core.first(cljs.core.next(arglist__7211));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7211)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7211))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7211)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7211)))));
      return G__7210__delegate(a, f, x, y, z, more)
    };
    G__7210.cljs$lang$arity$variadic = G__7210__delegate;
    return G__7210
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__7212) {
    var iref = cljs.core.first(arglist__7212);
    var f = cljs.core.first(cljs.core.next(arglist__7212));
    var args = cljs.core.rest(cljs.core.next(arglist__7212));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 536887296
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__7213 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__7213.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7214 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__7214.state, function(p__7215) {
    var curr_state__7216 = p__7215;
    var curr_state__7217 = cljs.core.seq_QMARK_.call(null, curr_state__7216) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__7216) : curr_state__7216;
    var done__7218 = cljs.core.get.call(null, curr_state__7217, "\ufdd0'done");
    if(cljs.core.truth_(done__7218)) {
      return curr_state__7217
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__7214.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__7219__7220 = options;
    var map__7219__7221 = cljs.core.seq_QMARK_.call(null, map__7219__7220) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7219__7220) : map__7219__7220;
    var keywordize_keys__7222 = cljs.core.get.call(null, map__7219__7221, "\ufdd0'keywordize-keys");
    var keyfn__7223 = cljs.core.truth_(keywordize_keys__7222) ? cljs.core.keyword : cljs.core.str;
    var f__7229 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__625__auto____7228 = function iter__7224(s__7225) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__7225__7226 = s__7225;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__7225__7226))) {
                        var k__7227 = cljs.core.first.call(null, s__7225__7226);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__7223.call(null, k__7227), thisfn.call(null, x[k__7227])]), iter__7224.call(null, cljs.core.rest.call(null, s__7225__7226)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__625__auto____7228.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__7229.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__7230) {
    var x = cljs.core.first(arglist__7230);
    var options = cljs.core.rest(arglist__7230);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__7231 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__7235__delegate = function(args) {
      var temp__3695__auto____7232 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__7231), args);
      if(cljs.core.truth_(temp__3695__auto____7232)) {
        var v__7233 = temp__3695__auto____7232;
        return v__7233
      }else {
        var ret__7234 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__7231, cljs.core.assoc, args, ret__7234);
        return ret__7234
      }
    };
    var G__7235 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7235__delegate.call(this, args)
    };
    G__7235.cljs$lang$maxFixedArity = 0;
    G__7235.cljs$lang$applyTo = function(arglist__7236) {
      var args = cljs.core.seq(arglist__7236);
      return G__7235__delegate(args)
    };
    G__7235.cljs$lang$arity$variadic = G__7235__delegate;
    return G__7235
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__7237 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__7237)) {
        var G__7238 = ret__7237;
        f = G__7238;
        continue
      }else {
        return ret__7237
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__7239__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__7239 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7239__delegate.call(this, f, args)
    };
    G__7239.cljs$lang$maxFixedArity = 1;
    G__7239.cljs$lang$applyTo = function(arglist__7240) {
      var f = cljs.core.first(arglist__7240);
      var args = cljs.core.rest(arglist__7240);
      return G__7239__delegate(f, args)
    };
    G__7239.cljs$lang$arity$variadic = G__7239__delegate;
    return G__7239
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__7241 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__7241, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__7241, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3548__auto____7242 = cljs.core._EQ_.call(null, child, parent);
    if(or__3548__auto____7242) {
      return or__3548__auto____7242
    }else {
      var or__3548__auto____7243 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(or__3548__auto____7243) {
        return or__3548__auto____7243
      }else {
        var and__3546__auto____7244 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3546__auto____7244) {
          var and__3546__auto____7245 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3546__auto____7245) {
            var and__3546__auto____7246 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3546__auto____7246) {
              var ret__7247 = true;
              var i__7248 = 0;
              while(true) {
                if(function() {
                  var or__3548__auto____7249 = cljs.core.not.call(null, ret__7247);
                  if(or__3548__auto____7249) {
                    return or__3548__auto____7249
                  }else {
                    return i__7248 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__7247
                }else {
                  var G__7250 = isa_QMARK_.call(null, h, child.call(null, i__7248), parent.call(null, i__7248));
                  var G__7251 = i__7248 + 1;
                  ret__7247 = G__7250;
                  i__7248 = G__7251;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____7246
            }
          }else {
            return and__3546__auto____7245
          }
        }else {
          return and__3546__auto____7244
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6201))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6205))))].join(""));
    }
    var tp__7255 = "\ufdd0'parents".call(null, h);
    var td__7256 = "\ufdd0'descendants".call(null, h);
    var ta__7257 = "\ufdd0'ancestors".call(null, h);
    var tf__7258 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____7259 = cljs.core.contains_QMARK_.call(null, tp__7255.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__7257.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__7257.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__7255, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__7258.call(null, "\ufdd0'ancestors".call(null, h), tag, td__7256, parent, ta__7257), "\ufdd0'descendants":tf__7258.call(null, "\ufdd0'descendants".call(null, h), parent, ta__7257, tag, td__7256)})
    }();
    if(cljs.core.truth_(or__3548__auto____7259)) {
      return or__3548__auto____7259
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__7260 = "\ufdd0'parents".call(null, h);
    var childsParents__7261 = cljs.core.truth_(parentMap__7260.call(null, tag)) ? cljs.core.disj.call(null, parentMap__7260.call(null, tag), parent) : cljs.core.set([]);
    var newParents__7262 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__7261)) ? cljs.core.assoc.call(null, parentMap__7260, tag, childsParents__7261) : cljs.core.dissoc.call(null, parentMap__7260, tag);
    var deriv_seq__7263 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__7252_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__7252_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__7252_SHARP_), cljs.core.second.call(null, p1__7252_SHARP_)))
    }, cljs.core.seq.call(null, newParents__7262)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__7260.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__7253_SHARP_, p2__7254_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__7253_SHARP_, p2__7254_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__7263))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__7264 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____7266 = cljs.core.truth_(function() {
    var and__3546__auto____7265 = xprefs__7264;
    if(cljs.core.truth_(and__3546__auto____7265)) {
      return xprefs__7264.call(null, y)
    }else {
      return and__3546__auto____7265
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____7266)) {
    return or__3548__auto____7266
  }else {
    var or__3548__auto____7268 = function() {
      var ps__7267 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__7267) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__7267), prefer_table))) {
          }else {
          }
          var G__7271 = cljs.core.rest.call(null, ps__7267);
          ps__7267 = G__7271;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7268)) {
      return or__3548__auto____7268
    }else {
      var or__3548__auto____7270 = function() {
        var ps__7269 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__7269) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__7269), y, prefer_table))) {
            }else {
            }
            var G__7272 = cljs.core.rest.call(null, ps__7269);
            ps__7269 = G__7272;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____7270)) {
        return or__3548__auto____7270
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____7273 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____7273)) {
    return or__3548__auto____7273
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__7282 = cljs.core.reduce.call(null, function(be, p__7274) {
    var vec__7275__7276 = p__7274;
    var k__7277 = cljs.core.nth.call(null, vec__7275__7276, 0, null);
    var ___7278 = cljs.core.nth.call(null, vec__7275__7276, 1, null);
    var e__7279 = vec__7275__7276;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__7277)) {
      var be2__7281 = cljs.core.truth_(function() {
        var or__3548__auto____7280 = be == null;
        if(or__3548__auto____7280) {
          return or__3548__auto____7280
        }else {
          return cljs.core.dominates.call(null, k__7277, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__7279 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__7281), k__7277, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__7277), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__7281)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__7281
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__7282)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__7282));
      return cljs.core.second.call(null, best_entry__7282)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
void 0;
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3546__auto____7283 = mf;
    if(and__3546__auto____7283) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3546__auto____7283
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7284 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7284) {
        return or__3548__auto____7284
      }else {
        var or__3548__auto____7285 = cljs.core._reset["_"];
        if(or__3548__auto____7285) {
          return or__3548__auto____7285
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3546__auto____7286 = mf;
    if(and__3546__auto____7286) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3546__auto____7286
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____7287 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7287) {
        return or__3548__auto____7287
      }else {
        var or__3548__auto____7288 = cljs.core._add_method["_"];
        if(or__3548__auto____7288) {
          return or__3548__auto____7288
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7289 = mf;
    if(and__3546__auto____7289) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3546__auto____7289
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7290 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7290) {
        return or__3548__auto____7290
      }else {
        var or__3548__auto____7291 = cljs.core._remove_method["_"];
        if(or__3548__auto____7291) {
          return or__3548__auto____7291
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3546__auto____7292 = mf;
    if(and__3546__auto____7292) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3546__auto____7292
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____7293 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7293) {
        return or__3548__auto____7293
      }else {
        var or__3548__auto____7294 = cljs.core._prefer_method["_"];
        if(or__3548__auto____7294) {
          return or__3548__auto____7294
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7295 = mf;
    if(and__3546__auto____7295) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3546__auto____7295
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7296 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7296) {
        return or__3548__auto____7296
      }else {
        var or__3548__auto____7297 = cljs.core._get_method["_"];
        if(or__3548__auto____7297) {
          return or__3548__auto____7297
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3546__auto____7298 = mf;
    if(and__3546__auto____7298) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3546__auto____7298
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7299 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7299) {
        return or__3548__auto____7299
      }else {
        var or__3548__auto____7300 = cljs.core._methods["_"];
        if(or__3548__auto____7300) {
          return or__3548__auto____7300
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3546__auto____7301 = mf;
    if(and__3546__auto____7301) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3546__auto____7301
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7302 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7302) {
        return or__3548__auto____7302
      }else {
        var or__3548__auto____7303 = cljs.core._prefers["_"];
        if(or__3548__auto____7303) {
          return or__3548__auto____7303
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3546__auto____7304 = mf;
    if(and__3546__auto____7304) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3546__auto____7304
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    return function() {
      var or__3548__auto____7305 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7305) {
        return or__3548__auto____7305
      }else {
        var or__3548__auto____7306 = cljs.core._dispatch["_"];
        if(or__3548__auto____7306) {
          return or__3548__auto____7306
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
void 0;
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__7307 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__7308 = cljs.core._get_method.call(null, mf, dispatch_val__7307);
  if(cljs.core.truth_(target_fn__7308)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__7307)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__7308, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 32
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7309 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__7310 = this;
  cljs.core.swap_BANG_.call(null, this__7310.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7310.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7310.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7310.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__7311 = this;
  cljs.core.swap_BANG_.call(null, this__7311.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__7311.method_cache, this__7311.method_table, this__7311.cached_hierarchy, this__7311.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__7312 = this;
  cljs.core.swap_BANG_.call(null, this__7312.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__7312.method_cache, this__7312.method_table, this__7312.cached_hierarchy, this__7312.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__7313 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__7313.cached_hierarchy), cljs.core.deref.call(null, this__7313.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__7313.method_cache, this__7313.method_table, this__7313.cached_hierarchy, this__7313.hierarchy)
  }
  var temp__3695__auto____7314 = cljs.core.deref.call(null, this__7313.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____7314)) {
    var target_fn__7315 = temp__3695__auto____7314;
    return target_fn__7315
  }else {
    var temp__3695__auto____7316 = cljs.core.find_and_cache_best_method.call(null, this__7313.name, dispatch_val, this__7313.hierarchy, this__7313.method_table, this__7313.prefer_table, this__7313.method_cache, this__7313.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____7316)) {
      var target_fn__7317 = temp__3695__auto____7316;
      return target_fn__7317
    }else {
      return cljs.core.deref.call(null, this__7313.method_table).call(null, this__7313.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__7318 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__7318.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__7318.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__7318.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__7318.method_cache, this__7318.method_table, this__7318.cached_hierarchy, this__7318.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__7319 = this;
  return cljs.core.deref.call(null, this__7319.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__7320 = this;
  return cljs.core.deref.call(null, this__7320.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__7321 = this;
  return cljs.core.do_dispatch.call(null, mf, this__7321.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__7322__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__7322 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__7322__delegate.call(this, _, args)
  };
  G__7322.cljs$lang$maxFixedArity = 1;
  G__7322.cljs$lang$applyTo = function(arglist__7323) {
    var _ = cljs.core.first(arglist__7323);
    var args = cljs.core.rest(arglist__7323);
    return G__7322__delegate(_, args)
  };
  G__7322.cljs$lang$arity$variadic = G__7322__delegate;
  return G__7322
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
void 0;
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(function() {
    var and__3546__auto____7485 = reader;
    if(and__3546__auto____7485) {
      return reader.cljs$reader$PushbackReader$read_char$arity$1
    }else {
      return and__3546__auto____7485
    }
  }()) {
    return reader.cljs$reader$PushbackReader$read_char$arity$1(reader)
  }else {
    return function() {
      var or__3548__auto____7486 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7486) {
        return or__3548__auto____7486
      }else {
        var or__3548__auto____7487 = cljs.reader.read_char["_"];
        if(or__3548__auto____7487) {
          return or__3548__auto____7487
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(function() {
    var and__3546__auto____7488 = reader;
    if(and__3546__auto____7488) {
      return reader.cljs$reader$PushbackReader$unread$arity$2
    }else {
      return and__3546__auto____7488
    }
  }()) {
    return reader.cljs$reader$PushbackReader$unread$arity$2(reader, ch)
  }else {
    return function() {
      var or__3548__auto____7489 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7489) {
        return or__3548__auto____7489
      }else {
        var or__3548__auto____7490 = cljs.reader.unread["_"];
        if(or__3548__auto____7490) {
          return or__3548__auto____7490
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
void 0;
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = function(reader) {
  var this__7491 = this;
  if(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__7491.buffer_atom))) {
    var idx__7492 = cljs.core.deref.call(null, this__7491.index_atom);
    cljs.core.swap_BANG_.call(null, this__7491.index_atom, cljs.core.inc);
    return this__7491.s[idx__7492]
  }else {
    var buf__7493 = cljs.core.deref.call(null, this__7491.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__7491.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__7493)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = function(reader, ch) {
  var this__7494 = this;
  return cljs.core.swap_BANG_.call(null, this__7494.buffer_atom, function(p1__7484_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__7484_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____7495 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____7495)) {
    return or__3548__auto____7495
  }else {
    return"," === ch
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return";" === ch
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____7496 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(or__3548__auto____7496) {
    return or__3548__auto____7496
  }else {
    var and__3546__auto____7498 = function() {
      var or__3548__auto____7497 = "+" === initch;
      if(or__3548__auto____7497) {
        return or__3548__auto____7497
      }else {
        return"-" === initch
      }
    }();
    if(cljs.core.truth_(and__3546__auto____7498)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__7499 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__7499);
        return next_ch__7499
      }())
    }else {
      return and__3546__auto____7498
    }
  }
};
void 0;
void 0;
void 0;
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__7500) {
    var rdr = cljs.core.first(arglist__7500);
    var msg = cljs.core.rest(arglist__7500);
    return reader_error__delegate(rdr, msg)
  };
  reader_error.cljs$lang$arity$variadic = reader_error__delegate;
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____7501 = ch != "#";
  if(and__3546__auto____7501) {
    var and__3546__auto____7502 = ch != "'";
    if(and__3546__auto____7502) {
      var and__3546__auto____7503 = ch != ":";
      if(and__3546__auto____7503) {
        return cljs.reader.macros.call(null, ch)
      }else {
        return and__3546__auto____7503
      }
    }else {
      return and__3546__auto____7502
    }
  }else {
    return and__3546__auto____7501
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__7504 = new goog.string.StringBuffer(initch);
  var ch__7505 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(function() {
      var or__3548__auto____7506 = ch__7505 == null;
      if(or__3548__auto____7506) {
        return or__3548__auto____7506
      }else {
        var or__3548__auto____7507 = cljs.reader.whitespace_QMARK_.call(null, ch__7505);
        if(or__3548__auto____7507) {
          return or__3548__auto____7507
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__7505)
        }
      }
    }()) {
      cljs.reader.unread.call(null, rdr, ch__7505);
      return sb__7504.toString()
    }else {
      var G__7508 = function() {
        sb__7504.append(ch__7505);
        return sb__7504
      }();
      var G__7509 = cljs.reader.read_char.call(null, rdr);
      sb__7504 = G__7508;
      ch__7505 = G__7509;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__7510 = cljs.reader.read_char.call(null, reader);
    if(function() {
      var or__3548__auto____7511 = ch__7510 === "n";
      if(or__3548__auto____7511) {
        return or__3548__auto____7511
      }else {
        var or__3548__auto____7512 = ch__7510 === "r";
        if(or__3548__auto____7512) {
          return or__3548__auto____7512
        }else {
          return ch__7510 == null
        }
      }
    }()) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.re_find_STAR_ = function re_find_STAR_(re, s) {
  var matches__7513 = re.exec(s);
  if(matches__7513 != null) {
    if(matches__7513.length === 1) {
      return matches__7513[0]
    }else {
      return matches__7513
    }
  }else {
    return null
  }
};
cljs.reader.match_int = function match_int(s) {
  var groups__7514 = cljs.reader.re_find_STAR_.call(null, cljs.reader.int_pattern, s);
  var group3__7515 = groups__7514[2];
  if(!function() {
    var or__3548__auto____7516 = group3__7515 == null;
    if(or__3548__auto____7516) {
      return or__3548__auto____7516
    }else {
      return group3__7515.length < 1
    }
  }()) {
    return 0
  }else {
    var negate__7517 = "-" === groups__7514[1] ? -1 : 1;
    var a__7518 = cljs.core.truth_(groups__7514[3]) ? [groups__7514[3], 10] : cljs.core.truth_(groups__7514[4]) ? [groups__7514[4], 16] : cljs.core.truth_(groups__7514[5]) ? [groups__7514[5], 8] : cljs.core.truth_(groups__7514[7]) ? [groups__7514[7], parseInt(groups__7514[7])] : "\ufdd0'default" ? [null, null] : null;
    var n__7519 = a__7518[0];
    var radix__7520 = a__7518[1];
    if(n__7519 == null) {
      return null
    }else {
      return negate__7517 * parseInt(n__7519, radix__7520)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__7521 = cljs.reader.re_find_STAR_.call(null, cljs.reader.ratio_pattern, s);
  var numinator__7522 = groups__7521[1];
  var denominator__7523 = groups__7521[2];
  return parseInt(numinator__7522) / parseInt(denominator__7523)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat(s)
};
cljs.reader.re_matches_STAR_ = function re_matches_STAR_(re, s) {
  var matches__7524 = re.exec(s);
  if(function() {
    var and__3546__auto____7525 = matches__7524 != null;
    if(and__3546__auto____7525) {
      return matches__7524[0] === s
    }else {
      return and__3546__auto____7525
    }
  }()) {
    if(matches__7524.length === 1) {
      return matches__7524[0]
    }else {
      return matches__7524
    }
  }else {
    return null
  }
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = function escape_char_map(c) {
  if("f" === c) {
    return"\u000c"
  }else {
    if("b" === c) {
      return"\u0008"
    }else {
      if('"' === c) {
        return'"'
      }else {
        if("\\" === c) {
          return"\\"
        }else {
          if("n" === c) {
            return"\n"
          }else {
            if("r" === c) {
              return"\r"
            }else {
              if("t" === c) {
                return"\t"
              }else {
                if("\ufdd0'else") {
                  return null
                }else {
                  return null
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__7526 = cljs.reader.read_char.call(null, reader);
  var mapresult__7527 = cljs.reader.escape_char_map.call(null, ch__7526);
  if(cljs.core.truth_(mapresult__7527)) {
    return mapresult__7527
  }else {
    if(function() {
      var or__3548__auto____7528 = "u" === ch__7526;
      if(or__3548__auto____7528) {
        return or__3548__auto____7528
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__7526)
      }
    }()) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__7526)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape character: \\", ch__7526)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__7529 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__7529))) {
      var G__7530 = cljs.reader.read_char.call(null, rdr);
      ch__7529 = G__7530;
      continue
    }else {
      return ch__7529
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__7531 = cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([]));
  while(true) {
    var ch__7532 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__7532)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(delim === ch__7532) {
      return cljs.core.persistent_BANG_.call(null, a__7531)
    }else {
      var temp__3695__auto____7533 = cljs.reader.macros.call(null, ch__7532);
      if(cljs.core.truth_(temp__3695__auto____7533)) {
        var macrofn__7534 = temp__3695__auto____7533;
        var mret__7535 = macrofn__7534.call(null, rdr, ch__7532);
        var G__7537 = mret__7535 === rdr ? a__7531 : cljs.core.conj_BANG_.call(null, a__7531, mret__7535);
        a__7531 = G__7537;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__7532);
        var o__7536 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__7538 = o__7536 === rdr ? a__7531 : cljs.core.conj_BANG_.call(null, a__7531, o__7536);
        a__7531 = G__7538;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
void 0;
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__7539 = cljs.reader.read_char.call(null, rdr);
  var dm__7540 = cljs.reader.dispatch_macros.call(null, ch__7539);
  if(cljs.core.truth_(dm__7540)) {
    return dm__7540.call(null, rdr, _)
  }else {
    var temp__3695__auto____7541 = cljs.reader.maybe_read_tagged_type.call(null, rdr, ch__7539);
    if(cljs.core.truth_(temp__3695__auto____7541)) {
      var obj__7542 = temp__3695__auto____7541;
      return obj__7542
    }else {
      return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__7539)
    }
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__7543 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__7543))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__7543)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__7544 = new goog.string.StringBuffer(initch);
  var ch__7545 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7546 = ch__7545 == null;
      if(or__3548__auto____7546) {
        return or__3548__auto____7546
      }else {
        var or__3548__auto____7547 = cljs.reader.whitespace_QMARK_.call(null, ch__7545);
        if(or__3548__auto____7547) {
          return or__3548__auto____7547
        }else {
          return cljs.reader.macros.call(null, ch__7545)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__7545);
      var s__7548 = buffer__7544.toString();
      var or__3548__auto____7549 = cljs.reader.match_number.call(null, s__7548);
      if(cljs.core.truth_(or__3548__auto____7549)) {
        return or__3548__auto____7549
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__7548, "]")
      }
    }else {
      var G__7550 = function() {
        buffer__7544.append(ch__7545);
        return buffer__7544
      }();
      var G__7551 = cljs.reader.read_char.call(null, reader);
      buffer__7544 = G__7550;
      ch__7545 = G__7551;
      continue
    }
    break
  }
};
cljs.reader.read_string_STAR_ = function read_string_STAR_(reader, _) {
  var buffer__7552 = new goog.string.StringBuffer;
  var ch__7553 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(ch__7553 == null) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if("\\" === ch__7553) {
        var G__7554 = function() {
          buffer__7552.append(cljs.reader.escape_char.call(null, buffer__7552, reader));
          return buffer__7552
        }();
        var G__7555 = cljs.reader.read_char.call(null, reader);
        buffer__7552 = G__7554;
        ch__7553 = G__7555;
        continue
      }else {
        if('"' === ch__7553) {
          return buffer__7552.toString()
        }else {
          if("\ufdd0'default") {
            var G__7556 = function() {
              buffer__7552.append(ch__7553);
              return buffer__7552
            }();
            var G__7557 = cljs.reader.read_char.call(null, reader);
            buffer__7552 = G__7556;
            ch__7553 = G__7557;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__7558 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__7558, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__7558, 0, token__7558.indexOf("/")), cljs.core.subs.call(null, token__7558, token__7558.indexOf("/") + 1, token__7558.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__7558, cljs.core.symbol.call(null, token__7558))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__7559 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var a__7560 = cljs.reader.re_matches_STAR_.call(null, cljs.reader.symbol_pattern, token__7559);
  var token__7561 = a__7560[0];
  var ns__7562 = a__7560[1];
  var name__7563 = a__7560[2];
  if(cljs.core.truth_(function() {
    var or__3548__auto____7565 = function() {
      var and__3546__auto____7564 = !(void 0 === ns__7562);
      if(and__3546__auto____7564) {
        return ns__7562.substring(ns__7562.length - 2, ns__7562.length) === ":/"
      }else {
        return and__3546__auto____7564
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7565)) {
      return or__3548__auto____7565
    }else {
      var or__3548__auto____7566 = name__7563[name__7563.length - 1] === ":";
      if(or__3548__auto____7566) {
        return or__3548__auto____7566
      }else {
        return!(token__7561.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__7561)
  }else {
    if(cljs.core.truth_(ns__7562)) {
      return cljs.core.keyword.call(null, ns__7562.substring(0, ns__7562.indexOf("/")), name__7563)
    }else {
      return cljs.core.keyword.call(null, token__7561)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.symbol_QMARK_.call(null, f)) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.string_QMARK_.call(null, f)) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.keyword_QMARK_.call(null, f)) {
        return cljs.core.PersistentArrayMap.fromArrays([f], [true])
      }else {
        if("\ufdd0'else") {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__7567 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.map_QMARK_.call(null, m__7567)) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__7568 = cljs.reader.read.call(null, rdr, true, null, true);
  if(function() {
    var G__7569__7570 = o__7568;
    if(G__7569__7570 != null) {
      if(function() {
        var or__3548__auto____7571 = G__7569__7570.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3548__auto____7571) {
          return or__3548__auto____7571
        }else {
          return G__7569__7570.cljs$core$IWithMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7569__7570.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7569__7570)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7569__7570)
    }
  }()) {
    return cljs.core.with_meta.call(null, o__7568, cljs.core.merge.call(null, cljs.core.meta.call(null, o__7568), m__7567))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string_STAR_.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = function macros(c) {
  if("@" === c) {
    return cljs.reader.wrapping_reader.call(null, "\ufdd1'deref")
  }else {
    if("`" === c) {
      return cljs.reader.not_implemented
    }else {
      if('"' === c) {
        return cljs.reader.read_string_STAR_
      }else {
        if("#" === c) {
          return cljs.reader.read_dispatch
        }else {
          if("%" === c) {
            return cljs.reader.not_implemented
          }else {
            if("'" === c) {
              return cljs.reader.wrapping_reader.call(null, "\ufdd1'quote")
            }else {
              if("(" === c) {
                return cljs.reader.read_list
              }else {
                if(")" === c) {
                  return cljs.reader.read_unmatched_delimiter
                }else {
                  if(":" === c) {
                    return cljs.reader.read_keyword
                  }else {
                    if(";" === c) {
                      return cljs.reader.not_implemented
                    }else {
                      if("[" === c) {
                        return cljs.reader.read_vector
                      }else {
                        if("{" === c) {
                          return cljs.reader.read_map
                        }else {
                          if("\\" === c) {
                            return cljs.reader.read_char
                          }else {
                            if("]" === c) {
                              return cljs.reader.read_unmatched_delimiter
                            }else {
                              if("}" === c) {
                                return cljs.reader.read_unmatched_delimiter
                              }else {
                                if("^" === c) {
                                  return cljs.reader.read_meta
                                }else {
                                  if("~" === c) {
                                    return cljs.reader.not_implemented
                                  }else {
                                    if("\ufdd0'else") {
                                      return null
                                    }else {
                                      return null
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.dispatch_macros = function dispatch_macros(s) {
  if("_" === s) {
    return cljs.reader.read_discard
  }else {
    if("!" === s) {
      return cljs.reader.read_comment
    }else {
      if('"' === s) {
        return cljs.reader.read_regex
      }else {
        if("<" === s) {
          return cljs.reader.throwing_reader.call(null, "Unreadable form")
        }else {
          if("{" === s) {
            return cljs.reader.read_set
          }else {
            if("\ufdd0'else") {
              return null
            }else {
              return null
            }
          }
        }
      }
    }
  }
};
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__7572 = cljs.reader.read_char.call(null, reader);
    if(ch__7572 == null) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.reader.whitespace_QMARK_.call(null, ch__7572)) {
        var G__7575 = reader;
        var G__7576 = eof_is_error;
        var G__7577 = sentinel;
        var G__7578 = is_recursive;
        reader = G__7575;
        eof_is_error = G__7576;
        sentinel = G__7577;
        is_recursive = G__7578;
        continue
      }else {
        if(cljs.reader.comment_prefix_QMARK_.call(null, ch__7572)) {
          var G__7579 = cljs.reader.read_comment.call(null, reader, ch__7572);
          var G__7580 = eof_is_error;
          var G__7581 = sentinel;
          var G__7582 = is_recursive;
          reader = G__7579;
          eof_is_error = G__7580;
          sentinel = G__7581;
          is_recursive = G__7582;
          continue
        }else {
          if("\ufdd0'else") {
            var f__7573 = cljs.reader.macros.call(null, ch__7572);
            var res__7574 = cljs.core.truth_(f__7573) ? f__7573.call(null, reader, ch__7572) : cljs.reader.number_literal_QMARK_.call(null, reader, ch__7572) ? cljs.reader.read_number.call(null, reader, ch__7572) : "\ufdd0'else" ? cljs.reader.read_symbol.call(null, reader, ch__7572) : null;
            if(res__7574 === reader) {
              var G__7583 = reader;
              var G__7584 = eof_is_error;
              var G__7585 = sentinel;
              var G__7586 = is_recursive;
              reader = G__7583;
              eof_is_error = G__7584;
              sentinel = G__7585;
              is_recursive = G__7586;
              continue
            }else {
              return res__7574
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__7587 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__7587, true, null, false)
};
cljs.reader.read_date = function read_date(str) {
  return new Date(Date.parse.call(null, str))
};
cljs.reader.read_queue = function read_queue(elems) {
  if(cljs.core.vector_QMARK_.call(null, elems)) {
    return cljs.core.into.call(null, cljs.core.PersistentQueue.EMPTY, elems)
  }else {
    return cljs.reader.reader_error.call(null, null, "Queue literal expects a vector for its elements.")
  }
};
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject(["inst", "uuid", "queue"], {"inst":cljs.core.identity, "uuid":cljs.core.identity, "queue":cljs.reader.read_queue}));
cljs.reader.maybe_read_tagged_type = function maybe_read_tagged_type(rdr, initch) {
  var tag__7588 = cljs.reader.read_symbol.call(null, rdr, initch);
  var form__7589 = cljs.reader.read.call(null, rdr, true, null, false);
  var pfn__7590 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), cljs.core.name.call(null, tag__7588));
  if(cljs.core.truth_(pfn__7590)) {
    return pfn__7590.call(null, form__7589)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Could not find tag parser for ", cljs.core.name.call(null, tag__7588), cljs.core.pr_str.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_)))
  }
};
cljs.reader.register_tag_parser_BANG_ = function register_tag_parser_BANG_(tag, f) {
  var tag__7591 = cljs.core.name.call(null, tag);
  var old_parser__7592 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), tag__7591);
  cljs.core.swap_BANG_.call(null, cljs.reader._STAR_tag_table_STAR_, cljs.core.assoc, tag__7591, f);
  return old_parser__7592
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__7461 = s;
      var limit__7462 = limit;
      var parts__7463 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core._EQ_.call(null, limit__7462, 1)) {
          return cljs.core.conj.call(null, parts__7463, s__7461)
        }else {
          var temp__3695__auto____7464 = cljs.core.re_find.call(null, re, s__7461);
          if(cljs.core.truth_(temp__3695__auto____7464)) {
            var m__7465 = temp__3695__auto____7464;
            var index__7466 = s__7461.indexOf(m__7465);
            var G__7467 = s__7461.substring(index__7466 + cljs.core.count.call(null, m__7465));
            var G__7468 = limit__7462 - 1;
            var G__7469 = cljs.core.conj.call(null, parts__7463, s__7461.substring(0, index__7466));
            s__7461 = G__7467;
            limit__7462 = G__7468;
            parts__7463 = G__7469;
            continue
          }else {
            return cljs.core.conj.call(null, parts__7463, s__7461)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__7470 = s.length;
  while(true) {
    if(index__7470 === 0) {
      return""
    }else {
      var ch__7471 = cljs.core.get.call(null, s, index__7470 - 1);
      if(function() {
        var or__3548__auto____7472 = cljs.core._EQ_.call(null, ch__7471, "\n");
        if(or__3548__auto____7472) {
          return or__3548__auto____7472
        }else {
          return cljs.core._EQ_.call(null, ch__7471, "\r")
        }
      }()) {
        var G__7473 = index__7470 - 1;
        index__7470 = G__7473;
        continue
      }else {
        return s.substring(0, index__7470)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__7474 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3548__auto____7475 = cljs.core.not.call(null, s__7474);
    if(or__3548__auto____7475) {
      return or__3548__auto____7475
    }else {
      var or__3548__auto____7476 = cljs.core._EQ_.call(null, "", s__7474);
      if(or__3548__auto____7476) {
        return or__3548__auto____7476
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__7474)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__7477 = new goog.string.StringBuffer;
  var length__7478 = s.length;
  var index__7479 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__7478, index__7479)) {
      return buffer__7477.toString()
    }else {
      var ch__7480 = s.charAt(index__7479);
      var temp__3695__auto____7481 = cljs.core.get.call(null, cmap, ch__7480);
      if(cljs.core.truth_(temp__3695__auto____7481)) {
        var replacement__7482 = temp__3695__auto____7481;
        buffer__7477.append([cljs.core.str(replacement__7482)].join(""))
      }else {
        buffer__7477.append(ch__7480)
      }
      var G__7483 = index__7479 + 1;
      index__7479 = G__7483;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__7432 = {};
  var G__7433__7434 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__7433__7434)) {
    var G__7436__7438 = cljs.core.first.call(null, G__7433__7434);
    var vec__7437__7439 = G__7436__7438;
    var k__7440 = cljs.core.nth.call(null, vec__7437__7439, 0, null);
    var v__7441 = cljs.core.nth.call(null, vec__7437__7439, 1, null);
    var G__7433__7442 = G__7433__7434;
    var G__7436__7443 = G__7436__7438;
    var G__7433__7444 = G__7433__7442;
    while(true) {
      var vec__7445__7446 = G__7436__7443;
      var k__7447 = cljs.core.nth.call(null, vec__7445__7446, 0, null);
      var v__7448 = cljs.core.nth.call(null, vec__7445__7446, 1, null);
      var G__7433__7449 = G__7433__7444;
      out__7432[cljs.core.name.call(null, k__7447)] = v__7448;
      var temp__3698__auto____7450 = cljs.core.next.call(null, G__7433__7449);
      if(cljs.core.truth_(temp__3698__auto____7450)) {
        var G__7433__7451 = temp__3698__auto____7450;
        var G__7452 = cljs.core.first.call(null, G__7433__7451);
        var G__7453 = G__7433__7451;
        G__7436__7443 = G__7452;
        G__7433__7444 = G__7453;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__7432
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__7454 = cljs.core.string_QMARK_.call(null, v) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__7454)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__7455) {
    var v = cljs.core.first(arglist__7455);
    var text = cljs.core.rest(arglist__7455);
    return log__delegate(v, text)
  };
  log.cljs$lang$arity$variadic = log__delegate;
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__7456) {
          var vec__7457__7458 = p__7456;
          var k__7459 = cljs.core.nth.call(null, vec__7457__7458, 0, null);
          var v__7460 = cljs.core.nth.call(null, vec__7457__7458, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__7459), clj__GT_js.call(null, v__7460))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.string_QMARK_.call(null, sel)) {
    return sel
  }else {
    if(cljs.core.fn_QMARK_.call(null, sel)) {
      var temp__3695__auto____7324 = jayq.core.crate_meta.call(null, sel);
      if(cljs.core.truth_(temp__3695__auto____7324)) {
        var cm__7325 = temp__3695__auto____7324;
        return[cljs.core.str("[crateGroup="), cljs.core.str(cm__7325), cljs.core.str("]")].join("")
      }else {
        return sel
      }
    }else {
      if(cljs.core.keyword_QMARK_.call(null, sel)) {
        return cljs.core.name.call(null, sel)
      }else {
        if("\ufdd0'else") {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__7326) {
    var vec__7327__7328 = p__7326;
    var context__7329 = cljs.core.nth.call(null, vec__7327__7328, 0, null);
    if(cljs.core.not.call(null, context__7329)) {
      return jQuery(jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery(jayq.core.__GT_selector.call(null, sel), context__7329)
    }
  };
  var $ = function(sel, var_args) {
    var p__7326 = null;
    if(goog.isDef(var_args)) {
      p__7326 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__7326)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__7330) {
    var sel = cljs.core.first(arglist__7330);
    var p__7326 = cljs.core.rest(arglist__7330);
    return $__delegate(sel, p__7326)
  };
  $.cljs$lang$arity$variadic = $__delegate;
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce$arity$2 = function(this$, f) {
  return cljs.core.ci_reduce.call(null, this$, f)
};
jQuery.prototype.cljs$core$IReduce$_reduce$arity$3 = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, this$, f, start)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup$arity$2 = function(this$, k) {
  var or__3548__auto____7331 = this$.slice(k, k + 1);
  if(cljs.core.truth_(or__3548__auto____7331)) {
    return or__3548__auto____7331
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$ILookup$_lookup$arity$3 = function(this$, k, not_found) {
  return cljs.core._nth.call(null, this$, k, not_found)
};
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth$arity$2 = function(this$, n) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth$arity$3 = function(this$, n, not_found) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    if(void 0 === not_found) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count$arity$1 = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  return this$.get(0)
};
jQuery.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  if(cljs.core.count.call(null, this$) > 1) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__7332 = null;
  var G__7332__2 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__7332__3 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__7332 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7332__2.call(this, _, k);
      case 3:
        return G__7332__3.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7332
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.clj__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.keyword_QMARK_.call(null, opts)) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.clj__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__7333) {
    var vec__7334__7335 = p__7333;
    var v__7336 = cljs.core.nth.call(null, vec__7334__7335, 0, null);
    var a__7337 = cljs.core.name.call(null, a);
    if(cljs.core.not.call(null, v__7336)) {
      return $elem.attr(a__7337)
    }else {
      return $elem.attr(a__7337, v__7336)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__7333 = null;
    if(goog.isDef(var_args)) {
      p__7333 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__7333)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__7338) {
    var $elem = cljs.core.first(arglist__7338);
    var a = cljs.core.first(cljs.core.next(arglist__7338));
    var p__7333 = cljs.core.rest(cljs.core.next(arglist__7338));
    return attr__delegate($elem, a, p__7333)
  };
  attr.cljs$lang$arity$variadic = attr__delegate;
  return attr
}();
jayq.core.remove_attr = function remove_attr($elem, a) {
  return $elem.removeAttr(cljs.core.name.call(null, a))
};
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__7339) {
    var vec__7340__7341 = p__7339;
    var v__7342 = cljs.core.nth.call(null, vec__7340__7341, 0, null);
    var k__7343 = cljs.core.name.call(null, k);
    if(cljs.core.not.call(null, v__7342)) {
      return $elem.data(k__7343)
    }else {
      return $elem.data(k__7343, v__7342)
    }
  };
  var data = function($elem, k, var_args) {
    var p__7339 = null;
    if(goog.isDef(var_args)) {
      p__7339 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__7339)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__7344) {
    var $elem = cljs.core.first(arglist__7344);
    var k = cljs.core.first(cljs.core.next(arglist__7344));
    var p__7339 = cljs.core.rest(cljs.core.next(arglist__7344));
    return data__delegate($elem, k, p__7339)
  };
  data.cljs$lang$arity$variadic = data__delegate;
  return data
}();
jayq.core.position = function position($elem) {
  return cljs.core.js__GT_clj.call(null, $elem.position(), "\ufdd0'keywordize-keys", true)
};
jayq.core.add_class = function add_class($elem, cl) {
  var cl__7345 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__7345)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__7346 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__7346)
};
jayq.core.toggle_class = function toggle_class($elem, cl) {
  var cl__7347 = cljs.core.name.call(null, cl);
  return $elem.toggleClass(cl__7347)
};
jayq.core.has_class = function has_class($elem, cl) {
  var cl__7348 = cljs.core.name.call(null, cl);
  return $elem.hasClass(cl__7348)
};
jayq.core.after = function after($elem, content) {
  return $elem.after(content)
};
jayq.core.before = function before($elem, content) {
  return $elem.before(content)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__7349) {
    var vec__7350__7351 = p__7349;
    var speed__7352 = cljs.core.nth.call(null, vec__7350__7351, 0, null);
    var on_finish__7353 = cljs.core.nth.call(null, vec__7350__7351, 1, null);
    return $elem.hide(speed__7352, on_finish__7353)
  };
  var hide = function($elem, var_args) {
    var p__7349 = null;
    if(goog.isDef(var_args)) {
      p__7349 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__7349)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__7354) {
    var $elem = cljs.core.first(arglist__7354);
    var p__7349 = cljs.core.rest(arglist__7354);
    return hide__delegate($elem, p__7349)
  };
  hide.cljs$lang$arity$variadic = hide__delegate;
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__7355) {
    var vec__7356__7357 = p__7355;
    var speed__7358 = cljs.core.nth.call(null, vec__7356__7357, 0, null);
    var on_finish__7359 = cljs.core.nth.call(null, vec__7356__7357, 1, null);
    return $elem.show(speed__7358, on_finish__7359)
  };
  var show = function($elem, var_args) {
    var p__7355 = null;
    if(goog.isDef(var_args)) {
      p__7355 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__7355)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__7360) {
    var $elem = cljs.core.first(arglist__7360);
    var p__7355 = cljs.core.rest(arglist__7360);
    return show__delegate($elem, p__7355)
  };
  show.cljs$lang$arity$variadic = show__delegate;
  return show
}();
jayq.core.toggle = function() {
  var toggle__delegate = function($elem, p__7361) {
    var vec__7362__7363 = p__7361;
    var speed__7364 = cljs.core.nth.call(null, vec__7362__7363, 0, null);
    var on_finish__7365 = cljs.core.nth.call(null, vec__7362__7363, 1, null);
    return $elem.toggle(speed__7364, on_finish__7365)
  };
  var toggle = function($elem, var_args) {
    var p__7361 = null;
    if(goog.isDef(var_args)) {
      p__7361 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return toggle__delegate.call(this, $elem, p__7361)
  };
  toggle.cljs$lang$maxFixedArity = 1;
  toggle.cljs$lang$applyTo = function(arglist__7366) {
    var $elem = cljs.core.first(arglist__7366);
    var p__7361 = cljs.core.rest(arglist__7366);
    return toggle__delegate($elem, p__7361)
  };
  toggle.cljs$lang$arity$variadic = toggle__delegate;
  return toggle
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__7367) {
    var vec__7368__7369 = p__7367;
    var speed__7370 = cljs.core.nth.call(null, vec__7368__7369, 0, null);
    var on_finish__7371 = cljs.core.nth.call(null, vec__7368__7369, 1, null);
    return $elem.fadeOut(speed__7370, on_finish__7371)
  };
  var fade_out = function($elem, var_args) {
    var p__7367 = null;
    if(goog.isDef(var_args)) {
      p__7367 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__7367)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__7372) {
    var $elem = cljs.core.first(arglist__7372);
    var p__7367 = cljs.core.rest(arglist__7372);
    return fade_out__delegate($elem, p__7367)
  };
  fade_out.cljs$lang$arity$variadic = fade_out__delegate;
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__7373) {
    var vec__7374__7375 = p__7373;
    var speed__7376 = cljs.core.nth.call(null, vec__7374__7375, 0, null);
    var on_finish__7377 = cljs.core.nth.call(null, vec__7374__7375, 1, null);
    return $elem.fadeIn(speed__7376, on_finish__7377)
  };
  var fade_in = function($elem, var_args) {
    var p__7373 = null;
    if(goog.isDef(var_args)) {
      p__7373 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__7373)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__7378) {
    var $elem = cljs.core.first(arglist__7378);
    var p__7373 = cljs.core.rest(arglist__7378);
    return fade_in__delegate($elem, p__7373)
  };
  fade_in.cljs$lang$arity$variadic = fade_in__delegate;
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__7379) {
    var vec__7380__7381 = p__7379;
    var speed__7382 = cljs.core.nth.call(null, vec__7380__7381, 0, null);
    var on_finish__7383 = cljs.core.nth.call(null, vec__7380__7381, 1, null);
    return $elem.slideUp(speed__7382, on_finish__7383)
  };
  var slide_up = function($elem, var_args) {
    var p__7379 = null;
    if(goog.isDef(var_args)) {
      p__7379 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__7379)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__7384) {
    var $elem = cljs.core.first(arglist__7384);
    var p__7379 = cljs.core.rest(arglist__7384);
    return slide_up__delegate($elem, p__7379)
  };
  slide_up.cljs$lang$arity$variadic = slide_up__delegate;
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__7385) {
    var vec__7386__7387 = p__7385;
    var speed__7388 = cljs.core.nth.call(null, vec__7386__7387, 0, null);
    var on_finish__7389 = cljs.core.nth.call(null, vec__7386__7387, 1, null);
    return $elem.slideDown(speed__7388, on_finish__7389)
  };
  var slide_down = function($elem, var_args) {
    var p__7385 = null;
    if(goog.isDef(var_args)) {
      p__7385 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__7385)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__7390) {
    var $elem = cljs.core.first(arglist__7390);
    var p__7385 = cljs.core.rest(arglist__7390);
    return slide_down__delegate($elem, p__7385)
  };
  slide_down.cljs$lang$arity$variadic = slide_down__delegate;
  return slide_down
}();
jayq.core.parent = function parent($elem) {
  return $elem.parent()
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.closest = function() {
  var closest__delegate = function($elem, selector, p__7391) {
    var vec__7392__7393 = p__7391;
    var context__7394 = cljs.core.nth.call(null, vec__7392__7393, 0, null);
    return $elem.closest(selector, context__7394)
  };
  var closest = function($elem, selector, var_args) {
    var p__7391 = null;
    if(goog.isDef(var_args)) {
      p__7391 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return closest__delegate.call(this, $elem, selector, p__7391)
  };
  closest.cljs$lang$maxFixedArity = 2;
  closest.cljs$lang$applyTo = function(arglist__7395) {
    var $elem = cljs.core.first(arglist__7395);
    var selector = cljs.core.first(cljs.core.next(arglist__7395));
    var p__7391 = cljs.core.rest(cljs.core.next(arglist__7395));
    return closest__delegate($elem, selector, p__7391)
  };
  closest.cljs$lang$arity$variadic = closest__delegate;
  return closest
}();
jayq.core.clone = function clone($elem) {
  return $elem.clone()
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__7396) {
    var vec__7397__7398 = p__7396;
    var v__7399 = cljs.core.nth.call(null, vec__7397__7398, 0, null);
    if(cljs.core.truth_(v__7399)) {
      return $elem.val(v__7399)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__7396 = null;
    if(goog.isDef(var_args)) {
      p__7396 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__7396)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__7400) {
    var $elem = cljs.core.first(arglist__7400);
    var p__7396 = cljs.core.rest(arglist__7400);
    return val__delegate($elem, p__7396)
  };
  val.cljs$lang$arity$variadic = val__delegate;
  return val
}();
jayq.core.serialize = function serialize($elem) {
  return $elem.serialize()
};
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.document_ready = function document_ready(func) {
  return jayq.core.$.call(null, document).ready(func)
};
jayq.core.xhr = function xhr(p__7401, content, callback) {
  var vec__7402__7403 = p__7401;
  var method__7404 = cljs.core.nth.call(null, vec__7402__7403, 0, null);
  var uri__7405 = cljs.core.nth.call(null, vec__7402__7403, 1, null);
  var params__7406 = jayq.util.clj__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__7404)), "\ufdd0'data":jayq.util.clj__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__7405, params__7406)
};
jayq.core.ajax = function() {
  var ajax = null;
  var ajax__1 = function(settings) {
    return jQuery.ajax(jayq.util.clj__GT_js.call(null, settings))
  };
  var ajax__2 = function(url, settings) {
    return jQuery.ajax(url, jayq.util.clj__GT_js.call(null, settings))
  };
  ajax = function(url, settings) {
    switch(arguments.length) {
      case 1:
        return ajax__1.call(this, url);
      case 2:
        return ajax__2.call(this, url, settings)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ajax.cljs$lang$arity$1 = ajax__1;
  ajax.cljs$lang$arity$2 = ajax__2;
  return ajax
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.unbind = function() {
  var unbind__delegate = function($elem, ev, p__7407) {
    var vec__7408__7409 = p__7407;
    var func__7410 = cljs.core.nth.call(null, vec__7408__7409, 0, null);
    return $elem.unbind(cljs.core.name.call(null, ev), func__7410)
  };
  var unbind = function($elem, ev, var_args) {
    var p__7407 = null;
    if(goog.isDef(var_args)) {
      p__7407 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return unbind__delegate.call(this, $elem, ev, p__7407)
  };
  unbind.cljs$lang$maxFixedArity = 2;
  unbind.cljs$lang$applyTo = function(arglist__7411) {
    var $elem = cljs.core.first(arglist__7411);
    var ev = cljs.core.first(cljs.core.next(arglist__7411));
    var p__7407 = cljs.core.rest(cljs.core.next(arglist__7411));
    return unbind__delegate($elem, ev, p__7407)
  };
  unbind.cljs$lang$arity$variadic = unbind__delegate;
  return unbind
}();
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.__GT_event = function __GT_event(e) {
  if(cljs.core.keyword_QMARK_.call(null, e)) {
    return cljs.core.name.call(null, e)
  }else {
    if(cljs.core.map_QMARK_.call(null, e)) {
      return jayq.util.clj__GT_js.call(null, e)
    }else {
      if(cljs.core.coll_QMARK_.call(null, e)) {
        return clojure.string.join.call(null, " ", cljs.core.map.call(null, cljs.core.name, e))
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Unknown event type: "), cljs.core.str(e)].join(""));
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.on = function() {
  var on__delegate = function($elem, events, p__7412) {
    var vec__7413__7414 = p__7412;
    var sel__7415 = cljs.core.nth.call(null, vec__7413__7414, 0, null);
    var data__7416 = cljs.core.nth.call(null, vec__7413__7414, 1, null);
    var handler__7417 = cljs.core.nth.call(null, vec__7413__7414, 2, null);
    return $elem.on(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7415), data__7416, handler__7417)
  };
  var on = function($elem, events, var_args) {
    var p__7412 = null;
    if(goog.isDef(var_args)) {
      p__7412 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return on__delegate.call(this, $elem, events, p__7412)
  };
  on.cljs$lang$maxFixedArity = 2;
  on.cljs$lang$applyTo = function(arglist__7418) {
    var $elem = cljs.core.first(arglist__7418);
    var events = cljs.core.first(cljs.core.next(arglist__7418));
    var p__7412 = cljs.core.rest(cljs.core.next(arglist__7418));
    return on__delegate($elem, events, p__7412)
  };
  on.cljs$lang$arity$variadic = on__delegate;
  return on
}();
jayq.core.one = function() {
  var one__delegate = function($elem, events, p__7419) {
    var vec__7420__7421 = p__7419;
    var sel__7422 = cljs.core.nth.call(null, vec__7420__7421, 0, null);
    var data__7423 = cljs.core.nth.call(null, vec__7420__7421, 1, null);
    var handler__7424 = cljs.core.nth.call(null, vec__7420__7421, 2, null);
    return $elem.one(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7422), data__7423, handler__7424)
  };
  var one = function($elem, events, var_args) {
    var p__7419 = null;
    if(goog.isDef(var_args)) {
      p__7419 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return one__delegate.call(this, $elem, events, p__7419)
  };
  one.cljs$lang$maxFixedArity = 2;
  one.cljs$lang$applyTo = function(arglist__7425) {
    var $elem = cljs.core.first(arglist__7425);
    var events = cljs.core.first(cljs.core.next(arglist__7425));
    var p__7419 = cljs.core.rest(cljs.core.next(arglist__7425));
    return one__delegate($elem, events, p__7419)
  };
  one.cljs$lang$arity$variadic = one__delegate;
  return one
}();
jayq.core.off = function() {
  var off__delegate = function($elem, events, p__7426) {
    var vec__7427__7428 = p__7426;
    var sel__7429 = cljs.core.nth.call(null, vec__7427__7428, 0, null);
    var handler__7430 = cljs.core.nth.call(null, vec__7427__7428, 1, null);
    return $elem.off(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7429), handler__7430)
  };
  var off = function($elem, events, var_args) {
    var p__7426 = null;
    if(goog.isDef(var_args)) {
      p__7426 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return off__delegate.call(this, $elem, events, p__7426)
  };
  off.cljs$lang$maxFixedArity = 2;
  off.cljs$lang$applyTo = function(arglist__7431) {
    var $elem = cljs.core.first(arglist__7431);
    var events = cljs.core.first(cljs.core.next(arglist__7431));
    var p__7426 = cljs.core.rest(cljs.core.next(arglist__7431));
    return off__delegate($elem, events, p__7426)
  };
  off.cljs$lang$arity$variadic = off__delegate;
  return off
}();
jayq.core.prevent = function prevent(e) {
  return e.preventDefault()
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.dynamic_bindings = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.binding_key = cljs.core.atom.call(null, 0);
cljsbinding.changing_input = cljs.core.atom.call(null, null);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__4831 = {};
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4830_SHARP_) {
    return out__4831[cljs.core.name.call(null, cljs.core.first.call(null, p1__4830_SHARP_))] = cljs.core.second.call(null, p1__4830_SHARP_)
  }, cljmap));
  return out__4831
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.map_QMARK_.call(null, data)) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.fnhandlers = cljs.core.set(["click", "dblclick"]);
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____4832 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(or__3548__auto____4832) {
    return or__3548__auto____4832
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx, bindingname) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.fnhandlers, bindingname)) {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return function() {
        return eval(fnstr).call(null, ctx)
      }
    }else {
      return function() {
        return eval(fnstr).call(null)
      }
    }
  }else {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return cljsbinding.translate.call(null, eval(fnstr).call(null, ctx))
    }else {
      return cljsbinding.translate.call(null, eval(fnstr).call(null))
    }
  }
};
cljsbinding.bind_elem = function bind_elem(elem, bindingname, f) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname)) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname).call(null, elem, f.call(null))
    }
  }else {
    return function() {
      return elem[bindingname].call(elem, f.call(null))
    }
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  var bindingname__4833 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__4834 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  return cljsbinding.bind_elem.call(null, elem, bindingname__4833, function() {
    return cljsbinding.valuefn.call(null, elem, fname__4834, ctx, bindingname__4833)
  })
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_jq_elem = function bind_jq_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__4835__4836 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__4835__4836)) {
    var data__4837 = cljs.core.first.call(null, G__4835__4836);
    var G__4835__4838 = G__4835__4836;
    while(true) {
      cljsbinding.bind_jq_elem.call(null, elem, data__4837.split(":"), ctx);
      var temp__3698__auto____4839 = cljs.core.next.call(null, G__4835__4838);
      if(cljs.core.truth_(temp__3698__auto____4839)) {
        var G__4835__4840 = temp__3698__auto____4839;
        var G__4841 = cljs.core.first.call(null, G__4835__4840);
        var G__4842 = G__4835__4840;
        data__4837 = G__4841;
        G__4835__4838 = G__4842;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.atom_val = function atom_val(elem, atm, ctx) {
  var aval__4843 = cljs.core.deref.call(null, atm);
  if(cljs.core.map_QMARK_.call(null, aval__4843)) {
    return aval__4843.call(null, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")))
  }else {
    if(cljs.core.truth_(function() {
      var and__3546__auto____4844 = cljs.core.coll_QMARK_.call(null, aval__4843);
      if(and__3546__auto____4844) {
        return ctx
      }else {
        return and__3546__auto____4844
      }
    }())) {
      var item__4845 = cljs.core.first.call(null, cljs.core.filter.call(null, function(x) {
        return cljs.core._EQ_.call(null, x.call(null, "\ufdd0'id"), ctx.call(null, "\ufdd0'id"))
      }, aval__4843));
      if(cljs.core.truth_(item__4845)) {
        return item__4845.call(null, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")))
      }else {
        return null
      }
    }else {
      if("\ufdd0'else") {
        return aval__4843
      }else {
        return null
      }
    }
  }
};
cljsbinding.update_in_seq = function update_in_seq(currentseq, ctx, k, v) {
  return cljs.core.doall.call(null, cljs.core.map.call(null, function(item) {
    if(cljs.core._EQ_.call(null, item.call(null, "\ufdd0'id"), ctx.call(null, "\ufdd0'id"))) {
      return cljs.core.assoc.call(null, item, k, v)
    }else {
      return item
    }
  }, currentseq))
};
cljsbinding.reset_atom_val = function reset_atom_val(elem, atom, val, ctx) {
  if(cljs.core.map_QMARK_.call(null, cljs.core.deref.call(null, atom))) {
    return cljs.core.swap_BANG_.call(null, atom, function(p1__4846_SHARP_) {
      return cljs.core.assoc.call(null, p1__4846_SHARP_, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")), val)
    })
  }else {
    if(cljs.core.truth_(function() {
      var and__3546__auto____4847 = cljs.core.coll_QMARK_.call(null, cljs.core.deref.call(null, atom));
      if(and__3546__auto____4847) {
        return ctx
      }else {
        return and__3546__auto____4847
      }
    }())) {
      return cljs.core.swap_BANG_.call(null, atom, cljsbinding.update_in_seq, ctx, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")), val)
    }else {
      if("\ufdd0'else") {
        return cljs.core.reset_BANG_.call(null, atom, val)
      }else {
        return null
      }
    }
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem, atm, ctx) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljsbinding.atom_val.call(null, elem, atm, ctx))
  });
  return elem.change(function() {
    cljs.core.reset_BANG_.call(null, cljsbinding.changing_input, elem);
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.val(), ctx);
    cljs.core.reset_BANG_.call(null, cljsbinding.changing_input, null);
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem, atm, ctx) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljsbinding.atom_val.call(null, elem, atm, ctx))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, atm, elem.is(":checked"), ctx);
    return false
  })
};
cljsbinding.bind_text_atom = function bind_text_atom(elem, atm, ctx) {
  return cljsbinding.run_bind_fn.call(null, function() {
    return elem["text"].call(elem, cljsbinding.atom_val.call(null, elem, atm, ctx))
  })
};
cljsbinding.bind_elem_to_atom = function bind_elem_to_atom(elem, atm, ctx) {
  if(cljs.core.truth_(function() {
    var or__3548__auto____4848 = elem.is("input");
    if(cljs.core.truth_(or__3548__auto____4848)) {
      return or__3548__auto____4848
    }else {
      var or__3548__auto____4849 = elem.is("textarea");
      if(cljs.core.truth_(or__3548__auto____4849)) {
        return or__3548__auto____4849
      }else {
        return elem.is("select")
      }
    }
  }())) {
    if(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type"))) {
      return cljsbinding.bind_checkbox_atom.call(null, elem, atm, ctx)
    }else {
      return cljsbinding.bind_input_atom.call(null, elem, atm, ctx)
    }
  }else {
    return cljsbinding.bind_text_atom.call(null, elem, atm, ctx)
  }
};
cljsbinding.bindatom = function() {
  var bindatom = null;
  var bindatom__1 = function(elem) {
    var atm__4850 = eval(jayq.core.attr.call(null, elem, "bindatom"));
    return cljsbinding.bind_elem_to_atom.call(null, elem, atm__4850, null)
  };
  var bindatom__2 = function(elem, ctx) {
    var atm__4851 = eval(jayq.core.attr.call(null, elem, "bindatom"));
    return cljsbinding.bind_elem_to_atom.call(null, elem, atm__4851, ctx)
  };
  bindatom = function(elem, ctx) {
    switch(arguments.length) {
      case 1:
        return bindatom__1.call(this, elem);
      case 2:
        return bindatom__2.call(this, elem, ctx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  bindatom.cljs$lang$arity$1 = bindatom__1;
  bindatom.cljs$lang$arity$2 = bindatom__2;
  return bindatom
}();
cljsbinding.insert_seq_item = function insert_seq_item(template, parent, sibling, item, elem, bindfn) {
  if(cljs.core._EQ_.call(null, sibling.length, 1)) {
    sibling.after(elem)
  }else {
    jayq.core.append.call(null, parent, elem)
  }
  return bindfn.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(templateid, sequence, parent, sibling, template, bindfn) {
  jayq.core.remove.call(null, parent.children([cljs.core.str("[bind-template-id='"), cljs.core.str(templateid), cljs.core.str("']")].join("")));
  var G__4852__4853 = cljs.core.seq.call(null, sequence);
  if(cljs.core.truth_(G__4852__4853)) {
    var item__4854 = cljs.core.first.call(null, G__4852__4853);
    var G__4852__4855 = G__4852__4853;
    while(true) {
      cljsbinding.insert_seq_item.call(null, template, parent, sibling, item__4854, template.clone().attr("bind-template-id", templateid), bindfn);
      var temp__3698__auto____4856 = cljs.core.next.call(null, G__4852__4855);
      if(cljs.core.truth_(temp__3698__auto____4856)) {
        var G__4852__4857 = temp__3698__auto____4856;
        var G__4858 = cljs.core.first.call(null, G__4852__4857);
        var G__4859 = G__4852__4857;
        item__4854 = G__4858;
        G__4852__4855 = G__4859;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.uuid = function uuid() {
  var r__4860 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__4860), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__4860)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__4860)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__4860)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__4860))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.parent_template_id = function parent_template_id(elem) {
  return jayq.core.$.call(null, elem).parents("*[bind-template-id]").attr("bind-template-id")
};
cljsbinding.bindseq = function bindseq(elem, elparent, elsibling, bindfn) {
  var atom__4863 = eval(jayq.core.attr.call(null, elem, "bindseq"));
  var templateid__4864 = cljsbinding.uuid.call(null);
  cljsbinding.insertseq.call(null, templateid__4864, cljs.core.deref.call(null, atom__4863), elparent, elsibling, elem, bindfn);
  return cljs.core.add_watch.call(null, atom__4863, templateid__4864, function(key, a, old_val, new_val) {
    var changing_input_template__4865 = cljs.core.truth_(cljs.core.deref.call(null, cljsbinding.changing_input)) ? cljsbinding.parent_template_id.call(null, cljs.core.deref.call(null, cljsbinding.changing_input)) : null;
    if(cljs.core.not.call(null, cljs.core._EQ_.call(null, changing_input_template__4865, templateid__4864))) {
      return cljsbinding.insertseq.call(null, templateid__4864, new_val, elparent, elsibling, elem, bindfn)
    }else {
      return null
    }
  })
};
cljsbinding.dobind = function dobind(parent, ctx) {
  var seqs__4866 = jayq.core.$.call(null, parent.find("*[bindseq]"));
  var seqparents__4867 = cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4861_SHARP_) {
    return jayq.core.$.call(null, p1__4861_SHARP_).parent()
  }, jayq.core.$.call(null, parent.find("*[bindseq]"))));
  var seqprevsiblings__4868 = cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4862_SHARP_) {
    return jayq.core.$.call(null, p1__4862_SHARP_).prev()
  }, jayq.core.$.call(null, parent.find("*[bindseq]"))));
  var G__4869__4870 = cljs.core.seq.call(null, seqs__4866);
  if(cljs.core.truth_(G__4869__4870)) {
    var elem__4871 = cljs.core.first.call(null, G__4869__4870);
    var G__4869__4872 = G__4869__4870;
    while(true) {
      jayq.core.remove.call(null, jayq.core.$.call(null, elem__4871));
      var temp__3698__auto____4873 = cljs.core.next.call(null, G__4869__4872);
      if(cljs.core.truth_(temp__3698__auto____4873)) {
        var G__4869__4874 = temp__3698__auto____4873;
        var G__4914 = cljs.core.first.call(null, G__4869__4874);
        var G__4915 = G__4869__4874;
        elem__4871 = G__4914;
        G__4869__4872 = G__4915;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4875__4876 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__4875__4876)) {
    var elem__4877 = cljs.core.first.call(null, G__4875__4876);
    var G__4875__4878 = G__4875__4876;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4877), ctx);
      var temp__3698__auto____4879 = cljs.core.next.call(null, G__4875__4878);
      if(cljs.core.truth_(temp__3698__auto____4879)) {
        var G__4875__4880 = temp__3698__auto____4879;
        var G__4916 = cljs.core.first.call(null, G__4875__4880);
        var G__4917 = G__4875__4880;
        elem__4877 = G__4916;
        G__4875__4878 = G__4917;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4881__4882 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__4881__4882)) {
    var elem__4883 = cljs.core.first.call(null, G__4881__4882);
    var G__4881__4884 = G__4881__4882;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4883), ctx);
      var temp__3698__auto____4885 = cljs.core.next.call(null, G__4881__4884);
      if(cljs.core.truth_(temp__3698__auto____4885)) {
        var G__4881__4886 = temp__3698__auto____4885;
        var G__4918 = cljs.core.first.call(null, G__4881__4886);
        var G__4919 = G__4881__4886;
        elem__4883 = G__4918;
        G__4881__4884 = G__4919;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4887__4888 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__4887__4888)) {
    var elem__4889 = cljs.core.first.call(null, G__4887__4888);
    var G__4887__4890 = G__4887__4888;
    while(true) {
      cljsbinding.bindatom.call(null, jayq.core.$.call(null, elem__4889), ctx);
      var temp__3698__auto____4891 = cljs.core.next.call(null, G__4887__4890);
      if(cljs.core.truth_(temp__3698__auto____4891)) {
        var G__4887__4892 = temp__3698__auto____4891;
        var G__4920 = cljs.core.first.call(null, G__4887__4892);
        var G__4921 = G__4887__4892;
        elem__4889 = G__4920;
        G__4887__4890 = G__4921;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4893__4894 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__4866, seqparents__4867, seqprevsiblings__4868));
  if(cljs.core.truth_(G__4893__4894)) {
    var G__4896__4898 = cljs.core.first.call(null, G__4893__4894);
    var vec__4897__4899 = G__4896__4898;
    var elem__4900 = cljs.core.nth.call(null, vec__4897__4899, 0, null);
    var parent__4901 = cljs.core.nth.call(null, vec__4897__4899, 1, null);
    var sibling__4902 = cljs.core.nth.call(null, vec__4897__4899, 2, null);
    var G__4893__4903 = G__4893__4894;
    var G__4896__4904 = G__4896__4898;
    var G__4893__4905 = G__4893__4903;
    while(true) {
      var vec__4906__4907 = G__4896__4904;
      var elem__4908 = cljs.core.nth.call(null, vec__4906__4907, 0, null);
      var parent__4909 = cljs.core.nth.call(null, vec__4906__4907, 1, null);
      var sibling__4910 = cljs.core.nth.call(null, vec__4906__4907, 2, null);
      var G__4893__4911 = G__4893__4905;
      cljsbinding.bindseq.call(null, jayq.core.$.call(null, elem__4908), parent__4909, sibling__4910, dobind);
      var temp__3698__auto____4912 = cljs.core.next.call(null, G__4893__4911);
      if(cljs.core.truth_(temp__3698__auto____4912)) {
        var G__4893__4913 = temp__3698__auto____4912;
        var G__4922 = cljs.core.first.call(null, G__4893__4913);
        var G__4923 = G__4893__4913;
        G__4896__4904 = G__4922;
        G__4893__4905 = G__4923;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindall = function() {
  var bindall = null;
  var bindall__1 = function(elem) {
    return cljsbinding.dobind.call(null, elem, null)
  };
  var bindall__2 = function(elem, ctx) {
    return cljsbinding.dobind.call(null, elem, ctx)
  };
  bindall = function(elem, ctx) {
    switch(arguments.length) {
      case 1:
        return bindall__1.call(this, elem);
      case 2:
        return bindall__2.call(this, elem, ctx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  bindall.cljs$lang$arity$1 = bindall__1;
  bindall.cljs$lang$arity$2 = bindall__2;
  return bindall
}();
goog.exportSymbol("cljsbinding.bindall", cljsbinding.bindall);
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.empty_QMARK_.call(null, sequence)) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__4924_SHARP_, p2__4925_SHARP_) {
      var or__3548__auto____4927 = p1__4924_SHARP_;
      if(cljs.core.truth_(or__3548__auto____4927)) {
        return or__3548__auto____4927
      }else {
        return p2__4925_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__4926_SHARP_) {
      return cljs.core._EQ_.call(null, p1__4926_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.add_binding = function add_binding(atom, m) {
  return cljs.core.assoc.call(null, m, atom, cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), m.call(null, atom)))
};
cljsbinding.run_bindings = function run_bindings(key, a, old_val, new_val) {
  var G__4928__4929 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
  if(cljs.core.truth_(G__4928__4929)) {
    var f__4930 = cljs.core.first.call(null, G__4928__4929);
    var G__4928__4931 = G__4928__4929;
    while(true) {
      f__4930.call(null);
      var temp__3698__auto____4932 = cljs.core.next.call(null, G__4928__4931);
      if(cljs.core.truth_(temp__3698__auto____4932)) {
        var G__4928__4933 = temp__3698__auto____4932;
        var G__4934 = cljs.core.first.call(null, G__4928__4933);
        var G__4935 = G__4928__4933;
        f__4930 = G__4934;
        G__4928__4931 = G__4935;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.next_binding_key = function next_binding_key() {
  return cljs.core.swap_BANG_.call(null, cljsbinding.binding_key, cljs.core.inc)
};
cljsbinding.register_bindingsource = function register_bindingsource(source) {
  var bindingkey__4937 = [cljs.core.str(cljsbinding.next_binding_key.call(null))].join("");
  cljs.core.swap_BANG_.call(null, cljsbinding.dynamic_bindings, function(p1__4936_SHARP_) {
    return cljs.core.assoc.call(null, p1__4936_SHARP_, bindingkey__4937, source)
  });
  return bindingkey__4937
};
cljsbinding.apply_binding = function apply_binding(elem, source) {
  if(cljs.core.map_QMARK_.call(null, source)) {
    var G__4938__4939 = cljs.core.seq.call(null, source);
    if(cljs.core.truth_(G__4938__4939)) {
      var G__4941__4943 = cljs.core.first.call(null, G__4938__4939);
      var vec__4942__4944 = G__4941__4943;
      var bindingname__4945 = cljs.core.nth.call(null, vec__4942__4944, 0, null);
      var f__4946 = cljs.core.nth.call(null, vec__4942__4944, 1, null);
      var G__4938__4947 = G__4938__4939;
      var G__4941__4948 = G__4941__4943;
      var G__4938__4949 = G__4938__4947;
      while(true) {
        var vec__4950__4951 = G__4941__4948;
        var bindingname__4952 = cljs.core.nth.call(null, vec__4950__4951, 0, null);
        var f__4953 = cljs.core.nth.call(null, vec__4950__4951, 1, null);
        var G__4938__4954 = G__4938__4949;
        cljsbinding.run_bind_fn.call(null, cljsbinding.bind_elem.call(null, elem, cljs.core.name.call(null, bindingname__4952), f__4953));
        var temp__3698__auto____4955 = cljs.core.next.call(null, G__4938__4954);
        if(cljs.core.truth_(temp__3698__auto____4955)) {
          var G__4938__4956 = temp__3698__auto____4955;
          var G__4957 = cljs.core.first.call(null, G__4938__4956);
          var G__4958 = G__4938__4956;
          G__4941__4948 = G__4957;
          G__4938__4949 = G__4958;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  }else {
    return cljsbinding.bind_elem_to_atom.call(null, elem, source, null)
  }
};
cljsbinding.apply_bindingsource = function apply_bindingsource(elem, bindingkey) {
  var G__4959__4960 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.dynamic_bindings).call(null, bindingkey));
  if(cljs.core.truth_(G__4959__4960)) {
    var source__4961 = cljs.core.first.call(null, G__4959__4960);
    var G__4959__4962 = G__4959__4960;
    while(true) {
      cljsbinding.apply_binding.call(null, elem, source__4961);
      var temp__3698__auto____4963 = cljs.core.next.call(null, G__4959__4962);
      if(cljs.core.truth_(temp__3698__auto____4963)) {
        var G__4959__4964 = temp__3698__auto____4963;
        var G__4965 = cljs.core.first.call(null, G__4959__4964);
        var G__4966 = G__4959__4964;
        source__4961 = G__4965;
        G__4959__4962 = G__4966;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, cljs.core.partial.call(null, cljsbinding.add_binding, atom));
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", cljsbinding.run_bindings);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.cljsderef = function cljsderef() {
  return cljs.core._deref
};
goog.exportSymbol("cljsbinding.cljsderef", cljsbinding.cljsderef);
cljsbinding.shouldregister = function shouldregister(drf) {
  return drf.call(null, cljsbinding.BindMonitor)
};
goog.exportSymbol("cljsbinding.shouldregister", cljsbinding.shouldregister);
cljsbinding.boot = function boot() {
  return eval("    \n    var derefName = eval('cljsbinding.cljsderef.toString().match(/return.(.*$)\\\\s/m)[1]')\n    if (derefName[derefName.length-1] == ';')\n      derefName = derefName.substr(0,derefName.length-1)\n    var deref = eval(derefName)\n    eval(derefName +' = function (a) { if (cljsbinding.shouldregister(deref)) { cljsbinding.register(a) };return deref(a); }')\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  var storedValue__4967 = localStorage[name];
  if(cljs.core.not.call(null, storedValue__4967 == null)) {
    return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, storedValue__4967))
  }else {
    return null
  }
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
goog.provide("cljsbinding.crate");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljsbinding");
cljsbinding.crate.re_tag = /([^\s\.#]+)(?:#([^\s\.#]+))?(?:\.([^\s#]+))?/;
cljsbinding.crate.tag_str = function tag_str(tag) {
  if(cljs.core.keyword_QMARK_.call(null, tag)) {
    return cljs.core.name.call(null, tag)
  }else {
    return[cljs.core.str(tag)].join("")
  }
};
cljsbinding.crate.normalize_element = function normalize_element(p__4808) {
  var vec__4809__4810 = p__4808;
  var tag__4811 = cljs.core.nth.call(null, vec__4809__4810, 0, null);
  var content__4812 = cljs.core.nthnext.call(null, vec__4809__4810, 1);
  if(cljs.core.not.call(null, function() {
    var or__3548__auto____4813 = cljs.core.keyword_QMARK_.call(null, tag__4811);
    if(or__3548__auto____4813) {
      return or__3548__auto____4813
    }else {
      var or__3548__auto____4814 = cljs.core.symbol_QMARK_.call(null, tag__4811);
      if(or__3548__auto____4814) {
        return or__3548__auto____4814
      }else {
        return cljs.core.string_QMARK_.call(null, tag__4811)
      }
    }
  }())) {
    throw Error([cljs.core.str(tag__4811), cljs.core.str(" is not a valid element name.")].join(""));
  }else {
  }
  var vec__4815__4816 = cljs.core.re_matches.call(null, cljsbinding.crate.re_tag, cljsbinding.crate.tag_str.call(null, tag__4811));
  var ___4817 = cljs.core.nth.call(null, vec__4815__4816, 0, null);
  var tag__4818 = cljs.core.nth.call(null, vec__4815__4816, 1, null);
  var id__4819 = cljs.core.nth.call(null, vec__4815__4816, 2, null);
  var class$__4820 = cljs.core.nth.call(null, vec__4815__4816, 3, null);
  var tag_attrs__4821 = cljs.core.ObjMap.fromObject(["\ufdd0'id", "\ufdd0'class"], {"\ufdd0'id":id__4819, "\ufdd0'class":cljs.core.truth_(class$__4820) ? class$__4820.replace(".", " ") : null});
  var map_attrs__4822 = cljs.core.first.call(null, content__4812);
  if(cljs.core.map_QMARK_.call(null, map_attrs__4822)) {
    return cljs.core.PersistentVector.fromArray([tag__4818, cljs.core.merge.call(null, tag_attrs__4821, map_attrs__4822), cljs.core.next.call(null, content__4812)])
  }else {
    return cljs.core.PersistentVector.fromArray([tag__4818, tag_attrs__4821, content__4812])
  }
};
cljsbinding.crate.add_binding = function() {
  var add_binding__delegate = function(elem, bind) {
    var vec__4823__4824 = cljsbinding.crate.normalize_element.call(null, elem);
    var tagname__4825 = cljs.core.nth.call(null, vec__4823__4824, 0, null);
    var attrs__4826 = cljs.core.nth.call(null, vec__4823__4824, 1, null);
    var content__4827 = cljs.core.nth.call(null, vec__4823__4824, 2, null);
    return cljs.core.PersistentVector.fromArray([tagname__4825, cljs.core.assoc.call(null, attrs__4826, "\ufdd0'withbinding", cljsbinding.register_bindingsource.call(null, bind))])
  };
  var add_binding = function(elem, var_args) {
    var bind = null;
    if(goog.isDef(var_args)) {
      bind = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return add_binding__delegate.call(this, elem, bind)
  };
  add_binding.cljs$lang$maxFixedArity = 1;
  add_binding.cljs$lang$applyTo = function(arglist__4828) {
    var elem = cljs.core.first(arglist__4828);
    var bind = cljs.core.rest(arglist__4828);
    return add_binding__delegate(elem, bind)
  };
  add_binding.cljs$lang$arity$variadic = add_binding__delegate;
  return add_binding
}();
cljsbinding.crate.bind_html_elem = function bind_html_elem(elem) {
  var bindingkey__4829 = jayq.core.attr.call(null, elem, "withbinding");
  cljsbinding.apply_bindingsource.call(null, elem, bindingkey__4829);
  return elem.removeAttr("withbinding")
};
