var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
void 0;
void 0;
void 0;
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
void 0;
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  if(p[goog.typeOf.call(null, x)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error("No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
void 0;
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__4764__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__4764 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4764__delegate.call(this, array, i, idxs)
    };
    G__4764.cljs$lang$maxFixedArity = 2;
    G__4764.cljs$lang$applyTo = function(arglist__4765) {
      var array = cljs.core.first(arglist__4765);
      var i = cljs.core.first(cljs.core.next(arglist__4765));
      var idxs = cljs.core.rest(cljs.core.next(arglist__4765));
      return G__4764__delegate(array, i, idxs)
    };
    G__4764.cljs$lang$arity$variadic = G__4764__delegate;
    return G__4764
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
void 0;
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
void 0;
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3546__auto____4766 = this$;
      if(and__3546__auto____4766) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3546__auto____4766
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      return function() {
        var or__3548__auto____4767 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4767) {
          return or__3548__auto____4767
        }else {
          var or__3548__auto____4768 = cljs.core._invoke["_"];
          if(or__3548__auto____4768) {
            return or__3548__auto____4768
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3546__auto____4769 = this$;
      if(and__3546__auto____4769) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3546__auto____4769
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      return function() {
        var or__3548__auto____4770 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4770) {
          return or__3548__auto____4770
        }else {
          var or__3548__auto____4771 = cljs.core._invoke["_"];
          if(or__3548__auto____4771) {
            return or__3548__auto____4771
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3546__auto____4772 = this$;
      if(and__3546__auto____4772) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3546__auto____4772
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____4773 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4773) {
          return or__3548__auto____4773
        }else {
          var or__3548__auto____4774 = cljs.core._invoke["_"];
          if(or__3548__auto____4774) {
            return or__3548__auto____4774
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3546__auto____4775 = this$;
      if(and__3546__auto____4775) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3546__auto____4775
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____4776 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4776) {
          return or__3548__auto____4776
        }else {
          var or__3548__auto____4777 = cljs.core._invoke["_"];
          if(or__3548__auto____4777) {
            return or__3548__auto____4777
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3546__auto____4778 = this$;
      if(and__3546__auto____4778) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3546__auto____4778
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____4779 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4779) {
          return or__3548__auto____4779
        }else {
          var or__3548__auto____4780 = cljs.core._invoke["_"];
          if(or__3548__auto____4780) {
            return or__3548__auto____4780
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3546__auto____4781 = this$;
      if(and__3546__auto____4781) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3546__auto____4781
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____4782 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4782) {
          return or__3548__auto____4782
        }else {
          var or__3548__auto____4783 = cljs.core._invoke["_"];
          if(or__3548__auto____4783) {
            return or__3548__auto____4783
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3546__auto____4784 = this$;
      if(and__3546__auto____4784) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3546__auto____4784
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____4785 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4785) {
          return or__3548__auto____4785
        }else {
          var or__3548__auto____4786 = cljs.core._invoke["_"];
          if(or__3548__auto____4786) {
            return or__3548__auto____4786
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3546__auto____4787 = this$;
      if(and__3546__auto____4787) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3546__auto____4787
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____4788 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4788) {
          return or__3548__auto____4788
        }else {
          var or__3548__auto____4789 = cljs.core._invoke["_"];
          if(or__3548__auto____4789) {
            return or__3548__auto____4789
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3546__auto____4790 = this$;
      if(and__3546__auto____4790) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3546__auto____4790
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____4791 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4791) {
          return or__3548__auto____4791
        }else {
          var or__3548__auto____4792 = cljs.core._invoke["_"];
          if(or__3548__auto____4792) {
            return or__3548__auto____4792
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3546__auto____4793 = this$;
      if(and__3546__auto____4793) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3546__auto____4793
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____4794 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4794) {
          return or__3548__auto____4794
        }else {
          var or__3548__auto____4795 = cljs.core._invoke["_"];
          if(or__3548__auto____4795) {
            return or__3548__auto____4795
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3546__auto____4796 = this$;
      if(and__3546__auto____4796) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3546__auto____4796
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____4797 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4797) {
          return or__3548__auto____4797
        }else {
          var or__3548__auto____4798 = cljs.core._invoke["_"];
          if(or__3548__auto____4798) {
            return or__3548__auto____4798
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3546__auto____4799 = this$;
      if(and__3546__auto____4799) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3546__auto____4799
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____4800 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4800) {
          return or__3548__auto____4800
        }else {
          var or__3548__auto____4801 = cljs.core._invoke["_"];
          if(or__3548__auto____4801) {
            return or__3548__auto____4801
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3546__auto____4802 = this$;
      if(and__3546__auto____4802) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3546__auto____4802
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____4803 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4803) {
          return or__3548__auto____4803
        }else {
          var or__3548__auto____4804 = cljs.core._invoke["_"];
          if(or__3548__auto____4804) {
            return or__3548__auto____4804
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3546__auto____4805 = this$;
      if(and__3546__auto____4805) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3546__auto____4805
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____4806 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4806) {
          return or__3548__auto____4806
        }else {
          var or__3548__auto____4807 = cljs.core._invoke["_"];
          if(or__3548__auto____4807) {
            return or__3548__auto____4807
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3546__auto____4808 = this$;
      if(and__3546__auto____4808) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3546__auto____4808
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____4809 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4809) {
          return or__3548__auto____4809
        }else {
          var or__3548__auto____4810 = cljs.core._invoke["_"];
          if(or__3548__auto____4810) {
            return or__3548__auto____4810
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3546__auto____4811 = this$;
      if(and__3546__auto____4811) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3546__auto____4811
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____4812 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4812) {
          return or__3548__auto____4812
        }else {
          var or__3548__auto____4813 = cljs.core._invoke["_"];
          if(or__3548__auto____4813) {
            return or__3548__auto____4813
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3546__auto____4814 = this$;
      if(and__3546__auto____4814) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3546__auto____4814
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____4815 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4815) {
          return or__3548__auto____4815
        }else {
          var or__3548__auto____4816 = cljs.core._invoke["_"];
          if(or__3548__auto____4816) {
            return or__3548__auto____4816
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3546__auto____4817 = this$;
      if(and__3546__auto____4817) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3546__auto____4817
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____4818 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4818) {
          return or__3548__auto____4818
        }else {
          var or__3548__auto____4819 = cljs.core._invoke["_"];
          if(or__3548__auto____4819) {
            return or__3548__auto____4819
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3546__auto____4820 = this$;
      if(and__3546__auto____4820) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3546__auto____4820
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____4821 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4821) {
          return or__3548__auto____4821
        }else {
          var or__3548__auto____4822 = cljs.core._invoke["_"];
          if(or__3548__auto____4822) {
            return or__3548__auto____4822
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3546__auto____4823 = this$;
      if(and__3546__auto____4823) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3546__auto____4823
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____4824 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4824) {
          return or__3548__auto____4824
        }else {
          var or__3548__auto____4825 = cljs.core._invoke["_"];
          if(or__3548__auto____4825) {
            return or__3548__auto____4825
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3546__auto____4826 = this$;
      if(and__3546__auto____4826) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3546__auto____4826
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____4827 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(or__3548__auto____4827) {
          return or__3548__auto____4827
        }else {
          var or__3548__auto____4828 = cljs.core._invoke["_"];
          if(or__3548__auto____4828) {
            return or__3548__auto____4828
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
void 0;
void 0;
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3546__auto____4829 = coll;
    if(and__3546__auto____4829) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3546__auto____4829
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4830 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4830) {
        return or__3548__auto____4830
      }else {
        var or__3548__auto____4831 = cljs.core._count["_"];
        if(or__3548__auto____4831) {
          return or__3548__auto____4831
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3546__auto____4832 = coll;
    if(and__3546__auto____4832) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3546__auto____4832
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4833 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4833) {
        return or__3548__auto____4833
      }else {
        var or__3548__auto____4834 = cljs.core._empty["_"];
        if(or__3548__auto____4834) {
          return or__3548__auto____4834
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3546__auto____4835 = coll;
    if(and__3546__auto____4835) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3546__auto____4835
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    return function() {
      var or__3548__auto____4836 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4836) {
        return or__3548__auto____4836
      }else {
        var or__3548__auto____4837 = cljs.core._conj["_"];
        if(or__3548__auto____4837) {
          return or__3548__auto____4837
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
void 0;
void 0;
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3546__auto____4838 = coll;
      if(and__3546__auto____4838) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3546__auto____4838
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      return function() {
        var or__3548__auto____4839 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4839) {
          return or__3548__auto____4839
        }else {
          var or__3548__auto____4840 = cljs.core._nth["_"];
          if(or__3548__auto____4840) {
            return or__3548__auto____4840
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3546__auto____4841 = coll;
      if(and__3546__auto____4841) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3546__auto____4841
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____4842 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4842) {
          return or__3548__auto____4842
        }else {
          var or__3548__auto____4843 = cljs.core._nth["_"];
          if(or__3548__auto____4843) {
            return or__3548__auto____4843
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
void 0;
void 0;
cljs.core.ASeq = {};
void 0;
void 0;
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3546__auto____4844 = coll;
    if(and__3546__auto____4844) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3546__auto____4844
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4845 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4845) {
        return or__3548__auto____4845
      }else {
        var or__3548__auto____4846 = cljs.core._first["_"];
        if(or__3548__auto____4846) {
          return or__3548__auto____4846
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3546__auto____4847 = coll;
    if(and__3546__auto____4847) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3546__auto____4847
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4848 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4848) {
        return or__3548__auto____4848
      }else {
        var or__3548__auto____4849 = cljs.core._rest["_"];
        if(or__3548__auto____4849) {
          return or__3548__auto____4849
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3546__auto____4850 = o;
      if(and__3546__auto____4850) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3546__auto____4850
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      return function() {
        var or__3548__auto____4851 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____4851) {
          return or__3548__auto____4851
        }else {
          var or__3548__auto____4852 = cljs.core._lookup["_"];
          if(or__3548__auto____4852) {
            return or__3548__auto____4852
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3546__auto____4853 = o;
      if(and__3546__auto____4853) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3546__auto____4853
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____4854 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(or__3548__auto____4854) {
          return or__3548__auto____4854
        }else {
          var or__3548__auto____4855 = cljs.core._lookup["_"];
          if(or__3548__auto____4855) {
            return or__3548__auto____4855
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
void 0;
void 0;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3546__auto____4856 = coll;
    if(and__3546__auto____4856) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3546__auto____4856
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____4857 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4857) {
        return or__3548__auto____4857
      }else {
        var or__3548__auto____4858 = cljs.core._contains_key_QMARK_["_"];
        if(or__3548__auto____4858) {
          return or__3548__auto____4858
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3546__auto____4859 = coll;
    if(and__3546__auto____4859) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3546__auto____4859
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____4860 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4860) {
        return or__3548__auto____4860
      }else {
        var or__3548__auto____4861 = cljs.core._assoc["_"];
        if(or__3548__auto____4861) {
          return or__3548__auto____4861
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
void 0;
void 0;
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3546__auto____4862 = coll;
    if(and__3546__auto____4862) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3546__auto____4862
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    return function() {
      var or__3548__auto____4863 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4863) {
        return or__3548__auto____4863
      }else {
        var or__3548__auto____4864 = cljs.core._dissoc["_"];
        if(or__3548__auto____4864) {
          return or__3548__auto____4864
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
void 0;
void 0;
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3546__auto____4865 = coll;
    if(and__3546__auto____4865) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3546__auto____4865
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4866 = cljs.core._key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4866) {
        return or__3548__auto____4866
      }else {
        var or__3548__auto____4867 = cljs.core._key["_"];
        if(or__3548__auto____4867) {
          return or__3548__auto____4867
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3546__auto____4868 = coll;
    if(and__3546__auto____4868) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3546__auto____4868
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4869 = cljs.core._val[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4869) {
        return or__3548__auto____4869
      }else {
        var or__3548__auto____4870 = cljs.core._val["_"];
        if(or__3548__auto____4870) {
          return or__3548__auto____4870
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3546__auto____4871 = coll;
    if(and__3546__auto____4871) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3546__auto____4871
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    return function() {
      var or__3548__auto____4872 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4872) {
        return or__3548__auto____4872
      }else {
        var or__3548__auto____4873 = cljs.core._disjoin["_"];
        if(or__3548__auto____4873) {
          return or__3548__auto____4873
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
void 0;
void 0;
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3546__auto____4874 = coll;
    if(and__3546__auto____4874) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3546__auto____4874
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4875 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4875) {
        return or__3548__auto____4875
      }else {
        var or__3548__auto____4876 = cljs.core._peek["_"];
        if(or__3548__auto____4876) {
          return or__3548__auto____4876
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3546__auto____4877 = coll;
    if(and__3546__auto____4877) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3546__auto____4877
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4878 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4878) {
        return or__3548__auto____4878
      }else {
        var or__3548__auto____4879 = cljs.core._pop["_"];
        if(or__3548__auto____4879) {
          return or__3548__auto____4879
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3546__auto____4880 = coll;
    if(and__3546__auto____4880) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3546__auto____4880
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____4881 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4881) {
        return or__3548__auto____4881
      }else {
        var or__3548__auto____4882 = cljs.core._assoc_n["_"];
        if(or__3548__auto____4882) {
          return or__3548__auto____4882
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
void 0;
void 0;
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3546__auto____4883 = o;
    if(and__3546__auto____4883) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3546__auto____4883
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4884 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(or__3548__auto____4884) {
        return or__3548__auto____4884
      }else {
        var or__3548__auto____4885 = cljs.core._deref["_"];
        if(or__3548__auto____4885) {
          return or__3548__auto____4885
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3546__auto____4886 = o;
    if(and__3546__auto____4886) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3546__auto____4886
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____4887 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(or__3548__auto____4887) {
        return or__3548__auto____4887
      }else {
        var or__3548__auto____4888 = cljs.core._deref_with_timeout["_"];
        if(or__3548__auto____4888) {
          return or__3548__auto____4888
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
void 0;
void 0;
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3546__auto____4889 = o;
    if(and__3546__auto____4889) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3546__auto____4889
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4890 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____4890) {
        return or__3548__auto____4890
      }else {
        var or__3548__auto____4891 = cljs.core._meta["_"];
        if(or__3548__auto____4891) {
          return or__3548__auto____4891
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3546__auto____4892 = o;
    if(and__3546__auto____4892) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3546__auto____4892
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    return function() {
      var or__3548__auto____4893 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(or__3548__auto____4893) {
        return or__3548__auto____4893
      }else {
        var or__3548__auto____4894 = cljs.core._with_meta["_"];
        if(or__3548__auto____4894) {
          return or__3548__auto____4894
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
void 0;
void 0;
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3546__auto____4895 = coll;
      if(and__3546__auto____4895) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3546__auto____4895
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      return function() {
        var or__3548__auto____4896 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4896) {
          return or__3548__auto____4896
        }else {
          var or__3548__auto____4897 = cljs.core._reduce["_"];
          if(or__3548__auto____4897) {
            return or__3548__auto____4897
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3546__auto____4898 = coll;
      if(and__3546__auto____4898) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3546__auto____4898
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____4899 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(or__3548__auto____4899) {
          return or__3548__auto____4899
        }else {
          var or__3548__auto____4900 = cljs.core._reduce["_"];
          if(or__3548__auto____4900) {
            return or__3548__auto____4900
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
void 0;
void 0;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3546__auto____4901 = coll;
    if(and__3546__auto____4901) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3546__auto____4901
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    return function() {
      var or__3548__auto____4902 = cljs.core._kv_reduce[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4902) {
        return or__3548__auto____4902
      }else {
        var or__3548__auto____4903 = cljs.core._kv_reduce["_"];
        if(or__3548__auto____4903) {
          return or__3548__auto____4903
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
void 0;
void 0;
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3546__auto____4904 = o;
    if(and__3546__auto____4904) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3546__auto____4904
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    return function() {
      var or__3548__auto____4905 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(or__3548__auto____4905) {
        return or__3548__auto____4905
      }else {
        var or__3548__auto____4906 = cljs.core._equiv["_"];
        if(or__3548__auto____4906) {
          return or__3548__auto____4906
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
void 0;
void 0;
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3546__auto____4907 = o;
    if(and__3546__auto____4907) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3546__auto____4907
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4908 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(or__3548__auto____4908) {
        return or__3548__auto____4908
      }else {
        var or__3548__auto____4909 = cljs.core._hash["_"];
        if(or__3548__auto____4909) {
          return or__3548__auto____4909
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3546__auto____4910 = o;
    if(and__3546__auto____4910) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3546__auto____4910
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    return function() {
      var or__3548__auto____4911 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____4911) {
        return or__3548__auto____4911
      }else {
        var or__3548__auto____4912 = cljs.core._seq["_"];
        if(or__3548__auto____4912) {
          return or__3548__auto____4912
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
void 0;
void 0;
cljs.core.ISequential = {};
void 0;
void 0;
cljs.core.IList = {};
void 0;
void 0;
cljs.core.IRecord = {};
void 0;
void 0;
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3546__auto____4913 = coll;
    if(and__3546__auto____4913) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3546__auto____4913
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4914 = cljs.core._rseq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4914) {
        return or__3548__auto____4914
      }else {
        var or__3548__auto____4915 = cljs.core._rseq["_"];
        if(or__3548__auto____4915) {
          return or__3548__auto____4915
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____4916 = coll;
    if(and__3546__auto____4916) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3546__auto____4916
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____4917 = cljs.core._sorted_seq[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4917) {
        return or__3548__auto____4917
      }else {
        var or__3548__auto____4918 = cljs.core._sorted_seq["_"];
        if(or__3548__auto____4918) {
          return or__3548__auto____4918
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3546__auto____4919 = coll;
    if(and__3546__auto____4919) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3546__auto____4919
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    return function() {
      var or__3548__auto____4920 = cljs.core._sorted_seq_from[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4920) {
        return or__3548__auto____4920
      }else {
        var or__3548__auto____4921 = cljs.core._sorted_seq_from["_"];
        if(or__3548__auto____4921) {
          return or__3548__auto____4921
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3546__auto____4922 = coll;
    if(and__3546__auto____4922) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3546__auto____4922
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    return function() {
      var or__3548__auto____4923 = cljs.core._entry_key[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4923) {
        return or__3548__auto____4923
      }else {
        var or__3548__auto____4924 = cljs.core._entry_key["_"];
        if(or__3548__auto____4924) {
          return or__3548__auto____4924
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3546__auto____4925 = coll;
    if(and__3546__auto____4925) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3546__auto____4925
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4926 = cljs.core._comparator[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4926) {
        return or__3548__auto____4926
      }else {
        var or__3548__auto____4927 = cljs.core._comparator["_"];
        if(or__3548__auto____4927) {
          return or__3548__auto____4927
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3546__auto____4928 = o;
    if(and__3546__auto____4928) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3546__auto____4928
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    return function() {
      var or__3548__auto____4929 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(or__3548__auto____4929) {
        return or__3548__auto____4929
      }else {
        var or__3548__auto____4930 = cljs.core._pr_seq["_"];
        if(or__3548__auto____4930) {
          return or__3548__auto____4930
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
void 0;
void 0;
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3546__auto____4931 = d;
    if(and__3546__auto____4931) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3546__auto____4931
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    return function() {
      var or__3548__auto____4932 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(or__3548__auto____4932) {
        return or__3548__auto____4932
      }else {
        var or__3548__auto____4933 = cljs.core._realized_QMARK_["_"];
        if(or__3548__auto____4933) {
          return or__3548__auto____4933
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
void 0;
void 0;
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3546__auto____4934 = this$;
    if(and__3546__auto____4934) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3546__auto____4934
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____4935 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4935) {
        return or__3548__auto____4935
      }else {
        var or__3548__auto____4936 = cljs.core._notify_watches["_"];
        if(or__3548__auto____4936) {
          return or__3548__auto____4936
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3546__auto____4937 = this$;
    if(and__3546__auto____4937) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3546__auto____4937
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____4938 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4938) {
        return or__3548__auto____4938
      }else {
        var or__3548__auto____4939 = cljs.core._add_watch["_"];
        if(or__3548__auto____4939) {
          return or__3548__auto____4939
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3546__auto____4940 = this$;
    if(and__3546__auto____4940) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3546__auto____4940
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    return function() {
      var or__3548__auto____4941 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(or__3548__auto____4941) {
        return or__3548__auto____4941
      }else {
        var or__3548__auto____4942 = cljs.core._remove_watch["_"];
        if(or__3548__auto____4942) {
          return or__3548__auto____4942
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
void 0;
void 0;
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3546__auto____4943 = coll;
    if(and__3546__auto____4943) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3546__auto____4943
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    return function() {
      var or__3548__auto____4944 = cljs.core._as_transient[goog.typeOf.call(null, coll)];
      if(or__3548__auto____4944) {
        return or__3548__auto____4944
      }else {
        var or__3548__auto____4945 = cljs.core._as_transient["_"];
        if(or__3548__auto____4945) {
          return or__3548__auto____4945
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
void 0;
void 0;
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3546__auto____4946 = tcoll;
    if(and__3546__auto____4946) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3546__auto____4946
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    return function() {
      var or__3548__auto____4947 = cljs.core._conj_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4947) {
        return or__3548__auto____4947
      }else {
        var or__3548__auto____4948 = cljs.core._conj_BANG_["_"];
        if(or__3548__auto____4948) {
          return or__3548__auto____4948
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____4949 = tcoll;
    if(and__3546__auto____4949) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3546__auto____4949
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____4950 = cljs.core._persistent_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4950) {
        return or__3548__auto____4950
      }else {
        var or__3548__auto____4951 = cljs.core._persistent_BANG_["_"];
        if(or__3548__auto____4951) {
          return or__3548__auto____4951
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3546__auto____4952 = tcoll;
    if(and__3546__auto____4952) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3546__auto____4952
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    return function() {
      var or__3548__auto____4953 = cljs.core._assoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4953) {
        return or__3548__auto____4953
      }else {
        var or__3548__auto____4954 = cljs.core._assoc_BANG_["_"];
        if(or__3548__auto____4954) {
          return or__3548__auto____4954
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
void 0;
void 0;
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3546__auto____4955 = tcoll;
    if(and__3546__auto____4955) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3546__auto____4955
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    return function() {
      var or__3548__auto____4956 = cljs.core._dissoc_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4956) {
        return or__3548__auto____4956
      }else {
        var or__3548__auto____4957 = cljs.core._dissoc_BANG_["_"];
        if(or__3548__auto____4957) {
          return or__3548__auto____4957
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
void 0;
void 0;
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3546__auto____4958 = tcoll;
    if(and__3546__auto____4958) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3546__auto____4958
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    return function() {
      var or__3548__auto____4959 = cljs.core._assoc_n_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4959) {
        return or__3548__auto____4959
      }else {
        var or__3548__auto____4960 = cljs.core._assoc_n_BANG_["_"];
        if(or__3548__auto____4960) {
          return or__3548__auto____4960
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3546__auto____4961 = tcoll;
    if(and__3546__auto____4961) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3546__auto____4961
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    return function() {
      var or__3548__auto____4962 = cljs.core._pop_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4962) {
        return or__3548__auto____4962
      }else {
        var or__3548__auto____4963 = cljs.core._pop_BANG_["_"];
        if(or__3548__auto____4963) {
          return or__3548__auto____4963
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
void 0;
void 0;
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3546__auto____4964 = tcoll;
    if(and__3546__auto____4964) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3546__auto____4964
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    return function() {
      var or__3548__auto____4965 = cljs.core._disjoin_BANG_[goog.typeOf.call(null, tcoll)];
      if(or__3548__auto____4965) {
        return or__3548__auto____4965
      }else {
        var or__3548__auto____4966 = cljs.core._disjoin_BANG_["_"];
        if(or__3548__auto____4966) {
          return or__3548__auto____4966
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
void 0;
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
void 0;
void 0;
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3548__auto____4967 = x === y;
    if(or__3548__auto____4967) {
      return or__3548__auto____4967
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__4968__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__4969 = y;
            var G__4970 = cljs.core.first.call(null, more);
            var G__4971 = cljs.core.next.call(null, more);
            x = G__4969;
            y = G__4970;
            more = G__4971;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__4968 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4968__delegate.call(this, x, y, more)
    };
    G__4968.cljs$lang$maxFixedArity = 2;
    G__4968.cljs$lang$applyTo = function(arglist__4972) {
      var x = cljs.core.first(arglist__4972);
      var y = cljs.core.first(cljs.core.next(arglist__4972));
      var more = cljs.core.rest(cljs.core.next(arglist__4972));
      return G__4968__delegate(x, y, more)
    };
    G__4968.cljs$lang$arity$variadic = G__4968__delegate;
    return G__4968
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(function() {
    var or__3548__auto____4973 = x == null;
    if(or__3548__auto____4973) {
      return or__3548__auto____4973
    }else {
      return void 0 === x
    }
  }()) {
    return null
  }else {
    return x.constructor
  }
};
void 0;
void 0;
void 0;
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__4974 = null;
  var G__4974__2 = function(o, k) {
    return null
  };
  var G__4974__3 = function(o, k, not_found) {
    return not_found
  };
  G__4974 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4974__2.call(this, o, k);
      case 3:
        return G__4974__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4974
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__4975 = null;
  var G__4975__2 = function(_, f) {
    return f.call(null)
  };
  var G__4975__3 = function(_, f, start) {
    return start
  };
  G__4975 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4975__2.call(this, _, f);
      case 3:
        return G__4975__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4975
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__4976 = null;
  var G__4976__2 = function(_, n) {
    return null
  };
  var G__4976__3 = function(_, n, not_found) {
    return not_found
  };
  G__4976 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4976__2.call(this, _, n);
      case 3:
        return G__4976__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4976
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
void 0;
void 0;
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    if(cljs.core._count.call(null, cicoll) === 0) {
      return f.call(null)
    }else {
      var val__4977 = cljs.core._nth.call(null, cicoll, 0);
      var n__4978 = 1;
      while(true) {
        if(n__4978 < cljs.core._count.call(null, cicoll)) {
          var nval__4979 = f.call(null, val__4977, cljs.core._nth.call(null, cicoll, n__4978));
          if(cljs.core.reduced_QMARK_.call(null, nval__4979)) {
            return cljs.core.deref.call(null, nval__4979)
          }else {
            var G__4986 = nval__4979;
            var G__4987 = n__4978 + 1;
            val__4977 = G__4986;
            n__4978 = G__4987;
            continue
          }
        }else {
          return val__4977
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var val__4980 = val;
    var n__4981 = 0;
    while(true) {
      if(n__4981 < cljs.core._count.call(null, cicoll)) {
        var nval__4982 = f.call(null, val__4980, cljs.core._nth.call(null, cicoll, n__4981));
        if(cljs.core.reduced_QMARK_.call(null, nval__4982)) {
          return cljs.core.deref.call(null, nval__4982)
        }else {
          var G__4988 = nval__4982;
          var G__4989 = n__4981 + 1;
          val__4980 = G__4988;
          n__4981 = G__4989;
          continue
        }
      }else {
        return val__4980
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var val__4983 = val;
    var n__4984 = idx;
    while(true) {
      if(n__4984 < cljs.core._count.call(null, cicoll)) {
        var nval__4985 = f.call(null, val__4983, cljs.core._nth.call(null, cicoll, n__4984));
        if(cljs.core.reduced_QMARK_.call(null, nval__4985)) {
          return cljs.core.deref.call(null, nval__4985)
        }else {
          var G__4990 = nval__4985;
          var G__4991 = n__4984 + 1;
          val__4983 = G__4990;
          n__4984 = G__4991;
          continue
        }
      }else {
        return val__4983
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
void 0;
void 0;
void 0;
void 0;
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15990906
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__4992 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__4993 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$ASeq$ = true;
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__4994 = this;
  var this$__4995 = this;
  return cljs.core.pr_str.call(null, this$__4995)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__4996 = this;
  if(cljs.core.counted_QMARK_.call(null, this__4996.a)) {
    return cljs.core.ci_reduce.call(null, this__4996.a, f, this__4996.a[this__4996.i], this__4996.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__4996.a[this__4996.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__4997 = this;
  if(cljs.core.counted_QMARK_.call(null, this__4997.a)) {
    return cljs.core.ci_reduce.call(null, this__4997.a, f, start, this__4997.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__4998 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__4999 = this;
  return this__4999.a.length - this__4999.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__5000 = this;
  return this__5000.a[this__5000.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__5001 = this;
  if(this__5001.i + 1 < this__5001.a.length) {
    return new cljs.core.IndexedSeq(this__5001.a, this__5001.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5002 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5003 = this;
  var i__5004 = n + this__5003.i;
  if(i__5004 < this__5003.a.length) {
    return this__5003.a[i__5004]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5005 = this;
  var i__5006 = n + this__5005.i;
  if(i__5006 < this__5005.a.length) {
    return this__5005.a[i__5006]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__5007 = null;
  var G__5007__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__5007__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__5007 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5007__2.call(this, array, f);
      case 3:
        return G__5007__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5007
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__5008 = null;
  var G__5008__2 = function(array, k) {
    return array[k]
  };
  var G__5008__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__5008 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5008__2.call(this, array, k);
      case 3:
        return G__5008__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5008
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__5009 = null;
  var G__5009__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__5009__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__5009 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5009__2.call(this, array, n);
      case 3:
        return G__5009__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5009
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(coll != null) {
    if(function() {
      var G__5010__5011 = coll;
      if(G__5010__5011 != null) {
        if(function() {
          var or__3548__auto____5012 = G__5010__5011.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3548__auto____5012) {
            return or__3548__auto____5012
          }else {
            return G__5010__5011.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__5010__5011.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5010__5011)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5010__5011)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  if(coll != null) {
    if(function() {
      var G__5013__5014 = coll;
      if(G__5013__5014 != null) {
        if(function() {
          var or__3548__auto____5015 = G__5013__5014.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5015) {
            return or__3548__auto____5015
          }else {
            return G__5013__5014.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5013__5014.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5013__5014)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5013__5014)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__5016 = cljs.core.seq.call(null, coll);
      if(s__5016 != null) {
        return cljs.core._first.call(null, s__5016)
      }else {
        return null
      }
    }
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  if(coll != null) {
    if(function() {
      var G__5017__5018 = coll;
      if(G__5017__5018 != null) {
        if(function() {
          var or__3548__auto____5019 = G__5017__5018.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5019) {
            return or__3548__auto____5019
          }else {
            return G__5017__5018.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5017__5018.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5017__5018)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5017__5018)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__5020 = cljs.core.seq.call(null, coll);
      if(s__5020 != null) {
        return cljs.core._rest.call(null, s__5020)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll != null) {
    if(function() {
      var G__5021__5022 = coll;
      if(G__5021__5022 != null) {
        if(function() {
          var or__3548__auto____5023 = G__5021__5022.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5023) {
            return or__3548__auto____5023
          }else {
            return G__5021__5022.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5021__5022.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5021__5022)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5021__5022)
      }
    }()) {
      var coll__5024 = cljs.core._rest.call(null, coll);
      if(coll__5024 != null) {
        if(function() {
          var G__5025__5026 = coll__5024;
          if(G__5025__5026 != null) {
            if(function() {
              var or__3548__auto____5027 = G__5025__5026.cljs$lang$protocol_mask$partition0$ & 32;
              if(or__3548__auto____5027) {
                return or__3548__auto____5027
              }else {
                return G__5025__5026.cljs$core$ASeq$
              }
            }()) {
              return true
            }else {
              if(!G__5025__5026.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5025__5026)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__5025__5026)
          }
        }()) {
          return coll__5024
        }else {
          return cljs.core._seq.call(null, coll__5024)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__5028 = cljs.core.next.call(null, s);
      s = G__5028;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__5029__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__5030 = conj.call(null, coll, x);
          var G__5031 = cljs.core.first.call(null, xs);
          var G__5032 = cljs.core.next.call(null, xs);
          coll = G__5030;
          x = G__5031;
          xs = G__5032;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__5029 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5029__delegate.call(this, coll, x, xs)
    };
    G__5029.cljs$lang$maxFixedArity = 2;
    G__5029.cljs$lang$applyTo = function(arglist__5033) {
      var coll = cljs.core.first(arglist__5033);
      var x = cljs.core.first(cljs.core.next(arglist__5033));
      var xs = cljs.core.rest(cljs.core.next(arglist__5033));
      return G__5029__delegate(coll, x, xs)
    };
    G__5029.cljs$lang$arity$variadic = G__5029__delegate;
    return G__5029
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
void 0;
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__5034 = cljs.core.seq.call(null, coll);
  var acc__5035 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__5034)) {
      return acc__5035 + cljs.core._count.call(null, s__5034)
    }else {
      var G__5036 = cljs.core.next.call(null, s__5034);
      var G__5037 = acc__5035 + 1;
      s__5034 = G__5036;
      acc__5035 = G__5037;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
void 0;
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll != null) {
      if(function() {
        var G__5038__5039 = coll;
        if(G__5038__5039 != null) {
          if(function() {
            var or__3548__auto____5040 = G__5038__5039.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5040) {
              return or__3548__auto____5040
            }else {
              return G__5038__5039.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5038__5039.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5038__5039)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5038__5039)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }else {
      return null
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(coll != null) {
      if(function() {
        var G__5041__5042 = coll;
        if(G__5041__5042 != null) {
          if(function() {
            var or__3548__auto____5043 = G__5041__5042.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3548__auto____5043) {
              return or__3548__auto____5043
            }else {
              return G__5041__5042.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__5041__5042.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5041__5042)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5041__5042)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__5045__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__5044 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__5046 = ret__5044;
          var G__5047 = cljs.core.first.call(null, kvs);
          var G__5048 = cljs.core.second.call(null, kvs);
          var G__5049 = cljs.core.nnext.call(null, kvs);
          coll = G__5046;
          k = G__5047;
          v = G__5048;
          kvs = G__5049;
          continue
        }else {
          return ret__5044
        }
        break
      }
    };
    var G__5045 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5045__delegate.call(this, coll, k, v, kvs)
    };
    G__5045.cljs$lang$maxFixedArity = 3;
    G__5045.cljs$lang$applyTo = function(arglist__5050) {
      var coll = cljs.core.first(arglist__5050);
      var k = cljs.core.first(cljs.core.next(arglist__5050));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5050)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5050)));
      return G__5045__delegate(coll, k, v, kvs)
    };
    G__5045.cljs$lang$arity$variadic = G__5045__delegate;
    return G__5045
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__5052__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5051 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5053 = ret__5051;
          var G__5054 = cljs.core.first.call(null, ks);
          var G__5055 = cljs.core.next.call(null, ks);
          coll = G__5053;
          k = G__5054;
          ks = G__5055;
          continue
        }else {
          return ret__5051
        }
        break
      }
    };
    var G__5052 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5052__delegate.call(this, coll, k, ks)
    };
    G__5052.cljs$lang$maxFixedArity = 2;
    G__5052.cljs$lang$applyTo = function(arglist__5056) {
      var coll = cljs.core.first(arglist__5056);
      var k = cljs.core.first(cljs.core.next(arglist__5056));
      var ks = cljs.core.rest(cljs.core.next(arglist__5056));
      return G__5052__delegate(coll, k, ks)
    };
    G__5052.cljs$lang$arity$variadic = G__5052__delegate;
    return G__5052
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__5057__5058 = o;
    if(G__5057__5058 != null) {
      if(function() {
        var or__3548__auto____5059 = G__5057__5058.cljs$lang$protocol_mask$partition0$ & 65536;
        if(or__3548__auto____5059) {
          return or__3548__auto____5059
        }else {
          return G__5057__5058.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__5057__5058.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5057__5058)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__5057__5058)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__5061__delegate = function(coll, k, ks) {
      while(true) {
        var ret__5060 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__5062 = ret__5060;
          var G__5063 = cljs.core.first.call(null, ks);
          var G__5064 = cljs.core.next.call(null, ks);
          coll = G__5062;
          k = G__5063;
          ks = G__5064;
          continue
        }else {
          return ret__5060
        }
        break
      }
    };
    var G__5061 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5061__delegate.call(this, coll, k, ks)
    };
    G__5061.cljs$lang$maxFixedArity = 2;
    G__5061.cljs$lang$applyTo = function(arglist__5065) {
      var coll = cljs.core.first(arglist__5065);
      var k = cljs.core.first(cljs.core.next(arglist__5065));
      var ks = cljs.core.rest(cljs.core.next(arglist__5065));
      return G__5061__delegate(coll, k, ks)
    };
    G__5061.cljs$lang$arity$variadic = G__5061__delegate;
    return G__5061
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5066__5067 = x;
    if(G__5066__5067 != null) {
      if(function() {
        var or__3548__auto____5068 = G__5066__5067.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3548__auto____5068) {
          return or__3548__auto____5068
        }else {
          return G__5066__5067.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__5066__5067.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5066__5067)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__5066__5067)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5069__5070 = x;
    if(G__5069__5070 != null) {
      if(function() {
        var or__3548__auto____5071 = G__5069__5070.cljs$lang$protocol_mask$partition0$ & 2048;
        if(or__3548__auto____5071) {
          return or__3548__auto____5071
        }else {
          return G__5069__5070.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__5069__5070.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5069__5070)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__5069__5070)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__5072__5073 = x;
  if(G__5072__5073 != null) {
    if(function() {
      var or__3548__auto____5074 = G__5072__5073.cljs$lang$protocol_mask$partition0$ & 256;
      if(or__3548__auto____5074) {
        return or__3548__auto____5074
      }else {
        return G__5072__5073.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__5072__5073.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5072__5073)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__5072__5073)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__5075__5076 = x;
  if(G__5075__5076 != null) {
    if(function() {
      var or__3548__auto____5077 = G__5075__5076.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3548__auto____5077) {
        return or__3548__auto____5077
      }else {
        return G__5075__5076.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__5075__5076.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5075__5076)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__5075__5076)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__5078__5079 = x;
  if(G__5078__5079 != null) {
    if(function() {
      var or__3548__auto____5080 = G__5078__5079.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3548__auto____5080) {
        return or__3548__auto____5080
      }else {
        return G__5078__5079.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__5078__5079.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5078__5079)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__5078__5079)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__5081__5082 = x;
  if(G__5081__5082 != null) {
    if(function() {
      var or__3548__auto____5083 = G__5081__5082.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3548__auto____5083) {
        return or__3548__auto____5083
      }else {
        return G__5081__5082.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__5081__5082.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5081__5082)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__5081__5082)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__5084__5085 = x;
  if(G__5084__5085 != null) {
    if(function() {
      var or__3548__auto____5086 = G__5084__5085.cljs$lang$protocol_mask$partition0$ & 262144;
      if(or__3548__auto____5086) {
        return or__3548__auto____5086
      }else {
        return G__5084__5085.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__5084__5085.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5084__5085)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5084__5085)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__5087__5088 = x;
    if(G__5087__5088 != null) {
      if(function() {
        var or__3548__auto____5089 = G__5087__5088.cljs$lang$protocol_mask$partition0$ & 512;
        if(or__3548__auto____5089) {
          return or__3548__auto____5089
        }else {
          return G__5087__5088.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__5087__5088.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5087__5088)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__5087__5088)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__5090__5091 = x;
  if(G__5090__5091 != null) {
    if(function() {
      var or__3548__auto____5092 = G__5090__5091.cljs$lang$protocol_mask$partition0$ & 8192;
      if(or__3548__auto____5092) {
        return or__3548__auto____5092
      }else {
        return G__5090__5091.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__5090__5091.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5090__5091)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__5090__5091)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__5093__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__5093 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5093__delegate.call(this, keyvals)
    };
    G__5093.cljs$lang$maxFixedArity = 0;
    G__5093.cljs$lang$applyTo = function(arglist__5094) {
      var keyvals = cljs.core.seq(arglist__5094);
      return G__5093__delegate(keyvals)
    };
    G__5093.cljs$lang$arity$variadic = G__5093__delegate;
    return G__5093
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(falsecljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__5095 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__5095.push(key)
  });
  return keys__5095
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__5096 = i;
  var j__5097 = j;
  var len__5098 = len;
  while(true) {
    if(len__5098 === 0) {
      return to
    }else {
      to[j__5097] = from[i__5096];
      var G__5099 = i__5096 + 1;
      var G__5100 = j__5097 + 1;
      var G__5101 = len__5098 - 1;
      i__5096 = G__5099;
      j__5097 = G__5100;
      len__5098 = G__5101;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__5102 = i + (len - 1);
  var j__5103 = j + (len - 1);
  var len__5104 = len;
  while(true) {
    if(len__5104 === 0) {
      return to
    }else {
      to[j__5103] = from[i__5102];
      var G__5105 = i__5102 - 1;
      var G__5106 = j__5103 - 1;
      var G__5107 = len__5104 - 1;
      i__5102 = G__5105;
      j__5103 = G__5106;
      len__5104 = G__5107;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__5108__5109 = s;
    if(G__5108__5109 != null) {
      if(function() {
        var or__3548__auto____5110 = G__5108__5109.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3548__auto____5110) {
          return or__3548__auto____5110
        }else {
          return G__5108__5109.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__5108__5109.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5108__5109)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5108__5109)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__5111__5112 = s;
  if(G__5111__5112 != null) {
    if(function() {
      var or__3548__auto____5113 = G__5111__5112.cljs$lang$protocol_mask$partition0$ & 4194304;
      if(or__3548__auto____5113) {
        return or__3548__auto____5113
      }else {
        return G__5111__5112.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__5111__5112.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5111__5112)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__5111__5112)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____5114 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5114)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____5115 = x.charAt(0) === "\ufdd0";
      if(or__3548__auto____5115) {
        return or__3548__auto____5115
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }())
  }else {
    return and__3546__auto____5114
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____5116 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5116)) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3546__auto____5116
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____5117 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____5117)) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3546__auto____5117
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3548__auto____5118 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3548__auto____5118) {
    return or__3548__auto____5118
  }else {
    var G__5119__5120 = f;
    if(G__5119__5120 != null) {
      if(function() {
        var or__3548__auto____5121 = G__5119__5120.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3548__auto____5121) {
          return or__3548__auto____5121
        }else {
          return G__5119__5120.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__5119__5120.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5119__5120)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__5119__5120)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____5122 = cljs.core.number_QMARK_.call(null, n);
  if(and__3546__auto____5122) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____5122
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5123 = coll;
    if(cljs.core.truth_(and__3546__auto____5123)) {
      var and__3546__auto____5124 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3546__auto____5124) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____5124
      }
    }else {
      return and__3546__auto____5123
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3 = function() {
    var G__5129__delegate = function(x, y, more) {
      if(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))) {
        var s__5125 = cljs.core.set([y, x]);
        var xs__5126 = more;
        while(true) {
          var x__5127 = cljs.core.first.call(null, xs__5126);
          var etc__5128 = cljs.core.next.call(null, xs__5126);
          if(cljs.core.truth_(xs__5126)) {
            if(cljs.core.contains_QMARK_.call(null, s__5125, x__5127)) {
              return false
            }else {
              var G__5130 = cljs.core.conj.call(null, s__5125, x__5127);
              var G__5131 = etc__5128;
              s__5125 = G__5130;
              xs__5126 = G__5131;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__5129 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5129__delegate.call(this, x, y, more)
    };
    G__5129.cljs$lang$maxFixedArity = 2;
    G__5129.cljs$lang$applyTo = function(arglist__5132) {
      var x = cljs.core.first(arglist__5132);
      var y = cljs.core.first(cljs.core.next(arglist__5132));
      var more = cljs.core.rest(cljs.core.next(arglist__5132));
      return G__5129__delegate(x, y, more)
    };
    G__5129.cljs$lang$arity$variadic = G__5129__delegate;
    return G__5129
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
    return goog.array.defaultCompare.call(null, x, y)
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if("\ufdd0'else") {
          throw new Error("compare on non-nil objects of different types");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__5133 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__5133)) {
        return r__5133
      }else {
        if(cljs.core.truth_(r__5133)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
void 0;
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__5134 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__5134, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__5134)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3695__auto____5135 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____5135)) {
      var s__5136 = temp__3695__auto____5135;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__5136), cljs.core.next.call(null, s__5136))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__5137 = val;
    var coll__5138 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__5138)) {
        var nval__5139 = f.call(null, val__5137, cljs.core.first.call(null, coll__5138));
        if(cljs.core.reduced_QMARK_.call(null, nval__5139)) {
          return cljs.core.deref.call(null, nval__5139)
        }else {
          var G__5140 = nval__5139;
          var G__5141 = cljs.core.next.call(null, coll__5138);
          val__5137 = G__5140;
          coll__5138 = G__5141;
          continue
        }
      }else {
        return val__5137
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__5142__5143 = coll;
      if(G__5142__5143 != null) {
        if(function() {
          var or__3548__auto____5144 = G__5142__5143.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5144) {
            return or__3548__auto____5144
          }else {
            return G__5142__5143.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5142__5143.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5142__5143)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5142__5143)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__5145__5146 = coll;
      if(G__5145__5146 != null) {
        if(function() {
          var or__3548__auto____5147 = G__5145__5146.cljs$lang$protocol_mask$partition0$ & 262144;
          if(or__3548__auto____5147) {
            return or__3548__auto____5147
          }else {
            return G__5145__5146.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__5145__5146.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5145__5146)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__5145__5146)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16384
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$ = true;
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__5148 = this;
  return this__5148.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__5149__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__5149 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5149__delegate.call(this, x, y, more)
    };
    G__5149.cljs$lang$maxFixedArity = 2;
    G__5149.cljs$lang$applyTo = function(arglist__5150) {
      var x = cljs.core.first(arglist__5150);
      var y = cljs.core.first(cljs.core.next(arglist__5150));
      var more = cljs.core.rest(cljs.core.next(arglist__5150));
      return G__5149__delegate(x, y, more)
    };
    G__5149.cljs$lang$arity$variadic = G__5149__delegate;
    return G__5149
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__5151__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__5151 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5151__delegate.call(this, x, y, more)
    };
    G__5151.cljs$lang$maxFixedArity = 2;
    G__5151.cljs$lang$applyTo = function(arglist__5152) {
      var x = cljs.core.first(arglist__5152);
      var y = cljs.core.first(cljs.core.next(arglist__5152));
      var more = cljs.core.rest(cljs.core.next(arglist__5152));
      return G__5151__delegate(x, y, more)
    };
    G__5151.cljs$lang$arity$variadic = G__5151__delegate;
    return G__5151
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__5153__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__5153 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5153__delegate.call(this, x, y, more)
    };
    G__5153.cljs$lang$maxFixedArity = 2;
    G__5153.cljs$lang$applyTo = function(arglist__5154) {
      var x = cljs.core.first(arglist__5154);
      var y = cljs.core.first(cljs.core.next(arglist__5154));
      var more = cljs.core.rest(cljs.core.next(arglist__5154));
      return G__5153__delegate(x, y, more)
    };
    G__5153.cljs$lang$arity$variadic = G__5153__delegate;
    return G__5153
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__5155__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__5155 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5155__delegate.call(this, x, y, more)
    };
    G__5155.cljs$lang$maxFixedArity = 2;
    G__5155.cljs$lang$applyTo = function(arglist__5156) {
      var x = cljs.core.first(arglist__5156);
      var y = cljs.core.first(cljs.core.next(arglist__5156));
      var more = cljs.core.rest(cljs.core.next(arglist__5156));
      return G__5155__delegate(x, y, more)
    };
    G__5155.cljs$lang$arity$variadic = G__5155__delegate;
    return G__5155
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__5157__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5158 = y;
            var G__5159 = cljs.core.first.call(null, more);
            var G__5160 = cljs.core.next.call(null, more);
            x = G__5158;
            y = G__5159;
            more = G__5160;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5157 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5157__delegate.call(this, x, y, more)
    };
    G__5157.cljs$lang$maxFixedArity = 2;
    G__5157.cljs$lang$applyTo = function(arglist__5161) {
      var x = cljs.core.first(arglist__5161);
      var y = cljs.core.first(cljs.core.next(arglist__5161));
      var more = cljs.core.rest(cljs.core.next(arglist__5161));
      return G__5157__delegate(x, y, more)
    };
    G__5157.cljs$lang$arity$variadic = G__5157__delegate;
    return G__5157
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__5162__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5163 = y;
            var G__5164 = cljs.core.first.call(null, more);
            var G__5165 = cljs.core.next.call(null, more);
            x = G__5163;
            y = G__5164;
            more = G__5165;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5162 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5162__delegate.call(this, x, y, more)
    };
    G__5162.cljs$lang$maxFixedArity = 2;
    G__5162.cljs$lang$applyTo = function(arglist__5166) {
      var x = cljs.core.first(arglist__5166);
      var y = cljs.core.first(cljs.core.next(arglist__5166));
      var more = cljs.core.rest(cljs.core.next(arglist__5166));
      return G__5162__delegate(x, y, more)
    };
    G__5162.cljs$lang$arity$variadic = G__5162__delegate;
    return G__5162
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__5167__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5168 = y;
            var G__5169 = cljs.core.first.call(null, more);
            var G__5170 = cljs.core.next.call(null, more);
            x = G__5168;
            y = G__5169;
            more = G__5170;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5167 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5167__delegate.call(this, x, y, more)
    };
    G__5167.cljs$lang$maxFixedArity = 2;
    G__5167.cljs$lang$applyTo = function(arglist__5171) {
      var x = cljs.core.first(arglist__5171);
      var y = cljs.core.first(cljs.core.next(arglist__5171));
      var more = cljs.core.rest(cljs.core.next(arglist__5171));
      return G__5167__delegate(x, y, more)
    };
    G__5167.cljs$lang$arity$variadic = G__5167__delegate;
    return G__5167
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__5172__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5173 = y;
            var G__5174 = cljs.core.first.call(null, more);
            var G__5175 = cljs.core.next.call(null, more);
            x = G__5173;
            y = G__5174;
            more = G__5175;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5172 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5172__delegate.call(this, x, y, more)
    };
    G__5172.cljs$lang$maxFixedArity = 2;
    G__5172.cljs$lang$applyTo = function(arglist__5176) {
      var x = cljs.core.first(arglist__5176);
      var y = cljs.core.first(cljs.core.next(arglist__5176));
      var more = cljs.core.rest(cljs.core.next(arglist__5176));
      return G__5172__delegate(x, y, more)
    };
    G__5172.cljs$lang$arity$variadic = G__5172__delegate;
    return G__5172
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__5177__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__5177 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5177__delegate.call(this, x, y, more)
    };
    G__5177.cljs$lang$maxFixedArity = 2;
    G__5177.cljs$lang$applyTo = function(arglist__5178) {
      var x = cljs.core.first(arglist__5178);
      var y = cljs.core.first(cljs.core.next(arglist__5178));
      var more = cljs.core.rest(cljs.core.next(arglist__5178));
      return G__5177__delegate(x, y, more)
    };
    G__5177.cljs$lang$arity$variadic = G__5177__delegate;
    return G__5177
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__5179__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__5179 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5179__delegate.call(this, x, y, more)
    };
    G__5179.cljs$lang$maxFixedArity = 2;
    G__5179.cljs$lang$applyTo = function(arglist__5180) {
      var x = cljs.core.first(arglist__5180);
      var y = cljs.core.first(cljs.core.next(arglist__5180));
      var more = cljs.core.rest(cljs.core.next(arglist__5180));
      return G__5179__delegate(x, y, more)
    };
    G__5179.cljs$lang$arity$variadic = G__5179__delegate;
    return G__5179
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__5181 = n % d;
  return cljs.core.fix.call(null, (n - rem__5181) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__5182 = cljs.core.quot.call(null, n, d);
  return n - d * q__5182
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(n) {
  var c__5183 = 0;
  var n__5184 = n;
  while(true) {
    if(n__5184 === 0) {
      return c__5183
    }else {
      var G__5185 = c__5183 + 1;
      var G__5186 = n__5184 & n__5184 - 1;
      c__5183 = G__5185;
      n__5184 = G__5186;
      continue
    }
    break
  }
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__5187__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__5188 = y;
            var G__5189 = cljs.core.first.call(null, more);
            var G__5190 = cljs.core.next.call(null, more);
            x = G__5188;
            y = G__5189;
            more = G__5190;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__5187 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5187__delegate.call(this, x, y, more)
    };
    G__5187.cljs$lang$maxFixedArity = 2;
    G__5187.cljs$lang$applyTo = function(arglist__5191) {
      var x = cljs.core.first(arglist__5191);
      var y = cljs.core.first(cljs.core.next(arglist__5191));
      var more = cljs.core.rest(cljs.core.next(arglist__5191));
      return G__5187__delegate(x, y, more)
    };
    G__5187.cljs$lang$arity$variadic = G__5187__delegate;
    return G__5187
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__5192 = n;
  var xs__5193 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5194 = xs__5193;
      if(cljs.core.truth_(and__3546__auto____5194)) {
        return n__5192 > 0
      }else {
        return and__3546__auto____5194
      }
    }())) {
      var G__5195 = n__5192 - 1;
      var G__5196 = cljs.core.next.call(null, xs__5193);
      n__5192 = G__5195;
      xs__5193 = G__5196;
      continue
    }else {
      return xs__5193
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__5197__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5198 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__5199 = cljs.core.next.call(null, more);
            sb = G__5198;
            more = G__5199;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__5197 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5197__delegate.call(this, x, ys)
    };
    G__5197.cljs$lang$maxFixedArity = 1;
    G__5197.cljs$lang$applyTo = function(arglist__5200) {
      var x = cljs.core.first(arglist__5200);
      var ys = cljs.core.rest(arglist__5200);
      return G__5197__delegate(x, ys)
    };
    G__5197.cljs$lang$arity$variadic = G__5197__delegate;
    return G__5197
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__5201__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__5202 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__5203 = cljs.core.next.call(null, more);
            sb = G__5202;
            more = G__5203;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__5201 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__5201__delegate.call(this, x, ys)
    };
    G__5201.cljs$lang$maxFixedArity = 1;
    G__5201.cljs$lang$applyTo = function(arglist__5204) {
      var x = cljs.core.first(arglist__5204);
      var ys = cljs.core.rest(arglist__5204);
      return G__5201__delegate(x, ys)
    };
    G__5201.cljs$lang$arity$variadic = G__5201__delegate;
    return G__5201
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__5205 = cljs.core.seq.call(null, x);
    var ys__5206 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__5205 == null) {
        return ys__5206 == null
      }else {
        if(ys__5206 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__5205), cljs.core.first.call(null, ys__5206))) {
            var G__5207 = cljs.core.next.call(null, xs__5205);
            var G__5208 = cljs.core.next.call(null, ys__5206);
            xs__5205 = G__5207;
            ys__5206 = G__5208;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__5209_SHARP_, p2__5210_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__5209_SHARP_, cljs.core.hash.call(null, p2__5210_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
void 0;
void 0;
cljs.core.hash_imap = function hash_imap(m) {
  var h__5211 = 0;
  var s__5212 = cljs.core.seq.call(null, m);
  while(true) {
    if(cljs.core.truth_(s__5212)) {
      var e__5213 = cljs.core.first.call(null, s__5212);
      var G__5214 = (h__5211 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__5213)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__5213)))) % 4503599627370496;
      var G__5215 = cljs.core.next.call(null, s__5212);
      h__5211 = G__5214;
      s__5212 = G__5215;
      continue
    }else {
      return h__5211
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__5216 = 0;
  var s__5217 = cljs.core.seq.call(null, s);
  while(true) {
    if(cljs.core.truth_(s__5217)) {
      var e__5218 = cljs.core.first.call(null, s__5217);
      var G__5219 = (h__5216 + cljs.core.hash.call(null, e__5218)) % 4503599627370496;
      var G__5220 = cljs.core.next.call(null, s__5217);
      h__5216 = G__5219;
      s__5217 = G__5220;
      continue
    }else {
      return h__5216
    }
    break
  }
};
void 0;
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__5221__5222 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__5221__5222)) {
    var G__5224__5226 = cljs.core.first.call(null, G__5221__5222);
    var vec__5225__5227 = G__5224__5226;
    var key_name__5228 = cljs.core.nth.call(null, vec__5225__5227, 0, null);
    var f__5229 = cljs.core.nth.call(null, vec__5225__5227, 1, null);
    var G__5221__5230 = G__5221__5222;
    var G__5224__5231 = G__5224__5226;
    var G__5221__5232 = G__5221__5230;
    while(true) {
      var vec__5233__5234 = G__5224__5231;
      var key_name__5235 = cljs.core.nth.call(null, vec__5233__5234, 0, null);
      var f__5236 = cljs.core.nth.call(null, vec__5233__5234, 1, null);
      var G__5221__5237 = G__5221__5232;
      var str_name__5238 = cljs.core.name.call(null, key_name__5235);
      obj[str_name__5238] = f__5236;
      var temp__3698__auto____5239 = cljs.core.next.call(null, G__5221__5237);
      if(cljs.core.truth_(temp__3698__auto____5239)) {
        var G__5221__5240 = temp__3698__auto____5239;
        var G__5241 = cljs.core.first.call(null, G__5221__5240);
        var G__5242 = G__5221__5240;
        G__5224__5231 = G__5241;
        G__5221__5232 = G__5242;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706670
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5243 = this;
  var h__364__auto____5244 = this__5243.__hash;
  if(h__364__auto____5244 != null) {
    return h__364__auto____5244
  }else {
    var h__364__auto____5245 = cljs.core.hash_coll.call(null, coll);
    this__5243.__hash = h__364__auto____5245;
    return h__364__auto____5245
  }
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5246 = this;
  return new cljs.core.List(this__5246.meta, o, coll, this__5246.count + 1, null)
};
cljs.core.List.prototype.cljs$core$ASeq$ = true;
cljs.core.List.prototype.toString = function() {
  var this__5247 = this;
  var this$__5248 = this;
  return cljs.core.pr_str.call(null, this$__5248)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5249 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5250 = this;
  return this__5250.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5251 = this;
  return this__5251.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5252 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5253 = this;
  return this__5253.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5254 = this;
  return this__5254.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5255 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5256 = this;
  return new cljs.core.List(meta, this__5256.first, this__5256.rest, this__5256.count, this__5256.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5257 = this;
  return this__5257.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5258 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List.prototype.cljs$core$IList$ = true;
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32706638
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5259 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5260 = this;
  return new cljs.core.List(this__5260.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__5261 = this;
  var this$__5262 = this;
  return cljs.core.pr_str.call(null, this$__5262)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5263 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5264 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5265 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5266 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5267 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5268 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5269 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5270 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5271 = this;
  return this__5271.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5272 = this;
  return coll
};
cljs.core.EmptyList.prototype.cljs$core$IList$ = true;
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__5273__5274 = coll;
  if(G__5273__5274 != null) {
    if(function() {
      var or__3548__auto____5275 = G__5273__5274.cljs$lang$protocol_mask$partition0$ & 67108864;
      if(or__3548__auto____5275) {
        return or__3548__auto____5275
      }else {
        return G__5273__5274.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__5273__5274.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5273__5274)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__5273__5274)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__5276) {
    var items = cljs.core.seq(arglist__5276);
    return list__delegate(items)
  };
  list.cljs$lang$arity$variadic = list__delegate;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32702572
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5277 = this;
  var h__364__auto____5278 = this__5277.__hash;
  if(h__364__auto____5278 != null) {
    return h__364__auto____5278
  }else {
    var h__364__auto____5279 = cljs.core.hash_coll.call(null, coll);
    this__5277.__hash = h__364__auto____5279;
    return h__364__auto____5279
  }
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5280 = this;
  return new cljs.core.Cons(null, o, coll, this__5280.__hash)
};
cljs.core.Cons.prototype.cljs$core$ASeq$ = true;
cljs.core.Cons.prototype.toString = function() {
  var this__5281 = this;
  var this$__5282 = this;
  return cljs.core.pr_str.call(null, this$__5282)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5283 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5284 = this;
  return this__5284.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5285 = this;
  if(this__5285.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__5285.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5286 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5287 = this;
  return new cljs.core.Cons(meta, this__5287.first, this__5287.rest, this__5287.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5288 = this;
  return this__5288.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5289 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5289.meta)
};
cljs.core.Cons.prototype.cljs$core$IList$ = true;
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3548__auto____5290 = coll == null;
    if(or__3548__auto____5290) {
      return or__3548__auto____5290
    }else {
      var G__5291__5292 = coll;
      if(G__5291__5292 != null) {
        if(function() {
          var or__3548__auto____5293 = G__5291__5292.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3548__auto____5293) {
            return or__3548__auto____5293
          }else {
            return G__5291__5292.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__5291__5292.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5291__5292)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__5291__5292)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__5294__5295 = x;
  if(G__5294__5295 != null) {
    if(function() {
      var or__3548__auto____5296 = G__5294__5295.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3548__auto____5296) {
        return or__3548__auto____5296
      }else {
        return G__5294__5295.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__5294__5295.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5294__5295)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__5294__5295)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__5297 = null;
  var G__5297__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__5297__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__5297 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__5297__2.call(this, string, f);
      case 3:
        return G__5297__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5297
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__5298 = null;
  var G__5298__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__5298__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__5298 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5298__2.call(this, string, k);
      case 3:
        return G__5298__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5298
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__5299 = null;
  var G__5299__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__5299__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__5299 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5299__2.call(this, string, n);
      case 3:
        return G__5299__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5299
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__5308 = null;
  var G__5308__2 = function(tsym5302, coll) {
    var tsym5302__5304 = this;
    var this$__5305 = tsym5302__5304;
    return cljs.core.get.call(null, coll, this$__5305.toString())
  };
  var G__5308__3 = function(tsym5303, coll, not_found) {
    var tsym5303__5306 = this;
    var this$__5307 = tsym5303__5306;
    return cljs.core.get.call(null, coll, this$__5307.toString(), not_found)
  };
  G__5308 = function(tsym5303, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5308__2.call(this, tsym5303, coll);
      case 3:
        return G__5308__3.call(this, tsym5303, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5308
}();
String.prototype.apply = function(tsym5300, args5301) {
  return tsym5300.call.apply(tsym5300, [tsym5300].concat(cljs.core.aclone.call(null, args5301)))
};
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__5309 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__5309
  }else {
    lazy_seq.x = x__5309.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5310 = this;
  var h__364__auto____5311 = this__5310.__hash;
  if(h__364__auto____5311 != null) {
    return h__364__auto____5311
  }else {
    var h__364__auto____5312 = cljs.core.hash_coll.call(null, coll);
    this__5310.__hash = h__364__auto____5312;
    return h__364__auto____5312
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5313 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__5314 = this;
  var this$__5315 = this;
  return cljs.core.pr_str.call(null, this$__5315)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5316 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5317 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5318 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5319 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5320 = this;
  return new cljs.core.LazySeq(meta, this__5320.realized, this__5320.x, this__5320.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5321 = this;
  return this__5321.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5322 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5322.meta)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__5323 = [];
  var s__5324 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__5324))) {
      ary__5323.push(cljs.core.first.call(null, s__5324));
      var G__5325 = cljs.core.next.call(null, s__5324);
      s__5324 = G__5325;
      continue
    }else {
      return ary__5323
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__5326 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__5327 = 0;
  var xs__5328 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(xs__5328)) {
      ret__5326[i__5327] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__5328));
      var G__5329 = i__5327 + 1;
      var G__5330 = cljs.core.next.call(null, xs__5328);
      i__5327 = G__5329;
      xs__5328 = G__5330;
      continue
    }else {
    }
    break
  }
  return ret__5326
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__5331 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5332 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5333 = 0;
      var s__5334 = s__5332;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5335 = s__5334;
          if(cljs.core.truth_(and__3546__auto____5335)) {
            return i__5333 < size
          }else {
            return and__3546__auto____5335
          }
        }())) {
          a__5331[i__5333] = cljs.core.first.call(null, s__5334);
          var G__5338 = i__5333 + 1;
          var G__5339 = cljs.core.next.call(null, s__5334);
          i__5333 = G__5338;
          s__5334 = G__5339;
          continue
        }else {
          return a__5331
        }
        break
      }
    }else {
      var n__685__auto____5336 = size;
      var i__5337 = 0;
      while(true) {
        if(i__5337 < n__685__auto____5336) {
          a__5331[i__5337] = init_val_or_seq;
          var G__5340 = i__5337 + 1;
          i__5337 = G__5340;
          continue
        }else {
        }
        break
      }
      return a__5331
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__5341 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5342 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5343 = 0;
      var s__5344 = s__5342;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5345 = s__5344;
          if(cljs.core.truth_(and__3546__auto____5345)) {
            return i__5343 < size
          }else {
            return and__3546__auto____5345
          }
        }())) {
          a__5341[i__5343] = cljs.core.first.call(null, s__5344);
          var G__5348 = i__5343 + 1;
          var G__5349 = cljs.core.next.call(null, s__5344);
          i__5343 = G__5348;
          s__5344 = G__5349;
          continue
        }else {
          return a__5341
        }
        break
      }
    }else {
      var n__685__auto____5346 = size;
      var i__5347 = 0;
      while(true) {
        if(i__5347 < n__685__auto____5346) {
          a__5341[i__5347] = init_val_or_seq;
          var G__5350 = i__5347 + 1;
          i__5347 = G__5350;
          continue
        }else {
        }
        break
      }
      return a__5341
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__5351 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__5352 = cljs.core.seq.call(null, init_val_or_seq);
      var i__5353 = 0;
      var s__5354 = s__5352;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3546__auto____5355 = s__5354;
          if(cljs.core.truth_(and__3546__auto____5355)) {
            return i__5353 < size
          }else {
            return and__3546__auto____5355
          }
        }())) {
          a__5351[i__5353] = cljs.core.first.call(null, s__5354);
          var G__5358 = i__5353 + 1;
          var G__5359 = cljs.core.next.call(null, s__5354);
          i__5353 = G__5358;
          s__5354 = G__5359;
          continue
        }else {
          return a__5351
        }
        break
      }
    }else {
      var n__685__auto____5356 = size;
      var i__5357 = 0;
      while(true) {
        if(i__5357 < n__685__auto____5356) {
          a__5351[i__5357] = init_val_or_seq;
          var G__5360 = i__5357 + 1;
          i__5357 = G__5360;
          continue
        }else {
        }
        break
      }
      return a__5351
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__5361 = s;
    var i__5362 = n;
    var sum__5363 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____5364 = i__5362 > 0;
        if(and__3546__auto____5364) {
          return cljs.core.seq.call(null, s__5361)
        }else {
          return and__3546__auto____5364
        }
      }())) {
        var G__5365 = cljs.core.next.call(null, s__5361);
        var G__5366 = i__5362 - 1;
        var G__5367 = sum__5363 + 1;
        s__5361 = G__5365;
        i__5362 = G__5366;
        sum__5363 = G__5367;
        continue
      }else {
        return sum__5363
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__5368 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__5368)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5368), concat.call(null, cljs.core.rest.call(null, s__5368), y))
      }else {
        return y
      }
    })
  };
  var concat__3 = function() {
    var G__5371__delegate = function(x, y, zs) {
      var cat__5370 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__5369 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__5369)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__5369), cat.call(null, cljs.core.rest.call(null, xys__5369), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__5370.call(null, concat.call(null, x, y), zs)
    };
    var G__5371 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5371__delegate.call(this, x, y, zs)
    };
    G__5371.cljs$lang$maxFixedArity = 2;
    G__5371.cljs$lang$applyTo = function(arglist__5372) {
      var x = cljs.core.first(arglist__5372);
      var y = cljs.core.first(cljs.core.next(arglist__5372));
      var zs = cljs.core.rest(cljs.core.next(arglist__5372));
      return G__5371__delegate(x, y, zs)
    };
    G__5371.cljs$lang$arity$variadic = G__5371__delegate;
    return G__5371
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__5373__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__5373 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5373__delegate.call(this, a, b, c, d, more)
    };
    G__5373.cljs$lang$maxFixedArity = 4;
    G__5373.cljs$lang$applyTo = function(arglist__5374) {
      var a = cljs.core.first(arglist__5374);
      var b = cljs.core.first(cljs.core.next(arglist__5374));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5374)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5374))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5374))));
      return G__5373__delegate(a, b, c, d, more)
    };
    G__5373.cljs$lang$arity$variadic = G__5373__delegate;
    return G__5373
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
void 0;
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__5375 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__5376 = cljs.core._first.call(null, args__5375);
    var args__5377 = cljs.core._rest.call(null, args__5375);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__5376)
      }else {
        return f.call(null, a__5376)
      }
    }else {
      var b__5378 = cljs.core._first.call(null, args__5377);
      var args__5379 = cljs.core._rest.call(null, args__5377);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__5376, b__5378)
        }else {
          return f.call(null, a__5376, b__5378)
        }
      }else {
        var c__5380 = cljs.core._first.call(null, args__5379);
        var args__5381 = cljs.core._rest.call(null, args__5379);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__5376, b__5378, c__5380)
          }else {
            return f.call(null, a__5376, b__5378, c__5380)
          }
        }else {
          var d__5382 = cljs.core._first.call(null, args__5381);
          var args__5383 = cljs.core._rest.call(null, args__5381);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__5376, b__5378, c__5380, d__5382)
            }else {
              return f.call(null, a__5376, b__5378, c__5380, d__5382)
            }
          }else {
            var e__5384 = cljs.core._first.call(null, args__5383);
            var args__5385 = cljs.core._rest.call(null, args__5383);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__5376, b__5378, c__5380, d__5382, e__5384)
              }else {
                return f.call(null, a__5376, b__5378, c__5380, d__5382, e__5384)
              }
            }else {
              var f__5386 = cljs.core._first.call(null, args__5385);
              var args__5387 = cljs.core._rest.call(null, args__5385);
              if(argc === 6) {
                if(f__5386.cljs$lang$arity$6) {
                  return f__5386.cljs$lang$arity$6(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386)
                }else {
                  return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386)
                }
              }else {
                var g__5388 = cljs.core._first.call(null, args__5387);
                var args__5389 = cljs.core._rest.call(null, args__5387);
                if(argc === 7) {
                  if(f__5386.cljs$lang$arity$7) {
                    return f__5386.cljs$lang$arity$7(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388)
                  }else {
                    return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388)
                  }
                }else {
                  var h__5390 = cljs.core._first.call(null, args__5389);
                  var args__5391 = cljs.core._rest.call(null, args__5389);
                  if(argc === 8) {
                    if(f__5386.cljs$lang$arity$8) {
                      return f__5386.cljs$lang$arity$8(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390)
                    }else {
                      return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390)
                    }
                  }else {
                    var i__5392 = cljs.core._first.call(null, args__5391);
                    var args__5393 = cljs.core._rest.call(null, args__5391);
                    if(argc === 9) {
                      if(f__5386.cljs$lang$arity$9) {
                        return f__5386.cljs$lang$arity$9(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392)
                      }else {
                        return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392)
                      }
                    }else {
                      var j__5394 = cljs.core._first.call(null, args__5393);
                      var args__5395 = cljs.core._rest.call(null, args__5393);
                      if(argc === 10) {
                        if(f__5386.cljs$lang$arity$10) {
                          return f__5386.cljs$lang$arity$10(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394)
                        }else {
                          return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394)
                        }
                      }else {
                        var k__5396 = cljs.core._first.call(null, args__5395);
                        var args__5397 = cljs.core._rest.call(null, args__5395);
                        if(argc === 11) {
                          if(f__5386.cljs$lang$arity$11) {
                            return f__5386.cljs$lang$arity$11(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396)
                          }else {
                            return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396)
                          }
                        }else {
                          var l__5398 = cljs.core._first.call(null, args__5397);
                          var args__5399 = cljs.core._rest.call(null, args__5397);
                          if(argc === 12) {
                            if(f__5386.cljs$lang$arity$12) {
                              return f__5386.cljs$lang$arity$12(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398)
                            }else {
                              return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398)
                            }
                          }else {
                            var m__5400 = cljs.core._first.call(null, args__5399);
                            var args__5401 = cljs.core._rest.call(null, args__5399);
                            if(argc === 13) {
                              if(f__5386.cljs$lang$arity$13) {
                                return f__5386.cljs$lang$arity$13(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400)
                              }else {
                                return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400)
                              }
                            }else {
                              var n__5402 = cljs.core._first.call(null, args__5401);
                              var args__5403 = cljs.core._rest.call(null, args__5401);
                              if(argc === 14) {
                                if(f__5386.cljs$lang$arity$14) {
                                  return f__5386.cljs$lang$arity$14(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402)
                                }else {
                                  return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402)
                                }
                              }else {
                                var o__5404 = cljs.core._first.call(null, args__5403);
                                var args__5405 = cljs.core._rest.call(null, args__5403);
                                if(argc === 15) {
                                  if(f__5386.cljs$lang$arity$15) {
                                    return f__5386.cljs$lang$arity$15(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404)
                                  }else {
                                    return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404)
                                  }
                                }else {
                                  var p__5406 = cljs.core._first.call(null, args__5405);
                                  var args__5407 = cljs.core._rest.call(null, args__5405);
                                  if(argc === 16) {
                                    if(f__5386.cljs$lang$arity$16) {
                                      return f__5386.cljs$lang$arity$16(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406)
                                    }else {
                                      return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406)
                                    }
                                  }else {
                                    var q__5408 = cljs.core._first.call(null, args__5407);
                                    var args__5409 = cljs.core._rest.call(null, args__5407);
                                    if(argc === 17) {
                                      if(f__5386.cljs$lang$arity$17) {
                                        return f__5386.cljs$lang$arity$17(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406, q__5408)
                                      }else {
                                        return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406, q__5408)
                                      }
                                    }else {
                                      var r__5410 = cljs.core._first.call(null, args__5409);
                                      var args__5411 = cljs.core._rest.call(null, args__5409);
                                      if(argc === 18) {
                                        if(f__5386.cljs$lang$arity$18) {
                                          return f__5386.cljs$lang$arity$18(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406, q__5408, r__5410)
                                        }else {
                                          return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406, q__5408, r__5410)
                                        }
                                      }else {
                                        var s__5412 = cljs.core._first.call(null, args__5411);
                                        var args__5413 = cljs.core._rest.call(null, args__5411);
                                        if(argc === 19) {
                                          if(f__5386.cljs$lang$arity$19) {
                                            return f__5386.cljs$lang$arity$19(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406, q__5408, r__5410, s__5412)
                                          }else {
                                            return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406, q__5408, r__5410, s__5412)
                                          }
                                        }else {
                                          var t__5414 = cljs.core._first.call(null, args__5413);
                                          var args__5415 = cljs.core._rest.call(null, args__5413);
                                          if(argc === 20) {
                                            if(f__5386.cljs$lang$arity$20) {
                                              return f__5386.cljs$lang$arity$20(a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406, q__5408, r__5410, s__5412, t__5414)
                                            }else {
                                              return f__5386.call(null, a__5376, b__5378, c__5380, d__5382, e__5384, f__5386, g__5388, h__5390, i__5392, j__5394, k__5396, l__5398, m__5400, n__5402, o__5404, p__5406, q__5408, r__5410, s__5412, t__5414)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
void 0;
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__5416 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5417 = cljs.core.bounded_count.call(null, args, fixed_arity__5416 + 1);
      if(bc__5417 <= fixed_arity__5416) {
        return cljs.core.apply_to.call(null, f, bc__5417, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__5418 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__5419 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5420 = cljs.core.bounded_count.call(null, arglist__5418, fixed_arity__5419 + 1);
      if(bc__5420 <= fixed_arity__5419) {
        return cljs.core.apply_to.call(null, f, bc__5420, arglist__5418)
      }else {
        return f.cljs$lang$applyTo(arglist__5418)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5418))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__5421 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__5422 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5423 = cljs.core.bounded_count.call(null, arglist__5421, fixed_arity__5422 + 1);
      if(bc__5423 <= fixed_arity__5422) {
        return cljs.core.apply_to.call(null, f, bc__5423, arglist__5421)
      }else {
        return f.cljs$lang$applyTo(arglist__5421)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5421))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__5424 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__5425 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__5426 = cljs.core.bounded_count.call(null, arglist__5424, fixed_arity__5425 + 1);
      if(bc__5426 <= fixed_arity__5425) {
        return cljs.core.apply_to.call(null, f, bc__5426, arglist__5424)
      }else {
        return f.cljs$lang$applyTo(arglist__5424)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__5424))
    }
  };
  var apply__6 = function() {
    var G__5430__delegate = function(f, a, b, c, d, args) {
      var arglist__5427 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__5428 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__5429 = cljs.core.bounded_count.call(null, arglist__5427, fixed_arity__5428 + 1);
        if(bc__5429 <= fixed_arity__5428) {
          return cljs.core.apply_to.call(null, f, bc__5429, arglist__5427)
        }else {
          return f.cljs$lang$applyTo(arglist__5427)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__5427))
      }
    };
    var G__5430 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__5430__delegate.call(this, f, a, b, c, d, args)
    };
    G__5430.cljs$lang$maxFixedArity = 5;
    G__5430.cljs$lang$applyTo = function(arglist__5431) {
      var f = cljs.core.first(arglist__5431);
      var a = cljs.core.first(cljs.core.next(arglist__5431));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5431)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5431))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5431)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5431)))));
      return G__5430__delegate(f, a, b, c, d, args)
    };
    G__5430.cljs$lang$arity$variadic = G__5430__delegate;
    return G__5430
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__5432) {
    var obj = cljs.core.first(arglist__5432);
    var f = cljs.core.first(cljs.core.next(arglist__5432));
    var args = cljs.core.rest(cljs.core.next(arglist__5432));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3 = function() {
    var G__5433__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__5433 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5433__delegate.call(this, x, y, more)
    };
    G__5433.cljs$lang$maxFixedArity = 2;
    G__5433.cljs$lang$applyTo = function(arglist__5434) {
      var x = cljs.core.first(arglist__5434);
      var y = cljs.core.first(cljs.core.next(arglist__5434));
      var more = cljs.core.rest(cljs.core.next(arglist__5434));
      return G__5433__delegate(x, y, more)
    };
    G__5433.cljs$lang$arity$variadic = G__5433__delegate;
    return G__5433
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__5435 = pred;
        var G__5436 = cljs.core.next.call(null, coll);
        pred = G__5435;
        coll = G__5436;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____5437 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____5437)) {
        return or__3548__auto____5437
      }else {
        var G__5438 = pred;
        var G__5439 = cljs.core.next.call(null, coll);
        pred = G__5438;
        coll = G__5439;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__5440 = null;
    var G__5440__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__5440__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__5440__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__5440__3 = function() {
      var G__5441__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__5441 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__5441__delegate.call(this, x, y, zs)
      };
      G__5441.cljs$lang$maxFixedArity = 2;
      G__5441.cljs$lang$applyTo = function(arglist__5442) {
        var x = cljs.core.first(arglist__5442);
        var y = cljs.core.first(cljs.core.next(arglist__5442));
        var zs = cljs.core.rest(cljs.core.next(arglist__5442));
        return G__5441__delegate(x, y, zs)
      };
      G__5441.cljs$lang$arity$variadic = G__5441__delegate;
      return G__5441
    }();
    G__5440 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5440__0.call(this);
        case 1:
          return G__5440__1.call(this, x);
        case 2:
          return G__5440__2.call(this, x, y);
        default:
          return G__5440__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__5440.cljs$lang$maxFixedArity = 2;
    G__5440.cljs$lang$applyTo = G__5440__3.cljs$lang$applyTo;
    return G__5440
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__5443__delegate = function(args) {
      return x
    };
    var G__5443 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__5443__delegate.call(this, args)
    };
    G__5443.cljs$lang$maxFixedArity = 0;
    G__5443.cljs$lang$applyTo = function(arglist__5444) {
      var args = cljs.core.seq(arglist__5444);
      return G__5443__delegate(args)
    };
    G__5443.cljs$lang$arity$variadic = G__5443__delegate;
    return G__5443
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__5448 = null;
      var G__5448__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__5448__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__5448__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__5448__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__5448__4 = function() {
        var G__5449__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__5449 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5449__delegate.call(this, x, y, z, args)
        };
        G__5449.cljs$lang$maxFixedArity = 3;
        G__5449.cljs$lang$applyTo = function(arglist__5450) {
          var x = cljs.core.first(arglist__5450);
          var y = cljs.core.first(cljs.core.next(arglist__5450));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5450)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5450)));
          return G__5449__delegate(x, y, z, args)
        };
        G__5449.cljs$lang$arity$variadic = G__5449__delegate;
        return G__5449
      }();
      G__5448 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5448__0.call(this);
          case 1:
            return G__5448__1.call(this, x);
          case 2:
            return G__5448__2.call(this, x, y);
          case 3:
            return G__5448__3.call(this, x, y, z);
          default:
            return G__5448__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5448.cljs$lang$maxFixedArity = 3;
      G__5448.cljs$lang$applyTo = G__5448__4.cljs$lang$applyTo;
      return G__5448
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__5451 = null;
      var G__5451__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__5451__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__5451__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__5451__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__5451__4 = function() {
        var G__5452__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__5452 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5452__delegate.call(this, x, y, z, args)
        };
        G__5452.cljs$lang$maxFixedArity = 3;
        G__5452.cljs$lang$applyTo = function(arglist__5453) {
          var x = cljs.core.first(arglist__5453);
          var y = cljs.core.first(cljs.core.next(arglist__5453));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5453)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5453)));
          return G__5452__delegate(x, y, z, args)
        };
        G__5452.cljs$lang$arity$variadic = G__5452__delegate;
        return G__5452
      }();
      G__5451 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__5451__0.call(this);
          case 1:
            return G__5451__1.call(this, x);
          case 2:
            return G__5451__2.call(this, x, y);
          case 3:
            return G__5451__3.call(this, x, y, z);
          default:
            return G__5451__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5451.cljs$lang$maxFixedArity = 3;
      G__5451.cljs$lang$applyTo = G__5451__4.cljs$lang$applyTo;
      return G__5451
    }()
  };
  var comp__4 = function() {
    var G__5454__delegate = function(f1, f2, f3, fs) {
      var fs__5445 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__5455__delegate = function(args) {
          var ret__5446 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__5445), args);
          var fs__5447 = cljs.core.next.call(null, fs__5445);
          while(true) {
            if(cljs.core.truth_(fs__5447)) {
              var G__5456 = cljs.core.first.call(null, fs__5447).call(null, ret__5446);
              var G__5457 = cljs.core.next.call(null, fs__5447);
              ret__5446 = G__5456;
              fs__5447 = G__5457;
              continue
            }else {
              return ret__5446
            }
            break
          }
        };
        var G__5455 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5455__delegate.call(this, args)
        };
        G__5455.cljs$lang$maxFixedArity = 0;
        G__5455.cljs$lang$applyTo = function(arglist__5458) {
          var args = cljs.core.seq(arglist__5458);
          return G__5455__delegate(args)
        };
        G__5455.cljs$lang$arity$variadic = G__5455__delegate;
        return G__5455
      }()
    };
    var G__5454 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5454__delegate.call(this, f1, f2, f3, fs)
    };
    G__5454.cljs$lang$maxFixedArity = 3;
    G__5454.cljs$lang$applyTo = function(arglist__5459) {
      var f1 = cljs.core.first(arglist__5459);
      var f2 = cljs.core.first(cljs.core.next(arglist__5459));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5459)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5459)));
      return G__5454__delegate(f1, f2, f3, fs)
    };
    G__5454.cljs$lang$arity$variadic = G__5454__delegate;
    return G__5454
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__5460__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__5460 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5460__delegate.call(this, args)
      };
      G__5460.cljs$lang$maxFixedArity = 0;
      G__5460.cljs$lang$applyTo = function(arglist__5461) {
        var args = cljs.core.seq(arglist__5461);
        return G__5460__delegate(args)
      };
      G__5460.cljs$lang$arity$variadic = G__5460__delegate;
      return G__5460
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__5462__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__5462 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5462__delegate.call(this, args)
      };
      G__5462.cljs$lang$maxFixedArity = 0;
      G__5462.cljs$lang$applyTo = function(arglist__5463) {
        var args = cljs.core.seq(arglist__5463);
        return G__5462__delegate(args)
      };
      G__5462.cljs$lang$arity$variadic = G__5462__delegate;
      return G__5462
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__5464__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__5464 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__5464__delegate.call(this, args)
      };
      G__5464.cljs$lang$maxFixedArity = 0;
      G__5464.cljs$lang$applyTo = function(arglist__5465) {
        var args = cljs.core.seq(arglist__5465);
        return G__5464__delegate(args)
      };
      G__5464.cljs$lang$arity$variadic = G__5464__delegate;
      return G__5464
    }()
  };
  var partial__5 = function() {
    var G__5466__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__5467__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__5467 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__5467__delegate.call(this, args)
        };
        G__5467.cljs$lang$maxFixedArity = 0;
        G__5467.cljs$lang$applyTo = function(arglist__5468) {
          var args = cljs.core.seq(arglist__5468);
          return G__5467__delegate(args)
        };
        G__5467.cljs$lang$arity$variadic = G__5467__delegate;
        return G__5467
      }()
    };
    var G__5466 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5466__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__5466.cljs$lang$maxFixedArity = 4;
    G__5466.cljs$lang$applyTo = function(arglist__5469) {
      var f = cljs.core.first(arglist__5469);
      var arg1 = cljs.core.first(cljs.core.next(arglist__5469));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5469)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5469))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5469))));
      return G__5466__delegate(f, arg1, arg2, arg3, more)
    };
    G__5466.cljs$lang$arity$variadic = G__5466__delegate;
    return G__5466
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__5470 = null;
      var G__5470__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__5470__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__5470__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__5470__4 = function() {
        var G__5471__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__5471 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5471__delegate.call(this, a, b, c, ds)
        };
        G__5471.cljs$lang$maxFixedArity = 3;
        G__5471.cljs$lang$applyTo = function(arglist__5472) {
          var a = cljs.core.first(arglist__5472);
          var b = cljs.core.first(cljs.core.next(arglist__5472));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5472)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5472)));
          return G__5471__delegate(a, b, c, ds)
        };
        G__5471.cljs$lang$arity$variadic = G__5471__delegate;
        return G__5471
      }();
      G__5470 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__5470__1.call(this, a);
          case 2:
            return G__5470__2.call(this, a, b);
          case 3:
            return G__5470__3.call(this, a, b, c);
          default:
            return G__5470__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5470.cljs$lang$maxFixedArity = 3;
      G__5470.cljs$lang$applyTo = G__5470__4.cljs$lang$applyTo;
      return G__5470
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__5473 = null;
      var G__5473__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5473__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__5473__4 = function() {
        var G__5474__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__5474 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5474__delegate.call(this, a, b, c, ds)
        };
        G__5474.cljs$lang$maxFixedArity = 3;
        G__5474.cljs$lang$applyTo = function(arglist__5475) {
          var a = cljs.core.first(arglist__5475);
          var b = cljs.core.first(cljs.core.next(arglist__5475));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5475)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5475)));
          return G__5474__delegate(a, b, c, ds)
        };
        G__5474.cljs$lang$arity$variadic = G__5474__delegate;
        return G__5474
      }();
      G__5473 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5473__2.call(this, a, b);
          case 3:
            return G__5473__3.call(this, a, b, c);
          default:
            return G__5473__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5473.cljs$lang$maxFixedArity = 3;
      G__5473.cljs$lang$applyTo = G__5473__4.cljs$lang$applyTo;
      return G__5473
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__5476 = null;
      var G__5476__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__5476__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__5476__4 = function() {
        var G__5477__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__5477 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5477__delegate.call(this, a, b, c, ds)
        };
        G__5477.cljs$lang$maxFixedArity = 3;
        G__5477.cljs$lang$applyTo = function(arglist__5478) {
          var a = cljs.core.first(arglist__5478);
          var b = cljs.core.first(cljs.core.next(arglist__5478));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5478)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5478)));
          return G__5477__delegate(a, b, c, ds)
        };
        G__5477.cljs$lang$arity$variadic = G__5477__delegate;
        return G__5477
      }();
      G__5476 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__5476__2.call(this, a, b);
          case 3:
            return G__5476__3.call(this, a, b, c);
          default:
            return G__5476__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__5476.cljs$lang$maxFixedArity = 3;
      G__5476.cljs$lang$applyTo = G__5476__4.cljs$lang$applyTo;
      return G__5476
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__5481 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5479 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5479)) {
        var s__5480 = temp__3698__auto____5479;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__5480)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__5480)))
      }else {
        return null
      }
    })
  };
  return mapi__5481.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5482 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5482)) {
      var s__5483 = temp__3698__auto____5482;
      var x__5484 = f.call(null, cljs.core.first.call(null, s__5483));
      if(x__5484 == null) {
        return keep.call(null, f, cljs.core.rest.call(null, s__5483))
      }else {
        return cljs.core.cons.call(null, x__5484, keep.call(null, f, cljs.core.rest.call(null, s__5483)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__5494 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5491 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5491)) {
        var s__5492 = temp__3698__auto____5491;
        var x__5493 = f.call(null, idx, cljs.core.first.call(null, s__5492));
        if(x__5493 == null) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5492))
        }else {
          return cljs.core.cons.call(null, x__5493, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__5492)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__5494.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5501 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5501)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____5501
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5502 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5502)) {
            var and__3546__auto____5503 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5503)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____5503
            }
          }else {
            return and__3546__auto____5502
          }
        }())
      };
      var ep1__4 = function() {
        var G__5539__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5504 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5504)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____5504
            }
          }())
        };
        var G__5539 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5539__delegate.call(this, x, y, z, args)
        };
        G__5539.cljs$lang$maxFixedArity = 3;
        G__5539.cljs$lang$applyTo = function(arglist__5540) {
          var x = cljs.core.first(arglist__5540);
          var y = cljs.core.first(cljs.core.next(arglist__5540));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5540)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5540)));
          return G__5539__delegate(x, y, z, args)
        };
        G__5539.cljs$lang$arity$variadic = G__5539__delegate;
        return G__5539
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5505 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5505)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____5505
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5506 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5506)) {
            var and__3546__auto____5507 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5507)) {
              var and__3546__auto____5508 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5508)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____5508
              }
            }else {
              return and__3546__auto____5507
            }
          }else {
            return and__3546__auto____5506
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5509 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5509)) {
            var and__3546__auto____5510 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____5510)) {
              var and__3546__auto____5511 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____5511)) {
                var and__3546__auto____5512 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____5512)) {
                  var and__3546__auto____5513 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5513)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____5513
                  }
                }else {
                  return and__3546__auto____5512
                }
              }else {
                return and__3546__auto____5511
              }
            }else {
              return and__3546__auto____5510
            }
          }else {
            return and__3546__auto____5509
          }
        }())
      };
      var ep2__4 = function() {
        var G__5541__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5514 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5514)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5485_SHARP_) {
                var and__3546__auto____5515 = p1.call(null, p1__5485_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5515)) {
                  return p2.call(null, p1__5485_SHARP_)
                }else {
                  return and__3546__auto____5515
                }
              }, args)
            }else {
              return and__3546__auto____5514
            }
          }())
        };
        var G__5541 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5541__delegate.call(this, x, y, z, args)
        };
        G__5541.cljs$lang$maxFixedArity = 3;
        G__5541.cljs$lang$applyTo = function(arglist__5542) {
          var x = cljs.core.first(arglist__5542);
          var y = cljs.core.first(cljs.core.next(arglist__5542));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5542)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5542)));
          return G__5541__delegate(x, y, z, args)
        };
        G__5541.cljs$lang$arity$variadic = G__5541__delegate;
        return G__5541
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5516 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5516)) {
            var and__3546__auto____5517 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5517)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____5517
            }
          }else {
            return and__3546__auto____5516
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5518 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5518)) {
            var and__3546__auto____5519 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5519)) {
              var and__3546__auto____5520 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5520)) {
                var and__3546__auto____5521 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5521)) {
                  var and__3546__auto____5522 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5522)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____5522
                  }
                }else {
                  return and__3546__auto____5521
                }
              }else {
                return and__3546__auto____5520
              }
            }else {
              return and__3546__auto____5519
            }
          }else {
            return and__3546__auto____5518
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____5523 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____5523)) {
            var and__3546__auto____5524 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5524)) {
              var and__3546__auto____5525 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____5525)) {
                var and__3546__auto____5526 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____5526)) {
                  var and__3546__auto____5527 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____5527)) {
                    var and__3546__auto____5528 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____5528)) {
                      var and__3546__auto____5529 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____5529)) {
                        var and__3546__auto____5530 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____5530)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____5530
                        }
                      }else {
                        return and__3546__auto____5529
                      }
                    }else {
                      return and__3546__auto____5528
                    }
                  }else {
                    return and__3546__auto____5527
                  }
                }else {
                  return and__3546__auto____5526
                }
              }else {
                return and__3546__auto____5525
              }
            }else {
              return and__3546__auto____5524
            }
          }else {
            return and__3546__auto____5523
          }
        }())
      };
      var ep3__4 = function() {
        var G__5543__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____5531 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____5531)) {
              return cljs.core.every_QMARK_.call(null, function(p1__5486_SHARP_) {
                var and__3546__auto____5532 = p1.call(null, p1__5486_SHARP_);
                if(cljs.core.truth_(and__3546__auto____5532)) {
                  var and__3546__auto____5533 = p2.call(null, p1__5486_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____5533)) {
                    return p3.call(null, p1__5486_SHARP_)
                  }else {
                    return and__3546__auto____5533
                  }
                }else {
                  return and__3546__auto____5532
                }
              }, args)
            }else {
              return and__3546__auto____5531
            }
          }())
        };
        var G__5543 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5543__delegate.call(this, x, y, z, args)
        };
        G__5543.cljs$lang$maxFixedArity = 3;
        G__5543.cljs$lang$applyTo = function(arglist__5544) {
          var x = cljs.core.first(arglist__5544);
          var y = cljs.core.first(cljs.core.next(arglist__5544));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5544)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5544)));
          return G__5543__delegate(x, y, z, args)
        };
        G__5543.cljs$lang$arity$variadic = G__5543__delegate;
        return G__5543
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__5545__delegate = function(p1, p2, p3, ps) {
      var ps__5534 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__5487_SHARP_) {
            return p1__5487_SHARP_.call(null, x)
          }, ps__5534)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__5488_SHARP_) {
            var and__3546__auto____5535 = p1__5488_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5535)) {
              return p1__5488_SHARP_.call(null, y)
            }else {
              return and__3546__auto____5535
            }
          }, ps__5534)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__5489_SHARP_) {
            var and__3546__auto____5536 = p1__5489_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____5536)) {
              var and__3546__auto____5537 = p1__5489_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____5537)) {
                return p1__5489_SHARP_.call(null, z)
              }else {
                return and__3546__auto____5537
              }
            }else {
              return and__3546__auto____5536
            }
          }, ps__5534)
        };
        var epn__4 = function() {
          var G__5546__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____5538 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____5538)) {
                return cljs.core.every_QMARK_.call(null, function(p1__5490_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__5490_SHARP_, args)
                }, ps__5534)
              }else {
                return and__3546__auto____5538
              }
            }())
          };
          var G__5546 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5546__delegate.call(this, x, y, z, args)
          };
          G__5546.cljs$lang$maxFixedArity = 3;
          G__5546.cljs$lang$applyTo = function(arglist__5547) {
            var x = cljs.core.first(arglist__5547);
            var y = cljs.core.first(cljs.core.next(arglist__5547));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5547)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5547)));
            return G__5546__delegate(x, y, z, args)
          };
          G__5546.cljs$lang$arity$variadic = G__5546__delegate;
          return G__5546
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__5545 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5545__delegate.call(this, p1, p2, p3, ps)
    };
    G__5545.cljs$lang$maxFixedArity = 3;
    G__5545.cljs$lang$applyTo = function(arglist__5548) {
      var p1 = cljs.core.first(arglist__5548);
      var p2 = cljs.core.first(cljs.core.next(arglist__5548));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5548)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5548)));
      return G__5545__delegate(p1, p2, p3, ps)
    };
    G__5545.cljs$lang$arity$variadic = G__5545__delegate;
    return G__5545
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3548__auto____5550 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5550)) {
          return or__3548__auto____5550
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3548__auto____5551 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5551)) {
          return or__3548__auto____5551
        }else {
          var or__3548__auto____5552 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5552)) {
            return or__3548__auto____5552
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__5588__delegate = function(x, y, z, args) {
          var or__3548__auto____5553 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5553)) {
            return or__3548__auto____5553
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__5588 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5588__delegate.call(this, x, y, z, args)
        };
        G__5588.cljs$lang$maxFixedArity = 3;
        G__5588.cljs$lang$applyTo = function(arglist__5589) {
          var x = cljs.core.first(arglist__5589);
          var y = cljs.core.first(cljs.core.next(arglist__5589));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5589)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5589)));
          return G__5588__delegate(x, y, z, args)
        };
        G__5588.cljs$lang$arity$variadic = G__5588__delegate;
        return G__5588
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3548__auto____5554 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5554)) {
          return or__3548__auto____5554
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3548__auto____5555 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5555)) {
          return or__3548__auto____5555
        }else {
          var or__3548__auto____5556 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5556)) {
            return or__3548__auto____5556
          }else {
            var or__3548__auto____5557 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5557)) {
              return or__3548__auto____5557
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3548__auto____5558 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5558)) {
          return or__3548__auto____5558
        }else {
          var or__3548__auto____5559 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____5559)) {
            return or__3548__auto____5559
          }else {
            var or__3548__auto____5560 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____5560)) {
              return or__3548__auto____5560
            }else {
              var or__3548__auto____5561 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____5561)) {
                return or__3548__auto____5561
              }else {
                var or__3548__auto____5562 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5562)) {
                  return or__3548__auto____5562
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__5590__delegate = function(x, y, z, args) {
          var or__3548__auto____5563 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5563)) {
            return or__3548__auto____5563
          }else {
            return cljs.core.some.call(null, function(p1__5495_SHARP_) {
              var or__3548__auto____5564 = p1.call(null, p1__5495_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5564)) {
                return or__3548__auto____5564
              }else {
                return p2.call(null, p1__5495_SHARP_)
              }
            }, args)
          }
        };
        var G__5590 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5590__delegate.call(this, x, y, z, args)
        };
        G__5590.cljs$lang$maxFixedArity = 3;
        G__5590.cljs$lang$applyTo = function(arglist__5591) {
          var x = cljs.core.first(arglist__5591);
          var y = cljs.core.first(cljs.core.next(arglist__5591));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5591)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5591)));
          return G__5590__delegate(x, y, z, args)
        };
        G__5590.cljs$lang$arity$variadic = G__5590__delegate;
        return G__5590
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3548__auto____5565 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5565)) {
          return or__3548__auto____5565
        }else {
          var or__3548__auto____5566 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5566)) {
            return or__3548__auto____5566
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3548__auto____5567 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5567)) {
          return or__3548__auto____5567
        }else {
          var or__3548__auto____5568 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5568)) {
            return or__3548__auto____5568
          }else {
            var or__3548__auto____5569 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5569)) {
              return or__3548__auto____5569
            }else {
              var or__3548__auto____5570 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5570)) {
                return or__3548__auto____5570
              }else {
                var or__3548__auto____5571 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5571)) {
                  return or__3548__auto____5571
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3548__auto____5572 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____5572)) {
          return or__3548__auto____5572
        }else {
          var or__3548__auto____5573 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____5573)) {
            return or__3548__auto____5573
          }else {
            var or__3548__auto____5574 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5574)) {
              return or__3548__auto____5574
            }else {
              var or__3548__auto____5575 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5575)) {
                return or__3548__auto____5575
              }else {
                var or__3548__auto____5576 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____5576)) {
                  return or__3548__auto____5576
                }else {
                  var or__3548__auto____5577 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____5577)) {
                    return or__3548__auto____5577
                  }else {
                    var or__3548__auto____5578 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____5578)) {
                      return or__3548__auto____5578
                    }else {
                      var or__3548__auto____5579 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____5579)) {
                        return or__3548__auto____5579
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__5592__delegate = function(x, y, z, args) {
          var or__3548__auto____5580 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____5580)) {
            return or__3548__auto____5580
          }else {
            return cljs.core.some.call(null, function(p1__5496_SHARP_) {
              var or__3548__auto____5581 = p1.call(null, p1__5496_SHARP_);
              if(cljs.core.truth_(or__3548__auto____5581)) {
                return or__3548__auto____5581
              }else {
                var or__3548__auto____5582 = p2.call(null, p1__5496_SHARP_);
                if(cljs.core.truth_(or__3548__auto____5582)) {
                  return or__3548__auto____5582
                }else {
                  return p3.call(null, p1__5496_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__5592 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__5592__delegate.call(this, x, y, z, args)
        };
        G__5592.cljs$lang$maxFixedArity = 3;
        G__5592.cljs$lang$applyTo = function(arglist__5593) {
          var x = cljs.core.first(arglist__5593);
          var y = cljs.core.first(cljs.core.next(arglist__5593));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5593)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5593)));
          return G__5592__delegate(x, y, z, args)
        };
        G__5592.cljs$lang$arity$variadic = G__5592__delegate;
        return G__5592
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__5594__delegate = function(p1, p2, p3, ps) {
      var ps__5583 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__5497_SHARP_) {
            return p1__5497_SHARP_.call(null, x)
          }, ps__5583)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__5498_SHARP_) {
            var or__3548__auto____5584 = p1__5498_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5584)) {
              return or__3548__auto____5584
            }else {
              return p1__5498_SHARP_.call(null, y)
            }
          }, ps__5583)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__5499_SHARP_) {
            var or__3548__auto____5585 = p1__5499_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____5585)) {
              return or__3548__auto____5585
            }else {
              var or__3548__auto____5586 = p1__5499_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____5586)) {
                return or__3548__auto____5586
              }else {
                return p1__5499_SHARP_.call(null, z)
              }
            }
          }, ps__5583)
        };
        var spn__4 = function() {
          var G__5595__delegate = function(x, y, z, args) {
            var or__3548__auto____5587 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____5587)) {
              return or__3548__auto____5587
            }else {
              return cljs.core.some.call(null, function(p1__5500_SHARP_) {
                return cljs.core.some.call(null, p1__5500_SHARP_, args)
              }, ps__5583)
            }
          };
          var G__5595 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__5595__delegate.call(this, x, y, z, args)
          };
          G__5595.cljs$lang$maxFixedArity = 3;
          G__5595.cljs$lang$applyTo = function(arglist__5596) {
            var x = cljs.core.first(arglist__5596);
            var y = cljs.core.first(cljs.core.next(arglist__5596));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5596)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5596)));
            return G__5595__delegate(x, y, z, args)
          };
          G__5595.cljs$lang$arity$variadic = G__5595__delegate;
          return G__5595
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__5594 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__5594__delegate.call(this, p1, p2, p3, ps)
    };
    G__5594.cljs$lang$maxFixedArity = 3;
    G__5594.cljs$lang$applyTo = function(arglist__5597) {
      var p1 = cljs.core.first(arglist__5597);
      var p2 = cljs.core.first(cljs.core.next(arglist__5597));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5597)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5597)));
      return G__5594__delegate(p1, p2, p3, ps)
    };
    G__5594.cljs$lang$arity$variadic = G__5594__delegate;
    return G__5594
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5598 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5598)) {
        var s__5599 = temp__3698__auto____5598;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__5599)), map.call(null, f, cljs.core.rest.call(null, s__5599)))
      }else {
        return null
      }
    })
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5600 = cljs.core.seq.call(null, c1);
      var s2__5601 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5602 = s1__5600;
        if(cljs.core.truth_(and__3546__auto____5602)) {
          return s2__5601
        }else {
          return and__3546__auto____5602
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5600), cljs.core.first.call(null, s2__5601)), map.call(null, f, cljs.core.rest.call(null, s1__5600), cljs.core.rest.call(null, s2__5601)))
      }else {
        return null
      }
    })
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5603 = cljs.core.seq.call(null, c1);
      var s2__5604 = cljs.core.seq.call(null, c2);
      var s3__5605 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5606 = s1__5603;
        if(cljs.core.truth_(and__3546__auto____5606)) {
          var and__3546__auto____5607 = s2__5604;
          if(cljs.core.truth_(and__3546__auto____5607)) {
            return s3__5605
          }else {
            return and__3546__auto____5607
          }
        }else {
          return and__3546__auto____5606
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__5603), cljs.core.first.call(null, s2__5604), cljs.core.first.call(null, s3__5605)), map.call(null, f, cljs.core.rest.call(null, s1__5603), cljs.core.rest.call(null, s2__5604), cljs.core.rest.call(null, s3__5605)))
      }else {
        return null
      }
    })
  };
  var map__5 = function() {
    var G__5610__delegate = function(f, c1, c2, c3, colls) {
      var step__5609 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__5608 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5608)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__5608), step.call(null, map.call(null, cljs.core.rest, ss__5608)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__5549_SHARP_) {
        return cljs.core.apply.call(null, f, p1__5549_SHARP_)
      }, step__5609.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__5610 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5610__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5610.cljs$lang$maxFixedArity = 4;
    G__5610.cljs$lang$applyTo = function(arglist__5611) {
      var f = cljs.core.first(arglist__5611);
      var c1 = cljs.core.first(cljs.core.next(arglist__5611));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5611)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5611))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5611))));
      return G__5610__delegate(f, c1, c2, c3, colls)
    };
    G__5610.cljs$lang$arity$variadic = G__5610__delegate;
    return G__5610
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3698__auto____5612 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5612)) {
        var s__5613 = temp__3698__auto____5612;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__5613), take.call(null, n - 1, cljs.core.rest.call(null, s__5613)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__5616 = function(n, coll) {
    while(true) {
      var s__5614 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5615 = n > 0;
        if(and__3546__auto____5615) {
          return s__5614
        }else {
          return and__3546__auto____5615
        }
      }())) {
        var G__5617 = n - 1;
        var G__5618 = cljs.core.rest.call(null, s__5614);
        n = G__5617;
        coll = G__5618;
        continue
      }else {
        return s__5614
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5616.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__5619 = cljs.core.seq.call(null, coll);
  var lead__5620 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__5620)) {
      var G__5621 = cljs.core.next.call(null, s__5619);
      var G__5622 = cljs.core.next.call(null, lead__5620);
      s__5619 = G__5621;
      lead__5620 = G__5622;
      continue
    }else {
      return s__5619
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__5625 = function(pred, coll) {
    while(true) {
      var s__5623 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5624 = s__5623;
        if(cljs.core.truth_(and__3546__auto____5624)) {
          return pred.call(null, cljs.core.first.call(null, s__5623))
        }else {
          return and__3546__auto____5624
        }
      }())) {
        var G__5626 = pred;
        var G__5627 = cljs.core.rest.call(null, s__5623);
        pred = G__5626;
        coll = G__5627;
        continue
      }else {
        return s__5623
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__5625.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5628 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5628)) {
      var s__5629 = temp__3698__auto____5628;
      return cljs.core.concat.call(null, s__5629, cycle.call(null, s__5629))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__5630 = cljs.core.seq.call(null, c1);
      var s2__5631 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____5632 = s1__5630;
        if(cljs.core.truth_(and__3546__auto____5632)) {
          return s2__5631
        }else {
          return and__3546__auto____5632
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__5630), cljs.core.cons.call(null, cljs.core.first.call(null, s2__5631), interleave.call(null, cljs.core.rest.call(null, s1__5630), cljs.core.rest.call(null, s2__5631))))
      }else {
        return null
      }
    })
  };
  var interleave__3 = function() {
    var G__5634__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__5633 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__5633)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__5633), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__5633)))
        }else {
          return null
        }
      })
    };
    var G__5634 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5634__delegate.call(this, c1, c2, colls)
    };
    G__5634.cljs$lang$maxFixedArity = 2;
    G__5634.cljs$lang$applyTo = function(arglist__5635) {
      var c1 = cljs.core.first(arglist__5635);
      var c2 = cljs.core.first(cljs.core.next(arglist__5635));
      var colls = cljs.core.rest(cljs.core.next(arglist__5635));
      return G__5634__delegate(c1, c2, colls)
    };
    G__5634.cljs$lang$arity$variadic = G__5634__delegate;
    return G__5634
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__5638 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____5636 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____5636)) {
        var coll__5637 = temp__3695__auto____5636;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__5637), cat.call(null, cljs.core.rest.call(null, coll__5637), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__5638.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__5639__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__5639 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__5639__delegate.call(this, f, coll, colls)
    };
    G__5639.cljs$lang$maxFixedArity = 2;
    G__5639.cljs$lang$applyTo = function(arglist__5640) {
      var f = cljs.core.first(arglist__5640);
      var coll = cljs.core.first(cljs.core.next(arglist__5640));
      var colls = cljs.core.rest(cljs.core.next(arglist__5640));
      return G__5639__delegate(f, coll, colls)
    };
    G__5639.cljs$lang$arity$variadic = G__5639__delegate;
    return G__5639
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____5641 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____5641)) {
      var s__5642 = temp__3698__auto____5641;
      var f__5643 = cljs.core.first.call(null, s__5642);
      var r__5644 = cljs.core.rest.call(null, s__5642);
      if(cljs.core.truth_(pred.call(null, f__5643))) {
        return cljs.core.cons.call(null, f__5643, filter.call(null, pred, r__5644))
      }else {
        return filter.call(null, pred, r__5644)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__5646 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__5646.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__5645_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__5645_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__5647__5648 = to;
    if(G__5647__5648 != null) {
      if(function() {
        var or__3548__auto____5649 = G__5647__5648.cljs$lang$protocol_mask$partition0$ & 2147483648;
        if(or__3548__auto____5649) {
          return or__3548__auto____5649
        }else {
          return G__5647__5648.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__5647__5648.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5647__5648)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__5647__5648)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__5650__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.fromArray([]), cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__5650 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__5650__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__5650.cljs$lang$maxFixedArity = 4;
    G__5650.cljs$lang$applyTo = function(arglist__5651) {
      var f = cljs.core.first(arglist__5651);
      var c1 = cljs.core.first(cljs.core.next(arglist__5651));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5651)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5651))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__5651))));
      return G__5650__delegate(f, c1, c2, c3, colls)
    };
    G__5650.cljs$lang$arity$variadic = G__5650__delegate;
    return G__5650
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([])), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5652 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5652)) {
        var s__5653 = temp__3698__auto____5652;
        var p__5654 = cljs.core.take.call(null, n, s__5653);
        if(n === cljs.core.count.call(null, p__5654)) {
          return cljs.core.cons.call(null, p__5654, partition.call(null, n, step, cljs.core.drop.call(null, step, s__5653)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____5655 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____5655)) {
        var s__5656 = temp__3698__auto____5655;
        var p__5657 = cljs.core.take.call(null, n, s__5656);
        if(n === cljs.core.count.call(null, p__5657)) {
          return cljs.core.cons.call(null, p__5657, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__5656)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__5657, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__5658 = cljs.core.lookup_sentinel;
    var m__5659 = m;
    var ks__5660 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__5660)) {
        var m__5661 = cljs.core.get.call(null, m__5659, cljs.core.first.call(null, ks__5660), sentinel__5658);
        if(sentinel__5658 === m__5661) {
          return not_found
        }else {
          var G__5662 = sentinel__5658;
          var G__5663 = m__5661;
          var G__5664 = cljs.core.next.call(null, ks__5660);
          sentinel__5658 = G__5662;
          m__5659 = G__5663;
          ks__5660 = G__5664;
          continue
        }
      }else {
        return m__5659
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__5665, v) {
  var vec__5666__5667 = p__5665;
  var k__5668 = cljs.core.nth.call(null, vec__5666__5667, 0, null);
  var ks__5669 = cljs.core.nthnext.call(null, vec__5666__5667, 1);
  if(cljs.core.truth_(ks__5669)) {
    return cljs.core.assoc.call(null, m, k__5668, assoc_in.call(null, cljs.core.get.call(null, m, k__5668), ks__5669, v))
  }else {
    return cljs.core.assoc.call(null, m, k__5668, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__5670, f, args) {
    var vec__5671__5672 = p__5670;
    var k__5673 = cljs.core.nth.call(null, vec__5671__5672, 0, null);
    var ks__5674 = cljs.core.nthnext.call(null, vec__5671__5672, 1);
    if(cljs.core.truth_(ks__5674)) {
      return cljs.core.assoc.call(null, m, k__5673, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__5673), ks__5674, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__5673, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__5673), args))
    }
  };
  var update_in = function(m, p__5670, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__5670, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__5675) {
    var m = cljs.core.first(arglist__5675);
    var p__5670 = cljs.core.first(cljs.core.next(arglist__5675));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__5675)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__5675)));
    return update_in__delegate(m, p__5670, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5680 = this;
  var h__364__auto____5681 = this__5680.__hash;
  if(h__364__auto____5681 != null) {
    return h__364__auto____5681
  }else {
    var h__364__auto____5682 = cljs.core.hash_coll.call(null, coll);
    this__5680.__hash = h__364__auto____5682;
    return h__364__auto____5682
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5683 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5684 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5685 = this;
  var new_array__5686 = cljs.core.aclone.call(null, this__5685.array);
  new_array__5686[k] = v;
  return new cljs.core.Vector(this__5685.meta, new_array__5686, null)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__5715 = null;
  var G__5715__2 = function(tsym5678, k) {
    var this__5687 = this;
    var tsym5678__5688 = this;
    var coll__5689 = tsym5678__5688;
    return cljs.core._lookup.call(null, coll__5689, k)
  };
  var G__5715__3 = function(tsym5679, k, not_found) {
    var this__5690 = this;
    var tsym5679__5691 = this;
    var coll__5692 = tsym5679__5691;
    return cljs.core._lookup.call(null, coll__5692, k, not_found)
  };
  G__5715 = function(tsym5679, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5715__2.call(this, tsym5679, k);
      case 3:
        return G__5715__3.call(this, tsym5679, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5715
}();
cljs.core.Vector.prototype.apply = function(tsym5676, args5677) {
  return tsym5676.call.apply(tsym5676, [tsym5676].concat(cljs.core.aclone.call(null, args5677)))
};
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5693 = this;
  var new_array__5694 = cljs.core.aclone.call(null, this__5693.array);
  new_array__5694.push(o);
  return new cljs.core.Vector(this__5693.meta, new_array__5694, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__5695 = this;
  var this$__5696 = this;
  return cljs.core.pr_str.call(null, this$__5696)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5697 = this;
  return cljs.core.ci_reduce.call(null, this__5697.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5698 = this;
  return cljs.core.ci_reduce.call(null, this__5698.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5699 = this;
  if(this__5699.array.length > 0) {
    var vector_seq__5700 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__5699.array.length) {
          return cljs.core.cons.call(null, this__5699.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__5700.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5701 = this;
  return this__5701.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5702 = this;
  var count__5703 = this__5702.array.length;
  if(count__5703 > 0) {
    return this__5702.array[count__5703 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5704 = this;
  if(this__5704.array.length > 0) {
    var new_array__5705 = cljs.core.aclone.call(null, this__5704.array);
    new_array__5705.pop();
    return new cljs.core.Vector(this__5704.meta, new_array__5705, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5706 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5707 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5708 = this;
  return new cljs.core.Vector(meta, this__5708.array, this__5708.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5709 = this;
  return this__5709.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5711 = this;
  if(function() {
    var and__3546__auto____5712 = 0 <= n;
    if(and__3546__auto____5712) {
      return n < this__5711.array.length
    }else {
      return and__3546__auto____5712
    }
  }()) {
    return this__5711.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5713 = this;
  if(function() {
    var and__3546__auto____5714 = 0 <= n;
    if(and__3546__auto____5714) {
      return n < this__5713.array.length
    }else {
      return and__3546__auto____5714
    }
  }()) {
    return this__5713.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5710 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5710.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__455__auto__) {
  return cljs.core.list.call(null, "cljs.core.VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__5716 = pv.cnt;
  if(cnt__5716 < 32) {
    return 0
  }else {
    return cnt__5716 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__5717 = level;
  var ret__5718 = node;
  while(true) {
    if(ll__5717 === 0) {
      return ret__5718
    }else {
      var embed__5719 = ret__5718;
      var r__5720 = cljs.core.pv_fresh_node.call(null, edit);
      var ___5721 = cljs.core.pv_aset.call(null, r__5720, 0, embed__5719);
      var G__5722 = ll__5717 - 5;
      var G__5723 = r__5720;
      ll__5717 = G__5722;
      ret__5718 = G__5723;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__5724 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__5725 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__5724, subidx__5725, tailnode);
    return ret__5724
  }else {
    var temp__3695__auto____5726 = cljs.core.pv_aget.call(null, parent, subidx__5725);
    if(cljs.core.truth_(temp__3695__auto____5726)) {
      var child__5727 = temp__3695__auto____5726;
      var node_to_insert__5728 = push_tail.call(null, pv, level - 5, child__5727, tailnode);
      cljs.core.pv_aset.call(null, ret__5724, subidx__5725, node_to_insert__5728);
      return ret__5724
    }else {
      var node_to_insert__5729 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__5724, subidx__5725, node_to_insert__5729);
      return ret__5724
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3546__auto____5730 = 0 <= i;
    if(and__3546__auto____5730) {
      return i < pv.cnt
    }else {
      return and__3546__auto____5730
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__5731 = pv.root;
      var level__5732 = pv.shift;
      while(true) {
        if(level__5732 > 0) {
          var G__5733 = cljs.core.pv_aget.call(null, node__5731, i >>> level__5732 & 31);
          var G__5734 = level__5732 - 5;
          node__5731 = G__5733;
          level__5732 = G__5734;
          continue
        }else {
          return node__5731.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__5735 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__5735, i & 31, val);
    return ret__5735
  }else {
    var subidx__5736 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__5735, subidx__5736, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5736), i, val));
    return ret__5735
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__5737 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5738 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__5737));
    if(function() {
      var and__3546__auto____5739 = new_child__5738 == null;
      if(and__3546__auto____5739) {
        return subidx__5737 === 0
      }else {
        return and__3546__auto____5739
      }
    }()) {
      return null
    }else {
      var ret__5740 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__5740, subidx__5737, new_child__5738);
      return ret__5740
    }
  }else {
    if(subidx__5737 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__5741 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__5741, subidx__5737, null);
        return ret__5741
      }else {
        return null
      }
    }
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.vector_seq = function vector_seq(v, offset) {
  var c__5742 = cljs.core._count.call(null, v);
  if(c__5742 > 0) {
    if(void 0 === cljs.core.t5743) {
      cljs.core.t5743 = function(c, offset, v, vector_seq, __meta__389__auto__) {
        this.c = c;
        this.offset = offset;
        this.v = v;
        this.vector_seq = vector_seq;
        this.__meta__389__auto__ = __meta__389__auto__;
        this.cljs$lang$protocol_mask$partition1$ = 0;
        this.cljs$lang$protocol_mask$partition0$ = 282263648
      };
      cljs.core.t5743.cljs$lang$type = true;
      cljs.core.t5743.cljs$lang$ctorPrSeq = function(this__454__auto__) {
        return cljs.core.list.call(null, "cljs.core.t5743")
      };
      cljs.core.t5743.prototype.cljs$core$ISeqable$ = true;
      cljs.core.t5743.prototype.cljs$core$ISeqable$_seq$arity$1 = function(vseq) {
        var this__5744 = this;
        return vseq
      };
      cljs.core.t5743.prototype.cljs$core$ISeq$ = true;
      cljs.core.t5743.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
        var this__5745 = this;
        return cljs.core._nth.call(null, this__5745.v, this__5745.offset)
      };
      cljs.core.t5743.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
        var this__5746 = this;
        var offset__5747 = this__5746.offset + 1;
        if(offset__5747 < this__5746.c) {
          return this__5746.vector_seq.call(null, this__5746.v, offset__5747)
        }else {
          return cljs.core.List.EMPTY
        }
      };
      cljs.core.t5743.prototype.cljs$core$ASeq$ = true;
      cljs.core.t5743.prototype.cljs$core$IEquiv$ = true;
      cljs.core.t5743.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(vseq, other) {
        var this__5748 = this;
        return cljs.core.equiv_sequential.call(null, vseq, other)
      };
      cljs.core.t5743.prototype.cljs$core$ISequential$ = true;
      cljs.core.t5743.prototype.cljs$core$IPrintable$ = true;
      cljs.core.t5743.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(vseq, opts) {
        var this__5749 = this;
        return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, vseq)
      };
      cljs.core.t5743.prototype.cljs$core$IMeta$ = true;
      cljs.core.t5743.prototype.cljs$core$IMeta$_meta$arity$1 = function(___390__auto__) {
        var this__5750 = this;
        return this__5750.__meta__389__auto__
      };
      cljs.core.t5743.prototype.cljs$core$IWithMeta$ = true;
      cljs.core.t5743.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(___390__auto__, __meta__389__auto__) {
        var this__5751 = this;
        return new cljs.core.t5743(this__5751.c, this__5751.offset, this__5751.v, this__5751.vector_seq, __meta__389__auto__)
      };
      cljs.core.t5743
    }else {
    }
    return new cljs.core.t5743(c__5742, offset, v, vector_seq, null)
  }else {
    return null
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2164209055
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5756 = this;
  return new cljs.core.TransientVector(this__5756.cnt, this__5756.shift, cljs.core.tv_editable_root.call(null, this__5756.root), cljs.core.tv_editable_tail.call(null, this__5756.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5757 = this;
  var h__364__auto____5758 = this__5757.__hash;
  if(h__364__auto____5758 != null) {
    return h__364__auto____5758
  }else {
    var h__364__auto____5759 = cljs.core.hash_coll.call(null, coll);
    this__5757.__hash = h__364__auto____5759;
    return h__364__auto____5759
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5760 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5761 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5762 = this;
  if(function() {
    var and__3546__auto____5763 = 0 <= k;
    if(and__3546__auto____5763) {
      return k < this__5762.cnt
    }else {
      return and__3546__auto____5763
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__5764 = cljs.core.aclone.call(null, this__5762.tail);
      new_tail__5764[k & 31] = v;
      return new cljs.core.PersistentVector(this__5762.meta, this__5762.cnt, this__5762.shift, this__5762.root, new_tail__5764, null)
    }else {
      return new cljs.core.PersistentVector(this__5762.meta, this__5762.cnt, this__5762.shift, cljs.core.do_assoc.call(null, coll, this__5762.shift, this__5762.root, k, v), this__5762.tail, null)
    }
  }else {
    if(k === this__5762.cnt) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__5762.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__5809 = null;
  var G__5809__2 = function(tsym5754, k) {
    var this__5765 = this;
    var tsym5754__5766 = this;
    var coll__5767 = tsym5754__5766;
    return cljs.core._lookup.call(null, coll__5767, k)
  };
  var G__5809__3 = function(tsym5755, k, not_found) {
    var this__5768 = this;
    var tsym5755__5769 = this;
    var coll__5770 = tsym5755__5769;
    return cljs.core._lookup.call(null, coll__5770, k, not_found)
  };
  G__5809 = function(tsym5755, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5809__2.call(this, tsym5755, k);
      case 3:
        return G__5809__3.call(this, tsym5755, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5809
}();
cljs.core.PersistentVector.prototype.apply = function(tsym5752, args5753) {
  return tsym5752.call.apply(tsym5752, [tsym5752].concat(cljs.core.aclone.call(null, args5753)))
};
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__5771 = this;
  var step_init__5772 = [0, init];
  var i__5773 = 0;
  while(true) {
    if(i__5773 < this__5771.cnt) {
      var arr__5774 = cljs.core.array_for.call(null, v, i__5773);
      var len__5775 = arr__5774.length;
      var init__5779 = function() {
        var j__5776 = 0;
        var init__5777 = step_init__5772[1];
        while(true) {
          if(j__5776 < len__5775) {
            var init__5778 = f.call(null, init__5777, j__5776 + i__5773, arr__5774[j__5776]);
            if(cljs.core.reduced_QMARK_.call(null, init__5778)) {
              return init__5778
            }else {
              var G__5810 = j__5776 + 1;
              var G__5811 = init__5778;
              j__5776 = G__5810;
              init__5777 = G__5811;
              continue
            }
          }else {
            step_init__5772[0] = len__5775;
            step_init__5772[1] = init__5777;
            return init__5777
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__5779)) {
        return cljs.core.deref.call(null, init__5779)
      }else {
        var G__5812 = i__5773 + step_init__5772[0];
        i__5773 = G__5812;
        continue
      }
    }else {
      return step_init__5772[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5780 = this;
  if(this__5780.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__5781 = cljs.core.aclone.call(null, this__5780.tail);
    new_tail__5781.push(o);
    return new cljs.core.PersistentVector(this__5780.meta, this__5780.cnt + 1, this__5780.shift, this__5780.root, new_tail__5781, null)
  }else {
    var root_overflow_QMARK___5782 = this__5780.cnt >>> 5 > 1 << this__5780.shift;
    var new_shift__5783 = root_overflow_QMARK___5782 ? this__5780.shift + 5 : this__5780.shift;
    var new_root__5785 = root_overflow_QMARK___5782 ? function() {
      var n_r__5784 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__5784, 0, this__5780.root);
      cljs.core.pv_aset.call(null, n_r__5784, 1, cljs.core.new_path.call(null, null, this__5780.shift, new cljs.core.VectorNode(null, this__5780.tail)));
      return n_r__5784
    }() : cljs.core.push_tail.call(null, coll, this__5780.shift, this__5780.root, new cljs.core.VectorNode(null, this__5780.tail));
    return new cljs.core.PersistentVector(this__5780.meta, this__5780.cnt + 1, new_shift__5783, new_root__5785, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__5786 = this;
  return cljs.core._nth.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__5787 = this;
  return cljs.core._nth.call(null, coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__5788 = this;
  var this$__5789 = this;
  return cljs.core.pr_str.call(null, this$__5789)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__5790 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__5791 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5792 = this;
  return cljs.core.vector_seq.call(null, coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5793 = this;
  return this__5793.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5794 = this;
  if(this__5794.cnt > 0) {
    return cljs.core._nth.call(null, coll, this__5794.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5795 = this;
  if(this__5795.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__5795.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5795.meta)
    }else {
      if(1 < this__5795.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__5795.meta, this__5795.cnt - 1, this__5795.shift, this__5795.root, this__5795.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__5796 = cljs.core.array_for.call(null, coll, this__5795.cnt - 2);
          var nr__5797 = cljs.core.pop_tail.call(null, coll, this__5795.shift, this__5795.root);
          var new_root__5798 = nr__5797 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__5797;
          var cnt_1__5799 = this__5795.cnt - 1;
          if(function() {
            var and__3546__auto____5800 = 5 < this__5795.shift;
            if(and__3546__auto____5800) {
              return cljs.core.pv_aget.call(null, new_root__5798, 1) == null
            }else {
              return and__3546__auto____5800
            }
          }()) {
            return new cljs.core.PersistentVector(this__5795.meta, cnt_1__5799, this__5795.shift - 5, cljs.core.pv_aget.call(null, new_root__5798, 0), new_tail__5796, null)
          }else {
            return new cljs.core.PersistentVector(this__5795.meta, cnt_1__5799, this__5795.shift, new_root__5798, new_tail__5796, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5802 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5803 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5804 = this;
  return new cljs.core.PersistentVector(meta, this__5804.cnt, this__5804.shift, this__5804.root, this__5804.tail, this__5804.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5805 = this;
  return this__5805.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5806 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5807 = this;
  if(function() {
    var and__3546__auto____5808 = 0 <= n;
    if(and__3546__auto____5808) {
      return n < this__5807.cnt
    }else {
      return and__3546__auto____5808
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5801 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__5801.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs) {
  var xs__5813 = cljs.core.seq.call(null, xs);
  var out__5814 = cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);
  while(true) {
    if(cljs.core.truth_(xs__5813)) {
      var G__5815 = cljs.core.next.call(null, xs__5813);
      var G__5816 = cljs.core.conj_BANG_.call(null, out__5814, cljs.core.first.call(null, xs__5813));
      xs__5813 = G__5815;
      out__5814 = G__5816;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__5814)
    }
    break
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__5817) {
    var args = cljs.core.seq(arglist__5817);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16200095
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5822 = this;
  var h__364__auto____5823 = this__5822.__hash;
  if(h__364__auto____5823 != null) {
    return h__364__auto____5823
  }else {
    var h__364__auto____5824 = cljs.core.hash_coll.call(null, coll);
    this__5822.__hash = h__364__auto____5824;
    return h__364__auto____5824
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5825 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5826 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__5827 = this;
  var v_pos__5828 = this__5827.start + key;
  return new cljs.core.Subvec(this__5827.meta, cljs.core._assoc.call(null, this__5827.v, v_pos__5828, val), this__5827.start, this__5827.end > v_pos__5828 + 1 ? this__5827.end : v_pos__5828 + 1, null)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__5852 = null;
  var G__5852__2 = function(tsym5820, k) {
    var this__5829 = this;
    var tsym5820__5830 = this;
    var coll__5831 = tsym5820__5830;
    return cljs.core._lookup.call(null, coll__5831, k)
  };
  var G__5852__3 = function(tsym5821, k, not_found) {
    var this__5832 = this;
    var tsym5821__5833 = this;
    var coll__5834 = tsym5821__5833;
    return cljs.core._lookup.call(null, coll__5834, k, not_found)
  };
  G__5852 = function(tsym5821, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5852__2.call(this, tsym5821, k);
      case 3:
        return G__5852__3.call(this, tsym5821, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5852
}();
cljs.core.Subvec.prototype.apply = function(tsym5818, args5819) {
  return tsym5818.call.apply(tsym5818, [tsym5818].concat(cljs.core.aclone.call(null, args5819)))
};
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5835 = this;
  return new cljs.core.Subvec(this__5835.meta, cljs.core._assoc_n.call(null, this__5835.v, this__5835.end, o), this__5835.start, this__5835.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__5836 = this;
  var this$__5837 = this;
  return cljs.core.pr_str.call(null, this$__5837)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__5838 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__5839 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5840 = this;
  var subvec_seq__5841 = function subvec_seq(i) {
    if(i === this__5840.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__5840.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__5841.call(null, this__5840.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5842 = this;
  return this__5842.end - this__5842.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5843 = this;
  return cljs.core._nth.call(null, this__5843.v, this__5843.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5844 = this;
  if(this__5844.start === this__5844.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__5844.meta, this__5844.v, this__5844.start, this__5844.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__5845 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5846 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5847 = this;
  return new cljs.core.Subvec(meta, this__5847.v, this__5847.start, this__5847.end, this__5847.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5848 = this;
  return this__5848.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5850 = this;
  return cljs.core._nth.call(null, this__5850.v, this__5850.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5851 = this;
  return cljs.core._nth.call(null, this__5851.v, this__5851.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5849 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__5849.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone.call(null, node.arr))
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone.call(null, node.arr))
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__5853 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__5853, 0, tl.length);
  return ret__5853
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__5854 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__5855 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__5854, subidx__5855, level === 5 ? tail_node : function() {
    var child__5856 = cljs.core.pv_aget.call(null, ret__5854, subidx__5855);
    if(child__5856 != null) {
      return tv_push_tail.call(null, tv, level - 5, child__5856, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__5854
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__5857 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__5858 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__5859 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__5857, subidx__5858));
    if(function() {
      var and__3546__auto____5860 = new_child__5859 == null;
      if(and__3546__auto____5860) {
        return subidx__5858 === 0
      }else {
        return and__3546__auto____5860
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__5857, subidx__5858, new_child__5859);
      return node__5857
    }
  }else {
    if(subidx__5858 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__5857, subidx__5858, null);
        return node__5857
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3546__auto____5861 = 0 <= i;
    if(and__3546__auto____5861) {
      return i < tv.cnt
    }else {
      return and__3546__auto____5861
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__5862 = tv.root;
      var node__5863 = root__5862;
      var level__5864 = tv.shift;
      while(true) {
        if(level__5864 > 0) {
          var G__5865 = cljs.core.tv_ensure_editable.call(null, root__5862.edit, cljs.core.pv_aget.call(null, node__5863, i >>> level__5864 & 31));
          var G__5866 = level__5864 - 5;
          node__5863 = G__5865;
          level__5864 = G__5866;
          continue
        }else {
          return node__5863.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 147;
  this.cljs$lang$protocol_mask$partition1$ = 11
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientVector")
};
cljs.core.TransientVector.prototype.cljs$core$IFn$ = true;
cljs.core.TransientVector.prototype.call = function() {
  var G__5904 = null;
  var G__5904__2 = function(tsym5869, k) {
    var this__5871 = this;
    var tsym5869__5872 = this;
    var coll__5873 = tsym5869__5872;
    return cljs.core._lookup.call(null, coll__5873, k)
  };
  var G__5904__3 = function(tsym5870, k, not_found) {
    var this__5874 = this;
    var tsym5870__5875 = this;
    var coll__5876 = tsym5870__5875;
    return cljs.core._lookup.call(null, coll__5876, k, not_found)
  };
  G__5904 = function(tsym5870, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5904__2.call(this, tsym5870, k);
      case 3:
        return G__5904__3.call(this, tsym5870, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5904
}();
cljs.core.TransientVector.prototype.apply = function(tsym5867, args5868) {
  return tsym5867.call.apply(tsym5867, [tsym5867].concat(cljs.core.aclone.call(null, args5868)))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5877 = this;
  return cljs.core._nth.call(null, coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5878 = this;
  return cljs.core._nth.call(null, coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__5879 = this;
  if(cljs.core.truth_(this__5879.root.edit)) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__5880 = this;
  if(function() {
    var and__3546__auto____5881 = 0 <= n;
    if(and__3546__auto____5881) {
      return n < this__5880.cnt
    }else {
      return and__3546__auto____5881
    }
  }()) {
    return cljs.core._nth.call(null, coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5882 = this;
  if(cljs.core.truth_(this__5882.root.edit)) {
    return this__5882.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__5883 = this;
  if(cljs.core.truth_(this__5883.root.edit)) {
    if(function() {
      var and__3546__auto____5884 = 0 <= n;
      if(and__3546__auto____5884) {
        return n < this__5883.cnt
      }else {
        return and__3546__auto____5884
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__5883.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__5887 = function go(level, node) {
          var node__5885 = cljs.core.tv_ensure_editable.call(null, this__5883.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__5885, n & 31, val);
            return node__5885
          }else {
            var subidx__5886 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__5885, subidx__5886, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__5885, subidx__5886)));
            return node__5885
          }
        }.call(null, this__5883.shift, this__5883.root);
        this__5883.root = new_root__5887;
        return tcoll
      }
    }else {
      if(n === this__5883.cnt) {
        return cljs.core._conj_BANG_.call(null, tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__5883.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__5888 = this;
  if(cljs.core.truth_(this__5888.root.edit)) {
    if(this__5888.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__5888.cnt) {
        this__5888.cnt = 0;
        return tcoll
      }else {
        if((this__5888.cnt - 1 & 31) > 0) {
          this__5888.cnt = this__5888.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__5889 = cljs.core.editable_array_for.call(null, tcoll, this__5888.cnt - 2);
            var new_root__5891 = function() {
              var nr__5890 = cljs.core.tv_pop_tail.call(null, tcoll, this__5888.shift, this__5888.root);
              if(nr__5890 != null) {
                return nr__5890
              }else {
                return new cljs.core.VectorNode(this__5888.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3546__auto____5892 = 5 < this__5888.shift;
              if(and__3546__auto____5892) {
                return cljs.core.pv_aget.call(null, new_root__5891, 1) == null
              }else {
                return and__3546__auto____5892
              }
            }()) {
              var new_root__5893 = cljs.core.tv_ensure_editable.call(null, this__5888.root.edit, cljs.core.pv_aget.call(null, new_root__5891, 0));
              this__5888.root = new_root__5893;
              this__5888.shift = this__5888.shift - 5;
              this__5888.cnt = this__5888.cnt - 1;
              this__5888.tail = new_tail__5889;
              return tcoll
            }else {
              this__5888.root = new_root__5891;
              this__5888.cnt = this__5888.cnt - 1;
              this__5888.tail = new_tail__5889;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__5894 = this;
  return cljs.core._assoc_n_BANG_.call(null, tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__5895 = this;
  if(cljs.core.truth_(this__5895.root.edit)) {
    if(this__5895.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__5895.tail[this__5895.cnt & 31] = o;
      this__5895.cnt = this__5895.cnt + 1;
      return tcoll
    }else {
      var tail_node__5896 = new cljs.core.VectorNode(this__5895.root.edit, this__5895.tail);
      var new_tail__5897 = cljs.core.make_array.call(null, 32);
      new_tail__5897[0] = o;
      this__5895.tail = new_tail__5897;
      if(this__5895.cnt >>> 5 > 1 << this__5895.shift) {
        var new_root_array__5898 = cljs.core.make_array.call(null, 32);
        var new_shift__5899 = this__5895.shift + 5;
        new_root_array__5898[0] = this__5895.root;
        new_root_array__5898[1] = cljs.core.new_path.call(null, this__5895.root.edit, this__5895.shift, tail_node__5896);
        this__5895.root = new cljs.core.VectorNode(this__5895.root.edit, new_root_array__5898);
        this__5895.shift = new_shift__5899;
        this__5895.cnt = this__5895.cnt + 1;
        return tcoll
      }else {
        var new_root__5900 = cljs.core.tv_push_tail.call(null, tcoll, this__5895.shift, this__5895.root, tail_node__5896);
        this__5895.root = new_root__5900;
        this__5895.cnt = this__5895.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__5901 = this;
  if(cljs.core.truth_(this__5901.root.edit)) {
    this__5901.root.edit = null;
    var len__5902 = this__5901.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__5903 = cljs.core.make_array.call(null, len__5902);
    cljs.core.array_copy.call(null, this__5901.tail, 0, trimmed_tail__5903, 0, len__5902);
    return new cljs.core.PersistentVector(null, this__5901.cnt, this__5901.shift, this__5901.root, trimmed_tail__5903, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5905 = this;
  var h__364__auto____5906 = this__5905.__hash;
  if(h__364__auto____5906 != null) {
    return h__364__auto____5906
  }else {
    var h__364__auto____5907 = cljs.core.hash_coll.call(null, coll);
    this__5905.__hash = h__364__auto____5907;
    return h__364__auto____5907
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5908 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__5909 = this;
  var this$__5910 = this;
  return cljs.core.pr_str.call(null, this$__5910)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5911 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5912 = this;
  return cljs.core._first.call(null, this__5912.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5913 = this;
  var temp__3695__auto____5914 = cljs.core.next.call(null, this__5913.front);
  if(cljs.core.truth_(temp__3695__auto____5914)) {
    var f1__5915 = temp__3695__auto____5914;
    return new cljs.core.PersistentQueueSeq(this__5913.meta, f1__5915, this__5913.rear, null)
  }else {
    if(this__5913.rear == null) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__5913.meta, this__5913.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5916 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5917 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__5917.front, this__5917.rear, this__5917.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5918 = this;
  return this__5918.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5919 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__5919.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15929422
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5920 = this;
  var h__364__auto____5921 = this__5920.__hash;
  if(h__364__auto____5921 != null) {
    return h__364__auto____5921
  }else {
    var h__364__auto____5922 = cljs.core.hash_coll.call(null, coll);
    this__5920.__hash = h__364__auto____5922;
    return h__364__auto____5922
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__5923 = this;
  if(cljs.core.truth_(this__5923.front)) {
    return new cljs.core.PersistentQueue(this__5923.meta, this__5923.count + 1, this__5923.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____5924 = this__5923.rear;
      if(cljs.core.truth_(or__3548__auto____5924)) {
        return or__3548__auto____5924
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__5923.meta, this__5923.count + 1, cljs.core.conj.call(null, this__5923.front, o), cljs.core.PersistentVector.fromArray([]), null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__5925 = this;
  var this$__5926 = this;
  return cljs.core.pr_str.call(null, this$__5926)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5927 = this;
  var rear__5928 = cljs.core.seq.call(null, this__5927.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____5929 = this__5927.front;
    if(cljs.core.truth_(or__3548__auto____5929)) {
      return or__3548__auto____5929
    }else {
      return rear__5928
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__5927.front, cljs.core.seq.call(null, rear__5928), null, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5930 = this;
  return this__5930.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__5931 = this;
  return cljs.core._first.call(null, this__5931.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__5932 = this;
  if(cljs.core.truth_(this__5932.front)) {
    var temp__3695__auto____5933 = cljs.core.next.call(null, this__5932.front);
    if(cljs.core.truth_(temp__3695__auto____5933)) {
      var f1__5934 = temp__3695__auto____5933;
      return new cljs.core.PersistentQueue(this__5932.meta, this__5932.count - 1, f1__5934, this__5932.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__5932.meta, this__5932.count - 1, cljs.core.seq.call(null, this__5932.rear), cljs.core.PersistentVector.fromArray([]), null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__5935 = this;
  return cljs.core.first.call(null, this__5935.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__5936 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5937 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5938 = this;
  return new cljs.core.PersistentQueue(meta, this__5938.count, this__5938.front, this__5938.rear, this__5938.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5939 = this;
  return this__5939.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5940 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]), 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1048576
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__5941 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__5942 = array.length;
  var i__5943 = 0;
  while(true) {
    if(i__5943 < len__5942) {
      if(cljs.core._EQ_.call(null, k, array[i__5943])) {
        return i__5943
      }else {
        var G__5944 = i__5943 + incr;
        i__5943 = G__5944;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___2 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____5945 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____5945)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____5945
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___2.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  obj_map_contains_key_QMARK_.cljs$lang$arity$2 = obj_map_contains_key_QMARK___2;
  obj_map_contains_key_QMARK_.cljs$lang$arity$4 = obj_map_contains_key_QMARK___4;
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__5946 = cljs.core.hash.call(null, a);
  var b__5947 = cljs.core.hash.call(null, b);
  if(a__5946 < b__5947) {
    return-1
  }else {
    if(a__5946 > b__5947) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__5949 = m.keys;
  var len__5950 = ks__5949.length;
  var so__5951 = m.strobj;
  var out__5952 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__5953 = 0;
  var out__5954 = cljs.core.transient$.call(null, out__5952);
  while(true) {
    if(i__5953 < len__5950) {
      var k__5955 = ks__5949[i__5953];
      var G__5956 = i__5953 + 1;
      var G__5957 = cljs.core.assoc_BANG_.call(null, out__5954, k__5955, so__5951[k__5955]);
      i__5953 = G__5956;
      out__5954 = G__5957;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__5954, k, v))
    }
    break
  }
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155021199
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__5962 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5963 = this;
  var h__364__auto____5964 = this__5963.__hash;
  if(h__364__auto____5964 != null) {
    return h__364__auto____5964
  }else {
    var h__364__auto____5965 = cljs.core.hash_imap.call(null, coll);
    this__5963.__hash = h__364__auto____5965;
    return h__364__auto____5965
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__5966 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__5967 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__5967.strobj, this__5967.strobj[k], not_found)
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__5968 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var overwrite_QMARK___5969 = this__5968.strobj.hasOwnProperty(k);
    if(cljs.core.truth_(overwrite_QMARK___5969)) {
      var new_strobj__5970 = goog.object.clone.call(null, this__5968.strobj);
      new_strobj__5970[k] = v;
      return new cljs.core.ObjMap(this__5968.meta, this__5968.keys, new_strobj__5970, this__5968.update_count + 1, null)
    }else {
      if(this__5968.update_count < cljs.core.ObjMap.HASHMAP_THRESHOLD) {
        var new_strobj__5971 = goog.object.clone.call(null, this__5968.strobj);
        var new_keys__5972 = cljs.core.aclone.call(null, this__5968.keys);
        new_strobj__5971[k] = v;
        new_keys__5972.push(k);
        return new cljs.core.ObjMap(this__5968.meta, new_keys__5972, new_strobj__5971, this__5968.update_count + 1, null)
      }else {
        return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__5973 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__5973.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__5993 = null;
  var G__5993__2 = function(tsym5960, k) {
    var this__5974 = this;
    var tsym5960__5975 = this;
    var coll__5976 = tsym5960__5975;
    return cljs.core._lookup.call(null, coll__5976, k)
  };
  var G__5993__3 = function(tsym5961, k, not_found) {
    var this__5977 = this;
    var tsym5961__5978 = this;
    var coll__5979 = tsym5961__5978;
    return cljs.core._lookup.call(null, coll__5979, k, not_found)
  };
  G__5993 = function(tsym5961, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5993__2.call(this, tsym5961, k);
      case 3:
        return G__5993__3.call(this, tsym5961, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__5993
}();
cljs.core.ObjMap.prototype.apply = function(tsym5958, args5959) {
  return tsym5958.call.apply(tsym5958, [tsym5958].concat(cljs.core.aclone.call(null, args5959)))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__5980 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__5981 = this;
  var this$__5982 = this;
  return cljs.core.pr_str.call(null, this$__5982)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__5983 = this;
  if(this__5983.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__5948_SHARP_) {
      return cljs.core.vector.call(null, p1__5948_SHARP_, this__5983.strobj[p1__5948_SHARP_])
    }, this__5983.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__5984 = this;
  return this__5984.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__5985 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__5986 = this;
  return new cljs.core.ObjMap(meta, this__5986.keys, this__5986.strobj, this__5986.update_count, this__5986.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__5987 = this;
  return this__5987.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__5988 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__5988.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__5989 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____5990 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____5990)) {
      return this__5989.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____5990
    }
  }())) {
    var new_keys__5991 = cljs.core.aclone.call(null, this__5989.keys);
    var new_strobj__5992 = goog.object.clone.call(null, this__5989.strobj);
    new_keys__5991.splice(cljs.core.scan_array.call(null, 1, k, new_keys__5991), 1);
    cljs.core.js_delete.call(null, new_strobj__5992, k);
    return new cljs.core.ObjMap(this__5989.meta, new_keys__5991, new_strobj__5992, this__5989.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 7537551
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__5999 = this;
  var h__364__auto____6000 = this__5999.__hash;
  if(h__364__auto____6000 != null) {
    return h__364__auto____6000
  }else {
    var h__364__auto____6001 = cljs.core.hash_imap.call(null, coll);
    this__5999.__hash = h__364__auto____6001;
    return h__364__auto____6001
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6002 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6003 = this;
  var bucket__6004 = this__6003.hashobj[cljs.core.hash.call(null, k)];
  var i__6005 = cljs.core.truth_(bucket__6004) ? cljs.core.scan_array.call(null, 2, k, bucket__6004) : null;
  if(cljs.core.truth_(i__6005)) {
    return bucket__6004[i__6005 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6006 = this;
  var h__6007 = cljs.core.hash.call(null, k);
  var bucket__6008 = this__6006.hashobj[h__6007];
  if(cljs.core.truth_(bucket__6008)) {
    var new_bucket__6009 = cljs.core.aclone.call(null, bucket__6008);
    var new_hashobj__6010 = goog.object.clone.call(null, this__6006.hashobj);
    new_hashobj__6010[h__6007] = new_bucket__6009;
    var temp__3695__auto____6011 = cljs.core.scan_array.call(null, 2, k, new_bucket__6009);
    if(cljs.core.truth_(temp__3695__auto____6011)) {
      var i__6012 = temp__3695__auto____6011;
      new_bucket__6009[i__6012 + 1] = v;
      return new cljs.core.HashMap(this__6006.meta, this__6006.count, new_hashobj__6010, null)
    }else {
      new_bucket__6009.push(k, v);
      return new cljs.core.HashMap(this__6006.meta, this__6006.count + 1, new_hashobj__6010, null)
    }
  }else {
    var new_hashobj__6013 = goog.object.clone.call(null, this__6006.hashobj);
    new_hashobj__6013[h__6007] = [k, v];
    return new cljs.core.HashMap(this__6006.meta, this__6006.count + 1, new_hashobj__6013, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6014 = this;
  var bucket__6015 = this__6014.hashobj[cljs.core.hash.call(null, k)];
  var i__6016 = cljs.core.truth_(bucket__6015) ? cljs.core.scan_array.call(null, 2, k, bucket__6015) : null;
  if(cljs.core.truth_(i__6016)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__6039 = null;
  var G__6039__2 = function(tsym5997, k) {
    var this__6017 = this;
    var tsym5997__6018 = this;
    var coll__6019 = tsym5997__6018;
    return cljs.core._lookup.call(null, coll__6019, k)
  };
  var G__6039__3 = function(tsym5998, k, not_found) {
    var this__6020 = this;
    var tsym5998__6021 = this;
    var coll__6022 = tsym5998__6021;
    return cljs.core._lookup.call(null, coll__6022, k, not_found)
  };
  G__6039 = function(tsym5998, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6039__2.call(this, tsym5998, k);
      case 3:
        return G__6039__3.call(this, tsym5998, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6039
}();
cljs.core.HashMap.prototype.apply = function(tsym5995, args5996) {
  return tsym5995.call.apply(tsym5995, [tsym5995].concat(cljs.core.aclone.call(null, args5996)))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6023 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__6024 = this;
  var this$__6025 = this;
  return cljs.core.pr_str.call(null, this$__6025)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6026 = this;
  if(this__6026.count > 0) {
    var hashes__6027 = cljs.core.js_keys.call(null, this__6026.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__5994_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__6026.hashobj[p1__5994_SHARP_]))
    }, hashes__6027)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6028 = this;
  return this__6028.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6029 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6030 = this;
  return new cljs.core.HashMap(meta, this__6030.count, this__6030.hashobj, this__6030.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6031 = this;
  return this__6031.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6032 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__6032.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6033 = this;
  var h__6034 = cljs.core.hash.call(null, k);
  var bucket__6035 = this__6033.hashobj[h__6034];
  var i__6036 = cljs.core.truth_(bucket__6035) ? cljs.core.scan_array.call(null, 2, k, bucket__6035) : null;
  if(cljs.core.not.call(null, i__6036)) {
    return coll
  }else {
    var new_hashobj__6037 = goog.object.clone.call(null, this__6033.hashobj);
    if(3 > bucket__6035.length) {
      cljs.core.js_delete.call(null, new_hashobj__6037, h__6034)
    }else {
      var new_bucket__6038 = cljs.core.aclone.call(null, bucket__6035);
      new_bucket__6038.splice(i__6036, 2);
      new_hashobj__6037[h__6034] = new_bucket__6038
    }
    return new cljs.core.HashMap(this__6033.meta, this__6033.count - 1, new_hashobj__6037, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__6040 = ks.length;
  var i__6041 = 0;
  var out__6042 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__6041 < len__6040) {
      var G__6043 = i__6041 + 1;
      var G__6044 = cljs.core.assoc.call(null, out__6042, ks[i__6041], vs[i__6041]);
      i__6041 = G__6043;
      out__6042 = G__6044;
      continue
    }else {
      return out__6042
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__6045 = m.arr;
  var len__6046 = arr__6045.length;
  var i__6047 = 0;
  while(true) {
    if(len__6046 <= i__6047) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__6045[i__6047], k)) {
        return i__6047
      }else {
        if("\ufdd0'else") {
          var G__6048 = i__6047 + 2;
          i__6047 = G__6048;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
void 0;
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6053 = this;
  return new cljs.core.TransientArrayMap({}, this__6053.arr.length, cljs.core.aclone.call(null, this__6053.arr))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6054 = this;
  var h__364__auto____6055 = this__6054.__hash;
  if(h__364__auto____6055 != null) {
    return h__364__auto____6055
  }else {
    var h__364__auto____6056 = cljs.core.hash_imap.call(null, coll);
    this__6054.__hash = h__364__auto____6056;
    return h__364__auto____6056
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6057 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6058 = this;
  var idx__6059 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6059 === -1) {
    return not_found
  }else {
    return this__6058.arr[idx__6059 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6060 = this;
  var idx__6061 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6061 === -1) {
    if(this__6060.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__6060.meta, this__6060.cnt + 1, function() {
        var G__6062__6063 = cljs.core.aclone.call(null, this__6060.arr);
        G__6062__6063.push(k);
        G__6062__6063.push(v);
        return G__6062__6063
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__6060.arr[idx__6061 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__6060.meta, this__6060.cnt, function() {
          var G__6064__6065 = cljs.core.aclone.call(null, this__6060.arr);
          G__6064__6065[idx__6061 + 1] = v;
          return G__6064__6065
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6066 = this;
  return cljs.core.array_map_index_of.call(null, coll, k) != -1
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__6096 = null;
  var G__6096__2 = function(tsym6051, k) {
    var this__6067 = this;
    var tsym6051__6068 = this;
    var coll__6069 = tsym6051__6068;
    return cljs.core._lookup.call(null, coll__6069, k)
  };
  var G__6096__3 = function(tsym6052, k, not_found) {
    var this__6070 = this;
    var tsym6052__6071 = this;
    var coll__6072 = tsym6052__6071;
    return cljs.core._lookup.call(null, coll__6072, k, not_found)
  };
  G__6096 = function(tsym6052, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6096__2.call(this, tsym6052, k);
      case 3:
        return G__6096__3.call(this, tsym6052, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6096
}();
cljs.core.PersistentArrayMap.prototype.apply = function(tsym6049, args6050) {
  return tsym6049.call.apply(tsym6049, [tsym6049].concat(cljs.core.aclone.call(null, args6050)))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6073 = this;
  var len__6074 = this__6073.arr.length;
  var i__6075 = 0;
  var init__6076 = init;
  while(true) {
    if(i__6075 < len__6074) {
      var init__6077 = f.call(null, init__6076, this__6073.arr[i__6075], this__6073.arr[i__6075 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__6077)) {
        return cljs.core.deref.call(null, init__6077)
      }else {
        var G__6097 = i__6075 + 2;
        var G__6098 = init__6077;
        i__6075 = G__6097;
        init__6076 = G__6098;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6078 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__6079 = this;
  var this$__6080 = this;
  return cljs.core.pr_str.call(null, this$__6080)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6081 = this;
  if(this__6081.cnt > 0) {
    var len__6082 = this__6081.arr.length;
    var array_map_seq__6083 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__6082) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__6081.arr[i], this__6081.arr[i + 1]]), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      })
    };
    return array_map_seq__6083.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6084 = this;
  return this__6084.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6085 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6086 = this;
  return new cljs.core.PersistentArrayMap(meta, this__6086.cnt, this__6086.arr, this__6086.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6087 = this;
  return this__6087.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6088 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__6088.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6089 = this;
  var idx__6090 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__6090 >= 0) {
    var len__6091 = this__6089.arr.length;
    var new_len__6092 = len__6091 - 2;
    if(new_len__6092 === 0) {
      return cljs.core._empty.call(null, coll)
    }else {
      var new_arr__6093 = cljs.core.make_array.call(null, new_len__6092);
      var s__6094 = 0;
      var d__6095 = 0;
      while(true) {
        if(s__6094 >= len__6091) {
          return new cljs.core.PersistentArrayMap(this__6089.meta, this__6089.cnt - 1, new_arr__6093, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__6089.arr[s__6094])) {
            var G__6099 = s__6094 + 2;
            var G__6100 = d__6095;
            s__6094 = G__6099;
            d__6095 = G__6100;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__6093[d__6095] = this__6089.arr[s__6094];
              new_arr__6093[d__6095 + 1] = this__6089.arr[s__6094 + 1];
              var G__6101 = s__6094 + 2;
              var G__6102 = d__6095 + 2;
              s__6094 = G__6101;
              d__6095 = G__6102;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__6103 = cljs.core.count.call(null, ks);
  var i__6104 = 0;
  var out__6105 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__6104 < len__6103) {
      var G__6106 = i__6104 + 1;
      var G__6107 = cljs.core.assoc_BANG_.call(null, out__6105, ks[i__6104], vs[i__6104]);
      i__6104 = G__6106;
      out__6105 = G__6107;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6105)
    }
    break
  }
};
void 0;
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6108 = this;
  if(cljs.core.truth_(this__6108.editable_QMARK_)) {
    var idx__6109 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6109 >= 0) {
      this__6108.arr[idx__6109] = this__6108.arr[this__6108.len - 2];
      this__6108.arr[idx__6109 + 1] = this__6108.arr[this__6108.len - 1];
      var G__6110__6111 = this__6108.arr;
      G__6110__6111.pop();
      G__6110__6111.pop();
      G__6110__6111;
      this__6108.len = this__6108.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6112 = this;
  if(cljs.core.truth_(this__6112.editable_QMARK_)) {
    var idx__6113 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__6113 === -1) {
      if(this__6112.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__6112.len = this__6112.len + 2;
        this__6112.arr.push(key);
        this__6112.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__6112.len, this__6112.arr), key, val)
      }
    }else {
      if(val === this__6112.arr[idx__6113 + 1]) {
        return tcoll
      }else {
        this__6112.arr[idx__6113 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6114 = this;
  if(cljs.core.truth_(this__6114.editable_QMARK_)) {
    if(function() {
      var G__6115__6116 = o;
      if(G__6115__6116 != null) {
        if(function() {
          var or__3548__auto____6117 = G__6115__6116.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6117) {
            return or__3548__auto____6117
          }else {
            return G__6115__6116.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6115__6116.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6115__6116)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6115__6116)
      }
    }()) {
      return cljs.core._assoc_BANG_.call(null, tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6118 = cljs.core.seq.call(null, o);
      var tcoll__6119 = tcoll;
      while(true) {
        var temp__3695__auto____6120 = cljs.core.first.call(null, es__6118);
        if(cljs.core.truth_(temp__3695__auto____6120)) {
          var e__6121 = temp__3695__auto____6120;
          var G__6127 = cljs.core.next.call(null, es__6118);
          var G__6128 = cljs.core._assoc_BANG_.call(null, tcoll__6119, cljs.core.key.call(null, e__6121), cljs.core.val.call(null, e__6121));
          es__6118 = G__6127;
          tcoll__6119 = G__6128;
          continue
        }else {
          return tcoll__6119
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6122 = this;
  if(cljs.core.truth_(this__6122.editable_QMARK_)) {
    this__6122.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__6122.len, 2), this__6122.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6123 = this;
  return cljs.core._lookup.call(null, tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6124 = this;
  if(cljs.core.truth_(this__6124.editable_QMARK_)) {
    var idx__6125 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__6125 === -1) {
      return not_found
    }else {
      return this__6124.arr[idx__6125 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6126 = this;
  if(cljs.core.truth_(this__6126.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__6126.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
void 0;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__6129 = cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {}));
  var i__6130 = 0;
  while(true) {
    if(i__6130 < len) {
      var G__6131 = cljs.core.assoc_BANG_.call(null, out__6129, arr[i__6130], arr[i__6130 + 1]);
      var G__6132 = i__6130 + 2;
      out__6129 = G__6131;
      i__6130 = G__6132;
      continue
    }else {
      return out__6129
    }
    break
  }
};
void 0;
void 0;
void 0;
void 0;
void 0;
void 0;
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__6133__6134 = cljs.core.aclone.call(null, arr);
    G__6133__6134[i] = a;
    return G__6133__6134
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__6135__6136 = cljs.core.aclone.call(null, arr);
    G__6135__6136[i] = a;
    G__6135__6136[j] = b;
    return G__6135__6136
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__6137 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__6137, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__6137, 2 * i, new_arr__6137.length - 2 * i);
  return new_arr__6137
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__6138 = inode.ensure_editable(edit);
    editable__6138.arr[i] = a;
    return editable__6138
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__6139 = inode.ensure_editable(edit);
    editable__6139.arr[i] = a;
    editable__6139.arr[j] = b;
    return editable__6139
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__6140 = arr.length;
  var i__6141 = 0;
  var init__6142 = init;
  while(true) {
    if(i__6141 < len__6140) {
      var init__6145 = function() {
        var k__6143 = arr[i__6141];
        if(k__6143 != null) {
          return f.call(null, init__6142, k__6143, arr[i__6141 + 1])
        }else {
          var node__6144 = arr[i__6141 + 1];
          if(node__6144 != null) {
            return node__6144.kv_reduce(f, init__6142)
          }else {
            return init__6142
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__6145)) {
        return cljs.core.deref.call(null, init__6145)
      }else {
        var G__6146 = i__6141 + 2;
        var G__6147 = init__6145;
        i__6141 = G__6146;
        init__6142 = G__6147;
        continue
      }
    }else {
      return init__6142
    }
    break
  }
};
void 0;
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__6148 = this;
  var inode__6149 = this;
  if(this__6148.bitmap === bit) {
    return null
  }else {
    var editable__6150 = inode__6149.ensure_editable(e);
    var earr__6151 = editable__6150.arr;
    var len__6152 = earr__6151.length;
    editable__6150.bitmap = bit ^ editable__6150.bitmap;
    cljs.core.array_copy.call(null, earr__6151, 2 * (i + 1), earr__6151, 2 * i, len__6152 - 2 * (i + 1));
    earr__6151[len__6152 - 2] = null;
    earr__6151[len__6152 - 1] = null;
    return editable__6150
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6153 = this;
  var inode__6154 = this;
  var bit__6155 = 1 << (hash >>> shift & 31);
  var idx__6156 = cljs.core.bitmap_indexed_node_index.call(null, this__6153.bitmap, bit__6155);
  if((this__6153.bitmap & bit__6155) === 0) {
    var n__6157 = cljs.core.bit_count.call(null, this__6153.bitmap);
    if(2 * n__6157 < this__6153.arr.length) {
      var editable__6158 = inode__6154.ensure_editable(edit);
      var earr__6159 = editable__6158.arr;
      added_leaf_QMARK_[0] = true;
      cljs.core.array_copy_downward.call(null, earr__6159, 2 * idx__6156, earr__6159, 2 * (idx__6156 + 1), 2 * (n__6157 - idx__6156));
      earr__6159[2 * idx__6156] = key;
      earr__6159[2 * idx__6156 + 1] = val;
      editable__6158.bitmap = editable__6158.bitmap | bit__6155;
      return editable__6158
    }else {
      if(n__6157 >= 16) {
        var nodes__6160 = cljs.core.make_array.call(null, 32);
        var jdx__6161 = hash >>> shift & 31;
        nodes__6160[jdx__6161] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__6162 = 0;
        var j__6163 = 0;
        while(true) {
          if(i__6162 < 32) {
            if((this__6153.bitmap >>> i__6162 & 1) === 0) {
              var G__6216 = i__6162 + 1;
              var G__6217 = j__6163;
              i__6162 = G__6216;
              j__6163 = G__6217;
              continue
            }else {
              nodes__6160[i__6162] = null != this__6153.arr[j__6163] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__6153.arr[j__6163]), this__6153.arr[j__6163], this__6153.arr[j__6163 + 1], added_leaf_QMARK_) : this__6153.arr[j__6163 + 1];
              var G__6218 = i__6162 + 1;
              var G__6219 = j__6163 + 2;
              i__6162 = G__6218;
              j__6163 = G__6219;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__6157 + 1, nodes__6160)
      }else {
        if("\ufdd0'else") {
          var new_arr__6164 = cljs.core.make_array.call(null, 2 * (n__6157 + 4));
          cljs.core.array_copy.call(null, this__6153.arr, 0, new_arr__6164, 0, 2 * idx__6156);
          new_arr__6164[2 * idx__6156] = key;
          added_leaf_QMARK_[0] = true;
          new_arr__6164[2 * idx__6156 + 1] = val;
          cljs.core.array_copy.call(null, this__6153.arr, 2 * idx__6156, new_arr__6164, 2 * (idx__6156 + 1), 2 * (n__6157 - idx__6156));
          var editable__6165 = inode__6154.ensure_editable(edit);
          editable__6165.arr = new_arr__6164;
          editable__6165.bitmap = editable__6165.bitmap | bit__6155;
          return editable__6165
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__6166 = this__6153.arr[2 * idx__6156];
    var val_or_node__6167 = this__6153.arr[2 * idx__6156 + 1];
    if(null == key_or_nil__6166) {
      var n__6168 = val_or_node__6167.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6168 === val_or_node__6167) {
        return inode__6154
      }else {
        return cljs.core.edit_and_set.call(null, inode__6154, edit, 2 * idx__6156 + 1, n__6168)
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6166)) {
        if(val === val_or_node__6167) {
          return inode__6154
        }else {
          return cljs.core.edit_and_set.call(null, inode__6154, edit, 2 * idx__6156 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return cljs.core.edit_and_set.call(null, inode__6154, edit, 2 * idx__6156, null, 2 * idx__6156 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__6166, val_or_node__6167, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__6169 = this;
  var inode__6170 = this;
  return cljs.core.create_inode_seq.call(null, this__6169.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6171 = this;
  var inode__6172 = this;
  var bit__6173 = 1 << (hash >>> shift & 31);
  if((this__6171.bitmap & bit__6173) === 0) {
    return inode__6172
  }else {
    var idx__6174 = cljs.core.bitmap_indexed_node_index.call(null, this__6171.bitmap, bit__6173);
    var key_or_nil__6175 = this__6171.arr[2 * idx__6174];
    var val_or_node__6176 = this__6171.arr[2 * idx__6174 + 1];
    if(null == key_or_nil__6175) {
      var n__6177 = val_or_node__6176.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__6177 === val_or_node__6176) {
        return inode__6172
      }else {
        if(null != n__6177) {
          return cljs.core.edit_and_set.call(null, inode__6172, edit, 2 * idx__6174 + 1, n__6177)
        }else {
          if(this__6171.bitmap === bit__6173) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__6172.edit_and_remove_pair(edit, bit__6173, idx__6174)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6175)) {
        removed_leaf_QMARK_[0] = true;
        return inode__6172.edit_and_remove_pair(edit, bit__6173, idx__6174)
      }else {
        if("\ufdd0'else") {
          return inode__6172
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__6178 = this;
  var inode__6179 = this;
  if(e === this__6178.edit) {
    return inode__6179
  }else {
    var n__6180 = cljs.core.bit_count.call(null, this__6178.bitmap);
    var new_arr__6181 = cljs.core.make_array.call(null, n__6180 < 0 ? 4 : 2 * (n__6180 + 1));
    cljs.core.array_copy.call(null, this__6178.arr, 0, new_arr__6181, 0, 2 * n__6180);
    return new cljs.core.BitmapIndexedNode(e, this__6178.bitmap, new_arr__6181)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__6182 = this;
  var inode__6183 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6182.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function() {
  var G__6220 = null;
  var G__6220__3 = function(shift, hash, key) {
    var this__6184 = this;
    var inode__6185 = this;
    var bit__6186 = 1 << (hash >>> shift & 31);
    if((this__6184.bitmap & bit__6186) === 0) {
      return null
    }else {
      var idx__6187 = cljs.core.bitmap_indexed_node_index.call(null, this__6184.bitmap, bit__6186);
      var key_or_nil__6188 = this__6184.arr[2 * idx__6187];
      var val_or_node__6189 = this__6184.arr[2 * idx__6187 + 1];
      if(null == key_or_nil__6188) {
        return val_or_node__6189.inode_find(shift + 5, hash, key)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6188)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6188, val_or_node__6189])
        }else {
          if("\ufdd0'else") {
            return null
          }else {
            return null
          }
        }
      }
    }
  };
  var G__6220__4 = function(shift, hash, key, not_found) {
    var this__6190 = this;
    var inode__6191 = this;
    var bit__6192 = 1 << (hash >>> shift & 31);
    if((this__6190.bitmap & bit__6192) === 0) {
      return not_found
    }else {
      var idx__6193 = cljs.core.bitmap_indexed_node_index.call(null, this__6190.bitmap, bit__6192);
      var key_or_nil__6194 = this__6190.arr[2 * idx__6193];
      var val_or_node__6195 = this__6190.arr[2 * idx__6193 + 1];
      if(null == key_or_nil__6194) {
        return val_or_node__6195.inode_find(shift + 5, hash, key, not_found)
      }else {
        if(cljs.core._EQ_.call(null, key, key_or_nil__6194)) {
          return cljs.core.PersistentVector.fromArray([key_or_nil__6194, val_or_node__6195])
        }else {
          if("\ufdd0'else") {
            return not_found
          }else {
            return null
          }
        }
      }
    }
  };
  G__6220 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6220__3.call(this, shift, hash, key);
      case 4:
        return G__6220__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6220
}();
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__6196 = this;
  var inode__6197 = this;
  var bit__6198 = 1 << (hash >>> shift & 31);
  if((this__6196.bitmap & bit__6198) === 0) {
    return inode__6197
  }else {
    var idx__6199 = cljs.core.bitmap_indexed_node_index.call(null, this__6196.bitmap, bit__6198);
    var key_or_nil__6200 = this__6196.arr[2 * idx__6199];
    var val_or_node__6201 = this__6196.arr[2 * idx__6199 + 1];
    if(null == key_or_nil__6200) {
      var n__6202 = val_or_node__6201.inode_without(shift + 5, hash, key);
      if(n__6202 === val_or_node__6201) {
        return inode__6197
      }else {
        if(null != n__6202) {
          return new cljs.core.BitmapIndexedNode(null, this__6196.bitmap, cljs.core.clone_and_set.call(null, this__6196.arr, 2 * idx__6199 + 1, n__6202))
        }else {
          if(this__6196.bitmap === bit__6198) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__6196.bitmap ^ bit__6198, cljs.core.remove_pair.call(null, this__6196.arr, idx__6199))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6200)) {
        return new cljs.core.BitmapIndexedNode(null, this__6196.bitmap ^ bit__6198, cljs.core.remove_pair.call(null, this__6196.arr, idx__6199))
      }else {
        if("\ufdd0'else") {
          return inode__6197
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6203 = this;
  var inode__6204 = this;
  var bit__6205 = 1 << (hash >>> shift & 31);
  var idx__6206 = cljs.core.bitmap_indexed_node_index.call(null, this__6203.bitmap, bit__6205);
  if((this__6203.bitmap & bit__6205) === 0) {
    var n__6207 = cljs.core.bit_count.call(null, this__6203.bitmap);
    if(n__6207 >= 16) {
      var nodes__6208 = cljs.core.make_array.call(null, 32);
      var jdx__6209 = hash >>> shift & 31;
      nodes__6208[jdx__6209] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__6210 = 0;
      var j__6211 = 0;
      while(true) {
        if(i__6210 < 32) {
          if((this__6203.bitmap >>> i__6210 & 1) === 0) {
            var G__6221 = i__6210 + 1;
            var G__6222 = j__6211;
            i__6210 = G__6221;
            j__6211 = G__6222;
            continue
          }else {
            nodes__6208[i__6210] = null != this__6203.arr[j__6211] ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__6203.arr[j__6211]), this__6203.arr[j__6211], this__6203.arr[j__6211 + 1], added_leaf_QMARK_) : this__6203.arr[j__6211 + 1];
            var G__6223 = i__6210 + 1;
            var G__6224 = j__6211 + 2;
            i__6210 = G__6223;
            j__6211 = G__6224;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__6207 + 1, nodes__6208)
    }else {
      var new_arr__6212 = cljs.core.make_array.call(null, 2 * (n__6207 + 1));
      cljs.core.array_copy.call(null, this__6203.arr, 0, new_arr__6212, 0, 2 * idx__6206);
      new_arr__6212[2 * idx__6206] = key;
      added_leaf_QMARK_[0] = true;
      new_arr__6212[2 * idx__6206 + 1] = val;
      cljs.core.array_copy.call(null, this__6203.arr, 2 * idx__6206, new_arr__6212, 2 * (idx__6206 + 1), 2 * (n__6207 - idx__6206));
      return new cljs.core.BitmapIndexedNode(null, this__6203.bitmap | bit__6205, new_arr__6212)
    }
  }else {
    var key_or_nil__6213 = this__6203.arr[2 * idx__6206];
    var val_or_node__6214 = this__6203.arr[2 * idx__6206 + 1];
    if(null == key_or_nil__6213) {
      var n__6215 = val_or_node__6214.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__6215 === val_or_node__6214) {
        return inode__6204
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__6203.bitmap, cljs.core.clone_and_set.call(null, this__6203.arr, 2 * idx__6206 + 1, n__6215))
      }
    }else {
      if(cljs.core._EQ_.call(null, key, key_or_nil__6213)) {
        if(val === val_or_node__6214) {
          return inode__6204
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__6203.bitmap, cljs.core.clone_and_set.call(null, this__6203.arr, 2 * idx__6206 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_[0] = true;
          return new cljs.core.BitmapIndexedNode(null, this__6203.bitmap, cljs.core.clone_and_set.call(null, this__6203.arr, 2 * idx__6206, null, 2 * idx__6206 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__6213, val_or_node__6214, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__6225 = array_node.arr;
  var len__6226 = 2 * (array_node.cnt - 1);
  var new_arr__6227 = cljs.core.make_array.call(null, len__6226);
  var i__6228 = 0;
  var j__6229 = 1;
  var bitmap__6230 = 0;
  while(true) {
    if(i__6228 < len__6226) {
      if(function() {
        var and__3546__auto____6231 = i__6228 != idx;
        if(and__3546__auto____6231) {
          return null != arr__6225[i__6228]
        }else {
          return and__3546__auto____6231
        }
      }()) {
        new_arr__6227[j__6229] = arr__6225[i__6228];
        var G__6232 = i__6228 + 1;
        var G__6233 = j__6229 + 2;
        var G__6234 = bitmap__6230 | 1 << i__6228;
        i__6228 = G__6232;
        j__6229 = G__6233;
        bitmap__6230 = G__6234;
        continue
      }else {
        var G__6235 = i__6228 + 1;
        var G__6236 = j__6229;
        var G__6237 = bitmap__6230;
        i__6228 = G__6235;
        j__6229 = G__6236;
        bitmap__6230 = G__6237;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__6230, new_arr__6227)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6238 = this;
  var inode__6239 = this;
  var idx__6240 = hash >>> shift & 31;
  var node__6241 = this__6238.arr[idx__6240];
  if(null == node__6241) {
    return new cljs.core.ArrayNode(null, this__6238.cnt + 1, cljs.core.clone_and_set.call(null, this__6238.arr, idx__6240, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__6242 = node__6241.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6242 === node__6241) {
      return inode__6239
    }else {
      return new cljs.core.ArrayNode(null, this__6238.cnt, cljs.core.clone_and_set.call(null, this__6238.arr, idx__6240, n__6242))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__6243 = this;
  var inode__6244 = this;
  var idx__6245 = hash >>> shift & 31;
  var node__6246 = this__6243.arr[idx__6245];
  if(null != node__6246) {
    var n__6247 = node__6246.inode_without(shift + 5, hash, key);
    if(n__6247 === node__6246) {
      return inode__6244
    }else {
      if(n__6247 == null) {
        if(this__6243.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6244, null, idx__6245)
        }else {
          return new cljs.core.ArrayNode(null, this__6243.cnt - 1, cljs.core.clone_and_set.call(null, this__6243.arr, idx__6245, n__6247))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__6243.cnt, cljs.core.clone_and_set.call(null, this__6243.arr, idx__6245, n__6247))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__6244
  }
};
cljs.core.ArrayNode.prototype.inode_find = function() {
  var G__6279 = null;
  var G__6279__3 = function(shift, hash, key) {
    var this__6248 = this;
    var inode__6249 = this;
    var idx__6250 = hash >>> shift & 31;
    var node__6251 = this__6248.arr[idx__6250];
    if(null != node__6251) {
      return node__6251.inode_find(shift + 5, hash, key)
    }else {
      return null
    }
  };
  var G__6279__4 = function(shift, hash, key, not_found) {
    var this__6252 = this;
    var inode__6253 = this;
    var idx__6254 = hash >>> shift & 31;
    var node__6255 = this__6252.arr[idx__6254];
    if(null != node__6255) {
      return node__6255.inode_find(shift + 5, hash, key, not_found)
    }else {
      return not_found
    }
  };
  G__6279 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6279__3.call(this, shift, hash, key);
      case 4:
        return G__6279__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6279
}();
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__6256 = this;
  var inode__6257 = this;
  return cljs.core.create_array_node_seq.call(null, this__6256.arr)
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__6258 = this;
  var inode__6259 = this;
  if(e === this__6258.edit) {
    return inode__6259
  }else {
    return new cljs.core.ArrayNode(e, this__6258.cnt, cljs.core.aclone.call(null, this__6258.arr))
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6260 = this;
  var inode__6261 = this;
  var idx__6262 = hash >>> shift & 31;
  var node__6263 = this__6260.arr[idx__6262];
  if(null == node__6263) {
    var editable__6264 = cljs.core.edit_and_set.call(null, inode__6261, edit, idx__6262, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__6264.cnt = editable__6264.cnt + 1;
    return editable__6264
  }else {
    var n__6265 = node__6263.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__6265 === node__6263) {
      return inode__6261
    }else {
      return cljs.core.edit_and_set.call(null, inode__6261, edit, idx__6262, n__6265)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6266 = this;
  var inode__6267 = this;
  var idx__6268 = hash >>> shift & 31;
  var node__6269 = this__6266.arr[idx__6268];
  if(null == node__6269) {
    return inode__6267
  }else {
    var n__6270 = node__6269.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__6270 === node__6269) {
      return inode__6267
    }else {
      if(null == n__6270) {
        if(this__6266.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__6267, edit, idx__6268)
        }else {
          var editable__6271 = cljs.core.edit_and_set.call(null, inode__6267, edit, idx__6268, n__6270);
          editable__6271.cnt = editable__6271.cnt - 1;
          return editable__6271
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__6267, edit, idx__6268, n__6270)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__6272 = this;
  var inode__6273 = this;
  var len__6274 = this__6272.arr.length;
  var i__6275 = 0;
  var init__6276 = init;
  while(true) {
    if(i__6275 < len__6274) {
      var node__6277 = this__6272.arr[i__6275];
      if(node__6277 != null) {
        var init__6278 = node__6277.kv_reduce(f, init__6276);
        if(cljs.core.reduced_QMARK_.call(null, init__6278)) {
          return cljs.core.deref.call(null, init__6278)
        }else {
          var G__6280 = i__6275 + 1;
          var G__6281 = init__6278;
          i__6275 = G__6280;
          init__6276 = G__6281;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__6276
    }
    break
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__6282 = 2 * cnt;
  var i__6283 = 0;
  while(true) {
    if(i__6283 < lim__6282) {
      if(cljs.core._EQ_.call(null, key, arr[i__6283])) {
        return i__6283
      }else {
        var G__6284 = i__6283 + 2;
        i__6283 = G__6284;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__6285 = this;
  var inode__6286 = this;
  if(hash === this__6285.collision_hash) {
    var idx__6287 = cljs.core.hash_collision_node_find_index.call(null, this__6285.arr, this__6285.cnt, key);
    if(idx__6287 === -1) {
      var len__6288 = this__6285.arr.length;
      var new_arr__6289 = cljs.core.make_array.call(null, len__6288 + 2);
      cljs.core.array_copy.call(null, this__6285.arr, 0, new_arr__6289, 0, len__6288);
      new_arr__6289[len__6288] = key;
      new_arr__6289[len__6288 + 1] = val;
      added_leaf_QMARK_[0] = true;
      return new cljs.core.HashCollisionNode(null, this__6285.collision_hash, this__6285.cnt + 1, new_arr__6289)
    }else {
      if(cljs.core._EQ_.call(null, this__6285.arr[idx__6287], val)) {
        return inode__6286
      }else {
        return new cljs.core.HashCollisionNode(null, this__6285.collision_hash, this__6285.cnt, cljs.core.clone_and_set.call(null, this__6285.arr, idx__6287 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__6285.collision_hash >>> shift & 31), [null, inode__6286])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__6290 = this;
  var inode__6291 = this;
  var idx__6292 = cljs.core.hash_collision_node_find_index.call(null, this__6290.arr, this__6290.cnt, key);
  if(idx__6292 === -1) {
    return inode__6291
  }else {
    if(this__6290.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__6290.collision_hash, this__6290.cnt - 1, cljs.core.remove_pair.call(null, this__6290.arr, cljs.core.quot.call(null, idx__6292, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function() {
  var G__6319 = null;
  var G__6319__3 = function(shift, hash, key) {
    var this__6293 = this;
    var inode__6294 = this;
    var idx__6295 = cljs.core.hash_collision_node_find_index.call(null, this__6293.arr, this__6293.cnt, key);
    if(idx__6295 < 0) {
      return null
    }else {
      if(cljs.core._EQ_.call(null, key, this__6293.arr[idx__6295])) {
        return cljs.core.PersistentVector.fromArray([this__6293.arr[idx__6295], this__6293.arr[idx__6295 + 1]])
      }else {
        if("\ufdd0'else") {
          return null
        }else {
          return null
        }
      }
    }
  };
  var G__6319__4 = function(shift, hash, key, not_found) {
    var this__6296 = this;
    var inode__6297 = this;
    var idx__6298 = cljs.core.hash_collision_node_find_index.call(null, this__6296.arr, this__6296.cnt, key);
    if(idx__6298 < 0) {
      return not_found
    }else {
      if(cljs.core._EQ_.call(null, key, this__6296.arr[idx__6298])) {
        return cljs.core.PersistentVector.fromArray([this__6296.arr[idx__6298], this__6296.arr[idx__6298 + 1]])
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  };
  G__6319 = function(shift, hash, key, not_found) {
    switch(arguments.length) {
      case 3:
        return G__6319__3.call(this, shift, hash, key);
      case 4:
        return G__6319__4.call(this, shift, hash, key, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6319
}();
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__6299 = this;
  var inode__6300 = this;
  return cljs.core.create_inode_seq.call(null, this__6299.arr)
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function() {
  var G__6320 = null;
  var G__6320__1 = function(e) {
    var this__6301 = this;
    var inode__6302 = this;
    if(e === this__6301.edit) {
      return inode__6302
    }else {
      var new_arr__6303 = cljs.core.make_array.call(null, 2 * (this__6301.cnt + 1));
      cljs.core.array_copy.call(null, this__6301.arr, 0, new_arr__6303, 0, 2 * this__6301.cnt);
      return new cljs.core.HashCollisionNode(e, this__6301.collision_hash, this__6301.cnt, new_arr__6303)
    }
  };
  var G__6320__3 = function(e, count, array) {
    var this__6304 = this;
    var inode__6305 = this;
    if(e === this__6304.edit) {
      this__6304.arr = array;
      this__6304.cnt = count;
      return inode__6305
    }else {
      return new cljs.core.HashCollisionNode(this__6304.edit, this__6304.collision_hash, count, array)
    }
  };
  G__6320 = function(e, count, array) {
    switch(arguments.length) {
      case 1:
        return G__6320__1.call(this, e);
      case 3:
        return G__6320__3.call(this, e, count, array)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6320
}();
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__6306 = this;
  var inode__6307 = this;
  if(hash === this__6306.collision_hash) {
    var idx__6308 = cljs.core.hash_collision_node_find_index.call(null, this__6306.arr, this__6306.cnt, key);
    if(idx__6308 === -1) {
      if(this__6306.arr.length > 2 * this__6306.cnt) {
        var editable__6309 = cljs.core.edit_and_set.call(null, inode__6307, edit, 2 * this__6306.cnt, key, 2 * this__6306.cnt + 1, val);
        added_leaf_QMARK_[0] = true;
        editable__6309.cnt = editable__6309.cnt + 1;
        return editable__6309
      }else {
        var len__6310 = this__6306.arr.length;
        var new_arr__6311 = cljs.core.make_array.call(null, len__6310 + 2);
        cljs.core.array_copy.call(null, this__6306.arr, 0, new_arr__6311, 0, len__6310);
        new_arr__6311[len__6310] = key;
        new_arr__6311[len__6310 + 1] = val;
        added_leaf_QMARK_[0] = true;
        return inode__6307.ensure_editable(edit, this__6306.cnt + 1, new_arr__6311)
      }
    }else {
      if(this__6306.arr[idx__6308 + 1] === val) {
        return inode__6307
      }else {
        return cljs.core.edit_and_set.call(null, inode__6307, edit, idx__6308 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__6306.collision_hash >>> shift & 31), [null, inode__6307, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__6312 = this;
  var inode__6313 = this;
  var idx__6314 = cljs.core.hash_collision_node_find_index.call(null, this__6312.arr, this__6312.cnt, key);
  if(idx__6314 === -1) {
    return inode__6313
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__6312.cnt === 1) {
      return null
    }else {
      var editable__6315 = inode__6313.ensure_editable(edit);
      var earr__6316 = editable__6315.arr;
      earr__6316[idx__6314] = earr__6316[2 * this__6312.cnt - 2];
      earr__6316[idx__6314 + 1] = earr__6316[2 * this__6312.cnt - 1];
      earr__6316[2 * this__6312.cnt - 1] = null;
      earr__6316[2 * this__6312.cnt - 2] = null;
      editable__6315.cnt = editable__6315.cnt - 1;
      return editable__6315
    }
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__6317 = this;
  var inode__6318 = this;
  return cljs.core.inode_kv_reduce.call(null, this__6317.arr, f, init)
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6321 = cljs.core.hash.call(null, key1);
    if(key1hash__6321 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6321, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6322 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__6321, key1, val1, added_leaf_QMARK___6322).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___6322)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__6323 = cljs.core.hash.call(null, key1);
    if(key1hash__6323 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__6323, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___6324 = [false];
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__6323, key1, val1, added_leaf_QMARK___6324).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___6324)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6325 = this;
  var h__364__auto____6326 = this__6325.__hash;
  if(h__364__auto____6326 != null) {
    return h__364__auto____6326
  }else {
    var h__364__auto____6327 = cljs.core.hash_coll.call(null, coll);
    this__6325.__hash = h__364__auto____6327;
    return h__364__auto____6327
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6328 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__6329 = this;
  var this$__6330 = this;
  return cljs.core.pr_str.call(null, this$__6330)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6331 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6332 = this;
  if(this__6332.s == null) {
    return cljs.core.PersistentVector.fromArray([this__6332.nodes[this__6332.i], this__6332.nodes[this__6332.i + 1]])
  }else {
    return cljs.core.first.call(null, this__6332.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6333 = this;
  if(this__6333.s == null) {
    return cljs.core.create_inode_seq.call(null, this__6333.nodes, this__6333.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__6333.nodes, this__6333.i, cljs.core.next.call(null, this__6333.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6334 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6335 = this;
  return new cljs.core.NodeSeq(meta, this__6335.nodes, this__6335.i, this__6335.s, this__6335.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6336 = this;
  return this__6336.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6337 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6337.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__6338 = nodes.length;
      var j__6339 = i;
      while(true) {
        if(j__6339 < len__6338) {
          if(null != nodes[j__6339]) {
            return new cljs.core.NodeSeq(null, nodes, j__6339, null, null)
          }else {
            var temp__3695__auto____6340 = nodes[j__6339 + 1];
            if(cljs.core.truth_(temp__3695__auto____6340)) {
              var node__6341 = temp__3695__auto____6340;
              var temp__3695__auto____6342 = node__6341.inode_seq();
              if(cljs.core.truth_(temp__3695__auto____6342)) {
                var node_seq__6343 = temp__3695__auto____6342;
                return new cljs.core.NodeSeq(null, nodes, j__6339 + 2, node_seq__6343, null)
              }else {
                var G__6344 = j__6339 + 2;
                j__6339 = G__6344;
                continue
              }
            }else {
              var G__6345 = j__6339 + 2;
              j__6339 = G__6345;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925324
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6346 = this;
  var h__364__auto____6347 = this__6346.__hash;
  if(h__364__auto____6347 != null) {
    return h__364__auto____6347
  }else {
    var h__364__auto____6348 = cljs.core.hash_coll.call(null, coll);
    this__6346.__hash = h__364__auto____6348;
    return h__364__auto____6348
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6349 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__6350 = this;
  var this$__6351 = this;
  return cljs.core.pr_str.call(null, this$__6351)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6352 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6353 = this;
  return cljs.core.first.call(null, this__6353.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6354 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__6354.nodes, this__6354.i, cljs.core.next.call(null, this__6354.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6355 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6356 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__6356.nodes, this__6356.i, this__6356.s, this__6356.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6357 = this;
  return this__6357.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6358 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6358.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__6359 = nodes.length;
      var j__6360 = i;
      while(true) {
        if(j__6360 < len__6359) {
          var temp__3695__auto____6361 = nodes[j__6360];
          if(cljs.core.truth_(temp__3695__auto____6361)) {
            var nj__6362 = temp__3695__auto____6361;
            var temp__3695__auto____6363 = nj__6362.inode_seq();
            if(cljs.core.truth_(temp__3695__auto____6363)) {
              var ns__6364 = temp__3695__auto____6363;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__6360 + 1, ns__6364, null)
            }else {
              var G__6365 = j__6360 + 1;
              j__6360 = G__6365;
              continue
            }
          }else {
            var G__6366 = j__6360 + 1;
            j__6360 = G__6366;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
void 0;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155545487
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6371 = this;
  return new cljs.core.TransientHashMap({}, this__6371.root, this__6371.cnt, this__6371.has_nil_QMARK_, this__6371.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6372 = this;
  var h__364__auto____6373 = this__6372.__hash;
  if(h__364__auto____6373 != null) {
    return h__364__auto____6373
  }else {
    var h__364__auto____6374 = cljs.core.hash_imap.call(null, coll);
    this__6372.__hash = h__364__auto____6374;
    return h__364__auto____6374
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6375 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6376 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6376.has_nil_QMARK_)) {
      return this__6376.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6376.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return cljs.core.nth.call(null, this__6376.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6377 = this;
  if(k == null) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6378 = this__6377.has_nil_QMARK_;
      if(cljs.core.truth_(and__3546__auto____6378)) {
        return v === this__6377.nil_val
      }else {
        return and__3546__auto____6378
      }
    }())) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6377.meta, cljs.core.truth_(this__6377.has_nil_QMARK_) ? this__6377.cnt : this__6377.cnt + 1, this__6377.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___6379 = [false];
    var new_root__6380 = (this__6377.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6377.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6379);
    if(new_root__6380 === this__6377.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__6377.meta, cljs.core.truth_(added_leaf_QMARK___6379[0]) ? this__6377.cnt + 1 : this__6377.cnt, new_root__6380, this__6377.has_nil_QMARK_, this__6377.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6381 = this;
  if(k == null) {
    return this__6381.has_nil_QMARK_
  }else {
    if(this__6381.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return cljs.core.not.call(null, this__6381.root.inode_find(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__6402 = null;
  var G__6402__2 = function(tsym6369, k) {
    var this__6382 = this;
    var tsym6369__6383 = this;
    var coll__6384 = tsym6369__6383;
    return cljs.core._lookup.call(null, coll__6384, k)
  };
  var G__6402__3 = function(tsym6370, k, not_found) {
    var this__6385 = this;
    var tsym6370__6386 = this;
    var coll__6387 = tsym6370__6386;
    return cljs.core._lookup.call(null, coll__6387, k, not_found)
  };
  G__6402 = function(tsym6370, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6402__2.call(this, tsym6370, k);
      case 3:
        return G__6402__3.call(this, tsym6370, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6402
}();
cljs.core.PersistentHashMap.prototype.apply = function(tsym6367, args6368) {
  return tsym6367.call.apply(tsym6367, [tsym6367].concat(cljs.core.aclone.call(null, args6368)))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6388 = this;
  var init__6389 = cljs.core.truth_(this__6388.has_nil_QMARK_) ? f.call(null, init, null, this__6388.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__6389)) {
    return cljs.core.deref.call(null, init__6389)
  }else {
    if(null != this__6388.root) {
      return this__6388.root.kv_reduce(f, init__6389)
    }else {
      if("\ufdd0'else") {
        return init__6389
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6390 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__6391 = this;
  var this$__6392 = this;
  return cljs.core.pr_str.call(null, this$__6392)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6393 = this;
  if(this__6393.cnt > 0) {
    var s__6394 = null != this__6393.root ? this__6393.root.inode_seq() : null;
    if(cljs.core.truth_(this__6393.has_nil_QMARK_)) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__6393.nil_val]), s__6394)
    }else {
      return s__6394
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6395 = this;
  return this__6395.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6396 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6397 = this;
  return new cljs.core.PersistentHashMap(meta, this__6397.cnt, this__6397.root, this__6397.has_nil_QMARK_, this__6397.nil_val, this__6397.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6398 = this;
  return this__6398.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6399 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__6399.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6400 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6400.has_nil_QMARK_)) {
      return new cljs.core.PersistentHashMap(this__6400.meta, this__6400.cnt - 1, this__6400.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__6400.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__6401 = this__6400.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__6401 === this__6400.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__6400.meta, this__6400.cnt - 1, new_root__6401, this__6400.has_nil_QMARK_, this__6400.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__6403 = ks.length;
  var i__6404 = 0;
  var out__6405 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__6404 < len__6403) {
      var G__6406 = i__6404 + 1;
      var G__6407 = cljs.core.assoc_BANG_.call(null, out__6405, ks[i__6404], vs[i__6404]);
      i__6404 = G__6406;
      out__6405 = G__6407;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6405)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 7;
  this.cljs$lang$protocol_mask$partition0$ = 130
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__6408 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__6409 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__6410 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6411 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__6412 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6412.has_nil_QMARK_)) {
      return this__6412.nil_val
    }else {
      return null
    }
  }else {
    if(this__6412.root == null) {
      return null
    }else {
      return cljs.core.nth.call(null, this__6412.root.inode_find(0, cljs.core.hash.call(null, k), k), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__6413 = this;
  if(k == null) {
    if(cljs.core.truth_(this__6413.has_nil_QMARK_)) {
      return this__6413.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__6413.root == null) {
      return not_found
    }else {
      return cljs.core.nth.call(null, this__6413.root.inode_find(0, cljs.core.hash.call(null, k), k, [null, not_found]), 1)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6414 = this;
  if(cljs.core.truth_(this__6414.edit)) {
    return this__6414.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__6415 = this;
  var tcoll__6416 = this;
  if(cljs.core.truth_(this__6415.edit)) {
    if(function() {
      var G__6417__6418 = o;
      if(G__6417__6418 != null) {
        if(function() {
          var or__3548__auto____6419 = G__6417__6418.cljs$lang$protocol_mask$partition0$ & 1024;
          if(or__3548__auto____6419) {
            return or__3548__auto____6419
          }else {
            return G__6417__6418.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__6417__6418.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6417__6418)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__6417__6418)
      }
    }()) {
      return tcoll__6416.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__6420 = cljs.core.seq.call(null, o);
      var tcoll__6421 = tcoll__6416;
      while(true) {
        var temp__3695__auto____6422 = cljs.core.first.call(null, es__6420);
        if(cljs.core.truth_(temp__3695__auto____6422)) {
          var e__6423 = temp__3695__auto____6422;
          var G__6434 = cljs.core.next.call(null, es__6420);
          var G__6435 = tcoll__6421.assoc_BANG_(cljs.core.key.call(null, e__6423), cljs.core.val.call(null, e__6423));
          es__6420 = G__6434;
          tcoll__6421 = G__6435;
          continue
        }else {
          return tcoll__6421
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__6424 = this;
  var tcoll__6425 = this;
  if(cljs.core.truth_(this__6424.edit)) {
    if(k == null) {
      if(this__6424.nil_val === v) {
      }else {
        this__6424.nil_val = v
      }
      if(cljs.core.truth_(this__6424.has_nil_QMARK_)) {
      }else {
        this__6424.count = this__6424.count + 1;
        this__6424.has_nil_QMARK_ = true
      }
      return tcoll__6425
    }else {
      var added_leaf_QMARK___6426 = [false];
      var node__6427 = (this__6424.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__6424.root).inode_assoc_BANG_(this__6424.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___6426);
      if(node__6427 === this__6424.root) {
      }else {
        this__6424.root = node__6427
      }
      if(cljs.core.truth_(added_leaf_QMARK___6426[0])) {
        this__6424.count = this__6424.count + 1
      }else {
      }
      return tcoll__6425
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__6428 = this;
  var tcoll__6429 = this;
  if(cljs.core.truth_(this__6428.edit)) {
    if(k == null) {
      if(cljs.core.truth_(this__6428.has_nil_QMARK_)) {
        this__6428.has_nil_QMARK_ = false;
        this__6428.nil_val = null;
        this__6428.count = this__6428.count - 1;
        return tcoll__6429
      }else {
        return tcoll__6429
      }
    }else {
      if(this__6428.root == null) {
        return tcoll__6429
      }else {
        var removed_leaf_QMARK___6430 = [false];
        var node__6431 = this__6428.root.inode_without_BANG_(this__6428.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___6430);
        if(node__6431 === this__6428.root) {
        }else {
          this__6428.root = node__6431
        }
        if(cljs.core.truth_(removed_leaf_QMARK___6430[0])) {
          this__6428.count = this__6428.count - 1
        }else {
        }
        return tcoll__6429
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__6432 = this;
  var tcoll__6433 = this;
  if(cljs.core.truth_(this__6432.edit)) {
    this__6432.edit = null;
    return new cljs.core.PersistentHashMap(null, this__6432.count, this__6432.root, this__6432.has_nil_QMARK_, this__6432.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__6436 = node;
  var stack__6437 = stack;
  while(true) {
    if(t__6436 != null) {
      var G__6438 = cljs.core.truth_(ascending_QMARK_) ? t__6436.left : t__6436.right;
      var G__6439 = cljs.core.conj.call(null, stack__6437, t__6436);
      t__6436 = G__6438;
      stack__6437 = G__6439;
      continue
    }else {
      return stack__6437
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15925322
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6440 = this;
  var h__364__auto____6441 = this__6440.__hash;
  if(h__364__auto____6441 != null) {
    return h__364__auto____6441
  }else {
    var h__364__auto____6442 = cljs.core.hash_coll.call(null, coll);
    this__6440.__hash = h__364__auto____6442;
    return h__364__auto____6442
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6443 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__6444 = this;
  var this$__6445 = this;
  return cljs.core.pr_str.call(null, this$__6445)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6446 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6447 = this;
  if(this__6447.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__6447.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__6448 = this;
  return cljs.core.peek.call(null, this__6448.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__6449 = this;
  var t__6450 = cljs.core.peek.call(null, this__6449.stack);
  var next_stack__6451 = cljs.core.tree_map_seq_push.call(null, cljs.core.truth_(this__6449.ascending_QMARK_) ? t__6450.right : t__6450.left, cljs.core.pop.call(null, this__6449.stack), this__6449.ascending_QMARK_);
  if(next_stack__6451 != null) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__6451, this__6449.ascending_QMARK_, this__6449.cnt - 1, null)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6452 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6453 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__6453.stack, this__6453.ascending_QMARK_, this__6453.cnt, this__6453.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6454 = this;
  return this__6454.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
void 0;
void 0;
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3546__auto____6455 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3546__auto____6455) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3546__auto____6455
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3546__auto____6456 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3546__auto____6456) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3546__auto____6456
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__6457 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__6457)) {
    return cljs.core.deref.call(null, init__6457)
  }else {
    var init__6458 = node.left != null ? tree_map_kv_reduce.call(null, node.left, f, init__6457) : init__6457;
    if(cljs.core.reduced_QMARK_.call(null, init__6458)) {
      return cljs.core.deref.call(null, init__6458)
    }else {
      var init__6459 = node.right != null ? tree_map_kv_reduce.call(null, node.right, f, init__6458) : init__6458;
      if(cljs.core.reduced_QMARK_.call(null, init__6459)) {
        return cljs.core.deref.call(null, init__6459)
      }else {
        return init__6459
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$ = true;
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6464 = this;
  var h__364__auto____6465 = this__6464.__hash;
  if(h__364__auto____6465 != null) {
    return h__364__auto____6465
  }else {
    var h__364__auto____6466 = cljs.core.hash_coll.call(null, coll);
    this__6464.__hash = h__364__auto____6466;
    return h__364__auto____6466
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$ = true;
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6467 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6468 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6469 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6469.key, this__6469.val]), k, v)
};
cljs.core.BlackNode.prototype.cljs$core$IFn$ = true;
cljs.core.BlackNode.prototype.call = function() {
  var G__6516 = null;
  var G__6516__2 = function(tsym6462, k) {
    var this__6470 = this;
    var tsym6462__6471 = this;
    var node__6472 = tsym6462__6471;
    return cljs.core._lookup.call(null, node__6472, k)
  };
  var G__6516__3 = function(tsym6463, k, not_found) {
    var this__6473 = this;
    var tsym6463__6474 = this;
    var node__6475 = tsym6463__6474;
    return cljs.core._lookup.call(null, node__6475, k, not_found)
  };
  G__6516 = function(tsym6463, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6516__2.call(this, tsym6463, k);
      case 3:
        return G__6516__3.call(this, tsym6463, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6516
}();
cljs.core.BlackNode.prototype.apply = function(tsym6460, args6461) {
  return tsym6460.call.apply(tsym6460, [tsym6460].concat(cljs.core.aclone.call(null, args6461)))
};
cljs.core.BlackNode.prototype.cljs$core$ISequential$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6476 = this;
  return cljs.core.PersistentVector.fromArray([this__6476.key, this__6476.val, o])
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6477 = this;
  return this__6477.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6478 = this;
  return this__6478.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__6479 = this;
  var node__6480 = this;
  return ins.balance_right(node__6480)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__6481 = this;
  var node__6482 = this;
  return new cljs.core.RedNode(this__6481.key, this__6481.val, this__6481.left, this__6481.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__6483 = this;
  var node__6484 = this;
  return cljs.core.balance_right_del.call(null, this__6483.key, this__6483.val, this__6483.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__6485 = this;
  var node__6486 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__6487 = this;
  var node__6488 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6488, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__6489 = this;
  var node__6490 = this;
  return cljs.core.balance_left_del.call(null, this__6489.key, this__6489.val, del, this__6489.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__6491 = this;
  var node__6492 = this;
  return ins.balance_left(node__6492)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__6493 = this;
  var node__6494 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__6494, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__6517 = null;
  var G__6517__0 = function() {
    var this__6497 = this;
    var this$__6498 = this;
    return cljs.core.pr_str.call(null, this$__6498)
  };
  G__6517 = function() {
    switch(arguments.length) {
      case 0:
        return G__6517__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6517
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__6499 = this;
  var node__6500 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6500, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__6501 = this;
  var node__6502 = this;
  return node__6502
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$ = true;
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6503 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6504 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6505 = this;
  return cljs.core.list.call(null, this__6505.key, this__6505.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$ = true;
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6507 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$ = true;
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6508 = this;
  return this__6508.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6509 = this;
  return cljs.core.PersistentVector.fromArray([this__6509.key])
};
cljs.core.BlackNode.prototype.cljs$core$IVector$ = true;
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6510 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6510.key, this__6510.val]), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6511 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6512 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6512.key, this__6512.val]), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$ = true;
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6513 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6514 = this;
  if(n === 0) {
    return this__6514.key
  }else {
    if(n === 1) {
      return this__6514.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6515 = this;
  if(n === 0) {
    return this__6515.key
  }else {
    if(n === 1) {
      return this__6515.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6506 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16201119
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$ = true;
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6522 = this;
  var h__364__auto____6523 = this__6522.__hash;
  if(h__364__auto____6523 != null) {
    return h__364__auto____6523
  }else {
    var h__364__auto____6524 = cljs.core.hash_coll.call(null, coll);
    this__6522.__hash = h__364__auto____6524;
    return h__364__auto____6524
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$ = true;
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__6525 = this;
  return cljs.core._nth.call(null, node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__6526 = this;
  return cljs.core._nth.call(null, node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$ = true;
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__6527 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__6527.key, this__6527.val]), k, v)
};
cljs.core.RedNode.prototype.cljs$core$IFn$ = true;
cljs.core.RedNode.prototype.call = function() {
  var G__6574 = null;
  var G__6574__2 = function(tsym6520, k) {
    var this__6528 = this;
    var tsym6520__6529 = this;
    var node__6530 = tsym6520__6529;
    return cljs.core._lookup.call(null, node__6530, k)
  };
  var G__6574__3 = function(tsym6521, k, not_found) {
    var this__6531 = this;
    var tsym6521__6532 = this;
    var node__6533 = tsym6521__6532;
    return cljs.core._lookup.call(null, node__6533, k, not_found)
  };
  G__6574 = function(tsym6521, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6574__2.call(this, tsym6521, k);
      case 3:
        return G__6574__3.call(this, tsym6521, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6574
}();
cljs.core.RedNode.prototype.apply = function(tsym6518, args6519) {
  return tsym6518.call.apply(tsym6518, [tsym6518].concat(cljs.core.aclone.call(null, args6519)))
};
cljs.core.RedNode.prototype.cljs$core$ISequential$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$ = true;
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__6534 = this;
  return cljs.core.PersistentVector.fromArray([this__6534.key, this__6534.val, o])
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$ = true;
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__6535 = this;
  return this__6535.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__6536 = this;
  return this__6536.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__6537 = this;
  var node__6538 = this;
  return new cljs.core.RedNode(this__6537.key, this__6537.val, this__6537.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__6539 = this;
  var node__6540 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__6541 = this;
  var node__6542 = this;
  return new cljs.core.RedNode(this__6541.key, this__6541.val, this__6541.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__6543 = this;
  var node__6544 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__6545 = this;
  var node__6546 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__6546, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__6547 = this;
  var node__6548 = this;
  return new cljs.core.RedNode(this__6547.key, this__6547.val, del, this__6547.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__6549 = this;
  var node__6550 = this;
  return new cljs.core.RedNode(this__6549.key, this__6549.val, ins, this__6549.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__6551 = this;
  var node__6552 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6551.left)) {
    return new cljs.core.RedNode(this__6551.key, this__6551.val, this__6551.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__6551.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6551.right)) {
      return new cljs.core.RedNode(this__6551.right.key, this__6551.right.val, new cljs.core.BlackNode(this__6551.key, this__6551.val, this__6551.left, this__6551.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__6551.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__6552, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__6575 = null;
  var G__6575__0 = function() {
    var this__6555 = this;
    var this$__6556 = this;
    return cljs.core.pr_str.call(null, this$__6556)
  };
  G__6575 = function() {
    switch(arguments.length) {
      case 0:
        return G__6575__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6575
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__6557 = this;
  var node__6558 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6557.right)) {
    return new cljs.core.RedNode(this__6557.key, this__6557.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6557.left, null), this__6557.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__6557.left)) {
      return new cljs.core.RedNode(this__6557.left.key, this__6557.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__6557.left.left, null), new cljs.core.BlackNode(this__6557.key, this__6557.val, this__6557.left.right, this__6557.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__6558, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__6559 = this;
  var node__6560 = this;
  return new cljs.core.BlackNode(this__6559.key, this__6559.val, this__6559.left, this__6559.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$ = true;
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__6561 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__6562 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$ = true;
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__6563 = this;
  return cljs.core.list.call(null, this__6563.key, this__6563.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$ = true;
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__6565 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$ = true;
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__6566 = this;
  return this__6566.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__6567 = this;
  return cljs.core.PersistentVector.fromArray([this__6567.key])
};
cljs.core.RedNode.prototype.cljs$core$IVector$ = true;
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__6568 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__6568.key, this__6568.val]), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$ = true;
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6569 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__6570 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__6570.key, this__6570.val]), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$ = true;
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__6571 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$ = true;
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__6572 = this;
  if(n === 0) {
    return this__6572.key
  }else {
    if(n === 1) {
      return this__6572.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__6573 = this;
  if(n === 0) {
    return this__6573.key
  }else {
    if(n === 1) {
      return this__6573.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__6564 = this;
  return cljs.core.PersistentVector.fromArray([])
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__6576 = comp.call(null, k, tree.key);
    if(c__6576 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__6576 < 0) {
        var ins__6577 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(ins__6577 != null) {
          return tree.add_left(ins__6577)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__6578 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(ins__6578 != null) {
            return tree.add_right(ins__6578)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__6579 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6579)) {
            return new cljs.core.RedNode(app__6579.key, app__6579.val, new cljs.core.RedNode(left.key, left.val, left.left, app__6579.left), new cljs.core.RedNode(right.key, right.val, app__6579.right, right.right), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__6579, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__6580 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__6580)) {
              return new cljs.core.RedNode(app__6580.key, app__6580.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__6580.left, null), new cljs.core.BlackNode(right.key, right.val, app__6580.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__6580, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(tree != null) {
    var c__6581 = comp.call(null, k, tree.key);
    if(c__6581 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__6581 < 0) {
        var del__6582 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3548__auto____6583 = del__6582 != null;
          if(or__3548__auto____6583) {
            return or__3548__auto____6583
          }else {
            return found[0] != null
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__6582, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__6582, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__6584 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3548__auto____6585 = del__6584 != null;
            if(or__3548__auto____6585) {
              return or__3548__auto____6585
            }else {
              return found[0] != null
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__6584)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__6584, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__6586 = tree.key;
  var c__6587 = comp.call(null, k, tk__6586);
  if(c__6587 === 0) {
    return tree.replace(tk__6586, v, tree.left, tree.right)
  }else {
    if(c__6587 < 0) {
      return tree.replace(tk__6586, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__6586, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
void 0;
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 209388431
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6592 = this;
  var h__364__auto____6593 = this__6592.__hash;
  if(h__364__auto____6593 != null) {
    return h__364__auto____6593
  }else {
    var h__364__auto____6594 = cljs.core.hash_imap.call(null, coll);
    this__6592.__hash = h__364__auto____6594;
    return h__364__auto____6594
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__6595 = this;
  return cljs.core._lookup.call(null, coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__6596 = this;
  var n__6597 = coll.entry_at(k);
  if(n__6597 != null) {
    return n__6597.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__6598 = this;
  var found__6599 = [null];
  var t__6600 = cljs.core.tree_map_add.call(null, this__6598.comp, this__6598.tree, k, v, found__6599);
  if(t__6600 == null) {
    var found_node__6601 = cljs.core.nth.call(null, found__6599, 0);
    if(cljs.core._EQ_.call(null, v, found_node__6601.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6598.comp, cljs.core.tree_map_replace.call(null, this__6598.comp, this__6598.tree, k, v), this__6598.cnt, this__6598.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6598.comp, t__6600.blacken(), this__6598.cnt + 1, this__6598.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__6602 = this;
  return coll.entry_at(k) != null
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__6634 = null;
  var G__6634__2 = function(tsym6590, k) {
    var this__6603 = this;
    var tsym6590__6604 = this;
    var coll__6605 = tsym6590__6604;
    return cljs.core._lookup.call(null, coll__6605, k)
  };
  var G__6634__3 = function(tsym6591, k, not_found) {
    var this__6606 = this;
    var tsym6591__6607 = this;
    var coll__6608 = tsym6591__6607;
    return cljs.core._lookup.call(null, coll__6608, k, not_found)
  };
  G__6634 = function(tsym6591, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6634__2.call(this, tsym6591, k);
      case 3:
        return G__6634__3.call(this, tsym6591, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6634
}();
cljs.core.PersistentTreeMap.prototype.apply = function(tsym6588, args6589) {
  return tsym6588.call.apply(tsym6588, [tsym6588].concat(cljs.core.aclone.call(null, args6589)))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__6609 = this;
  if(this__6609.tree != null) {
    return cljs.core.tree_map_kv_reduce.call(null, this__6609.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__6610 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6611 = this;
  if(this__6611.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6611.tree, false, this__6611.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__6612 = this;
  var this$__6613 = this;
  return cljs.core.pr_str.call(null, this$__6613)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__6614 = this;
  var coll__6615 = this;
  var t__6616 = this__6614.tree;
  while(true) {
    if(t__6616 != null) {
      var c__6617 = this__6614.comp.call(null, k, t__6616.key);
      if(c__6617 === 0) {
        return t__6616
      }else {
        if(c__6617 < 0) {
          var G__6635 = t__6616.left;
          t__6616 = G__6635;
          continue
        }else {
          if("\ufdd0'else") {
            var G__6636 = t__6616.right;
            t__6616 = G__6636;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6618 = this;
  if(this__6618.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6618.tree, ascending_QMARK_, this__6618.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6619 = this;
  if(this__6619.cnt > 0) {
    var stack__6620 = null;
    var t__6621 = this__6619.tree;
    while(true) {
      if(t__6621 != null) {
        var c__6622 = this__6619.comp.call(null, k, t__6621.key);
        if(c__6622 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__6620, t__6621), ascending_QMARK_, -1)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__6622 < 0) {
              var G__6637 = cljs.core.conj.call(null, stack__6620, t__6621);
              var G__6638 = t__6621.left;
              stack__6620 = G__6637;
              t__6621 = G__6638;
              continue
            }else {
              var G__6639 = stack__6620;
              var G__6640 = t__6621.right;
              stack__6620 = G__6639;
              t__6621 = G__6640;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__6622 > 0) {
                var G__6641 = cljs.core.conj.call(null, stack__6620, t__6621);
                var G__6642 = t__6621.right;
                stack__6620 = G__6641;
                t__6621 = G__6642;
                continue
              }else {
                var G__6643 = stack__6620;
                var G__6644 = t__6621.left;
                stack__6620 = G__6643;
                t__6621 = G__6644;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__6620 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__6620, ascending_QMARK_, -1)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6623 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6624 = this;
  return this__6624.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6625 = this;
  if(this__6625.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__6625.tree, true, this__6625.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6626 = this;
  return this__6626.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6627 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6628 = this;
  return new cljs.core.PersistentTreeMap(this__6628.comp, this__6628.tree, this__6628.cnt, meta, this__6628.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6632 = this;
  return this__6632.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6633 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__6633.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__6629 = this;
  var found__6630 = [null];
  var t__6631 = cljs.core.tree_map_remove.call(null, this__6629.comp, this__6629.tree, k, found__6630);
  if(t__6631 == null) {
    if(cljs.core.nth.call(null, found__6630, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__6629.comp, null, 0, this__6629.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__6629.comp, t__6631.blacken(), this__6629.cnt - 1, this__6629.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__6645 = cljs.core.seq.call(null, keyvals);
    var out__6646 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(cljs.core.truth_(in$__6645)) {
        var G__6647 = cljs.core.nnext.call(null, in$__6645);
        var G__6648 = cljs.core.assoc_BANG_.call(null, out__6646, cljs.core.first.call(null, in$__6645), cljs.core.second.call(null, in$__6645));
        in$__6645 = G__6647;
        out__6646 = G__6648;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__6646)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__6649) {
    var keyvals = cljs.core.seq(arglist__6649);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__6650) {
    var keyvals = cljs.core.seq(arglist__6650);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in$__6651 = cljs.core.seq.call(null, keyvals);
    var out__6652 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__6651)) {
        var G__6653 = cljs.core.nnext.call(null, in$__6651);
        var G__6654 = cljs.core.assoc.call(null, out__6652, cljs.core.first.call(null, in$__6651), cljs.core.second.call(null, in$__6651));
        in$__6651 = G__6653;
        out__6652 = G__6654;
        continue
      }else {
        return out__6652
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__6655) {
    var keyvals = cljs.core.seq(arglist__6655);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in$__6656 = cljs.core.seq.call(null, keyvals);
    var out__6657 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(cljs.core.truth_(in$__6656)) {
        var G__6658 = cljs.core.nnext.call(null, in$__6656);
        var G__6659 = cljs.core.assoc.call(null, out__6657, cljs.core.first.call(null, in$__6656), cljs.core.second.call(null, in$__6656));
        in$__6656 = G__6658;
        out__6657 = G__6659;
        continue
      }else {
        return out__6657
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__6660) {
    var comparator = cljs.core.first(arglist__6660);
    var keyvals = cljs.core.rest(arglist__6660);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__6661_SHARP_, p2__6662_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____6663 = p1__6661_SHARP_;
          if(cljs.core.truth_(or__3548__auto____6663)) {
            return or__3548__auto____6663
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__6662_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__6664) {
    var maps = cljs.core.seq(arglist__6664);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__6667 = function(m, e) {
        var k__6665 = cljs.core.first.call(null, e);
        var v__6666 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__6665)) {
          return cljs.core.assoc.call(null, m, k__6665, f.call(null, cljs.core.get.call(null, m, k__6665), v__6666))
        }else {
          return cljs.core.assoc.call(null, m, k__6665, v__6666)
        }
      };
      var merge2__6669 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__6667, function() {
          var or__3548__auto____6668 = m1;
          if(cljs.core.truth_(or__3548__auto____6668)) {
            return or__3548__auto____6668
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__6669, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__6670) {
    var f = cljs.core.first(arglist__6670);
    var maps = cljs.core.rest(arglist__6670);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__6671 = cljs.core.ObjMap.fromObject([], {});
  var keys__6672 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__6672)) {
      var key__6673 = cljs.core.first.call(null, keys__6672);
      var entry__6674 = cljs.core.get.call(null, map, key__6673, "\ufdd0'user/not-found");
      var G__6675 = cljs.core.not_EQ_.call(null, entry__6674, "\ufdd0'user/not-found") ? cljs.core.assoc.call(null, ret__6671, key__6673, entry__6674) : ret__6671;
      var G__6676 = cljs.core.next.call(null, keys__6672);
      ret__6671 = G__6675;
      keys__6672 = G__6676;
      continue
    }else {
      return ret__6671
    }
    break
  }
};
void 0;
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2155022479
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__6682 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__6682.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6683 = this;
  var h__364__auto____6684 = this__6683.__hash;
  if(h__364__auto____6684 != null) {
    return h__364__auto____6684
  }else {
    var h__364__auto____6685 = cljs.core.hash_iset.call(null, coll);
    this__6683.__hash = h__364__auto____6685;
    return h__364__auto____6685
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6686 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6687 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6687.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__6706 = null;
  var G__6706__2 = function(tsym6680, k) {
    var this__6688 = this;
    var tsym6680__6689 = this;
    var coll__6690 = tsym6680__6689;
    return cljs.core._lookup.call(null, coll__6690, k)
  };
  var G__6706__3 = function(tsym6681, k, not_found) {
    var this__6691 = this;
    var tsym6681__6692 = this;
    var coll__6693 = tsym6681__6692;
    return cljs.core._lookup.call(null, coll__6693, k, not_found)
  };
  G__6706 = function(tsym6681, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6706__2.call(this, tsym6681, k);
      case 3:
        return G__6706__3.call(this, tsym6681, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6706
}();
cljs.core.PersistentHashSet.prototype.apply = function(tsym6678, args6679) {
  return tsym6678.call.apply(tsym6678, [tsym6678].concat(cljs.core.aclone.call(null, args6679)))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6694 = this;
  return new cljs.core.PersistentHashSet(this__6694.meta, cljs.core.assoc.call(null, this__6694.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__6695 = this;
  var this$__6696 = this;
  return cljs.core.pr_str.call(null, this$__6696)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6697 = this;
  return cljs.core.keys.call(null, this__6697.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6698 = this;
  return new cljs.core.PersistentHashSet(this__6698.meta, cljs.core.dissoc.call(null, this__6698.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6699 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6700 = this;
  var and__3546__auto____6701 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6701) {
    var and__3546__auto____6702 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6702) {
      return cljs.core.every_QMARK_.call(null, function(p1__6677_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6677_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6702
    }
  }else {
    return and__3546__auto____6701
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6703 = this;
  return new cljs.core.PersistentHashSet(meta, this__6703.hash_map, this__6703.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6704 = this;
  return this__6704.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6705 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__6705.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 131;
  this.cljs$lang$protocol_mask$partition1$ = 17
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.TransientHashSet")
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$ = true;
cljs.core.TransientHashSet.prototype.call = function() {
  var G__6724 = null;
  var G__6724__2 = function(tsym6710, k) {
    var this__6712 = this;
    var tsym6710__6713 = this;
    var tcoll__6714 = tsym6710__6713;
    if(cljs.core._lookup.call(null, this__6712.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__6724__3 = function(tsym6711, k, not_found) {
    var this__6715 = this;
    var tsym6711__6716 = this;
    var tcoll__6717 = tsym6711__6716;
    if(cljs.core._lookup.call(null, this__6715.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__6724 = function(tsym6711, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6724__2.call(this, tsym6711, k);
      case 3:
        return G__6724__3.call(this, tsym6711, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6724
}();
cljs.core.TransientHashSet.prototype.apply = function(tsym6708, args6709) {
  return tsym6708.call.apply(tsym6708, [tsym6708].concat(cljs.core.aclone.call(null, args6709)))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__6718 = this;
  return cljs.core._lookup.call(null, tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__6719 = this;
  if(cljs.core._lookup.call(null, this__6719.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__6720 = this;
  return cljs.core.count.call(null, this__6720.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__6721 = this;
  this__6721.transient_map = cljs.core.dissoc_BANG_.call(null, this__6721.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$ = true;
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__6722 = this;
  this__6722.transient_map = cljs.core.assoc_BANG_.call(null, this__6722.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__6723 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__6723.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 208865423
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6729 = this;
  var h__364__auto____6730 = this__6729.__hash;
  if(h__364__auto____6730 != null) {
    return h__364__auto____6730
  }else {
    var h__364__auto____6731 = cljs.core.hash_iset.call(null, coll);
    this__6729.__hash = h__364__auto____6731;
    return h__364__auto____6731
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__6732 = this;
  return cljs.core._lookup.call(null, coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__6733 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__6733.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__6757 = null;
  var G__6757__2 = function(tsym6727, k) {
    var this__6734 = this;
    var tsym6727__6735 = this;
    var coll__6736 = tsym6727__6735;
    return cljs.core._lookup.call(null, coll__6736, k)
  };
  var G__6757__3 = function(tsym6728, k, not_found) {
    var this__6737 = this;
    var tsym6728__6738 = this;
    var coll__6739 = tsym6728__6738;
    return cljs.core._lookup.call(null, coll__6739, k, not_found)
  };
  G__6757 = function(tsym6728, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6757__2.call(this, tsym6728, k);
      case 3:
        return G__6757__3.call(this, tsym6728, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6757
}();
cljs.core.PersistentTreeSet.prototype.apply = function(tsym6725, args6726) {
  return tsym6725.call.apply(tsym6725, [tsym6725].concat(cljs.core.aclone.call(null, args6726)))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6740 = this;
  return new cljs.core.PersistentTreeSet(this__6740.meta, cljs.core.assoc.call(null, this__6740.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6741 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__6741.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__6742 = this;
  var this$__6743 = this;
  return cljs.core.pr_str.call(null, this$__6743)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__6744 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__6744.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__6745 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__6745.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__6746 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__6747 = this;
  return cljs.core._comparator.call(null, this__6747.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6748 = this;
  return cljs.core.keys.call(null, this__6748.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__6749 = this;
  return new cljs.core.PersistentTreeSet(this__6749.meta, cljs.core.dissoc.call(null, this__6749.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6750 = this;
  return cljs.core.count.call(null, this__6750.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6751 = this;
  var and__3546__auto____6752 = cljs.core.set_QMARK_.call(null, other);
  if(and__3546__auto____6752) {
    var and__3546__auto____6753 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3546__auto____6753) {
      return cljs.core.every_QMARK_.call(null, function(p1__6707_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__6707_SHARP_)
      }, other)
    }else {
      return and__3546__auto____6753
    }
  }else {
    return and__3546__auto____6752
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__6754 = this;
  return new cljs.core.PersistentTreeSet(meta, this__6754.tree_map, this__6754.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6755 = this;
  return this__6755.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__6756 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__6756.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.set = function set(coll) {
  var in$__6758 = cljs.core.seq.call(null, coll);
  var out__6759 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, in$__6758))) {
      var G__6760 = cljs.core.next.call(null, in$__6758);
      var G__6761 = cljs.core.conj_BANG_.call(null, out__6759, cljs.core.first.call(null, in$__6758));
      in$__6758 = G__6760;
      out__6759 = G__6761;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__6759)
    }
    break
  }
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__6762) {
    var keys = cljs.core.seq(arglist__6762);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__6764) {
    var comparator = cljs.core.first(arglist__6764);
    var keys = cljs.core.rest(arglist__6764);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__6765 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____6766 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____6766)) {
        var e__6767 = temp__3695__auto____6766;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__6767))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__6765, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__6763_SHARP_) {
      var temp__3695__auto____6768 = cljs.core.find.call(null, smap, p1__6763_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____6768)) {
        var e__6769 = temp__3695__auto____6768;
        return cljs.core.second.call(null, e__6769)
      }else {
        return p1__6763_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__6777 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__6770, seen) {
        while(true) {
          var vec__6771__6772 = p__6770;
          var f__6773 = cljs.core.nth.call(null, vec__6771__6772, 0, null);
          var xs__6774 = vec__6771__6772;
          var temp__3698__auto____6775 = cljs.core.seq.call(null, xs__6774);
          if(cljs.core.truth_(temp__3698__auto____6775)) {
            var s__6776 = temp__3698__auto____6775;
            if(cljs.core.contains_QMARK_.call(null, seen, f__6773)) {
              var G__6778 = cljs.core.rest.call(null, s__6776);
              var G__6779 = seen;
              p__6770 = G__6778;
              seen = G__6779;
              continue
            }else {
              return cljs.core.cons.call(null, f__6773, step.call(null, cljs.core.rest.call(null, s__6776), cljs.core.conj.call(null, seen, f__6773)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__6777.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__6780 = cljs.core.PersistentVector.fromArray([]);
  var s__6781 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__6781))) {
      var G__6782 = cljs.core.conj.call(null, ret__6780, cljs.core.first.call(null, s__6781));
      var G__6783 = cljs.core.next.call(null, s__6781);
      ret__6780 = G__6782;
      s__6781 = G__6783;
      continue
    }else {
      return cljs.core.seq.call(null, ret__6780)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3548__auto____6784 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3548__auto____6784) {
        return or__3548__auto____6784
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__6785 = x.lastIndexOf("/");
      if(i__6785 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__6785 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3548__auto____6786 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3548__auto____6786) {
      return or__3548__auto____6786
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__6787 = x.lastIndexOf("/");
    if(i__6787 > -1) {
      return cljs.core.subs.call(null, x, 2, i__6787)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__6790 = cljs.core.ObjMap.fromObject([], {});
  var ks__6791 = cljs.core.seq.call(null, keys);
  var vs__6792 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____6793 = ks__6791;
      if(cljs.core.truth_(and__3546__auto____6793)) {
        return vs__6792
      }else {
        return and__3546__auto____6793
      }
    }())) {
      var G__6794 = cljs.core.assoc.call(null, map__6790, cljs.core.first.call(null, ks__6791), cljs.core.first.call(null, vs__6792));
      var G__6795 = cljs.core.next.call(null, ks__6791);
      var G__6796 = cljs.core.next.call(null, vs__6792);
      map__6790 = G__6794;
      ks__6791 = G__6795;
      vs__6792 = G__6796;
      continue
    }else {
      return map__6790
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__6799__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6788_SHARP_, p2__6789_SHARP_) {
        return max_key.call(null, k, p1__6788_SHARP_, p2__6789_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__6799 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6799__delegate.call(this, k, x, y, more)
    };
    G__6799.cljs$lang$maxFixedArity = 3;
    G__6799.cljs$lang$applyTo = function(arglist__6800) {
      var k = cljs.core.first(arglist__6800);
      var x = cljs.core.first(cljs.core.next(arglist__6800));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6800)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6800)));
      return G__6799__delegate(k, x, y, more)
    };
    G__6799.cljs$lang$arity$variadic = G__6799__delegate;
    return G__6799
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__6801__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__6797_SHARP_, p2__6798_SHARP_) {
        return min_key.call(null, k, p1__6797_SHARP_, p2__6798_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__6801 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6801__delegate.call(this, k, x, y, more)
    };
    G__6801.cljs$lang$maxFixedArity = 3;
    G__6801.cljs$lang$applyTo = function(arglist__6802) {
      var k = cljs.core.first(arglist__6802);
      var x = cljs.core.first(cljs.core.next(arglist__6802));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6802)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6802)));
      return G__6801__delegate(k, x, y, more)
    };
    G__6801.cljs$lang$arity$variadic = G__6801__delegate;
    return G__6801
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6803 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6803)) {
        var s__6804 = temp__3698__auto____6803;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__6804), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__6804)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6805 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6805)) {
      var s__6806 = temp__3698__auto____6805;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__6806)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__6806), take_while.call(null, pred, cljs.core.rest.call(null, s__6806)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__6807 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__6807.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__6808 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3698__auto____6809 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3698__auto____6809)) {
        var vec__6810__6811 = temp__3698__auto____6809;
        var e__6812 = cljs.core.nth.call(null, vec__6810__6811, 0, null);
        var s__6813 = vec__6810__6811;
        if(cljs.core.truth_(include__6808.call(null, e__6812))) {
          return s__6813
        }else {
          return cljs.core.next.call(null, s__6813)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6808, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6814 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3698__auto____6814)) {
      var vec__6815__6816 = temp__3698__auto____6814;
      var e__6817 = cljs.core.nth.call(null, vec__6815__6816, 0, null);
      var s__6818 = vec__6815__6816;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__6817)) ? s__6818 : cljs.core.next.call(null, s__6818))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__6819 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.set([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3698__auto____6820 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3698__auto____6820)) {
        var vec__6821__6822 = temp__3698__auto____6820;
        var e__6823 = cljs.core.nth.call(null, vec__6821__6822, 0, null);
        var s__6824 = vec__6821__6822;
        if(cljs.core.truth_(include__6819.call(null, e__6823))) {
          return s__6824
        }else {
          return cljs.core.next.call(null, s__6824)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__6819, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3698__auto____6825 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3698__auto____6825)) {
      var vec__6826__6827 = temp__3698__auto____6825;
      var e__6828 = cljs.core.nth.call(null, vec__6826__6827, 0, null);
      var s__6829 = vec__6826__6827;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__6828)) ? s__6829 : cljs.core.next.call(null, s__6829))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 16187486
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__6830 = this;
  var h__364__auto____6831 = this__6830.__hash;
  if(h__364__auto____6831 != null) {
    return h__364__auto____6831
  }else {
    var h__364__auto____6832 = cljs.core.hash_coll.call(null, rng);
    this__6830.__hash = h__364__auto____6832;
    return h__364__auto____6832
  }
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__6833 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__6834 = this;
  var this$__6835 = this;
  return cljs.core.pr_str.call(null, this$__6835)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__6836 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__6837 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__6838 = this;
  var comp__6839 = this__6838.step > 0 ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__6839.call(null, this__6838.start, this__6838.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__6840 = this;
  if(cljs.core.not.call(null, cljs.core._seq.call(null, rng))) {
    return 0
  }else {
    return Math["ceil"]((this__6840.end - this__6840.start) / this__6840.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__6841 = this;
  return this__6841.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__6842 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__6842.meta, this__6842.start + this__6842.step, this__6842.end, this__6842.step, null)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__6843 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__6844 = this;
  return new cljs.core.Range(meta, this__6844.start, this__6844.end, this__6844.step, this__6844.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__6845 = this;
  return this__6845.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__6846 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__6846.start + n * this__6846.step
  }else {
    if(function() {
      var and__3546__auto____6847 = this__6846.start > this__6846.end;
      if(and__3546__auto____6847) {
        return this__6846.step === 0
      }else {
        return and__3546__auto____6847
      }
    }()) {
      return this__6846.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__6848 = this;
  if(n < cljs.core._count.call(null, rng)) {
    return this__6848.start + n * this__6848.step
  }else {
    if(function() {
      var and__3546__auto____6849 = this__6848.start > this__6848.end;
      if(and__3546__auto____6849) {
        return this__6848.step === 0
      }else {
        return and__3546__auto____6849
      }
    }()) {
      return this__6848.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__6850 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__6850.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6851 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6851)) {
      var s__6852 = temp__3698__auto____6851;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__6852), take_nth.call(null, n, cljs.core.drop.call(null, n, s__6852)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____6854 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____6854)) {
      var s__6855 = temp__3698__auto____6854;
      var fst__6856 = cljs.core.first.call(null, s__6855);
      var fv__6857 = f.call(null, fst__6856);
      var run__6858 = cljs.core.cons.call(null, fst__6856, cljs.core.take_while.call(null, function(p1__6853_SHARP_) {
        return cljs.core._EQ_.call(null, fv__6857, f.call(null, p1__6853_SHARP_))
      }, cljs.core.next.call(null, s__6855)));
      return cljs.core.cons.call(null, run__6858, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__6858), s__6855))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.fromObject([], {})), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____6869 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____6869)) {
        var s__6870 = temp__3695__auto____6869;
        return reductions.call(null, f, cljs.core.first.call(null, s__6870), cljs.core.rest.call(null, s__6870))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____6871 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____6871)) {
        var s__6872 = temp__3698__auto____6871;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__6872)), cljs.core.rest.call(null, s__6872))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__6874 = null;
      var G__6874__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__6874__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__6874__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__6874__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__6874__4 = function() {
        var G__6875__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__6875 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6875__delegate.call(this, x, y, z, args)
        };
        G__6875.cljs$lang$maxFixedArity = 3;
        G__6875.cljs$lang$applyTo = function(arglist__6876) {
          var x = cljs.core.first(arglist__6876);
          var y = cljs.core.first(cljs.core.next(arglist__6876));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6876)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6876)));
          return G__6875__delegate(x, y, z, args)
        };
        G__6875.cljs$lang$arity$variadic = G__6875__delegate;
        return G__6875
      }();
      G__6874 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6874__0.call(this);
          case 1:
            return G__6874__1.call(this, x);
          case 2:
            return G__6874__2.call(this, x, y);
          case 3:
            return G__6874__3.call(this, x, y, z);
          default:
            return G__6874__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6874.cljs$lang$maxFixedArity = 3;
      G__6874.cljs$lang$applyTo = G__6874__4.cljs$lang$applyTo;
      return G__6874
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__6877 = null;
      var G__6877__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__6877__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__6877__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__6877__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__6877__4 = function() {
        var G__6878__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__6878 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6878__delegate.call(this, x, y, z, args)
        };
        G__6878.cljs$lang$maxFixedArity = 3;
        G__6878.cljs$lang$applyTo = function(arglist__6879) {
          var x = cljs.core.first(arglist__6879);
          var y = cljs.core.first(cljs.core.next(arglist__6879));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6879)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6879)));
          return G__6878__delegate(x, y, z, args)
        };
        G__6878.cljs$lang$arity$variadic = G__6878__delegate;
        return G__6878
      }();
      G__6877 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6877__0.call(this);
          case 1:
            return G__6877__1.call(this, x);
          case 2:
            return G__6877__2.call(this, x, y);
          case 3:
            return G__6877__3.call(this, x, y, z);
          default:
            return G__6877__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6877.cljs$lang$maxFixedArity = 3;
      G__6877.cljs$lang$applyTo = G__6877__4.cljs$lang$applyTo;
      return G__6877
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__6880 = null;
      var G__6880__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__6880__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__6880__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__6880__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__6880__4 = function() {
        var G__6881__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__6881 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__6881__delegate.call(this, x, y, z, args)
        };
        G__6881.cljs$lang$maxFixedArity = 3;
        G__6881.cljs$lang$applyTo = function(arglist__6882) {
          var x = cljs.core.first(arglist__6882);
          var y = cljs.core.first(cljs.core.next(arglist__6882));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6882)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6882)));
          return G__6881__delegate(x, y, z, args)
        };
        G__6881.cljs$lang$arity$variadic = G__6881__delegate;
        return G__6881
      }();
      G__6880 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__6880__0.call(this);
          case 1:
            return G__6880__1.call(this, x);
          case 2:
            return G__6880__2.call(this, x, y);
          case 3:
            return G__6880__3.call(this, x, y, z);
          default:
            return G__6880__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__6880.cljs$lang$maxFixedArity = 3;
      G__6880.cljs$lang$applyTo = G__6880__4.cljs$lang$applyTo;
      return G__6880
    }()
  };
  var juxt__4 = function() {
    var G__6883__delegate = function(f, g, h, fs) {
      var fs__6873 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__6884 = null;
        var G__6884__0 = function() {
          return cljs.core.reduce.call(null, function(p1__6859_SHARP_, p2__6860_SHARP_) {
            return cljs.core.conj.call(null, p1__6859_SHARP_, p2__6860_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__6873)
        };
        var G__6884__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__6861_SHARP_, p2__6862_SHARP_) {
            return cljs.core.conj.call(null, p1__6861_SHARP_, p2__6862_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__6873)
        };
        var G__6884__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__6863_SHARP_, p2__6864_SHARP_) {
            return cljs.core.conj.call(null, p1__6863_SHARP_, p2__6864_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__6873)
        };
        var G__6884__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__6865_SHARP_, p2__6866_SHARP_) {
            return cljs.core.conj.call(null, p1__6865_SHARP_, p2__6866_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__6873)
        };
        var G__6884__4 = function() {
          var G__6885__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__6867_SHARP_, p2__6868_SHARP_) {
              return cljs.core.conj.call(null, p1__6867_SHARP_, cljs.core.apply.call(null, p2__6868_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__6873)
          };
          var G__6885 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__6885__delegate.call(this, x, y, z, args)
          };
          G__6885.cljs$lang$maxFixedArity = 3;
          G__6885.cljs$lang$applyTo = function(arglist__6886) {
            var x = cljs.core.first(arglist__6886);
            var y = cljs.core.first(cljs.core.next(arglist__6886));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6886)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6886)));
            return G__6885__delegate(x, y, z, args)
          };
          G__6885.cljs$lang$arity$variadic = G__6885__delegate;
          return G__6885
        }();
        G__6884 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__6884__0.call(this);
            case 1:
              return G__6884__1.call(this, x);
            case 2:
              return G__6884__2.call(this, x, y);
            case 3:
              return G__6884__3.call(this, x, y, z);
            default:
              return G__6884__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__6884.cljs$lang$maxFixedArity = 3;
        G__6884.cljs$lang$applyTo = G__6884__4.cljs$lang$applyTo;
        return G__6884
      }()
    };
    var G__6883 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__6883__delegate.call(this, f, g, h, fs)
    };
    G__6883.cljs$lang$maxFixedArity = 3;
    G__6883.cljs$lang$applyTo = function(arglist__6887) {
      var f = cljs.core.first(arglist__6887);
      var g = cljs.core.first(cljs.core.next(arglist__6887));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6887)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6887)));
      return G__6883__delegate(f, g, h, fs)
    };
    G__6883.cljs$lang$arity$variadic = G__6883__delegate;
    return G__6883
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__6889 = cljs.core.next.call(null, coll);
        coll = G__6889;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____6888 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____6888)) {
          return n > 0
        }else {
          return and__3546__auto____6888
        }
      }())) {
        var G__6890 = n - 1;
        var G__6891 = cljs.core.next.call(null, coll);
        n = G__6890;
        coll = G__6891;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__6892 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__6892), s)) {
    if(cljs.core.count.call(null, matches__6892) === 1) {
      return cljs.core.first.call(null, matches__6892)
    }else {
      return cljs.core.vec.call(null, matches__6892)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__6893 = re.exec(s);
  if(matches__6893 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__6893) === 1) {
      return cljs.core.first.call(null, matches__6893)
    }else {
      return cljs.core.vec.call(null, matches__6893)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__6894 = cljs.core.re_find.call(null, re, s);
  var match_idx__6895 = s.search(re);
  var match_str__6896 = cljs.core.coll_QMARK_.call(null, match_data__6894) ? cljs.core.first.call(null, match_data__6894) : match_data__6894;
  var post_match__6897 = cljs.core.subs.call(null, s, match_idx__6895 + cljs.core.count.call(null, match_str__6896));
  if(cljs.core.truth_(match_data__6894)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__6894, re_seq.call(null, re, post_match__6897))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__6899__6900 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___6901 = cljs.core.nth.call(null, vec__6899__6900, 0, null);
  var flags__6902 = cljs.core.nth.call(null, vec__6899__6900, 1, null);
  var pattern__6903 = cljs.core.nth.call(null, vec__6899__6900, 2, null);
  return new RegExp(pattern__6903, flags__6902)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__6898_SHARP_) {
    return print_one.call(null, p1__6898_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____6904 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____6904)) {
            var and__3546__auto____6908 = function() {
              var G__6905__6906 = obj;
              if(G__6905__6906 != null) {
                if(function() {
                  var or__3548__auto____6907 = G__6905__6906.cljs$lang$protocol_mask$partition0$ & 65536;
                  if(or__3548__auto____6907) {
                    return or__3548__auto____6907
                  }else {
                    return G__6905__6906.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__6905__6906.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__6905__6906)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__6905__6906)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____6908)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____6908
            }
          }else {
            return and__3546__auto____6904
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var and__3546__auto____6909 = obj != null;
          if(and__3546__auto____6909) {
            return obj.cljs$lang$type
          }else {
            return and__3546__auto____6909
          }
        }()) ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__6910__6911 = obj;
          if(G__6910__6911 != null) {
            if(function() {
              var or__3548__auto____6912 = G__6910__6911.cljs$lang$protocol_mask$partition0$ & 268435456;
              if(or__3548__auto____6912) {
                return or__3548__auto____6912
              }else {
                return G__6910__6911.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__6910__6911.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__6910__6911)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__6910__6911)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__6913 = cljs.core.first.call(null, objs);
  var sb__6914 = new goog.string.StringBuffer;
  var G__6915__6916 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__6915__6916)) {
    var obj__6917 = cljs.core.first.call(null, G__6915__6916);
    var G__6915__6918 = G__6915__6916;
    while(true) {
      if(obj__6917 === first_obj__6913) {
      }else {
        sb__6914.append(" ")
      }
      var G__6919__6920 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__6917, opts));
      if(cljs.core.truth_(G__6919__6920)) {
        var string__6921 = cljs.core.first.call(null, G__6919__6920);
        var G__6919__6922 = G__6919__6920;
        while(true) {
          sb__6914.append(string__6921);
          var temp__3698__auto____6923 = cljs.core.next.call(null, G__6919__6922);
          if(cljs.core.truth_(temp__3698__auto____6923)) {
            var G__6919__6924 = temp__3698__auto____6923;
            var G__6927 = cljs.core.first.call(null, G__6919__6924);
            var G__6928 = G__6919__6924;
            string__6921 = G__6927;
            G__6919__6922 = G__6928;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____6925 = cljs.core.next.call(null, G__6915__6918);
      if(cljs.core.truth_(temp__3698__auto____6925)) {
        var G__6915__6926 = temp__3698__auto____6925;
        var G__6929 = cljs.core.first.call(null, G__6915__6926);
        var G__6930 = G__6915__6926;
        obj__6917 = G__6929;
        G__6915__6918 = G__6930;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__6914
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__6931 = cljs.core.pr_sb.call(null, objs, opts);
  sb__6931.append("\n");
  return[cljs.core.str(sb__6931)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__6932 = cljs.core.first.call(null, objs);
  var G__6933__6934 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__6933__6934)) {
    var obj__6935 = cljs.core.first.call(null, G__6933__6934);
    var G__6933__6936 = G__6933__6934;
    while(true) {
      if(obj__6935 === first_obj__6932) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__6937__6938 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__6935, opts));
      if(cljs.core.truth_(G__6937__6938)) {
        var string__6939 = cljs.core.first.call(null, G__6937__6938);
        var G__6937__6940 = G__6937__6938;
        while(true) {
          cljs.core.string_print.call(null, string__6939);
          var temp__3698__auto____6941 = cljs.core.next.call(null, G__6937__6940);
          if(cljs.core.truth_(temp__3698__auto____6941)) {
            var G__6937__6942 = temp__3698__auto____6941;
            var G__6945 = cljs.core.first.call(null, G__6937__6942);
            var G__6946 = G__6937__6942;
            string__6939 = G__6945;
            G__6937__6940 = G__6946;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____6943 = cljs.core.next.call(null, G__6933__6936);
      if(cljs.core.truth_(temp__3698__auto____6943)) {
        var G__6933__6944 = temp__3698__auto____6943;
        var G__6947 = cljs.core.first.call(null, G__6933__6944);
        var G__6948 = G__6933__6944;
        obj__6935 = G__6947;
        G__6933__6936 = G__6948;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__6949) {
    var objs = cljs.core.seq(arglist__6949);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__6950) {
    var objs = cljs.core.seq(arglist__6950);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__6951) {
    var objs = cljs.core.seq(arglist__6951);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__6952) {
    var objs = cljs.core.seq(arglist__6952);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__6953) {
    var objs = cljs.core.seq(arglist__6953);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__6954) {
    var objs = cljs.core.seq(arglist__6954);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__6955) {
    var objs = cljs.core.seq(arglist__6955);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__6956) {
    var objs = cljs.core.seq(arglist__6956);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6957 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6957, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6958 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6958, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6959 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6959, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3698__auto____6960 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____6960)) {
        var nspc__6961 = temp__3698__auto____6960;
        return[cljs.core.str(nspc__6961), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3698__auto____6962 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____6962)) {
          var nspc__6963 = temp__3698__auto____6962;
          return[cljs.core.str(nspc__6963), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6964 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6964, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__6965 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__6965, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1345404928
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__6966 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__6967 = this;
  var G__6968__6969 = cljs.core.seq.call(null, this__6967.watches);
  if(cljs.core.truth_(G__6968__6969)) {
    var G__6971__6973 = cljs.core.first.call(null, G__6968__6969);
    var vec__6972__6974 = G__6971__6973;
    var key__6975 = cljs.core.nth.call(null, vec__6972__6974, 0, null);
    var f__6976 = cljs.core.nth.call(null, vec__6972__6974, 1, null);
    var G__6968__6977 = G__6968__6969;
    var G__6971__6978 = G__6971__6973;
    var G__6968__6979 = G__6968__6977;
    while(true) {
      var vec__6980__6981 = G__6971__6978;
      var key__6982 = cljs.core.nth.call(null, vec__6980__6981, 0, null);
      var f__6983 = cljs.core.nth.call(null, vec__6980__6981, 1, null);
      var G__6968__6984 = G__6968__6979;
      f__6983.call(null, key__6982, this$, oldval, newval);
      var temp__3698__auto____6985 = cljs.core.next.call(null, G__6968__6984);
      if(cljs.core.truth_(temp__3698__auto____6985)) {
        var G__6968__6986 = temp__3698__auto____6985;
        var G__6993 = cljs.core.first.call(null, G__6968__6986);
        var G__6994 = G__6968__6986;
        G__6971__6978 = G__6993;
        G__6968__6979 = G__6994;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__6987 = this;
  return this$.watches = cljs.core.assoc.call(null, this__6987.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__6988 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__6988.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__6989 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__6989.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__6990 = this;
  return this__6990.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__6991 = this;
  return this__6991.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__6992 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__7001__delegate = function(x, p__6995) {
      var map__6996__6997 = p__6995;
      var map__6996__6998 = cljs.core.seq_QMARK_.call(null, map__6996__6997) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6996__6997) : map__6996__6997;
      var validator__6999 = cljs.core.get.call(null, map__6996__6998, "\ufdd0'validator");
      var meta__7000 = cljs.core.get.call(null, map__6996__6998, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__7000, validator__6999, null)
    };
    var G__7001 = function(x, var_args) {
      var p__6995 = null;
      if(goog.isDef(var_args)) {
        p__6995 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7001__delegate.call(this, x, p__6995)
    };
    G__7001.cljs$lang$maxFixedArity = 1;
    G__7001.cljs$lang$applyTo = function(arglist__7002) {
      var x = cljs.core.first(arglist__7002);
      var p__6995 = cljs.core.rest(arglist__7002);
      return G__7001__delegate(x, p__6995)
    };
    G__7001.cljs$lang$arity$variadic = G__7001__delegate;
    return G__7001
  }();
  atom = function(x, var_args) {
    var p__6995 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____7003 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____7003)) {
    var validate__7004 = temp__3698__auto____7003;
    if(cljs.core.truth_(validate__7004.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 5917))))].join(""));
    }
  }else {
  }
  var old_value__7005 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__7005, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__7006__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__7006 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__7006__delegate.call(this, a, f, x, y, z, more)
    };
    G__7006.cljs$lang$maxFixedArity = 5;
    G__7006.cljs$lang$applyTo = function(arglist__7007) {
      var a = cljs.core.first(arglist__7007);
      var f = cljs.core.first(cljs.core.next(arglist__7007));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7007)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7007))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7007)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7007)))));
      return G__7006__delegate(a, f, x, y, z, more)
    };
    G__7006.cljs$lang$arity$variadic = G__7006__delegate;
    return G__7006
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__7008) {
    var iref = cljs.core.first(arglist__7008);
    var f = cljs.core.first(cljs.core.next(arglist__7008));
    var args = cljs.core.rest(cljs.core.next(arglist__7008));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 536887296
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__7009 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__7009.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__7010 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__7010.state, function(p__7011) {
    var curr_state__7012 = p__7011;
    var curr_state__7013 = cljs.core.seq_QMARK_.call(null, curr_state__7012) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__7012) : curr_state__7012;
    var done__7014 = cljs.core.get.call(null, curr_state__7013, "\ufdd0'done");
    if(cljs.core.truth_(done__7014)) {
      return curr_state__7013
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__7010.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__7015__7016 = options;
    var map__7015__7017 = cljs.core.seq_QMARK_.call(null, map__7015__7016) ? cljs.core.apply.call(null, cljs.core.hash_map, map__7015__7016) : map__7015__7016;
    var keywordize_keys__7018 = cljs.core.get.call(null, map__7015__7017, "\ufdd0'keywordize-keys");
    var keyfn__7019 = cljs.core.truth_(keywordize_keys__7018) ? cljs.core.keyword : cljs.core.str;
    var f__7025 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__625__auto____7024 = function iter__7020(s__7021) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__7021__7022 = s__7021;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__7021__7022))) {
                        var k__7023 = cljs.core.first.call(null, s__7021__7022);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__7019.call(null, k__7023), thisfn.call(null, x[k__7023])]), iter__7020.call(null, cljs.core.rest.call(null, s__7021__7022)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__625__auto____7024.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__7025.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__7026) {
    var x = cljs.core.first(arglist__7026);
    var options = cljs.core.rest(arglist__7026);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__7027 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__7031__delegate = function(args) {
      var temp__3695__auto____7028 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__7027), args);
      if(cljs.core.truth_(temp__3695__auto____7028)) {
        var v__7029 = temp__3695__auto____7028;
        return v__7029
      }else {
        var ret__7030 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__7027, cljs.core.assoc, args, ret__7030);
        return ret__7030
      }
    };
    var G__7031 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7031__delegate.call(this, args)
    };
    G__7031.cljs$lang$maxFixedArity = 0;
    G__7031.cljs$lang$applyTo = function(arglist__7032) {
      var args = cljs.core.seq(arglist__7032);
      return G__7031__delegate(args)
    };
    G__7031.cljs$lang$arity$variadic = G__7031__delegate;
    return G__7031
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__7033 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__7033)) {
        var G__7034 = ret__7033;
        f = G__7034;
        continue
      }else {
        return ret__7033
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__7035__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__7035 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7035__delegate.call(this, f, args)
    };
    G__7035.cljs$lang$maxFixedArity = 1;
    G__7035.cljs$lang$applyTo = function(arglist__7036) {
      var f = cljs.core.first(arglist__7036);
      var args = cljs.core.rest(arglist__7036);
      return G__7035__delegate(f, args)
    };
    G__7035.cljs$lang$arity$variadic = G__7035__delegate;
    return G__7035
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__7037 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__7037, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__7037, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3548__auto____7038 = cljs.core._EQ_.call(null, child, parent);
    if(or__3548__auto____7038) {
      return or__3548__auto____7038
    }else {
      var or__3548__auto____7039 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(or__3548__auto____7039) {
        return or__3548__auto____7039
      }else {
        var and__3546__auto____7040 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3546__auto____7040) {
          var and__3546__auto____7041 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3546__auto____7041) {
            var and__3546__auto____7042 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3546__auto____7042) {
              var ret__7043 = true;
              var i__7044 = 0;
              while(true) {
                if(function() {
                  var or__3548__auto____7045 = cljs.core.not.call(null, ret__7043);
                  if(or__3548__auto____7045) {
                    return or__3548__auto____7045
                  }else {
                    return i__7044 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__7043
                }else {
                  var G__7046 = isa_QMARK_.call(null, h, child.call(null, i__7044), parent.call(null, i__7044));
                  var G__7047 = i__7044 + 1;
                  ret__7043 = G__7046;
                  i__7044 = G__7047;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____7042
            }
          }else {
            return and__3546__auto____7041
          }
        }else {
          return and__3546__auto____7040
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6201))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6205))))].join(""));
    }
    var tp__7051 = "\ufdd0'parents".call(null, h);
    var td__7052 = "\ufdd0'descendants".call(null, h);
    var ta__7053 = "\ufdd0'ancestors".call(null, h);
    var tf__7054 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____7055 = cljs.core.contains_QMARK_.call(null, tp__7051.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__7053.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__7053.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__7051, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__7054.call(null, "\ufdd0'ancestors".call(null, h), tag, td__7052, parent, ta__7053), "\ufdd0'descendants":tf__7054.call(null, "\ufdd0'descendants".call(null, h), parent, ta__7053, tag, td__7052)})
    }();
    if(cljs.core.truth_(or__3548__auto____7055)) {
      return or__3548__auto____7055
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__7056 = "\ufdd0'parents".call(null, h);
    var childsParents__7057 = cljs.core.truth_(parentMap__7056.call(null, tag)) ? cljs.core.disj.call(null, parentMap__7056.call(null, tag), parent) : cljs.core.set([]);
    var newParents__7058 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__7057)) ? cljs.core.assoc.call(null, parentMap__7056, tag, childsParents__7057) : cljs.core.dissoc.call(null, parentMap__7056, tag);
    var deriv_seq__7059 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__7048_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__7048_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__7048_SHARP_), cljs.core.second.call(null, p1__7048_SHARP_)))
    }, cljs.core.seq.call(null, newParents__7058)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__7056.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__7049_SHARP_, p2__7050_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__7049_SHARP_, p2__7050_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__7059))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__7060 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____7062 = cljs.core.truth_(function() {
    var and__3546__auto____7061 = xprefs__7060;
    if(cljs.core.truth_(and__3546__auto____7061)) {
      return xprefs__7060.call(null, y)
    }else {
      return and__3546__auto____7061
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____7062)) {
    return or__3548__auto____7062
  }else {
    var or__3548__auto____7064 = function() {
      var ps__7063 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__7063) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__7063), prefer_table))) {
          }else {
          }
          var G__7067 = cljs.core.rest.call(null, ps__7063);
          ps__7063 = G__7067;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7064)) {
      return or__3548__auto____7064
    }else {
      var or__3548__auto____7066 = function() {
        var ps__7065 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__7065) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__7065), y, prefer_table))) {
            }else {
            }
            var G__7068 = cljs.core.rest.call(null, ps__7065);
            ps__7065 = G__7068;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____7066)) {
        return or__3548__auto____7066
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____7069 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____7069)) {
    return or__3548__auto____7069
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__7078 = cljs.core.reduce.call(null, function(be, p__7070) {
    var vec__7071__7072 = p__7070;
    var k__7073 = cljs.core.nth.call(null, vec__7071__7072, 0, null);
    var ___7074 = cljs.core.nth.call(null, vec__7071__7072, 1, null);
    var e__7075 = vec__7071__7072;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__7073)) {
      var be2__7077 = cljs.core.truth_(function() {
        var or__3548__auto____7076 = be == null;
        if(or__3548__auto____7076) {
          return or__3548__auto____7076
        }else {
          return cljs.core.dominates.call(null, k__7073, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__7075 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__7077), k__7073, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__7073), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__7077)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__7077
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__7078)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__7078));
      return cljs.core.second.call(null, best_entry__7078)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
void 0;
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3546__auto____7079 = mf;
    if(and__3546__auto____7079) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3546__auto____7079
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7080 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7080) {
        return or__3548__auto____7080
      }else {
        var or__3548__auto____7081 = cljs.core._reset["_"];
        if(or__3548__auto____7081) {
          return or__3548__auto____7081
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3546__auto____7082 = mf;
    if(and__3546__auto____7082) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3546__auto____7082
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____7083 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7083) {
        return or__3548__auto____7083
      }else {
        var or__3548__auto____7084 = cljs.core._add_method["_"];
        if(or__3548__auto____7084) {
          return or__3548__auto____7084
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7085 = mf;
    if(and__3546__auto____7085) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3546__auto____7085
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7086 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7086) {
        return or__3548__auto____7086
      }else {
        var or__3548__auto____7087 = cljs.core._remove_method["_"];
        if(or__3548__auto____7087) {
          return or__3548__auto____7087
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3546__auto____7088 = mf;
    if(and__3546__auto____7088) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3546__auto____7088
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____7089 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7089) {
        return or__3548__auto____7089
      }else {
        var or__3548__auto____7090 = cljs.core._prefer_method["_"];
        if(or__3548__auto____7090) {
          return or__3548__auto____7090
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3546__auto____7091 = mf;
    if(and__3546__auto____7091) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3546__auto____7091
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____7092 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7092) {
        return or__3548__auto____7092
      }else {
        var or__3548__auto____7093 = cljs.core._get_method["_"];
        if(or__3548__auto____7093) {
          return or__3548__auto____7093
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3546__auto____7094 = mf;
    if(and__3546__auto____7094) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3546__auto____7094
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7095 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7095) {
        return or__3548__auto____7095
      }else {
        var or__3548__auto____7096 = cljs.core._methods["_"];
        if(or__3548__auto____7096) {
          return or__3548__auto____7096
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3546__auto____7097 = mf;
    if(and__3546__auto____7097) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3546__auto____7097
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    return function() {
      var or__3548__auto____7098 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7098) {
        return or__3548__auto____7098
      }else {
        var or__3548__auto____7099 = cljs.core._prefers["_"];
        if(or__3548__auto____7099) {
          return or__3548__auto____7099
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3546__auto____7100 = mf;
    if(and__3546__auto____7100) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3546__auto____7100
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    return function() {
      var or__3548__auto____7101 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(or__3548__auto____7101) {
        return or__3548__auto____7101
      }else {
        var or__3548__auto____7102 = cljs.core._dispatch["_"];
        if(or__3548__auto____7102) {
          return or__3548__auto____7102
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
void 0;
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__7103 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__7104 = cljs.core._get_method.call(null, mf, dispatch_val__7103);
  if(cljs.core.truth_(target_fn__7104)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__7103)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__7104, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 32
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__7105 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__7106 = this;
  cljs.core.swap_BANG_.call(null, this__7106.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7106.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7106.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__7106.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__7107 = this;
  cljs.core.swap_BANG_.call(null, this__7107.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__7107.method_cache, this__7107.method_table, this__7107.cached_hierarchy, this__7107.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__7108 = this;
  cljs.core.swap_BANG_.call(null, this__7108.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__7108.method_cache, this__7108.method_table, this__7108.cached_hierarchy, this__7108.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__7109 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__7109.cached_hierarchy), cljs.core.deref.call(null, this__7109.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__7109.method_cache, this__7109.method_table, this__7109.cached_hierarchy, this__7109.hierarchy)
  }
  var temp__3695__auto____7110 = cljs.core.deref.call(null, this__7109.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____7110)) {
    var target_fn__7111 = temp__3695__auto____7110;
    return target_fn__7111
  }else {
    var temp__3695__auto____7112 = cljs.core.find_and_cache_best_method.call(null, this__7109.name, dispatch_val, this__7109.hierarchy, this__7109.method_table, this__7109.prefer_table, this__7109.method_cache, this__7109.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____7112)) {
      var target_fn__7113 = temp__3695__auto____7112;
      return target_fn__7113
    }else {
      return cljs.core.deref.call(null, this__7109.method_table).call(null, this__7109.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__7114 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__7114.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__7114.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__7114.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__7114.method_cache, this__7114.method_table, this__7114.cached_hierarchy, this__7114.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__7115 = this;
  return cljs.core.deref.call(null, this__7115.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__7116 = this;
  return cljs.core.deref.call(null, this__7116.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__7117 = this;
  return cljs.core.do_dispatch.call(null, mf, this__7117.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__7118__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__7118 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__7118__delegate.call(this, _, args)
  };
  G__7118.cljs$lang$maxFixedArity = 1;
  G__7118.cljs$lang$applyTo = function(arglist__7119) {
    var _ = cljs.core.first(arglist__7119);
    var args = cljs.core.rest(arglist__7119);
    return G__7118__delegate(_, args)
  };
  G__7118.cljs$lang$arity$variadic = G__7118__delegate;
  return G__7118
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljs.reader");
goog.require("cljs.core");
goog.require("goog.string");
void 0;
cljs.reader.PushbackReader = {};
cljs.reader.read_char = function read_char(reader) {
  if(function() {
    var and__3546__auto____7121 = reader;
    if(and__3546__auto____7121) {
      return reader.cljs$reader$PushbackReader$read_char$arity$1
    }else {
      return and__3546__auto____7121
    }
  }()) {
    return reader.cljs$reader$PushbackReader$read_char$arity$1(reader)
  }else {
    return function() {
      var or__3548__auto____7122 = cljs.reader.read_char[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7122) {
        return or__3548__auto____7122
      }else {
        var or__3548__auto____7123 = cljs.reader.read_char["_"];
        if(or__3548__auto____7123) {
          return or__3548__auto____7123
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.read-char", reader);
        }
      }
    }().call(null, reader)
  }
};
cljs.reader.unread = function unread(reader, ch) {
  if(function() {
    var and__3546__auto____7124 = reader;
    if(and__3546__auto____7124) {
      return reader.cljs$reader$PushbackReader$unread$arity$2
    }else {
      return and__3546__auto____7124
    }
  }()) {
    return reader.cljs$reader$PushbackReader$unread$arity$2(reader, ch)
  }else {
    return function() {
      var or__3548__auto____7125 = cljs.reader.unread[goog.typeOf.call(null, reader)];
      if(or__3548__auto____7125) {
        return or__3548__auto____7125
      }else {
        var or__3548__auto____7126 = cljs.reader.unread["_"];
        if(or__3548__auto____7126) {
          return or__3548__auto____7126
        }else {
          throw cljs.core.missing_protocol.call(null, "PushbackReader.unread", reader);
        }
      }
    }().call(null, reader, ch)
  }
};
void 0;
cljs.reader.StringPushbackReader = function(s, index_atom, buffer_atom) {
  this.s = s;
  this.index_atom = index_atom;
  this.buffer_atom = buffer_atom
};
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = function(this__454__auto__) {
  return cljs.core.list.call(null, "cljs.reader.StringPushbackReader")
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = function(reader) {
  var this__7127 = this;
  if(cljs.core.empty_QMARK_.call(null, cljs.core.deref.call(null, this__7127.buffer_atom))) {
    var idx__7128 = cljs.core.deref.call(null, this__7127.index_atom);
    cljs.core.swap_BANG_.call(null, this__7127.index_atom, cljs.core.inc);
    return this__7127.s[idx__7128]
  }else {
    var buf__7129 = cljs.core.deref.call(null, this__7127.buffer_atom);
    cljs.core.swap_BANG_.call(null, this__7127.buffer_atom, cljs.core.rest);
    return cljs.core.first.call(null, buf__7129)
  }
};
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = function(reader, ch) {
  var this__7130 = this;
  return cljs.core.swap_BANG_.call(null, this__7130.buffer_atom, function(p1__7120_SHARP_) {
    return cljs.core.cons.call(null, ch, p1__7120_SHARP_)
  })
};
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = function push_back_reader(s) {
  return new cljs.reader.StringPushbackReader(s, cljs.core.atom.call(null, 0), cljs.core.atom.call(null, null))
};
cljs.reader.whitespace_QMARK_ = function whitespace_QMARK_(ch) {
  var or__3548__auto____7131 = goog.string.isBreakingWhitespace.call(null, ch);
  if(cljs.core.truth_(or__3548__auto____7131)) {
    return or__3548__auto____7131
  }else {
    return"," === ch
  }
};
cljs.reader.numeric_QMARK_ = function numeric_QMARK_(ch) {
  return goog.string.isNumeric.call(null, ch)
};
cljs.reader.comment_prefix_QMARK_ = function comment_prefix_QMARK_(ch) {
  return";" === ch
};
cljs.reader.number_literal_QMARK_ = function number_literal_QMARK_(reader, initch) {
  var or__3548__auto____7132 = cljs.reader.numeric_QMARK_.call(null, initch);
  if(or__3548__auto____7132) {
    return or__3548__auto____7132
  }else {
    var and__3546__auto____7134 = function() {
      var or__3548__auto____7133 = "+" === initch;
      if(or__3548__auto____7133) {
        return or__3548__auto____7133
      }else {
        return"-" === initch
      }
    }();
    if(cljs.core.truth_(and__3546__auto____7134)) {
      return cljs.reader.numeric_QMARK_.call(null, function() {
        var next_ch__7135 = cljs.reader.read_char.call(null, reader);
        cljs.reader.unread.call(null, reader, next_ch__7135);
        return next_ch__7135
      }())
    }else {
      return and__3546__auto____7134
    }
  }
};
void 0;
void 0;
void 0;
cljs.reader.reader_error = function() {
  var reader_error__delegate = function(rdr, msg) {
    throw cljs.core.apply.call(null, cljs.core.str, msg);
  };
  var reader_error = function(rdr, var_args) {
    var msg = null;
    if(goog.isDef(var_args)) {
      msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return reader_error__delegate.call(this, rdr, msg)
  };
  reader_error.cljs$lang$maxFixedArity = 1;
  reader_error.cljs$lang$applyTo = function(arglist__7136) {
    var rdr = cljs.core.first(arglist__7136);
    var msg = cljs.core.rest(arglist__7136);
    return reader_error__delegate(rdr, msg)
  };
  reader_error.cljs$lang$arity$variadic = reader_error__delegate;
  return reader_error
}();
cljs.reader.macro_terminating_QMARK_ = function macro_terminating_QMARK_(ch) {
  var and__3546__auto____7137 = ch != "#";
  if(and__3546__auto____7137) {
    var and__3546__auto____7138 = ch != "'";
    if(and__3546__auto____7138) {
      var and__3546__auto____7139 = ch != ":";
      if(and__3546__auto____7139) {
        return cljs.reader.macros.call(null, ch)
      }else {
        return and__3546__auto____7139
      }
    }else {
      return and__3546__auto____7138
    }
  }else {
    return and__3546__auto____7137
  }
};
cljs.reader.read_token = function read_token(rdr, initch) {
  var sb__7140 = new goog.string.StringBuffer(initch);
  var ch__7141 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(function() {
      var or__3548__auto____7142 = ch__7141 == null;
      if(or__3548__auto____7142) {
        return or__3548__auto____7142
      }else {
        var or__3548__auto____7143 = cljs.reader.whitespace_QMARK_.call(null, ch__7141);
        if(or__3548__auto____7143) {
          return or__3548__auto____7143
        }else {
          return cljs.reader.macro_terminating_QMARK_.call(null, ch__7141)
        }
      }
    }()) {
      cljs.reader.unread.call(null, rdr, ch__7141);
      return sb__7140.toString()
    }else {
      var G__7144 = function() {
        sb__7140.append(ch__7141);
        return sb__7140
      }();
      var G__7145 = cljs.reader.read_char.call(null, rdr);
      sb__7140 = G__7144;
      ch__7141 = G__7145;
      continue
    }
    break
  }
};
cljs.reader.skip_line = function skip_line(reader, _) {
  while(true) {
    var ch__7146 = cljs.reader.read_char.call(null, reader);
    if(function() {
      var or__3548__auto____7147 = ch__7146 === "n";
      if(or__3548__auto____7147) {
        return or__3548__auto____7147
      }else {
        var or__3548__auto____7148 = ch__7146 === "r";
        if(or__3548__auto____7148) {
          return or__3548__auto____7148
        }else {
          return ch__7146 == null
        }
      }
    }()) {
      return reader
    }else {
      continue
    }
    break
  }
};
cljs.reader.int_pattern = cljs.core.re_pattern.call(null, "([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null, "([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null, "[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.re_find_STAR_ = function re_find_STAR_(re, s) {
  var matches__7149 = re.exec(s);
  if(matches__7149 != null) {
    if(matches__7149.length === 1) {
      return matches__7149[0]
    }else {
      return matches__7149
    }
  }else {
    return null
  }
};
cljs.reader.match_int = function match_int(s) {
  var groups__7150 = cljs.reader.re_find_STAR_.call(null, cljs.reader.int_pattern, s);
  var group3__7151 = groups__7150[2];
  if(!function() {
    var or__3548__auto____7152 = group3__7151 == null;
    if(or__3548__auto____7152) {
      return or__3548__auto____7152
    }else {
      return group3__7151.length < 1
    }
  }()) {
    return 0
  }else {
    var negate__7153 = "-" === groups__7150[1] ? -1 : 1;
    var a__7154 = cljs.core.truth_(groups__7150[3]) ? [groups__7150[3], 10] : cljs.core.truth_(groups__7150[4]) ? [groups__7150[4], 16] : cljs.core.truth_(groups__7150[5]) ? [groups__7150[5], 8] : cljs.core.truth_(groups__7150[7]) ? [groups__7150[7], parseInt(groups__7150[7])] : "\ufdd0'default" ? [null, null] : null;
    var n__7155 = a__7154[0];
    var radix__7156 = a__7154[1];
    if(n__7155 == null) {
      return null
    }else {
      return negate__7153 * parseInt(n__7155, radix__7156)
    }
  }
};
cljs.reader.match_ratio = function match_ratio(s) {
  var groups__7157 = cljs.reader.re_find_STAR_.call(null, cljs.reader.ratio_pattern, s);
  var numinator__7158 = groups__7157[1];
  var denominator__7159 = groups__7157[2];
  return parseInt(numinator__7158) / parseInt(denominator__7159)
};
cljs.reader.match_float = function match_float(s) {
  return parseFloat(s)
};
cljs.reader.re_matches_STAR_ = function re_matches_STAR_(re, s) {
  var matches__7160 = re.exec(s);
  if(function() {
    var and__3546__auto____7161 = matches__7160 != null;
    if(and__3546__auto____7161) {
      return matches__7160[0] === s
    }else {
      return and__3546__auto____7161
    }
  }()) {
    if(matches__7160.length === 1) {
      return matches__7160[0]
    }else {
      return matches__7160
    }
  }else {
    return null
  }
};
cljs.reader.match_number = function match_number(s) {
  if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.int_pattern, s))) {
    return cljs.reader.match_int.call(null, s)
  }else {
    if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.ratio_pattern, s))) {
      return cljs.reader.match_ratio.call(null, s)
    }else {
      if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null, cljs.reader.float_pattern, s))) {
        return cljs.reader.match_float.call(null, s)
      }else {
        return null
      }
    }
  }
};
cljs.reader.escape_char_map = function escape_char_map(c) {
  if("f" === c) {
    return"\u000c"
  }else {
    if("b" === c) {
      return"\u0008"
    }else {
      if('"' === c) {
        return'"'
      }else {
        if("\\" === c) {
          return"\\"
        }else {
          if("n" === c) {
            return"\n"
          }else {
            if("r" === c) {
              return"\r"
            }else {
              if("t" === c) {
                return"\t"
              }else {
                if("\ufdd0'else") {
                  return null
                }else {
                  return null
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.read_unicode_char = function read_unicode_char(reader, initch) {
  return cljs.reader.reader_error.call(null, reader, "Unicode characters not supported by reader (yet)")
};
cljs.reader.escape_char = function escape_char(buffer, reader) {
  var ch__7162 = cljs.reader.read_char.call(null, reader);
  var mapresult__7163 = cljs.reader.escape_char_map.call(null, ch__7162);
  if(cljs.core.truth_(mapresult__7163)) {
    return mapresult__7163
  }else {
    if(function() {
      var or__3548__auto____7164 = "u" === ch__7162;
      if(or__3548__auto____7164) {
        return or__3548__auto____7164
      }else {
        return cljs.reader.numeric_QMARK_.call(null, ch__7162)
      }
    }()) {
      return cljs.reader.read_unicode_char.call(null, reader, ch__7162)
    }else {
      return cljs.reader.reader_error.call(null, reader, "Unsupported escape character: \\", ch__7162)
    }
  }
};
cljs.reader.read_past = function read_past(pred, rdr) {
  var ch__7165 = cljs.reader.read_char.call(null, rdr);
  while(true) {
    if(cljs.core.truth_(pred.call(null, ch__7165))) {
      var G__7166 = cljs.reader.read_char.call(null, rdr);
      ch__7165 = G__7166;
      continue
    }else {
      return ch__7165
    }
    break
  }
};
cljs.reader.read_delimited_list = function read_delimited_list(delim, rdr, recursive_QMARK_) {
  var a__7167 = cljs.core.transient$.call(null, cljs.core.PersistentVector.fromArray([]));
  while(true) {
    var ch__7168 = cljs.reader.read_past.call(null, cljs.reader.whitespace_QMARK_, rdr);
    if(cljs.core.truth_(ch__7168)) {
    }else {
      cljs.reader.reader_error.call(null, rdr, "EOF")
    }
    if(delim === ch__7168) {
      return cljs.core.persistent_BANG_.call(null, a__7167)
    }else {
      var temp__3695__auto____7169 = cljs.reader.macros.call(null, ch__7168);
      if(cljs.core.truth_(temp__3695__auto____7169)) {
        var macrofn__7170 = temp__3695__auto____7169;
        var mret__7171 = macrofn__7170.call(null, rdr, ch__7168);
        var G__7173 = mret__7171 === rdr ? a__7167 : cljs.core.conj_BANG_.call(null, a__7167, mret__7171);
        a__7167 = G__7173;
        continue
      }else {
        cljs.reader.unread.call(null, rdr, ch__7168);
        var o__7172 = cljs.reader.read.call(null, rdr, true, null, recursive_QMARK_);
        var G__7174 = o__7172 === rdr ? a__7167 : cljs.core.conj_BANG_.call(null, a__7167, o__7172);
        a__7167 = G__7174;
        continue
      }
    }
    break
  }
};
cljs.reader.not_implemented = function not_implemented(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Reader for ", ch, " not implemented yet")
};
void 0;
cljs.reader.read_dispatch = function read_dispatch(rdr, _) {
  var ch__7175 = cljs.reader.read_char.call(null, rdr);
  var dm__7176 = cljs.reader.dispatch_macros.call(null, ch__7175);
  if(cljs.core.truth_(dm__7176)) {
    return dm__7176.call(null, rdr, _)
  }else {
    var temp__3695__auto____7177 = cljs.reader.maybe_read_tagged_type.call(null, rdr, ch__7175);
    if(cljs.core.truth_(temp__3695__auto____7177)) {
      var obj__7178 = temp__3695__auto____7177;
      return obj__7178
    }else {
      return cljs.reader.reader_error.call(null, rdr, "No dispatch macro for ", ch__7175)
    }
  }
};
cljs.reader.read_unmatched_delimiter = function read_unmatched_delimiter(rdr, ch) {
  return cljs.reader.reader_error.call(null, rdr, "Unmached delimiter ", ch)
};
cljs.reader.read_list = function read_list(rdr, _) {
  return cljs.core.apply.call(null, cljs.core.list, cljs.reader.read_delimited_list.call(null, ")", rdr, true))
};
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = function read_vector(rdr, _) {
  return cljs.reader.read_delimited_list.call(null, "]", rdr, true)
};
cljs.reader.read_map = function read_map(rdr, _) {
  var l__7179 = cljs.reader.read_delimited_list.call(null, "}", rdr, true);
  if(cljs.core.odd_QMARK_.call(null, cljs.core.count.call(null, l__7179))) {
    cljs.reader.reader_error.call(null, rdr, "Map literal must contain an even number of forms")
  }else {
  }
  return cljs.core.apply.call(null, cljs.core.hash_map, l__7179)
};
cljs.reader.read_number = function read_number(reader, initch) {
  var buffer__7180 = new goog.string.StringBuffer(initch);
  var ch__7181 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(cljs.core.truth_(function() {
      var or__3548__auto____7182 = ch__7181 == null;
      if(or__3548__auto____7182) {
        return or__3548__auto____7182
      }else {
        var or__3548__auto____7183 = cljs.reader.whitespace_QMARK_.call(null, ch__7181);
        if(or__3548__auto____7183) {
          return or__3548__auto____7183
        }else {
          return cljs.reader.macros.call(null, ch__7181)
        }
      }
    }())) {
      cljs.reader.unread.call(null, reader, ch__7181);
      var s__7184 = buffer__7180.toString();
      var or__3548__auto____7185 = cljs.reader.match_number.call(null, s__7184);
      if(cljs.core.truth_(or__3548__auto____7185)) {
        return or__3548__auto____7185
      }else {
        return cljs.reader.reader_error.call(null, reader, "Invalid number format [", s__7184, "]")
      }
    }else {
      var G__7186 = function() {
        buffer__7180.append(ch__7181);
        return buffer__7180
      }();
      var G__7187 = cljs.reader.read_char.call(null, reader);
      buffer__7180 = G__7186;
      ch__7181 = G__7187;
      continue
    }
    break
  }
};
cljs.reader.read_string_STAR_ = function read_string_STAR_(reader, _) {
  var buffer__7188 = new goog.string.StringBuffer;
  var ch__7189 = cljs.reader.read_char.call(null, reader);
  while(true) {
    if(ch__7189 == null) {
      return cljs.reader.reader_error.call(null, reader, "EOF while reading string")
    }else {
      if("\\" === ch__7189) {
        var G__7190 = function() {
          buffer__7188.append(cljs.reader.escape_char.call(null, buffer__7188, reader));
          return buffer__7188
        }();
        var G__7191 = cljs.reader.read_char.call(null, reader);
        buffer__7188 = G__7190;
        ch__7189 = G__7191;
        continue
      }else {
        if('"' === ch__7189) {
          return buffer__7188.toString()
        }else {
          if("\ufdd0'default") {
            var G__7192 = function() {
              buffer__7188.append(ch__7189);
              return buffer__7188
            }();
            var G__7193 = cljs.reader.read_char.call(null, reader);
            buffer__7188 = G__7192;
            ch__7189 = G__7193;
            continue
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.special_symbols = cljs.core.ObjMap.fromObject(["nil", "true", "false"], {"nil":null, "true":true, "false":false});
cljs.reader.read_symbol = function read_symbol(reader, initch) {
  var token__7194 = cljs.reader.read_token.call(null, reader, initch);
  if(cljs.core.truth_(goog.string.contains.call(null, token__7194, "/"))) {
    return cljs.core.symbol.call(null, cljs.core.subs.call(null, token__7194, 0, token__7194.indexOf("/")), cljs.core.subs.call(null, token__7194, token__7194.indexOf("/") + 1, token__7194.length))
  }else {
    return cljs.core.get.call(null, cljs.reader.special_symbols, token__7194, cljs.core.symbol.call(null, token__7194))
  }
};
cljs.reader.read_keyword = function read_keyword(reader, initch) {
  var token__7195 = cljs.reader.read_token.call(null, reader, cljs.reader.read_char.call(null, reader));
  var a__7196 = cljs.reader.re_matches_STAR_.call(null, cljs.reader.symbol_pattern, token__7195);
  var token__7197 = a__7196[0];
  var ns__7198 = a__7196[1];
  var name__7199 = a__7196[2];
  if(cljs.core.truth_(function() {
    var or__3548__auto____7201 = function() {
      var and__3546__auto____7200 = !(void 0 === ns__7198);
      if(and__3546__auto____7200) {
        return ns__7198.substring(ns__7198.length - 2, ns__7198.length) === ":/"
      }else {
        return and__3546__auto____7200
      }
    }();
    if(cljs.core.truth_(or__3548__auto____7201)) {
      return or__3548__auto____7201
    }else {
      var or__3548__auto____7202 = name__7199[name__7199.length - 1] === ":";
      if(or__3548__auto____7202) {
        return or__3548__auto____7202
      }else {
        return!(token__7197.indexOf("::", 1) === -1)
      }
    }
  }())) {
    return cljs.reader.reader_error.call(null, reader, "Invalid token: ", token__7197)
  }else {
    if(cljs.core.truth_(ns__7198)) {
      return cljs.core.keyword.call(null, ns__7198.substring(0, ns__7198.indexOf("/")), name__7199)
    }else {
      return cljs.core.keyword.call(null, token__7197)
    }
  }
};
cljs.reader.desugar_meta = function desugar_meta(f) {
  if(cljs.core.symbol_QMARK_.call(null, f)) {
    return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
  }else {
    if(cljs.core.string_QMARK_.call(null, f)) {
      return cljs.core.ObjMap.fromObject(["\ufdd0'tag"], {"\ufdd0'tag":f})
    }else {
      if(cljs.core.keyword_QMARK_.call(null, f)) {
        return cljs.core.PersistentArrayMap.fromArrays([f], [true])
      }else {
        if("\ufdd0'else") {
          return f
        }else {
          return null
        }
      }
    }
  }
};
cljs.reader.wrapping_reader = function wrapping_reader(sym) {
  return function(rdr, _) {
    return cljs.core.list.call(null, sym, cljs.reader.read.call(null, rdr, true, null, true))
  }
};
cljs.reader.throwing_reader = function throwing_reader(msg) {
  return function(rdr, _) {
    return cljs.reader.reader_error.call(null, rdr, msg)
  }
};
cljs.reader.read_meta = function read_meta(rdr, _) {
  var m__7203 = cljs.reader.desugar_meta.call(null, cljs.reader.read.call(null, rdr, true, null, true));
  if(cljs.core.map_QMARK_.call(null, m__7203)) {
  }else {
    cljs.reader.reader_error.call(null, rdr, "Metadata must be Symbol,Keyword,String or Map")
  }
  var o__7204 = cljs.reader.read.call(null, rdr, true, null, true);
  if(function() {
    var G__7205__7206 = o__7204;
    if(G__7205__7206 != null) {
      if(function() {
        var or__3548__auto____7207 = G__7205__7206.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3548__auto____7207) {
          return or__3548__auto____7207
        }else {
          return G__7205__7206.cljs$core$IWithMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7205__7206.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7205__7206)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IWithMeta, G__7205__7206)
    }
  }()) {
    return cljs.core.with_meta.call(null, o__7204, cljs.core.merge.call(null, cljs.core.meta.call(null, o__7204), m__7203))
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Metadata can only be applied to IWithMetas")
  }
};
cljs.reader.read_set = function read_set(rdr, _) {
  return cljs.core.set.call(null, cljs.reader.read_delimited_list.call(null, "}", rdr, true))
};
cljs.reader.read_regex = function read_regex(rdr, ch) {
  return cljs.core.re_pattern.call(null, cljs.reader.read_string_STAR_.call(null, rdr, ch))
};
cljs.reader.read_discard = function read_discard(rdr, _) {
  cljs.reader.read.call(null, rdr, true, null, true);
  return rdr
};
cljs.reader.macros = function macros(c) {
  if("@" === c) {
    return cljs.reader.wrapping_reader.call(null, "\ufdd1'deref")
  }else {
    if("`" === c) {
      return cljs.reader.not_implemented
    }else {
      if('"' === c) {
        return cljs.reader.read_string_STAR_
      }else {
        if("#" === c) {
          return cljs.reader.read_dispatch
        }else {
          if("%" === c) {
            return cljs.reader.not_implemented
          }else {
            if("'" === c) {
              return cljs.reader.wrapping_reader.call(null, "\ufdd1'quote")
            }else {
              if("(" === c) {
                return cljs.reader.read_list
              }else {
                if(")" === c) {
                  return cljs.reader.read_unmatched_delimiter
                }else {
                  if(":" === c) {
                    return cljs.reader.read_keyword
                  }else {
                    if(";" === c) {
                      return cljs.reader.not_implemented
                    }else {
                      if("[" === c) {
                        return cljs.reader.read_vector
                      }else {
                        if("{" === c) {
                          return cljs.reader.read_map
                        }else {
                          if("\\" === c) {
                            return cljs.reader.read_char
                          }else {
                            if("]" === c) {
                              return cljs.reader.read_unmatched_delimiter
                            }else {
                              if("}" === c) {
                                return cljs.reader.read_unmatched_delimiter
                              }else {
                                if("^" === c) {
                                  return cljs.reader.read_meta
                                }else {
                                  if("~" === c) {
                                    return cljs.reader.not_implemented
                                  }else {
                                    if("\ufdd0'else") {
                                      return null
                                    }else {
                                      return null
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.reader.dispatch_macros = function dispatch_macros(s) {
  if("_" === s) {
    return cljs.reader.read_discard
  }else {
    if("!" === s) {
      return cljs.reader.read_comment
    }else {
      if('"' === s) {
        return cljs.reader.read_regex
      }else {
        if("<" === s) {
          return cljs.reader.throwing_reader.call(null, "Unreadable form")
        }else {
          if("{" === s) {
            return cljs.reader.read_set
          }else {
            if("\ufdd0'else") {
              return null
            }else {
              return null
            }
          }
        }
      }
    }
  }
};
cljs.reader.read = function read(reader, eof_is_error, sentinel, is_recursive) {
  while(true) {
    var ch__7208 = cljs.reader.read_char.call(null, reader);
    if(ch__7208 == null) {
      if(cljs.core.truth_(eof_is_error)) {
        return cljs.reader.reader_error.call(null, reader, "EOF")
      }else {
        return sentinel
      }
    }else {
      if(cljs.reader.whitespace_QMARK_.call(null, ch__7208)) {
        var G__7211 = reader;
        var G__7212 = eof_is_error;
        var G__7213 = sentinel;
        var G__7214 = is_recursive;
        reader = G__7211;
        eof_is_error = G__7212;
        sentinel = G__7213;
        is_recursive = G__7214;
        continue
      }else {
        if(cljs.reader.comment_prefix_QMARK_.call(null, ch__7208)) {
          var G__7215 = cljs.reader.read_comment.call(null, reader, ch__7208);
          var G__7216 = eof_is_error;
          var G__7217 = sentinel;
          var G__7218 = is_recursive;
          reader = G__7215;
          eof_is_error = G__7216;
          sentinel = G__7217;
          is_recursive = G__7218;
          continue
        }else {
          if("\ufdd0'else") {
            var f__7209 = cljs.reader.macros.call(null, ch__7208);
            var res__7210 = cljs.core.truth_(f__7209) ? f__7209.call(null, reader, ch__7208) : cljs.reader.number_literal_QMARK_.call(null, reader, ch__7208) ? cljs.reader.read_number.call(null, reader, ch__7208) : "\ufdd0'else" ? cljs.reader.read_symbol.call(null, reader, ch__7208) : null;
            if(res__7210 === reader) {
              var G__7219 = reader;
              var G__7220 = eof_is_error;
              var G__7221 = sentinel;
              var G__7222 = is_recursive;
              reader = G__7219;
              eof_is_error = G__7220;
              sentinel = G__7221;
              is_recursive = G__7222;
              continue
            }else {
              return res__7210
            }
          }else {
            return null
          }
        }
      }
    }
    break
  }
};
cljs.reader.read_string = function read_string(s) {
  var r__7223 = cljs.reader.push_back_reader.call(null, s);
  return cljs.reader.read.call(null, r__7223, true, null, false)
};
cljs.reader.read_date = function read_date(str) {
  return new Date(Date.parse.call(null, str))
};
cljs.reader.read_queue = function read_queue(elems) {
  if(cljs.core.vector_QMARK_.call(null, elems)) {
    return cljs.core.into.call(null, cljs.core.PersistentQueue.EMPTY, elems)
  }else {
    return cljs.reader.reader_error.call(null, null, "Queue literal expects a vector for its elements.")
  }
};
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject(["inst", "uuid", "queue"], {"inst":cljs.core.identity, "uuid":cljs.core.identity, "queue":cljs.reader.read_queue}));
cljs.reader.maybe_read_tagged_type = function maybe_read_tagged_type(rdr, initch) {
  var tag__7224 = cljs.reader.read_symbol.call(null, rdr, initch);
  var form__7225 = cljs.reader.read.call(null, rdr, true, null, false);
  var pfn__7226 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), cljs.core.name.call(null, tag__7224));
  if(cljs.core.truth_(pfn__7226)) {
    return pfn__7226.call(null, form__7225)
  }else {
    return cljs.reader.reader_error.call(null, rdr, "Could not find tag parser for ", cljs.core.name.call(null, tag__7224), cljs.core.pr_str.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_)))
  }
};
cljs.reader.register_tag_parser_BANG_ = function register_tag_parser_BANG_(tag, f) {
  var tag__7227 = cljs.core.name.call(null, tag);
  var old_parser__7228 = cljs.core.get.call(null, cljs.core.deref.call(null, cljs.reader._STAR_tag_table_STAR_), tag__7227);
  cljs.core.swap_BANG_.call(null, cljs.reader._STAR_tag_table_STAR_, cljs.core.assoc, tag__7227, f);
  return old_parser__7228
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape.call(null, match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__7366 = s;
      var limit__7367 = limit;
      var parts__7368 = cljs.core.PersistentVector.fromArray([]);
      while(true) {
        if(cljs.core._EQ_.call(null, limit__7367, 1)) {
          return cljs.core.conj.call(null, parts__7368, s__7366)
        }else {
          var temp__3695__auto____7369 = cljs.core.re_find.call(null, re, s__7366);
          if(cljs.core.truth_(temp__3695__auto____7369)) {
            var m__7370 = temp__3695__auto____7369;
            var index__7371 = s__7366.indexOf(m__7370);
            var G__7372 = s__7366.substring(index__7371 + cljs.core.count.call(null, m__7370));
            var G__7373 = limit__7367 - 1;
            var G__7374 = cljs.core.conj.call(null, parts__7368, s__7366.substring(0, index__7371));
            s__7366 = G__7372;
            limit__7367 = G__7373;
            parts__7368 = G__7374;
            continue
          }else {
            return cljs.core.conj.call(null, parts__7368, s__7366)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim.call(null, s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft.call(null, s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight.call(null, s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__7375 = s.length;
  while(true) {
    if(index__7375 === 0) {
      return""
    }else {
      var ch__7376 = cljs.core.get.call(null, s, index__7375 - 1);
      if(function() {
        var or__3548__auto____7377 = cljs.core._EQ_.call(null, ch__7376, "\n");
        if(or__3548__auto____7377) {
          return or__3548__auto____7377
        }else {
          return cljs.core._EQ_.call(null, ch__7376, "\r")
        }
      }()) {
        var G__7378 = index__7375 - 1;
        index__7375 = G__7378;
        continue
      }else {
        return s.substring(0, index__7375)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__7379 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3548__auto____7380 = cljs.core.not.call(null, s__7379);
    if(or__3548__auto____7380) {
      return or__3548__auto____7380
    }else {
      var or__3548__auto____7381 = cljs.core._EQ_.call(null, "", s__7379);
      if(or__3548__auto____7381) {
        return or__3548__auto____7381
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__7379)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__7382 = new goog.string.StringBuffer;
  var length__7383 = s.length;
  var index__7384 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__7383, index__7384)) {
      return buffer__7382.toString()
    }else {
      var ch__7385 = s.charAt(index__7384);
      var temp__3695__auto____7386 = cljs.core.get.call(null, cmap, ch__7385);
      if(cljs.core.truth_(temp__3695__auto____7386)) {
        var replacement__7387 = temp__3695__auto____7386;
        buffer__7382.append([cljs.core.str(replacement__7387)].join(""))
      }else {
        buffer__7382.append(ch__7385)
      }
      var G__7388 = index__7384 + 1;
      index__7384 = G__7388;
      continue
    }
    break
  }
};
goog.provide("jayq.util");
goog.require("cljs.core");
jayq.util.map__GT_js = function map__GT_js(m) {
  var out__7337 = {};
  var G__7338__7339 = cljs.core.seq.call(null, m);
  if(cljs.core.truth_(G__7338__7339)) {
    var G__7341__7343 = cljs.core.first.call(null, G__7338__7339);
    var vec__7342__7344 = G__7341__7343;
    var k__7345 = cljs.core.nth.call(null, vec__7342__7344, 0, null);
    var v__7346 = cljs.core.nth.call(null, vec__7342__7344, 1, null);
    var G__7338__7347 = G__7338__7339;
    var G__7341__7348 = G__7341__7343;
    var G__7338__7349 = G__7338__7347;
    while(true) {
      var vec__7350__7351 = G__7341__7348;
      var k__7352 = cljs.core.nth.call(null, vec__7350__7351, 0, null);
      var v__7353 = cljs.core.nth.call(null, vec__7350__7351, 1, null);
      var G__7338__7354 = G__7338__7349;
      out__7337[cljs.core.name.call(null, k__7352)] = v__7353;
      var temp__3698__auto____7355 = cljs.core.next.call(null, G__7338__7354);
      if(cljs.core.truth_(temp__3698__auto____7355)) {
        var G__7338__7356 = temp__3698__auto____7355;
        var G__7357 = cljs.core.first.call(null, G__7338__7356);
        var G__7358 = G__7338__7356;
        G__7341__7348 = G__7357;
        G__7338__7349 = G__7358;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return out__7337
};
jayq.util.wait = function wait(ms, func) {
  return setTimeout(func, ms)
};
jayq.util.log = function() {
  var log__delegate = function(v, text) {
    var vs__7359 = cljs.core.string_QMARK_.call(null, v) ? cljs.core.apply.call(null, cljs.core.str, v, text) : v;
    return console.log(vs__7359)
  };
  var log = function(v, var_args) {
    var text = null;
    if(goog.isDef(var_args)) {
      text = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return log__delegate.call(this, v, text)
  };
  log.cljs$lang$maxFixedArity = 1;
  log.cljs$lang$applyTo = function(arglist__7360) {
    var v = cljs.core.first(arglist__7360);
    var text = cljs.core.rest(arglist__7360);
    return log__delegate(v, text)
  };
  log.cljs$lang$arity$variadic = log__delegate;
  return log
}();
jayq.util.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__7361) {
          var vec__7362__7363 = p__7361;
          var k__7364 = cljs.core.nth.call(null, vec__7362__7363, 0, null);
          var v__7365 = cljs.core.nth.call(null, vec__7362__7363, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__7364), clj__GT_js.call(null, v__7365))
        }, cljs.core.ObjMap.fromObject([], {}), x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
goog.provide("jayq.core");
goog.require("cljs.core");
goog.require("jayq.util");
goog.require("clojure.string");
jayq.core.crate_meta = function crate_meta(func) {
  return func.prototype._crateGroup
};
jayq.core.__GT_selector = function __GT_selector(sel) {
  if(cljs.core.string_QMARK_.call(null, sel)) {
    return sel
  }else {
    if(cljs.core.fn_QMARK_.call(null, sel)) {
      var temp__3695__auto____7229 = jayq.core.crate_meta.call(null, sel);
      if(cljs.core.truth_(temp__3695__auto____7229)) {
        var cm__7230 = temp__3695__auto____7229;
        return[cljs.core.str("[crateGroup="), cljs.core.str(cm__7230), cljs.core.str("]")].join("")
      }else {
        return sel
      }
    }else {
      if(cljs.core.keyword_QMARK_.call(null, sel)) {
        return cljs.core.name.call(null, sel)
      }else {
        if("\ufdd0'else") {
          return sel
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.$ = function() {
  var $__delegate = function(sel, p__7231) {
    var vec__7232__7233 = p__7231;
    var context__7234 = cljs.core.nth.call(null, vec__7232__7233, 0, null);
    if(cljs.core.not.call(null, context__7234)) {
      return jQuery(jayq.core.__GT_selector.call(null, sel))
    }else {
      return jQuery(jayq.core.__GT_selector.call(null, sel), context__7234)
    }
  };
  var $ = function(sel, var_args) {
    var p__7231 = null;
    if(goog.isDef(var_args)) {
      p__7231 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return $__delegate.call(this, sel, p__7231)
  };
  $.cljs$lang$maxFixedArity = 1;
  $.cljs$lang$applyTo = function(arglist__7235) {
    var sel = cljs.core.first(arglist__7235);
    var p__7231 = cljs.core.rest(arglist__7235);
    return $__delegate(sel, p__7231)
  };
  $.cljs$lang$arity$variadic = $__delegate;
  return $
}();
jQuery.prototype.cljs$core$IReduce$ = true;
jQuery.prototype.cljs$core$IReduce$_reduce$arity$2 = function(this$, f) {
  return cljs.core.ci_reduce.call(null, this$, f)
};
jQuery.prototype.cljs$core$IReduce$_reduce$arity$3 = function(this$, f, start) {
  return cljs.core.ci_reduce.call(null, this$, f, start)
};
jQuery.prototype.cljs$core$ILookup$ = true;
jQuery.prototype.cljs$core$ILookup$_lookup$arity$2 = function(this$, k) {
  var or__3548__auto____7236 = this$.slice(k, k + 1);
  if(cljs.core.truth_(or__3548__auto____7236)) {
    return or__3548__auto____7236
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$ILookup$_lookup$arity$3 = function(this$, k, not_found) {
  return cljs.core._nth.call(null, this$, k, not_found)
};
jQuery.prototype.cljs$core$ISequential$ = true;
jQuery.prototype.cljs$core$IIndexed$ = true;
jQuery.prototype.cljs$core$IIndexed$_nth$arity$2 = function(this$, n) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    return null
  }
};
jQuery.prototype.cljs$core$IIndexed$_nth$arity$3 = function(this$, n, not_found) {
  if(n < cljs.core.count.call(null, this$)) {
    return this$.slice(n, n + 1)
  }else {
    if(void 0 === not_found) {
      return null
    }else {
      return not_found
    }
  }
};
jQuery.prototype.cljs$core$ICounted$ = true;
jQuery.prototype.cljs$core$ICounted$_count$arity$1 = function(this$) {
  return this$.size()
};
jQuery.prototype.cljs$core$ISeq$ = true;
jQuery.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  return this$.get(0)
};
jQuery.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  if(cljs.core.count.call(null, this$) > 1) {
    return this$.slice(1)
  }else {
    return cljs.core.list.call(null)
  }
};
jQuery.prototype.cljs$core$ISeqable$ = true;
jQuery.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  if(cljs.core.truth_(this$.get(0))) {
    return this$
  }else {
    return null
  }
};
jQuery.prototype.call = function() {
  var G__7237 = null;
  var G__7237__2 = function(_, k) {
    return cljs.core._lookup.call(null, this, k)
  };
  var G__7237__3 = function(_, k, not_found) {
    return cljs.core._lookup.call(null, this, k, not_found)
  };
  G__7237 = function(_, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7237__2.call(this, _, k);
      case 3:
        return G__7237__3.call(this, _, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7237
}();
jayq.core.anim = function anim(elem, props, dur) {
  return elem.animate(jayq.util.clj__GT_js.call(null, props), dur)
};
jayq.core.text = function text($elem, txt) {
  return $elem.text(txt)
};
jayq.core.css = function css($elem, opts) {
  if(cljs.core.keyword_QMARK_.call(null, opts)) {
    return $elem.css(cljs.core.name.call(null, opts))
  }else {
    return $elem.css(jayq.util.clj__GT_js.call(null, opts))
  }
};
jayq.core.attr = function() {
  var attr__delegate = function($elem, a, p__7238) {
    var vec__7239__7240 = p__7238;
    var v__7241 = cljs.core.nth.call(null, vec__7239__7240, 0, null);
    var a__7242 = cljs.core.name.call(null, a);
    if(cljs.core.not.call(null, v__7241)) {
      return $elem.attr(a__7242)
    }else {
      return $elem.attr(a__7242, v__7241)
    }
  };
  var attr = function($elem, a, var_args) {
    var p__7238 = null;
    if(goog.isDef(var_args)) {
      p__7238 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return attr__delegate.call(this, $elem, a, p__7238)
  };
  attr.cljs$lang$maxFixedArity = 2;
  attr.cljs$lang$applyTo = function(arglist__7243) {
    var $elem = cljs.core.first(arglist__7243);
    var a = cljs.core.first(cljs.core.next(arglist__7243));
    var p__7238 = cljs.core.rest(cljs.core.next(arglist__7243));
    return attr__delegate($elem, a, p__7238)
  };
  attr.cljs$lang$arity$variadic = attr__delegate;
  return attr
}();
jayq.core.remove_attr = function remove_attr($elem, a) {
  return $elem.removeAttr(cljs.core.name.call(null, a))
};
jayq.core.data = function() {
  var data__delegate = function($elem, k, p__7244) {
    var vec__7245__7246 = p__7244;
    var v__7247 = cljs.core.nth.call(null, vec__7245__7246, 0, null);
    var k__7248 = cljs.core.name.call(null, k);
    if(cljs.core.not.call(null, v__7247)) {
      return $elem.data(k__7248)
    }else {
      return $elem.data(k__7248, v__7247)
    }
  };
  var data = function($elem, k, var_args) {
    var p__7244 = null;
    if(goog.isDef(var_args)) {
      p__7244 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return data__delegate.call(this, $elem, k, p__7244)
  };
  data.cljs$lang$maxFixedArity = 2;
  data.cljs$lang$applyTo = function(arglist__7249) {
    var $elem = cljs.core.first(arglist__7249);
    var k = cljs.core.first(cljs.core.next(arglist__7249));
    var p__7244 = cljs.core.rest(cljs.core.next(arglist__7249));
    return data__delegate($elem, k, p__7244)
  };
  data.cljs$lang$arity$variadic = data__delegate;
  return data
}();
jayq.core.position = function position($elem) {
  return cljs.core.js__GT_clj.call(null, $elem.position(), "\ufdd0'keywordize-keys", true)
};
jayq.core.add_class = function add_class($elem, cl) {
  var cl__7250 = cljs.core.name.call(null, cl);
  return $elem.addClass(cl__7250)
};
jayq.core.remove_class = function remove_class($elem, cl) {
  var cl__7251 = cljs.core.name.call(null, cl);
  return $elem.removeClass(cl__7251)
};
jayq.core.toggle_class = function toggle_class($elem, cl) {
  var cl__7252 = cljs.core.name.call(null, cl);
  return $elem.toggleClass(cl__7252)
};
jayq.core.has_class = function has_class($elem, cl) {
  var cl__7253 = cljs.core.name.call(null, cl);
  return $elem.hasClass(cl__7253)
};
jayq.core.after = function after($elem, content) {
  return $elem.after(content)
};
jayq.core.before = function before($elem, content) {
  return $elem.before(content)
};
jayq.core.append = function append($elem, content) {
  return $elem.append(content)
};
jayq.core.prepend = function prepend($elem, content) {
  return $elem.prepend(content)
};
jayq.core.remove = function remove($elem) {
  return $elem.remove()
};
jayq.core.hide = function() {
  var hide__delegate = function($elem, p__7254) {
    var vec__7255__7256 = p__7254;
    var speed__7257 = cljs.core.nth.call(null, vec__7255__7256, 0, null);
    var on_finish__7258 = cljs.core.nth.call(null, vec__7255__7256, 1, null);
    return $elem.hide(speed__7257, on_finish__7258)
  };
  var hide = function($elem, var_args) {
    var p__7254 = null;
    if(goog.isDef(var_args)) {
      p__7254 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return hide__delegate.call(this, $elem, p__7254)
  };
  hide.cljs$lang$maxFixedArity = 1;
  hide.cljs$lang$applyTo = function(arglist__7259) {
    var $elem = cljs.core.first(arglist__7259);
    var p__7254 = cljs.core.rest(arglist__7259);
    return hide__delegate($elem, p__7254)
  };
  hide.cljs$lang$arity$variadic = hide__delegate;
  return hide
}();
jayq.core.show = function() {
  var show__delegate = function($elem, p__7260) {
    var vec__7261__7262 = p__7260;
    var speed__7263 = cljs.core.nth.call(null, vec__7261__7262, 0, null);
    var on_finish__7264 = cljs.core.nth.call(null, vec__7261__7262, 1, null);
    return $elem.show(speed__7263, on_finish__7264)
  };
  var show = function($elem, var_args) {
    var p__7260 = null;
    if(goog.isDef(var_args)) {
      p__7260 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return show__delegate.call(this, $elem, p__7260)
  };
  show.cljs$lang$maxFixedArity = 1;
  show.cljs$lang$applyTo = function(arglist__7265) {
    var $elem = cljs.core.first(arglist__7265);
    var p__7260 = cljs.core.rest(arglist__7265);
    return show__delegate($elem, p__7260)
  };
  show.cljs$lang$arity$variadic = show__delegate;
  return show
}();
jayq.core.toggle = function() {
  var toggle__delegate = function($elem, p__7266) {
    var vec__7267__7268 = p__7266;
    var speed__7269 = cljs.core.nth.call(null, vec__7267__7268, 0, null);
    var on_finish__7270 = cljs.core.nth.call(null, vec__7267__7268, 1, null);
    return $elem.toggle(speed__7269, on_finish__7270)
  };
  var toggle = function($elem, var_args) {
    var p__7266 = null;
    if(goog.isDef(var_args)) {
      p__7266 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return toggle__delegate.call(this, $elem, p__7266)
  };
  toggle.cljs$lang$maxFixedArity = 1;
  toggle.cljs$lang$applyTo = function(arglist__7271) {
    var $elem = cljs.core.first(arglist__7271);
    var p__7266 = cljs.core.rest(arglist__7271);
    return toggle__delegate($elem, p__7266)
  };
  toggle.cljs$lang$arity$variadic = toggle__delegate;
  return toggle
}();
jayq.core.fade_out = function() {
  var fade_out__delegate = function($elem, p__7272) {
    var vec__7273__7274 = p__7272;
    var speed__7275 = cljs.core.nth.call(null, vec__7273__7274, 0, null);
    var on_finish__7276 = cljs.core.nth.call(null, vec__7273__7274, 1, null);
    return $elem.fadeOut(speed__7275, on_finish__7276)
  };
  var fade_out = function($elem, var_args) {
    var p__7272 = null;
    if(goog.isDef(var_args)) {
      p__7272 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_out__delegate.call(this, $elem, p__7272)
  };
  fade_out.cljs$lang$maxFixedArity = 1;
  fade_out.cljs$lang$applyTo = function(arglist__7277) {
    var $elem = cljs.core.first(arglist__7277);
    var p__7272 = cljs.core.rest(arglist__7277);
    return fade_out__delegate($elem, p__7272)
  };
  fade_out.cljs$lang$arity$variadic = fade_out__delegate;
  return fade_out
}();
jayq.core.fade_in = function() {
  var fade_in__delegate = function($elem, p__7278) {
    var vec__7279__7280 = p__7278;
    var speed__7281 = cljs.core.nth.call(null, vec__7279__7280, 0, null);
    var on_finish__7282 = cljs.core.nth.call(null, vec__7279__7280, 1, null);
    return $elem.fadeIn(speed__7281, on_finish__7282)
  };
  var fade_in = function($elem, var_args) {
    var p__7278 = null;
    if(goog.isDef(var_args)) {
      p__7278 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return fade_in__delegate.call(this, $elem, p__7278)
  };
  fade_in.cljs$lang$maxFixedArity = 1;
  fade_in.cljs$lang$applyTo = function(arglist__7283) {
    var $elem = cljs.core.first(arglist__7283);
    var p__7278 = cljs.core.rest(arglist__7283);
    return fade_in__delegate($elem, p__7278)
  };
  fade_in.cljs$lang$arity$variadic = fade_in__delegate;
  return fade_in
}();
jayq.core.slide_up = function() {
  var slide_up__delegate = function($elem, p__7284) {
    var vec__7285__7286 = p__7284;
    var speed__7287 = cljs.core.nth.call(null, vec__7285__7286, 0, null);
    var on_finish__7288 = cljs.core.nth.call(null, vec__7285__7286, 1, null);
    return $elem.slideUp(speed__7287, on_finish__7288)
  };
  var slide_up = function($elem, var_args) {
    var p__7284 = null;
    if(goog.isDef(var_args)) {
      p__7284 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_up__delegate.call(this, $elem, p__7284)
  };
  slide_up.cljs$lang$maxFixedArity = 1;
  slide_up.cljs$lang$applyTo = function(arglist__7289) {
    var $elem = cljs.core.first(arglist__7289);
    var p__7284 = cljs.core.rest(arglist__7289);
    return slide_up__delegate($elem, p__7284)
  };
  slide_up.cljs$lang$arity$variadic = slide_up__delegate;
  return slide_up
}();
jayq.core.slide_down = function() {
  var slide_down__delegate = function($elem, p__7290) {
    var vec__7291__7292 = p__7290;
    var speed__7293 = cljs.core.nth.call(null, vec__7291__7292, 0, null);
    var on_finish__7294 = cljs.core.nth.call(null, vec__7291__7292, 1, null);
    return $elem.slideDown(speed__7293, on_finish__7294)
  };
  var slide_down = function($elem, var_args) {
    var p__7290 = null;
    if(goog.isDef(var_args)) {
      p__7290 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return slide_down__delegate.call(this, $elem, p__7290)
  };
  slide_down.cljs$lang$maxFixedArity = 1;
  slide_down.cljs$lang$applyTo = function(arglist__7295) {
    var $elem = cljs.core.first(arglist__7295);
    var p__7290 = cljs.core.rest(arglist__7295);
    return slide_down__delegate($elem, p__7290)
  };
  slide_down.cljs$lang$arity$variadic = slide_down__delegate;
  return slide_down
}();
jayq.core.parent = function parent($elem) {
  return $elem.parent()
};
jayq.core.find = function find($elem, selector) {
  return $elem.find(cljs.core.name.call(null, selector))
};
jayq.core.closest = function() {
  var closest__delegate = function($elem, selector, p__7296) {
    var vec__7297__7298 = p__7296;
    var context__7299 = cljs.core.nth.call(null, vec__7297__7298, 0, null);
    return $elem.closest(selector, context__7299)
  };
  var closest = function($elem, selector, var_args) {
    var p__7296 = null;
    if(goog.isDef(var_args)) {
      p__7296 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return closest__delegate.call(this, $elem, selector, p__7296)
  };
  closest.cljs$lang$maxFixedArity = 2;
  closest.cljs$lang$applyTo = function(arglist__7300) {
    var $elem = cljs.core.first(arglist__7300);
    var selector = cljs.core.first(cljs.core.next(arglist__7300));
    var p__7296 = cljs.core.rest(cljs.core.next(arglist__7300));
    return closest__delegate($elem, selector, p__7296)
  };
  closest.cljs$lang$arity$variadic = closest__delegate;
  return closest
}();
jayq.core.clone = function clone($elem) {
  return $elem.clone()
};
jayq.core.inner = function inner($elem, v) {
  return $elem.html(v)
};
jayq.core.empty = function empty($elem) {
  return $elem.empty()
};
jayq.core.val = function() {
  var val__delegate = function($elem, p__7301) {
    var vec__7302__7303 = p__7301;
    var v__7304 = cljs.core.nth.call(null, vec__7302__7303, 0, null);
    if(cljs.core.truth_(v__7304)) {
      return $elem.val(v__7304)
    }else {
      return $elem.val()
    }
  };
  var val = function($elem, var_args) {
    var p__7301 = null;
    if(goog.isDef(var_args)) {
      p__7301 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return val__delegate.call(this, $elem, p__7301)
  };
  val.cljs$lang$maxFixedArity = 1;
  val.cljs$lang$applyTo = function(arglist__7305) {
    var $elem = cljs.core.first(arglist__7305);
    var p__7301 = cljs.core.rest(arglist__7305);
    return val__delegate($elem, p__7301)
  };
  val.cljs$lang$arity$variadic = val__delegate;
  return val
}();
jayq.core.serialize = function serialize($elem) {
  return $elem.serialize()
};
jayq.core.queue = function queue($elem, callback) {
  return $elem.queue(callback)
};
jayq.core.dequeue = function dequeue(elem) {
  return jayq.core.$.call(null, elem).dequeue()
};
jayq.core.document_ready = function document_ready(func) {
  return jayq.core.$.call(null, document).ready(func)
};
jayq.core.xhr = function xhr(p__7306, content, callback) {
  var vec__7307__7308 = p__7306;
  var method__7309 = cljs.core.nth.call(null, vec__7307__7308, 0, null);
  var uri__7310 = cljs.core.nth.call(null, vec__7307__7308, 1, null);
  var params__7311 = jayq.util.clj__GT_js.call(null, cljs.core.ObjMap.fromObject(["\ufdd0'type", "\ufdd0'data", "\ufdd0'success"], {"\ufdd0'type":clojure.string.upper_case.call(null, cljs.core.name.call(null, method__7309)), "\ufdd0'data":jayq.util.clj__GT_js.call(null, content), "\ufdd0'success":callback}));
  return jQuery.ajax(uri__7310, params__7311)
};
jayq.core.ajax = function() {
  var ajax = null;
  var ajax__1 = function(settings) {
    return jQuery.ajax(jayq.util.clj__GT_js.call(null, settings))
  };
  var ajax__2 = function(url, settings) {
    return jQuery.ajax(url, jayq.util.clj__GT_js.call(null, settings))
  };
  ajax = function(url, settings) {
    switch(arguments.length) {
      case 1:
        return ajax__1.call(this, url);
      case 2:
        return ajax__2.call(this, url, settings)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ajax.cljs$lang$arity$1 = ajax__1;
  ajax.cljs$lang$arity$2 = ajax__2;
  return ajax
}();
jayq.core.bind = function bind($elem, ev, func) {
  return $elem.bind(cljs.core.name.call(null, ev), func)
};
jayq.core.unbind = function() {
  var unbind__delegate = function($elem, ev, p__7312) {
    var vec__7313__7314 = p__7312;
    var func__7315 = cljs.core.nth.call(null, vec__7313__7314, 0, null);
    return $elem.unbind(cljs.core.name.call(null, ev), func__7315)
  };
  var unbind = function($elem, ev, var_args) {
    var p__7312 = null;
    if(goog.isDef(var_args)) {
      p__7312 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return unbind__delegate.call(this, $elem, ev, p__7312)
  };
  unbind.cljs$lang$maxFixedArity = 2;
  unbind.cljs$lang$applyTo = function(arglist__7316) {
    var $elem = cljs.core.first(arglist__7316);
    var ev = cljs.core.first(cljs.core.next(arglist__7316));
    var p__7312 = cljs.core.rest(cljs.core.next(arglist__7316));
    return unbind__delegate($elem, ev, p__7312)
  };
  unbind.cljs$lang$arity$variadic = unbind__delegate;
  return unbind
}();
jayq.core.trigger = function trigger($elem, ev) {
  return $elem.trigger(cljs.core.name.call(null, ev))
};
jayq.core.delegate = function delegate($elem, sel, ev, func) {
  return $elem.delegate(jayq.core.__GT_selector.call(null, sel), cljs.core.name.call(null, ev), func)
};
jayq.core.__GT_event = function __GT_event(e) {
  if(cljs.core.keyword_QMARK_.call(null, e)) {
    return cljs.core.name.call(null, e)
  }else {
    if(cljs.core.map_QMARK_.call(null, e)) {
      return jayq.util.clj__GT_js.call(null, e)
    }else {
      if(cljs.core.coll_QMARK_.call(null, e)) {
        return clojure.string.join.call(null, " ", cljs.core.map.call(null, cljs.core.name, e))
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Unknown event type: "), cljs.core.str(e)].join(""));
        }else {
          return null
        }
      }
    }
  }
};
jayq.core.on = function() {
  var on__delegate = function($elem, events, p__7317) {
    var vec__7318__7319 = p__7317;
    var sel__7320 = cljs.core.nth.call(null, vec__7318__7319, 0, null);
    var data__7321 = cljs.core.nth.call(null, vec__7318__7319, 1, null);
    var handler__7322 = cljs.core.nth.call(null, vec__7318__7319, 2, null);
    return $elem.on(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7320), data__7321, handler__7322)
  };
  var on = function($elem, events, var_args) {
    var p__7317 = null;
    if(goog.isDef(var_args)) {
      p__7317 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return on__delegate.call(this, $elem, events, p__7317)
  };
  on.cljs$lang$maxFixedArity = 2;
  on.cljs$lang$applyTo = function(arglist__7323) {
    var $elem = cljs.core.first(arglist__7323);
    var events = cljs.core.first(cljs.core.next(arglist__7323));
    var p__7317 = cljs.core.rest(cljs.core.next(arglist__7323));
    return on__delegate($elem, events, p__7317)
  };
  on.cljs$lang$arity$variadic = on__delegate;
  return on
}();
jayq.core.one = function() {
  var one__delegate = function($elem, events, p__7324) {
    var vec__7325__7326 = p__7324;
    var sel__7327 = cljs.core.nth.call(null, vec__7325__7326, 0, null);
    var data__7328 = cljs.core.nth.call(null, vec__7325__7326, 1, null);
    var handler__7329 = cljs.core.nth.call(null, vec__7325__7326, 2, null);
    return $elem.one(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7327), data__7328, handler__7329)
  };
  var one = function($elem, events, var_args) {
    var p__7324 = null;
    if(goog.isDef(var_args)) {
      p__7324 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return one__delegate.call(this, $elem, events, p__7324)
  };
  one.cljs$lang$maxFixedArity = 2;
  one.cljs$lang$applyTo = function(arglist__7330) {
    var $elem = cljs.core.first(arglist__7330);
    var events = cljs.core.first(cljs.core.next(arglist__7330));
    var p__7324 = cljs.core.rest(cljs.core.next(arglist__7330));
    return one__delegate($elem, events, p__7324)
  };
  one.cljs$lang$arity$variadic = one__delegate;
  return one
}();
jayq.core.off = function() {
  var off__delegate = function($elem, events, p__7331) {
    var vec__7332__7333 = p__7331;
    var sel__7334 = cljs.core.nth.call(null, vec__7332__7333, 0, null);
    var handler__7335 = cljs.core.nth.call(null, vec__7332__7333, 1, null);
    return $elem.off(jayq.core.__GT_event.call(null, events), jayq.core.__GT_selector.call(null, sel__7334), handler__7335)
  };
  var off = function($elem, events, var_args) {
    var p__7331 = null;
    if(goog.isDef(var_args)) {
      p__7331 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return off__delegate.call(this, $elem, events, p__7331)
  };
  off.cljs$lang$maxFixedArity = 2;
  off.cljs$lang$applyTo = function(arglist__7336) {
    var $elem = cljs.core.first(arglist__7336);
    var events = cljs.core.first(cljs.core.next(arglist__7336));
    var p__7331 = cljs.core.rest(cljs.core.next(arglist__7336));
    return off__delegate($elem, events, p__7331)
  };
  off.cljs$lang$arity$variadic = off__delegate;
  return off
}();
jayq.core.prevent = function prevent(e) {
  return e.preventDefault()
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
goog.require("cljs.reader");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__4672 = {};
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__4671_SHARP_) {
    return out__4672[cljs.core.name.call(null, cljs.core.first.call(null, p1__4671_SHARP_))] = cljs.core.second.call(null, p1__4671_SHARP_)
  }, cljmap));
  return out__4672
};
cljsbinding.translate = function translate(data) {
  if(cljs.core.map_QMARK_.call(null, data)) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.checked = function checked(elem, c) {
  elem.removeAttr("checked");
  if(cljs.core.truth_(c)) {
    return jayq.core.attr.call(null, elem, "checked", "checked")
  }else {
    return null
  }
};
cljsbinding.setclass = function setclass(elem, c) {
  elem.removeClass();
  return elem.addClass(c)
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible", "class", "checked"], {"visible":cljsbinding.visible, "class":cljsbinding.setclass, "checked":cljsbinding.checked});
cljsbinding.fnhandlers = cljs.core.set(["click", "dblclick"]);
cljsbinding.in_bindseq_QMARK_ = function in_bindseq_QMARK_(elem) {
  var or__3548__auto____4673 = cljs.core.count.call(null, elem.filter("*[bindseq]")) > 0;
  if(or__3548__auto____4673) {
    return or__3548__auto____4673
  }else {
    return cljs.core.count.call(null, elem.parents("*[bindseq]")) > 0
  }
};
cljsbinding.valuefn = function valuefn(elem, fnstr, ctx, bindingname) {
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.fnhandlers, bindingname)) {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return function() {
        return eval(fnstr).call(null, ctx)
      }
    }else {
      return function() {
        return eval(fnstr).call(null)
      }
    }
  }else {
    if(cljs.core.truth_(cljsbinding.in_bindseq_QMARK_.call(null, elem))) {
      return cljsbinding.translate.call(null, eval(fnstr).call(null, ctx))
    }else {
      return cljsbinding.translate.call(null, eval(fnstr).call(null))
    }
  }
};
cljsbinding.bindfn = function bindfn(elem, data, ctx) {
  var bindingname__4674 = clojure.string.trim.call(null, cljs.core.first.call(null, data));
  var fname__4675 = clojure.string.trim.call(null, cljs.core.second.call(null, data));
  if(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, bindingname__4674)) {
    return function() {
      return cljsbinding.bindings.call(null, bindingname__4674).call(null, elem, cljsbinding.valuefn.call(null, elem, fname__4675, ctx, bindingname__4674))
    }
  }else {
    return function() {
      return elem[bindingname__4674].call(elem, cljsbinding.valuefn.call(null, elem, fname__4675, ctx, bindingname__4674))
    }
  }
};
cljsbinding.run_bind_fn = function run_bind_fn(f) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f);
  f.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.bind_elem = function bind_elem(elem, data, ctx) {
  return cljsbinding.run_bind_fn.call(null, cljsbinding.bindfn.call(null, elem, data, ctx))
};
cljsbinding.bind = function bind(elem, ctx) {
  var G__4676__4677 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__4676__4677)) {
    var data__4678 = cljs.core.first.call(null, G__4676__4677);
    var G__4676__4679 = G__4676__4677;
    while(true) {
      cljsbinding.bind_elem.call(null, elem, data__4678.split(":"), ctx);
      var temp__3698__auto____4680 = cljs.core.next.call(null, G__4676__4679);
      if(cljs.core.truth_(temp__3698__auto____4680)) {
        var G__4676__4681 = temp__3698__auto____4680;
        var G__4682 = cljs.core.first.call(null, G__4676__4681);
        var G__4683 = G__4676__4681;
        data__4678 = G__4682;
        G__4676__4679 = G__4683;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.atom_val = function atom_val(elem) {
  var aval__4685 = cljs.core.deref.call(null, eval(jayq.core.attr.call(null, elem, "bindatom")));
  if(cljs.core.map_QMARK_.call(null, aval__4685)) {
    return aval__4685.call(null, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")))
  }else {
    return aval__4685
  }
};
cljsbinding.reset_atom_val = function reset_atom_val(elem, atom, val) {
  if(cljs.core.map_QMARK_.call(null, cljs.core.deref.call(null, atom))) {
    return cljs.core.swap_BANG_.call(null, atom, function(p1__4684_SHARP_) {
      return cljs.core.assoc.call(null, p1__4684_SHARP_, cljs.core.keyword.call(null, jayq.core.attr.call(null, elem, "id")), val)
    })
  }else {
    return cljs.core.reset_BANG_.call(null, atom, val)
  }
};
cljsbinding.bind_input_atom = function bind_input_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return elem["val"].call(elem, cljsbinding.atom_val.call(null, elem))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, eval(jayq.core.attr.call(null, elem, "bindatom")), elem.val());
    return false
  })
};
cljsbinding.bind_checkbox_atom = function bind_checkbox_atom(elem) {
  cljsbinding.run_bind_fn.call(null, function() {
    return cljsbinding.checked.call(null, elem, cljsbinding.atom_val.call(null, elem))
  });
  return elem.change(function() {
    cljsbinding.reset_atom_val.call(null, elem, eval(jayq.core.attr.call(null, elem, "bindatom")), elem.is(":checked"));
    return false
  })
};
cljsbinding.bindatom = function bindatom(elem) {
  if(cljs.core._EQ_.call(null, "checkbox", jayq.core.attr.call(null, elem, "type"))) {
    return cljsbinding.bind_checkbox_atom.call(null, elem)
  }else {
    return cljsbinding.bind_input_atom.call(null, elem)
  }
};
cljsbinding.insert_seq_item = function insert_seq_item(parent, item, elem, bindfn) {
  jayq.core.append.call(null, parent, elem);
  return bindfn.call(null, elem, item)
};
cljsbinding.insertseq = function insertseq(seq, parent, template, bindfn) {
  jayq.core.remove.call(null, parent.children());
  var G__4686__4687 = cljs.core.seq.call(null, seq);
  if(cljs.core.truth_(G__4686__4687)) {
    var item__4688 = cljs.core.first.call(null, G__4686__4687);
    var G__4686__4689 = G__4686__4687;
    while(true) {
      cljsbinding.insert_seq_item.call(null, parent, item__4688, template.clone(), bindfn);
      var temp__3698__auto____4690 = cljs.core.next.call(null, G__4686__4689);
      if(cljs.core.truth_(temp__3698__auto____4690)) {
        var G__4686__4691 = temp__3698__auto____4690;
        var G__4692 = cljs.core.first.call(null, G__4686__4691);
        var G__4693 = G__4686__4691;
        item__4688 = G__4692;
        G__4686__4689 = G__4693;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindseq = function bindseq(elem, elparent, bindfn) {
  var atom__4695 = eval(jayq.core.attr.call(null, elem, "bindseq"));
  cljsbinding.insertseq.call(null, cljs.core.deref.call(null, atom__4695), elparent, elem, bindfn);
  return cljs.core.add_watch.call(null, atom__4695, "\ufdd0'seq-binding-watch", function(key, a, old_val, new_val) {
    return cljsbinding.insertseq.call(null, new_val, elparent, elem, bindfn)
  })
};
cljsbinding.dobind = function dobind(parent, ctx) {
  var seqs__4696 = jayq.core.$.call(null, parent.find("*[bindseq]"));
  var seqparents__4697 = cljs.core.seq.call(null, cljs.core.map.call(null, function(p1__4694_SHARP_) {
    return jayq.core.$.call(null, p1__4694_SHARP_).parent()
  }, jayq.core.$.call(null, parent.find("*[bindseq]"))));
  var G__4698__4699 = cljs.core.seq.call(null, seqs__4696);
  if(cljs.core.truth_(G__4698__4699)) {
    var elem__4700 = cljs.core.first.call(null, G__4698__4699);
    var G__4698__4701 = G__4698__4699;
    while(true) {
      jayq.core.remove.call(null, jayq.core.$.call(null, elem__4700));
      var temp__3698__auto____4702 = cljs.core.next.call(null, G__4698__4701);
      if(cljs.core.truth_(temp__3698__auto____4702)) {
        var G__4698__4703 = temp__3698__auto____4702;
        var G__4741 = cljs.core.first.call(null, G__4698__4703);
        var G__4742 = G__4698__4703;
        elem__4700 = G__4741;
        G__4698__4701 = G__4742;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4704__4705 = cljs.core.seq.call(null, parent.filter("*[bind]"));
  if(cljs.core.truth_(G__4704__4705)) {
    var elem__4706 = cljs.core.first.call(null, G__4704__4705);
    var G__4704__4707 = G__4704__4705;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4706), ctx);
      var temp__3698__auto____4708 = cljs.core.next.call(null, G__4704__4707);
      if(cljs.core.truth_(temp__3698__auto____4708)) {
        var G__4704__4709 = temp__3698__auto____4708;
        var G__4743 = cljs.core.first.call(null, G__4704__4709);
        var G__4744 = G__4704__4709;
        elem__4706 = G__4743;
        G__4704__4707 = G__4744;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4710__4711 = cljs.core.seq.call(null, parent.find("*[bind]"));
  if(cljs.core.truth_(G__4710__4711)) {
    var elem__4712 = cljs.core.first.call(null, G__4710__4711);
    var G__4710__4713 = G__4710__4711;
    while(true) {
      cljsbinding.bind.call(null, jayq.core.$.call(null, elem__4712), ctx);
      var temp__3698__auto____4714 = cljs.core.next.call(null, G__4710__4713);
      if(cljs.core.truth_(temp__3698__auto____4714)) {
        var G__4710__4715 = temp__3698__auto____4714;
        var G__4745 = cljs.core.first.call(null, G__4710__4715);
        var G__4746 = G__4710__4715;
        elem__4712 = G__4745;
        G__4710__4713 = G__4746;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4716__4717 = cljs.core.seq.call(null, parent.find("*[bindatom]"));
  if(cljs.core.truth_(G__4716__4717)) {
    var elem__4718 = cljs.core.first.call(null, G__4716__4717);
    var G__4716__4719 = G__4716__4717;
    while(true) {
      cljsbinding.bindatom.call(null, jayq.core.$.call(null, elem__4718));
      var temp__3698__auto____4720 = cljs.core.next.call(null, G__4716__4719);
      if(cljs.core.truth_(temp__3698__auto____4720)) {
        var G__4716__4721 = temp__3698__auto____4720;
        var G__4747 = cljs.core.first.call(null, G__4716__4721);
        var G__4748 = G__4716__4721;
        elem__4718 = G__4747;
        G__4716__4719 = G__4748;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__4722__4723 = cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.list, seqs__4696, seqparents__4697));
  if(cljs.core.truth_(G__4722__4723)) {
    var G__4725__4727 = cljs.core.first.call(null, G__4722__4723);
    var vec__4726__4728 = G__4725__4727;
    var elem__4729 = cljs.core.nth.call(null, vec__4726__4728, 0, null);
    var parent__4730 = cljs.core.nth.call(null, vec__4726__4728, 1, null);
    var G__4722__4731 = G__4722__4723;
    var G__4725__4732 = G__4725__4727;
    var G__4722__4733 = G__4722__4731;
    while(true) {
      var vec__4734__4735 = G__4725__4732;
      var elem__4736 = cljs.core.nth.call(null, vec__4734__4735, 0, null);
      var parent__4737 = cljs.core.nth.call(null, vec__4734__4735, 1, null);
      var G__4722__4738 = G__4722__4733;
      cljsbinding.bindseq.call(null, jayq.core.$.call(null, elem__4736), parent__4737, dobind);
      var temp__3698__auto____4739 = cljs.core.next.call(null, G__4722__4738);
      if(cljs.core.truth_(temp__3698__auto____4739)) {
        var G__4722__4740 = temp__3698__auto____4739;
        var G__4749 = cljs.core.first.call(null, G__4722__4740);
        var G__4750 = G__4722__4740;
        G__4725__4732 = G__4749;
        G__4722__4733 = G__4750;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindall = function() {
  var bindall = null;
  var bindall__1 = function(elem) {
    return cljsbinding.dobind.call(null, elem, null)
  };
  var bindall__2 = function(elem, ctx) {
    return cljsbinding.dobind.call(null, elem, ctx)
  };
  bindall = function(elem, ctx) {
    switch(arguments.length) {
      case 1:
        return bindall__1.call(this, elem);
      case 2:
        return bindall__2.call(this, elem, ctx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  bindall.cljs$lang$arity$1 = bindall__1;
  bindall.cljs$lang$arity$2 = bindall__2;
  return bindall
}();
goog.exportSymbol("cljsbinding.bindall", cljsbinding.bindall);
cljsbinding.init = function init() {
  return cljsbinding.bindall.call(null, jayq.core.$.call(null, "body"), null)
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.empty_QMARK_.call(null, sequence)) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__4751_SHARP_, p2__4752_SHARP_) {
      var or__3548__auto____4754 = p1__4751_SHARP_;
      if(cljs.core.truth_(or__3548__auto____4754)) {
        return or__3548__auto____4754
      }else {
        return p2__4752_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__4753_SHARP_) {
      return cljs.core._EQ_.call(null, p1__4753_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.add_binding = function add_binding(atom, m) {
  return cljs.core.assoc.call(null, m, atom, cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), m.call(null, atom)))
};
cljsbinding.run_bindings = function run_bindings(key, a, old_val, new_val) {
  var G__4755__4756 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
  if(cljs.core.truth_(G__4755__4756)) {
    var f__4757 = cljs.core.first.call(null, G__4755__4756);
    var G__4755__4758 = G__4755__4756;
    while(true) {
      f__4757.call(null);
      var temp__3698__auto____4759 = cljs.core.next.call(null, G__4755__4758);
      if(cljs.core.truth_(temp__3698__auto____4759)) {
        var G__4755__4760 = temp__3698__auto____4759;
        var G__4761 = cljs.core.first.call(null, G__4755__4760);
        var G__4762 = G__4755__4760;
        f__4757 = G__4761;
        G__4755__4758 = G__4762;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, cljs.core.partial.call(null, cljsbinding.add_binding, atom));
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", cljsbinding.run_bindings);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.cljsderef = function cljsderef() {
  return cljs.core._deref
};
goog.exportSymbol("cljsbinding.cljsderef", cljsbinding.cljsderef);
cljsbinding.shouldregister = function shouldregister(drf) {
  return drf.call(null, cljsbinding.BindMonitor)
};
goog.exportSymbol("cljsbinding.shouldregister", cljsbinding.shouldregister);
cljsbinding.boot = function boot() {
  return eval("    \n    var derefName = eval('cljsbinding.cljsderef.toString().match(/return.(.*$)\\\\s/m)[1]')\n    var deref = eval(derefName)\n    eval(derefName +' = function (a) { if (cljsbinding.shouldregister(deref)) { cljsbinding.register(a) };return deref(a); }')\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
cljsbinding.uuid = function uuid() {
  var r__4763 = cljs.core.repeatedly.call(null, 30, function() {
    return cljs.core.rand_int.call(null, 16).toString(16)
  });
  return cljs.core.apply.call(null, cljs.core.str, cljs.core.concat.call(null, cljs.core.take.call(null, 8, r__4763), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 4, cljs.core.drop.call(null, 8, r__4763)), cljs.core.PersistentVector.fromArray(["-4"]), cljs.core.take.call(null, 3, cljs.core.drop.call(null, 12, r__4763)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.PersistentVector.fromArray([(8 | 3 & cljs.core.rand_int.call(null, 15)).toString(16)]), cljs.core.take.call(null, 
  3, cljs.core.drop.call(null, 15, r__4763)), cljs.core.PersistentVector.fromArray(["-"]), cljs.core.take.call(null, 12, cljs.core.drop.call(null, 18, r__4763))))
};
goog.exportSymbol("cljsbinding.uuid", cljsbinding.uuid);
cljsbinding.bind_atom_to_localstorage = function bind_atom_to_localstorage(name, atom) {
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-localstorage-watch", function(key, a, old_val, new_val) {
    return localStorage[name] = cljs.core.pr_str.call(null, new_val)
  });
  return cljs.core.reset_BANG_.call(null, atom, cljs.reader.read_string.call(null, localStorage[name]))
};
goog.exportSymbol("cljsbinding.bind_atom_to_localstorage", cljsbinding.bind_atom_to_localstorage);
