var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.evalWorksForGlobals_ = null;
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.getObjectByName(name) && !goog.implicitNamespaces_[name]) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.require = function(rule) {
  if(!COMPILED) {
    if(goog.getObjectByName(rule)) {
      return
    }
    var path = goog.getPathFromDeps_(rule);
    if(path) {
      goog.included_[path] = true;
      goog.writeScripts_()
    }else {
      var errorMessage = "goog.require could not find: " + rule;
      if(goog.global.console) {
        goog.global.console["error"](errorMessage)
      }
      throw Error(errorMessage);
    }
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(requireName in deps.nameToPath) {
            visitNode(deps.nameToPath[requireName])
          }else {
            if(!goog.getObjectByName(requireName)) {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  var context = selfObj || goog.global;
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(context, newArgs)
    }
  }else {
    return function() {
      return fn.apply(context, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = style
};
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global && !goog.string.contains(str, "<")) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var el = goog.global["document"]["createElement"]("div");
  el["innerHTML"] = "<pre>x" + str + "</pre>";
  if(el["firstChild"][goog.string.NORMALIZE_FN_]) {
    el["firstChild"][goog.string.NORMALIZE_FN_]()
  }
  str = el["firstChild"]["firstChild"]["nodeValue"].slice(1);
  el["innerHTML"] = "";
  return goog.string.canonicalizeNewlines(str)
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.NORMALIZE_FN_ = "normalize";
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\u000b":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.string.StringBuffer");
goog.require("goog.object");
goog.require("goog.array");
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  var or__3548__auto____3226 = p[goog.typeOf.call(null, x)];
  if(cljs.core.truth_(or__3548__auto____3226)) {
    return or__3548__auto____3226
  }else {
    var or__3548__auto____3227 = p["_"];
    if(cljs.core.truth_(or__3548__auto____3227)) {
      return or__3548__auto____3227
    }else {
      return false
    }
  }
};
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error.call(null, "No protocol method " + proto + " defined for type " + goog.typeOf.call(null, obj) + ": " + obj)
};
cljs.core.aclone = function aclone(array_like) {
  return Array.prototype.slice.call(array_like)
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.aget = function aget(array, i) {
  return array[i]
};
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__3291 = function(this$) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3228 = this$;
      if(cljs.core.truth_(and__3546__auto____3228)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3228
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$)
    }else {
      return function() {
        var or__3548__auto____3229 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3229)) {
          return or__3548__auto____3229
        }else {
          var or__3548__auto____3230 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3230)) {
            return or__3548__auto____3230
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__3292 = function(this$, a) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3231 = this$;
      if(cljs.core.truth_(and__3546__auto____3231)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3231
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a)
    }else {
      return function() {
        var or__3548__auto____3232 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3232)) {
          return or__3548__auto____3232
        }else {
          var or__3548__auto____3233 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3233)) {
            return or__3548__auto____3233
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3293 = function(this$, a, b) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3234 = this$;
      if(cljs.core.truth_(and__3546__auto____3234)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3234
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b)
    }else {
      return function() {
        var or__3548__auto____3235 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3235)) {
          return or__3548__auto____3235
        }else {
          var or__3548__auto____3236 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3236)) {
            return or__3548__auto____3236
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__3294 = function(this$, a, b, c) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3237 = this$;
      if(cljs.core.truth_(and__3546__auto____3237)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3237
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c)
    }else {
      return function() {
        var or__3548__auto____3238 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3238)) {
          return or__3548__auto____3238
        }else {
          var or__3548__auto____3239 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3239)) {
            return or__3548__auto____3239
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__3295 = function(this$, a, b, c, d) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3240 = this$;
      if(cljs.core.truth_(and__3546__auto____3240)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3240
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d)
    }else {
      return function() {
        var or__3548__auto____3241 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3241)) {
          return or__3548__auto____3241
        }else {
          var or__3548__auto____3242 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3242)) {
            return or__3548__auto____3242
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__3296 = function(this$, a, b, c, d, e) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3243 = this$;
      if(cljs.core.truth_(and__3546__auto____3243)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3243
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e)
    }else {
      return function() {
        var or__3548__auto____3244 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3244)) {
          return or__3548__auto____3244
        }else {
          var or__3548__auto____3245 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3245)) {
            return or__3548__auto____3245
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__3297 = function(this$, a, b, c, d, e, f) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3246 = this$;
      if(cljs.core.truth_(and__3546__auto____3246)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3246
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f)
    }else {
      return function() {
        var or__3548__auto____3247 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3247)) {
          return or__3548__auto____3247
        }else {
          var or__3548__auto____3248 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3248)) {
            return or__3548__auto____3248
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__3298 = function(this$, a, b, c, d, e, f, g) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3249 = this$;
      if(cljs.core.truth_(and__3546__auto____3249)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3249
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g)
    }else {
      return function() {
        var or__3548__auto____3250 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3250)) {
          return or__3548__auto____3250
        }else {
          var or__3548__auto____3251 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3251)) {
            return or__3548__auto____3251
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__3299 = function(this$, a, b, c, d, e, f, g, h) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3252 = this$;
      if(cljs.core.truth_(and__3546__auto____3252)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3252
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h)
    }else {
      return function() {
        var or__3548__auto____3253 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3253)) {
          return or__3548__auto____3253
        }else {
          var or__3548__auto____3254 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3254)) {
            return or__3548__auto____3254
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__3300 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3255 = this$;
      if(cljs.core.truth_(and__3546__auto____3255)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3255
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i)
    }else {
      return function() {
        var or__3548__auto____3256 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3256)) {
          return or__3548__auto____3256
        }else {
          var or__3548__auto____3257 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3257)) {
            return or__3548__auto____3257
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__3301 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3258 = this$;
      if(cljs.core.truth_(and__3546__auto____3258)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3258
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      return function() {
        var or__3548__auto____3259 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3259)) {
          return or__3548__auto____3259
        }else {
          var or__3548__auto____3260 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3260)) {
            return or__3548__auto____3260
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__3302 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3261 = this$;
      if(cljs.core.truth_(and__3546__auto____3261)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3261
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      return function() {
        var or__3548__auto____3262 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3262)) {
          return or__3548__auto____3262
        }else {
          var or__3548__auto____3263 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3263)) {
            return or__3548__auto____3263
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__3303 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3264 = this$;
      if(cljs.core.truth_(and__3546__auto____3264)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3264
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      return function() {
        var or__3548__auto____3265 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3265)) {
          return or__3548__auto____3265
        }else {
          var or__3548__auto____3266 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3266)) {
            return or__3548__auto____3266
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__3304 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3267 = this$;
      if(cljs.core.truth_(and__3546__auto____3267)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3267
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      return function() {
        var or__3548__auto____3268 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3268)) {
          return or__3548__auto____3268
        }else {
          var or__3548__auto____3269 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3269)) {
            return or__3548__auto____3269
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__3305 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3270 = this$;
      if(cljs.core.truth_(and__3546__auto____3270)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3270
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      return function() {
        var or__3548__auto____3271 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3271)) {
          return or__3548__auto____3271
        }else {
          var or__3548__auto____3272 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3272)) {
            return or__3548__auto____3272
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__3306 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3273 = this$;
      if(cljs.core.truth_(and__3546__auto____3273)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3273
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      return function() {
        var or__3548__auto____3274 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3274)) {
          return or__3548__auto____3274
        }else {
          var or__3548__auto____3275 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3275)) {
            return or__3548__auto____3275
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__3307 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3276 = this$;
      if(cljs.core.truth_(and__3546__auto____3276)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3276
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      return function() {
        var or__3548__auto____3277 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3277)) {
          return or__3548__auto____3277
        }else {
          var or__3548__auto____3278 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3278)) {
            return or__3548__auto____3278
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__3308 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3279 = this$;
      if(cljs.core.truth_(and__3546__auto____3279)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3279
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      return function() {
        var or__3548__auto____3280 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3280)) {
          return or__3548__auto____3280
        }else {
          var or__3548__auto____3281 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3281)) {
            return or__3548__auto____3281
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__3309 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3282 = this$;
      if(cljs.core.truth_(and__3546__auto____3282)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3282
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      return function() {
        var or__3548__auto____3283 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3283)) {
          return or__3548__auto____3283
        }else {
          var or__3548__auto____3284 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3284)) {
            return or__3548__auto____3284
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__3310 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3285 = this$;
      if(cljs.core.truth_(and__3546__auto____3285)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3285
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      return function() {
        var or__3548__auto____3286 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3286)) {
          return or__3548__auto____3286
        }else {
          var or__3548__auto____3287 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3287)) {
            return or__3548__auto____3287
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__3311 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3288 = this$;
      if(cljs.core.truth_(and__3546__auto____3288)) {
        return this$.cljs$core$IFn$_invoke
      }else {
        return and__3546__auto____3288
      }
    }())) {
      return this$.cljs$core$IFn$_invoke(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      return function() {
        var or__3548__auto____3289 = cljs.core._invoke[goog.typeOf.call(null, this$)];
        if(cljs.core.truth_(or__3548__auto____3289)) {
          return or__3548__auto____3289
        }else {
          var or__3548__auto____3290 = cljs.core._invoke["_"];
          if(cljs.core.truth_(or__3548__auto____3290)) {
            return or__3548__auto____3290
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__3291.call(this, this$);
      case 2:
        return _invoke__3292.call(this, this$, a);
      case 3:
        return _invoke__3293.call(this, this$, a, b);
      case 4:
        return _invoke__3294.call(this, this$, a, b, c);
      case 5:
        return _invoke__3295.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__3296.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__3297.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__3298.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__3299.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__3300.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__3301.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__3302.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__3303.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__3304.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__3305.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__3306.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__3307.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__3308.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__3309.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__3310.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__3311.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return _invoke
}();
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3313 = coll;
    if(cljs.core.truth_(and__3546__auto____3313)) {
      return coll.cljs$core$ICounted$_count
    }else {
      return and__3546__auto____3313
    }
  }())) {
    return coll.cljs$core$ICounted$_count(coll)
  }else {
    return function() {
      var or__3548__auto____3314 = cljs.core._count[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3314)) {
        return or__3548__auto____3314
      }else {
        var or__3548__auto____3315 = cljs.core._count["_"];
        if(cljs.core.truth_(or__3548__auto____3315)) {
          return or__3548__auto____3315
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3316 = coll;
    if(cljs.core.truth_(and__3546__auto____3316)) {
      return coll.cljs$core$IEmptyableCollection$_empty
    }else {
      return and__3546__auto____3316
    }
  }())) {
    return coll.cljs$core$IEmptyableCollection$_empty(coll)
  }else {
    return function() {
      var or__3548__auto____3317 = cljs.core._empty[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3317)) {
        return or__3548__auto____3317
      }else {
        var or__3548__auto____3318 = cljs.core._empty["_"];
        if(cljs.core.truth_(or__3548__auto____3318)) {
          return or__3548__auto____3318
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3319 = coll;
    if(cljs.core.truth_(and__3546__auto____3319)) {
      return coll.cljs$core$ICollection$_conj
    }else {
      return and__3546__auto____3319
    }
  }())) {
    return coll.cljs$core$ICollection$_conj(coll, o)
  }else {
    return function() {
      var or__3548__auto____3320 = cljs.core._conj[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3320)) {
        return or__3548__auto____3320
      }else {
        var or__3548__auto____3321 = cljs.core._conj["_"];
        if(cljs.core.truth_(or__3548__auto____3321)) {
          return or__3548__auto____3321
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__3328 = function(coll, n) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3322 = coll;
      if(cljs.core.truth_(and__3546__auto____3322)) {
        return coll.cljs$core$IIndexed$_nth
      }else {
        return and__3546__auto____3322
      }
    }())) {
      return coll.cljs$core$IIndexed$_nth(coll, n)
    }else {
      return function() {
        var or__3548__auto____3323 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(cljs.core.truth_(or__3548__auto____3323)) {
          return or__3548__auto____3323
        }else {
          var or__3548__auto____3324 = cljs.core._nth["_"];
          if(cljs.core.truth_(or__3548__auto____3324)) {
            return or__3548__auto____3324
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3329 = function(coll, n, not_found) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3325 = coll;
      if(cljs.core.truth_(and__3546__auto____3325)) {
        return coll.cljs$core$IIndexed$_nth
      }else {
        return and__3546__auto____3325
      }
    }())) {
      return coll.cljs$core$IIndexed$_nth(coll, n, not_found)
    }else {
      return function() {
        var or__3548__auto____3326 = cljs.core._nth[goog.typeOf.call(null, coll)];
        if(cljs.core.truth_(or__3548__auto____3326)) {
          return or__3548__auto____3326
        }else {
          var or__3548__auto____3327 = cljs.core._nth["_"];
          if(cljs.core.truth_(or__3548__auto____3327)) {
            return or__3548__auto____3327
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__3328.call(this, coll, n);
      case 3:
        return _nth__3329.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return _nth
}();
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3331 = coll;
    if(cljs.core.truth_(and__3546__auto____3331)) {
      return coll.cljs$core$ISeq$_first
    }else {
      return and__3546__auto____3331
    }
  }())) {
    return coll.cljs$core$ISeq$_first(coll)
  }else {
    return function() {
      var or__3548__auto____3332 = cljs.core._first[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3332)) {
        return or__3548__auto____3332
      }else {
        var or__3548__auto____3333 = cljs.core._first["_"];
        if(cljs.core.truth_(or__3548__auto____3333)) {
          return or__3548__auto____3333
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3334 = coll;
    if(cljs.core.truth_(and__3546__auto____3334)) {
      return coll.cljs$core$ISeq$_rest
    }else {
      return and__3546__auto____3334
    }
  }())) {
    return coll.cljs$core$ISeq$_rest(coll)
  }else {
    return function() {
      var or__3548__auto____3335 = cljs.core._rest[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3335)) {
        return or__3548__auto____3335
      }else {
        var or__3548__auto____3336 = cljs.core._rest["_"];
        if(cljs.core.truth_(or__3548__auto____3336)) {
          return or__3548__auto____3336
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__3343 = function(o, k) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3337 = o;
      if(cljs.core.truth_(and__3546__auto____3337)) {
        return o.cljs$core$ILookup$_lookup
      }else {
        return and__3546__auto____3337
      }
    }())) {
      return o.cljs$core$ILookup$_lookup(o, k)
    }else {
      return function() {
        var or__3548__auto____3338 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(cljs.core.truth_(or__3548__auto____3338)) {
          return or__3548__auto____3338
        }else {
          var or__3548__auto____3339 = cljs.core._lookup["_"];
          if(cljs.core.truth_(or__3548__auto____3339)) {
            return or__3548__auto____3339
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3344 = function(o, k, not_found) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3340 = o;
      if(cljs.core.truth_(and__3546__auto____3340)) {
        return o.cljs$core$ILookup$_lookup
      }else {
        return and__3546__auto____3340
      }
    }())) {
      return o.cljs$core$ILookup$_lookup(o, k, not_found)
    }else {
      return function() {
        var or__3548__auto____3341 = cljs.core._lookup[goog.typeOf.call(null, o)];
        if(cljs.core.truth_(or__3548__auto____3341)) {
          return or__3548__auto____3341
        }else {
          var or__3548__auto____3342 = cljs.core._lookup["_"];
          if(cljs.core.truth_(or__3548__auto____3342)) {
            return or__3548__auto____3342
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__3343.call(this, o, k);
      case 3:
        return _lookup__3344.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return _lookup
}();
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3346 = coll;
    if(cljs.core.truth_(and__3546__auto____3346)) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_
    }else {
      return and__3546__auto____3346
    }
  }())) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_(coll, k)
  }else {
    return function() {
      var or__3548__auto____3347 = cljs.core._contains_key_QMARK_[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3347)) {
        return or__3548__auto____3347
      }else {
        var or__3548__auto____3348 = cljs.core._contains_key_QMARK_["_"];
        if(cljs.core.truth_(or__3548__auto____3348)) {
          return or__3548__auto____3348
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3349 = coll;
    if(cljs.core.truth_(and__3546__auto____3349)) {
      return coll.cljs$core$IAssociative$_assoc
    }else {
      return and__3546__auto____3349
    }
  }())) {
    return coll.cljs$core$IAssociative$_assoc(coll, k, v)
  }else {
    return function() {
      var or__3548__auto____3350 = cljs.core._assoc[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3350)) {
        return or__3548__auto____3350
      }else {
        var or__3548__auto____3351 = cljs.core._assoc["_"];
        if(cljs.core.truth_(or__3548__auto____3351)) {
          return or__3548__auto____3351
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3352 = coll;
    if(cljs.core.truth_(and__3546__auto____3352)) {
      return coll.cljs$core$IMap$_dissoc
    }else {
      return and__3546__auto____3352
    }
  }())) {
    return coll.cljs$core$IMap$_dissoc(coll, k)
  }else {
    return function() {
      var or__3548__auto____3353 = cljs.core._dissoc[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3353)) {
        return or__3548__auto____3353
      }else {
        var or__3548__auto____3354 = cljs.core._dissoc["_"];
        if(cljs.core.truth_(or__3548__auto____3354)) {
          return or__3548__auto____3354
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3355 = coll;
    if(cljs.core.truth_(and__3546__auto____3355)) {
      return coll.cljs$core$ISet$_disjoin
    }else {
      return and__3546__auto____3355
    }
  }())) {
    return coll.cljs$core$ISet$_disjoin(coll, v)
  }else {
    return function() {
      var or__3548__auto____3356 = cljs.core._disjoin[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3356)) {
        return or__3548__auto____3356
      }else {
        var or__3548__auto____3357 = cljs.core._disjoin["_"];
        if(cljs.core.truth_(or__3548__auto____3357)) {
          return or__3548__auto____3357
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3358 = coll;
    if(cljs.core.truth_(and__3546__auto____3358)) {
      return coll.cljs$core$IStack$_peek
    }else {
      return and__3546__auto____3358
    }
  }())) {
    return coll.cljs$core$IStack$_peek(coll)
  }else {
    return function() {
      var or__3548__auto____3359 = cljs.core._peek[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3359)) {
        return or__3548__auto____3359
      }else {
        var or__3548__auto____3360 = cljs.core._peek["_"];
        if(cljs.core.truth_(or__3548__auto____3360)) {
          return or__3548__auto____3360
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3361 = coll;
    if(cljs.core.truth_(and__3546__auto____3361)) {
      return coll.cljs$core$IStack$_pop
    }else {
      return and__3546__auto____3361
    }
  }())) {
    return coll.cljs$core$IStack$_pop(coll)
  }else {
    return function() {
      var or__3548__auto____3362 = cljs.core._pop[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3362)) {
        return or__3548__auto____3362
      }else {
        var or__3548__auto____3363 = cljs.core._pop["_"];
        if(cljs.core.truth_(or__3548__auto____3363)) {
          return or__3548__auto____3363
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3364 = coll;
    if(cljs.core.truth_(and__3546__auto____3364)) {
      return coll.cljs$core$IVector$_assoc_n
    }else {
      return and__3546__auto____3364
    }
  }())) {
    return coll.cljs$core$IVector$_assoc_n(coll, n, val)
  }else {
    return function() {
      var or__3548__auto____3365 = cljs.core._assoc_n[goog.typeOf.call(null, coll)];
      if(cljs.core.truth_(or__3548__auto____3365)) {
        return or__3548__auto____3365
      }else {
        var or__3548__auto____3366 = cljs.core._assoc_n["_"];
        if(cljs.core.truth_(or__3548__auto____3366)) {
          return or__3548__auto____3366
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3367 = o;
    if(cljs.core.truth_(and__3546__auto____3367)) {
      return o.cljs$core$IDeref$_deref
    }else {
      return and__3546__auto____3367
    }
  }())) {
    return o.cljs$core$IDeref$_deref(o)
  }else {
    return function() {
      var or__3548__auto____3368 = cljs.core._deref[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3368)) {
        return or__3548__auto____3368
      }else {
        var or__3548__auto____3369 = cljs.core._deref["_"];
        if(cljs.core.truth_(or__3548__auto____3369)) {
          return or__3548__auto____3369
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3370 = o;
    if(cljs.core.truth_(and__3546__auto____3370)) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout
    }else {
      return and__3546__auto____3370
    }
  }())) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout(o, msec, timeout_val)
  }else {
    return function() {
      var or__3548__auto____3371 = cljs.core._deref_with_timeout[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3371)) {
        return or__3548__auto____3371
      }else {
        var or__3548__auto____3372 = cljs.core._deref_with_timeout["_"];
        if(cljs.core.truth_(or__3548__auto____3372)) {
          return or__3548__auto____3372
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3373 = o;
    if(cljs.core.truth_(and__3546__auto____3373)) {
      return o.cljs$core$IMeta$_meta
    }else {
      return and__3546__auto____3373
    }
  }())) {
    return o.cljs$core$IMeta$_meta(o)
  }else {
    return function() {
      var or__3548__auto____3374 = cljs.core._meta[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3374)) {
        return or__3548__auto____3374
      }else {
        var or__3548__auto____3375 = cljs.core._meta["_"];
        if(cljs.core.truth_(or__3548__auto____3375)) {
          return or__3548__auto____3375
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3376 = o;
    if(cljs.core.truth_(and__3546__auto____3376)) {
      return o.cljs$core$IWithMeta$_with_meta
    }else {
      return and__3546__auto____3376
    }
  }())) {
    return o.cljs$core$IWithMeta$_with_meta(o, meta)
  }else {
    return function() {
      var or__3548__auto____3377 = cljs.core._with_meta[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3377)) {
        return or__3548__auto____3377
      }else {
        var or__3548__auto____3378 = cljs.core._with_meta["_"];
        if(cljs.core.truth_(or__3548__auto____3378)) {
          return or__3548__auto____3378
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__3385 = function(coll, f) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3379 = coll;
      if(cljs.core.truth_(and__3546__auto____3379)) {
        return coll.cljs$core$IReduce$_reduce
      }else {
        return and__3546__auto____3379
      }
    }())) {
      return coll.cljs$core$IReduce$_reduce(coll, f)
    }else {
      return function() {
        var or__3548__auto____3380 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(cljs.core.truth_(or__3548__auto____3380)) {
          return or__3548__auto____3380
        }else {
          var or__3548__auto____3381 = cljs.core._reduce["_"];
          if(cljs.core.truth_(or__3548__auto____3381)) {
            return or__3548__auto____3381
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3386 = function(coll, f, start) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3382 = coll;
      if(cljs.core.truth_(and__3546__auto____3382)) {
        return coll.cljs$core$IReduce$_reduce
      }else {
        return and__3546__auto____3382
      }
    }())) {
      return coll.cljs$core$IReduce$_reduce(coll, f, start)
    }else {
      return function() {
        var or__3548__auto____3383 = cljs.core._reduce[goog.typeOf.call(null, coll)];
        if(cljs.core.truth_(or__3548__auto____3383)) {
          return or__3548__auto____3383
        }else {
          var or__3548__auto____3384 = cljs.core._reduce["_"];
          if(cljs.core.truth_(or__3548__auto____3384)) {
            return or__3548__auto____3384
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__3385.call(this, coll, f);
      case 3:
        return _reduce__3386.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return _reduce
}();
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3388 = o;
    if(cljs.core.truth_(and__3546__auto____3388)) {
      return o.cljs$core$IEquiv$_equiv
    }else {
      return and__3546__auto____3388
    }
  }())) {
    return o.cljs$core$IEquiv$_equiv(o, other)
  }else {
    return function() {
      var or__3548__auto____3389 = cljs.core._equiv[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3389)) {
        return or__3548__auto____3389
      }else {
        var or__3548__auto____3390 = cljs.core._equiv["_"];
        if(cljs.core.truth_(or__3548__auto____3390)) {
          return or__3548__auto____3390
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3391 = o;
    if(cljs.core.truth_(and__3546__auto____3391)) {
      return o.cljs$core$IHash$_hash
    }else {
      return and__3546__auto____3391
    }
  }())) {
    return o.cljs$core$IHash$_hash(o)
  }else {
    return function() {
      var or__3548__auto____3392 = cljs.core._hash[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3392)) {
        return or__3548__auto____3392
      }else {
        var or__3548__auto____3393 = cljs.core._hash["_"];
        if(cljs.core.truth_(or__3548__auto____3393)) {
          return or__3548__auto____3393
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3394 = o;
    if(cljs.core.truth_(and__3546__auto____3394)) {
      return o.cljs$core$ISeqable$_seq
    }else {
      return and__3546__auto____3394
    }
  }())) {
    return o.cljs$core$ISeqable$_seq(o)
  }else {
    return function() {
      var or__3548__auto____3395 = cljs.core._seq[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3395)) {
        return or__3548__auto____3395
      }else {
        var or__3548__auto____3396 = cljs.core._seq["_"];
        if(cljs.core.truth_(or__3548__auto____3396)) {
          return or__3548__auto____3396
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISequential = {};
cljs.core.IRecord = {};
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3397 = o;
    if(cljs.core.truth_(and__3546__auto____3397)) {
      return o.cljs$core$IPrintable$_pr_seq
    }else {
      return and__3546__auto____3397
    }
  }())) {
    return o.cljs$core$IPrintable$_pr_seq(o, opts)
  }else {
    return function() {
      var or__3548__auto____3398 = cljs.core._pr_seq[goog.typeOf.call(null, o)];
      if(cljs.core.truth_(or__3548__auto____3398)) {
        return or__3548__auto____3398
      }else {
        var or__3548__auto____3399 = cljs.core._pr_seq["_"];
        if(cljs.core.truth_(or__3548__auto____3399)) {
          return or__3548__auto____3399
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3400 = d;
    if(cljs.core.truth_(and__3546__auto____3400)) {
      return d.cljs$core$IPending$_realized_QMARK_
    }else {
      return and__3546__auto____3400
    }
  }())) {
    return d.cljs$core$IPending$_realized_QMARK_(d)
  }else {
    return function() {
      var or__3548__auto____3401 = cljs.core._realized_QMARK_[goog.typeOf.call(null, d)];
      if(cljs.core.truth_(or__3548__auto____3401)) {
        return or__3548__auto____3401
      }else {
        var or__3548__auto____3402 = cljs.core._realized_QMARK_["_"];
        if(cljs.core.truth_(or__3548__auto____3402)) {
          return or__3548__auto____3402
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3403 = this$;
    if(cljs.core.truth_(and__3546__auto____3403)) {
      return this$.cljs$core$IWatchable$_notify_watches
    }else {
      return and__3546__auto____3403
    }
  }())) {
    return this$.cljs$core$IWatchable$_notify_watches(this$, oldval, newval)
  }else {
    return function() {
      var or__3548__auto____3404 = cljs.core._notify_watches[goog.typeOf.call(null, this$)];
      if(cljs.core.truth_(or__3548__auto____3404)) {
        return or__3548__auto____3404
      }else {
        var or__3548__auto____3405 = cljs.core._notify_watches["_"];
        if(cljs.core.truth_(or__3548__auto____3405)) {
          return or__3548__auto____3405
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3406 = this$;
    if(cljs.core.truth_(and__3546__auto____3406)) {
      return this$.cljs$core$IWatchable$_add_watch
    }else {
      return and__3546__auto____3406
    }
  }())) {
    return this$.cljs$core$IWatchable$_add_watch(this$, key, f)
  }else {
    return function() {
      var or__3548__auto____3407 = cljs.core._add_watch[goog.typeOf.call(null, this$)];
      if(cljs.core.truth_(or__3548__auto____3407)) {
        return or__3548__auto____3407
      }else {
        var or__3548__auto____3408 = cljs.core._add_watch["_"];
        if(cljs.core.truth_(or__3548__auto____3408)) {
          return or__3548__auto____3408
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3409 = this$;
    if(cljs.core.truth_(and__3546__auto____3409)) {
      return this$.cljs$core$IWatchable$_remove_watch
    }else {
      return and__3546__auto____3409
    }
  }())) {
    return this$.cljs$core$IWatchable$_remove_watch(this$, key)
  }else {
    return function() {
      var or__3548__auto____3410 = cljs.core._remove_watch[goog.typeOf.call(null, this$)];
      if(cljs.core.truth_(or__3548__auto____3410)) {
        return or__3548__auto____3410
      }else {
        var or__3548__auto____3411 = cljs.core._remove_watch["_"];
        if(cljs.core.truth_(or__3548__auto____3411)) {
          return or__3548__auto____3411
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
cljs.core._EQ_ = function _EQ_(x, y) {
  return cljs.core._equiv.call(null, x, y)
};
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x === null
};
cljs.core.type = function type(x) {
  return x.constructor
};
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__3412 = null;
  var G__3412__3413 = function(o, k) {
    return null
  };
  var G__3412__3414 = function(o, k, not_found) {
    return not_found
  };
  G__3412 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3412__3413.call(this, o, k);
      case 3:
        return G__3412__3414.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3412
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__3416 = null;
  var G__3416__3417 = function(_, f) {
    return f.call(null)
  };
  var G__3416__3418 = function(_, f, start) {
    return start
  };
  G__3416 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3416__3417.call(this, _, f);
      case 3:
        return G__3416__3418.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3416
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o === null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__3420 = null;
  var G__3420__3421 = function(_, n) {
    return null
  };
  var G__3420__3422 = function(_, n, not_found) {
    return not_found
  };
  G__3420 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3420__3421.call(this, _, n);
      case 3:
        return G__3420__3422.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3420
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv = function(o, other) {
  return o.toString() === other.toString()
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  return o === true ? 1 : 0
};
cljs.core.IHash["function"] = true;
cljs.core._hash["function"] = function(o) {
  return goog.getUid.call(null, o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__3430 = function(cicoll, f) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, 0, cljs.core._count.call(null, cicoll)))) {
      return f.call(null)
    }else {
      var val__3424 = cljs.core._nth.call(null, cicoll, 0);
      var n__3425 = 1;
      while(true) {
        if(cljs.core.truth_(n__3425 < cljs.core._count.call(null, cicoll))) {
          var G__3434 = f.call(null, val__3424, cljs.core._nth.call(null, cicoll, n__3425));
          var G__3435 = n__3425 + 1;
          val__3424 = G__3434;
          n__3425 = G__3435;
          continue
        }else {
          return val__3424
        }
        break
      }
    }
  };
  var ci_reduce__3431 = function(cicoll, f, val) {
    var val__3426 = val;
    var n__3427 = 0;
    while(true) {
      if(cljs.core.truth_(n__3427 < cljs.core._count.call(null, cicoll))) {
        var G__3436 = f.call(null, val__3426, cljs.core._nth.call(null, cicoll, n__3427));
        var G__3437 = n__3427 + 1;
        val__3426 = G__3436;
        n__3427 = G__3437;
        continue
      }else {
        return val__3426
      }
      break
    }
  };
  var ci_reduce__3432 = function(cicoll, f, val, idx) {
    var val__3428 = val;
    var n__3429 = idx;
    while(true) {
      if(cljs.core.truth_(n__3429 < cljs.core._count.call(null, cicoll))) {
        var G__3438 = f.call(null, val__3428, cljs.core._nth.call(null, cicoll, n__3429));
        var G__3439 = n__3429 + 1;
        val__3428 = G__3438;
        n__3429 = G__3439;
        continue
      }else {
        return val__3428
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__3430.call(this, cicoll, f);
      case 3:
        return ci_reduce__3431.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__3432.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return ci_reduce
}();
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i
};
cljs.core.IndexedSeq.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3440 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce = function() {
  var G__3453 = null;
  var G__3453__3454 = function(_, f) {
    var this__3441 = this;
    return cljs.core.ci_reduce.call(null, this__3441.a, f, this__3441.a[this__3441.i], this__3441.i + 1)
  };
  var G__3453__3455 = function(_, f, start) {
    var this__3442 = this;
    return cljs.core.ci_reduce.call(null, this__3442.a, f, start, this__3442.i)
  };
  G__3453 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3453__3454.call(this, _, f);
      case 3:
        return G__3453__3455.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3453
}();
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3443 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3444 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth = function() {
  var G__3457 = null;
  var G__3457__3458 = function(coll, n) {
    var this__3445 = this;
    var i__3446 = n + this__3445.i;
    if(cljs.core.truth_(i__3446 < this__3445.a.length)) {
      return this__3445.a[i__3446]
    }else {
      return null
    }
  };
  var G__3457__3459 = function(coll, n, not_found) {
    var this__3447 = this;
    var i__3448 = n + this__3447.i;
    if(cljs.core.truth_(i__3448 < this__3447.a.length)) {
      return this__3447.a[i__3448]
    }else {
      return not_found
    }
  };
  G__3457 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3457__3458.call(this, coll, n);
      case 3:
        return G__3457__3459.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3457
}();
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count = function(_) {
  var this__3449 = this;
  return this__3449.a.length - this__3449.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first = function(_) {
  var this__3450 = this;
  return this__3450.a[this__3450.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest = function(_) {
  var this__3451 = this;
  if(cljs.core.truth_(this__3451.i + 1 < this__3451.a.length)) {
    return new cljs.core.IndexedSeq(this__3451.a, this__3451.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq = function(this$) {
  var this__3452 = this;
  return this$
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function prim_seq(prim, i) {
  if(cljs.core.truth_(cljs.core._EQ_.call(null, 0, prim.length))) {
    return null
  }else {
    return new cljs.core.IndexedSeq(prim, i)
  }
};
cljs.core.array_seq = function array_seq(array, i) {
  return cljs.core.prim_seq.call(null, array, i)
};
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__3461 = null;
  var G__3461__3462 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__3461__3463 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__3461 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3461__3462.call(this, array, f);
      case 3:
        return G__3461__3463.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3461
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__3465 = null;
  var G__3465__3466 = function(array, k) {
    return array[k]
  };
  var G__3465__3467 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__3465 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3465__3466.call(this, array, k);
      case 3:
        return G__3465__3467.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3465
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__3469 = null;
  var G__3469__3470 = function(array, n) {
    if(cljs.core.truth_(n < array.length)) {
      return array[n]
    }else {
      return null
    }
  };
  var G__3469__3471 = function(array, n, not_found) {
    if(cljs.core.truth_(n < array.length)) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__3469 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3469__3470.call(this, array, n);
      case 3:
        return G__3469__3471.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3469
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.seq = function seq(coll) {
  if(cljs.core.truth_(coll)) {
    return cljs.core._seq.call(null, coll)
  }else {
    return null
  }
};
cljs.core.first = function first(coll) {
  var temp__3698__auto____3473 = cljs.core.seq.call(null, coll);
  if(cljs.core.truth_(temp__3698__auto____3473)) {
    var s__3474 = temp__3698__auto____3473;
    return cljs.core._first.call(null, s__3474)
  }else {
    return null
  }
};
cljs.core.rest = function rest(coll) {
  return cljs.core._rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.next = function next(coll) {
  if(cljs.core.truth_(coll)) {
    return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
  }else {
    return null
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s))) {
      var G__3475 = cljs.core.next.call(null, s);
      s = G__3475;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.ICounted["_"] = true;
cljs.core._count["_"] = function(x) {
  var s__3476 = cljs.core.seq.call(null, x);
  var n__3477 = 0;
  while(true) {
    if(cljs.core.truth_(s__3476)) {
      var G__3478 = cljs.core.next.call(null, s__3476);
      var G__3479 = n__3477 + 1;
      s__3476 = G__3478;
      n__3477 = G__3479;
      continue
    }else {
      return n__3477
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__3480 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3481 = function() {
    var G__3483__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__3484 = conj.call(null, coll, x);
          var G__3485 = cljs.core.first.call(null, xs);
          var G__3486 = cljs.core.next.call(null, xs);
          coll = G__3484;
          x = G__3485;
          xs = G__3486;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__3483 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3483__delegate.call(this, coll, x, xs)
    };
    G__3483.cljs$lang$maxFixedArity = 2;
    G__3483.cljs$lang$applyTo = function(arglist__3487) {
      var coll = cljs.core.first(arglist__3487);
      var x = cljs.core.first(cljs.core.next(arglist__3487));
      var xs = cljs.core.rest(cljs.core.next(arglist__3487));
      return G__3483__delegate.call(this, coll, x, xs)
    };
    return G__3483
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__3480.call(this, coll, x);
      default:
        return conj__3481.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3481.cljs$lang$applyTo;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
cljs.core.count = function count(coll) {
  return cljs.core._count.call(null, coll)
};
cljs.core.nth = function() {
  var nth = null;
  var nth__3488 = function(coll, n) {
    return cljs.core._nth.call(null, coll, Math.floor(n))
  };
  var nth__3489 = function(coll, n, not_found) {
    return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__3488.call(this, coll, n);
      case 3:
        return nth__3489.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__3491 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3492 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__3491.call(this, o, k);
      case 3:
        return get__3492.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3495 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__3496 = function() {
    var G__3498__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__3494 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__3499 = ret__3494;
          var G__3500 = cljs.core.first.call(null, kvs);
          var G__3501 = cljs.core.second.call(null, kvs);
          var G__3502 = cljs.core.nnext.call(null, kvs);
          coll = G__3499;
          k = G__3500;
          v = G__3501;
          kvs = G__3502;
          continue
        }else {
          return ret__3494
        }
        break
      }
    };
    var G__3498 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__3498__delegate.call(this, coll, k, v, kvs)
    };
    G__3498.cljs$lang$maxFixedArity = 3;
    G__3498.cljs$lang$applyTo = function(arglist__3503) {
      var coll = cljs.core.first(arglist__3503);
      var k = cljs.core.first(cljs.core.next(arglist__3503));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3503)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3503)));
      return G__3498__delegate.call(this, coll, k, v, kvs)
    };
    return G__3498
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3495.call(this, coll, k, v);
      default:
        return assoc__3496.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__3496.cljs$lang$applyTo;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__3505 = function(coll) {
    return coll
  };
  var dissoc__3506 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3507 = function() {
    var G__3509__delegate = function(coll, k, ks) {
      while(true) {
        var ret__3504 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__3510 = ret__3504;
          var G__3511 = cljs.core.first.call(null, ks);
          var G__3512 = cljs.core.next.call(null, ks);
          coll = G__3510;
          k = G__3511;
          ks = G__3512;
          continue
        }else {
          return ret__3504
        }
        break
      }
    };
    var G__3509 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3509__delegate.call(this, coll, k, ks)
    };
    G__3509.cljs$lang$maxFixedArity = 2;
    G__3509.cljs$lang$applyTo = function(arglist__3513) {
      var coll = cljs.core.first(arglist__3513);
      var k = cljs.core.first(cljs.core.next(arglist__3513));
      var ks = cljs.core.rest(cljs.core.next(arglist__3513));
      return G__3509__delegate.call(this, coll, k, ks)
    };
    return G__3509
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__3505.call(this, coll);
      case 2:
        return dissoc__3506.call(this, coll, k);
      default:
        return dissoc__3507.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3507.cljs$lang$applyTo;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(cljs.core.truth_(function() {
    var x__451__auto____3514 = o;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3515 = x__451__auto____3514;
      if(cljs.core.truth_(and__3546__auto____3515)) {
        var and__3546__auto____3516 = x__451__auto____3514.cljs$core$IMeta$;
        if(cljs.core.truth_(and__3546__auto____3516)) {
          return cljs.core.not.call(null, x__451__auto____3514.hasOwnProperty("cljs$core$IMeta$"))
        }else {
          return and__3546__auto____3516
        }
      }else {
        return and__3546__auto____3515
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, x__451__auto____3514)
    }
  }())) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__3518 = function(coll) {
    return coll
  };
  var disj__3519 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3520 = function() {
    var G__3522__delegate = function(coll, k, ks) {
      while(true) {
        var ret__3517 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__3523 = ret__3517;
          var G__3524 = cljs.core.first.call(null, ks);
          var G__3525 = cljs.core.next.call(null, ks);
          coll = G__3523;
          k = G__3524;
          ks = G__3525;
          continue
        }else {
          return ret__3517
        }
        break
      }
    };
    var G__3522 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3522__delegate.call(this, coll, k, ks)
    };
    G__3522.cljs$lang$maxFixedArity = 2;
    G__3522.cljs$lang$applyTo = function(arglist__3526) {
      var coll = cljs.core.first(arglist__3526);
      var k = cljs.core.first(cljs.core.next(arglist__3526));
      var ks = cljs.core.rest(cljs.core.next(arglist__3526));
      return G__3522__delegate.call(this, coll, k, ks)
    };
    return G__3522
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__3518.call(this, coll);
      case 2:
        return disj__3519.call(this, coll, k);
      default:
        return disj__3520.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3520.cljs$lang$applyTo;
  return disj
}();
cljs.core.hash = function hash(o) {
  return cljs.core._hash.call(null, o)
};
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(cljs.core.truth_(x === null)) {
    return false
  }else {
    var x__451__auto____3527 = x;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3528 = x__451__auto____3527;
      if(cljs.core.truth_(and__3546__auto____3528)) {
        var and__3546__auto____3529 = x__451__auto____3527.cljs$core$ICollection$;
        if(cljs.core.truth_(and__3546__auto____3529)) {
          return cljs.core.not.call(null, x__451__auto____3527.hasOwnProperty("cljs$core$ICollection$"))
        }else {
          return and__3546__auto____3529
        }
      }else {
        return and__3546__auto____3528
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, x__451__auto____3527)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(cljs.core.truth_(x === null)) {
    return false
  }else {
    var x__451__auto____3530 = x;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3531 = x__451__auto____3530;
      if(cljs.core.truth_(and__3546__auto____3531)) {
        var and__3546__auto____3532 = x__451__auto____3530.cljs$core$ISet$;
        if(cljs.core.truth_(and__3546__auto____3532)) {
          return cljs.core.not.call(null, x__451__auto____3530.hasOwnProperty("cljs$core$ISet$"))
        }else {
          return and__3546__auto____3532
        }
      }else {
        return and__3546__auto____3531
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, x__451__auto____3530)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var x__451__auto____3533 = x;
  if(cljs.core.truth_(function() {
    var and__3546__auto____3534 = x__451__auto____3533;
    if(cljs.core.truth_(and__3546__auto____3534)) {
      var and__3546__auto____3535 = x__451__auto____3533.cljs$core$IAssociative$;
      if(cljs.core.truth_(and__3546__auto____3535)) {
        return cljs.core.not.call(null, x__451__auto____3533.hasOwnProperty("cljs$core$IAssociative$"))
      }else {
        return and__3546__auto____3535
      }
    }else {
      return and__3546__auto____3534
    }
  }())) {
    return true
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, x__451__auto____3533)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var x__451__auto____3536 = x;
  if(cljs.core.truth_(function() {
    var and__3546__auto____3537 = x__451__auto____3536;
    if(cljs.core.truth_(and__3546__auto____3537)) {
      var and__3546__auto____3538 = x__451__auto____3536.cljs$core$ISequential$;
      if(cljs.core.truth_(and__3546__auto____3538)) {
        return cljs.core.not.call(null, x__451__auto____3536.hasOwnProperty("cljs$core$ISequential$"))
      }else {
        return and__3546__auto____3538
      }
    }else {
      return and__3546__auto____3537
    }
  }())) {
    return true
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, x__451__auto____3536)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var x__451__auto____3539 = x;
  if(cljs.core.truth_(function() {
    var and__3546__auto____3540 = x__451__auto____3539;
    if(cljs.core.truth_(and__3546__auto____3540)) {
      var and__3546__auto____3541 = x__451__auto____3539.cljs$core$ICounted$;
      if(cljs.core.truth_(and__3546__auto____3541)) {
        return cljs.core.not.call(null, x__451__auto____3539.hasOwnProperty("cljs$core$ICounted$"))
      }else {
        return and__3546__auto____3541
      }
    }else {
      return and__3546__auto____3540
    }
  }())) {
    return true
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, x__451__auto____3539)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(cljs.core.truth_(x === null)) {
    return false
  }else {
    var x__451__auto____3542 = x;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3543 = x__451__auto____3542;
      if(cljs.core.truth_(and__3546__auto____3543)) {
        var and__3546__auto____3544 = x__451__auto____3542.cljs$core$IMap$;
        if(cljs.core.truth_(and__3546__auto____3544)) {
          return cljs.core.not.call(null, x__451__auto____3542.hasOwnProperty("cljs$core$IMap$"))
        }else {
          return and__3546__auto____3544
        }
      }else {
        return and__3546__auto____3543
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, x__451__auto____3542)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var x__451__auto____3545 = x;
  if(cljs.core.truth_(function() {
    var and__3546__auto____3546 = x__451__auto____3545;
    if(cljs.core.truth_(and__3546__auto____3546)) {
      var and__3546__auto____3547 = x__451__auto____3545.cljs$core$IVector$;
      if(cljs.core.truth_(and__3546__auto____3547)) {
        return cljs.core.not.call(null, x__451__auto____3545.hasOwnProperty("cljs$core$IVector$"))
      }else {
        return and__3546__auto____3547
      }
    }else {
      return and__3546__auto____3546
    }
  }())) {
    return true
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, x__451__auto____3545)
  }
};
cljs.core.js_obj = function js_obj() {
  return{}
};
cljs.core.js_keys = function js_keys(obj) {
  var keys__3548 = [];
  goog.object.forEach.call(null, obj, function(val, key, obj) {
    return keys__3548.push(key)
  });
  return keys__3548
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.lookup_sentinel = cljs.core.js_obj.call(null);
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o != null && (o instanceof t || o.constructor === t || t === Object)
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(cljs.core.truth_(s === null)) {
    return false
  }else {
    var x__451__auto____3549 = s;
    if(cljs.core.truth_(function() {
      var and__3546__auto____3550 = x__451__auto____3549;
      if(cljs.core.truth_(and__3546__auto____3550)) {
        var and__3546__auto____3551 = x__451__auto____3549.cljs$core$ISeq$;
        if(cljs.core.truth_(and__3546__auto____3551)) {
          return cljs.core.not.call(null, x__451__auto____3549.hasOwnProperty("cljs$core$ISeq$"))
        }else {
          return and__3546__auto____3551
        }
      }else {
        return and__3546__auto____3550
      }
    }())) {
      return true
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, x__451__auto____3549)
    }
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3546__auto____3552 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____3552)) {
    return cljs.core.not.call(null, function() {
      var or__3548__auto____3553 = cljs.core._EQ_.call(null, x.charAt(0), "\ufdd0");
      if(cljs.core.truth_(or__3548__auto____3553)) {
        return or__3548__auto____3553
      }else {
        return cljs.core._EQ_.call(null, x.charAt(0), "\ufdd1")
      }
    }())
  }else {
    return and__3546__auto____3552
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3546__auto____3554 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____3554)) {
    return cljs.core._EQ_.call(null, x.charAt(0), "\ufdd0")
  }else {
    return and__3546__auto____3554
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3546__auto____3555 = goog.isString.call(null, x);
  if(cljs.core.truth_(and__3546__auto____3555)) {
    return cljs.core._EQ_.call(null, x.charAt(0), "\ufdd1")
  }else {
    return and__3546__auto____3555
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber.call(null, n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction.call(null, f)
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3546__auto____3556 = cljs.core.number_QMARK_.call(null, n);
  if(cljs.core.truth_(and__3546__auto____3556)) {
    return n == n.toFixed()
  }else {
    return and__3546__auto____3556
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core.truth_(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____3557 = coll;
    if(cljs.core.truth_(and__3546__auto____3557)) {
      var and__3546__auto____3558 = cljs.core.associative_QMARK_.call(null, coll);
      if(cljs.core.truth_(and__3546__auto____3558)) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3546__auto____3558
      }
    }else {
      return and__3546__auto____3557
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)])
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___3563 = function(x) {
    return true
  };
  var distinct_QMARK___3564 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var distinct_QMARK___3565 = function() {
    var G__3567__delegate = function(x, y, more) {
      if(cljs.core.truth_(cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y)))) {
        var s__3559 = cljs.core.set([y, x]);
        var xs__3560 = more;
        while(true) {
          var x__3561 = cljs.core.first.call(null, xs__3560);
          var etc__3562 = cljs.core.next.call(null, xs__3560);
          if(cljs.core.truth_(xs__3560)) {
            if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, s__3559, x__3561))) {
              return false
            }else {
              var G__3568 = cljs.core.conj.call(null, s__3559, x__3561);
              var G__3569 = etc__3562;
              s__3559 = G__3568;
              xs__3560 = G__3569;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__3567 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3567__delegate.call(this, x, y, more)
    };
    G__3567.cljs$lang$maxFixedArity = 2;
    G__3567.cljs$lang$applyTo = function(arglist__3570) {
      var x = cljs.core.first(arglist__3570);
      var y = cljs.core.first(cljs.core.next(arglist__3570));
      var more = cljs.core.rest(cljs.core.next(arglist__3570));
      return G__3567__delegate.call(this, x, y, more)
    };
    return G__3567
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___3563.call(this, x);
      case 2:
        return distinct_QMARK___3564.call(this, x, y);
      default:
        return distinct_QMARK___3565.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3565.cljs$lang$applyTo;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  return goog.array.defaultCompare.call(null, x, y)
};
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core.truth_(cljs.core._EQ_.call(null, f, cljs.core.compare))) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__3571 = f.call(null, x, y);
      if(cljs.core.truth_(cljs.core.number_QMARK_.call(null, r__3571))) {
        return r__3571
      }else {
        if(cljs.core.truth_(r__3571)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
cljs.core.sort = function() {
  var sort = null;
  var sort__3573 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__3574 = function(comp, coll) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var a__3572 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort.call(null, a__3572, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__3572)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__3573.call(this, comp);
      case 2:
        return sort__3574.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__3576 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3577 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__3576.call(this, keyfn, comp);
      case 3:
        return sort_by__3577.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return sort_by
}();
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__3579 = function(f, coll) {
    return cljs.core._reduce.call(null, coll, f)
  };
  var reduce__3580 = function(f, val, coll) {
    return cljs.core._reduce.call(null, coll, f, val)
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__3579.call(this, f, val);
      case 3:
        return reduce__3580.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return reduce
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__3586 = function(f, coll) {
    var temp__3695__auto____3582 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3695__auto____3582)) {
      var s__3583 = temp__3695__auto____3582;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__3583), cljs.core.next.call(null, s__3583))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3587 = function(f, val, coll) {
    var val__3584 = val;
    var coll__3585 = cljs.core.seq.call(null, coll);
    while(true) {
      if(cljs.core.truth_(coll__3585)) {
        var G__3589 = f.call(null, val__3584, cljs.core.first.call(null, coll__3585));
        var G__3590 = cljs.core.next.call(null, coll__3585);
        val__3584 = G__3589;
        coll__3585 = G__3590;
        continue
      }else {
        return val__3584
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__3586.call(this, f, val);
      case 3:
        return seq_reduce__3587.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return seq_reduce
}();
cljs.core.IReduce["_"] = true;
cljs.core._reduce["_"] = function() {
  var G__3591 = null;
  var G__3591__3592 = function(coll, f) {
    return cljs.core.seq_reduce.call(null, f, coll)
  };
  var G__3591__3593 = function(coll, f, start) {
    return cljs.core.seq_reduce.call(null, f, start, coll)
  };
  G__3591 = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3591__3592.call(this, coll, f);
      case 3:
        return G__3591__3593.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3591
}();
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___3595 = function() {
    return 0
  };
  var _PLUS___3596 = function(x) {
    return x
  };
  var _PLUS___3597 = function(x, y) {
    return x + y
  };
  var _PLUS___3598 = function() {
    var G__3600__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__3600 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3600__delegate.call(this, x, y, more)
    };
    G__3600.cljs$lang$maxFixedArity = 2;
    G__3600.cljs$lang$applyTo = function(arglist__3601) {
      var x = cljs.core.first(arglist__3601);
      var y = cljs.core.first(cljs.core.next(arglist__3601));
      var more = cljs.core.rest(cljs.core.next(arglist__3601));
      return G__3600__delegate.call(this, x, y, more)
    };
    return G__3600
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___3595.call(this);
      case 1:
        return _PLUS___3596.call(this, x);
      case 2:
        return _PLUS___3597.call(this, x, y);
      default:
        return _PLUS___3598.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3598.cljs$lang$applyTo;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___3602 = function(x) {
    return-x
  };
  var ___3603 = function(x, y) {
    return x - y
  };
  var ___3604 = function() {
    var G__3606__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__3606 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3606__delegate.call(this, x, y, more)
    };
    G__3606.cljs$lang$maxFixedArity = 2;
    G__3606.cljs$lang$applyTo = function(arglist__3607) {
      var x = cljs.core.first(arglist__3607);
      var y = cljs.core.first(cljs.core.next(arglist__3607));
      var more = cljs.core.rest(cljs.core.next(arglist__3607));
      return G__3606__delegate.call(this, x, y, more)
    };
    return G__3606
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___3602.call(this, x);
      case 2:
        return ___3603.call(this, x, y);
      default:
        return ___3604.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3604.cljs$lang$applyTo;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___3608 = function() {
    return 1
  };
  var _STAR___3609 = function(x) {
    return x
  };
  var _STAR___3610 = function(x, y) {
    return x * y
  };
  var _STAR___3611 = function() {
    var G__3613__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__3613 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3613__delegate.call(this, x, y, more)
    };
    G__3613.cljs$lang$maxFixedArity = 2;
    G__3613.cljs$lang$applyTo = function(arglist__3614) {
      var x = cljs.core.first(arglist__3614);
      var y = cljs.core.first(cljs.core.next(arglist__3614));
      var more = cljs.core.rest(cljs.core.next(arglist__3614));
      return G__3613__delegate.call(this, x, y, more)
    };
    return G__3613
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___3608.call(this);
      case 1:
        return _STAR___3609.call(this, x);
      case 2:
        return _STAR___3610.call(this, x, y);
      default:
        return _STAR___3611.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3611.cljs$lang$applyTo;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___3615 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___3616 = function(x, y) {
    return x / y
  };
  var _SLASH___3617 = function() {
    var G__3619__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__3619 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3619__delegate.call(this, x, y, more)
    };
    G__3619.cljs$lang$maxFixedArity = 2;
    G__3619.cljs$lang$applyTo = function(arglist__3620) {
      var x = cljs.core.first(arglist__3620);
      var y = cljs.core.first(cljs.core.next(arglist__3620));
      var more = cljs.core.rest(cljs.core.next(arglist__3620));
      return G__3619__delegate.call(this, x, y, more)
    };
    return G__3619
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___3615.call(this, x);
      case 2:
        return _SLASH___3616.call(this, x, y);
      default:
        return _SLASH___3617.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3617.cljs$lang$applyTo;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___3621 = function(x) {
    return true
  };
  var _LT___3622 = function(x, y) {
    return x < y
  };
  var _LT___3623 = function() {
    var G__3625__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(x < y)) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3626 = y;
            var G__3627 = cljs.core.first.call(null, more);
            var G__3628 = cljs.core.next.call(null, more);
            x = G__3626;
            y = G__3627;
            more = G__3628;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3625 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3625__delegate.call(this, x, y, more)
    };
    G__3625.cljs$lang$maxFixedArity = 2;
    G__3625.cljs$lang$applyTo = function(arglist__3629) {
      var x = cljs.core.first(arglist__3629);
      var y = cljs.core.first(cljs.core.next(arglist__3629));
      var more = cljs.core.rest(cljs.core.next(arglist__3629));
      return G__3625__delegate.call(this, x, y, more)
    };
    return G__3625
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___3621.call(this, x);
      case 2:
        return _LT___3622.call(this, x, y);
      default:
        return _LT___3623.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3623.cljs$lang$applyTo;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___3630 = function(x) {
    return true
  };
  var _LT__EQ___3631 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3632 = function() {
    var G__3634__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(x <= y)) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3635 = y;
            var G__3636 = cljs.core.first.call(null, more);
            var G__3637 = cljs.core.next.call(null, more);
            x = G__3635;
            y = G__3636;
            more = G__3637;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3634 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3634__delegate.call(this, x, y, more)
    };
    G__3634.cljs$lang$maxFixedArity = 2;
    G__3634.cljs$lang$applyTo = function(arglist__3638) {
      var x = cljs.core.first(arglist__3638);
      var y = cljs.core.first(cljs.core.next(arglist__3638));
      var more = cljs.core.rest(cljs.core.next(arglist__3638));
      return G__3634__delegate.call(this, x, y, more)
    };
    return G__3634
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___3630.call(this, x);
      case 2:
        return _LT__EQ___3631.call(this, x, y);
      default:
        return _LT__EQ___3632.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3632.cljs$lang$applyTo;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___3639 = function(x) {
    return true
  };
  var _GT___3640 = function(x, y) {
    return x > y
  };
  var _GT___3641 = function() {
    var G__3643__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(x > y)) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3644 = y;
            var G__3645 = cljs.core.first.call(null, more);
            var G__3646 = cljs.core.next.call(null, more);
            x = G__3644;
            y = G__3645;
            more = G__3646;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3643 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3643__delegate.call(this, x, y, more)
    };
    G__3643.cljs$lang$maxFixedArity = 2;
    G__3643.cljs$lang$applyTo = function(arglist__3647) {
      var x = cljs.core.first(arglist__3647);
      var y = cljs.core.first(cljs.core.next(arglist__3647));
      var more = cljs.core.rest(cljs.core.next(arglist__3647));
      return G__3643__delegate.call(this, x, y, more)
    };
    return G__3643
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___3639.call(this, x);
      case 2:
        return _GT___3640.call(this, x, y);
      default:
        return _GT___3641.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3641.cljs$lang$applyTo;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___3648 = function(x) {
    return true
  };
  var _GT__EQ___3649 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3650 = function() {
    var G__3652__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(x >= y)) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3653 = y;
            var G__3654 = cljs.core.first.call(null, more);
            var G__3655 = cljs.core.next.call(null, more);
            x = G__3653;
            y = G__3654;
            more = G__3655;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3652 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3652__delegate.call(this, x, y, more)
    };
    G__3652.cljs$lang$maxFixedArity = 2;
    G__3652.cljs$lang$applyTo = function(arglist__3656) {
      var x = cljs.core.first(arglist__3656);
      var y = cljs.core.first(cljs.core.next(arglist__3656));
      var more = cljs.core.rest(cljs.core.next(arglist__3656));
      return G__3652__delegate.call(this, x, y, more)
    };
    return G__3652
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___3648.call(this, x);
      case 2:
        return _GT__EQ___3649.call(this, x, y);
      default:
        return _GT__EQ___3650.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3650.cljs$lang$applyTo;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__3657 = function(x) {
    return x
  };
  var max__3658 = function(x, y) {
    return x > y ? x : y
  };
  var max__3659 = function() {
    var G__3661__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__3661 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3661__delegate.call(this, x, y, more)
    };
    G__3661.cljs$lang$maxFixedArity = 2;
    G__3661.cljs$lang$applyTo = function(arglist__3662) {
      var x = cljs.core.first(arglist__3662);
      var y = cljs.core.first(cljs.core.next(arglist__3662));
      var more = cljs.core.rest(cljs.core.next(arglist__3662));
      return G__3661__delegate.call(this, x, y, more)
    };
    return G__3661
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__3657.call(this, x);
      case 2:
        return max__3658.call(this, x, y);
      default:
        return max__3659.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3659.cljs$lang$applyTo;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__3663 = function(x) {
    return x
  };
  var min__3664 = function(x, y) {
    return x < y ? x : y
  };
  var min__3665 = function() {
    var G__3667__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__3667 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3667__delegate.call(this, x, y, more)
    };
    G__3667.cljs$lang$maxFixedArity = 2;
    G__3667.cljs$lang$applyTo = function(arglist__3668) {
      var x = cljs.core.first(arglist__3668);
      var y = cljs.core.first(cljs.core.next(arglist__3668));
      var more = cljs.core.rest(cljs.core.next(arglist__3668));
      return G__3667__delegate.call(this, x, y, more)
    };
    return G__3667
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__3663.call(this, x);
      case 2:
        return min__3664.call(this, x, y);
      default:
        return min__3665.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3665.cljs$lang$applyTo;
  return min
}();
cljs.core.fix = function fix(q) {
  if(cljs.core.truth_(q >= 0)) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__3669 = n % d;
  return cljs.core.fix.call(null, (n - rem__3669) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__3670 = cljs.core.quot.call(null, n, d);
  return n - d * q__3670
};
cljs.core.rand = function() {
  var rand = null;
  var rand__3671 = function() {
    return Math.random.call(null)
  };
  var rand__3672 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__3671.call(this);
      case 1:
        return rand__3672.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___3674 = function(x) {
    return true
  };
  var _EQ__EQ___3675 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3676 = function() {
    var G__3678__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.truth_(cljs.core.next.call(null, more))) {
            var G__3679 = y;
            var G__3680 = cljs.core.first.call(null, more);
            var G__3681 = cljs.core.next.call(null, more);
            x = G__3679;
            y = G__3680;
            more = G__3681;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__3678 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3678__delegate.call(this, x, y, more)
    };
    G__3678.cljs$lang$maxFixedArity = 2;
    G__3678.cljs$lang$applyTo = function(arglist__3682) {
      var x = cljs.core.first(arglist__3682);
      var y = cljs.core.first(cljs.core.next(arglist__3682));
      var more = cljs.core.rest(cljs.core.next(arglist__3682));
      return G__3678__delegate.call(this, x, y, more)
    };
    return G__3678
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___3674.call(this, x);
      case 2:
        return _EQ__EQ___3675.call(this, x, y);
      default:
        return _EQ__EQ___3676.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3676.cljs$lang$applyTo;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__3683 = n;
  var xs__3684 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3685 = xs__3684;
      if(cljs.core.truth_(and__3546__auto____3685)) {
        return n__3683 > 0
      }else {
        return and__3546__auto____3685
      }
    }())) {
      var G__3686 = n__3683 - 1;
      var G__3687 = cljs.core.next.call(null, xs__3684);
      n__3683 = G__3686;
      xs__3684 = G__3687;
      continue
    }else {
      return xs__3684
    }
    break
  }
};
cljs.core.IIndexed["_"] = true;
cljs.core._nth["_"] = function() {
  var G__3692 = null;
  var G__3692__3693 = function(coll, n) {
    var temp__3695__auto____3688 = cljs.core.nthnext.call(null, coll, n);
    if(cljs.core.truth_(temp__3695__auto____3688)) {
      var xs__3689 = temp__3695__auto____3688;
      return cljs.core.first.call(null, xs__3689)
    }else {
      throw new Error("Index out of bounds");
    }
  };
  var G__3692__3694 = function(coll, n, not_found) {
    var temp__3695__auto____3690 = cljs.core.nthnext.call(null, coll, n);
    if(cljs.core.truth_(temp__3695__auto____3690)) {
      var xs__3691 = temp__3695__auto____3690;
      return cljs.core.first.call(null, xs__3691)
    }else {
      return not_found
    }
  };
  G__3692 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3692__3693.call(this, coll, n);
      case 3:
        return G__3692__3694.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3692
}();
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___3696 = function() {
    return""
  };
  var str_STAR___3697 = function(x) {
    if(cljs.core.truth_(x === null)) {
      return""
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___3698 = function() {
    var G__3700__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__3701 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__3702 = cljs.core.next.call(null, more);
            sb = G__3701;
            more = G__3702;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__3700 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__3700__delegate.call(this, x, ys)
    };
    G__3700.cljs$lang$maxFixedArity = 1;
    G__3700.cljs$lang$applyTo = function(arglist__3703) {
      var x = cljs.core.first(arglist__3703);
      var ys = cljs.core.rest(arglist__3703);
      return G__3700__delegate.call(this, x, ys)
    };
    return G__3700
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___3696.call(this);
      case 1:
        return str_STAR___3697.call(this, x);
      default:
        return str_STAR___3698.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___3698.cljs$lang$applyTo;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__3704 = function() {
    return""
  };
  var str__3705 = function(x) {
    if(cljs.core.truth_(cljs.core.symbol_QMARK_.call(null, x))) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, x))) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(cljs.core.truth_(x === null)) {
          return""
        }else {
          if(cljs.core.truth_("\ufdd0'else")) {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__3706 = function() {
    var G__3708__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__3709 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__3710 = cljs.core.next.call(null, more);
            sb = G__3709;
            more = G__3710;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__3708 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__3708__delegate.call(this, x, ys)
    };
    G__3708.cljs$lang$maxFixedArity = 1;
    G__3708.cljs$lang$applyTo = function(arglist__3711) {
      var x = cljs.core.first(arglist__3711);
      var ys = cljs.core.rest(arglist__3711);
      return G__3708__delegate.call(this, x, ys)
    };
    return G__3708
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__3704.call(this);
      case 1:
        return str__3705.call(this, x);
      default:
        return str__3706.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__3706.cljs$lang$applyTo;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__3712 = function(s, start) {
    return s.substring(start)
  };
  var subs__3713 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__3712.call(this, s, start);
      case 3:
        return subs__3713.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return subs
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__3715 = function(name) {
    if(cljs.core.truth_(cljs.core.symbol_QMARK_.call(null, name))) {
      name
    }else {
      if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, name))) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__3716 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__3715.call(this, ns);
      case 2:
        return symbol__3716.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__3718 = function(name) {
    if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, name))) {
      return name
    }else {
      if(cljs.core.truth_(cljs.core.symbol_QMARK_.call(null, name))) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if(cljs.core.truth_("\ufdd0'else")) {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__3719 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__3718.call(this, ns);
      case 2:
        return keyword__3719.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.truth_(cljs.core.sequential_QMARK_.call(null, y)) ? function() {
    var xs__3721 = cljs.core.seq.call(null, x);
    var ys__3722 = cljs.core.seq.call(null, y);
    while(true) {
      if(cljs.core.truth_(xs__3721 === null)) {
        return ys__3722 === null
      }else {
        if(cljs.core.truth_(ys__3722 === null)) {
          return false
        }else {
          if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__3721), cljs.core.first.call(null, ys__3722)))) {
            var G__3723 = cljs.core.next.call(null, xs__3721);
            var G__3724 = cljs.core.next.call(null, ys__3722);
            xs__3721 = G__3723;
            ys__3722 = G__3724;
            continue
          }else {
            if(cljs.core.truth_("\ufdd0'else")) {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__3725_SHARP_, p2__3726_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__3725_SHARP_, cljs.core.hash.call(null, p2__3726_SHARP_))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll)), cljs.core.next.call(null, coll))
};
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__3727__3728 = cljs.core.seq.call(null, fn_map);
  if(cljs.core.truth_(G__3727__3728)) {
    var G__3730__3732 = cljs.core.first.call(null, G__3727__3728);
    var vec__3731__3733 = G__3730__3732;
    var key_name__3734 = cljs.core.nth.call(null, vec__3731__3733, 0, null);
    var f__3735 = cljs.core.nth.call(null, vec__3731__3733, 1, null);
    var G__3727__3736 = G__3727__3728;
    var G__3730__3737 = G__3730__3732;
    var G__3727__3738 = G__3727__3736;
    while(true) {
      var vec__3739__3740 = G__3730__3737;
      var key_name__3741 = cljs.core.nth.call(null, vec__3739__3740, 0, null);
      var f__3742 = cljs.core.nth.call(null, vec__3739__3740, 1, null);
      var G__3727__3743 = G__3727__3738;
      var str_name__3744 = cljs.core.name.call(null, key_name__3741);
      obj[str_name__3744] = f__3742;
      var temp__3698__auto____3745 = cljs.core.next.call(null, G__3727__3743);
      if(cljs.core.truth_(temp__3698__auto____3745)) {
        var G__3727__3746 = temp__3698__auto____3745;
        var G__3747 = cljs.core.first.call(null, G__3727__3746);
        var G__3748 = G__3727__3746;
        G__3730__3737 = G__3747;
        G__3727__3738 = G__3748;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count
};
cljs.core.List.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.List")
};
cljs.core.List.prototype.cljs$core$IHash$ = true;
cljs.core.List.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3749 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISequential$ = true;
cljs.core.List.prototype.cljs$core$ICollection$ = true;
cljs.core.List.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3750 = this;
  return new cljs.core.List(this__3750.meta, o, coll, this__3750.count + 1)
};
cljs.core.List.prototype.cljs$core$ISeqable$ = true;
cljs.core.List.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__3751 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$ = true;
cljs.core.List.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__3752 = this;
  return this__3752.count
};
cljs.core.List.prototype.cljs$core$IStack$ = true;
cljs.core.List.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__3753 = this;
  return this__3753.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__3754 = this;
  return cljs.core._rest.call(null, coll)
};
cljs.core.List.prototype.cljs$core$ISeq$ = true;
cljs.core.List.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__3755 = this;
  return this__3755.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__3756 = this;
  return this__3756.rest
};
cljs.core.List.prototype.cljs$core$IEquiv$ = true;
cljs.core.List.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3757 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$ = true;
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__3758 = this;
  return new cljs.core.List(meta, this__3758.first, this__3758.rest, this__3758.count)
};
cljs.core.List.prototype.cljs$core$IMeta$ = true;
cljs.core.List.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__3759 = this;
  return this__3759.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__3760 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta
};
cljs.core.EmptyList.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$ = true;
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3761 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.EmptyList.prototype.cljs$core$ISequential$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3762 = this;
  return new cljs.core.List(this__3762.meta, o, null, 1)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__3763 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$ = true;
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__3764 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$ = true;
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__3765 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__3766 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$ = true;
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__3767 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__3768 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3769 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__3770 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$ = true;
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__3771 = this;
  return this__3771.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__3772 = this;
  return coll
};
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reverse = function reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
cljs.core.list = function() {
  var list__delegate = function(items) {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items))
  };
  var list = function(var_args) {
    var items = null;
    if(goog.isDef(var_args)) {
      items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return list__delegate.call(this, items)
  };
  list.cljs$lang$maxFixedArity = 0;
  list.cljs$lang$applyTo = function(arglist__3773) {
    var items = cljs.core.seq(arglist__3773);
    return list__delegate.call(this, items)
  };
  return list
}();
cljs.core.Cons = function(meta, first, rest) {
  this.meta = meta;
  this.first = first;
  this.rest = rest
};
cljs.core.Cons.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Cons")
};
cljs.core.Cons.prototype.cljs$core$ISeqable$ = true;
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__3774 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$IHash$ = true;
cljs.core.Cons.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3775 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.Cons.prototype.cljs$core$IEquiv$ = true;
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3776 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$ISequential$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__3777 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__3777.meta)
};
cljs.core.Cons.prototype.cljs$core$ICollection$ = true;
cljs.core.Cons.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3778 = this;
  return new cljs.core.Cons(null, o, coll)
};
cljs.core.Cons.prototype.cljs$core$ISeq$ = true;
cljs.core.Cons.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__3779 = this;
  return this__3779.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__3780 = this;
  if(cljs.core.truth_(this__3780.rest === null)) {
    return cljs.core.List.EMPTY
  }else {
    return this__3780.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__3781 = this;
  return this__3781.meta
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__3782 = this;
  return new cljs.core.Cons(meta, this__3782.first, this__3782.rest)
};
cljs.core.Cons;
cljs.core.cons = function cons(x, seq) {
  return new cljs.core.Cons(null, x, seq)
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__3783 = null;
  var G__3783__3784 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__3783__3785 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__3783 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__3783__3784.call(this, string, f);
      case 3:
        return G__3783__3785.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3783
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__3787 = null;
  var G__3787__3788 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__3787__3789 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__3787 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3787__3788.call(this, string, k);
      case 3:
        return G__3787__3789.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3787
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__3791 = null;
  var G__3791__3792 = function(string, n) {
    if(cljs.core.truth_(n < cljs.core._count.call(null, string))) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__3791__3793 = function(string, n, not_found) {
    if(cljs.core.truth_(n < cljs.core._count.call(null, string))) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__3791 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3791__3792.call(this, string, n);
      case 3:
        return G__3791__3793.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3791
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode.call(null, o)
};
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__3801 = null;
  var G__3801__3802 = function(tsym3795, coll) {
    var tsym3795__3797 = this;
    var this$__3798 = tsym3795__3797;
    return cljs.core.get.call(null, coll, this$__3798.toString())
  };
  var G__3801__3803 = function(tsym3796, coll, not_found) {
    var tsym3796__3799 = this;
    var this$__3800 = tsym3796__3799;
    return cljs.core.get.call(null, coll, this$__3800.toString(), not_found)
  };
  G__3801 = function(tsym3796, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__3801__3802.call(this, tsym3796, coll);
      case 3:
        return G__3801__3803.call(this, tsym3796, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__3801
}();
String["prototype"]["apply"] = function(s, args) {
  if(cljs.core.truth_(cljs.core.count.call(null, args) < 2)) {
    return cljs.core.get.call(null, args[0], s)
  }else {
    return cljs.core.get.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__3805 = lazy_seq.x;
  if(cljs.core.truth_(lazy_seq.realized)) {
    return x__3805
  }else {
    lazy_seq.x = x__3805.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x) {
  this.meta = meta;
  this.realized = realized;
  this.x = x
};
cljs.core.LazySeq.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__3806 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IHash$ = true;
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__3807 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__3808 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$ISequential$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__3809 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__3809.meta)
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$ = true;
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__3810 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$ = true;
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__3811 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__3812 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__3813 = this;
  return this__3813.meta
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__3814 = this;
  return new cljs.core.LazySeq(meta, this__3814.realized, this__3814.x)
};
cljs.core.LazySeq;
cljs.core.to_array = function to_array(s) {
  var ary__3815 = [];
  var s__3816 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, s__3816))) {
      ary__3815.push(cljs.core.first.call(null, s__3816));
      var G__3817 = cljs.core.next.call(null, s__3816);
      s__3816 = G__3817;
      continue
    }else {
      return ary__3815
    }
    break
  }
};
cljs.core.bounded_count = function bounded_count(s, n) {
  var s__3818 = s;
  var i__3819 = n;
  var sum__3820 = 0;
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____3821 = i__3819 > 0;
      if(cljs.core.truth_(and__3546__auto____3821)) {
        return cljs.core.seq.call(null, s__3818)
      }else {
        return and__3546__auto____3821
      }
    }())) {
      var G__3822 = cljs.core.next.call(null, s__3818);
      var G__3823 = i__3819 - 1;
      var G__3824 = sum__3820 + 1;
      s__3818 = G__3822;
      i__3819 = G__3823;
      sum__3820 = G__3824;
      continue
    }else {
      return sum__3820
    }
    break
  }
};
cljs.core.spread = function spread(arglist) {
  if(cljs.core.truth_(arglist === null)) {
    return null
  }else {
    if(cljs.core.truth_(cljs.core.next.call(null, arglist) === null)) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__3828 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    })
  };
  var concat__3829 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    })
  };
  var concat__3830 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__3825 = cljs.core.seq.call(null, x);
      if(cljs.core.truth_(s__3825)) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__3825), concat.call(null, cljs.core.rest.call(null, s__3825), y))
      }else {
        return y
      }
    })
  };
  var concat__3831 = function() {
    var G__3833__delegate = function(x, y, zs) {
      var cat__3827 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__3826 = cljs.core.seq.call(null, xys);
          if(cljs.core.truth_(xys__3826)) {
            return cljs.core.cons.call(null, cljs.core.first.call(null, xys__3826), cat.call(null, cljs.core.rest.call(null, xys__3826), zs))
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        })
      };
      return cat__3827.call(null, concat.call(null, x, y), zs)
    };
    var G__3833 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3833__delegate.call(this, x, y, zs)
    };
    G__3833.cljs$lang$maxFixedArity = 2;
    G__3833.cljs$lang$applyTo = function(arglist__3834) {
      var x = cljs.core.first(arglist__3834);
      var y = cljs.core.first(cljs.core.next(arglist__3834));
      var zs = cljs.core.rest(cljs.core.next(arglist__3834));
      return G__3833__delegate.call(this, x, y, zs)
    };
    return G__3833
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__3828.call(this);
      case 1:
        return concat__3829.call(this, x);
      case 2:
        return concat__3830.call(this, x, y);
      default:
        return concat__3831.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3831.cljs$lang$applyTo;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___3835 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___3836 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3837 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___3838 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___3839 = function() {
    var G__3841__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__3841 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__3841__delegate.call(this, a, b, c, d, more)
    };
    G__3841.cljs$lang$maxFixedArity = 4;
    G__3841.cljs$lang$applyTo = function(arglist__3842) {
      var a = cljs.core.first(arglist__3842);
      var b = cljs.core.first(cljs.core.next(arglist__3842));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3842)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3842))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3842))));
      return G__3841__delegate.call(this, a, b, c, d, more)
    };
    return G__3841
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___3835.call(this, a);
      case 2:
        return list_STAR___3836.call(this, a, b);
      case 3:
        return list_STAR___3837.call(this, a, b, c);
      case 4:
        return list_STAR___3838.call(this, a, b, c, d);
      default:
        return list_STAR___3839.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___3839.cljs$lang$applyTo;
  return list_STAR_
}();
cljs.core.apply = function() {
  var apply = null;
  var apply__3852 = function(f, args) {
    var fixed_arity__3843 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      if(cljs.core.truth_(cljs.core.bounded_count.call(null, args, fixed_arity__3843 + 1) <= fixed_arity__3843)) {
        return f.apply(f, cljs.core.to_array.call(null, args))
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3853 = function(f, x, args) {
    var arglist__3844 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__3845 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      if(cljs.core.truth_(cljs.core.bounded_count.call(null, arglist__3844, fixed_arity__3845) <= fixed_arity__3845)) {
        return f.apply(f, cljs.core.to_array.call(null, arglist__3844))
      }else {
        return f.cljs$lang$applyTo(arglist__3844)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__3844))
    }
  };
  var apply__3854 = function(f, x, y, args) {
    var arglist__3846 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__3847 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      if(cljs.core.truth_(cljs.core.bounded_count.call(null, arglist__3846, fixed_arity__3847) <= fixed_arity__3847)) {
        return f.apply(f, cljs.core.to_array.call(null, arglist__3846))
      }else {
        return f.cljs$lang$applyTo(arglist__3846)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__3846))
    }
  };
  var apply__3855 = function(f, x, y, z, args) {
    var arglist__3848 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__3849 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      if(cljs.core.truth_(cljs.core.bounded_count.call(null, arglist__3848, fixed_arity__3849) <= fixed_arity__3849)) {
        return f.apply(f, cljs.core.to_array.call(null, arglist__3848))
      }else {
        return f.cljs$lang$applyTo(arglist__3848)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__3848))
    }
  };
  var apply__3856 = function() {
    var G__3858__delegate = function(f, a, b, c, d, args) {
      var arglist__3850 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__3851 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        if(cljs.core.truth_(cljs.core.bounded_count.call(null, arglist__3850, fixed_arity__3851) <= fixed_arity__3851)) {
          return f.apply(f, cljs.core.to_array.call(null, arglist__3850))
        }else {
          return f.cljs$lang$applyTo(arglist__3850)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__3850))
      }
    };
    var G__3858 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__3858__delegate.call(this, f, a, b, c, d, args)
    };
    G__3858.cljs$lang$maxFixedArity = 5;
    G__3858.cljs$lang$applyTo = function(arglist__3859) {
      var f = cljs.core.first(arglist__3859);
      var a = cljs.core.first(cljs.core.next(arglist__3859));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3859)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3859))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3859)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3859)))));
      return G__3858__delegate.call(this, f, a, b, c, d, args)
    };
    return G__3858
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__3852.call(this, f, a);
      case 3:
        return apply__3853.call(this, f, a, b);
      case 4:
        return apply__3854.call(this, f, a, b, c);
      case 5:
        return apply__3855.call(this, f, a, b, c, d);
      default:
        return apply__3856.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__3856.cljs$lang$applyTo;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__3860) {
    var obj = cljs.core.first(arglist__3860);
    var f = cljs.core.first(cljs.core.next(arglist__3860));
    var args = cljs.core.rest(cljs.core.next(arglist__3860));
    return vary_meta__delegate.call(this, obj, f, args)
  };
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___3861 = function(x) {
    return false
  };
  var not_EQ___3862 = function(x, y) {
    return cljs.core.not.call(null, cljs.core._EQ_.call(null, x, y))
  };
  var not_EQ___3863 = function() {
    var G__3865__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__3865 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__3865__delegate.call(this, x, y, more)
    };
    G__3865.cljs$lang$maxFixedArity = 2;
    G__3865.cljs$lang$applyTo = function(arglist__3866) {
      var x = cljs.core.first(arglist__3866);
      var y = cljs.core.first(cljs.core.next(arglist__3866));
      var more = cljs.core.rest(cljs.core.next(arglist__3866));
      return G__3865__delegate.call(this, x, y, more)
    };
    return G__3865
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___3861.call(this, x);
      case 2:
        return not_EQ___3862.call(this, x, y);
      default:
        return not_EQ___3863.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3863.cljs$lang$applyTo;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll) === null)) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__3867 = pred;
        var G__3868 = cljs.core.next.call(null, coll);
        pred = G__3867;
        coll = G__3868;
        continue
      }else {
        if(cljs.core.truth_("\ufdd0'else")) {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.every_QMARK_.call(null, pred, coll))
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
      var or__3548__auto____3869 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3548__auto____3869)) {
        return or__3548__auto____3869
      }else {
        var G__3870 = pred;
        var G__3871 = cljs.core.next.call(null, coll);
        pred = G__3870;
        coll = G__3871;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.truth_(cljs.core.integer_QMARK_.call(null, n))) {
    return(n & 1) === 0
  }else {
    throw new Error(cljs.core.str.call(null, "Argument must be an integer: ", n));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return cljs.core.not.call(null, cljs.core.even_QMARK_.call(null, n))
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__3872 = null;
    var G__3872__3873 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__3872__3874 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__3872__3875 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__3872__3876 = function() {
      var G__3878__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__3878 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__3878__delegate.call(this, x, y, zs)
      };
      G__3878.cljs$lang$maxFixedArity = 2;
      G__3878.cljs$lang$applyTo = function(arglist__3879) {
        var x = cljs.core.first(arglist__3879);
        var y = cljs.core.first(cljs.core.next(arglist__3879));
        var zs = cljs.core.rest(cljs.core.next(arglist__3879));
        return G__3878__delegate.call(this, x, y, zs)
      };
      return G__3878
    }();
    G__3872 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__3872__3873.call(this);
        case 1:
          return G__3872__3874.call(this, x);
        case 2:
          return G__3872__3875.call(this, x, y);
        default:
          return G__3872__3876.apply(this, arguments)
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__3872.cljs$lang$maxFixedArity = 2;
    G__3872.cljs$lang$applyTo = G__3872__3876.cljs$lang$applyTo;
    return G__3872
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__3880__delegate = function(args) {
      return x
    };
    var G__3880 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__3880__delegate.call(this, args)
    };
    G__3880.cljs$lang$maxFixedArity = 0;
    G__3880.cljs$lang$applyTo = function(arglist__3881) {
      var args = cljs.core.seq(arglist__3881);
      return G__3880__delegate.call(this, args)
    };
    return G__3880
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__3885 = function() {
    return cljs.core.identity
  };
  var comp__3886 = function(f) {
    return f
  };
  var comp__3887 = function(f, g) {
    return function() {
      var G__3891 = null;
      var G__3891__3892 = function() {
        return f.call(null, g.call(null))
      };
      var G__3891__3893 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__3891__3894 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__3891__3895 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__3891__3896 = function() {
        var G__3898__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__3898 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__3898__delegate.call(this, x, y, z, args)
        };
        G__3898.cljs$lang$maxFixedArity = 3;
        G__3898.cljs$lang$applyTo = function(arglist__3899) {
          var x = cljs.core.first(arglist__3899);
          var y = cljs.core.first(cljs.core.next(arglist__3899));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3899)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3899)));
          return G__3898__delegate.call(this, x, y, z, args)
        };
        return G__3898
      }();
      G__3891 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__3891__3892.call(this);
          case 1:
            return G__3891__3893.call(this, x);
          case 2:
            return G__3891__3894.call(this, x, y);
          case 3:
            return G__3891__3895.call(this, x, y, z);
          default:
            return G__3891__3896.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__3891.cljs$lang$maxFixedArity = 3;
      G__3891.cljs$lang$applyTo = G__3891__3896.cljs$lang$applyTo;
      return G__3891
    }()
  };
  var comp__3888 = function(f, g, h) {
    return function() {
      var G__3900 = null;
      var G__3900__3901 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__3900__3902 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__3900__3903 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__3900__3904 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__3900__3905 = function() {
        var G__3907__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__3907 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__3907__delegate.call(this, x, y, z, args)
        };
        G__3907.cljs$lang$maxFixedArity = 3;
        G__3907.cljs$lang$applyTo = function(arglist__3908) {
          var x = cljs.core.first(arglist__3908);
          var y = cljs.core.first(cljs.core.next(arglist__3908));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3908)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3908)));
          return G__3907__delegate.call(this, x, y, z, args)
        };
        return G__3907
      }();
      G__3900 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__3900__3901.call(this);
          case 1:
            return G__3900__3902.call(this, x);
          case 2:
            return G__3900__3903.call(this, x, y);
          case 3:
            return G__3900__3904.call(this, x, y, z);
          default:
            return G__3900__3905.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__3900.cljs$lang$maxFixedArity = 3;
      G__3900.cljs$lang$applyTo = G__3900__3905.cljs$lang$applyTo;
      return G__3900
    }()
  };
  var comp__3889 = function() {
    var G__3909__delegate = function(f1, f2, f3, fs) {
      var fs__3882 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__3910__delegate = function(args) {
          var ret__3883 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__3882), args);
          var fs__3884 = cljs.core.next.call(null, fs__3882);
          while(true) {
            if(cljs.core.truth_(fs__3884)) {
              var G__3911 = cljs.core.first.call(null, fs__3884).call(null, ret__3883);
              var G__3912 = cljs.core.next.call(null, fs__3884);
              ret__3883 = G__3911;
              fs__3884 = G__3912;
              continue
            }else {
              return ret__3883
            }
            break
          }
        };
        var G__3910 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__3910__delegate.call(this, args)
        };
        G__3910.cljs$lang$maxFixedArity = 0;
        G__3910.cljs$lang$applyTo = function(arglist__3913) {
          var args = cljs.core.seq(arglist__3913);
          return G__3910__delegate.call(this, args)
        };
        return G__3910
      }()
    };
    var G__3909 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__3909__delegate.call(this, f1, f2, f3, fs)
    };
    G__3909.cljs$lang$maxFixedArity = 3;
    G__3909.cljs$lang$applyTo = function(arglist__3914) {
      var f1 = cljs.core.first(arglist__3914);
      var f2 = cljs.core.first(cljs.core.next(arglist__3914));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3914)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3914)));
      return G__3909__delegate.call(this, f1, f2, f3, fs)
    };
    return G__3909
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__3885.call(this);
      case 1:
        return comp__3886.call(this, f1);
      case 2:
        return comp__3887.call(this, f1, f2);
      case 3:
        return comp__3888.call(this, f1, f2, f3);
      default:
        return comp__3889.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__3889.cljs$lang$applyTo;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__3915 = function(f, arg1) {
    return function() {
      var G__3920__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__3920 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__3920__delegate.call(this, args)
      };
      G__3920.cljs$lang$maxFixedArity = 0;
      G__3920.cljs$lang$applyTo = function(arglist__3921) {
        var args = cljs.core.seq(arglist__3921);
        return G__3920__delegate.call(this, args)
      };
      return G__3920
    }()
  };
  var partial__3916 = function(f, arg1, arg2) {
    return function() {
      var G__3922__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__3922 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__3922__delegate.call(this, args)
      };
      G__3922.cljs$lang$maxFixedArity = 0;
      G__3922.cljs$lang$applyTo = function(arglist__3923) {
        var args = cljs.core.seq(arglist__3923);
        return G__3922__delegate.call(this, args)
      };
      return G__3922
    }()
  };
  var partial__3917 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__3924__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__3924 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__3924__delegate.call(this, args)
      };
      G__3924.cljs$lang$maxFixedArity = 0;
      G__3924.cljs$lang$applyTo = function(arglist__3925) {
        var args = cljs.core.seq(arglist__3925);
        return G__3924__delegate.call(this, args)
      };
      return G__3924
    }()
  };
  var partial__3918 = function() {
    var G__3926__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__3927__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__3927 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__3927__delegate.call(this, args)
        };
        G__3927.cljs$lang$maxFixedArity = 0;
        G__3927.cljs$lang$applyTo = function(arglist__3928) {
          var args = cljs.core.seq(arglist__3928);
          return G__3927__delegate.call(this, args)
        };
        return G__3927
      }()
    };
    var G__3926 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__3926__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__3926.cljs$lang$maxFixedArity = 4;
    G__3926.cljs$lang$applyTo = function(arglist__3929) {
      var f = cljs.core.first(arglist__3929);
      var arg1 = cljs.core.first(cljs.core.next(arglist__3929));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3929)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3929))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__3929))));
      return G__3926__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    return G__3926
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__3915.call(this, f, arg1);
      case 3:
        return partial__3916.call(this, f, arg1, arg2);
      case 4:
        return partial__3917.call(this, f, arg1, arg2, arg3);
      default:
        return partial__3918.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__3918.cljs$lang$applyTo;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__3930 = function(f, x) {
    return function() {
      var G__3934 = null;
      var G__3934__3935 = function(a) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a)
      };
      var G__3934__3936 = function(a, b) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, b)
      };
      var G__3934__3937 = function(a, b, c) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, b, c)
      };
      var G__3934__3938 = function() {
        var G__3940__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, cljs.core.truth_(a === null) ? x : a, b, c, ds)
        };
        var G__3940 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__3940__delegate.call(this, a, b, c, ds)
        };
        G__3940.cljs$lang$maxFixedArity = 3;
        G__3940.cljs$lang$applyTo = function(arglist__3941) {
          var a = cljs.core.first(arglist__3941);
          var b = cljs.core.first(cljs.core.next(arglist__3941));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3941)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3941)));
          return G__3940__delegate.call(this, a, b, c, ds)
        };
        return G__3940
      }();
      G__3934 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__3934__3935.call(this, a);
          case 2:
            return G__3934__3936.call(this, a, b);
          case 3:
            return G__3934__3937.call(this, a, b, c);
          default:
            return G__3934__3938.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__3934.cljs$lang$maxFixedArity = 3;
      G__3934.cljs$lang$applyTo = G__3934__3938.cljs$lang$applyTo;
      return G__3934
    }()
  };
  var fnil__3931 = function(f, x, y) {
    return function() {
      var G__3942 = null;
      var G__3942__3943 = function(a, b) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b)
      };
      var G__3942__3944 = function(a, b, c) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b, c)
      };
      var G__3942__3945 = function() {
        var G__3947__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b, c, ds)
        };
        var G__3947 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__3947__delegate.call(this, a, b, c, ds)
        };
        G__3947.cljs$lang$maxFixedArity = 3;
        G__3947.cljs$lang$applyTo = function(arglist__3948) {
          var a = cljs.core.first(arglist__3948);
          var b = cljs.core.first(cljs.core.next(arglist__3948));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3948)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3948)));
          return G__3947__delegate.call(this, a, b, c, ds)
        };
        return G__3947
      }();
      G__3942 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__3942__3943.call(this, a, b);
          case 3:
            return G__3942__3944.call(this, a, b, c);
          default:
            return G__3942__3945.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__3942.cljs$lang$maxFixedArity = 3;
      G__3942.cljs$lang$applyTo = G__3942__3945.cljs$lang$applyTo;
      return G__3942
    }()
  };
  var fnil__3932 = function(f, x, y, z) {
    return function() {
      var G__3949 = null;
      var G__3949__3950 = function(a, b) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b)
      };
      var G__3949__3951 = function(a, b, c) {
        return f.call(null, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b, cljs.core.truth_(c === null) ? z : c)
      };
      var G__3949__3952 = function() {
        var G__3954__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, cljs.core.truth_(a === null) ? x : a, cljs.core.truth_(b === null) ? y : b, cljs.core.truth_(c === null) ? z : c, ds)
        };
        var G__3954 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__3954__delegate.call(this, a, b, c, ds)
        };
        G__3954.cljs$lang$maxFixedArity = 3;
        G__3954.cljs$lang$applyTo = function(arglist__3955) {
          var a = cljs.core.first(arglist__3955);
          var b = cljs.core.first(cljs.core.next(arglist__3955));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__3955)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__3955)));
          return G__3954__delegate.call(this, a, b, c, ds)
        };
        return G__3954
      }();
      G__3949 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__3949__3950.call(this, a, b);
          case 3:
            return G__3949__3951.call(this, a, b, c);
          default:
            return G__3949__3952.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__3949.cljs$lang$maxFixedArity = 3;
      G__3949.cljs$lang$applyTo = G__3949__3952.cljs$lang$applyTo;
      return G__3949
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__3930.call(this, f, x);
      case 3:
        return fnil__3931.call(this, f, x, y);
      case 4:
        return fnil__3932.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__3958 = function mpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____3956 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____3956)) {
        var s__3957 = temp__3698__auto____3956;
        return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__3957)), mpi.call(null, idx + 1, cljs.core.rest.call(null, s__3957)))
      }else {
        return null
      }
    })
  };
  return mapi__3958.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____3959 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____3959)) {
      var s__3960 = temp__3698__auto____3959;
      var x__3961 = f.call(null, cljs.core.first.call(null, s__3960));
      if(cljs.core.truth_(x__3961 === null)) {
        return keep.call(null, f, cljs.core.rest.call(null, s__3960))
      }else {
        return cljs.core.cons.call(null, x__3961, keep.call(null, f, cljs.core.rest.call(null, s__3960)))
      }
    }else {
      return null
    }
  })
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__3971 = function kpi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____3968 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____3968)) {
        var s__3969 = temp__3698__auto____3968;
        var x__3970 = f.call(null, idx, cljs.core.first.call(null, s__3969));
        if(cljs.core.truth_(x__3970 === null)) {
          return kpi.call(null, idx + 1, cljs.core.rest.call(null, s__3969))
        }else {
          return cljs.core.cons.call(null, x__3970, kpi.call(null, idx + 1, cljs.core.rest.call(null, s__3969)))
        }
      }else {
        return null
      }
    })
  };
  return keepi__3971.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__4016 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__4021 = function() {
        return true
      };
      var ep1__4022 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__4023 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____3978 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____3978)) {
            return p.call(null, y)
          }else {
            return and__3546__auto____3978
          }
        }())
      };
      var ep1__4024 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____3979 = p.call(null, x);
          if(cljs.core.truth_(and__3546__auto____3979)) {
            var and__3546__auto____3980 = p.call(null, y);
            if(cljs.core.truth_(and__3546__auto____3980)) {
              return p.call(null, z)
            }else {
              return and__3546__auto____3980
            }
          }else {
            return and__3546__auto____3979
          }
        }())
      };
      var ep1__4025 = function() {
        var G__4027__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____3981 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____3981)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3546__auto____3981
            }
          }())
        };
        var G__4027 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4027__delegate.call(this, x, y, z, args)
        };
        G__4027.cljs$lang$maxFixedArity = 3;
        G__4027.cljs$lang$applyTo = function(arglist__4028) {
          var x = cljs.core.first(arglist__4028);
          var y = cljs.core.first(cljs.core.next(arglist__4028));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4028)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4028)));
          return G__4027__delegate.call(this, x, y, z, args)
        };
        return G__4027
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__4021.call(this);
          case 1:
            return ep1__4022.call(this, x);
          case 2:
            return ep1__4023.call(this, x, y);
          case 3:
            return ep1__4024.call(this, x, y, z);
          default:
            return ep1__4025.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4025.cljs$lang$applyTo;
      return ep1
    }()
  };
  var every_pred__4017 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__4029 = function() {
        return true
      };
      var ep2__4030 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____3982 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____3982)) {
            return p2.call(null, x)
          }else {
            return and__3546__auto____3982
          }
        }())
      };
      var ep2__4031 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____3983 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____3983)) {
            var and__3546__auto____3984 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____3984)) {
              var and__3546__auto____3985 = p2.call(null, x);
              if(cljs.core.truth_(and__3546__auto____3985)) {
                return p2.call(null, y)
              }else {
                return and__3546__auto____3985
              }
            }else {
              return and__3546__auto____3984
            }
          }else {
            return and__3546__auto____3983
          }
        }())
      };
      var ep2__4032 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____3986 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____3986)) {
            var and__3546__auto____3987 = p1.call(null, y);
            if(cljs.core.truth_(and__3546__auto____3987)) {
              var and__3546__auto____3988 = p1.call(null, z);
              if(cljs.core.truth_(and__3546__auto____3988)) {
                var and__3546__auto____3989 = p2.call(null, x);
                if(cljs.core.truth_(and__3546__auto____3989)) {
                  var and__3546__auto____3990 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____3990)) {
                    return p2.call(null, z)
                  }else {
                    return and__3546__auto____3990
                  }
                }else {
                  return and__3546__auto____3989
                }
              }else {
                return and__3546__auto____3988
              }
            }else {
              return and__3546__auto____3987
            }
          }else {
            return and__3546__auto____3986
          }
        }())
      };
      var ep2__4033 = function() {
        var G__4035__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____3991 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____3991)) {
              return cljs.core.every_QMARK_.call(null, function(p1__3962_SHARP_) {
                var and__3546__auto____3992 = p1.call(null, p1__3962_SHARP_);
                if(cljs.core.truth_(and__3546__auto____3992)) {
                  return p2.call(null, p1__3962_SHARP_)
                }else {
                  return and__3546__auto____3992
                }
              }, args)
            }else {
              return and__3546__auto____3991
            }
          }())
        };
        var G__4035 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4035__delegate.call(this, x, y, z, args)
        };
        G__4035.cljs$lang$maxFixedArity = 3;
        G__4035.cljs$lang$applyTo = function(arglist__4036) {
          var x = cljs.core.first(arglist__4036);
          var y = cljs.core.first(cljs.core.next(arglist__4036));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4036)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4036)));
          return G__4035__delegate.call(this, x, y, z, args)
        };
        return G__4035
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__4029.call(this);
          case 1:
            return ep2__4030.call(this, x);
          case 2:
            return ep2__4031.call(this, x, y);
          case 3:
            return ep2__4032.call(this, x, y, z);
          default:
            return ep2__4033.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4033.cljs$lang$applyTo;
      return ep2
    }()
  };
  var every_pred__4018 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__4037 = function() {
        return true
      };
      var ep3__4038 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____3993 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____3993)) {
            var and__3546__auto____3994 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____3994)) {
              return p3.call(null, x)
            }else {
              return and__3546__auto____3994
            }
          }else {
            return and__3546__auto____3993
          }
        }())
      };
      var ep3__4039 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____3995 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____3995)) {
            var and__3546__auto____3996 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____3996)) {
              var and__3546__auto____3997 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____3997)) {
                var and__3546__auto____3998 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____3998)) {
                  var and__3546__auto____3999 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____3999)) {
                    return p3.call(null, y)
                  }else {
                    return and__3546__auto____3999
                  }
                }else {
                  return and__3546__auto____3998
                }
              }else {
                return and__3546__auto____3997
              }
            }else {
              return and__3546__auto____3996
            }
          }else {
            return and__3546__auto____3995
          }
        }())
      };
      var ep3__4040 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3546__auto____4000 = p1.call(null, x);
          if(cljs.core.truth_(and__3546__auto____4000)) {
            var and__3546__auto____4001 = p2.call(null, x);
            if(cljs.core.truth_(and__3546__auto____4001)) {
              var and__3546__auto____4002 = p3.call(null, x);
              if(cljs.core.truth_(and__3546__auto____4002)) {
                var and__3546__auto____4003 = p1.call(null, y);
                if(cljs.core.truth_(and__3546__auto____4003)) {
                  var and__3546__auto____4004 = p2.call(null, y);
                  if(cljs.core.truth_(and__3546__auto____4004)) {
                    var and__3546__auto____4005 = p3.call(null, y);
                    if(cljs.core.truth_(and__3546__auto____4005)) {
                      var and__3546__auto____4006 = p1.call(null, z);
                      if(cljs.core.truth_(and__3546__auto____4006)) {
                        var and__3546__auto____4007 = p2.call(null, z);
                        if(cljs.core.truth_(and__3546__auto____4007)) {
                          return p3.call(null, z)
                        }else {
                          return and__3546__auto____4007
                        }
                      }else {
                        return and__3546__auto____4006
                      }
                    }else {
                      return and__3546__auto____4005
                    }
                  }else {
                    return and__3546__auto____4004
                  }
                }else {
                  return and__3546__auto____4003
                }
              }else {
                return and__3546__auto____4002
              }
            }else {
              return and__3546__auto____4001
            }
          }else {
            return and__3546__auto____4000
          }
        }())
      };
      var ep3__4041 = function() {
        var G__4043__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3546__auto____4008 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3546__auto____4008)) {
              return cljs.core.every_QMARK_.call(null, function(p1__3963_SHARP_) {
                var and__3546__auto____4009 = p1.call(null, p1__3963_SHARP_);
                if(cljs.core.truth_(and__3546__auto____4009)) {
                  var and__3546__auto____4010 = p2.call(null, p1__3963_SHARP_);
                  if(cljs.core.truth_(and__3546__auto____4010)) {
                    return p3.call(null, p1__3963_SHARP_)
                  }else {
                    return and__3546__auto____4010
                  }
                }else {
                  return and__3546__auto____4009
                }
              }, args)
            }else {
              return and__3546__auto____4008
            }
          }())
        };
        var G__4043 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4043__delegate.call(this, x, y, z, args)
        };
        G__4043.cljs$lang$maxFixedArity = 3;
        G__4043.cljs$lang$applyTo = function(arglist__4044) {
          var x = cljs.core.first(arglist__4044);
          var y = cljs.core.first(cljs.core.next(arglist__4044));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4044)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4044)));
          return G__4043__delegate.call(this, x, y, z, args)
        };
        return G__4043
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__4037.call(this);
          case 1:
            return ep3__4038.call(this, x);
          case 2:
            return ep3__4039.call(this, x, y);
          case 3:
            return ep3__4040.call(this, x, y, z);
          default:
            return ep3__4041.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4041.cljs$lang$applyTo;
      return ep3
    }()
  };
  var every_pred__4019 = function() {
    var G__4045__delegate = function(p1, p2, p3, ps) {
      var ps__4011 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__4046 = function() {
          return true
        };
        var epn__4047 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__3964_SHARP_) {
            return p1__3964_SHARP_.call(null, x)
          }, ps__4011)
        };
        var epn__4048 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__3965_SHARP_) {
            var and__3546__auto____4012 = p1__3965_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____4012)) {
              return p1__3965_SHARP_.call(null, y)
            }else {
              return and__3546__auto____4012
            }
          }, ps__4011)
        };
        var epn__4049 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__3966_SHARP_) {
            var and__3546__auto____4013 = p1__3966_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3546__auto____4013)) {
              var and__3546__auto____4014 = p1__3966_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3546__auto____4014)) {
                return p1__3966_SHARP_.call(null, z)
              }else {
                return and__3546__auto____4014
              }
            }else {
              return and__3546__auto____4013
            }
          }, ps__4011)
        };
        var epn__4050 = function() {
          var G__4052__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3546__auto____4015 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3546__auto____4015)) {
                return cljs.core.every_QMARK_.call(null, function(p1__3967_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__3967_SHARP_, args)
                }, ps__4011)
              }else {
                return and__3546__auto____4015
              }
            }())
          };
          var G__4052 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__4052__delegate.call(this, x, y, z, args)
          };
          G__4052.cljs$lang$maxFixedArity = 3;
          G__4052.cljs$lang$applyTo = function(arglist__4053) {
            var x = cljs.core.first(arglist__4053);
            var y = cljs.core.first(cljs.core.next(arglist__4053));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4053)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4053)));
            return G__4052__delegate.call(this, x, y, z, args)
          };
          return G__4052
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__4046.call(this);
            case 1:
              return epn__4047.call(this, x);
            case 2:
              return epn__4048.call(this, x, y);
            case 3:
              return epn__4049.call(this, x, y, z);
            default:
              return epn__4050.apply(this, arguments)
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4050.cljs$lang$applyTo;
        return epn
      }()
    };
    var G__4045 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4045__delegate.call(this, p1, p2, p3, ps)
    };
    G__4045.cljs$lang$maxFixedArity = 3;
    G__4045.cljs$lang$applyTo = function(arglist__4054) {
      var p1 = cljs.core.first(arglist__4054);
      var p2 = cljs.core.first(cljs.core.next(arglist__4054));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4054)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4054)));
      return G__4045__delegate.call(this, p1, p2, p3, ps)
    };
    return G__4045
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__4016.call(this, p1);
      case 2:
        return every_pred__4017.call(this, p1, p2);
      case 3:
        return every_pred__4018.call(this, p1, p2, p3);
      default:
        return every_pred__4019.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4019.cljs$lang$applyTo;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__4094 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__4099 = function() {
        return null
      };
      var sp1__4100 = function(x) {
        return p.call(null, x)
      };
      var sp1__4101 = function(x, y) {
        var or__3548__auto____4056 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4056)) {
          return or__3548__auto____4056
        }else {
          return p.call(null, y)
        }
      };
      var sp1__4102 = function(x, y, z) {
        var or__3548__auto____4057 = p.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4057)) {
          return or__3548__auto____4057
        }else {
          var or__3548__auto____4058 = p.call(null, y);
          if(cljs.core.truth_(or__3548__auto____4058)) {
            return or__3548__auto____4058
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4103 = function() {
        var G__4105__delegate = function(x, y, z, args) {
          var or__3548__auto____4059 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____4059)) {
            return or__3548__auto____4059
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__4105 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4105__delegate.call(this, x, y, z, args)
        };
        G__4105.cljs$lang$maxFixedArity = 3;
        G__4105.cljs$lang$applyTo = function(arglist__4106) {
          var x = cljs.core.first(arglist__4106);
          var y = cljs.core.first(cljs.core.next(arglist__4106));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4106)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4106)));
          return G__4105__delegate.call(this, x, y, z, args)
        };
        return G__4105
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__4099.call(this);
          case 1:
            return sp1__4100.call(this, x);
          case 2:
            return sp1__4101.call(this, x, y);
          case 3:
            return sp1__4102.call(this, x, y, z);
          default:
            return sp1__4103.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4103.cljs$lang$applyTo;
      return sp1
    }()
  };
  var some_fn__4095 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__4107 = function() {
        return null
      };
      var sp2__4108 = function(x) {
        var or__3548__auto____4060 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4060)) {
          return or__3548__auto____4060
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__4109 = function(x, y) {
        var or__3548__auto____4061 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4061)) {
          return or__3548__auto____4061
        }else {
          var or__3548__auto____4062 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____4062)) {
            return or__3548__auto____4062
          }else {
            var or__3548__auto____4063 = p2.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4063)) {
              return or__3548__auto____4063
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__4110 = function(x, y, z) {
        var or__3548__auto____4064 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4064)) {
          return or__3548__auto____4064
        }else {
          var or__3548__auto____4065 = p1.call(null, y);
          if(cljs.core.truth_(or__3548__auto____4065)) {
            return or__3548__auto____4065
          }else {
            var or__3548__auto____4066 = p1.call(null, z);
            if(cljs.core.truth_(or__3548__auto____4066)) {
              return or__3548__auto____4066
            }else {
              var or__3548__auto____4067 = p2.call(null, x);
              if(cljs.core.truth_(or__3548__auto____4067)) {
                return or__3548__auto____4067
              }else {
                var or__3548__auto____4068 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____4068)) {
                  return or__3548__auto____4068
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4111 = function() {
        var G__4113__delegate = function(x, y, z, args) {
          var or__3548__auto____4069 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____4069)) {
            return or__3548__auto____4069
          }else {
            return cljs.core.some.call(null, function(p1__3972_SHARP_) {
              var or__3548__auto____4070 = p1.call(null, p1__3972_SHARP_);
              if(cljs.core.truth_(or__3548__auto____4070)) {
                return or__3548__auto____4070
              }else {
                return p2.call(null, p1__3972_SHARP_)
              }
            }, args)
          }
        };
        var G__4113 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4113__delegate.call(this, x, y, z, args)
        };
        G__4113.cljs$lang$maxFixedArity = 3;
        G__4113.cljs$lang$applyTo = function(arglist__4114) {
          var x = cljs.core.first(arglist__4114);
          var y = cljs.core.first(cljs.core.next(arglist__4114));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4114)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4114)));
          return G__4113__delegate.call(this, x, y, z, args)
        };
        return G__4113
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__4107.call(this);
          case 1:
            return sp2__4108.call(this, x);
          case 2:
            return sp2__4109.call(this, x, y);
          case 3:
            return sp2__4110.call(this, x, y, z);
          default:
            return sp2__4111.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4111.cljs$lang$applyTo;
      return sp2
    }()
  };
  var some_fn__4096 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__4115 = function() {
        return null
      };
      var sp3__4116 = function(x) {
        var or__3548__auto____4071 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4071)) {
          return or__3548__auto____4071
        }else {
          var or__3548__auto____4072 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____4072)) {
            return or__3548__auto____4072
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__4117 = function(x, y) {
        var or__3548__auto____4073 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4073)) {
          return or__3548__auto____4073
        }else {
          var or__3548__auto____4074 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____4074)) {
            return or__3548__auto____4074
          }else {
            var or__3548__auto____4075 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4075)) {
              return or__3548__auto____4075
            }else {
              var or__3548__auto____4076 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____4076)) {
                return or__3548__auto____4076
              }else {
                var or__3548__auto____4077 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____4077)) {
                  return or__3548__auto____4077
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__4118 = function(x, y, z) {
        var or__3548__auto____4078 = p1.call(null, x);
        if(cljs.core.truth_(or__3548__auto____4078)) {
          return or__3548__auto____4078
        }else {
          var or__3548__auto____4079 = p2.call(null, x);
          if(cljs.core.truth_(or__3548__auto____4079)) {
            return or__3548__auto____4079
          }else {
            var or__3548__auto____4080 = p3.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4080)) {
              return or__3548__auto____4080
            }else {
              var or__3548__auto____4081 = p1.call(null, y);
              if(cljs.core.truth_(or__3548__auto____4081)) {
                return or__3548__auto____4081
              }else {
                var or__3548__auto____4082 = p2.call(null, y);
                if(cljs.core.truth_(or__3548__auto____4082)) {
                  return or__3548__auto____4082
                }else {
                  var or__3548__auto____4083 = p3.call(null, y);
                  if(cljs.core.truth_(or__3548__auto____4083)) {
                    return or__3548__auto____4083
                  }else {
                    var or__3548__auto____4084 = p1.call(null, z);
                    if(cljs.core.truth_(or__3548__auto____4084)) {
                      return or__3548__auto____4084
                    }else {
                      var or__3548__auto____4085 = p2.call(null, z);
                      if(cljs.core.truth_(or__3548__auto____4085)) {
                        return or__3548__auto____4085
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4119 = function() {
        var G__4121__delegate = function(x, y, z, args) {
          var or__3548__auto____4086 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3548__auto____4086)) {
            return or__3548__auto____4086
          }else {
            return cljs.core.some.call(null, function(p1__3973_SHARP_) {
              var or__3548__auto____4087 = p1.call(null, p1__3973_SHARP_);
              if(cljs.core.truth_(or__3548__auto____4087)) {
                return or__3548__auto____4087
              }else {
                var or__3548__auto____4088 = p2.call(null, p1__3973_SHARP_);
                if(cljs.core.truth_(or__3548__auto____4088)) {
                  return or__3548__auto____4088
                }else {
                  return p3.call(null, p1__3973_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__4121 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4121__delegate.call(this, x, y, z, args)
        };
        G__4121.cljs$lang$maxFixedArity = 3;
        G__4121.cljs$lang$applyTo = function(arglist__4122) {
          var x = cljs.core.first(arglist__4122);
          var y = cljs.core.first(cljs.core.next(arglist__4122));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4122)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4122)));
          return G__4121__delegate.call(this, x, y, z, args)
        };
        return G__4121
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__4115.call(this);
          case 1:
            return sp3__4116.call(this, x);
          case 2:
            return sp3__4117.call(this, x, y);
          case 3:
            return sp3__4118.call(this, x, y, z);
          default:
            return sp3__4119.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4119.cljs$lang$applyTo;
      return sp3
    }()
  };
  var some_fn__4097 = function() {
    var G__4123__delegate = function(p1, p2, p3, ps) {
      var ps__4089 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__4124 = function() {
          return null
        };
        var spn__4125 = function(x) {
          return cljs.core.some.call(null, function(p1__3974_SHARP_) {
            return p1__3974_SHARP_.call(null, x)
          }, ps__4089)
        };
        var spn__4126 = function(x, y) {
          return cljs.core.some.call(null, function(p1__3975_SHARP_) {
            var or__3548__auto____4090 = p1__3975_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4090)) {
              return or__3548__auto____4090
            }else {
              return p1__3975_SHARP_.call(null, y)
            }
          }, ps__4089)
        };
        var spn__4127 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__3976_SHARP_) {
            var or__3548__auto____4091 = p1__3976_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3548__auto____4091)) {
              return or__3548__auto____4091
            }else {
              var or__3548__auto____4092 = p1__3976_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3548__auto____4092)) {
                return or__3548__auto____4092
              }else {
                return p1__3976_SHARP_.call(null, z)
              }
            }
          }, ps__4089)
        };
        var spn__4128 = function() {
          var G__4130__delegate = function(x, y, z, args) {
            var or__3548__auto____4093 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3548__auto____4093)) {
              return or__3548__auto____4093
            }else {
              return cljs.core.some.call(null, function(p1__3977_SHARP_) {
                return cljs.core.some.call(null, p1__3977_SHARP_, args)
              }, ps__4089)
            }
          };
          var G__4130 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__4130__delegate.call(this, x, y, z, args)
          };
          G__4130.cljs$lang$maxFixedArity = 3;
          G__4130.cljs$lang$applyTo = function(arglist__4131) {
            var x = cljs.core.first(arglist__4131);
            var y = cljs.core.first(cljs.core.next(arglist__4131));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4131)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4131)));
            return G__4130__delegate.call(this, x, y, z, args)
          };
          return G__4130
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__4124.call(this);
            case 1:
              return spn__4125.call(this, x);
            case 2:
              return spn__4126.call(this, x, y);
            case 3:
              return spn__4127.call(this, x, y, z);
            default:
              return spn__4128.apply(this, arguments)
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4128.cljs$lang$applyTo;
        return spn
      }()
    };
    var G__4123 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4123__delegate.call(this, p1, p2, p3, ps)
    };
    G__4123.cljs$lang$maxFixedArity = 3;
    G__4123.cljs$lang$applyTo = function(arglist__4132) {
      var p1 = cljs.core.first(arglist__4132);
      var p2 = cljs.core.first(cljs.core.next(arglist__4132));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4132)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4132)));
      return G__4123__delegate.call(this, p1, p2, p3, ps)
    };
    return G__4123
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__4094.call(this, p1);
      case 2:
        return some_fn__4095.call(this, p1, p2);
      case 3:
        return some_fn__4096.call(this, p1, p2, p3);
      default:
        return some_fn__4097.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4097.cljs$lang$applyTo;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__4145 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4133 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4133)) {
        var s__4134 = temp__3698__auto____4133;
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__4134)), map.call(null, f, cljs.core.rest.call(null, s__4134)))
      }else {
        return null
      }
    })
  };
  var map__4146 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__4135 = cljs.core.seq.call(null, c1);
      var s2__4136 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4137 = s1__4135;
        if(cljs.core.truth_(and__3546__auto____4137)) {
          return s2__4136
        }else {
          return and__3546__auto____4137
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__4135), cljs.core.first.call(null, s2__4136)), map.call(null, f, cljs.core.rest.call(null, s1__4135), cljs.core.rest.call(null, s2__4136)))
      }else {
        return null
      }
    })
  };
  var map__4147 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__4138 = cljs.core.seq.call(null, c1);
      var s2__4139 = cljs.core.seq.call(null, c2);
      var s3__4140 = cljs.core.seq.call(null, c3);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4141 = s1__4138;
        if(cljs.core.truth_(and__3546__auto____4141)) {
          var and__3546__auto____4142 = s2__4139;
          if(cljs.core.truth_(and__3546__auto____4142)) {
            return s3__4140
          }else {
            return and__3546__auto____4142
          }
        }else {
          return and__3546__auto____4141
        }
      }())) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__4138), cljs.core.first.call(null, s2__4139), cljs.core.first.call(null, s3__4140)), map.call(null, f, cljs.core.rest.call(null, s1__4138), cljs.core.rest.call(null, s2__4139), cljs.core.rest.call(null, s3__4140)))
      }else {
        return null
      }
    })
  };
  var map__4148 = function() {
    var G__4150__delegate = function(f, c1, c2, c3, colls) {
      var step__4144 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__4143 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.truth_(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__4143))) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__4143), step.call(null, map.call(null, cljs.core.rest, ss__4143)))
          }else {
            return null
          }
        })
      };
      return map.call(null, function(p1__4055_SHARP_) {
        return cljs.core.apply.call(null, f, p1__4055_SHARP_)
      }, step__4144.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__4150 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__4150__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__4150.cljs$lang$maxFixedArity = 4;
    G__4150.cljs$lang$applyTo = function(arglist__4151) {
      var f = cljs.core.first(arglist__4151);
      var c1 = cljs.core.first(cljs.core.next(arglist__4151));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4151)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4151))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4151))));
      return G__4150__delegate.call(this, f, c1, c2, c3, colls)
    };
    return G__4150
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__4145.call(this, f, c1);
      case 3:
        return map__4146.call(this, f, c1, c2);
      case 4:
        return map__4147.call(this, f, c1, c2, c3);
      default:
        return map__4148.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__4148.cljs$lang$applyTo;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(cljs.core.truth_(n > 0)) {
      var temp__3698__auto____4152 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4152)) {
        var s__4153 = temp__3698__auto____4152;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__4153), take.call(null, n - 1, cljs.core.rest.call(null, s__4153)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.drop = function drop(n, coll) {
  var step__4156 = function(n, coll) {
    while(true) {
      var s__4154 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4155 = n > 0;
        if(cljs.core.truth_(and__3546__auto____4155)) {
          return s__4154
        }else {
          return and__3546__auto____4155
        }
      }())) {
        var G__4157 = n - 1;
        var G__4158 = cljs.core.rest.call(null, s__4154);
        n = G__4157;
        coll = G__4158;
        continue
      }else {
        return s__4154
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__4156.call(null, n, coll)
  })
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__4159 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__4160 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__4159.call(this, n);
      case 2:
        return drop_last__4160.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__4162 = cljs.core.seq.call(null, coll);
  var lead__4163 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(cljs.core.truth_(lead__4163)) {
      var G__4164 = cljs.core.next.call(null, s__4162);
      var G__4165 = cljs.core.next.call(null, lead__4163);
      s__4162 = G__4164;
      lead__4163 = G__4165;
      continue
    }else {
      return s__4162
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__4168 = function(pred, coll) {
    while(true) {
      var s__4166 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4167 = s__4166;
        if(cljs.core.truth_(and__3546__auto____4167)) {
          return pred.call(null, cljs.core.first.call(null, s__4166))
        }else {
          return and__3546__auto____4167
        }
      }())) {
        var G__4169 = pred;
        var G__4170 = cljs.core.rest.call(null, s__4166);
        pred = G__4169;
        coll = G__4170;
        continue
      }else {
        return s__4166
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__4168.call(null, pred, coll)
  })
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4171 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4171)) {
      var s__4172 = temp__3698__auto____4171;
      return cljs.core.concat.call(null, s__4172, cycle.call(null, s__4172))
    }else {
      return null
    }
  })
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)])
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__4173 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    })
  };
  var repeat__4174 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__4173.call(this, n);
      case 2:
        return repeat__4174.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__4176 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    })
  };
  var repeatedly__4177 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__4176.call(this, n);
      case 2:
        return repeatedly__4177.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__4183 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__4179 = cljs.core.seq.call(null, c1);
      var s2__4180 = cljs.core.seq.call(null, c2);
      if(cljs.core.truth_(function() {
        var and__3546__auto____4181 = s1__4179;
        if(cljs.core.truth_(and__3546__auto____4181)) {
          return s2__4180
        }else {
          return and__3546__auto____4181
        }
      }())) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__4179), cljs.core.cons.call(null, cljs.core.first.call(null, s2__4180), interleave.call(null, cljs.core.rest.call(null, s1__4179), cljs.core.rest.call(null, s2__4180))))
      }else {
        return null
      }
    })
  };
  var interleave__4184 = function() {
    var G__4186__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__4182 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.truth_(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__4182))) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__4182), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__4182)))
        }else {
          return null
        }
      })
    };
    var G__4186 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4186__delegate.call(this, c1, c2, colls)
    };
    G__4186.cljs$lang$maxFixedArity = 2;
    G__4186.cljs$lang$applyTo = function(arglist__4187) {
      var c1 = cljs.core.first(arglist__4187);
      var c2 = cljs.core.first(cljs.core.next(arglist__4187));
      var colls = cljs.core.rest(cljs.core.next(arglist__4187));
      return G__4186__delegate.call(this, c1, c2, colls)
    };
    return G__4186
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__4183.call(this, c1, c2);
      default:
        return interleave__4184.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__4184.cljs$lang$applyTo;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__4190 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____4188 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____4188)) {
        var coll__4189 = temp__3695__auto____4188;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__4189), cat.call(null, cljs.core.rest.call(null, coll__4189), colls))
      }else {
        if(cljs.core.truth_(cljs.core.seq.call(null, colls))) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    })
  };
  return cat__4190.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__4191 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__4192 = function() {
    var G__4194__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__4194 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__4194__delegate.call(this, f, coll, colls)
    };
    G__4194.cljs$lang$maxFixedArity = 2;
    G__4194.cljs$lang$applyTo = function(arglist__4195) {
      var f = cljs.core.first(arglist__4195);
      var coll = cljs.core.first(cljs.core.next(arglist__4195));
      var colls = cljs.core.rest(cljs.core.next(arglist__4195));
      return G__4194__delegate.call(this, f, coll, colls)
    };
    return G__4194
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__4191.call(this, f, coll);
      default:
        return mapcat__4192.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__4192.cljs$lang$applyTo;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4196 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4196)) {
      var s__4197 = temp__3698__auto____4196;
      var f__4198 = cljs.core.first.call(null, s__4197);
      var r__4199 = cljs.core.rest.call(null, s__4197);
      if(cljs.core.truth_(pred.call(null, f__4198))) {
        return cljs.core.cons.call(null, f__4198, filter.call(null, pred, r__4199))
      }else {
        return filter.call(null, pred, r__4199)
      }
    }else {
      return null
    }
  })
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__4201 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    })
  };
  return walk__4201.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__4200_SHARP_) {
    return cljs.core.not.call(null, cljs.core.sequential_QMARK_.call(null, p1__4200_SHARP_))
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  return cljs.core.reduce.call(null, cljs.core._conj, to, from)
};
cljs.core.partition = function() {
  var partition = null;
  var partition__4208 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__4209 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4202 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4202)) {
        var s__4203 = temp__3698__auto____4202;
        var p__4204 = cljs.core.take.call(null, n, s__4203);
        if(cljs.core.truth_(cljs.core._EQ_.call(null, n, cljs.core.count.call(null, p__4204)))) {
          return cljs.core.cons.call(null, p__4204, partition.call(null, n, step, cljs.core.drop.call(null, step, s__4203)))
        }else {
          return null
        }
      }else {
        return null
      }
    })
  };
  var partition__4210 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4205 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4205)) {
        var s__4206 = temp__3698__auto____4205;
        var p__4207 = cljs.core.take.call(null, n, s__4206);
        if(cljs.core.truth_(cljs.core._EQ_.call(null, n, cljs.core.count.call(null, p__4207)))) {
          return cljs.core.cons.call(null, p__4207, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__4206)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__4207, pad)))
        }
      }else {
        return null
      }
    })
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__4208.call(this, n, step);
      case 3:
        return partition__4209.call(this, n, step, pad);
      case 4:
        return partition__4210.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__4216 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__4217 = function(m, ks, not_found) {
    var sentinel__4212 = cljs.core.lookup_sentinel;
    var m__4213 = m;
    var ks__4214 = cljs.core.seq.call(null, ks);
    while(true) {
      if(cljs.core.truth_(ks__4214)) {
        var m__4215 = cljs.core.get.call(null, m__4213, cljs.core.first.call(null, ks__4214), sentinel__4212);
        if(cljs.core.truth_(sentinel__4212 === m__4215)) {
          return not_found
        }else {
          var G__4219 = sentinel__4212;
          var G__4220 = m__4215;
          var G__4221 = cljs.core.next.call(null, ks__4214);
          sentinel__4212 = G__4219;
          m__4213 = G__4220;
          ks__4214 = G__4221;
          continue
        }
      }else {
        return m__4213
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__4216.call(this, m, ks);
      case 3:
        return get_in__4217.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__4222, v) {
  var vec__4223__4224 = p__4222;
  var k__4225 = cljs.core.nth.call(null, vec__4223__4224, 0, null);
  var ks__4226 = cljs.core.nthnext.call(null, vec__4223__4224, 1);
  if(cljs.core.truth_(ks__4226)) {
    return cljs.core.assoc.call(null, m, k__4225, assoc_in.call(null, cljs.core.get.call(null, m, k__4225), ks__4226, v))
  }else {
    return cljs.core.assoc.call(null, m, k__4225, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__4227, f, args) {
    var vec__4228__4229 = p__4227;
    var k__4230 = cljs.core.nth.call(null, vec__4228__4229, 0, null);
    var ks__4231 = cljs.core.nthnext.call(null, vec__4228__4229, 1);
    if(cljs.core.truth_(ks__4231)) {
      return cljs.core.assoc.call(null, m, k__4230, cljs.core.apply.call(null, update_in, cljs.core.get.call(null, m, k__4230), ks__4231, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__4230, cljs.core.apply.call(null, f, cljs.core.get.call(null, m, k__4230), args))
    }
  };
  var update_in = function(m, p__4227, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__4227, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__4232) {
    var m = cljs.core.first(arglist__4232);
    var p__4227 = cljs.core.first(cljs.core.next(arglist__4232));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4232)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4232)));
    return update_in__delegate.call(this, m, p__4227, f, args)
  };
  return update_in
}();
cljs.core.Vector = function(meta, array) {
  this.meta = meta;
  this.array = array
};
cljs.core.Vector.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$ = true;
cljs.core.Vector.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4233 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.Vector.prototype.cljs$core$ILookup$ = true;
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4266 = null;
  var G__4266__4267 = function(coll, k) {
    var this__4234 = this;
    return cljs.core._nth.call(null, coll, k, null)
  };
  var G__4266__4268 = function(coll, k, not_found) {
    var this__4235 = this;
    return cljs.core._nth.call(null, coll, k, not_found)
  };
  G__4266 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4266__4267.call(this, coll, k);
      case 3:
        return G__4266__4268.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4266
}();
cljs.core.Vector.prototype.cljs$core$IAssociative$ = true;
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc = function(coll, k, v) {
  var this__4236 = this;
  var new_array__4237 = cljs.core.aclone.call(null, this__4236.array);
  new_array__4237[k] = v;
  return new cljs.core.Vector(this__4236.meta, new_array__4237)
};
cljs.core.Vector.prototype.cljs$core$IFn$ = true;
cljs.core.Vector.prototype.call = function() {
  var G__4270 = null;
  var G__4270__4271 = function(tsym4238, k) {
    var this__4240 = this;
    var tsym4238__4241 = this;
    var coll__4242 = tsym4238__4241;
    return cljs.core._lookup.call(null, coll__4242, k)
  };
  var G__4270__4272 = function(tsym4239, k, not_found) {
    var this__4243 = this;
    var tsym4239__4244 = this;
    var coll__4245 = tsym4239__4244;
    return cljs.core._lookup.call(null, coll__4245, k, not_found)
  };
  G__4270 = function(tsym4239, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4270__4271.call(this, tsym4239, k);
      case 3:
        return G__4270__4272.call(this, tsym4239, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4270
}();
cljs.core.Vector.prototype.cljs$core$ISequential$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$ = true;
cljs.core.Vector.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4246 = this;
  var new_array__4247 = cljs.core.aclone.call(null, this__4246.array);
  new_array__4247.push(o);
  return new cljs.core.Vector(this__4246.meta, new_array__4247)
};
cljs.core.Vector.prototype.cljs$core$IReduce$ = true;
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce = function() {
  var G__4274 = null;
  var G__4274__4275 = function(v, f) {
    var this__4248 = this;
    return cljs.core.ci_reduce.call(null, this__4248.array, f)
  };
  var G__4274__4276 = function(v, f, start) {
    var this__4249 = this;
    return cljs.core.ci_reduce.call(null, this__4249.array, f, start)
  };
  G__4274 = function(v, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4274__4275.call(this, v, f);
      case 3:
        return G__4274__4276.call(this, v, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4274
}();
cljs.core.Vector.prototype.cljs$core$ISeqable$ = true;
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4250 = this;
  if(cljs.core.truth_(this__4250.array.length > 0)) {
    var vector_seq__4251 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(cljs.core.truth_(i < this__4250.array.length)) {
          return cljs.core.cons.call(null, this__4250.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__4251.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$ = true;
cljs.core.Vector.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4252 = this;
  return this__4252.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$ = true;
cljs.core.Vector.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__4253 = this;
  var count__4254 = this__4253.array.length;
  if(cljs.core.truth_(count__4254 > 0)) {
    return this__4253.array[count__4254 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__4255 = this;
  if(cljs.core.truth_(this__4255.array.length > 0)) {
    var new_array__4256 = cljs.core.aclone.call(null, this__4255.array);
    new_array__4256.pop();
    return new cljs.core.Vector(this__4255.meta, new_array__4256)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$ = true;
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n = function(coll, n, val) {
  var this__4257 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$ = true;
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4258 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4259 = this;
  return new cljs.core.Vector(meta, this__4259.array)
};
cljs.core.Vector.prototype.cljs$core$IMeta$ = true;
cljs.core.Vector.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4260 = this;
  return this__4260.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$ = true;
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth = function() {
  var G__4278 = null;
  var G__4278__4279 = function(coll, n) {
    var this__4261 = this;
    if(cljs.core.truth_(function() {
      var and__3546__auto____4262 = 0 <= n;
      if(cljs.core.truth_(and__3546__auto____4262)) {
        return n < this__4261.array.length
      }else {
        return and__3546__auto____4262
      }
    }())) {
      return this__4261.array[n]
    }else {
      return null
    }
  };
  var G__4278__4280 = function(coll, n, not_found) {
    var this__4263 = this;
    if(cljs.core.truth_(function() {
      var and__3546__auto____4264 = 0 <= n;
      if(cljs.core.truth_(and__3546__auto____4264)) {
        return n < this__4263.array.length
      }else {
        return and__3546__auto____4264
      }
    }())) {
      return this__4263.array[n]
    }else {
      return not_found
    }
  };
  G__4278 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4278__4279.call(this, coll, n);
      case 3:
        return G__4278__4280.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4278
}();
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4265 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__4265.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, []);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs)
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__4282 = pv.cnt;
  if(cljs.core.truth_(cnt__4282 < 32)) {
    return 0
  }else {
    return cnt__4282 - 1 >> 5 << 5
  }
};
cljs.core.new_path = function new_path(level, node) {
  var ll__4283 = level;
  var ret__4284 = node;
  while(true) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, 0, ll__4283))) {
      return ret__4284
    }else {
      var embed__4285 = ret__4284;
      var r__4286 = cljs.core.aclone.call(null, cljs.core.PersistentVector.EMPTY_NODE);
      var ___4287 = r__4286[0] = embed__4285;
      var G__4288 = ll__4283 - 5;
      var G__4289 = r__4286;
      ll__4283 = G__4288;
      ret__4284 = G__4289;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__4290 = cljs.core.aclone.call(null, parent);
  var subidx__4291 = pv.cnt - 1 >> level & 31;
  if(cljs.core.truth_(cljs.core._EQ_.call(null, 5, level))) {
    ret__4290[subidx__4291] = tailnode;
    return ret__4290
  }else {
    var temp__3695__auto____4292 = parent[subidx__4291];
    if(cljs.core.truth_(temp__3695__auto____4292)) {
      var child__4293 = temp__3695__auto____4292;
      var node_to_insert__4294 = push_tail.call(null, pv, level - 5, child__4293, tailnode);
      var ___4295 = ret__4290[subidx__4291] = node_to_insert__4294;
      return ret__4290
    }else {
      var node_to_insert__4296 = cljs.core.new_path.call(null, level - 5, tailnode);
      var ___4297 = ret__4290[subidx__4291] = node_to_insert__4296;
      return ret__4290
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4298 = 0 <= i;
    if(cljs.core.truth_(and__3546__auto____4298)) {
      return i < pv.cnt
    }else {
      return and__3546__auto____4298
    }
  }())) {
    if(cljs.core.truth_(i >= cljs.core.tail_off.call(null, pv))) {
      return pv.tail
    }else {
      var node__4299 = pv.root;
      var level__4300 = pv.shift;
      while(true) {
        if(cljs.core.truth_(level__4300 > 0)) {
          var G__4301 = node__4299[i >> level__4300 & 31];
          var G__4302 = level__4300 - 5;
          node__4299 = G__4301;
          level__4300 = G__4302;
          continue
        }else {
          return node__4299
        }
        break
      }
    }
  }else {
    throw new Error(cljs.core.str.call(null, "No item ", i, " in vector of length ", pv.cnt));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__4303 = cljs.core.aclone.call(null, node);
  if(cljs.core.truth_(level === 0)) {
    ret__4303[i & 31] = val;
    return ret__4303
  }else {
    var subidx__4304 = i >> level & 31;
    var ___4305 = ret__4303[subidx__4304] = do_assoc.call(null, pv, level - 5, node[subidx__4304], i, val);
    return ret__4303
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__4306 = pv.cnt - 2 >> level & 31;
  if(cljs.core.truth_(level > 5)) {
    var new_child__4307 = pop_tail.call(null, pv, level - 5, node[subidx__4306]);
    if(cljs.core.truth_(function() {
      var and__3546__auto____4308 = new_child__4307 === null;
      if(cljs.core.truth_(and__3546__auto____4308)) {
        return subidx__4306 === 0
      }else {
        return and__3546__auto____4308
      }
    }())) {
      return null
    }else {
      var ret__4309 = cljs.core.aclone.call(null, node);
      var ___4310 = ret__4309[subidx__4306] = new_child__4307;
      return ret__4309
    }
  }else {
    if(cljs.core.truth_(subidx__4306 === 0)) {
      return null
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        var ret__4311 = cljs.core.aclone.call(null, node);
        var ___4312 = ret__4311[subidx__4306] = null;
        return ret__4311
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail
};
cljs.core.PersistentVector.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4313 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4353 = null;
  var G__4353__4354 = function(coll, k) {
    var this__4314 = this;
    return cljs.core._nth.call(null, coll, k, null)
  };
  var G__4353__4355 = function(coll, k, not_found) {
    var this__4315 = this;
    return cljs.core._nth.call(null, coll, k, not_found)
  };
  G__4353 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4353__4354.call(this, coll, k);
      case 3:
        return G__4353__4355.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4353
}();
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc = function(coll, k, v) {
  var this__4316 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____4317 = 0 <= k;
    if(cljs.core.truth_(and__3546__auto____4317)) {
      return k < this__4316.cnt
    }else {
      return and__3546__auto____4317
    }
  }())) {
    if(cljs.core.truth_(cljs.core.tail_off.call(null, coll) <= k)) {
      var new_tail__4318 = cljs.core.aclone.call(null, this__4316.tail);
      new_tail__4318[k & 31] = v;
      return new cljs.core.PersistentVector(this__4316.meta, this__4316.cnt, this__4316.shift, this__4316.root, new_tail__4318)
    }else {
      return new cljs.core.PersistentVector(this__4316.meta, this__4316.cnt, this__4316.shift, cljs.core.do_assoc.call(null, coll, this__4316.shift, this__4316.root, k, v), this__4316.tail)
    }
  }else {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, k, this__4316.cnt))) {
      return cljs.core._conj.call(null, coll, v)
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        throw new Error(cljs.core.str.call(null, "Index ", k, " out of bounds  [0,", this__4316.cnt, "]"));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$ = true;
cljs.core.PersistentVector.prototype.call = function() {
  var G__4357 = null;
  var G__4357__4358 = function(tsym4319, k) {
    var this__4321 = this;
    var tsym4319__4322 = this;
    var coll__4323 = tsym4319__4322;
    return cljs.core._lookup.call(null, coll__4323, k)
  };
  var G__4357__4359 = function(tsym4320, k, not_found) {
    var this__4324 = this;
    var tsym4320__4325 = this;
    var coll__4326 = tsym4320__4325;
    return cljs.core._lookup.call(null, coll__4326, k, not_found)
  };
  G__4357 = function(tsym4320, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4357__4358.call(this, tsym4320, k);
      case 3:
        return G__4357__4359.call(this, tsym4320, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4357
}();
cljs.core.PersistentVector.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4327 = this;
  if(cljs.core.truth_(this__4327.cnt - cljs.core.tail_off.call(null, coll) < 32)) {
    var new_tail__4328 = cljs.core.aclone.call(null, this__4327.tail);
    new_tail__4328.push(o);
    return new cljs.core.PersistentVector(this__4327.meta, this__4327.cnt + 1, this__4327.shift, this__4327.root, new_tail__4328)
  }else {
    var root_overflow_QMARK___4329 = this__4327.cnt >> 5 > 1 << this__4327.shift;
    var new_shift__4330 = cljs.core.truth_(root_overflow_QMARK___4329) ? this__4327.shift + 5 : this__4327.shift;
    var new_root__4332 = cljs.core.truth_(root_overflow_QMARK___4329) ? function() {
      var n_r__4331 = cljs.core.aclone.call(null, cljs.core.PersistentVector.EMPTY_NODE);
      n_r__4331[0] = this__4327.root;
      n_r__4331[1] = cljs.core.new_path.call(null, this__4327.shift, this__4327.tail);
      return n_r__4331
    }() : cljs.core.push_tail.call(null, coll, this__4327.shift, this__4327.root, this__4327.tail);
    return new cljs.core.PersistentVector(this__4327.meta, this__4327.cnt + 1, new_shift__4330, new_root__4332, [o])
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce = function() {
  var G__4361 = null;
  var G__4361__4362 = function(v, f) {
    var this__4333 = this;
    return cljs.core.ci_reduce.call(null, v, f)
  };
  var G__4361__4363 = function(v, f, start) {
    var this__4334 = this;
    return cljs.core.ci_reduce.call(null, v, f, start)
  };
  G__4361 = function(v, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4361__4362.call(this, v, f);
      case 3:
        return G__4361__4363.call(this, v, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4361
}();
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4335 = this;
  if(cljs.core.truth_(this__4335.cnt > 0)) {
    var vector_seq__4336 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(cljs.core.truth_(i < this__4335.cnt)) {
          return cljs.core.cons.call(null, cljs.core._nth.call(null, coll, i), vector_seq.call(null, i + 1))
        }else {
          return null
        }
      })
    };
    return vector_seq__4336.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4337 = this;
  return this__4337.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__4338 = this;
  if(cljs.core.truth_(this__4338.cnt > 0)) {
    return cljs.core._nth.call(null, coll, this__4338.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__4339 = this;
  if(cljs.core.truth_(this__4339.cnt === 0)) {
    throw new Error("Can't pop empty vector");
  }else {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, 1, this__4339.cnt))) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__4339.meta)
    }else {
      if(cljs.core.truth_(1 < this__4339.cnt - cljs.core.tail_off.call(null, coll))) {
        return new cljs.core.PersistentVector(this__4339.meta, this__4339.cnt - 1, this__4339.shift, this__4339.root, cljs.core.aclone.call(null, this__4339.tail))
      }else {
        if(cljs.core.truth_("\ufdd0'else")) {
          var new_tail__4340 = cljs.core.array_for.call(null, coll, this__4339.cnt - 2);
          var nr__4341 = cljs.core.pop_tail.call(null, this__4339.shift, this__4339.root);
          var new_root__4342 = cljs.core.truth_(nr__4341 === null) ? cljs.core.PersistentVector.EMPTY_NODE : nr__4341;
          var cnt_1__4343 = this__4339.cnt - 1;
          if(cljs.core.truth_(function() {
            var and__3546__auto____4344 = 5 < this__4339.shift;
            if(cljs.core.truth_(and__3546__auto____4344)) {
              return new_root__4342[1] === null
            }else {
              return and__3546__auto____4344
            }
          }())) {
            return new cljs.core.PersistentVector(this__4339.meta, cnt_1__4343, this__4339.shift - 5, new_root__4342[0], new_tail__4340)
          }else {
            return new cljs.core.PersistentVector(this__4339.meta, cnt_1__4343, this__4339.shift, new_root__4342, new_tail__4340)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n = function(coll, n, val) {
  var this__4345 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4346 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4347 = this;
  return new cljs.core.PersistentVector(meta, this__4347.cnt, this__4347.shift, this__4347.root, this__4347.tail)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4348 = this;
  return this__4348.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth = function() {
  var G__4365 = null;
  var G__4365__4366 = function(coll, n) {
    var this__4349 = this;
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  };
  var G__4365__4367 = function(coll, n, not_found) {
    var this__4350 = this;
    if(cljs.core.truth_(function() {
      var and__3546__auto____4351 = 0 <= n;
      if(cljs.core.truth_(and__3546__auto____4351)) {
        return n < this__4350.cnt
      }else {
        return and__3546__auto____4351
      }
    }())) {
      return cljs.core._nth.call(null, coll, n)
    }else {
      return not_found
    }
  };
  G__4365 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4365__4366.call(this, coll, n);
      case 3:
        return G__4365__4367.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4365
}();
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4352 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__4352.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = new Array(32);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, []);
cljs.core.PersistentVector.fromArray = function(xs) {
  return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, xs)
};
cljs.core.vec = function vec(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.PersistentVector.EMPTY, coll)
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__4369) {
    var args = cljs.core.seq(arglist__4369);
    return vector__delegate.call(this, args)
  };
  return vector
}();
cljs.core.Subvec = function(meta, v, start, end) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end
};
cljs.core.Subvec.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$ = true;
cljs.core.Subvec.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4370 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$ = true;
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4398 = null;
  var G__4398__4399 = function(coll, k) {
    var this__4371 = this;
    return cljs.core._nth.call(null, coll, k, null)
  };
  var G__4398__4400 = function(coll, k, not_found) {
    var this__4372 = this;
    return cljs.core._nth.call(null, coll, k, not_found)
  };
  G__4398 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4398__4399.call(this, coll, k);
      case 3:
        return G__4398__4400.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4398
}();
cljs.core.Subvec.prototype.cljs$core$IAssociative$ = true;
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc = function(coll, key, val) {
  var this__4373 = this;
  var v_pos__4374 = this__4373.start + key;
  return new cljs.core.Subvec(this__4373.meta, cljs.core._assoc.call(null, this__4373.v, v_pos__4374, val), this__4373.start, this__4373.end > v_pos__4374 + 1 ? this__4373.end : v_pos__4374 + 1)
};
cljs.core.Subvec.prototype.cljs$core$IFn$ = true;
cljs.core.Subvec.prototype.call = function() {
  var G__4402 = null;
  var G__4402__4403 = function(tsym4375, k) {
    var this__4377 = this;
    var tsym4375__4378 = this;
    var coll__4379 = tsym4375__4378;
    return cljs.core._lookup.call(null, coll__4379, k)
  };
  var G__4402__4404 = function(tsym4376, k, not_found) {
    var this__4380 = this;
    var tsym4376__4381 = this;
    var coll__4382 = tsym4376__4381;
    return cljs.core._lookup.call(null, coll__4382, k, not_found)
  };
  G__4402 = function(tsym4376, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4402__4403.call(this, tsym4376, k);
      case 3:
        return G__4402__4404.call(this, tsym4376, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4402
}();
cljs.core.Subvec.prototype.cljs$core$ISequential$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$ = true;
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4383 = this;
  return new cljs.core.Subvec(this__4383.meta, cljs.core._assoc_n.call(null, this__4383.v, this__4383.end, o), this__4383.start, this__4383.end + 1)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$ = true;
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce = function() {
  var G__4406 = null;
  var G__4406__4407 = function(coll, f) {
    var this__4384 = this;
    return cljs.core.ci_reduce.call(null, coll, f)
  };
  var G__4406__4408 = function(coll, f, start) {
    var this__4385 = this;
    return cljs.core.ci_reduce.call(null, coll, f, start)
  };
  G__4406 = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return G__4406__4407.call(this, coll, f);
      case 3:
        return G__4406__4408.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4406
}();
cljs.core.Subvec.prototype.cljs$core$ISeqable$ = true;
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4386 = this;
  var subvec_seq__4387 = function subvec_seq(i) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, i, this__4386.end))) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__4386.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }))
    }
  };
  return subvec_seq__4387.call(null, this__4386.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$ = true;
cljs.core.Subvec.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4388 = this;
  return this__4388.end - this__4388.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$ = true;
cljs.core.Subvec.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__4389 = this;
  return cljs.core._nth.call(null, this__4389.v, this__4389.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__4390 = this;
  if(cljs.core.truth_(cljs.core._EQ_.call(null, this__4390.start, this__4390.end))) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__4390.meta, this__4390.v, this__4390.start, this__4390.end - 1)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$ = true;
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n = function(coll, n, val) {
  var this__4391 = this;
  return cljs.core._assoc.call(null, coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$ = true;
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4392 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4393 = this;
  return new cljs.core.Subvec(meta, this__4393.v, this__4393.start, this__4393.end)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$ = true;
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4394 = this;
  return this__4394.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$ = true;
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth = function() {
  var G__4410 = null;
  var G__4410__4411 = function(coll, n) {
    var this__4395 = this;
    return cljs.core._nth.call(null, this__4395.v, this__4395.start + n)
  };
  var G__4410__4412 = function(coll, n, not_found) {
    var this__4396 = this;
    return cljs.core._nth.call(null, this__4396.v, this__4396.start + n, not_found)
  };
  G__4410 = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4410__4411.call(this, coll, n);
      case 3:
        return G__4410__4412.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4410
}();
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4397 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__4397.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__4414 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__4415 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__4414.call(this, v, start);
      case 3:
        return subvec__4415.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return subvec
}();
cljs.core.PersistentQueueSeq = function(meta, front, rear) {
  this.meta = meta;
  this.front = front;
  this.rear = rear
};
cljs.core.PersistentQueueSeq.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4417 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4418 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4419 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4420 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__4420.meta)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4421 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__4422 = this;
  return cljs.core._first.call(null, this__4422.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__4423 = this;
  var temp__3695__auto____4424 = cljs.core.next.call(null, this__4423.front);
  if(cljs.core.truth_(temp__3695__auto____4424)) {
    var f1__4425 = temp__3695__auto____4424;
    return new cljs.core.PersistentQueueSeq(this__4423.meta, f1__4425, this__4423.rear)
  }else {
    if(cljs.core.truth_(this__4423.rear === null)) {
      return cljs.core._empty.call(null, coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__4423.meta, this__4423.rear, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4426 = this;
  return this__4426.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4427 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__4427.front, this__4427.rear)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear
};
cljs.core.PersistentQueue.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4428 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISequential$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4429 = this;
  if(cljs.core.truth_(this__4429.front)) {
    return new cljs.core.PersistentQueue(this__4429.meta, this__4429.count + 1, this__4429.front, cljs.core.conj.call(null, function() {
      var or__3548__auto____4430 = this__4429.rear;
      if(cljs.core.truth_(or__3548__auto____4430)) {
        return or__3548__auto____4430
      }else {
        return cljs.core.PersistentVector.fromArray([])
      }
    }(), o))
  }else {
    return new cljs.core.PersistentQueue(this__4429.meta, this__4429.count + 1, cljs.core.conj.call(null, this__4429.front, o), cljs.core.PersistentVector.fromArray([]))
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4431 = this;
  var rear__4432 = cljs.core.seq.call(null, this__4431.rear);
  if(cljs.core.truth_(function() {
    var or__3548__auto____4433 = this__4431.front;
    if(cljs.core.truth_(or__3548__auto____4433)) {
      return or__3548__auto____4433
    }else {
      return rear__4432
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__4431.front, cljs.core.seq.call(null, rear__4432))
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4434 = this;
  return this__4434.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek = function(coll) {
  var this__4435 = this;
  return cljs.core._first.call(null, this__4435.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop = function(coll) {
  var this__4436 = this;
  if(cljs.core.truth_(this__4436.front)) {
    var temp__3695__auto____4437 = cljs.core.next.call(null, this__4436.front);
    if(cljs.core.truth_(temp__3695__auto____4437)) {
      var f1__4438 = temp__3695__auto____4437;
      return new cljs.core.PersistentQueue(this__4436.meta, this__4436.count - 1, f1__4438, this__4436.rear)
    }else {
      return new cljs.core.PersistentQueue(this__4436.meta, this__4436.count - 1, cljs.core.seq.call(null, this__4436.rear), cljs.core.PersistentVector.fromArray([]))
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first = function(coll) {
  var this__4439 = this;
  return cljs.core.first.call(null, this__4439.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest = function(coll) {
  var this__4440 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4441 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4442 = this;
  return new cljs.core.PersistentQueue(meta, this__4442.count, this__4442.front, this__4442.rear)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4443 = this;
  return this__4443.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4444 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.fromArray([]));
cljs.core.NeverEquiv = function() {
};
cljs.core.NeverEquiv.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$ = true;
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv = function(o, other) {
  var this__4445 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.truth_(cljs.core.map_QMARK_.call(null, y)) ? cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.count.call(null, x), cljs.core.count.call(null, y))) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core.get.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__4446 = array.length;
  var i__4447 = 0;
  while(true) {
    if(cljs.core.truth_(i__4447 < len__4446)) {
      if(cljs.core.truth_(cljs.core._EQ_.call(null, k, array[i__4447]))) {
        return i__4447
      }else {
        var G__4448 = i__4447 + incr;
        i__4447 = G__4448;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_contains_key_QMARK_ = function() {
  var obj_map_contains_key_QMARK_ = null;
  var obj_map_contains_key_QMARK___4450 = function(k, strobj) {
    return obj_map_contains_key_QMARK_.call(null, k, strobj, true, false)
  };
  var obj_map_contains_key_QMARK___4451 = function(k, strobj, true_val, false_val) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____4449 = goog.isString.call(null, k);
      if(cljs.core.truth_(and__3546__auto____4449)) {
        return strobj.hasOwnProperty(k)
      }else {
        return and__3546__auto____4449
      }
    }())) {
      return true_val
    }else {
      return false_val
    }
  };
  obj_map_contains_key_QMARK_ = function(k, strobj, true_val, false_val) {
    switch(arguments.length) {
      case 2:
        return obj_map_contains_key_QMARK___4450.call(this, k, strobj);
      case 4:
        return obj_map_contains_key_QMARK___4451.call(this, k, strobj, true_val, false_val)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return obj_map_contains_key_QMARK_
}();
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__4454 = cljs.core.hash.call(null, a);
  var b__4455 = cljs.core.hash.call(null, b);
  if(cljs.core.truth_(a__4454 < b__4455)) {
    return-1
  }else {
    if(cljs.core.truth_(a__4454 > b__4455)) {
      return 1
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.ObjMap = function(meta, keys, strobj) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj
};
cljs.core.ObjMap.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IHash$ = true;
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4456 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$ = true;
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4483 = null;
  var G__4483__4484 = function(coll, k) {
    var this__4457 = this;
    return cljs.core._lookup.call(null, coll, k, null)
  };
  var G__4483__4485 = function(coll, k, not_found) {
    var this__4458 = this;
    return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__4458.strobj, this__4458.strobj[k], not_found)
  };
  G__4483 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4483__4484.call(this, coll, k);
      case 3:
        return G__4483__4485.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4483
}();
cljs.core.ObjMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc = function(coll, k, v) {
  var this__4459 = this;
  if(cljs.core.truth_(goog.isString.call(null, k))) {
    var new_strobj__4460 = goog.object.clone.call(null, this__4459.strobj);
    var overwrite_QMARK___4461 = new_strobj__4460.hasOwnProperty(k);
    new_strobj__4460[k] = v;
    if(cljs.core.truth_(overwrite_QMARK___4461)) {
      return new cljs.core.ObjMap(this__4459.meta, this__4459.keys, new_strobj__4460)
    }else {
      var new_keys__4462 = cljs.core.aclone.call(null, this__4459.keys);
      new_keys__4462.push(k);
      return new cljs.core.ObjMap(this__4459.meta, new_keys__4462, new_strobj__4460)
    }
  }else {
    return cljs.core.with_meta.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null, k, v), cljs.core.seq.call(null, coll)), this__4459.meta)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_ = function(coll, k) {
  var this__4463 = this;
  return cljs.core.obj_map_contains_key_QMARK_.call(null, k, this__4463.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IFn$ = true;
cljs.core.ObjMap.prototype.call = function() {
  var G__4487 = null;
  var G__4487__4488 = function(tsym4464, k) {
    var this__4466 = this;
    var tsym4464__4467 = this;
    var coll__4468 = tsym4464__4467;
    return cljs.core._lookup.call(null, coll__4468, k)
  };
  var G__4487__4489 = function(tsym4465, k, not_found) {
    var this__4469 = this;
    var tsym4465__4470 = this;
    var coll__4471 = tsym4465__4470;
    return cljs.core._lookup.call(null, coll__4471, k, not_found)
  };
  G__4487 = function(tsym4465, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4487__4488.call(this, tsym4465, k);
      case 3:
        return G__4487__4489.call(this, tsym4465, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4487
}();
cljs.core.ObjMap.prototype.cljs$core$ICollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj = function(coll, entry) {
  var this__4472 = this;
  if(cljs.core.truth_(cljs.core.vector_QMARK_.call(null, entry))) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4473 = this;
  if(cljs.core.truth_(this__4473.keys.length > 0)) {
    return cljs.core.map.call(null, function(p1__4453_SHARP_) {
      return cljs.core.vector.call(null, p1__4453_SHARP_, this__4473.strobj[p1__4453_SHARP_])
    }, this__4473.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$ = true;
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4474 = this;
  return this__4474.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4475 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4476 = this;
  return new cljs.core.ObjMap(meta, this__4476.keys, this__4476.strobj)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4477 = this;
  return this__4477.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4478 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__4478.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$ = true;
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc = function(coll, k) {
  var this__4479 = this;
  if(cljs.core.truth_(function() {
    var and__3546__auto____4480 = goog.isString.call(null, k);
    if(cljs.core.truth_(and__3546__auto____4480)) {
      return this__4479.strobj.hasOwnProperty(k)
    }else {
      return and__3546__auto____4480
    }
  }())) {
    var new_keys__4481 = cljs.core.aclone.call(null, this__4479.keys);
    var new_strobj__4482 = goog.object.clone.call(null, this__4479.strobj);
    new_keys__4481.splice(cljs.core.scan_array.call(null, 1, k, new_keys__4481), 1);
    cljs.core.js_delete.call(null, new_strobj__4482, k);
    return new cljs.core.ObjMap(this__4479.meta, new_keys__4481, new_strobj__4482)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], cljs.core.js_obj.call(null));
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj)
};
cljs.core.HashMap = function(meta, count, hashobj) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj
};
cljs.core.HashMap.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$ = true;
cljs.core.HashMap.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4492 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$ = true;
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4530 = null;
  var G__4530__4531 = function(coll, k) {
    var this__4493 = this;
    return cljs.core._lookup.call(null, coll, k, null)
  };
  var G__4530__4532 = function(coll, k, not_found) {
    var this__4494 = this;
    var bucket__4495 = this__4494.hashobj[cljs.core.hash.call(null, k)];
    var i__4496 = cljs.core.truth_(bucket__4495) ? cljs.core.scan_array.call(null, 2, k, bucket__4495) : null;
    if(cljs.core.truth_(i__4496)) {
      return bucket__4495[i__4496 + 1]
    }else {
      return not_found
    }
  };
  G__4530 = function(coll, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4530__4531.call(this, coll, k);
      case 3:
        return G__4530__4532.call(this, coll, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4530
}();
cljs.core.HashMap.prototype.cljs$core$IAssociative$ = true;
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc = function(coll, k, v) {
  var this__4497 = this;
  var h__4498 = cljs.core.hash.call(null, k);
  var bucket__4499 = this__4497.hashobj[h__4498];
  if(cljs.core.truth_(bucket__4499)) {
    var new_bucket__4500 = cljs.core.aclone.call(null, bucket__4499);
    var new_hashobj__4501 = goog.object.clone.call(null, this__4497.hashobj);
    new_hashobj__4501[h__4498] = new_bucket__4500;
    var temp__3695__auto____4502 = cljs.core.scan_array.call(null, 2, k, new_bucket__4500);
    if(cljs.core.truth_(temp__3695__auto____4502)) {
      var i__4503 = temp__3695__auto____4502;
      new_bucket__4500[i__4503 + 1] = v;
      return new cljs.core.HashMap(this__4497.meta, this__4497.count, new_hashobj__4501)
    }else {
      new_bucket__4500.push(k, v);
      return new cljs.core.HashMap(this__4497.meta, this__4497.count + 1, new_hashobj__4501)
    }
  }else {
    var new_hashobj__4504 = goog.object.clone.call(null, this__4497.hashobj);
    new_hashobj__4504[h__4498] = [k, v];
    return new cljs.core.HashMap(this__4497.meta, this__4497.count + 1, new_hashobj__4504)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_ = function(coll, k) {
  var this__4505 = this;
  var bucket__4506 = this__4505.hashobj[cljs.core.hash.call(null, k)];
  var i__4507 = cljs.core.truth_(bucket__4506) ? cljs.core.scan_array.call(null, 2, k, bucket__4506) : null;
  if(cljs.core.truth_(i__4507)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.cljs$core$IFn$ = true;
cljs.core.HashMap.prototype.call = function() {
  var G__4534 = null;
  var G__4534__4535 = function(tsym4508, k) {
    var this__4510 = this;
    var tsym4508__4511 = this;
    var coll__4512 = tsym4508__4511;
    return cljs.core._lookup.call(null, coll__4512, k)
  };
  var G__4534__4536 = function(tsym4509, k, not_found) {
    var this__4513 = this;
    var tsym4509__4514 = this;
    var coll__4515 = tsym4509__4514;
    return cljs.core._lookup.call(null, coll__4515, k, not_found)
  };
  G__4534 = function(tsym4509, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4534__4535.call(this, tsym4509, k);
      case 3:
        return G__4534__4536.call(this, tsym4509, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4534
}();
cljs.core.HashMap.prototype.cljs$core$ICollection$ = true;
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj = function(coll, entry) {
  var this__4516 = this;
  if(cljs.core.truth_(cljs.core.vector_QMARK_.call(null, entry))) {
    return cljs.core._assoc.call(null, coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$ = true;
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4517 = this;
  if(cljs.core.truth_(this__4517.count > 0)) {
    var hashes__4518 = cljs.core.js_keys.call(null, this__4517.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__4491_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__4517.hashobj[p1__4491_SHARP_]))
    }, hashes__4518)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$ = true;
cljs.core.HashMap.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4519 = this;
  return this__4519.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$ = true;
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4520 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4521 = this;
  return new cljs.core.HashMap(meta, this__4521.count, this__4521.hashobj)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$ = true;
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4522 = this;
  return this__4522.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4523 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__4523.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$ = true;
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc = function(coll, k) {
  var this__4524 = this;
  var h__4525 = cljs.core.hash.call(null, k);
  var bucket__4526 = this__4524.hashobj[h__4525];
  var i__4527 = cljs.core.truth_(bucket__4526) ? cljs.core.scan_array.call(null, 2, k, bucket__4526) : null;
  if(cljs.core.truth_(cljs.core.not.call(null, i__4527))) {
    return coll
  }else {
    var new_hashobj__4528 = goog.object.clone.call(null, this__4524.hashobj);
    if(cljs.core.truth_(3 > bucket__4526.length)) {
      cljs.core.js_delete.call(null, new_hashobj__4528, h__4525)
    }else {
      var new_bucket__4529 = cljs.core.aclone.call(null, bucket__4526);
      new_bucket__4529.splice(i__4527, 2);
      new_hashobj__4528[h__4525] = new_bucket__4529
    }
    return new cljs.core.HashMap(this__4524.meta, this__4524.count - 1, new_hashobj__4528)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, cljs.core.js_obj.call(null));
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__4538 = ks.length;
  var i__4539 = 0;
  var out__4540 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(cljs.core.truth_(i__4539 < len__4538)) {
      var G__4541 = i__4539 + 1;
      var G__4542 = cljs.core.assoc.call(null, out__4540, ks[i__4539], vs[i__4539]);
      i__4539 = G__4541;
      out__4540 = G__4542;
      continue
    }else {
      return out__4540
    }
    break
  }
};
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in$__4543 = cljs.core.seq.call(null, keyvals);
    var out__4544 = cljs.core.HashMap.EMPTY;
    while(true) {
      if(cljs.core.truth_(in$__4543)) {
        var G__4545 = cljs.core.nnext.call(null, in$__4543);
        var G__4546 = cljs.core.assoc.call(null, out__4544, cljs.core.first.call(null, in$__4543), cljs.core.second.call(null, in$__4543));
        in$__4543 = G__4545;
        out__4544 = G__4546;
        continue
      }else {
        return out__4544
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__4547) {
    var keyvals = cljs.core.seq(arglist__4547);
    return hash_map__delegate.call(this, keyvals)
  };
  return hash_map
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__4548_SHARP_, p2__4549_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3548__auto____4550 = p1__4548_SHARP_;
          if(cljs.core.truth_(or__3548__auto____4550)) {
            return or__3548__auto____4550
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), p2__4549_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__4551) {
    var maps = cljs.core.seq(arglist__4551);
    return merge__delegate.call(this, maps)
  };
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__4554 = function(m, e) {
        var k__4552 = cljs.core.first.call(null, e);
        var v__4553 = cljs.core.second.call(null, e);
        if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, m, k__4552))) {
          return cljs.core.assoc.call(null, m, k__4552, f.call(null, cljs.core.get.call(null, m, k__4552), v__4553))
        }else {
          return cljs.core.assoc.call(null, m, k__4552, v__4553)
        }
      };
      var merge2__4556 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__4554, function() {
          var or__3548__auto____4555 = m1;
          if(cljs.core.truth_(or__3548__auto____4555)) {
            return or__3548__auto____4555
          }else {
            return cljs.core.ObjMap.fromObject([], {})
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__4556, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__4557) {
    var f = cljs.core.first(arglist__4557);
    var maps = cljs.core.rest(arglist__4557);
    return merge_with__delegate.call(this, f, maps)
  };
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__4559 = cljs.core.ObjMap.fromObject([], {});
  var keys__4560 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(cljs.core.truth_(keys__4560)) {
      var key__4561 = cljs.core.first.call(null, keys__4560);
      var entry__4562 = cljs.core.get.call(null, map, key__4561, "\ufdd0'user/not-found");
      var G__4563 = cljs.core.truth_(cljs.core.not_EQ_.call(null, entry__4562, "\ufdd0'user/not-found")) ? cljs.core.assoc.call(null, ret__4559, key__4561, entry__4562) : ret__4559;
      var G__4564 = cljs.core.next.call(null, keys__4560);
      ret__4559 = G__4563;
      keys__4560 = G__4564;
      continue
    }else {
      return ret__4559
    }
    break
  }
};
cljs.core.Set = function(meta, hash_map) {
  this.meta = meta;
  this.hash_map = hash_map
};
cljs.core.Set.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Set")
};
cljs.core.Set.prototype.cljs$core$IHash$ = true;
cljs.core.Set.prototype.cljs$core$IHash$_hash = function(coll) {
  var this__4565 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.Set.prototype.cljs$core$ILookup$ = true;
cljs.core.Set.prototype.cljs$core$ILookup$_lookup = function() {
  var G__4586 = null;
  var G__4586__4587 = function(coll, v) {
    var this__4566 = this;
    return cljs.core._lookup.call(null, coll, v, null)
  };
  var G__4586__4588 = function(coll, v, not_found) {
    var this__4567 = this;
    if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__4567.hash_map, v))) {
      return v
    }else {
      return not_found
    }
  };
  G__4586 = function(coll, v, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4586__4587.call(this, coll, v);
      case 3:
        return G__4586__4588.call(this, coll, v, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4586
}();
cljs.core.Set.prototype.cljs$core$IFn$ = true;
cljs.core.Set.prototype.call = function() {
  var G__4590 = null;
  var G__4590__4591 = function(tsym4568, k) {
    var this__4570 = this;
    var tsym4568__4571 = this;
    var coll__4572 = tsym4568__4571;
    return cljs.core._lookup.call(null, coll__4572, k)
  };
  var G__4590__4592 = function(tsym4569, k, not_found) {
    var this__4573 = this;
    var tsym4569__4574 = this;
    var coll__4575 = tsym4569__4574;
    return cljs.core._lookup.call(null, coll__4575, k, not_found)
  };
  G__4590 = function(tsym4569, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4590__4591.call(this, tsym4569, k);
      case 3:
        return G__4590__4592.call(this, tsym4569, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4590
}();
cljs.core.Set.prototype.cljs$core$ICollection$ = true;
cljs.core.Set.prototype.cljs$core$ICollection$_conj = function(coll, o) {
  var this__4576 = this;
  return new cljs.core.Set(this__4576.meta, cljs.core.assoc.call(null, this__4576.hash_map, o, null))
};
cljs.core.Set.prototype.cljs$core$ISeqable$ = true;
cljs.core.Set.prototype.cljs$core$ISeqable$_seq = function(coll) {
  var this__4577 = this;
  return cljs.core.keys.call(null, this__4577.hash_map)
};
cljs.core.Set.prototype.cljs$core$ISet$ = true;
cljs.core.Set.prototype.cljs$core$ISet$_disjoin = function(coll, v) {
  var this__4578 = this;
  return new cljs.core.Set(this__4578.meta, cljs.core.dissoc.call(null, this__4578.hash_map, v))
};
cljs.core.Set.prototype.cljs$core$ICounted$ = true;
cljs.core.Set.prototype.cljs$core$ICounted$_count = function(coll) {
  var this__4579 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.Set.prototype.cljs$core$IEquiv$ = true;
cljs.core.Set.prototype.cljs$core$IEquiv$_equiv = function(coll, other) {
  var this__4580 = this;
  var and__3546__auto____4581 = cljs.core.set_QMARK_.call(null, other);
  if(cljs.core.truth_(and__3546__auto____4581)) {
    var and__3546__auto____4582 = cljs.core._EQ_.call(null, cljs.core.count.call(null, coll), cljs.core.count.call(null, other));
    if(cljs.core.truth_(and__3546__auto____4582)) {
      return cljs.core.every_QMARK_.call(null, function(p1__4558_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__4558_SHARP_)
      }, other)
    }else {
      return and__3546__auto____4582
    }
  }else {
    return and__3546__auto____4581
  }
};
cljs.core.Set.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Set.prototype.cljs$core$IWithMeta$_with_meta = function(coll, meta) {
  var this__4583 = this;
  return new cljs.core.Set(meta, this__4583.hash_map)
};
cljs.core.Set.prototype.cljs$core$IMeta$ = true;
cljs.core.Set.prototype.cljs$core$IMeta$_meta = function(coll) {
  var this__4584 = this;
  return this__4584.meta
};
cljs.core.Set.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Set.prototype.cljs$core$IEmptyableCollection$_empty = function(coll) {
  var this__4585 = this;
  return cljs.core.with_meta.call(null, cljs.core.Set.EMPTY, this__4585.meta)
};
cljs.core.Set;
cljs.core.Set.EMPTY = new cljs.core.Set(null, cljs.core.hash_map.call(null));
cljs.core.set = function set(coll) {
  var in$__4595 = cljs.core.seq.call(null, coll);
  var out__4596 = cljs.core.Set.EMPTY;
  while(true) {
    if(cljs.core.truth_(cljs.core.not.call(null, cljs.core.empty_QMARK_.call(null, in$__4595)))) {
      var G__4597 = cljs.core.rest.call(null, in$__4595);
      var G__4598 = cljs.core.conj.call(null, out__4596, cljs.core.first.call(null, in$__4595));
      in$__4595 = G__4597;
      out__4596 = G__4598;
      continue
    }else {
      return out__4596
    }
    break
  }
};
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.truth_(cljs.core.vector_QMARK_.call(null, coll))) {
    var n__4599 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3695__auto____4600 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3695__auto____4600)) {
        var e__4601 = temp__3695__auto____4600;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__4601))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__4599, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__4594_SHARP_) {
      var temp__3695__auto____4602 = cljs.core.find.call(null, smap, p1__4594_SHARP_);
      if(cljs.core.truth_(temp__3695__auto____4602)) {
        var e__4603 = temp__3695__auto____4602;
        return cljs.core.second.call(null, e__4603)
      }else {
        return p1__4594_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__4611 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__4604, seen) {
        while(true) {
          var vec__4605__4606 = p__4604;
          var f__4607 = cljs.core.nth.call(null, vec__4605__4606, 0, null);
          var xs__4608 = vec__4605__4606;
          var temp__3698__auto____4609 = cljs.core.seq.call(null, xs__4608);
          if(cljs.core.truth_(temp__3698__auto____4609)) {
            var s__4610 = temp__3698__auto____4609;
            if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, seen, f__4607))) {
              var G__4612 = cljs.core.rest.call(null, s__4610);
              var G__4613 = seen;
              p__4604 = G__4612;
              seen = G__4613;
              continue
            }else {
              return cljs.core.cons.call(null, f__4607, step.call(null, cljs.core.rest.call(null, s__4610), cljs.core.conj.call(null, seen, f__4607)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    })
  };
  return step__4611.call(null, coll, cljs.core.set([]))
};
cljs.core.butlast = function butlast(s) {
  var ret__4614 = cljs.core.PersistentVector.fromArray([]);
  var s__4615 = s;
  while(true) {
    if(cljs.core.truth_(cljs.core.next.call(null, s__4615))) {
      var G__4616 = cljs.core.conj.call(null, ret__4614, cljs.core.first.call(null, s__4615));
      var G__4617 = cljs.core.next.call(null, s__4615);
      ret__4614 = G__4616;
      s__4615 = G__4617;
      continue
    }else {
      return cljs.core.seq.call(null, ret__4614)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.truth_(cljs.core.string_QMARK_.call(null, x))) {
    return x
  }else {
    if(cljs.core.truth_(function() {
      var or__3548__auto____4618 = cljs.core.keyword_QMARK_.call(null, x);
      if(cljs.core.truth_(or__3548__auto____4618)) {
        return or__3548__auto____4618
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }())) {
      var i__4619 = x.lastIndexOf("/");
      if(cljs.core.truth_(i__4619 < 0)) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__4619 + 1)
      }
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        throw new Error(cljs.core.str.call(null, "Doesn't support name: ", x));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(cljs.core.truth_(function() {
    var or__3548__auto____4620 = cljs.core.keyword_QMARK_.call(null, x);
    if(cljs.core.truth_(or__3548__auto____4620)) {
      return or__3548__auto____4620
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }())) {
    var i__4621 = x.lastIndexOf("/");
    if(cljs.core.truth_(i__4621 > -1)) {
      return cljs.core.subs.call(null, x, 2, i__4621)
    }else {
      return null
    }
  }else {
    throw new Error(cljs.core.str.call(null, "Doesn't support namespace: ", x));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__4624 = cljs.core.ObjMap.fromObject([], {});
  var ks__4625 = cljs.core.seq.call(null, keys);
  var vs__4626 = cljs.core.seq.call(null, vals);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3546__auto____4627 = ks__4625;
      if(cljs.core.truth_(and__3546__auto____4627)) {
        return vs__4626
      }else {
        return and__3546__auto____4627
      }
    }())) {
      var G__4628 = cljs.core.assoc.call(null, map__4624, cljs.core.first.call(null, ks__4625), cljs.core.first.call(null, vs__4626));
      var G__4629 = cljs.core.next.call(null, ks__4625);
      var G__4630 = cljs.core.next.call(null, vs__4626);
      map__4624 = G__4628;
      ks__4625 = G__4629;
      vs__4626 = G__4630;
      continue
    }else {
      return map__4624
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__4633 = function(k, x) {
    return x
  };
  var max_key__4634 = function(k, x, y) {
    if(cljs.core.truth_(k.call(null, x) > k.call(null, y))) {
      return x
    }else {
      return y
    }
  };
  var max_key__4635 = function() {
    var G__4637__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__4622_SHARP_, p2__4623_SHARP_) {
        return max_key.call(null, k, p1__4622_SHARP_, p2__4623_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__4637 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4637__delegate.call(this, k, x, y, more)
    };
    G__4637.cljs$lang$maxFixedArity = 3;
    G__4637.cljs$lang$applyTo = function(arglist__4638) {
      var k = cljs.core.first(arglist__4638);
      var x = cljs.core.first(cljs.core.next(arglist__4638));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4638)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4638)));
      return G__4637__delegate.call(this, k, x, y, more)
    };
    return G__4637
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__4633.call(this, k, x);
      case 3:
        return max_key__4634.call(this, k, x, y);
      default:
        return max_key__4635.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4635.cljs$lang$applyTo;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__4639 = function(k, x) {
    return x
  };
  var min_key__4640 = function(k, x, y) {
    if(cljs.core.truth_(k.call(null, x) < k.call(null, y))) {
      return x
    }else {
      return y
    }
  };
  var min_key__4641 = function() {
    var G__4643__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__4631_SHARP_, p2__4632_SHARP_) {
        return min_key.call(null, k, p1__4631_SHARP_, p2__4632_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__4643 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4643__delegate.call(this, k, x, y, more)
    };
    G__4643.cljs$lang$maxFixedArity = 3;
    G__4643.cljs$lang$applyTo = function(arglist__4644) {
      var k = cljs.core.first(arglist__4644);
      var x = cljs.core.first(cljs.core.next(arglist__4644));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4644)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4644)));
      return G__4643__delegate.call(this, k, x, y, more)
    };
    return G__4643
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__4639.call(this, k, x);
      case 3:
        return min_key__4640.call(this, k, x, y);
      default:
        return min_key__4641.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4641.cljs$lang$applyTo;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__4647 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__4648 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4645 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4645)) {
        var s__4646 = temp__3698__auto____4645;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__4646), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__4646)))
      }else {
        return null
      }
    })
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__4647.call(this, n, step);
      case 3:
        return partition_all__4648.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4650 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4650)) {
      var s__4651 = temp__3698__auto____4650;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__4651)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__4651), take_while.call(null, pred, cljs.core.rest.call(null, s__4651)))
      }else {
        return null
      }
    }else {
      return null
    }
  })
};
cljs.core.Range = function(meta, start, end, step) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step
};
cljs.core.Range.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Range")
};
cljs.core.Range.prototype.cljs$core$IHash$ = true;
cljs.core.Range.prototype.cljs$core$IHash$_hash = function(rng) {
  var this__4652 = this;
  return cljs.core.hash_coll.call(null, rng)
};
cljs.core.Range.prototype.cljs$core$ISequential$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$ = true;
cljs.core.Range.prototype.cljs$core$ICollection$_conj = function(rng, o) {
  var this__4653 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.cljs$core$IReduce$ = true;
cljs.core.Range.prototype.cljs$core$IReduce$_reduce = function() {
  var G__4669 = null;
  var G__4669__4670 = function(rng, f) {
    var this__4654 = this;
    return cljs.core.ci_reduce.call(null, rng, f)
  };
  var G__4669__4671 = function(rng, f, s) {
    var this__4655 = this;
    return cljs.core.ci_reduce.call(null, rng, f, s)
  };
  G__4669 = function(rng, f, s) {
    switch(arguments.length) {
      case 2:
        return G__4669__4670.call(this, rng, f);
      case 3:
        return G__4669__4671.call(this, rng, f, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4669
}();
cljs.core.Range.prototype.cljs$core$ISeqable$ = true;
cljs.core.Range.prototype.cljs$core$ISeqable$_seq = function(rng) {
  var this__4656 = this;
  var comp__4657 = cljs.core.truth_(this__4656.step > 0) ? cljs.core._LT_ : cljs.core._GT_;
  if(cljs.core.truth_(comp__4657.call(null, this__4656.start, this__4656.end))) {
    return rng
  }else {
    return null
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$ = true;
cljs.core.Range.prototype.cljs$core$ICounted$_count = function(rng) {
  var this__4658 = this;
  if(cljs.core.truth_(cljs.core.not.call(null, cljs.core._seq.call(null, rng)))) {
    return 0
  }else {
    return Math["ceil"].call(null, (this__4658.end - this__4658.start) / this__4658.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$ = true;
cljs.core.Range.prototype.cljs$core$ISeq$_first = function(rng) {
  var this__4659 = this;
  return this__4659.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest = function(rng) {
  var this__4660 = this;
  if(cljs.core.truth_(cljs.core._seq.call(null, rng))) {
    return new cljs.core.Range(this__4660.meta, this__4660.start + this__4660.step, this__4660.end, this__4660.step)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$ = true;
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv = function(rng, other) {
  var this__4661 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$ = true;
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta = function(rng, meta) {
  var this__4662 = this;
  return new cljs.core.Range(meta, this__4662.start, this__4662.end, this__4662.step)
};
cljs.core.Range.prototype.cljs$core$IMeta$ = true;
cljs.core.Range.prototype.cljs$core$IMeta$_meta = function(rng) {
  var this__4663 = this;
  return this__4663.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$ = true;
cljs.core.Range.prototype.cljs$core$IIndexed$_nth = function() {
  var G__4673 = null;
  var G__4673__4674 = function(rng, n) {
    var this__4664 = this;
    if(cljs.core.truth_(n < cljs.core._count.call(null, rng))) {
      return this__4664.start + n * this__4664.step
    }else {
      if(cljs.core.truth_(function() {
        var and__3546__auto____4665 = this__4664.start > this__4664.end;
        if(cljs.core.truth_(and__3546__auto____4665)) {
          return cljs.core._EQ_.call(null, this__4664.step, 0)
        }else {
          return and__3546__auto____4665
        }
      }())) {
        return this__4664.start
      }else {
        throw new Error("Index out of bounds");
      }
    }
  };
  var G__4673__4675 = function(rng, n, not_found) {
    var this__4666 = this;
    if(cljs.core.truth_(n < cljs.core._count.call(null, rng))) {
      return this__4666.start + n * this__4666.step
    }else {
      if(cljs.core.truth_(function() {
        var and__3546__auto____4667 = this__4666.start > this__4666.end;
        if(cljs.core.truth_(and__3546__auto____4667)) {
          return cljs.core._EQ_.call(null, this__4666.step, 0)
        }else {
          return and__3546__auto____4667
        }
      }())) {
        return this__4666.start
      }else {
        return not_found
      }
    }
  };
  G__4673 = function(rng, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4673__4674.call(this, rng, n);
      case 3:
        return G__4673__4675.call(this, rng, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__4673
}();
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$ = true;
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty = function(rng) {
  var this__4668 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__4668.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__4677 = function() {
    return range.call(null, 0, Number["MAX_VALUE"], 1)
  };
  var range__4678 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__4679 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__4680 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__4677.call(this);
      case 1:
        return range__4678.call(this, start);
      case 2:
        return range__4679.call(this, start, end);
      case 3:
        return range__4680.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4682 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4682)) {
      var s__4683 = temp__3698__auto____4682;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__4683), take_nth.call(null, n, cljs.core.drop.call(null, n, s__4683)))
    }else {
      return null
    }
  })
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)])
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3698__auto____4685 = cljs.core.seq.call(null, coll);
    if(cljs.core.truth_(temp__3698__auto____4685)) {
      var s__4686 = temp__3698__auto____4685;
      var fst__4687 = cljs.core.first.call(null, s__4686);
      var fv__4688 = f.call(null, fst__4687);
      var run__4689 = cljs.core.cons.call(null, fst__4687, cljs.core.take_while.call(null, function(p1__4684_SHARP_) {
        return cljs.core._EQ_.call(null, fv__4688, f.call(null, p1__4684_SHARP_))
      }, cljs.core.next.call(null, s__4686)));
      return cljs.core.cons.call(null, run__4689, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__4689), s__4686))))
    }else {
      return null
    }
  })
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc.call(null, counts, x, cljs.core.get.call(null, counts, x, 0) + 1)
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__4704 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3695__auto____4700 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3695__auto____4700)) {
        var s__4701 = temp__3695__auto____4700;
        return reductions.call(null, f, cljs.core.first.call(null, s__4701), cljs.core.rest.call(null, s__4701))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    })
  };
  var reductions__4705 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3698__auto____4702 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(temp__3698__auto____4702)) {
        var s__4703 = temp__3698__auto____4702;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__4703)), cljs.core.rest.call(null, s__4703))
      }else {
        return null
      }
    }))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__4704.call(this, f, init);
      case 3:
        return reductions__4705.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__4708 = function(f) {
    return function() {
      var G__4713 = null;
      var G__4713__4714 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__4713__4715 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__4713__4716 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__4713__4717 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__4713__4718 = function() {
        var G__4720__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__4720 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4720__delegate.call(this, x, y, z, args)
        };
        G__4720.cljs$lang$maxFixedArity = 3;
        G__4720.cljs$lang$applyTo = function(arglist__4721) {
          var x = cljs.core.first(arglist__4721);
          var y = cljs.core.first(cljs.core.next(arglist__4721));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4721)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4721)));
          return G__4720__delegate.call(this, x, y, z, args)
        };
        return G__4720
      }();
      G__4713 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__4713__4714.call(this);
          case 1:
            return G__4713__4715.call(this, x);
          case 2:
            return G__4713__4716.call(this, x, y);
          case 3:
            return G__4713__4717.call(this, x, y, z);
          default:
            return G__4713__4718.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__4713.cljs$lang$maxFixedArity = 3;
      G__4713.cljs$lang$applyTo = G__4713__4718.cljs$lang$applyTo;
      return G__4713
    }()
  };
  var juxt__4709 = function(f, g) {
    return function() {
      var G__4722 = null;
      var G__4722__4723 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__4722__4724 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__4722__4725 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__4722__4726 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__4722__4727 = function() {
        var G__4729__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__4729 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4729__delegate.call(this, x, y, z, args)
        };
        G__4729.cljs$lang$maxFixedArity = 3;
        G__4729.cljs$lang$applyTo = function(arglist__4730) {
          var x = cljs.core.first(arglist__4730);
          var y = cljs.core.first(cljs.core.next(arglist__4730));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4730)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4730)));
          return G__4729__delegate.call(this, x, y, z, args)
        };
        return G__4729
      }();
      G__4722 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__4722__4723.call(this);
          case 1:
            return G__4722__4724.call(this, x);
          case 2:
            return G__4722__4725.call(this, x, y);
          case 3:
            return G__4722__4726.call(this, x, y, z);
          default:
            return G__4722__4727.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__4722.cljs$lang$maxFixedArity = 3;
      G__4722.cljs$lang$applyTo = G__4722__4727.cljs$lang$applyTo;
      return G__4722
    }()
  };
  var juxt__4710 = function(f, g, h) {
    return function() {
      var G__4731 = null;
      var G__4731__4732 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__4731__4733 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__4731__4734 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__4731__4735 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__4731__4736 = function() {
        var G__4738__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__4738 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__4738__delegate.call(this, x, y, z, args)
        };
        G__4738.cljs$lang$maxFixedArity = 3;
        G__4738.cljs$lang$applyTo = function(arglist__4739) {
          var x = cljs.core.first(arglist__4739);
          var y = cljs.core.first(cljs.core.next(arglist__4739));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4739)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4739)));
          return G__4738__delegate.call(this, x, y, z, args)
        };
        return G__4738
      }();
      G__4731 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__4731__4732.call(this);
          case 1:
            return G__4731__4733.call(this, x);
          case 2:
            return G__4731__4734.call(this, x, y);
          case 3:
            return G__4731__4735.call(this, x, y, z);
          default:
            return G__4731__4736.apply(this, arguments)
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__4731.cljs$lang$maxFixedArity = 3;
      G__4731.cljs$lang$applyTo = G__4731__4736.cljs$lang$applyTo;
      return G__4731
    }()
  };
  var juxt__4711 = function() {
    var G__4740__delegate = function(f, g, h, fs) {
      var fs__4707 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__4741 = null;
        var G__4741__4742 = function() {
          return cljs.core.reduce.call(null, function(p1__4690_SHARP_, p2__4691_SHARP_) {
            return cljs.core.conj.call(null, p1__4690_SHARP_, p2__4691_SHARP_.call(null))
          }, cljs.core.PersistentVector.fromArray([]), fs__4707)
        };
        var G__4741__4743 = function(x) {
          return cljs.core.reduce.call(null, function(p1__4692_SHARP_, p2__4693_SHARP_) {
            return cljs.core.conj.call(null, p1__4692_SHARP_, p2__4693_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.fromArray([]), fs__4707)
        };
        var G__4741__4744 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__4694_SHARP_, p2__4695_SHARP_) {
            return cljs.core.conj.call(null, p1__4694_SHARP_, p2__4695_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.fromArray([]), fs__4707)
        };
        var G__4741__4745 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__4696_SHARP_, p2__4697_SHARP_) {
            return cljs.core.conj.call(null, p1__4696_SHARP_, p2__4697_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.fromArray([]), fs__4707)
        };
        var G__4741__4746 = function() {
          var G__4748__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__4698_SHARP_, p2__4699_SHARP_) {
              return cljs.core.conj.call(null, p1__4698_SHARP_, cljs.core.apply.call(null, p2__4699_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.fromArray([]), fs__4707)
          };
          var G__4748 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__4748__delegate.call(this, x, y, z, args)
          };
          G__4748.cljs$lang$maxFixedArity = 3;
          G__4748.cljs$lang$applyTo = function(arglist__4749) {
            var x = cljs.core.first(arglist__4749);
            var y = cljs.core.first(cljs.core.next(arglist__4749));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4749)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4749)));
            return G__4748__delegate.call(this, x, y, z, args)
          };
          return G__4748
        }();
        G__4741 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__4741__4742.call(this);
            case 1:
              return G__4741__4743.call(this, x);
            case 2:
              return G__4741__4744.call(this, x, y);
            case 3:
              return G__4741__4745.call(this, x, y, z);
            default:
              return G__4741__4746.apply(this, arguments)
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__4741.cljs$lang$maxFixedArity = 3;
        G__4741.cljs$lang$applyTo = G__4741__4746.cljs$lang$applyTo;
        return G__4741
      }()
    };
    var G__4740 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__4740__delegate.call(this, f, g, h, fs)
    };
    G__4740.cljs$lang$maxFixedArity = 3;
    G__4740.cljs$lang$applyTo = function(arglist__4750) {
      var f = cljs.core.first(arglist__4750);
      var g = cljs.core.first(cljs.core.next(arglist__4750));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4750)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__4750)));
      return G__4740__delegate.call(this, f, g, h, fs)
    };
    return G__4740
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__4708.call(this, f);
      case 2:
        return juxt__4709.call(this, f, g);
      case 3:
        return juxt__4710.call(this, f, g, h);
      default:
        return juxt__4711.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4711.cljs$lang$applyTo;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__4752 = function(coll) {
    while(true) {
      if(cljs.core.truth_(cljs.core.seq.call(null, coll))) {
        var G__4755 = cljs.core.next.call(null, coll);
        coll = G__4755;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__4753 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3546__auto____4751 = cljs.core.seq.call(null, coll);
        if(cljs.core.truth_(and__3546__auto____4751)) {
          return n > 0
        }else {
          return and__3546__auto____4751
        }
      }())) {
        var G__4756 = n - 1;
        var G__4757 = cljs.core.next.call(null, coll);
        n = G__4756;
        coll = G__4757;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__4752.call(this, n);
      case 2:
        return dorun__4753.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__4758 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__4759 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__4758.call(this, n);
      case 2:
        return doall__4759.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return doall
}();
cljs.core.re_matches = function re_matches(re, s) {
  var matches__4761 = re.exec(s);
  if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__4761), s))) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.count.call(null, matches__4761), 1))) {
      return cljs.core.first.call(null, matches__4761)
    }else {
      return cljs.core.vec.call(null, matches__4761)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__4762 = re.exec(s);
  if(cljs.core.truth_(matches__4762 === null)) {
    return null
  }else {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.count.call(null, matches__4762), 1))) {
      return cljs.core.first.call(null, matches__4762)
    }else {
      return cljs.core.vec.call(null, matches__4762)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__4763 = cljs.core.re_find.call(null, re, s);
  var match_idx__4764 = s.search(re);
  var match_str__4765 = cljs.core.truth_(cljs.core.coll_QMARK_.call(null, match_data__4763)) ? cljs.core.first.call(null, match_data__4763) : match_data__4763;
  var post_match__4766 = cljs.core.subs.call(null, s, match_idx__4764 + cljs.core.count.call(null, match_str__4765));
  if(cljs.core.truth_(match_data__4763)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__4763, re_seq.call(null, re, post_match__4766))
    })
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__4768__4769 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___4770 = cljs.core.nth.call(null, vec__4768__4769, 0, null);
  var flags__4771 = cljs.core.nth.call(null, vec__4768__4769, 1, null);
  var pattern__4772 = cljs.core.nth.call(null, vec__4768__4769, 2, null);
  return new RegExp(pattern__4772, flags__4771)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin]), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep]), cljs.core.map.call(null, function(p1__4767_SHARP_) {
    return print_one.call(null, p1__4767_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end]))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(cljs.core.truth_(obj === null)) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(cljs.core.truth_(void 0 === obj)) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3546__auto____4773 = cljs.core.get.call(null, opts, "\ufdd0'meta");
          if(cljs.core.truth_(and__3546__auto____4773)) {
            var and__3546__auto____4777 = function() {
              var x__451__auto____4774 = obj;
              if(cljs.core.truth_(function() {
                var and__3546__auto____4775 = x__451__auto____4774;
                if(cljs.core.truth_(and__3546__auto____4775)) {
                  var and__3546__auto____4776 = x__451__auto____4774.cljs$core$IMeta$;
                  if(cljs.core.truth_(and__3546__auto____4776)) {
                    return cljs.core.not.call(null, x__451__auto____4774.hasOwnProperty("cljs$core$IMeta$"))
                  }else {
                    return and__3546__auto____4776
                  }
                }else {
                  return and__3546__auto____4775
                }
              }())) {
                return true
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, x__451__auto____4774)
              }
            }();
            if(cljs.core.truth_(and__3546__auto____4777)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3546__auto____4777
            }
          }else {
            return and__3546__auto____4773
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"]), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "])) : null, cljs.core.truth_(function() {
          var x__451__auto____4778 = obj;
          if(cljs.core.truth_(function() {
            var and__3546__auto____4779 = x__451__auto____4778;
            if(cljs.core.truth_(and__3546__auto____4779)) {
              var and__3546__auto____4780 = x__451__auto____4778.cljs$core$IPrintable$;
              if(cljs.core.truth_(and__3546__auto____4780)) {
                return cljs.core.not.call(null, x__451__auto____4778.hasOwnProperty("cljs$core$IPrintable$"))
              }else {
                return and__3546__auto____4780
              }
            }else {
              return and__3546__auto____4779
            }
          }())) {
            return true
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, x__451__auto____4778)
          }
        }()) ? cljs.core._pr_seq.call(null, obj, opts) : cljs.core.list.call(null, "#<", cljs.core.str.call(null, obj), ">"))
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var first_obj__4781 = cljs.core.first.call(null, objs);
  var sb__4782 = new goog.string.StringBuffer;
  var G__4783__4784 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__4783__4784)) {
    var obj__4785 = cljs.core.first.call(null, G__4783__4784);
    var G__4783__4786 = G__4783__4784;
    while(true) {
      if(cljs.core.truth_(obj__4785 === first_obj__4781)) {
      }else {
        sb__4782.append(" ")
      }
      var G__4787__4788 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__4785, opts));
      if(cljs.core.truth_(G__4787__4788)) {
        var string__4789 = cljs.core.first.call(null, G__4787__4788);
        var G__4787__4790 = G__4787__4788;
        while(true) {
          sb__4782.append(string__4789);
          var temp__3698__auto____4791 = cljs.core.next.call(null, G__4787__4790);
          if(cljs.core.truth_(temp__3698__auto____4791)) {
            var G__4787__4792 = temp__3698__auto____4791;
            var G__4795 = cljs.core.first.call(null, G__4787__4792);
            var G__4796 = G__4787__4792;
            string__4789 = G__4795;
            G__4787__4790 = G__4796;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____4793 = cljs.core.next.call(null, G__4783__4786);
      if(cljs.core.truth_(temp__3698__auto____4793)) {
        var G__4783__4794 = temp__3698__auto____4793;
        var G__4797 = cljs.core.first.call(null, G__4783__4794);
        var G__4798 = G__4783__4794;
        obj__4785 = G__4797;
        G__4783__4786 = G__4798;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__4782
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return cljs.core.str.call(null, cljs.core.pr_sb.call(null, objs, opts))
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__4799 = cljs.core.pr_sb.call(null, objs, opts);
  sb__4799.append("\n");
  return cljs.core.str.call(null, sb__4799)
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var first_obj__4800 = cljs.core.first.call(null, objs);
  var G__4801__4802 = cljs.core.seq.call(null, objs);
  if(cljs.core.truth_(G__4801__4802)) {
    var obj__4803 = cljs.core.first.call(null, G__4801__4802);
    var G__4801__4804 = G__4801__4802;
    while(true) {
      if(cljs.core.truth_(obj__4803 === first_obj__4800)) {
      }else {
        cljs.core.string_print.call(null, " ")
      }
      var G__4805__4806 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__4803, opts));
      if(cljs.core.truth_(G__4805__4806)) {
        var string__4807 = cljs.core.first.call(null, G__4805__4806);
        var G__4805__4808 = G__4805__4806;
        while(true) {
          cljs.core.string_print.call(null, string__4807);
          var temp__3698__auto____4809 = cljs.core.next.call(null, G__4805__4808);
          if(cljs.core.truth_(temp__3698__auto____4809)) {
            var G__4805__4810 = temp__3698__auto____4809;
            var G__4813 = cljs.core.first.call(null, G__4805__4810);
            var G__4814 = G__4805__4810;
            string__4807 = G__4813;
            G__4805__4808 = G__4814;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3698__auto____4811 = cljs.core.next.call(null, G__4801__4804);
      if(cljs.core.truth_(temp__3698__auto____4811)) {
        var G__4801__4812 = temp__3698__auto____4811;
        var G__4815 = cljs.core.first.call(null, G__4801__4812);
        var G__4816 = G__4801__4812;
        obj__4803 = G__4815;
        G__4801__4804 = G__4816;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core.get.call(null, opts, "\ufdd0'flush-on-newline"))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__4817) {
    var objs = cljs.core.seq(arglist__4817);
    return pr_str__delegate.call(this, objs)
  };
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__4818) {
    var objs = cljs.core.seq(arglist__4818);
    return prn_str__delegate.call(this, objs)
  };
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__4819) {
    var objs = cljs.core.seq(arglist__4819);
    return pr__delegate.call(this, objs)
  };
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__4820) {
    var objs = cljs.core.seq(arglist__4820);
    return cljs_core_print__delegate.call(this, objs)
  };
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__4821) {
    var objs = cljs.core.seq(arglist__4821);
    return print_str__delegate.call(this, objs)
  };
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__4822) {
    var objs = cljs.core.seq(arglist__4822);
    return println__delegate.call(this, objs)
  };
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__4823) {
    var objs = cljs.core.seq(arglist__4823);
    return println_str__delegate.call(this, objs)
  };
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__4824) {
    var objs = cljs.core.seq(arglist__4824);
    return prn__delegate.call(this, objs)
  };
  return prn
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  var pr_pair__4825 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__4825, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, cljs.core.str.call(null, n))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, cljs.core.str.call(null, bool))
};
cljs.core.Set.prototype.cljs$core$IPrintable$ = true;
cljs.core.Set.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.truth_(cljs.core.keyword_QMARK_.call(null, obj))) {
    return cljs.core.list.call(null, cljs.core.str.call(null, ":", function() {
      var temp__3698__auto____4826 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3698__auto____4826)) {
        var nspc__4827 = temp__3698__auto____4826;
        return cljs.core.str.call(null, nspc__4827, "/")
      }else {
        return null
      }
    }(), cljs.core.name.call(null, obj)))
  }else {
    if(cljs.core.truth_(cljs.core.symbol_QMARK_.call(null, obj))) {
      return cljs.core.list.call(null, cljs.core.str.call(null, function() {
        var temp__3698__auto____4828 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3698__auto____4828)) {
          var nspc__4829 = temp__3698__auto____4828;
          return cljs.core.str.call(null, nspc__4829, "/")
        }else {
          return null
        }
      }(), cljs.core.name.call(null, obj)))
    }else {
      if(cljs.core.truth_("\ufdd0'else")) {
        return cljs.core.list.call(null, cljs.core.truth_("\ufdd0'readably".call(null, opts)) ? goog.string.quote.call(null, obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", cljs.core.str.call(null, this$), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq = function(coll, opts) {
  var pr_pair__4830 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__4830, "{", ", ", "}", opts, coll)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches
};
cljs.core.Atom.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$ = true;
cljs.core.Atom.prototype.cljs$core$IHash$_hash = function(this$) {
  var this__4831 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$ = true;
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches = function(this$, oldval, newval) {
  var this__4832 = this;
  var G__4833__4834 = cljs.core.seq.call(null, this__4832.watches);
  if(cljs.core.truth_(G__4833__4834)) {
    var G__4836__4838 = cljs.core.first.call(null, G__4833__4834);
    var vec__4837__4839 = G__4836__4838;
    var key__4840 = cljs.core.nth.call(null, vec__4837__4839, 0, null);
    var f__4841 = cljs.core.nth.call(null, vec__4837__4839, 1, null);
    var G__4833__4842 = G__4833__4834;
    var G__4836__4843 = G__4836__4838;
    var G__4833__4844 = G__4833__4842;
    while(true) {
      var vec__4845__4846 = G__4836__4843;
      var key__4847 = cljs.core.nth.call(null, vec__4845__4846, 0, null);
      var f__4848 = cljs.core.nth.call(null, vec__4845__4846, 1, null);
      var G__4833__4849 = G__4833__4844;
      f__4848.call(null, key__4847, this$, oldval, newval);
      var temp__3698__auto____4850 = cljs.core.next.call(null, G__4833__4849);
      if(cljs.core.truth_(temp__3698__auto____4850)) {
        var G__4833__4851 = temp__3698__auto____4850;
        var G__4858 = cljs.core.first.call(null, G__4833__4851);
        var G__4859 = G__4833__4851;
        G__4836__4843 = G__4858;
        G__4833__4844 = G__4859;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch = function(this$, key, f) {
  var this__4852 = this;
  return this$.watches = cljs.core.assoc.call(null, this__4852.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch = function(this$, key) {
  var this__4853 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__4853.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$ = true;
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq = function(a, opts) {
  var this__4854 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "]), cljs.core._pr_seq.call(null, this__4854.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$ = true;
cljs.core.Atom.prototype.cljs$core$IMeta$_meta = function(_) {
  var this__4855 = this;
  return this__4855.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$ = true;
cljs.core.Atom.prototype.cljs$core$IDeref$_deref = function(_) {
  var this__4856 = this;
  return this__4856.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$ = true;
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv = function(o, other) {
  var this__4857 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__4866 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__4867 = function() {
    var G__4869__delegate = function(x, p__4860) {
      var map__4861__4862 = p__4860;
      var map__4861__4863 = cljs.core.truth_(cljs.core.seq_QMARK_.call(null, map__4861__4862)) ? cljs.core.apply.call(null, cljs.core.hash_map, map__4861__4862) : map__4861__4862;
      var validator__4864 = cljs.core.get.call(null, map__4861__4863, "\ufdd0'validator");
      var meta__4865 = cljs.core.get.call(null, map__4861__4863, "\ufdd0'meta");
      return new cljs.core.Atom(x, meta__4865, validator__4864, null)
    };
    var G__4869 = function(x, var_args) {
      var p__4860 = null;
      if(goog.isDef(var_args)) {
        p__4860 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__4869__delegate.call(this, x, p__4860)
    };
    G__4869.cljs$lang$maxFixedArity = 1;
    G__4869.cljs$lang$applyTo = function(arglist__4870) {
      var x = cljs.core.first(arglist__4870);
      var p__4860 = cljs.core.rest(arglist__4870);
      return G__4869__delegate.call(this, x, p__4860)
    };
    return G__4869
  }();
  atom = function(x, var_args) {
    var p__4860 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__4866.call(this, x);
      default:
        return atom__4867.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__4867.cljs$lang$applyTo;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3698__auto____4871 = a.validator;
  if(cljs.core.truth_(temp__3698__auto____4871)) {
    var validate__4872 = temp__3698__auto____4871;
    if(cljs.core.truth_(validate__4872.call(null, new_value))) {
    }else {
      throw new Error(cljs.core.str.call(null, "Assert failed: ", "Validator rejected reference state", "\n", cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 3282)))));
    }
  }else {
  }
  var old_value__4873 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__4873, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___4874 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___4875 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4876 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___4877 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___4878 = function() {
    var G__4880__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__4880 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__4880__delegate.call(this, a, f, x, y, z, more)
    };
    G__4880.cljs$lang$maxFixedArity = 5;
    G__4880.cljs$lang$applyTo = function(arglist__4881) {
      var a = cljs.core.first(arglist__4881);
      var f = cljs.core.first(cljs.core.next(arglist__4881));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__4881)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4881))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4881)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__4881)))));
      return G__4880__delegate.call(this, a, f, x, y, z, more)
    };
    return G__4880
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___4874.call(this, a, f);
      case 3:
        return swap_BANG___4875.call(this, a, f, x);
      case 4:
        return swap_BANG___4876.call(this, a, f, x, y);
      case 5:
        return swap_BANG___4877.call(this, a, f, x, y, z);
      default:
        return swap_BANG___4878.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___4878.cljs$lang$applyTo;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core.truth_(cljs.core._EQ_.call(null, a.state, oldval))) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__4882) {
    var iref = cljs.core.first(arglist__4882);
    var f = cljs.core.first(cljs.core.next(arglist__4882));
    var args = cljs.core.rest(cljs.core.next(arglist__4882));
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__4883 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__4884 = function(prefix_string) {
    if(cljs.core.truth_(cljs.core.gensym_counter === null)) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, cljs.core.str.call(null, prefix_string, cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc)))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__4883.call(this);
      case 1:
        return gensym__4884.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f
};
cljs.core.Delay.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$ = true;
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_ = function(d) {
  var this__4886 = this;
  return"\ufdd0'done".call(null, cljs.core.deref.call(null, this__4886.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$ = true;
cljs.core.Delay.prototype.cljs$core$IDeref$_deref = function(_) {
  var this__4887 = this;
  return"\ufdd0'value".call(null, cljs.core.swap_BANG_.call(null, this__4887.state, function(p__4888) {
    var curr_state__4889 = p__4888;
    var curr_state__4890 = cljs.core.truth_(cljs.core.seq_QMARK_.call(null, curr_state__4889)) ? cljs.core.apply.call(null, cljs.core.hash_map, curr_state__4889) : curr_state__4889;
    var done__4891 = cljs.core.get.call(null, curr_state__4890, "\ufdd0'done");
    if(cljs.core.truth_(done__4891)) {
      return curr_state__4890
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__4887.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.truth_(cljs.core.delay_QMARK_.call(null, x))) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__4892__4893 = options;
    var map__4892__4894 = cljs.core.truth_(cljs.core.seq_QMARK_.call(null, map__4892__4893)) ? cljs.core.apply.call(null, cljs.core.hash_map, map__4892__4893) : map__4892__4893;
    var keywordize_keys__4895 = cljs.core.get.call(null, map__4892__4894, "\ufdd0'keywordize-keys");
    var keyfn__4896 = cljs.core.truth_(keywordize_keys__4895) ? cljs.core.keyword : cljs.core.str;
    var f__4902 = function thisfn(x) {
      if(cljs.core.truth_(cljs.core.seq_QMARK_.call(null, x))) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.truth_(cljs.core.coll_QMARK_.call(null, x))) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray.call(null, x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.truth_(goog.isObject.call(null, x))) {
              return cljs.core.into.call(null, cljs.core.ObjMap.fromObject([], {}), function() {
                var iter__520__auto____4901 = function iter__4897(s__4898) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__4898__4899 = s__4898;
                    while(true) {
                      if(cljs.core.truth_(cljs.core.seq.call(null, s__4898__4899))) {
                        var k__4900 = cljs.core.first.call(null, s__4898__4899);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__4896.call(null, k__4900), thisfn.call(null, x[k__4900])]), iter__4897.call(null, cljs.core.rest.call(null, s__4898__4899)))
                      }else {
                        return null
                      }
                      break
                    }
                  })
                };
                return iter__520__auto____4901.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if(cljs.core.truth_("\ufdd0'else")) {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__4902.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__4903) {
    var x = cljs.core.first(arglist__4903);
    var options = cljs.core.rest(arglist__4903);
    return js__GT_clj__delegate.call(this, x, options)
  };
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__4904 = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
  return function() {
    var G__4908__delegate = function(args) {
      var temp__3695__auto____4905 = cljs.core.get.call(null, cljs.core.deref.call(null, mem__4904), args);
      if(cljs.core.truth_(temp__3695__auto____4905)) {
        var v__4906 = temp__3695__auto____4905;
        return v__4906
      }else {
        var ret__4907 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__4904, cljs.core.assoc, args, ret__4907);
        return ret__4907
      }
    };
    var G__4908 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__4908__delegate.call(this, args)
    };
    G__4908.cljs$lang$maxFixedArity = 0;
    G__4908.cljs$lang$applyTo = function(arglist__4909) {
      var args = cljs.core.seq(arglist__4909);
      return G__4908__delegate.call(this, args)
    };
    return G__4908
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__4911 = function(f) {
    while(true) {
      var ret__4910 = f.call(null);
      if(cljs.core.truth_(cljs.core.fn_QMARK_.call(null, ret__4910))) {
        var G__4914 = ret__4910;
        f = G__4914;
        continue
      }else {
        return ret__4910
      }
      break
    }
  };
  var trampoline__4912 = function() {
    var G__4915__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__4915 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__4915__delegate.call(this, f, args)
    };
    G__4915.cljs$lang$maxFixedArity = 1;
    G__4915.cljs$lang$applyTo = function(arglist__4916) {
      var f = cljs.core.first(arglist__4916);
      var args = cljs.core.rest(arglist__4916);
      return G__4915__delegate.call(this, f, args)
    };
    return G__4915
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__4911.call(this, f);
      default:
        return trampoline__4912.apply(this, arguments)
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__4912.cljs$lang$applyTo;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__4917 = function() {
    return rand.call(null, 1)
  };
  var rand__4918 = function(n) {
    return Math.random() * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__4917.call(this);
      case 1:
        return rand__4918.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor(Math.random() * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__4920 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__4920, cljs.core.conj.call(null, cljs.core.get.call(null, ret, k__4920, cljs.core.PersistentVector.fromArray([])), x))
  }, cljs.core.ObjMap.fromObject([], {}), coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'descendants":cljs.core.ObjMap.fromObject([], {}), "\ufdd0'ancestors":cljs.core.ObjMap.fromObject([], {})})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___4929 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___4930 = function(h, child, parent) {
    var or__3548__auto____4921 = cljs.core._EQ_.call(null, child, parent);
    if(cljs.core.truth_(or__3548__auto____4921)) {
      return or__3548__auto____4921
    }else {
      var or__3548__auto____4922 = cljs.core.contains_QMARK_.call(null, "\ufdd0'ancestors".call(null, h).call(null, child), parent);
      if(cljs.core.truth_(or__3548__auto____4922)) {
        return or__3548__auto____4922
      }else {
        var and__3546__auto____4923 = cljs.core.vector_QMARK_.call(null, parent);
        if(cljs.core.truth_(and__3546__auto____4923)) {
          var and__3546__auto____4924 = cljs.core.vector_QMARK_.call(null, child);
          if(cljs.core.truth_(and__3546__auto____4924)) {
            var and__3546__auto____4925 = cljs.core._EQ_.call(null, cljs.core.count.call(null, parent), cljs.core.count.call(null, child));
            if(cljs.core.truth_(and__3546__auto____4925)) {
              var ret__4926 = true;
              var i__4927 = 0;
              while(true) {
                if(cljs.core.truth_(function() {
                  var or__3548__auto____4928 = cljs.core.not.call(null, ret__4926);
                  if(cljs.core.truth_(or__3548__auto____4928)) {
                    return or__3548__auto____4928
                  }else {
                    return cljs.core._EQ_.call(null, i__4927, cljs.core.count.call(null, parent))
                  }
                }())) {
                  return ret__4926
                }else {
                  var G__4932 = isa_QMARK_.call(null, h, child.call(null, i__4927), parent.call(null, i__4927));
                  var G__4933 = i__4927 + 1;
                  ret__4926 = G__4932;
                  i__4927 = G__4933;
                  continue
                }
                break
              }
            }else {
              return and__3546__auto____4925
            }
          }else {
            return and__3546__auto____4924
          }
        }else {
          return and__3546__auto____4923
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___4929.call(this, h, child);
      case 3:
        return isa_QMARK___4930.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__4934 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__4935 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'parents".call(null, h), tag))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__4934.call(this, h);
      case 2:
        return parents__4935.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__4937 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__4938 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'ancestors".call(null, h), tag))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__4937.call(this, h);
      case 2:
        return ancestors__4938.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__4940 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__4941 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core.get.call(null, "\ufdd0'descendants".call(null, h), tag))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__4940.call(this, h);
      case 2:
        return descendants__4941.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__4951 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error(cljs.core.str.call(null, "Assert failed: ", cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 3566)))));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__4952 = function(h, tag, parent) {
    if(cljs.core.truth_(cljs.core.not_EQ_.call(null, tag, parent))) {
    }else {
      throw new Error(cljs.core.str.call(null, "Assert failed: ", cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 3570)))));
    }
    var tp__4946 = "\ufdd0'parents".call(null, h);
    var td__4947 = "\ufdd0'descendants".call(null, h);
    var ta__4948 = "\ufdd0'ancestors".call(null, h);
    var tf__4949 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.get.call(null, targets, k, cljs.core.set([])), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3548__auto____4950 = cljs.core.truth_(cljs.core.contains_QMARK_.call(null, tp__4946.call(null, tag), parent)) ? null : function() {
      if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, ta__4948.call(null, tag), parent))) {
        throw new Error(cljs.core.str.call(null, tag, "already has", parent, "as ancestor"));
      }else {
      }
      if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, ta__4948.call(null, parent), tag))) {
        throw new Error(cljs.core.str.call(null, "Cyclic derivation:", parent, "has", tag, "as ancestor"));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, "\ufdd0'parents".call(null, h), tag, cljs.core.conj.call(null, cljs.core.get.call(null, tp__4946, tag, cljs.core.set([])), parent)), "\ufdd0'ancestors":tf__4949.call(null, "\ufdd0'ancestors".call(null, h), tag, td__4947, parent, ta__4948), "\ufdd0'descendants":tf__4949.call(null, "\ufdd0'descendants".call(null, h), parent, ta__4948, tag, td__4947)})
    }();
    if(cljs.core.truth_(or__3548__auto____4950)) {
      return or__3548__auto____4950
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__4951.call(this, h, tag);
      case 3:
        return derive__4952.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__4958 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__4959 = function(h, tag, parent) {
    var parentMap__4954 = "\ufdd0'parents".call(null, h);
    var childsParents__4955 = cljs.core.truth_(parentMap__4954.call(null, tag)) ? cljs.core.disj.call(null, parentMap__4954.call(null, tag), parent) : cljs.core.set([]);
    var newParents__4956 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__4955)) ? cljs.core.assoc.call(null, parentMap__4954, tag, childsParents__4955) : cljs.core.dissoc.call(null, parentMap__4954, tag);
    var deriv_seq__4957 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__4943_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__4943_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__4943_SHARP_), cljs.core.second.call(null, p1__4943_SHARP_)))
    }, cljs.core.seq.call(null, newParents__4956)));
    if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, parentMap__4954.call(null, tag), parent))) {
      return cljs.core.reduce.call(null, function(p1__4944_SHARP_, p2__4945_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__4944_SHARP_, p2__4945_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__4957))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__4958.call(this, h, tag);
      case 3:
        return underive__4959.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__4961 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3548__auto____4963 = cljs.core.truth_(function() {
    var and__3546__auto____4962 = xprefs__4961;
    if(cljs.core.truth_(and__3546__auto____4962)) {
      return xprefs__4961.call(null, y)
    }else {
      return and__3546__auto____4962
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3548__auto____4963)) {
    return or__3548__auto____4963
  }else {
    var or__3548__auto____4965 = function() {
      var ps__4964 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.truth_(cljs.core.count.call(null, ps__4964) > 0)) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__4964), prefer_table))) {
          }else {
          }
          var G__4968 = cljs.core.rest.call(null, ps__4964);
          ps__4964 = G__4968;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3548__auto____4965)) {
      return or__3548__auto____4965
    }else {
      var or__3548__auto____4967 = function() {
        var ps__4966 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.truth_(cljs.core.count.call(null, ps__4966) > 0)) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__4966), y, prefer_table))) {
            }else {
            }
            var G__4969 = cljs.core.rest.call(null, ps__4966);
            ps__4966 = G__4969;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3548__auto____4967)) {
        return or__3548__auto____4967
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3548__auto____4970 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3548__auto____4970)) {
    return or__3548__auto____4970
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__4979 = cljs.core.reduce.call(null, function(be, p__4971) {
    var vec__4972__4973 = p__4971;
    var k__4974 = cljs.core.nth.call(null, vec__4972__4973, 0, null);
    var ___4975 = cljs.core.nth.call(null, vec__4972__4973, 1, null);
    var e__4976 = vec__4972__4973;
    if(cljs.core.truth_(cljs.core.isa_QMARK_.call(null, dispatch_val, k__4974))) {
      var be2__4978 = cljs.core.truth_(function() {
        var or__3548__auto____4977 = be === null;
        if(cljs.core.truth_(or__3548__auto____4977)) {
          return or__3548__auto____4977
        }else {
          return cljs.core.dominates.call(null, k__4974, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__4976 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__4978), k__4974, prefer_table))) {
      }else {
        throw new Error(cljs.core.str.call(null, "Multiple methods in multimethod '", name, "' match dispatch value: ", dispatch_val, " -> ", k__4974, " and ", cljs.core.first.call(null, be2__4978), ", and neither is preferred"));
      }
      return be2__4978
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__4979)) {
    if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy)))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__4979));
      return cljs.core.second.call(null, best_entry__4979)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4980 = mf;
    if(cljs.core.truth_(and__3546__auto____4980)) {
      return mf.cljs$core$IMultiFn$_reset
    }else {
      return and__3546__auto____4980
    }
  }())) {
    return mf.cljs$core$IMultiFn$_reset(mf)
  }else {
    return function() {
      var or__3548__auto____4981 = cljs.core._reset[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____4981)) {
        return or__3548__auto____4981
      }else {
        var or__3548__auto____4982 = cljs.core._reset["_"];
        if(cljs.core.truth_(or__3548__auto____4982)) {
          return or__3548__auto____4982
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4983 = mf;
    if(cljs.core.truth_(and__3546__auto____4983)) {
      return mf.cljs$core$IMultiFn$_add_method
    }else {
      return and__3546__auto____4983
    }
  }())) {
    return mf.cljs$core$IMultiFn$_add_method(mf, dispatch_val, method)
  }else {
    return function() {
      var or__3548__auto____4984 = cljs.core._add_method[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____4984)) {
        return or__3548__auto____4984
      }else {
        var or__3548__auto____4985 = cljs.core._add_method["_"];
        if(cljs.core.truth_(or__3548__auto____4985)) {
          return or__3548__auto____4985
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4986 = mf;
    if(cljs.core.truth_(and__3546__auto____4986)) {
      return mf.cljs$core$IMultiFn$_remove_method
    }else {
      return and__3546__auto____4986
    }
  }())) {
    return mf.cljs$core$IMultiFn$_remove_method(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____4987 = cljs.core._remove_method[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____4987)) {
        return or__3548__auto____4987
      }else {
        var or__3548__auto____4988 = cljs.core._remove_method["_"];
        if(cljs.core.truth_(or__3548__auto____4988)) {
          return or__3548__auto____4988
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4989 = mf;
    if(cljs.core.truth_(and__3546__auto____4989)) {
      return mf.cljs$core$IMultiFn$_prefer_method
    }else {
      return and__3546__auto____4989
    }
  }())) {
    return mf.cljs$core$IMultiFn$_prefer_method(mf, dispatch_val, dispatch_val_y)
  }else {
    return function() {
      var or__3548__auto____4990 = cljs.core._prefer_method[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____4990)) {
        return or__3548__auto____4990
      }else {
        var or__3548__auto____4991 = cljs.core._prefer_method["_"];
        if(cljs.core.truth_(or__3548__auto____4991)) {
          return or__3548__auto____4991
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4992 = mf;
    if(cljs.core.truth_(and__3546__auto____4992)) {
      return mf.cljs$core$IMultiFn$_get_method
    }else {
      return and__3546__auto____4992
    }
  }())) {
    return mf.cljs$core$IMultiFn$_get_method(mf, dispatch_val)
  }else {
    return function() {
      var or__3548__auto____4993 = cljs.core._get_method[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____4993)) {
        return or__3548__auto____4993
      }else {
        var or__3548__auto____4994 = cljs.core._get_method["_"];
        if(cljs.core.truth_(or__3548__auto____4994)) {
          return or__3548__auto____4994
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4995 = mf;
    if(cljs.core.truth_(and__3546__auto____4995)) {
      return mf.cljs$core$IMultiFn$_methods
    }else {
      return and__3546__auto____4995
    }
  }())) {
    return mf.cljs$core$IMultiFn$_methods(mf)
  }else {
    return function() {
      var or__3548__auto____4996 = cljs.core._methods[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____4996)) {
        return or__3548__auto____4996
      }else {
        var or__3548__auto____4997 = cljs.core._methods["_"];
        if(cljs.core.truth_(or__3548__auto____4997)) {
          return or__3548__auto____4997
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____4998 = mf;
    if(cljs.core.truth_(and__3546__auto____4998)) {
      return mf.cljs$core$IMultiFn$_prefers
    }else {
      return and__3546__auto____4998
    }
  }())) {
    return mf.cljs$core$IMultiFn$_prefers(mf)
  }else {
    return function() {
      var or__3548__auto____4999 = cljs.core._prefers[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____4999)) {
        return or__3548__auto____4999
      }else {
        var or__3548__auto____5000 = cljs.core._prefers["_"];
        if(cljs.core.truth_(or__3548__auto____5000)) {
          return or__3548__auto____5000
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(cljs.core.truth_(function() {
    var and__3546__auto____5001 = mf;
    if(cljs.core.truth_(and__3546__auto____5001)) {
      return mf.cljs$core$IMultiFn$_dispatch
    }else {
      return and__3546__auto____5001
    }
  }())) {
    return mf.cljs$core$IMultiFn$_dispatch(mf, args)
  }else {
    return function() {
      var or__3548__auto____5002 = cljs.core._dispatch[goog.typeOf.call(null, mf)];
      if(cljs.core.truth_(or__3548__auto____5002)) {
        return or__3548__auto____5002
      }else {
        var or__3548__auto____5003 = cljs.core._dispatch["_"];
        if(cljs.core.truth_(or__3548__auto____5003)) {
          return or__3548__auto____5003
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__5004 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__5005 = cljs.core._get_method.call(null, mf, dispatch_val__5004);
  if(cljs.core.truth_(target_fn__5005)) {
  }else {
    throw new Error(cljs.core.str.call(null, "No method in multimethod '", cljs.core.name, "' for dispatch value: ", dispatch_val__5004));
  }
  return cljs.core.apply.call(null, target_fn__5005, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy
};
cljs.core.MultiFn.cljs$core$IPrintable$_pr_seq = function(this__367__auto__) {
  return cljs.core.list.call(null, "cljs.core.MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$ = true;
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash = function(this$) {
  var this__5006 = this;
  return goog.getUid.call(null, this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$ = true;
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset = function(mf) {
  var this__5007 = this;
  cljs.core.swap_BANG_.call(null, this__5007.method_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__5007.method_cache, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__5007.prefer_table, function(mf) {
    return cljs.core.ObjMap.fromObject([], {})
  });
  cljs.core.swap_BANG_.call(null, this__5007.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method = function(mf, dispatch_val, method) {
  var this__5008 = this;
  cljs.core.swap_BANG_.call(null, this__5008.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__5008.method_cache, this__5008.method_table, this__5008.cached_hierarchy, this__5008.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method = function(mf, dispatch_val) {
  var this__5009 = this;
  cljs.core.swap_BANG_.call(null, this__5009.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__5009.method_cache, this__5009.method_table, this__5009.cached_hierarchy, this__5009.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method = function(mf, dispatch_val) {
  var this__5010 = this;
  if(cljs.core.truth_(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__5010.cached_hierarchy), cljs.core.deref.call(null, this__5010.hierarchy)))) {
  }else {
    cljs.core.reset_cache.call(null, this__5010.method_cache, this__5010.method_table, this__5010.cached_hierarchy, this__5010.hierarchy)
  }
  var temp__3695__auto____5011 = cljs.core.deref.call(null, this__5010.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3695__auto____5011)) {
    var target_fn__5012 = temp__3695__auto____5011;
    return target_fn__5012
  }else {
    var temp__3695__auto____5013 = cljs.core.find_and_cache_best_method.call(null, this__5010.name, dispatch_val, this__5010.hierarchy, this__5010.method_table, this__5010.prefer_table, this__5010.method_cache, this__5010.cached_hierarchy);
    if(cljs.core.truth_(temp__3695__auto____5013)) {
      var target_fn__5014 = temp__3695__auto____5013;
      return target_fn__5014
    }else {
      return cljs.core.deref.call(null, this__5010.method_table).call(null, this__5010.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__5015 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__5015.prefer_table))) {
    throw new Error(cljs.core.str.call(null, "Preference conflict in multimethod '", this__5015.name, "': ", dispatch_val_y, " is already preferred to ", dispatch_val_x));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__5015.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core.get.call(null, old, dispatch_val_x, cljs.core.set([])), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__5015.method_cache, this__5015.method_table, this__5015.cached_hierarchy, this__5015.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods = function(mf) {
  var this__5016 = this;
  return cljs.core.deref.call(null, this__5016.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers = function(mf) {
  var this__5017 = this;
  return cljs.core.deref.call(null, this__5017.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch = function(mf, args) {
  var this__5018 = this;
  return cljs.core.do_dispatch.call(null, mf, this__5018.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__5019__delegate = function(_, args) {
    return cljs.core._dispatch.call(null, this, args)
  };
  var G__5019 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__5019__delegate.call(this, _, args)
  };
  G__5019.cljs$lang$maxFixedArity = 1;
  G__5019.cljs$lang$applyTo = function(arglist__5020) {
    var _ = cljs.core.first(arglist__5020);
    var args = cljs.core.rest(arglist__5020);
    return G__5019__delegate.call(this, _, args)
  };
  return G__5019
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  return cljs.core._dispatch.call(null, this, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
goog.provide("cljsbinding");
goog.require("cljs.core");
goog.require("jayq.core");
cljsbinding.BindMonitor = cljs.core.atom.call(null, false);
cljsbinding.BindDependencies = cljs.core.atom.call(null, cljs.core.ObjMap.fromObject([], {}));
cljsbinding.BindFn = cljs.core.atom.call(null, null);
cljsbinding.translate = function translate(data) {
  if(cljs.core.truth_(cljs.core.map_QMARK_.call(null, data))) {
    return cljsbinding.make_js_map.call(null, data)
  }else {
    return data
  }
};
cljsbinding.visible = function visible(elem, v) {
  if(cljs.core.truth_(v)) {
    return jayq.core.show.call(null, elem)
  }else {
    return jayq.core.hide.call(null, elem)
  }
};
cljsbinding.bindings = cljs.core.ObjMap.fromObject(["visible"], {"visible":cljsbinding.visible});
cljsbinding.bindfn = function bindfn(elem, data) {
  if(cljs.core.truth_(cljs.core.contains_QMARK_.call(null, cljsbinding.bindings, cljs.core.first.call(null, data)))) {
    return function() {
      return cljsbinding.bindings.call(null, cljs.core.first.call(null, data)).call(null, elem, cljsbinding.translate.call(null, eval.call(null, cljs.core.second.call(null, data))))
    }
  }else {
    return function() {
      return elem[cljs.core.first.call(null, data)].call(elem, cljsbinding.translate.call(null, eval.call(null, cljs.core.second.call(null, data))))
    }
  }
};
cljsbinding.bind_elem = function bind_elem(elem, data) {
  var f__3187 = cljsbinding.bindfn.call(null, elem, data);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true);
  cljs.core.reset_BANG_.call(null, cljsbinding.BindFn, f__3187);
  f__3187.call(null);
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false)
};
cljsbinding.make_js_map = function make_js_map(cljmap) {
  var out__3188 = cljs.core.js_obj.call(null);
  cljs.core.doall.call(null, cljs.core.map.call(null, function(p1__3186_SHARP_) {
    return out__3188[cljs.core.name.call(null, cljs.core.first.call(null, p1__3186_SHARP_))] = cljs.core.second.call(null, p1__3186_SHARP_)
  }, cljmap));
  return out__3188
};
cljsbinding.bind = function bind(elem) {
  var G__3189__3190 = cljs.core.seq.call(null, jayq.core.attr.call(null, elem, "bind").split(";"));
  if(cljs.core.truth_(G__3189__3190)) {
    var data__3191 = cljs.core.first.call(null, G__3189__3190);
    var G__3189__3192 = G__3189__3190;
    while(true) {
      cljsbinding.bind_elem.call(null, elem, data__3191.split(":"));
      var temp__3698__auto____3193 = cljs.core.next.call(null, G__3189__3192);
      if(cljs.core.truth_(temp__3698__auto____3193)) {
        var G__3189__3194 = temp__3698__auto____3193;
        var G__3195 = cljs.core.first.call(null, G__3189__3194);
        var G__3196 = G__3189__3194;
        data__3191 = G__3195;
        G__3189__3192 = G__3196;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljsbinding.bindatom = function bindatom(elem) {
  cljsbinding.bind_elem.call(null, elem, cljs.core.PersistentVector.fromArray(["val", cljs.core.str.call(null, "cljs.core.deref.call(null,", jayq.core.attr.call(null, elem, "bindatom"), ")")]));
  return elem.change(function() {
    return cljs.core.reset_BANG_.call(null, eval.call(null, jayq.core.attr.call(null, elem, "bindatom")), elem.val()).call(null, "\ufdd0'false")
  })
};
cljsbinding.init = function init() {
  var G__3200__3201 = cljs.core.seq.call(null, jayq.core.$.call(null, "*[bind]"));
  if(cljs.core.truth_(G__3200__3201)) {
    var elem__3202 = cljs.core.first.call(null, G__3200__3201);
    var G__3200__3203 = G__3200__3201;
    while(true) {
      cljsbinding.bind.call(null, elem__3202);
      var temp__3698__auto____3204 = cljs.core.next.call(null, G__3200__3203);
      if(cljs.core.truth_(temp__3698__auto____3204)) {
        var G__3200__3205 = temp__3698__auto____3204;
        var G__3212 = cljs.core.first.call(null, G__3200__3205);
        var G__3213 = G__3200__3205;
        elem__3202 = G__3212;
        G__3200__3203 = G__3213;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__3206__3207 = cljs.core.seq.call(null, jayq.core.$.call(null, "*[bindatom]"));
  if(cljs.core.truth_(G__3206__3207)) {
    var elem__3208 = cljs.core.first.call(null, G__3206__3207);
    var G__3206__3209 = G__3206__3207;
    while(true) {
      cljsbinding.bindatom.call(null, elem__3208);
      var temp__3698__auto____3210 = cljs.core.next.call(null, G__3206__3209);
      if(cljs.core.truth_(temp__3698__auto____3210)) {
        var G__3206__3211 = temp__3698__auto____3210;
        var G__3214 = cljs.core.first.call(null, G__3206__3211);
        var G__3215 = G__3206__3211;
        elem__3208 = G__3214;
        G__3206__3209 = G__3215;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
goog.exportSymbol("cljsbinding.init", cljsbinding.init);
cljsbinding.seq_contains_QMARK_ = function seq_contains_QMARK_(sequence, item) {
  if(cljs.core.truth_(cljs.core.empty_QMARK_.call(null, sequence))) {
    return false
  }else {
    return cljs.core.reduce.call(null, function(p1__3197_SHARP_, p2__3198_SHARP_) {
      var or__3548__auto____3217 = p1__3197_SHARP_;
      if(cljs.core.truth_(or__3548__auto____3217)) {
        return or__3548__auto____3217
      }else {
        return p2__3198_SHARP_
      }
    }, cljs.core.map.call(null, function(p1__3199_SHARP_) {
      return cljs.core._EQ_.call(null, p1__3199_SHARP_, item)
    }, sequence))
  }
};
cljsbinding.register = function register(atom) {
  cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, false);
  cljs.core.swap_BANG_.call(null, cljsbinding.BindDependencies, function(p1__3216_SHARP_) {
    return cljs.core.assoc.call(null, p1__3216_SHARP_, atom, cljs.core.truth_(cljs.core.contains_QMARK_.call(null, p1__3216_SHARP_, atom)) ? cljs.core.cons.call(null, cljs.core.deref.call(null, cljsbinding.BindFn), p1__3216_SHARP_.call(null, atom)) : cljs.core.PersistentVector.fromArray([cljs.core.deref.call(null, cljsbinding.BindFn)]))
  });
  cljs.core.add_watch.call(null, atom, "\ufdd0'binding-watch", function(key, a, old_val, new_val) {
    var G__3218__3219 = cljs.core.seq.call(null, cljs.core.deref.call(null, cljsbinding.BindDependencies).call(null, a));
    if(cljs.core.truth_(G__3218__3219)) {
      var f__3220 = cljs.core.first.call(null, G__3218__3219);
      var G__3218__3221 = G__3218__3219;
      while(true) {
        f__3220.call(null);
        var temp__3698__auto____3222 = cljs.core.next.call(null, G__3218__3221);
        if(cljs.core.truth_(temp__3698__auto____3222)) {
          var G__3218__3223 = temp__3698__auto____3222;
          var G__3224 = cljs.core.first.call(null, G__3218__3223);
          var G__3225 = G__3218__3223;
          f__3220 = G__3224;
          G__3218__3221 = G__3225;
          continue
        }else {
          return null
        }
        break
      }
    }else {
      return null
    }
  });
  return cljs.core.reset_BANG_.call(null, cljsbinding.BindMonitor, true)
};
goog.exportSymbol("cljsbinding.register", cljsbinding.register);
cljsbinding.boot = function boot() {
  return eval.call(null, "    \n    var deref = cljs.core.deref\n    cljs.core.deref = function (a) {\n     if (deref(cljsbinding.BindMonitor))\n       cljsbinding.register(a)\n     return deref(a)\n    }\n    cljsbinding.init()")
};
goog.exportSymbol("cljsbinding.boot", cljsbinding.boot);
