/*
 * Decompiled with CFR 0.152.
 */
package shaded.gojira.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import shaded.gojira.com.fasterxml.jackson.core.JsonGenerator;
import shaded.gojira.com.fasterxml.jackson.databind.JavaType;
import shaded.gojira.com.fasterxml.jackson.databind.JsonMappingException;
import shaded.gojira.com.fasterxml.jackson.databind.JsonNode;
import shaded.gojira.com.fasterxml.jackson.databind.SerializationFeature;
import shaded.gojira.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.gojira.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shaded.gojira.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class StdKeySerializer
extends StdSerializer<Object> {
    public StdKeySerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator g, SerializerProvider provider) throws IOException {
        String str;
        Class<?> cls = value.getClass();
        if (cls == String.class) {
            str = (String)value;
        } else if (cls.isEnum()) {
            Enum en = (Enum)value;
            str = provider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING) ? en.toString() : en.name();
        } else {
            if (value instanceof Date) {
                provider.defaultSerializeDateKey((Date)value, g);
                return;
            }
            str = cls == Class.class ? ((Class)value).getName() : value.toString();
        }
        g.writeFieldName(str);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

