/*
 * Decompiled with CFR 0.152.
 */
package shaded.gojira.com.fasterxml.jackson.databind.ser.impl;

import shaded.gojira.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import shaded.gojira.com.fasterxml.jackson.core.SerializableString;
import shaded.gojira.com.fasterxml.jackson.core.io.SerializedString;
import shaded.gojira.com.fasterxml.jackson.databind.JavaType;
import shaded.gojira.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.gojira.com.fasterxml.jackson.databind.PropertyName;

public final class ObjectIdWriter {
    public final JavaType idType;
    public final SerializableString propertyName;
    public final ObjectIdGenerator<?> generator;
    public final JsonSerializer<Object> serializer;
    public final boolean alwaysAsId;

    protected ObjectIdWriter(JavaType t, SerializableString propName, ObjectIdGenerator<?> gen, JsonSerializer<?> ser, boolean alwaysAsId) {
        this.idType = t;
        this.propertyName = propName;
        this.generator = gen;
        this.serializer = ser;
        this.alwaysAsId = alwaysAsId;
    }

    public static ObjectIdWriter construct(JavaType idType, PropertyName propName, ObjectIdGenerator<?> generator, boolean alwaysAsId) {
        String simpleName = propName == null ? null : propName.getSimpleName();
        return ObjectIdWriter.construct(idType, simpleName, generator, alwaysAsId);
    }

    @Deprecated
    public static ObjectIdWriter construct(JavaType idType, String propName, ObjectIdGenerator<?> generator, boolean alwaysAsId) {
        SerializedString serName = propName == null ? null : new SerializedString(propName);
        return new ObjectIdWriter(idType, serName, generator, null, alwaysAsId);
    }

    public ObjectIdWriter withSerializer(JsonSerializer<?> ser) {
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, ser, this.alwaysAsId);
    }

    public ObjectIdWriter withAlwaysAsId(boolean newState) {
        if (newState == this.alwaysAsId) {
            return this;
        }
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, this.serializer, newState);
    }
}

