/*
 * Decompiled with CFR 0.152.
 */
package shaded.gojira.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.Iterator;
import shaded.gojira.com.fasterxml.jackson.core.JsonGenerator;
import shaded.gojira.com.fasterxml.jackson.databind.BeanProperty;
import shaded.gojira.com.fasterxml.jackson.databind.JavaType;
import shaded.gojira.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.gojira.com.fasterxml.jackson.databind.SerializationFeature;
import shaded.gojira.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.gojira.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import shaded.gojira.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import shaded.gojira.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import shaded.gojira.com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;

@JacksonStdImpl
public class IteratorSerializer
extends AsArraySerializerBase<Iterator<?>> {
    public IteratorSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
        super(Iterator.class, elemType, staticTyping, vts, null);
    }

    public IteratorSerializer(IteratorSerializer src, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSerializer, Boolean unwrapSingle) {
        super(src, property, vts, valueSerializer, unwrapSingle);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Iterator<?> value) {
        return value == null || !value.hasNext();
    }

    @Override
    public boolean hasSingleElement(Iterator<?> value) {
        return false;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new IteratorSerializer(this, this._property, vts, this._elementSerializer, this._unwrapSingle);
    }

    public IteratorSerializer withResolved(BeanProperty property, TypeSerializer vts, JsonSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new IteratorSerializer(this, property, vts, elementSerializer, unwrapSingle);
    }

    @Override
    public final void serialize(Iterator<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if ((this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE) && this.hasSingleElement(value)) {
            this.serializeContents(value, gen, provider);
            return;
        }
        gen.writeStartArray();
        this.serializeContents(value, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(Iterator<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value.hasNext()) {
            TypeSerializer typeSer = this._valueTypeSerializer;
            JsonSerializer<Object> prevSerializer = null;
            Class<?> prevClass = null;
            do {
                Object elem;
                if ((elem = value.next()) == null) {
                    provider.defaultSerializeNull(gen);
                    continue;
                }
                JsonSerializer<Object> currSerializer = this._elementSerializer;
                if (currSerializer == null) {
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc, this._property);
                        prevClass = cc;
                    }
                }
                if (typeSer == null) {
                    currSerializer.serialize(elem, gen, provider);
                    continue;
                }
                currSerializer.serializeWithType(elem, gen, provider, typeSer);
            } while (value.hasNext());
        }
    }
}

