/*
 * Decompiled with CFR 0.152.
 */
package shaded.gojira.com.fasterxml.jackson.databind;

import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;
import shaded.gojira.com.fasterxml.jackson.annotation.JsonFormat;
import shaded.gojira.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import shaded.gojira.com.fasterxml.jackson.annotation.ObjectIdResolver;
import shaded.gojira.com.fasterxml.jackson.databind.AnnotationIntrospector;
import shaded.gojira.com.fasterxml.jackson.databind.JavaType;
import shaded.gojira.com.fasterxml.jackson.databind.JsonMappingException;
import shaded.gojira.com.fasterxml.jackson.databind.MapperFeature;
import shaded.gojira.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import shaded.gojira.com.fasterxml.jackson.databind.cfg.MapperConfig;
import shaded.gojira.com.fasterxml.jackson.databind.introspect.Annotated;
import shaded.gojira.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import shaded.gojira.com.fasterxml.jackson.databind.type.TypeFactory;
import shaded.gojira.com.fasterxml.jackson.databind.util.ClassUtil;
import shaded.gojira.com.fasterxml.jackson.databind.util.Converter;

public abstract class DatabindContext {
    public abstract MapperConfig<?> getConfig();

    public abstract AnnotationIntrospector getAnnotationIntrospector();

    public abstract boolean isEnabled(MapperFeature var1);

    public abstract boolean canOverrideAccessModifiers();

    public abstract Class<?> getActiveView();

    public abstract Locale getLocale();

    public abstract TimeZone getTimeZone();

    public abstract JsonFormat.Value getDefaultPropertyFormat(Class<?> var1);

    public abstract Object getAttribute(Object var1);

    public abstract DatabindContext setAttribute(Object var1, Object var2);

    public JavaType constructType(Type type) {
        return this.getTypeFactory().constructType(type);
    }

    public JavaType constructSpecializedType(JavaType baseType, Class<?> subclass) {
        if (baseType.getRawClass() == subclass) {
            return baseType;
        }
        return this.getConfig().constructSpecializedType(baseType, subclass);
    }

    public abstract TypeFactory getTypeFactory();

    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated annotated, ObjectIdInfo objectIdInfo) throws JsonMappingException {
        ObjectIdGenerator<?> gen;
        Class<? extends ObjectIdGenerator<?>> implClass = objectIdInfo.getGeneratorType();
        MapperConfig<?> config = this.getConfig();
        HandlerInstantiator hi = config.getHandlerInstantiator();
        ObjectIdGenerator<?> objectIdGenerator = gen = hi == null ? null : hi.objectIdGeneratorInstance(config, annotated, implClass);
        if (gen == null) {
            gen = ClassUtil.createInstance(implClass, config.canOverrideAccessModifiers());
        }
        return gen.forScope(objectIdInfo.getScope());
    }

    public ObjectIdResolver objectIdResolverInstance(Annotated annotated, ObjectIdInfo objectIdInfo) {
        ObjectIdResolver resolver;
        Class<? extends ObjectIdResolver> implClass = objectIdInfo.getResolverType();
        MapperConfig<?> config = this.getConfig();
        HandlerInstantiator hi = config.getHandlerInstantiator();
        ObjectIdResolver objectIdResolver = resolver = hi == null ? null : hi.resolverIdGeneratorInstance(config, annotated, implClass);
        if (resolver == null) {
            resolver = ClassUtil.createInstance(implClass, config.canOverrideAccessModifiers());
        }
        return resolver;
    }

    public Converter<Object, Object> converterInstance(Annotated annotated, Object converterDef) throws JsonMappingException {
        Converter conv;
        if (converterDef == null) {
            return null;
        }
        if (converterDef instanceof Converter) {
            return (Converter)converterDef;
        }
        if (!(converterDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + converterDef.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class converterClass = (Class)converterDef;
        if (converterClass == Converter.None.class || ClassUtil.isBogusClass(converterClass)) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(converterClass)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + converterClass.getName() + "; expected Class<Converter>");
        }
        MapperConfig<?> config = this.getConfig();
        HandlerInstantiator hi = config.getHandlerInstantiator();
        Converter converter = conv = hi == null ? null : hi.converterInstance(config, annotated, converterClass);
        if (conv == null) {
            conv = (Converter)ClassUtil.createInstance(converterClass, config.canOverrideAccessModifiers());
        }
        return conv;
    }
}

