/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.requestsampling.config;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RequestSamplingConfig {
    private double samplingPercentage = 0.0;
    private List<Pattern> whitelist = null;

    private RequestSamplingConfig() {
    }

    public double getSamplingPercentage() {
        return this.samplingPercentage;
    }

    public List<Pattern> getWhitelist() {
        return this.whitelist;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private RequestSamplingConfig requestSamplingConfigToBuild = new RequestSamplingConfig();

        private Builder() {
        }

        public RequestSamplingConfig build() {
            return this.requestSamplingConfigToBuild;
        }

        public Builder setSamplingPercentage(double samplingPercentage) {
            this.requestSamplingConfigToBuild.samplingPercentage = samplingPercentage * 100.0 / 100.0;
            return this;
        }

        public Builder setWhitelist(List<String> whitelist) {
            if (whitelist == null) {
                return this;
            }
            this.requestSamplingConfigToBuild.whitelist = new ArrayList();
            for (String whitelisted : whitelist) {
                Pattern pattern = Pattern.compile(whitelisted, 2);
                this.requestSamplingConfigToBuild.whitelist.add(pattern);
            }
            return this;
        }
    }
}

