/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.execute;

import com.google.inject.Key;
import com.google.inject.name.Names;
import flipkart.cp.gojira.core.injectors.GuiceInjector;
import flipkart.cp.gojira.execute.TestExecutionException;
import flipkart.cp.gojira.execute.TestExecutor;
import flipkart.cp.gojira.models.TestData;
import flipkart.cp.gojira.models.TestDataType;
import flipkart.cp.gojira.models.TestRequestData;
import flipkart.cp.gojira.serde.SerdeHandlerRepository;
import flipkart.cp.gojira.serde.TestSerdeException;
import flipkart.cp.gojira.serde.handlers.TestSerdeHandler;
import flipkart.cp.gojira.sinkstore.SinkException;
import flipkart.cp.gojira.sinkstore.handlers.SinkHandler;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdBasedTestExecutor<T extends TestDataType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdBasedTestExecutor.class);
    private String testId;
    private SinkHandler sinkHandler = GuiceInjector.getInjector().getInstance(SinkHandler.class);
    private TestSerdeHandler testDataSerdeHandler = GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class).getTestDataSerdeHandler();

    public void execute(String testId) throws TestExecutionException, SinkException, TestSerdeException {
        TestData testData = this.testDataSerdeHandler.deserialize(this.sinkHandler.read(testId), TestData.class);
        GuiceInjector.getInjector().getInstance(Key.get(TestExecutor.class, (Annotation)Names.named(((TestRequestData)testData.getRequestData()).getType()))).execute(testData);
    }

    public void execute(String testId, String clientId) throws TestExecutionException, SinkException, TestSerdeException {
        TestData testData = this.testDataSerdeHandler.deserialize(this.sinkHandler.read(testId), TestData.class);
        GuiceInjector.getInjector().getInstance(Key.get(TestExecutor.class, (Annotation)Names.named(((TestRequestData)testData.getRequestData()).getType()))).execute(testData, clientId);
    }
}

