/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.core;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import flipkart.cp.gojira.compare.GojiraComparisonModule;
import flipkart.cp.gojira.compare.config.GojiraComparisonConfig;
import flipkart.cp.gojira.core.Mode;
import flipkart.cp.gojira.core.ProfileRepository;
import flipkart.cp.gojira.core.injectors.GuiceInjector;
import flipkart.cp.gojira.queuedsender.TestQueuedSenderModule;
import flipkart.cp.gojira.queuedsender.config.TestQueuedSenderConfig;
import flipkart.cp.gojira.requestsampling.RequestSamplingModule;
import flipkart.cp.gojira.requestsampling.config.RequestSamplingConfig;
import flipkart.cp.gojira.serde.SerdeModule;
import flipkart.cp.gojira.serde.config.SerdeConfig;
import flipkart.cp.gojira.sinkstore.config.DataStoreConfig;
import flipkart.cp.gojira.sinkstore.config.DataStoreModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.gojira.com.fasterxml.jackson.databind.ObjectMapper;

public class SetupModule
extends AbstractModule {
    public static final Logger LOGGER = LoggerFactory.getLogger(SetupModule.class);
    private Mode mode;
    private RequestSamplingConfig requestSamplingConfig;
    private SerdeConfig serdeConfig;
    private GojiraComparisonConfig gojiraComparisonConfig;
    private DataStoreConfig dataStoreConfig;
    private TestQueuedSenderConfig testQueuedSenderConfig;

    public SetupModule(Mode mode, RequestSamplingConfig requestSamplingConfig, SerdeConfig serdeConfig, GojiraComparisonConfig gojiraComparisonConfig, DataStoreConfig dataStoreConfig, TestQueuedSenderConfig testQueuedSenderConfig) {
        this.mode = mode;
        this.requestSamplingConfig = requestSamplingConfig;
        this.serdeConfig = serdeConfig;
        this.gojiraComparisonConfig = gojiraComparisonConfig;
        this.dataStoreConfig = dataStoreConfig;
        this.testQueuedSenderConfig = testQueuedSenderConfig;
    }

    @Override
    protected void configure() {
        ProfileRepository.setMode(this.mode);
        Injector injector = Guice.createInjector(new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(ObjectMapper.class).asEagerSingleton();
                this.install(new RequestSamplingModule(SetupModule.this.requestSamplingConfig));
                this.install(new SerdeModule(SetupModule.this.serdeConfig));
                this.install(new GojiraComparisonModule(SetupModule.this.gojiraComparisonConfig));
                this.install(new DataStoreModule(SetupModule.this.dataStoreConfig));
                this.install(new TestQueuedSenderModule(SetupModule.this.testQueuedSenderConfig));
            }
        });
        GuiceInjector.assignInjector(injector);
    }
}

