/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.core;

import flipkart.cp.gojira.core.ProfileRepository;
import flipkart.cp.gojira.core.StartEndTestHandler;
import flipkart.cp.gojira.core.injectors.GuiceInjector;
import flipkart.cp.gojira.models.TestData;
import flipkart.cp.gojira.models.TestDataType;
import flipkart.cp.gojira.models.TestRequestData;
import flipkart.cp.gojira.models.TestResponseData;
import flipkart.cp.gojira.serde.SerdeHandlerRepository;
import flipkart.cp.gojira.sinkstore.handlers.SinkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeStartEndTestHandler<T extends TestDataType>
implements StartEndTestHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializeStartEndTestHandler.class);
    private SinkHandler sinkHandler = GuiceInjector.getInjector().getInstance(SinkHandler.class);
    private SerdeHandlerRepository serdeHandlerRepository = GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class);

    @Override
    public void start(String id, TestRequestData<T> requestData) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("test id is null");
        }
        try {
            TestData testData = this.serdeHandlerRepository.getTestDataSerdeHandler().deserialize(this.sinkHandler.read(id), TestData.class);
            if (testData == null) {
                throw new RuntimeException("no data available against mentioned test id: " + id);
            }
            ProfileRepository.begin(id);
            ProfileRepository.setTestData(testData);
        }
        catch (Exception e) {
            LOGGER.error("unable to fetch data against test id: " + id);
            throw new RuntimeException();
        }
    }

    @Override
    public void end(TestResponseData<T> responseData) {
        ProfileRepository.end();
    }
}

