/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.core;

import flipkart.cp.gojira.core.HttpFilterHandler;
import flipkart.cp.gojira.core.Mode;
import flipkart.cp.gojira.core.NoneHttpFilterHandler;
import flipkart.cp.gojira.core.ProfileHttpFilterHandler;
import flipkart.cp.gojira.core.ProfileRepository;
import flipkart.cp.gojira.core.SerializeHttpFilterHandler;
import flipkart.cp.gojira.core.TestHttpFilterHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpFilter.class);
    private static final Map<Mode, HttpFilterHandler> filterHashMap = Collections.unmodifiableMap(new HashMap<Mode, HttpFilterHandler>(){
        {
            this.put(Mode.NONE, new NoneHttpFilterHandler());
            this.put(Mode.PROFILE, new ProfileHttpFilterHandler());
            this.put(Mode.TEST, new TestHttpFilterHandler());
            this.put(Mode.SERIALIZE, new SerializeHttpFilterHandler());
        }
    });

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CustomHttpServletRequestWrapper requestWrapper = new CustomHttpServletRequestWrapper((HttpServletRequest)request);
        if (filterHashMap.containsKey((Object)ProfileRepository.getMode())) {
            if (filterHashMap.get((Object)ProfileRepository.getMode()).preFilter(requestWrapper)) {
                TestServletResponseWrapper testServletResponseWrapper = new TestServletResponseWrapper((HttpServletResponse)response);
                try {
                    filterHashMap.get((Object)ProfileRepository.getMode()).filter(requestWrapper, testServletResponseWrapper, chain);
                }
                finally {
                    filterHashMap.get((Object)ProfileRepository.getMode()).postFilter(requestWrapper, testServletResponseWrapper, response);
                }
            }
        } else {
            LOGGER.error("Processing logic not implemented for this mode: " + (Object)((Object)ProfileRepository.getMode()));
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
    }

    public class CustomHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final byte[] body;

        public CustomHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
            try {
                this.body = IOUtils.toByteArray(super.getInputStream());
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read the stream", ex);
            }
        }

        @Override
        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
            ServletInputStream inputStream = new ServletInputStream(){

                @Override
                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }

                @Override
                public int available() throws IOException {
                    return byteArrayInputStream.available();
                }

                @Override
                public boolean isFinished() {
                    return true;
                }

                @Override
                public boolean isReady() {
                    return true;
                }

                @Override
                public void setReadListener(ReadListener readListener) {
                }
            };
            return inputStream;
        }
    }

    private class TestBufferedServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream bos = new ByteArrayOutputStream();

        private TestBufferedServletOutputStream() {
        }

        @Override
        public void write(int data) {
            this.bos.write(data);
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public void setWriteListener(WriteListener writeListener) {
        }

        public byte[] getBuffer() {
            return this.bos.toByteArray();
        }
    }

    public class TestServletResponseWrapper
    extends HttpServletResponseWrapper {
        private TestBufferedServletOutputStream bufferedServletOut;
        private ServletOutputStream outputStream;

        public TestServletResponseWrapper(HttpServletResponse servletResponse) {
            super(servletResponse);
            this.bufferedServletOut = new TestBufferedServletOutputStream();
            this.outputStream = null;
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
        }

        @Override
        public void sendError(int sc) throws IOException {
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = this.bufferedServletOut;
            }
            return this.outputStream;
        }

        @Override
        public void flushBuffer() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }

        public byte[] getBuffer() {
            return this.bufferedServletOut.getBuffer();
        }
    }
}

