/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.gojira.core;

import flipkart.cp.gojira.core.Mode;
import flipkart.cp.gojira.core.NoneStartEndTestHandler;
import flipkart.cp.gojira.core.ProfileRepository;
import flipkart.cp.gojira.core.ProfileStartEndTestHandler;
import flipkart.cp.gojira.core.SerializeStartEndTestHandler;
import flipkart.cp.gojira.core.StartEndTestHandler;
import flipkart.cp.gojira.core.TestStartEndTestHandler;
import flipkart.cp.gojira.models.TestDataType;
import flipkart.cp.gojira.models.TestRequestData;
import flipkart.cp.gojira.models.TestResponseData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProfileOrTestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProfileOrTestHandler.class);
    private static final Map<Mode, StartEndTestHandler> startTestHandlerHashMap = Collections.unmodifiableMap(new HashMap<Mode, StartEndTestHandler>(){
        {
            this.put(Mode.PROFILE, new ProfileStartEndTestHandler());
            this.put(Mode.TEST, new TestStartEndTestHandler());
            this.put(Mode.NONE, new NoneStartEndTestHandler());
            this.put(Mode.SERIALIZE, new SerializeStartEndTestHandler());
        }
    });

    public static void start(String id, TestRequestData<? extends TestDataType> requestData) {
        if (startTestHandlerHashMap.containsKey((Object)ProfileRepository.getMode())) {
            startTestHandlerHashMap.get((Object)ProfileRepository.getMode()).start(id, requestData);
            return;
        }
        LOGGER.error("Processing logic not implemented for this mode: " + (Object)((Object)ProfileRepository.getMode()));
    }

    public static void end(TestResponseData<? extends TestDataType> responseData) {
        if (startTestHandlerHashMap.containsKey((Object)ProfileRepository.getMode())) {
            startTestHandlerHashMap.get((Object)ProfileRepository.getMode()).end(responseData);
            return;
        }
        LOGGER.error("Processing logic not implemented for this mode: " + (Object)((Object)ProfileRepository.getMode()));
    }
}

