(defproject flipboard/clj-services "1.0.0"
  :description "Flipboard Clojure Services Library"
  :url "http://github.com/Flipboard"
  :license {:name "Confidential and Proprietary"
            :url "https://flipboard.com/license.html"}
  :dependencies [[amazonica "0.3.12" :exclusions [joda-time]]
                 [cheshire "5.4.0"]
                 [circleci/clj-yaml "0.5.3"]
                 [clj-time "0.9.0"]
                 [clj-http "1.0.1"]
                 [clojurewerkz/propertied "1.2.0"]
                 [clojurewerkz/spyglass "1.1.0"]
                 [com.google.guava/guava "16.0"]
                 [com.stuartsierra/component "0.2.2"]
                 [compojure "1.3.1"]
                 [http-kit "2.1.19"]
                 [javax.servlet/servlet-api "2.5"]
                 [metrics-clojure "2.4.0"]
                 [metrics-clojure-graphite "2.4.0"]
                 [metrics-clojure-ring "2.4.0"]
                 [org.apache.kafka/kafka_2.10 "0.8.1.1"]
                 [org.apache.zookeeper/zookeeper "3.4.6"]
                 [org.clojure/clojure "1.6.0"]
                 [org.clojure/core.async "0.1.346.0-17112a-alpha"]
                 [org.clojure/java.jdbc "0.3.6"]
                 [org.clojure/test.check "0.6.2"]
                 [org.clojure/tools.logging "0.3.1"]
                 [org.slf4j/slf4j-log4j12 "1.7.10"]
                 [prismatic/schema "0.3.3"]
                 [ring/ring-core "1.3.2"]
                 [ring/ring-json "0.3.1"]
                 ;[watchtower "0.1.1"]
                 [c3p0/c3p0 "0.9.1.2"]
                 [org.clojure/core.cache "0.6.4"]
                 [de.ubercode.clostache/clostache "1.4.0"]
                 [org.clojure/tools.nrepl "0.2.8"]
                 [org.apache.hbase/hbase-client "1.0.0"]
                 [org.clojars.hzhao/clojure-hbase "1.0.0-pre"]]
  :exclusions    [javax.jms/jms
                  com.sun.jdmk/jmxtools
                  com.sun.jmx/jmxri]
  :repositories {"local" "file:maven_repo"}
  :profiles {:dev {:dependencies [[org.clojure/tools.namespace "0.2.8"]
                                  [midje "1.6.3"]
                                  [reloaded.repl "0.1.0"]]
                   :repl-options {:init-ns user}
                   :source-paths ["dev"]}}
  :plugins [[codox "0.8.10"]]
  :codox {:defaults {:doc "core library and common components"}
          :doc/format :markdown
          :src-dir-uri "http://github.com/Flipboard/clj-services/blob/master/lib/"
          :src-linenum-anchor-prefix "L"})
