;; -*- coding: utf-8 -*-
;; (c)2014 Flipboard Inc, All Rights Reserved.
;; Author: Howard Zhao
;; created: 3/17/15
;; flipboard.component.nrepl
;; 
;; Purpose: enable nrepl service for remote debugging
;;

(ns flipboard.component.nrepl
  (:require [com.stuartsierra.component :as component]
            [clojure.tools.nrepl.server :as rs]
            [clojure.tools.logging :as log]))

(defrecord nreplComponent [core port]
  component/Lifecycle

  (start [this]
    (log/info "starting nrepl on port " port)
    (assoc this :nrepl (rs/start-server :port port)))

  (stop [this]
    (log/info "stopping nrepl.")
    (rs/stop-server (:nrepl this))
    (assoc this :nrepl nil)))

(defn new-nrepl
  "create a nrepl component"
  [port]
  (map->nreplComponent {:port port}))