;; -*- coding: utf-8 -*-
;;
;; (c)2014 Flipboard Inc, All Rights Reserved.
;; Author: David Creemer
;;
;; flipboard.component.kafka

(ns flipboard.component.kafka
  (:require [clojure.string :as str]
            [schema.core :as s]
            [com.stuartsierra.component :as component]
            [flipboard.base.kafka :as k]))

(defn- calc-zk-connect
  "read the zookeeper configuration for the given cluster from the config, and return a zc.connect string"
  [cfg cluster]
  (let [pfx     (str "kafka." cluster)
        zkpeers (get cfg (str pfx ".zk.peers"))
        zkroot  (get cfg (str pfx ".zk.root") "/")]
  (->> (str/split zkpeers #",")
       (map #(str % zkroot))
       (rand-nth))))

;; a kafka consumer

(defrecord KafkaConsumer [cluster group consumer core]
  component/Lifecycle

  (start [component]
    (let [cfg (:config core)
          zkc (calc-zk-connect cfg cluster)
          c   (k/consumer {"zookeeper.connect" zkc, "group.id" group})]
      (assoc component :consumer c)))

  (stop [component]
    (when-let [c (:consumer component)]
      (k/shutdown c))
    (assoc component :consumer nil)))

(def kafka-connection-schema
  {:cluster s/Str
   :group s/Str})

(defn new-consumer
  [& {:as opts}]
  (->> opts
       (merge {:cluster "unknown" ;; TBD: dev cluster
               :group (format "cl-group-%d" (rand-int 1000000))})
       (s/validate kafka-connection-schema)
       (map->KafkaConsumer)))

;; producer TBD
