(ns leiningen.new.flibbertigibbet-test
  (:require [clojure.test :refer :all]
            [leiningen.new.flibbertigibbet :refer :all]))

(defn safe-delete [file-path]
  (if (.exists (clojure.java.io/file file-path))
    (try
      (clojure.java.io/delete-file file-path)
      (catch Exception e (str "exception: " (.getMessage e))))
    false))

(defn delete-directory [directory]
  (let [contents (file-seq (clojure.java.io/file directory))
        delete-files (filter #(.isFile %) contents)]
    (doseq [file delete-files]
      (safe-delete (.getPath file)))
    (safe-delete directory)))

(deftest a-test
  (testing "flibbertigibbet should advertise itself, so i know it works"
    (is (= "Generating fresh 'lein new' flibbertigibbet project: projecta\n"
           (with-out-str (flibbertigibbet "projecta"))))
    (delete-directory "./projecta")))
