(ns hoshi.core
  (:require [clojure.string :as cstring]))

(def b64-tbl (->> [(map char (range 65 91)) (map char (range 97 123)) (map char (range 48 58)) (list \+ \/)]
                  (map vec)
                  (reduce into)
                  (map-indexed hash-map)
                  (reduce into)))

(def b64-tbl-rev (->> (map reverse b64-tbl)
                      (map #(apply hash-map %))
                      (reduce into)))

(defn bin-rep [c]
  (->> (int c)
       (Integer/toBinaryString)
       (Integer/parseInt)
       (format "%08d")))

(defn pad [s]
  (cond (= 0 (rem (count s) 3)) s
        :else (let [l (- 3 (rem (count s) 3))]
                (->> (char 0)
                     (repeat l)
                     (apply str)
                     (str s)))))

(defn b64-encode [s]
  (-> (->> (pad s)
           (map bin-rep)
           (apply str)
           (partition 6)
           (map #(apply str %))
           (map #(Integer/parseInt % 2))
           (map b64-tbl)
           (apply str))
      (cstring/replace #"AA$" "==")
      (cstring/replace #"A$" "=")))

(defn b64-decode [s]
  (->> (clojure.string/replace s #"=" "")
       (map b64-tbl-rev s)
       (map char)
       (map bin-rep)
       (map #(drop 2 %))
       (map vec)
       (reduce into)
       (partition 8)
       (map #(apply str %))
       (map #(Integer/parseInt % 2))))
