(ns leiningen.new.fig-quil
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "fig-quil"))

(defn fig-quil
  "Create a new quil-cljs sketch with automatic figwheel integration"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' fig-quil project.")
    (->files data
               ["README.md" (render "README.md" data)]
               ["project.clj" (render "project.clj" data)]
               ["dev/user.clj" (render "user.clj" data)]
               ["script/repl.clj" (render "repl.clj" data)]
               ["src/{{sanitized}}/core.cljs" (render "core.cljs" data)]
               ["resources/public/index.html" (render "index.html" data)]
               ["resources/public/css/style.css" (render "style.css" data)]
               [".gitignore" (render "gitignore" data)])))
