(ns leiningen.new.fiftycuatro-reagent
  (:use 
    [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]
    [clojure.java.shell :only [sh]])
  (:require
    [clojure.java.io :as io]
    [clojure.string :as str]))

(def render (renderer "fiftycuatro_reagent"))

(defn binary
  [file]
  (io/input-stream (io/resource (clojure.string/join "/" ["leiningen" "new" "fiftycuatro_reagent" file]))))

(defn fiftycuatro-reagent 
  [name]
  (let [short-name (-> (str/split name #"\.") reverse first) 
        data {:name short-name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data 
             ["src/clj/{{sanitized}}/main.clj"                 (render "src/clj/main.clj" data)]
             ["src/clj/{{sanitized}}/core.clj"                 (render "src/clj/core.clj" data)]
             ["src/cljs/{{sanitized}}/core.cljs"               (render "src/cljs/core.cljs" data)]
             ["dev/clj/user.clj"                               (render "dev/clj/user.clj" data)]
             ["test/clj/{{sanitized}}/core_test.clj"           (render "test/clj/core_test.clj" data)]
             ["project.clj"                                    (render "project.clj" data)]
             ["resources/public/js/fontawesome-all.js"         (binary "resources/public/js/fontawesome-all.js")]
             ["resources/public/font/lato/lato_font.css"       (binary "resources/public/font/lato/lato_font.css")]
             ["resources/public/css/bulma.css"                 (binary "resources/public/css/bulma.css")]
             ["resources/public/css/style.css"                 (binary "resources/public/css/style.css")]
             ["resources/public/index.html"                    (render "resources/public/index.html" data)]
             ["resources/public/font/lato/latin_300.woff2"     (binary "resources/public/font/lato/latin_300.woff2")]
             ["resources/public/font/lato/latin_ext_300.woff2" (binary "resources/public/font/lato/latin_ext_300.woff2")]
             ["resources/public/font/lato/latin_400.woff2"     (binary "resources/public/font/lato/latin_400.woff2")]
             ["resources/public/font/lato/latin_ext_400.woff2" (binary "resources/public/font/lato/latin_ext_400.woff2")]
             ["resources/public/font/lato/latin_900.woff2"     (binary "resources/public/font/lato/latin_900.woff2")]
             ["resources/logback.xml"                          (binary "resources/logback.xml")]
             ["resources/public/font/lato/latin_ext_900.woff2" (binary "resources/public/font/lato/latin_ext_900.woff2")]
             [".gitignore"                                     (binary ".gitignore")]
             ["CHANGELOG.md"                                   (binary "CHANGELOG.md")]
             ["LICENSE"                                        (binary "LICENSE")]
             ["README.md"                                      (render "README.md" data)]
             ["open-in-intellij.sh"                            (binary "open-in-intellij.sh")])
    (sh "chmod" "+x" (str short-name "/open-in-intellij.sh"))))
