(ns leiningen.new.fiftycuatro-reagent
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "fiftycuatro_reagent"))

(defn fiftycuatro-reagent 
  [name]
  (let [data {:name (-> (clojure.string/split name #"\.") reverse first)
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data 
             ["src/clj/{{sanitized}}/main.clj" (render "src/clj/main.clj" data)]
             ["src/clj/{{sanitized}}/core.clj" (render "src/clj/core.clj" data)]
             ["src/cljs/{{sanitized}}/core.cljs" (render "src/cljs/core.cljs" data)]
             ["test/clj/{{sanitized}}/core_test.clj" (render "test/clj/core_test.clj" data)]
             ["project.clj" (render "project.clj" data)]
             ["resources/public/js/fontawesome-all.js" (render "resources/public/js/fontawesome-all.js")]
             ["resources/public/font/lato/lato_font.css" (render "resources/public/font/lato/lato_font.css")]
             ["resources/public/css/bulma.css" (render "resources/public/css/bulma.css")]
             ["resources/public/css/style.css" (render "resources/public/css/style.css")]
             ["resources/public/index.html" (render "resources/public/index.html" data)]
             ["resources/public/font/lato/latin_300.woff2" (render "resources/public/font/lato/latin_300.woff2")]
             ["resources/public/font/lato/latin_ext_300.woff2" (render "resources/public/font/lato/latin_ext_300.woff2")]
             ["resources/public/font/lato/latin_400.woff2" (render "resources/public/font/lato/latin_400.woff2")]
             ["resources/public/font/lato/latin_ext_400.woff2" (render "resources/public/font/lato/latin_ext_400.woff2")]
             ["resources/public/font/lato/latin_900.woff2" (render "resources/public/font/lato/latin_900.woff2")]
             ["resources/logback.xml" (render "resources/logback.xml")]
             ["resources/public/font/lato/latin_ext_900.woff2" (render "resources/public/font/lato/latin_ext_900.woff2")]
             [".gitignore" (render ".gitignore")]
             ["CHANGELOG.md" (render "CHANGELOG.md")]
             ["LICENSE" (render "LICENSE")]
             ["README.md" (render "README.md" data)]
             )))
