# git-revisions for tools.build

[![Deploy to Clojars](https://github.com/esuomi/git-revisions-buildtools/actions/workflows/deploy.yaml/badge.svg)](https://github.com/esuomi/git-revisions-buildtools/actions/workflows/deploy.yaml)
[![Clojars Project](https://img.shields.io/clojars/v/fi.polycode/buildtools-git-revisions.svg)](https://clojars.org/fi.polycode/buildtools-git-revisions)
[![cljdoc badge](https://cljdoc.org/badge/fi.polycode/buildtools-git-revisions)](https://cljdoc.org/jump/release/fi.polycode/buildtools-git-revisions)

Automatically control [tools.build](https://github.com/clojure/tools.build) based project version based on Git and system metadata.

## Usage

 1. **Add suitable base tag to repository**
    ```shell
    git tag -a v0.0.0 -m "initial version"
    ```
 2. **Add library dependency to `deps.edn`**
    ```clojure
    {:deps {...}
     :aliases {:build {:extra-deps {io.github.clojure/tools.build {:git/tag "v0.8.2" :git/sha "ba1a2bf"}
                                    fi.polycode/git-revisions-buildtools {:mvn/version "0.1.0-SNAPSHOT"}}
                       :ns-default build}}}
    ```
 3. **Use the library in your build script**
    ```clojure
    (ns build
      (:require [git-revisions.buildtools :as rev]
                ...))

    (def next-version (rev/generate-revision {:configuration
                                              {:format :semver
                                               :adjust [:env/revision_adjustment :minor]
                                               :revision-file "resources/metadata.edn"}}))

    ; next-version now contains the next revision of the project as per configuration
    ```

Further configuration options are described in depth at [git-revisions core library's README](https://github.com/esuomi/git-revisions#configuration).

## License

Copyright © 2022 Esko Suomi

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.

