
namespace ferret{
  namespace runtime{
    var first(ref coll){
      if (coll.is_nil() || coll.is_type(type_id<empty_sequence>))
        return nil();
      else
        return coll.cast<seekable_i>()->first();
    }
  
    var rest(ref coll){
      if (coll.is_nil())
        return runtime::list();
      if (coll.is_type(type_id<empty_sequence>))
        return nil();
      return coll.cast<seekable_i>()->rest();
    }
  
    var cons(ref x, ref coll){
      if (coll.is_nil() || coll == runtime::list())
        return runtime::list(x);
  
      return coll.cast<seekable_i>()->cons(x);
    }
  
    var nth(ref seq, number_t n_index){
      number_t index = 0;
      
      for_each(i, seq){
       if (n_index == index)
         return i;
       index++;
      }
  
      return nil();
    }
  
    var nthrest(ref seq, number_t index){
      var ret = seq;
      for(number_t i = 0; i < index; i++)
        ret = runtime::rest(ret);
  
      if (ret.is_nil())
        return runtime::list(); 
  
      return ret;
    }
    
    size_t count(ref seq){
      size_t acc = 0;
  
      for_each(v, seq){
        (void)v;
        acc++;
      }
      return acc;
    }
  
    bool is_seqable(ref seq){
      if(seq.cast<seekable_i>())
        return true;
      else
        return false;
    }
  }
  template<typename T, typename... Args>
  inline var run(T const & fn, Args const & ... args) {
    return fn.invoke(runtime::list(args...));
  }
  
  template<typename T>
  inline var run(T const & fn) {
    return fn.invoke(nil());
  }
  
  template<>
  inline var run(ref fn) {
    return fn.cast<lambda_i>()->invoke(nil());
  }
  
  template<typename... Args>
  inline var run(ref fn, Args const & ... args) {
    return fn.cast<lambda_i>()->invoke(runtime::list(args...));
  }
}
