
template <typename T>
class moving_average_filter : public lambda_i {
  T alpha;
  mutable T avrg;
  mutex lock;

  var step(T data) {
    lock_guard guard(lock);
    avrg = ((alpha * data) + ((1. - alpha) * avrg));
    return obj<number>(avrg);
  }
  
public:

  explicit moving_average_filter(ref a) : alpha(number::to<T>(a)), avrg(0) { }

  type_t type() const { return type_id<moving_average_filter>; }

#if !defined(FERRET_DISABLE_STD_OUT)
  void stream_console() const {
    runtime::print("moving_average_filter<");
    runtime::print(alpha);
    runtime::print(",");
    runtime::print(avrg);
    runtime::print(">");
  }
#endif

  var invoke(ref args) const {
    return var((object*)this).cast<moving_average_filter<T>>()
      ->step(number::to<T>(runtime::first(args)));
  }
};
