
class keyword final : public lambda_i {
  const number_t _word;

  number_t from_str(const char * str){
    number_t word = 0;
    for (number_t i = 0; str[i] != '\0'; i++){
      word = word + (number_t)str[i];
    }
    
    return word;
  }
  
public:

  type_t type() const final { return type_id<keyword>; }

  bool equals(ref o) const final {
    return (_word == o.cast<keyword>()->word());
  }

#if !defined(FERRET_DISABLE_STD_OUT)
  void stream_console() const final {
    runtime::print("keyword<");
    runtime::print(_word);
    runtime::print(">");
  }
#endif

  explicit keyword(number_t w) : _word(w) {} 
  explicit keyword(const char * str): _word(from_str(str)) { }

  number_t word() const {
    return _word;
  }

  var invoke(ref args) const {
    ref map = runtime::first(args);
    ref map_args = runtime::cons(var((object*)this), runtime::rest(args));

    if (map.is_type(type_id<d_list>)){
      return map.cast<map_t>()->val_at(map_args);
    }

    return nil();
  }
};
