
class d_list final : public lambda_i, public seekable_i {

  var data;

  var dissoc_aux(ref k) const {
    ref keys = runtime::first(data);
    var values = runtime::rest(data);

    var new_keys;
    var new_values;
    
    for_each(i, keys){
      if ( i == k)
        continue;
      new_keys = runtime::cons(i, new_keys);
      new_values = runtime::cons(runtime::first(values), new_values);
      values = runtime::rest(values);
    }
      
    return runtime::cons(new_keys,new_values);
  }
  
 public:

  type_t type() const final { return type_id<d_list>; }

  bool equals(ref o) const final {
    return seekable_i::equals(var((object*)this), o);
  }

#if !defined(FERRET_DISABLE_STD_OUT)
  void stream_console() const final {
    data.stream_console();
  }
#endif

  explicit d_list() : data(runtime::list(runtime::list())) { }
  explicit d_list(ref l) : data(l) { }
  
  var assoc(ref k, ref v) const {
    ref map = dissoc_aux(k);
    ref keys = runtime::first(map);
    ref values = runtime::rest(map);

    return obj<d_list>(runtime::cons(runtime::cons(k,keys),
                                     runtime::cons(v,values)));
  }

  var dissoc(ref k) const {
    return obj<d_list>(dissoc_aux(k));
  }
  
  var val_at(ref args) const {
    ref key = runtime::first(args);
    ref not_found = runtime::first(runtime::rest(args));

    ref keys = runtime::first(data);
    var values = runtime::rest(data);

    for_each(i, keys){
      if (key == i)
        return runtime::first(values);

      values = runtime::rest(values);
    }
    
    if (!not_found.is_nil()){
      return not_found;
    }else{
      return nil();  
    }
  }

  var invoke(ref args) const final {
    return val_at(args);
  }

  var vals () const { return runtime::rest(data);}
  var keys () const { return runtime::first(data);}

  virtual seekable_i* cast_seekable_i() { return this; }
  
  var cons(ref v) final {
    return runtime::list(v,data);
  }
  
  var first() final {
    ref keys = runtime::first(data);
    ref values = runtime::rest(data);
    return runtime::list(runtime::first(keys),runtime::first(values));
  }
  
  var rest() final {
    ref keys = runtime::first(data);
    ref values = runtime::rest(data);

    if(runtime::rest(keys) == runtime::list())
      return runtime::list();
    
    return obj<d_list>(runtime::cons(runtime::rest(keys),runtime::rest(values)));
  }
};

template<>
inline var obj<d_list>(var keys, var vals) {
  void * storage = FERRET_ALLOCATOR::allocate<d_list>();
  return var(new(storage) d_list(runtime::cons(keys,vals)));
}

#if !defined(FERRET_MAP_TYPE)
typedef d_list map_t;
#endif
