
(defproject ferret "0.3.0-4eb0a19"
  :description "Ferret is a lisp implementation designed to be used in real time embedded control systems."
  :url "https://ferret-lang.org/"
  :license {:name "BSD 2-Clause"
            :url "https://github.com/nakkaya/ferret/blob/master/LICENSE"}
  
  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/tools.cli "0.3.7"]
                 [org.clojure/tools.logging "0.4.1"]
                 [org.slf4j/slf4j-simple "1.7.25"]
                 [fast-zip "0.7.0"]
                 [clj-jgit "0.8.10"]
                 [org.bituf/clj-stringtemplate "0.2"]
                 [org.clojars.amit/commons-io "1.4.0"]
                 [commons-lang "2.5"]
                 [org.flatland/ordered "1.5.6"]
                 [watchtower "0.1.1"]]

  :deploy-repositories [["releases"  {:sign-releases false :url "https://clojars.org/repo"
                                      :username :env
                                      :password :env}]]

  :repl-options {:host "0.0.0.0"
                 :port 7888
                 :init-ns ferret.core}

  :test-paths ["test/compiler/"]
  :filespecs [{:type :bytes :path "build.info"
               :bytes ~(.getBytes "0.3.0-4eb0a19")}]
  
  :main ferret.core
  :aot [ferret.core]
  :jar-name "interim.jar"
  :uberjar-name "ferret.jar")
