/*
 * Decompiled with CFR 0.152.
 */
package feign.ranger.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.ServiceFinderBuilders;
import com.flipkart.ranger.finder.sharded.SimpleShardedServiceFinder;
import com.flipkart.ranger.model.ServiceNode;
import feign.ranger.common.ShardInfo;
import java.util.List;
import java.util.Optional;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryClient.class);
    private final ShardInfo criteria;
    private SimpleShardedServiceFinder<ShardInfo> serviceFinder;

    ServiceDiscoveryClient(String namespace, String serviceName, String environment, ObjectMapper objectMapper, CuratorFramework curator) throws Exception {
        this.criteria = ShardInfo.builder().environment(environment).build();
        this.serviceFinder = (SimpleShardedServiceFinder)ServiceFinderBuilders.shardedFinderBuilder().withCuratorFramework(curator).withNamespace(namespace).withServiceName(serviceName).withDisableWatchers(true).withNodeRefreshIntervalMs(5000).withDeserializer(data -> {
            try {
                return (ServiceNode)objectMapper.readValue(data, (TypeReference)new TypeReference<ServiceNode<ShardInfo>>(){});
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }).build();
    }

    public void start() throws Exception {
        this.serviceFinder.start();
    }

    public void stop() throws Exception {
        this.serviceFinder.stop();
    }

    public Optional<ServiceNode<ShardInfo>> getNode() {
        return Optional.ofNullable(this.serviceFinder.get((Object)this.criteria));
    }

    public List<ServiceNode<ShardInfo>> getAllNodes() {
        return this.serviceFinder.getAll((Object)this.criteria);
    }

    public static ServiceDiscoveryClientBuilder builder() {
        return new ServiceDiscoveryClientBuilder();
    }

    public static class ServiceDiscoveryClientBuilder {
        private String namespace;
        private String serviceName;
        private String environment;
        private ObjectMapper objectMapper;
        private CuratorFramework curator;

        ServiceDiscoveryClientBuilder() {
        }

        public ServiceDiscoveryClientBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ServiceDiscoveryClientBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ServiceDiscoveryClientBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public ServiceDiscoveryClientBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public ServiceDiscoveryClientBuilder curator(CuratorFramework curator) {
            this.curator = curator;
            return this;
        }

        public ServiceDiscoveryClient build() throws Exception {
            return new ServiceDiscoveryClient(this.namespace, this.serviceName, this.environment, this.objectMapper, this.curator);
        }

        public String toString() {
            return "ServiceDiscoveryClient.ServiceDiscoveryClientBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", environment=" + this.environment + ", objectMapper=" + this.objectMapper + ", curator=" + this.curator + ")";
        }
    }
}

