/*
 * Decompiled with CFR 0.152.
 */
package feign.ranger;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.model.ServiceNode;
import com.google.common.base.Strings;
import feign.Request;
import feign.RequestTemplate;
import feign.Target;
import feign.ranger.client.ServiceDiscoveryClient;
import feign.ranger.common.ShardInfo;
import java.util.Optional;
import lombok.NonNull;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerTarget<T>
implements Target<T> {
    private static final Logger log = LoggerFactory.getLogger(RangerTarget.class);
    @NonNull
    private final Class<T> type;
    private final String service;
    private final CuratorFramework curator;
    private ServiceDiscoveryClient client;
    private final String httpScheme;
    private final String fallbackUrl;
    private final String rootPathPrefix;

    public RangerTarget(Class<T> type, String environment, String namespace, String service, CuratorFramework curator, boolean secured, ObjectMapper objectMapper) throws Exception {
        this(type, environment, namespace, service, curator, secured, null, objectMapper, null);
    }

    public RangerTarget(Class<T> type, String environment, String namespace, String service, CuratorFramework curator, boolean secured, String fallbackAddress, ObjectMapper objectMapper) throws Exception {
        this(type, environment, namespace, service, curator, secured, fallbackAddress, objectMapper, null);
    }

    private RangerTarget(Class<T> type, String environment, String namespace, String service, CuratorFramework curator, boolean secured, String fallbackAddress, ObjectMapper objectMapper, String rootPathPrefix) throws Exception {
        this.type = type;
        this.httpScheme = secured ? "https" : "http";
        this.rootPathPrefix = Strings.isNullOrEmpty((String)rootPathPrefix) ? "" : "/" + rootPathPrefix;
        this.fallbackUrl = Strings.isNullOrEmpty((String)fallbackAddress) ? "" : String.format("%s://%s%s", this.httpScheme, fallbackAddress, this.rootPathPrefix);
        this.service = service;
        this.curator = curator;
        this.client = ServiceDiscoveryClient.builder().curator(curator).environment(environment).namespace(namespace).serviceName(service).objectMapper(objectMapper).build();
        this.start();
    }

    public Class<T> type() {
        return this.type;
    }

    public String name() {
        return this.service;
    }

    private String rangerUrl(ServiceNode<ShardInfo> node) {
        return String.format("%s://%s:%d%s", this.httpScheme, node.getHost(), node.getPort(), this.rootPathPrefix);
    }

    public String url() {
        Optional<ServiceNode<ShardInfo>> node = this.client.getNode();
        if (node.isPresent()) {
            return this.rangerUrl(node.get());
        }
        if (Strings.isNullOrEmpty((String)this.fallbackUrl)) {
            throw new IllegalArgumentException("No service nodes found");
        }
        return this.fallbackUrl;
    }

    private void start() throws Exception {
        log.info("Starting service discovery client for {} on {}", (Object)this.service, (Object)this.curator.getZookeeperClient().getCurrentConnectionString());
        this.client.start();
        log.info("Started service discovery client for {} on {}", (Object)this.service, (Object)this.curator.getZookeeperClient().getCurrentConnectionString());
    }

    public Request apply(RequestTemplate input) {
        Optional<ServiceNode<ShardInfo>> node = this.client.getNode();
        if (node == null || !node.isPresent()) {
            throw new IllegalArgumentException("No service nodes found");
        }
        String url = this.rangerUrl(node.get());
        input.insert(0, (CharSequence)url);
        return input.request();
    }

    public static <T> RangerTargetBuilder<T> builder() {
        return new RangerTargetBuilder();
    }

    public String getService() {
        return this.service;
    }

    public static class RangerTargetBuilder<T> {
        private Class<T> type;
        private String environment;
        private String namespace;
        private String service;
        private CuratorFramework curator;
        private boolean secured;
        private String fallbackAddress;
        private ObjectMapper objectMapper;
        private String rootPathPrefix;

        RangerTargetBuilder() {
        }

        public RangerTargetBuilder<T> type(Class<T> type) {
            this.type = type;
            return this;
        }

        public RangerTargetBuilder<T> environment(String environment) {
            this.environment = environment;
            return this;
        }

        public RangerTargetBuilder<T> namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RangerTargetBuilder<T> service(String service) {
            this.service = service;
            return this;
        }

        public RangerTargetBuilder<T> curator(CuratorFramework curator) {
            this.curator = curator;
            return this;
        }

        public RangerTargetBuilder<T> secured(boolean secured) {
            this.secured = secured;
            return this;
        }

        public RangerTargetBuilder<T> fallbackAddress(String fallbackAddress) {
            this.fallbackAddress = fallbackAddress;
            return this;
        }

        public RangerTargetBuilder<T> objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public RangerTargetBuilder<T> rootPathPrefix(String rootPathPrefix) {
            this.rootPathPrefix = rootPathPrefix;
            return this;
        }

        public RangerTarget<T> build() throws Exception {
            return new RangerTarget<T>(this.type, this.environment, this.namespace, this.service, this.curator, this.secured, this.fallbackAddress, this.objectMapper, this.rootPathPrefix);
        }

        public String toString() {
            return "RangerTarget.RangerTargetBuilder(type=" + this.type + ", environment=" + this.environment + ", namespace=" + this.namespace + ", service=" + this.service + ", curator=" + this.curator + ", secured=" + this.secured + ", fallbackAddress=" + this.fallbackAddress + ", objectMapper=" + this.objectMapper + ", rootPathPrefix=" + this.rootPathPrefix + ")";
        }
    }
}

