/*
 * Decompiled with CFR 0.152.
 */
package feign.ranger;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.model.ServiceNode;
import feign.Request;
import feign.RequestTemplate;
import feign.Target;
import feign.ranger.client.ServiceDiscoveryClient;
import feign.ranger.common.ShardInfo;
import java.util.Optional;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerTarget<T>
implements Target<T> {
    private static final Logger log = LoggerFactory.getLogger(RangerTarget.class);
    private final Class<T> type;
    private final String name;
    private final String service;
    private ServiceDiscoveryClient client;
    private final boolean secured;

    public RangerTarget(Class<T> type, String name, String environment, String namespace, String service, CuratorFramework curator, boolean secured, ObjectMapper objectMapper) throws Exception {
        this.type = type;
        this.name = name;
        this.secured = secured;
        this.service = service;
        this.client = ServiceDiscoveryClient.builder().curator(curator).environment(environment).namespace(namespace).serviceName(service).objectMapper(objectMapper).build();
        log.debug("Starting service discovery client for {} on {}", (Object)service, (Object)curator.getZookeeperClient().getCurrentConnectionString());
        this.client.start();
        log.debug("Started service discovery client for {} on {}", (Object)service, (Object)curator.getZookeeperClient().getCurrentConnectionString());
    }

    public Class<T> type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        Optional<ServiceNode<ShardInfo>> node = this.client.getNode();
        if (!node.isPresent()) {
            throw new IllegalArgumentException("No service nodes found");
        }
        return String.format("%s://%s:%d", this.secured ? "https" : "http", node.get().getHost(), node.get().getPort());
    }

    public Request apply(RequestTemplate input) {
        Optional<ServiceNode<ShardInfo>> node = this.client.getNode();
        if (!node.isPresent()) {
            throw new IllegalArgumentException("No service nodes found");
        }
        String url = String.format("%s://%s:%d", this.secured ? "https" : "http", node.get().getHost(), node.get().getPort());
        input.insert(0, (CharSequence)url);
        return input.request();
    }

    public String getService() {
        return this.service;
    }
}

