(ns leiningen.new.favfeed-template
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "favfeed-template"))

(defn favfeed-template
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' favfeed-template project.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["profiles.clj.example" (render "profiles.clj.example" data)]
             [".gitignore" (render "gitignore" data)]
             ["Dockerfile" (render "Dockerfile" data)]
             ["resources/log4j.properties" (render "log4j.properties" data)]
             ["scripts/{{name}}/log4j.properties" (render "log4j.properties.production" data)]
             ["dev/dev.clj" (render "dev.clj" data)]
             ["dev/user.clj" (render "user.clj" data)]
             ["src/{{sanitized}}/api.clj" (render "api.clj" data)]
             ["src/{{sanitized}}/main.clj" (render "main.clj" data)]
             ["src/{{sanitized}}/hx_stream.clj" (render "hx_stream.clj" data)]
             ["src/{{sanitized}}/system.clj" (render "system.clj" data)]
             ["test/{{sanitized}}/test_helper.clj" (render "test_helper.clj" data)])))
